                  ; 1996 by Matthias Withopf / c't

                  .MODEL LARGE,PASCAL
                  .286p
                  ;LOCALS
                  ;JUMPS

DOS               EQU     21H
DPMI              EQU     31H

                  .CODE

                  PUBLIC  LFN_INIT
LFN_INIT          PROC
                  ; teste, ob Betriebssystem lange Dateinamen untersttzt
                  SUB     SP,256
                  MOV     AX,7147H          ; get current directory
                  XOR     DL,DL
                  MOV     SI,SP
                  STC
                  INT     DOS
                  JNC     SHORT @@Ok
                  ADD     SP,256
                  JMP     SHORT @@Exit      ; keine LFN-Untersttzung

@@Ok:             ADD     SP,256

                  ; Lese alten INT21-Vektor
                  MOV     AX,0204H
                  MOV     BL,DOS
                  INT     DPMI
                  JC      SHORT @@Exit
                  MOV     WORD PTR OldINT21+0,DX
                  MOV     WORD PTR OldINT21+2,CX

                  ; Setze neuen INT21-Vektor
                  INC     AX
                  MOV     DX,OFFSET MyINT21Handler
                  MOV     CX,SEG    MyINT21Handler
                  INT     DPMI
                  JC      SHORT @@Exit
                  MOV     AX,1
                  RET
@@Exit:           XOR     AX,AX
                  RET
LFN_INIT          ENDP

                  PUBLIC  LFN_DONE
LFN_DONE          PROC
                  ; Setze alten INT21-Vektor zurck
                  MOV     AX,0205H
                  MOV     BL,DOS
                  MOV     DX,WORD PTR OldINT21+0
                  MOV     CX,WORD PTR OldINT21+2
                  JCXZ    SHORT @@1
                  INT     DPMI
                  JC      SHORT @@Exit
@@1:              MOV     WORD PTR OldINT21+0,0
                  MOV     WORD PTR OldINT21+2,0
                  MOV     AX,1
                  RET
@@Exit:           XOR     AX,AX
                  RET
LFN_DONE          ENDP

                  ; Neuer INT 21-Handler. Fngt dateibezogene DOS-Funktionen ab,
                  ; und fhrt, wenn mglich, die entsprechende Funktion fr
                  ; lange Dateinamen aus.

                  ; $39   - create directory          - ok
                  ; $3A   - remove directory          - ok
                  ; $3B   - set current directory     - ok
                  ; $3C   - create file               - ok
                  ; $3D   - open file                 - ok
                  ; $41   - delete file               - ok
                  ; $4300 - get file attributes       - ok
                  ; $4301 - set file attributes       - ok
                  ; $47   - get current directory     - ok
                  ; $4B   - load & execute program    - keine LFN-Untersttzung vorhanden!
                  ; $4E   - find first matching file  - Emulation nicht mglich!
                  ; $4F   - find next matching file   - Emulation nicht mglich!
                  ; $56   - rename file               - ok
                  ; $5A   - create temporary file     - nicht emuliert
                  ; $5B   - create new file           - ok
                  ; $6C   - open/create file          - ok

MyINT21Handler    PROC
                  PUSHF

                  ; lese Adresse der originalen INT 21-Routine
                  SUB     SP,4
                  PUSH    AX
                  PUSH    BX
                  PUSH    DS
                  MOV     BX,SP
                  MOV     AX,SEG _DATA
                  MOV     DS,AX
                  MOV     AX,WORD PTR OldINT21+0
                  MOV     SS:[BX+6],AX
                  MOV     AX,WORD PTR OldINT21+2
                  MOV     SS:[BX+8],AX
                  POP     DS
                  POP     BX
                  POP     AX

                  CMP     AH,39H          ; ist es 'create directory' ?
                  JZ      SHORT @@2
                  CMP     AH,3AH          ; ist es 'remove directory' ?
                  JZ      SHORT @@2
                  CMP     AH,3BH          ; ist es 'set current directory' ?
                  JZ      SHORT @@2
                  CMP     AH,3CH          ; ist es 'create file' ?
                  JZ      SHORT @@CreateFile
                  CMP     AH,3DH          ; ist es 'open file' ?
                  JZ      SHORT @@OpenFile
                  CMP     AH,41H          ; ist es 'delete file' ?
                  JZ      SHORT @@DeleteFile
                  CMP     AX,4300H        ; ist es 'get file attributes' ?
                  JZ      @@GetSetAttr
                  CMP     AX,4301H        ; ist es 'set file attributes' ?
                  JZ      @@GetSetAttr
                  CMP     AH,47H          ; ist es 'get current directory' ?
                  JZ      SHORT @@2
                  CMP     AH,56H          ; ist es 'rename file' ?
                  JZ      SHORT @@2
                  CMP     AH,5BH          ; ist es 'create new file' ?
                  JZ      @@CreateNewFile
                  CMP     AH,6CH          ; ist es 'open/create file' ?
                  JZ      SHORT @@2
                  JMP     SHORT @@1       ; -> keine dateibezogene Funktion

@@2:              MOV     AL,AH
                  MOV     AH,71H

                  ; fhre originale INT 21-Routine aus
@@1:              IRET

@@CreateFile:     PUSH    BP
                  MOV     BP,SP
                  PUSH    BX
                  PUSH    CX
                  PUSH    DX
                  PUSH    SI
                  MOV     SI,DX
                  XOR     CH,CH
                  MOV     BX,2
                  MOV     DX,11H
                  MOV     AX,716CH
                  PUSHF
                  CALL    DWORD PTR [BP+2]
                  POP     SI
                  POP     DX
                  POP     CX
                  POP     BX
                  POP     BP
                  INC     SP      ; ADD SP,6: verndert CF!
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  RETF    2

@@OpenFile:       PUSH    BP
                  MOV     BP,SP
                  PUSH    BX
                  PUSH    CX
                  PUSH    DX
                  PUSH    SI
                  MOV     SI,DX
                  XOR     BH,BH
                  XOR     CH,CH
                  MOV     BL,AL
                  MOV     DX,1
                  MOV     AX,716CH
                  PUSHF
                  CALL    DWORD PTR [BP+2]
                  POP     SI
                  POP     DX
                  POP     CX
                  POP     BX
                  POP     BP
                  INC     SP      
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  RETF    2

@@DeleteFile:     PUSH    BP
                  MOV     BP,SP
                  PUSH    CX
                  PUSH    SI
                  MOV     CH,CL
                  XOR     SI,SI
                  MOV     AX,7141H
                  PUSHF
                  CALL    DWORD PTR [BP+2]
                  POP     SI
                  POP     CX
                  POP     BP
                  INC     SP      
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  RETF    2

@@GetSetAttr:     PUSH    BP
                  MOV     BP,SP
                  PUSH    BX
                  MOV     BL,AL
                  MOV     AX,7143H
                  PUSHF
                  CALL    DWORD PTR [BP+2]
                  POP     BX
                  POP     BP
                  INC     SP      
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  RETF    2

@@CreateNewFile:  PUSH    BP
                  MOV     BP,SP
                  PUSH    BX
                  PUSH    CX
                  PUSH    DX
                  PUSH    SI
                  MOV     SI,DX
                  XOR     CH,CH
                  MOV     BX,2
                  MOV     DX,10H
                  MOV     AX,716CH
                  PUSHF
                  CALL    DWORD PTR [BP+2]
                  POP     SI
                  POP     DX
                  POP     CX
                  POP     BX
                  POP     BP
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  INC     SP
                  RETF    2

MyINT21Handler    ENDP

                  PUBLIC  _LOPEN
_LOPEN            PROC
                  PUSH    BP
                  MOV     BP,SP
                  PUSH    SI
                  PUSH    DS
                  MOV     AX,6C00H
                  XOR     BH,BH
                  MOV     BL,[BP+6]
                  XOR     CX,CX
                  MOV     DX,1
                  LDS     SI,[BP+8]
                  INT     DOS
                  JNC     SHORT @@1
                  MOV     AX,-1
@@1:              POP     DS
                  POP     SI
                  POP     BP
                  RET     6
_LOPEN            ENDP

                  PUBLIC  _LCREAT
_LCREAT           PROC
                  PUSH    BP
                  MOV     BP,SP
                  PUSH    SI
                  PUSH    DS
                  MOV     AX,6C00H
                  MOV     BX,2
                  XOR     CH,CH
                  MOV     CL,[BP+6]
                  MOV     DX,12H
                  LDS     SI,[BP+8]
                  INT     DOS
                  JNC     SHORT @@1
                  MOV     AX,-1
@@1:              POP     DS
                  POP     SI
                  POP     BP
                  RET     6
_LCREAT           ENDP

WIN32_FIND_DATA   STRUC
                  dwFileAttributes   DD         (?)
                  ftCreationTime     DD 2 DUP   (?)
                  ftLastAccessTime   DD 2 DUP   (?)
                  ftLastWriteTime    DD 2 DUP   (?)
                  nFileSizeHigh      DD         (?)
                  nFileSizeLow       DD         (?)
                  dwReserved0        DD         (?)
                  dwReserved1        DD         (?)
                  cFileName          DB 260 DUP (?)
                  cAlternateFileName DB  14 DUP (?)
WIN32_FIND_DATA   ENDS

                  PUBLIC  FINDFIRSTFILE
FINDFIRSTFILE     PROC
                  PUSH    BP
                  MOV     BP,SP
                  PUSH    SI
                  PUSH    DI
                  PUSH    DS
                  PUSH    ES
                  MOV     AX,714EH
                  MOV     CX,0037H
                  LDS     DX,[BP+10]
                  LES     DI,[BP+6]
                  MOV     SI,1
                  INT     21H
                  POP     ES
                  POP     DS
                  POP     DI
                  POP     SI
                  MOV     LastError,0
                  JNC     SHORT @@1
                  MOV     LastError,AX
                  MOV     AX,-1     ; INVALID_HANDLE_VALUE
@@1:              POP     BP
                  RET     8
FINDFIRSTFILE     ENDP

                  PUBLIC  FINDNEXTFILE
FINDNEXTFILE      PROC
                  PUSH    BP
                  MOV     BP,SP
                  PUSH    SI
                  PUSH    DI
                  PUSH    ES
                  MOV     AX,714FH
                  MOV     BX,[BP+10]
                  LES     DI,[BP+6]
                  MOV     SI,1
                  INT     21H
                  POP     ES
                  POP     DI
                  POP     SI
                  MOV     LastError,AX
                  MOV     AX,0
                  JC      SHORT @@1
                  MOV     LastError,AX
                  INC     AX
@@1:              POP     BP
                  RET     6
FINDNEXTFILE      ENDP

                  PUBLIC  FINDCLOSE
FINDCLOSE         PROC
                  PUSH    BP
                  MOV     BP,SP
                  MOV     AX,71A1H
                  MOV     BX,[BP+6]
                  INT     21H
                  MOV     LastError,AX
                  MOV     AX,0
                  JC      SHORT @@1
                  MOV     LastError,0
                  INC     AX
@@1:              POP     BP
                  RET     2
FINDCLOSE         ENDP

                  PUBLIC  GETLASTERROR
GETLASTERROR      PROC
                  MOV     AX,LastError
                  CWD
                  RET
GETLASTERROR      ENDP

                  .DATA

OldINT21          DD      0
LastError         DW      0

                  END
