/****  Datei: mod11.c                 ****/
/****  Autor: Jrg Michael, Hannover  ****/ 
/****  Datum: 16. Mai 1996            ****/ 

/****    Berechnung von Prfziffern   ****/ 
/****        mittels Modulo 11        ****/ 
/****            c't 07/96            ****/

#include <stdio.h> 
#include <ctype.h> 
#include <string.h> 

/****  Optionen  ****/ 
#define  setze_pruefziffer 
#define  loesche_trenner 
#define  trennzeichen     "/ -.:" 
#define  elfte_ziffer     'X' 

/****  Fehlercodes  ****/ 
#define  ZAHL_ZU_KURZ          -1000 
#define  ZAHL_ZU_LANG          -2000 
#define  UNGUELTIGE_PARAMETER  -3000 
#define  ZAHL_NICHT_VERWENDEN  -5000 
/****  Zahl nicht verwenden wg. Rest 10  ****/ 
/****  (nur bei "#undef elfte_ziffer")   ****/ 

/****  Potenzen von 2 (Modulo 11)  ****/ 
int zwei_hoch [10] = { 2, 4, 8, 5, 10, 9, 7, 3, 6, 1 }; 

/****  multiplikative Inverse bzgl. Modulo 11  ****/ 
int inv_mod11 [11] = { 0, 1, 6, 4, 3, 9, 2, 8, 7, 5, 10 }; 


int hole_mod11 (char zahl[], int anz_ziff, int pruef_pos) 
/****  Bestimmt bzw. setzt die Prfziffer einer Zahl   ****/ 
/****  an der Stelle pruef_pos (1. Ziffer = Pos 0)    ****/
/****  Ergebnis: Prfziffer im Bereich '0' bis '9'     ****/ 
/****            bzw. das Zeichen "elfte_ziffer"       ****/ 
{ 
 int i=0,k=0,n=0; 
 int p = -1; 
 int s = 0, x = 0; 
 if (anz_ziff > 0  &&  pruef_pos >= anz_ziff) 
   { 
    return (UNGUELTIGE_PARAMETER); 
   } 

 /****  Prfsumme ohne "pruef_pos" bestimmen  ****/ 
 while ((k = (int) zahl[n]) != 0) 
   { 
   #ifdef trennzeichen 
    if (strchr (trennzeichen,k) != NULL) 
      { 
     #ifdef loesche_trenner 
       strcpy (zahl+n, zahl+n+1); 
     #else 
       n++; 
     #endif 
       continue; 
      } 
   #endif 
    if (isdigit (k)  &&  i != pruef_pos) 
      { 
       s += zwei_hoch [i%10] * (k-'0'); 
       n++; 
       i++; 
      } 
    else if (i == pruef_pos  ||  pruef_pos < 0) 
           { 
            pruef_pos = i; 
            p = n; 
            n++; 
            i++; 
           } 
         else 
           { 
            break; 
           } 
   } 

 /****  Fehlerprfung  ****/ 
 if (k != 0  &&  k != ' ') 
   { 
    /****  Die (i+1)-te Ziffer ist fehlerhaft  ****/ 
    return (-i-1); 
   } 
 if (i <= 1  ||  i < anz_ziff  ||  p < 0) 
   { 
    return (ZAHL_ZU_KURZ); 
    /**** oder keine Prfzeichenposition gefunden ****/
   } 
 if (anz_ziff > 0  &&  i > anz_ziff) 
   { 
    return (ZAHL_ZU_LANG); 
   } 

 /****  Prfziffer berechnen aus der Bedingung:  ****/ 
 /****   (s + 2^(pruef_pos+1) * x) % 11 = 0     ****/ 
 n = zwei_hoch [pruef_pos%10]; 
 s = s % 11;   /****  wichtig wg. Computerarithmetik  ****/ 
 x = ((11-s) * inv_mod11[n]) % 11; 

 if (x < 10) 
   { 
    i = (x+'0'); 
   } 
 else 
   { 
  #ifdef elfte_ziffer 
     i = elfte_ziffer; 
  #else 
     /****  Zahl nicht verwenden wg. Rest 10  ****/ 
     return (ZAHL_NICHT_VERWENDEN); 
  #endif 
   } 

#ifdef setze_pruefziffer 
  /****  Prfziffer setzen  ****/ 
  zahl[p] = i; 
#endif 
 return (i); 
} 

#ifdef elfte_ziffer 
 int check_mod11 (char zahl[], int anz_ziff, int pruef_pos) 
#else 
 int check_mod11 (char zahl[], int anz_ziff) 
#endif 
/****  Prft eine Zahl auf Konsistenz        ****/ 
/****  Ergebnis:  0 : kein Fehler erkennbar  ****/ 
/****           1-10: Prfsumme fehlerhaft   ****/ 
{ 
 int i=0,k=0, 
     n=0,s=0; 

#ifdef elfte_ziffer 
 if (anz_ziff > 0  &&  pruef_pos >= anz_ziff) 
   { 
    return (UNGUELTIGE_PARAMETER); 
   } 
#endif 

 while ((k = (int) zahl[n]) != 0) 
   { 
   #ifdef trennzeichen 
    if (strchr (trennzeichen,k) != NULL) 
      { 
     #ifdef loesche_trenner 
       strcpy (zahl+n, zahl+n+1); 
     #else 
       n++; 
     #endif 
       continue; 
      } 
   #endif 

   #ifdef elfte_ziffer 
    if (k == elfte_ziffer  &&  (pruef_pos < 0  ||  i == pruef_pos)) 
      { 
       pruef_pos = i; 
       s += zwei_hoch [i%10] * 10; 
       n++; 
       i++; 
       continue; 
      } 
   #endif 

    if (isdigit (k)) 
      { 
       s += zwei_hoch [i%10] * (k-'0'); 
       n++; 
       i++; 
      } 
    else 
      { 
       break; 
      } 
   } 

 /****  Fehlerprfung  ****/ 
 if (zahl[n] != 0  &&  zahl[n] != ' ') 
   { 
    /****  Die (i+1)-te Ziffer ist fehlerhaft  ****/ 
    return (-i-1); 
   } 
 if (i < anz_ziff) 
   { 
    return (ZAHL_ZU_KURZ); 
   } 
 if (anz_ziff > 0  &&  i > anz_ziff) 
   { 
    return (ZAHL_ZU_LANG); 
   } 

 return (s % 11); 
} 
