// Delphi for OS/2 sample application. 1996 by c't / Matthias Withopf

Program TestOpen32;

{$IFDEF _OS2_}
Const
  SW_SHOWNORMAL       = 1;
  WM_DESTROY          = 2;
  WM_PAINT            = 15;
  IDC_ARROW           = PChar(32512);
  COLOR_WINDOW        = 5;
  CW_USEDEFAULT       = $80000000;
  WS_OVERLAPPEDWINDOW = $00CF0000;

Type
  UINT      = Cardinal;
  DWORD     = Cardinal;
  Bool      = LongBool;
  THandle   = LongInt;
  HInstance = THandle;
  HIcon     = THandle;
  HMenu     = THandle;
  HCursor   = THandle;
  HBrush    = THandle;
  HWND      = THandle;
  HDC       = THandle;
  TAtom     = Word;
  LResult   = LongInt;
  WParam    = LongInt;
  LParam    = LongInt;
  TWndProc  = Function (Wnd : HWND;Msg : UINT;wP : WParam;lP : LParam) : LResult; CDecl;
  TWinMain  = Function (Instance,PrevInstance : HInstance;CmdLine : PChar;CmdShow : Integer) : Integer; CDecl;

Type
  TWndClass =
    Record
      style         : UINT;
      lpfnWndProc   : TWndProc;
      cbClsExtra    : Integer;
      cbWndExtra    : Integer;
      hInstance     : HInstance;
      hIcon         : HIcon;
      hCursor       : HCursor;
      hbrBackground : HBrush;
      lpszMenuName  : PChar;
      lpszClassName : PChar;
    End;
  TPoint =
    Record
      x,y : LongInt;
    End;
  TRect =
    Record
      Left,Top,Right,Bottom : LongInt;
    End;
  TMsg =
    Record
      hwnd    : HWND;
      message : UINT;
      wParam  : WParam;
      lParam  : LParam;
      time    : DWord;
      pt      : TPoint;
    End;
  TPaintStruct =
    Record
      hdc         : HDC;
      fErase      : Bool;
      rcPaint     : TRect;
      fRestore    : Bool;
      fIncUpdate  : Bool;
      rgbReserved : Array[1..32] of Byte;
    End;

Const
  Open32DLLName = 'pmwinx.dll';

  Function  WinCallWinMain(argc : Integer;argv : Pointer;MainFunc : TWinMain;CmdShow : Integer) : Integer; CDecl;
    External Open32DLLName Index 6000;
  Function  RegisterClass(Var C : TWndClass) : TAtom; CDecl;
    External Open32DLLName Index 556;
  Procedure PostQuitMessage(ExitCode : Integer); CDecl;
    External Open32DLLName Index 528;
  Function  DefWindowProc(Wnd : HWND;Msg : UINT;wP : WParam;lP : LParam) : LResult; CDecl;
    External Open32DLLName Index 131;
  Function  LoadCursor(Inst : HInstance;Name : PChar) : HCursor; CDecl;
    External Open32DLLName Index 459;
  Function  CreateWindowEx(ExStyle : DWORD;ClassName,WindowName : PChar;Style : DWORD;x,y,Width,Height : Integer;
                           Parent : HWND;Menu : HMenu;Instance : HInstance;Param : Pointer) : HWND; CDecl;
    External Open32DLLName Index 99;
  Function ShowWindow(W : HWND;CmdShow : Integer) : Bool; CDecl;
    External Open32DLLName Index 671;
  Function GetMessage(Var Msg : TMsg;Wnd : HWND;MsgFilterMin,MsgFilterMax : UINT) : Bool; CDecl;
    External Open32DLLName Index 311;
  Function TranslateMessage(Var Msg : TMsg) : Bool; CDecl;
    External Open32DLLName Index 699;
  Function DispatchMessage(Var Msg : TMsg) : Bool; CDecl;
    External Open32DLLName Index 149;
  Function BeginPaint(Wnd : HWND;Var ps : TPaintStruct) : HDC; CDecl;
    External Open32DLLName Index 16;
  Function EndPaint(Wnd : HWND;Var ps : TPaintStruct) : Bool; CDecl;
    External Open32DLLName Index 173;
  Function TextOut(dc : HDC;x,y : Integer;s : PChar;Len : Integer) : Bool; CDecl;
    External Open32DLLName Index 689;
{$ELSE}
Uses
  Windows,Messages;
{$ENDIF}

  Function MainWndProc(Wnd : HWND;Msg : UINT;wP : WParam;lP : LParam) : LResult;
{$IFDEF _OS2_}
    CDecl;
{$ELSE}
    StdCall;
{$ENDIF}
  Const
    HelloStr = 'Delphi 2.0 says Hello to OS/2 Presentation Manager!';
  Var
    dc : HDC;
    ps : TPaintStruct;
  Begin
    Result := 0;
    Case Msg of
      WM_PAINT   : Begin
                     dc := BeginPaint(Wnd,ps);
                     TextOut(dc,20,15,HelloStr,51);
                     EndPaint(Wnd,ps);
                   End;
      WM_DESTROY : PostQuitMessage(0);
      else         Result := DefWindowProc(Wnd,Msg,wP,lP);
    End;
  End;


{$IFDEF _OS2_}
  Function WinMain(HInstance,PrevInstance : HInstance;CmdLine : PChar;CmdShow : Integer) : Integer; CDecl;
{$ENDIF}
  Const
    MainClassName = 'Main';
  Var
    C : TWndClass;
    W : HWND;
    M : TMsg;
  Begin
{$IFDEF _OS2_}
    Result := 0;
{$ENDIF}
    FillChar(C,SizeOf(C),0);
    C.lpfnWndProc   := @MainWndProc;
    C.hInstance     := HInstance;
    C.hCursor       := LoadCursor(0,IDC_ARROW);
    C.hbrBackground := HBrush(COLOR_WINDOW + 1);
    C.lpszClassName := MainClassName;
    RegisterClass(C);
    W := CreateWindowEx(0,MainClassName,'Hello',WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,CW_USEDEFAULT,
                        540,100,0,0,HInstance,Nil);
    ShowWindow(W,CmdShow);
    While GetMessage(M,0,0,0) do
      Begin
        TranslateMessage(M);
        DispatchMessage(M);
      End;
{$IFDEF _OS2_}
  End;

Begin
  WinCallWinMain(0,Nil,@WinMain,SW_SHOWNORMAL);
{$ENDIF}
End.
