// Delphi for OS/2 sample application. 1996 by c't / Matthias Withopf

Program ResTest;   {$R ResTest.Res}

Uses
  OS2;

Var
  ab : HAB;

  Function DemoDlgProc(Wnd : HWND;Msg : LongWord;Param1,Param2 : MParam) : MResult; CDecl;
  Begin
    Result := MResult(True);
    Case Msg of
      WM_COMMAND : WinDismissDlg(Wnd,Ord(True));
      else         Result := WinDefDlgProc(Wnd,Msg,Param1,Param2);
    End;
  End;

  Function PMDemoWndProc(Wnd : HWND;Msg : LongWord;Param1,Param2 : MParam) : MResult; CDecl;
  Var
    ps : HPS;
    R  : RECTL;
    s  : Array[0..255] of Char;
  Begin
    Case Msg of
      WM_CREATE          : PMDemoWndProc := Nil;
      WM_PAINT           : Begin
                             ps := WinBeginPaint(Wnd,0,Nil);
                             WinQueryWindowRect(Wnd,@R);
                             WinLoadString(ab,0,100,SizeOf(s),s);
                             WinDrawText(ps,-1,s,@R,0,2,DT_ERASERECT or DT_VCENTER or DT_CENTER);
                             WinEndPaint(ps);
                           End;
      WM_ERASEBACKGROUND : PMDemoWndProc := MResult(True);
      WM_COMMAND         : Begin
                             Case Word(Param1) of
                               101 : WinPostMsg(Wnd,WM_QUIT,Nil,Nil);
                               201 : WinDlgBox(HWND_DESKTOP,Wnd,@DemoDlgProc,0,100,Nil);
                             End;
                             PMDemoWndProc := Nil;
                           End;
      WM_CLOSE           : Begin
                             WinPostMsg(Wnd,WM_QUIT,Nil,Nil);
                             PMDemoWndProc := Nil;
                           End;
    else
      PMDemoWndProc := WinDefWindowProc(Wnd,Msg,Param1,Param2);
    End;
  End;

Var
  mq           : HMQ;
  FrameFlags   : LongWord;
  Frame,Client : HWND;
  Msg          : QMSG;
Begin
  ab := WinInitialize(0);
  mq := WinCreateMsgQueue(ab,0);
  If WinRegisterClass(ab,'HelloPM',@PMDemoWndProc,CS_SIZEREDRAW,0) <> 0 then
    Begin
      FrameFlags := FCF_TITLEBAR or FCF_SYSMENU or FCF_SIZEBORDER or FCF_MINMAX
                 or FCF_SHELLPOSITION or FCF_TASKLIST or FCF_MENU;
      Frame := WinCreateStdWindow(HWND_DESKTOP,WS_VISIBLE,FrameFlags,'HelloPM',
                                  'HelloPM',0,0,100,Client);
      If Frame <> 0 then
        Begin
          While WinGetMsg(ab,Msg,0,0,0) <> 0 do
            WinDispatchMsg(ab,Msg);
        End;
    End;
  WinDestroyMsgQueue(mq);
  WinTerminate(ab);
End.
