unit Arytimeu;
{ Laufzeiten fr Zugriffe auf zweidimensionale Arrays }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, MMSystem, StdCtrls;

type
  TAryTimeForm = class(TForm)
    TestStdAry: TButton;
    TestPtrAry: TButton;
    TimeLabel: TLabel;
    TestGlbAry: TButton;
    TestIncPtr: TButton;
    procedure TestStdAryClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TestPtrAryClick(Sender: TObject);
    procedure TestGlbAryClick(Sender: TObject);
    procedure TestIncPtrClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
const
  MaxX = 50; MaxY = 20;  { Arraydimensionen }

type
  TStdArray = Array[0..MaxX,0..MaxY] of Double;
  PStdArray = ^TStdArray;

  { Elemente einer Arrayzeile und Zeiger darauf}
  TDoubleRow = Array[0..MaxY] of Double;
  PDoubleRow = ^TDoubleRow;
  { Array mit Zeigern auf Arrayzeilen = zweidimensionales Array }
  TDoubleArray = Array[0..MaxX] of PDoubleRow;
  PDoubleArray = ^TDoubleArray;

var
  AryTimeForm: TAryTimeForm;
  PtrAry: PDoubleArray;
  StdAry: PStdArray;
  GlobalAry: TStdArray;  { im Datensegment }

implementation

{$R *.DFM}

procedure GetDoubleArray(var Ary: PDoubleArray);
var x: Integer;
begin
  New(Ary);
   { Platz fr die einzelnen Arrayzeilen }
  for x := 0 to MaxX do New(Ary^[x]);
end;

procedure FreeDoubleArray(var Ary: PDoubleArray);
var x: Integer;
begin { Arrayzeilen freigeben }
  for x := 0 to MaxX do Dispose(Ary^[x]);
  Dispose(Ary);
end;

procedure TAryTimeForm.FormCreate(Sender: TObject);
begin
  GetDoubleArray(PtrAry);
  New(StdAry);
end;

procedure TAryTimeForm.FormDestroy(Sender: TObject);
begin
  FreeDoubleArray(PtrAry);
  Dispose(StdAry);
end;

procedure TAryTimeForm.TestStdAryClick(Sender: TObject);
var x,y,z: Integer; StartTime: LongInt;
begin
  StartTime := timeGetTime;
  for x := 0 to MaxX do
    for y := 0 to MaxY do
      StdAry^[x,y] := 3.5*x+y;

  for z := 1 to 1000 do
    for x := 1 to MaxX do
      for y := 1 to MaxY do
        StdAry^[x,y] := StdAry^[x-1,y-1];

  TimeLabel.Caption := 'Zeit (ms): '+IntToStr(timeGetTime-StartTime);
end;

procedure TAryTimeForm.TestPtrAryClick(Sender: TObject);
var x,y,z: Integer; StartTime: LongInt;
begin
  StartTime := timeGetTime;
  for x := 0 to MaxX do
    for y := 0 to MaxY do
      PtrAry^[x]^[y] := 3.5*x+y;

  for z := 1 to 1000 do
    for x := 1 to MaxX do
      for y := 1 to MaxY do
        PtrAry^[x]^[y] := PtrAry^[x-1]^[y-1];

  TimeLabel.Caption := 'Zeit (ms): '+IntToStr(timeGetTime-StartTime);
end;

procedure TAryTimeForm.TestGlbAryClick(Sender: TObject);
var x,y,z: Integer; StartTime: LongInt;
begin
  StartTime := timeGetTime;
  for x := 0 to MaxX do
    for y := 0 to MaxY do
      GlobalAry[x,y] := 3.5*x+y;

  for z := 1 to 1000 do
    for x := 1 to MaxX do
      for y := 1 to MaxY do
        GlobalAry[x,y] := GlobalAry[x-1,y-1];

  TimeLabel.Caption := 'Zeit (ms): '+IntToStr(timeGetTime-StartTime);
end;

procedure TAryTimeForm.TestIncPtrClick(Sender: TObject);
var x,y,z: Integer; StartTime: LongInt; P,P1: ^Double;
begin
  StartTime := timeGetTime;
  for x := 0 to MaxX do
  begin
    P := @GlobalAry[x,0];
    for y := 0 to MaxY do
    begin
      P^ := 3.5*x+y;
      Inc(P);
    end;
  end;

  for z := 1 to 1000 do
    for x := 1 to MaxX do
    begin
      P := @GlobalAry[x,1]; P1 := @GlobalAry[x-1,0];
      for y := 1 to MaxY do
      begin
        P^ := P1^;
        Inc(P); Inc(P1);
      end;
    end;

  TimeLabel.Caption := 'Zeit (ms): '+IntToStr(timeGetTime-StartTime);
end;

end.
