// platform/os independent timing
//
// this routines use a free definable time stamp
// time gets converted to ms on calculating stamp difference
//
// for supported platforms take a look at psosdep.h
//

//#define ACORN
#ifdef ACORN
#include <time.h>
#include "pst_h"
#else
#include "pstimer.h"
#endif

#ifdef DOS_16
#include <conio.h>      // needed for Port-I/O
DWORD   far *pTicker;   // pointer to bios data area
#endif

#ifdef NT
#ifdef NTLOW
#else
TIME_STAMP  tsTimeBase;
#endif
#endif

#ifdef OS2_HR
HFILE   hfTimer;
#endif  

#ifdef NEXTSTEP
#import <mach/mach.h>
#import <mach/mach_error.h>
#import <servers/netname.h>
port_name_t tdriver_port;
#endif

#ifdef ACORN
TIME_STAMP DWORD
#endif

DWORD   dwTimeCorr= 0;	

// called on initialisation
void InitTime( void)
{   
        TIME_STAMP      tS, tE;
        
#ifdef DOS_16
    DWORD   dwT;
    
    pTicker= MAKELP( 0x40, 0x6c);   // get pointer to bios data area 
    _asm {  sti };                  // wait one interrrupt
    dwT= *pTicker;					
    while ( dwT == *pTicker);
    _asm {  cli };                  // setup timer chip
    outp( 0x43, 0x34);
    outp( 0x40, 0);
    outp( 0x40, 0);
    _asm {  sti };
#endif

#ifdef NT
#ifdef NTLOW
#else
    ULONG   lRemainder;

    if ( QueryPerformanceFrequency( &tsTimeBase))
    {   tsTimeBase= ExtendedLargeIntegerDivide( tsTimeBase, 1000, &lRemainder);
        return;
    }
#endif
#endif

#ifdef OS2_HR
    ULONG   ulRC, ulAction;
 
    ulRC=
        DosOpen( "TIMER$", &hfTimer, &ulAction, 0, FILE_NORMAL, FILE_OPEN, OPEN_SHARE_DENYNONE, NULL);
    if ( ulRC)  
    {}
#endif

#ifdef NEXTSTEP
    kern_return_t   r;

    r = netname_look_up( name_server_port, "", "td0", &tdriver_port);
    if (r != KERN_SUCCESS)
    {
        mach_error("Can't find timerdriver's advertised port", r);
        exit(1);
    }
#endif

        // get timing time
		GetTimeStamp( &tS);
        GetTimeStamp( &tE);
        dwTimeCorr= StampDifference( &tS, &tE);
}

// called to get current os/platform independent time stamp
void GetTimeStamp( TIME_STAMP *pStamp)
{
#ifdef WIN_16
        *pStamp= GetTickCount();
#endif  

#ifdef DOS_16
    DWORD   dwT;            // buffer
    WORD    wKlow, wKhigh;  // temps
    BYTE    bK;             // 
    
    _asm {  cli };
    outp( 0x43, 0);			// freeze to read timer 
    dwT= *pTicker;
    _asm {  sti };           
    wKlow= inp( 0x40);
    wKhigh= inp( 0x40);
    bK= (BYTE)(( *pTicker- dwT) & ( wKhigh >> 7));
    wKlow+= ( wKhigh << 8);
    dwT= (( dwT+ bK) << 16)+ ( 0xffff- (DWORD)wKlow);
    *pStamp= dwT;
#endif

#ifdef NT
#ifdef NTLOW
	*pStamp= GetTickCount();
#else
    QueryPerformanceCounter( pStamp);
#endif
#endif

#ifdef MAC
    Microseconds(pStamp);
#endif

#ifdef OS2
    APIRET  r;
    r= DosQuerySysInfo( QSV_MS_COUNT, QSV_MS_COUNT, (void*)pStamp, sizeof( &pStamp));
#endif             

#ifdef OS2_HR
    ULONG   ulRC, ulBytes;

    ulRC= DosRead( hfTimer, pStamp, sizeof( TIME_STAMP), &ulBytes);
#endif

#ifdef NEXTSTEP
    kern_return_t   r;

    r = td_getms(tdriver_port, pStamp);
    if (r != KERN_SUCCESS)
        *pStamp= 0;
#endif
#ifdef ACORN
    *pStamp= (DWORD)clock();
#endif
}

// calculated difference, return ms
DWORD StampDifference( TIME_STAMP *pStart, TIME_STAMP *pStop)
{   DWORD       dwR;

#ifdef WIN_16
        dwR= ( *pStop-*pStart);
#endif

#ifdef DOS_16
                dwR= (DWORD)
                        ((float)((float)(*pStop)* (float)TIMERZEIT* (float)1000)-
                         (float)((float)(*pStart)* (float)TIMERZEIT* (float)1000));
#endif

#ifdef NT
#ifdef NTLOW
	dwR= (*pStop- *pStart);
#else
    TIME_STAMP  tsResult;
    TIME_STAMP  tsRemainder;
    
    // based on NTs resolution
    tsResult= LargeIntegerSubtract( *pStop, *pStart);
    tsResult= LargeIntegerDivide( tsResult, tsTimeBase, &tsRemainder);
    dwR= ( tsResult. LowPart);
#endif
#endif

#ifdef MAC
	dwR = (pStop->lo >= pStart->lo) ? (pStop->lo - pStart->lo) /1000 : ~(pStop->lo - pStart->lo) /1000;	
    // Macintosh uses 60 Hz timer 
	// dwR= (( *pStop-*pStart)* 1000 /CLOCKS_PER_SEC);
#endif

#ifdef OS2                  
    dwR= ( *pStop-*pStart);
#endif

#ifdef OS2_HR
    dwR= (( pStop->ulMs- pStart->ulMs));
#endif

#ifdef NEXTSTEP
    dwR= ( *pStop- *pStart);
#endif

#ifdef ACORN
    dwR= ( *pStop- *pStart)* 10;
#endif

    return dwR- dwTimeCorr;
}
