////////////////////////////////////////
//
//  Pi-Berechnung
//
//  Sprache:      ANSI-C++
//  Datei:        bpp.cpp
//  Autor:        Sebastian Wedeniwski
//
//  Datum:        31.03.1996
//																				

#include <limits.h>
#include <iostream.h>
#include <string.h>
#include <math.h>
#include <time.h>


typedef unsigned int Digit;

const Digit BETA = CHAR_BIT*sizeof(Digit);
const Digit GAMMA = ~Digit(0);
const Digit GAMMA_LOW = GAMMA >> (BETA/2);
const Digit GAMMA_HIGH = ~GAMMA_LOW;

const Digit ALPHA = Digit(pow(10.0, int(log10(GAMMA+1.0))));
const Digit ALPHA_WIDTH = Digit(log10(ALPHA));


#if defined(__386__) && defined(__WATCOMC__)

void digitmul(const Digit, const Digit, Digit&, Digit&);
#pragma aux digitmul =    \
   "mul ebx"                          \
   "mov [esi],edx"                    \
   "mov [edi],eax"                    \
   parm [EAX] [EBX] [ESI] [EDI]       \
   modify [ ESI EDI EAX EDX ];

void digitdiv(const Digit, const Digit, const Digit, Digit&, Digit&);
#pragma aux digitdiv =    \
   "div ebx"                          \
   "mov [esi],eax"                    \
   "mov [edi],edx"                    \
   parm [EDX] [EAX] [EBX] [ESI] [EDI] \
   modify [ ESI EDI EAX EDX ];

#else

void digitmul(const Digit a, const Digit b, Digit &x, Digit &y)
// a*b = x*2^BETA + y.
{
	const Digit d = (a>>(BETA/2)) * (b&GAMMA_LOW);
	x = (a>>(BETA/2)) * (b>>(BETA/2));
	y = (a&GAMMA_LOW) * (b&GAMMA_LOW);
	Digit c = (a&GAMMA_LOW) * (b>>(BETA/2)) + d;
	if (c < d) x += GAMMA_LOW+1;
	x +=  c >> (BETA/2);
	c <<= BETA/2;
	y += c;
	if (y < c) x++;
}

void digitdiv(Digit a, Digit b, const Digit c, Digit &q, Digit &r)
// (a*2^BETA+b) / c = (q, r)
// Bedingung: a < c.
{
	const Digit HIBIT = ~(GAMMA >> 1);
	if (c <= GAMMA_LOW) {
		a = (a << BETA/2) | (b >> BETA/2);
		q = a/c;
		a -= q*c;
		a = (a << BETA/2) | (b & GAMMA_LOW);
		b = a/c;
		r = a -= b*c;
		q = (q << BETA/2) | b;
	} else {
		if (c & HIBIT) {
			for (Digit i = BETA; i; i--)
				if (a & HIBIT) {
					if (b & HIBIT) a -= ~a;
					else a += a;
					b -= ~b;
					a -= c;
				} else {
					if (b & HIBIT) a -= ~a;
					else a += a;
					if (a >= c) { a -= c; b -= ~b; }
					else b += b;
				}
		} else
			for (Digit i = BETA; i; i--) {
				if (b & HIBIT) a -= ~a;
				else a += a;
				if (a >= c) { a -= c; b -= ~b; }
				else b += b;
			}
		r = a; q = b;
	}
}

#endif

void mul(Digit* pT, Digit* pPrd, const Digit a)
{
	Digit x,y;
	Digit c = 0;
	do {
		digitmul(a, *--pPrd, x, y);
		y += c;
		if (y < c) x++;
		*pPrd = y;
		c = x;
	} while (pPrd != pT);
}

void print(const Digit* a, Digit FixedSize)
{
	Digit* pOut = new Digit[FixedSize];
	if (!pOut) { cerr << "Out of Memory!\n"; return; }
	memcpy(pOut, a, FixedSize*sizeof(Digit));

	cout << *pOut << '.';
	*pOut = 0;
	for (Digit i = Digit((FixedSize-1)*BETA*log(2)/log(ALPHA)); i; i--) {
		mul(pOut, pOut+FixedSize, ALPHA);
		cout.width(ALPHA_WIDTH);
		cout.fill('0');
		cout << *pOut;
		*pOut = 0;
	}
	delete[] pOut;
	cout << endl;
}

void add(const Digit* pT, Digit* pSum, Digit* pSmd)
{
	Digit c;
	do {
		*--pSum += c = *--pSmd;
		if (c > *pSum)
			do {
				c = *--pSmd;
				*--pSum -= ~c;
			} while (c >= *pSum);
	} while (pSum != pT);
}

void add(const Digit* pT, Digit* pSum, const Digit* pS, Digit* pSmd, Digit* pSd)
{
	Digit c;
	while (1) {
		do {
			*--pSum += c = *--pSmd;
			if (c > *pSum)
				do {
					if (pSmd == pS)
						if (pSum == pT) { *--pSum -= ~*--pSmd; return; }
						else pSmd = pSd;
					c = *--pSmd;
					*--pSum -= ~c;
				} while (c >= *pSum);
		} while (pSmd != pS);
		if (pSum == pT) break;
		pSmd = pSd;
	}
	*--pSum += *--pSmd;
}

void sub(const Digit* pT, Digit* pDif, Digit* pSub)
{
	do {
		Digit c = *--pSub;
		if (*--pDif >= c) *pDif -= c;
		else {
			*pDif -= c;
			do *--pDif += c = ~(*--pSub); while (*pDif >= c);
		}
	} while (pDif != pT);
}

void sub(const Digit* pT, Digit* pDif, const Digit* pS, Digit* pSub, Digit* pSd)
{
	while (1) {
		do {
			Digit c = *--pSub;
			if (*--pDif >= c) *pDif -= c;
			else {
				*pDif -= c;
				do {
					if (pSub == pS)
						if (pDif == pT) { *--pDif += ~*--pSub; return; }
						else pSub = pSd;
					*--pDif += c = ~(*--pSub);
				} while (*pDif >= c);
			}
		} while (pSub != pS);
		if (pDif == pT) break;
		pSub = pSd;
	}
	*--pDif -= *--pSub;
}

void main(void)
{
	Digit FixedSize;
	cout << "Anzahl der Dezimalstellen = "; cin >> FixedSize;

	FixedSize = Digit(3.321928095*FixedSize/BETA) + 1;
	if (FixedSize < 3) FixedSize = 3;
	Digit maxSize = FixedSize-1;

	Digit* a = new Digit[FixedSize];
	Digit* pi = new Digit[FixedSize];
	if (!a || !pi) { cerr << "Out of Memory!\n"; return; }
	*pi = 3;
	Digit* piEnd = pi+FixedSize;
	Digit* piAnf = pi+1;
	memset(piAnf, 34, maxSize*sizeof(Digit));

	Digit y;
	Digit j = 1;
	time_t start = clock();
	Digit i = 8;
	while (1) {
		j++; i++;
		digitdiv(0, GAMMA >> j, i, *a, y);
		Digit x = y;
		for (Digit k = 1; k < maxSize; k++) {
			digitdiv(x, GAMMA, i, a[k], x);
			if (x == y) {
				a++;
				const Digit sz = (maxSize-1) % k;
				if (sz) add(piAnf+1, piEnd, a, a+sz, a+k);
				else add(piAnf+1, piEnd, a, a+k, a+k);
				a--;
				break;
			}
		}
		if (k == maxSize) add(piAnf, piEnd, a+maxSize);

		j += 2;
		if (j >= BETA) {
			j -= BETA;
			if (--maxSize == 1) break;
			piAnf++;
		}

		i += 4;
		digitdiv(0, GAMMA >> j, i, *a, y);
		x = y;
		for (k = 1; k < maxSize; k++) {
			digitdiv(x, GAMMA, i, a[k], x);
			if (x == y) {
				a++;
				const Digit sz = (maxSize-1) % k;
				if (sz) sub(piAnf+1, piEnd, a, a+sz, a+k);
				else sub(piAnf+1, piEnd, a, a+k, a+k);
				a--;
				break;
			}
		}
		if (k == maxSize) sub(piAnf, piEnd, a+maxSize);

		j++;
		i /= 4;
		digitdiv(0, GAMMA >> j, i, *a, y);
		x = y;
		for (k = 1; k < maxSize; k++) {
			digitdiv(x, GAMMA, i, a[k], x);
			if (x == y) {
				a++;
				const Digit sz = (maxSize-1) % k;
				if (sz) sub(piAnf+1, piEnd, a, a+sz, a+k);
				else sub(piAnf+1, piEnd, a, a+k, a+k);
				a--;
				break;
			}
		}
		if (k == maxSize) sub(piAnf, piEnd, a+maxSize);

		i += i; i++;
		digitdiv(0, GAMMA >> j, i, *a, y);
		x = y;
		for (k = 1; k < maxSize; k++) {
			digitdiv(x, GAMMA, i, a[k], x);
			if (x == y) {
				a++;
				const Digit sz = (maxSize-1) % k;
				if (sz) sub(piAnf+1, piEnd, a, a+sz, a+k);
				else sub(piAnf+1, piEnd, a, a+k, a+k);
				a--;
				break;
			}
		}
		if (k == maxSize) sub(piAnf, piEnd, a+maxSize);
		i++; i *= 2;
	}
	time_t stop = clock();

	print(pi, FixedSize);
	cout << "time [s] = " << double(stop-start)/CLK_TCK << endl;

	delete[] pi;
	delete[] a;
}
