unit Msgtimeu;  { 04-OKT-96 as (Arne Schpers) }
{ Einfache Basisklasse fr zyklische Aufrufe und Demonstration
  anhand einer x-beliebigen Ableitung (hier: von TMemo) }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, mmSystem;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject;
                                 var CanClose: Boolean);
    procedure Button1Click(Sender: TObject);
  private
    TimeObjList: TList;
    CloseRequest: Boolean;
  public
    procedure DoMyMessageLoop;
  end;

var
  Form1: TForm1;
{ TTimeBase-Objekte tragen sich bei Create in
  eine Liste ein, die dann vom bergeordneten Programm
  zyklisch ber eine Schleife benachrichtigt werden. }
type
  TTimeEvent = procedure(Sender: TObject;
                  CurrTime: LongInt) of object;
  TTimeBase = class(TObject)
    private
      FOnTimer: TTimeEvent;
      FTimeList: TList;
    public
      constructor Create(TimeList: TList);
      destructor Destroy; override;
      procedure TimeCheck(CurrTime: LongInt);
      property OnTimer: TTimeEvent read FOnTimer write FOnTimer;
  end;


type
  TMyClass = class(TMemo)
  private
    FTimeBase: TTimeBase;
    FNextMove, FTimeStep: LongInt;
  protected
    procedure OnTimer(Sender: TObject; CurrTime: LongInt);
  public
    constructor Create(AOwner: TComponent; TimeList: TList);
    destructor Destroy; override;
  end;

implementation

{$R *.DFM}

constructor TTimeBase.Create(TimeList: TList);
begin
  inherited Create;
  FTimeList := TimeList; FTimeList.Add(Self);
end;

destructor TTimeBase.Destroy;
begin
  FTimeList.Remove(Self);
  inherited Destroy;
end;

procedure TTimeBase.TimeCheck(CurrTime: LongInt);
begin
  if Assigned(FOnTimer) then FOnTimer(Self,CurrTime);
end;

constructor TMyClass.Create(AOwner: TComponent; TimeList: TList);
begin
  inherited Create(AOwner);
  FTimeBase := TTimeBase.Create(TimeList);
  FTimeBase.OnTimer := OnTimer;
  FTimeStep := 50; FNextMove := timeGetTime+FTimeStep;
end;

destructor TMyClass.Destroy;
begin
  FTimeBase.Destroy;
  inherited Destroy;
end;

procedure TMyClass.OnTimer(Sender: TObject; CurrTime: LongInt);
begin
  if FNextMove <= CurrTime then
  begin
    Color := RGB(Random(256),Random(256),Random(256));
    Invalidate;
    FNextMove := CurrTime+FTimeStep;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Button1.Enabled := False;
  DoMyMessageLoop;
end;

procedure TForm1.DoMyMessageLoop;
var x: Integer; CurrTime: LongInt;
begin
  while not CloseRequest do
  begin
    CurrTime := timeGetTime;
    for x := 0 to TimeObjList.Count-1 do
     TTimeBase(TimeObjList.Items[x]).TimeCheck(CurrTime);

    Application.ProcessMessages;
  end;
end;

procedure TForm1.FormCloseQuery(Sender: TObject;
                                      var CanClose: Boolean);
begin
  CloseRequest := True;
end;

procedure TForm1.FormCreate(Sender: TObject);
var x: Integer; NewWnd: TMyClass;
begin
  TimeObjList := TList.Create;
  for x := 0 to 3 do
  begin  { einfach wild vier Fenster erzeugen }
    NewWnd := TMyClass.Create(Self,TimeObjList);
    NewWnd.Parent := Self;
    NewWnd.SetBounds(x*100,0,100,100);
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  TimeObjList.Destroy;
end;

end.
