		TITLE	VESA24.ASM
		.386
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  Routinen fr Grafik in den Truecolor-Modi des VESA-Standards   ;
;  Aufrufbar von Turbo Pascal					  ;
;  Jrgen Petsch fr c't 2.97                                     ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  Inhalt: KONST
;	   DATA
;	     ModeInfoBlock
;	     VESAInfoBlock
;	   CODE
;	     PUBLIC-Deklarationen
;	     MACROs
;	     Von TP aus aufrufbare FUNCTIONs und PROCEDUREs (FAR CALLs)
;	     Prozeduren, die innerhalb der UNIT mit NEAR CALL aufgerufen werden.
;	     Zeichensatz 8*16
;
;KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
;KONST
;-------------------------------
True		EQU	0FFH
False		EQU	0
;-------------------------------

;DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
DATA		SEGMENT PARA PUBLIC 'DATA' USE16
;-------------------------------
VESAInfoBlock	LABEL	NEAR
;					  Offs
VESASignature	DD	0		; 00H
VESAVersion	DW	0		; 04H
OEMStringPtr	DD	0		; 06H
Capabilities	DD	0		; 0AH
VideoModePtr	DD	0		; 0EH
TotalMemory	DW	0		; 12H
		DB	242 DUP (0)
;-------------------------------
;  Der ModeInfoBlock befindet sich im DS.
;  Bei PROC, die das von TP gelieferte DS verndern, ist unbedingt darauf zu
;  achten, da vor dem Zugriff auf den ModeInfoBlock das DS wieder seinen
;  ursprnglichen Wert erhlt.
;
ModeInfoBlock	LABEL	NEAR
;					  Offs
ModeAttributes		DW	0	; 00H
WinAAttributes		DB	0	; 02H
WinBAttributes		DB	0	; 03H
WinGranularity		DW	0	; 04H  (kByte)
WinSize			DW	0	; 06H  (kByte)
WinASegment		DW	0	; 08H
WinBSegment		DW	0	; 0AH
WinFuncPtr		DD	0	; 0CH  (Pointer)
BytesPerScanLine	DW	0	; 10H
XResolution		DW	0	; 12H
YResolution		DW	0	; 14H
XCharSize		DB	0	; 16H
YCharSize		DB	0	; 17H
NumberOfPlanes		DB	0	; 18H
BitsPerPixel		DB	0	; 19H
NumberOfBanks		DB	0	; 1AH
MemoryModel		DB	0	; 1BH
BankSize		DB	0	; 1CH
NumberOfImagePages	DB	0	; 1DH
Reserved		DB	0	; 1EH
RedMaskSize		DB	0	; 1FH
RedFieldPosition	DB	0	; 20H
GreenMaskSize		DB	0	; 21H
GreenFieldPosition	DB	0	; 22H
BlueMaskSize		DB	0	; 23H
BlueFieldPosition	DB	0	; 24H
			DB	0DBH DUP (0)
;----------------
WinSizePerGranu 	DW	1	; WinSize / WinGranularity
BytesPerPixel		DW	3	; BitsPerPixel DIV 8
;-------------------------------
Liste		DB	512 DUP (0)
;-------------------------------
XorMode 	DB	0
;-------------------------------
DATA		ENDS
;ddddddddddddddddddddddddddddddd

;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CODE		SEGMENT PARA PUBLIC USE16
		ASSUME	CS:CODE, DS:DATA
;-------------------------------
PUBLIC	GetScanCode	; Wartet auf eine Taste und liefert den Scancode
PUBLIC	VESAAvail	; Die FUNCTION kehrt mit True zurck und fllt den
			;  VESAInfoBlock, wenn ein VESA-BIOS vorhanden ist
PUBLIC	GetVESAInfo	; Liefert Teile des VESAInfoBlockes an TP
PUBLIC	SetVESAMode	; Schaltet einen Truecolor-VESA-Modus ein
PUBLIC	SetAlfaMode	; Schaltet zurck in den Textmode
PUBLIC	SetMovMode	; Setzt die lokale VAR XorMode:= FALSE
PUBLIC	SetXorMode	; Setzt die lokale VAR XorMode:= TRUE

PUBLIC	PutPixel	; Setzt ein Pixel an der Stelle X,Y mit Farbe
PUBLIC	GetPixel	; Liefert die Farbe eines Pixels an der Stelle X,Y

PUBLIC	PutLineH	; Horizontale von X,Y mit Lnge und Farbe
PUBLIC	PutLineV	; Vertikale von X,Y mit Lnge und Farbe
PUBLIC	PutLine		; Gerade von X,Y nach Xe,Ye mit Farbe
PUBLIC	PutRect 	; Rechteck X,Y obere linke Ecke
PUBLIC	PutCircle	; Kreis mit R um X,Y
PUBLIC	PutDisk 	; Kreisscheibe mit R um X,Y

PUBLIC	FillSprite	; Fllt ein Sprite mit Farbe
PUBLIC	ZoomSprite	; Zoomt ein Rechteck auf doppelte Kantenlnge
PUBLIC	GetSprite	; Holt ein Sprite vom Screen ins DOS-Mem
PUBLIC	PutSprite	; Bringt ein Sprite vom DOS-Mem zum Screen
PUBLIC	File2Sprite	; Holt ein Sprite vom File auf den Screen
PUBLIC	Sprite2File	; Bringt ein Sprite vom Screen in einen File
PUBLIC	Bmp2Sprite	; Holt ein Sprite vom .BMP-File in das Video-Mem
PUBLIC	Sprite2Bmp	; Bringt ein Sprite vom Video-Mem in einen Bmp-File

PUBLIC	PutChar 	; ASCII-Zeichen an X,Y mit Farbe

PUBLIC	ClearVGAMem	; Lscht das ganze VGA-Mem
PUBLIC	ShowBanks	; Blendet die Bankgrenzen ein
;===============================
;  MACROs
;===============================
;-------------------------------
;  Berechnet die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
GetScreenAddr	MACRO
		MOVZX	EAX,[BytesPerScanline]
		MOVZX	EDX,[Y]		; EDX = Y
		MUL	EDX		; EDXEAX := BytesPerScanLine * Y
;
		MOVZX	EDX,[X]			; EDX := X
		MOVZX	EBX,[BytesPerPixel]
		IMUL	EBX,EDX 		; EBX := X * BytesPerPixel
		ADD	EAX,EBX
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10			; [Byte]
		DIV	EBX			; EDX := Offset   EAX := Segm
		MOV	DI,DX			; DI := Offset
		MOV	DX,AX			; DX := Segm
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		ENDM
;------------------------------
;  Stellt im EAX die 3 Farbkomponenten zusammen
;  EING: Rot, Gruen, Blau auf dem Stack
;	 [Red/Green/BlueFieldPosition]
;  AUSG: EAX
;
GetColor	MACRO
		PUSH	EBX
		SUB	EBX,EBX
		MOV	BL,[Rot]
		MOV	CL,[RedFieldPosition]
		SHL	EBX,CL		; Bringe Rot in die RedFiledPosition..
		MOV	EAX,EBX 	; ..und ins EAX

		SUB	EBX,EBX
		MOV	BL,[Gruen]
		MOV	CL,[GreenFieldPosition]
		SHL	EBX,CL		; Bringe Gruen in die GreenFiledPosition..
		OR	EAX,EBX 	; ..und ins EAX

		SUB	EBX,EBX
		MOV	BL,[Blau]
		MOV	CL,[BlueFieldPosition]
		SHL	EBX,CL		; Bringe Blau in die BlueFiledPosition..
		OR	EAX,EBX 	; ..und ins EAX
		POP	EBX
		ENDM
;------------------------------
;  Setzt beide Bnke := DX
;
SetBanks	MACRO
		PUSH	DX
		SUB	BX,BX		; BH:=0 Window setzen;	BL:=0 Window A
		CALL	[WinFuncPtr]
		POP	DX
		MOV	BL,1		; Window B
		CALL	[WinFuncPtr]
		ENDM
;==================================================
;  Von TP aus aufrufbare FUNCTIONs und PROCEDUREs
;==================================================
;-------------------------------
;  Wartet auf ein Zeichen vom Keyboard und liefert den ScanCode der Taste
;  Aufruf: GetScanCode :BYTE;
;
GetScanCode	PROC	FAR
		MOV	AH,10H		; F16_GET_EXT_KEY
		INT	16H		; AH = SCAN_CODE  AL = ASCII-Zeichen
		MOV	AL,AH
		MOV	AH,0
		RET
GetScanCode	ENDP
;-------------------------------
;  Versucht den VESAInfoBlock zu laden.
;  Wenn ja, ist der VESAInfoBlock gefllt.
;
;  Aufruf: VESAAvail BOOLEAN;
;--------------
VESAAvail	PROC	FAR
		PUSH	BP
		MOV	BP,SP

		MOV	DI,OFFSET VESAInfoBlock	; ES:DI-> VESAInfoBlock
		MOV	AX,4F00h		; Return Super VGA Information
		INT	10h			; Video Interrupt
		CMP	AX,004Fh		; VESA BIOS vorhanden ?
		JZ	SHORT VESAAvail_0	;  Ja, True bleibt
		NOT	AX			; Nein, Ret mit False
VESAAvail_0:
		POP	BP
		RET
VESAAvail	ENDP
;-------------------------------
;  Liefert Teile des VESAInfoBlock an TP
;  Aufruf: GetVESAInfo (TpOEMString:STRING; VAR MemSize, Version:WORD);
;
TpOEMString	EQU	DWORD PTR [BP+14]
MemSizePtr	EQU	DWORD PTR [BP+10]
VESAVersionPtr	EQU	DWORD PTR [BP+6]
;...............
GetVESAInfo	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		PUSH	DS
;
;  Hole Version und wandle Nibbles B:A nach Dezimal
;
		MOV	AX,[VESAVersion]; AX:= X:C:B:A
		MOV	BL,AL		; BL:= B:A
		SHR	BL,4		; BL:= B
		MOV	BH,0		; BX:= B
		IMUL	BX,6		; BX:= 6*B
		SUB	AL,BL		; AL:= B:A - 6*B
		LES	DI,[VESAVersionPtr]; ES:DI-> TP-Variable
		MOV	ES:[DI],AX	; Lege Version ab
;
;  Hole TotalMemory und lege in der TP-Variablen ab
;
		MOV	AX,[TotalMemory]; Blcke a' 64k
		IMUL	AX,64		; Wandle in kByte
		LES	DI,[MemSizePtr] ; ES:DI-> TP-Variable
		MOV	ES:[DI],AX	; Lege MemSize ab
;
;  bertrage den OEMString in die TP-Variable
;
		LES	DI,[TpOEMString]; ES:DI-> TP-Variable
		INC	DI		; Skip TP-Stringlnge
		LDS	SI,[OEMStringPtr]; DS:SI-> OEMString
		SUB	CL,CL		; Init Stringlnge:= 0
GetVESAInfo_2:
		LODSB			; Hole vom OEMString
		CMP	AL,0		; Schluzeichen ?
		JZ	GetVESAInfo_4	;  Ja, fertig
		STOSB			; Bringe zum TP-OEMString
		INC	CL		; Stringlnge +1
		JMP	GetVESAInfo_2	; REPEAT UNTIL Zeichen = 0
;---------------
GetVESAInfo_4:	LDS	DI,[TPOEMString]; DS:DI-> TP-Variable
		MOV	[DI],CL 	; Lege Stringlnge ab
		POP	DS
		MOV	SP,BP
		POP	BP
		RET	12		; Entferne 3 POINTER
GetVESAInfo	ENDP
;-------------------------------
;  Schaltet einen bestimmten Truecolor-VESA-Modus ein
;  Aufruf: SetVESAMode (Xsoll,Ysoll:WORD; VAR BytePerPixel, VESAErr:WORD);
;	      VesaErr
;		0000 = kein Fehler
;		0001 = Modus wird nicht vom VESA-BIOS untersttzt
;		0002 = ModeInfoBlock konnte nicht gefllt werden
;		0003 = Einschalten des Modus fehlgeschlagen
;---------------
Xsoll		EQU	WORD PTR [BP+16]
Ysoll		EQU	WORD PTR [BP+14]
BytePerPixelPtr EQU	DWORD PTR [BP+10]
VESAErrPtr	EQU	DWORD PTR [BP+6]

ListenSegm	EQU	WORD PTR [BP-2]
ListenOffs	EQU	WORD PTR [BP-4]
Modus		EQU	WORD PTR [BP-6]
;---------------
SetVESAMode	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,6		; 3 lokale WORDs
;
;  Der VESAInfoBlock mu geladen worden sein (VESAAvail).
;  VESAInfoBlock.VideoModePtr enthlt einen Pointer auf eine mit FFFFH
;  abgeschlossene Liste der untersttzten Modi.
;
		LES	SI,DWORD PTR [VESAInfoBlock+0EH]; ES:SI-> Liste
		MOV	[ListenOffs],SI
		MOV	[ListenSegm],ES
;
;  Hole den nchsten Modus aus der Liste
;
SetVESAMode_2:	MOV	ES,[ListenSegm]
		MOV	SI,[ListenOffs]
		ADD	[ListenOffs],2	; ListenOffs-> nchster Eintrag
		MOV	CX,ES:[SI]	; CX:= Modus aus der Liste
		MOV	[Modus],CX	; Modus fr spter
		MOV	DX,1		; Bereite VESAErr:= 1 vor
		CMP	CX,0FFFFH	; Letzter Eintrag?
		JZ	SetVESAMode_0	; Ja, ret mit VESAErr
;
;  Flle fr CX:=Modus den ModeInfoBlock
;
		MOV	AX,DS
		MOV	ES,AX		; ES:DI-> ModeInfoBlock
		MOV	DI,OFFSET ModeInfoBlock
		MOV	AX,4F01H	; Return Super VGA Mode Info
		INT	10H		; Video Interrupt
		MOV	DX,2		; Bereite VESAErr:= 2 vor
		CMP	AX,004Fh	; erfolgreich ?
		JNZ	SetVESAMode_0	;  Nein, Ret mit VESAErr
;
;  Wenn ModeInfoBlock.XResolution <> Xsoll, dann weitersuchen
;
		MOV	AX,[Xsoll]
		CMP	AX,[XResolution]
		JNZ	SetVESAMode_2
;
;  Wenn ModeInfoBlock.YResolution <> Ysoll, dann weitersuchen
;
		MOV	AX,[Ysoll]
		CMP	AX,[YResolution]
		JNZ	SetVESAMode_2
;
;  Wenn ModeInfoBlock.BitsPerPixel <> 24/32, dann weitersuchen
;
		CMP	[BitsPerPixel],24 ; BitsPerPixel=24 ?
		JZ	SetVESAMode_4	  ;  Ja, Modus gefunden
		CMP	[BitsPerPixel],32 ; BitsPerPixel=32 ?
		JNZ	SetVESAMode_2	  ;  Nein, weitersuchen
;
;  Jetzt wissen wir, da Modus zu Xsoll, Ysoll
;  mit 24 oder 32 Bit/Pixel gehrt. Schalte den Modus ein.
;
SetVESAMode_4:	MOV	BX,[Modus]	; BX := Modus
		MOV	AX,4F02H	; Set Super VGA Video Mode
		INT	10H		; Video Interrupt
		MOV	DX,3		; Bereite VESAErr = 3 vor
		CMP	AX,004Fh	; erfolgreich ?
		JNZ	SetVESAMode_0	;  Nein, Ret mit VESAErr
;
;  Berechne WinSizePerGranu:= WinSize / WinGranularity
;
		MOV	AX,[WinSize]
		CWD
		DIV	[WinGranularity]
		MOV	[WinSizePerGranu],AX
;
;  Berechne BytesPerPixel:= BitsPerPixel DIV 8
;
		SUB	AX,AX
		MOV	AL,[BitsPerPixel]
		SHR	AL,3
		MOV	[BytesPerPixel],AX
;
;  Lege BytesPerPixel in der TP-Variablen ab
;
		LES	DI,[BytePerPixelPtr]	; ES:DI-> TP-Variable
		MOV	ES:[DI],AX		; Lege BytesPerPixel ab
;
;  Bereite Ablage des VESAErr:= 0 vor
;
		SUB	DX,DX
SetVESAMode_0:
		LES	DI,[VESAErrPtr]	; ES:DI-> VESAErr
		MOV	ES:[DI],DX	; Vorbereiteter VESAErr
		MOV	SP,BP
		POP	BP
		RET	8	; Entferne 2 WORDs und 1 POINTER
SetVESAMode	ENDP
;-------------------------------
;  Schaltet den VGA-Adapter auf 80 x 25 BW Alphanumeric Mode
;  Aufruf: SetAlfaMode;
;---------------
SetAlfaMode	PROC	FAR
		MOV	AL,03		; Mode:=3
		MOV	AH,0		; Set Video Mode
		INT	10H		; Video Interrupt
		RET
SetAlfaMode	ENDP
;-------------------------------
;  Setzt die VAR XorMode = TRUE, d.h. Pixel werden XOR mit dem Hintergrund
;  verknpft. Einige Prozeduren (PutPixel, PutLine, PutChar) richten sich danach.
;
;  Aufruf: SetXorMode
;---------------
SetXorMode	PROC	FAR
		MOV	[XorMode],True
		RET
SetXorMode	ENDP
;-------------------------------
;  Setzt die VAR XorMode = FALSE, d.h. Pixel berschreiben den Hintergrund.
;
;  Aufruf: SetMovMode
;---------------
SetMovMode	PROC	FAR
		MOV	[XorMode],False
		RET
SetMovMode	ENDP
;-------------------------------
;  Setzt ein Pixel an der Stelle X,Y mit Farbe.
;  Bercksichtigt XorMode
;  Aufruf: PutPixel (X,Y,rot,gruen,blau:WORD)
;---------------
X		EQU	WORD PTR [BP+14]
Y		EQU	WORD PTR [BP+12]
blau		EQU	BYTE PTR [BP+10]
gruen		EQU	BYTE PTR [BP+8]
rot		EQU	BYTE PTR [BP+6]
;---------------
PutPixel	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne ES:DI-> Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
;  Bilde im EAX die Farbkomponenten
;
		GetColor
;
;  Setze das Pixel ES:DI-> Video-Mem
;
		CALL	DrawPixel

		POP	BP
		RET	10			; Entferne 5 WORDs vom Stack
PutPixel	ENDP
;-------------------------------
;  Liefert die Farbkomponenten eines Pixels an der Stelle X,Y.
;  Aufruf: GetPixel (X,Y:WORD; VAR blau,gruen,rot:WORD);
;---------------
X		EQU	WORD PTR [BP+20]
Y		EQU	WORD PTR [BP+18]
BlauAddr	EQU	DWORD PTR [BP+14]
GruenAddr	EQU	DWORD PTR [BP+10]
RotAddr		EQU	DWORD PTR [BP+6]
;---------------
GetPixel	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne ES:DI-> Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
;  Hole die Farbkomponenten vom Video-Mem
;
		MOV	AL,ES:[DI]
		INC	DI
		JNZ	SHORT GetPixel_2
		CALL	IncRdBank
GetPixel_2:
		MOV	AH,ES:[DI]
		INC	DI
		JNZ	SHORT GetPixel_4
		CALL	IncRdBank
GetPixel_4:
		MOV	BL,ES:[DI]
		SHL	EBX,16
		MOV	BX,AX
;
;  Bringe die Farbkomponenten zu den TP-Variablen
;
		CLD
		LES	DI,[RotAddr]	; ES:DI-> Rot
		MOV	EAX,EBX
		MOV	CL,[RedFieldPosition]
		SHR	EAX,CL		; Hole Rot aus der RedFieldPosition..
		STOSB			; ..und bringe zur TP-Variablen

		LES	DI,[GruenAddr]	; ES:DI-> Gruen
		MOV	EAX,EBX
		MOV	CL,[GreenFieldPosition]
		SHR	EAX,CL		; Hole Gruen aus der GreenFieldPosition..
		STOSB			; ..und bringe zur TP-Variablen
;
		LES	DI,[BlauAddr]	; ES:DI-> Blau
		MOV	EAX,EBX
		MOV	CL,[BlueFieldPosition]
		SHR	EAX,CL		; Hole Gruen aus der GreenFieldPosition..
		STOSB			; ..und bringe zur TP-Variablen
;
		POP	BP
		RET	16	; Entferne 2 WORDs und 3 Ptr vom Stack
GetPixel	ENDP
;-------------------------------
;  Zeichnet eine senkrechte Gerade beginnend am oberen Ende.
;  Bercksichtigt XorMode.
;
;  Aufruf: PutLineV (X,Y,Laenge,Blau,Gruen,Rot:WORD);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Laenge		EQU	WORD PTR [BP+12]
blau		EQU	BYTE PTR [BP+10]
gruen		EQU	BYTE PTR [BP+8]
rot		EQU	BYTE PTR [BP+6]
;---------------
PutLineV	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne ES:DI-> Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows:= DX
;
		GetColor		; Bereite Farbkomponenten vor

		MOV	CX,[Laenge]
		JCXZ	PutLineV_0

		CALL	DrawDo		; Zeichne von oben nach unten
PutLineV_0:
		POP	BP
		RET	12		; Entferne 6 WORDs vom Stack

PutLineV	ENDP
;-------------------------------
;  Zeichnet eine Horizontale nach rechts
;  Bercksichtigt XorMode
;
;  Aufruf: PutLineH (X,Y,Laenge,Blau,Gruen,Rot:WORD);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Laenge		EQU	WORD PTR [BP+12]
blau		EQU	BYTE PTR [BP+10]
gruen		EQU	BYTE PTR [BP+8]
rot		EQU	BYTE PTR [BP+6]
;---------------
PutLineH	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne ES:DI-> Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
		GetColor		; Bereite Farbkomponenten vor

		MOV	CX,[Laenge]
		JCXZ	PutLineH_0
		CALL	DrawRi		; Zeichne die Horizontale nach rechts
PutLineH_0:
		POP	BP
		RET	12		; Entferne 6 WORDs vom Stack
;...............
PutLineH	ENDP
;-------------------------------
;  Zeichnet eine Gerade von X,Y nach XE,YE mit Farbe (nach Bresenham)
;  Bercksichtigt XorMode.
;
;  Aufruf: PutLine (X,Y,XE,YE,Blau,Gruen,Rot:WORD);
;---------------
X		EQU	WORD PTR [BP+18]
Y		EQU	WORD PTR [BP+16]
XE		EQU	WORD PTR [BP+14]
YE		EQU	WORD PTR [BP+12]
Blau		EQU	BYTE PTR [BP+10]
Gruen		EQU	BYTE PTR [BP+8]
Rot		EQU	BYTE PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
Sum		EQU	WORD PTR [BP-2]
BPLplus 	EQU	WORD PTR [BP-4]
BPLminus	EQU	WORD PTR [BP-6]
;---------------
;  Lokaler CALL: DrawRi
;---------------
PutLine		PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,6		; Platz fr 3 lokale WORDs
;
;  Berechne SI := DLTX
;
                MOV     SI,[XE]         ; XE
                SUB     SI,[X]          ; XE - X
;
;  Wenn DLTX < 0 , dann tausche X <-> XE und Y <-> YE  und  DLTX:= -DLTX
;
		JNS	SHORT PutLine_2
		MOV	AX,[XE]
		XCHG	AX,[X]
		MOV	[XE],AX
		MOV	AX,[YE]
		XCHG	AX,[Y]
		MOV	[YE],AX
		NEG	SI		; DLTX:= -DLTX
PutLine_2:
;
;  Berechne ES:DI-> Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows:= DX
;
		MOV	AX,[BytesPerScanline]
		MOV	BX,AX
		SUB	AX,[BytesPerPixel]
		MOV	[BPLMinus],AX	; BytesPerScanline -BytesPerPixel
		ADD	BX,[BytesPerPixel]
		MOV	[BPLPlus],BX	; BytesPerScanline +BytesPerPixel

		GetColor
;
;  Setze das 1. Pixel
;
		CALL	DrawPixel
;
;  Berechne BX := DLTY
;
		MOV	BX,[YE]
		SUB	BX,[Y]
;
;  Wenn DLTY > 0, dann positive Steigung (Scanlineoffset = +BytePerLine)
;
		JNS	PutLine_8
		NEG	BX		; DLTY := -DLTY
;
;  Wenn DLTX > DLTY, dann berechne Y = f(X)
;
                CMP     SI,BX
		JG	SHORT PutLine_20
;...............
;  Wir berechnen X = f(Y) mit Scanlineoffset = -BytePerLine
;
		MOV	CX,BX		; Loopcount = DLTY
		JCXZ	PutLine_0	; Loopcount = 0 ?
		MOV	[Sum],BX
		NEG	[Sum]		; SUM = - DLTY
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_12:
		SUB	DI,[BPLPlus]		; Y := Y - 1
		JC	SHORT PutLine_13	; Achte auf Bankswitch
PutLine_14:
		ADD	[Sum],SI		; SUM := SUM + 2 DLTX
		JS	SHORT PutLine_16	; Skip, wenn SUM < 0
		SUB	[Sum],BX		; SUM = SUM - 2 DLTY
		ADD	DI,[BytesPerPixel]	; X := X + 1
		JC	SHORT PutLine_15	; Achte auf Bankswitch
PutLine_16:
		CALL	DrawPixel		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_12	; Loop mit DLTY
		JMP	SHORT PutLine_0
;...............
PutLine_13:	CALL	DecRdWrBank
		JMP	SHORT PutLine_14
;...............
PutLine_15:	CALL	IncRdWrBank
		JMP	SHORT PutLine_16
;............................
;  Wir berechnen Y = f(X) mit Scanlineoffset = -BytePerLine
;
PutLine_20:	MOV	CX,SI		; Loopcount = DLTX
		JCXZ	PutLine_0	; Loopcount = 0 ?
		MOV	[Sum],SI
		NEG	[Sum]		; SUM = - DLTX
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_22:
		ADD	[Sum],BX		; SUM := SUM + 2 DLTY
		JS	SHORT PutLine_26	; Skip, wenn SUM < 0
		SUB	[Sum],SI		; SUM := SUM - 2DLTX
		SUB	DI,[BytesPerScanLine]; Y := Y - 1
		JC	SHORT PutLine_25	; Achte auf Bankswitch
PutLine_26:
		CALL	DrawPixel		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_22	; Loop mit DLTX
PutLine_0:
		MOV	SP,BP
		POP	BP
		RET	14			; Entferne 7 WORDs vom Stack
;...............
PutLine_25:	CALL	DecRdWrBank
		JMP	SHORT PutLine_26
;---------------
;  Wenn DLTX > DLTY, dann berechne Y = f(X)
;
PutLine_8:	CMP	SI,BX
		JG	SHORT PutLine_40
;............................
;  Wir berechnen X = f(Y) mit Scanlineoffset = +BytePerLine
;
		MOV	CX,BX		; Loopcount = DLTY
		JCXZ	PutLine_0	; Loopcount = 0 ?
		MOV	[Sum],BX
		NEG	[Sum]		; SUM = - DLTY
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_32:
		ADD	DI,[BPLMinus]	; Y := Y + 1
		JC	SHORT PutLine_33	; Achte auf Bankswitch
PutLine_34:
		ADD	[Sum],SI		; SUM := SUM + 2 DLTX
		JS	SHORT PutLine_36	; Skip, wenn SUM < 0
		SUB	[Sum],BX		; SUM := SUM - 2 DLTY
		ADD	DI,[BytesPerPixel]	; X := X + 1
		JC	SHORT PutLine_35	; Achte auf Bankswitch
PutLine_36:
		CALL	DrawPixel		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_32	; Loop mit DLTY
		JMP	SHORT PutLine_0
;...............
PutLine_33:	CALL	IncRdWrBank
		JMP	SHORT PutLine_34
;...............
PutLine_35:	CALL	IncRdWrBank
		JMP	SHORT PutLine_36
;...............
;  Wir berechnen Y = f(X) mit Scanlineoffset = +BytePerLine
;
PutLine_40:	MOV	CX,SI		; Loopcount = DLTX
		JCXZ	PutLine_0	; Loopcount = 0 ?
		MOV	[Sum],SI
		NEG	[Sum]		; SUM = - DLTX
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_42:
		ADD	[Sum],BX		; SUM := SUM + 2 DLTY
		JS	SHORT PutLine_46	; Skip, wenn SUM < 0
		SUB	[Sum],SI		; SUM := SUM - 2 DLTX
		ADD	DI,[BytesPerScanLine]; Y := Y + 1
		JC	SHORT PutLine_45	; Achte auf Bankswitch
PutLine_46:
		CALL	DrawPixel		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_42	; Loop mit DLTX
		JMP	PutLine_0
;...............
PutLine_45:	CALL	IncRdWrBank
		JMP	SHORT PutLine_46
;...............
PutLine 	ENDP
;---------------------------------------
;  Zeichnet ein Rechteck mit Farbe.
;  Bercksichtigt XorMode.
;
;  Aufruf: PutRect (X,Y,Breite,Hoehe,Blau,Gruen,Rot:WORD);
;---------------
X		EQU	WORD PTR [BP+18]
Y		EQU	WORD PTR [BP+16]
Breite		EQU	WORD PTR [BP+14]
Hoehe		EQU	WORD PTR [BP+12]
Blau		EQU	BYTE PTR [BP+10]
Gruen		EQU	BYTE PTR [BP+8]
Rot		EQU	BYTE PTR [BP+6]
;---------------
PutRect 	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X * BytesPerPixel	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
		GetColor		; Bilde im EAX die Farbkomponenten
;
		MOV	CX,[Breite]
		JCXZ	PutRect_0
		CALL	DrawRi
;
		MOV	CX,[Hoehe]
		JCXZ	PutRect_0
		CALL	DrawDo
;
		MOV	CX,[Breite]
		CALL	DrawLe
;
		MOV	CX,[Hoehe]
		CALL	DrawUp
PutRect_0:
		POP	BP
		RET	14		; Entferne 7 WORDs vom Stack
;................
PutRect 	ENDP
;-------------------------------
;  Zeichnet einen Kreis ohne Verwendung von Winkelfunktionen.
;  Die Mitte des Kreises liegt auf einem Pixel. Deshalb belegt der Kreis in
;  X- und Y-Richtung 2*R +1 Pixel.
;  Das kleinste R betrgt 2.
;  Bercksichtigt XorMode.
;
;  Aufruf: PutCircle (XM, YM, R, Blau, Gruen, Rot:WORD)
;---------------
Xm		EQU	WORD PTR [BP+16]
Ym		EQU	WORD PTR [BP+14]
R		EQU	WORD PTR [BP+12]
Blau		EQU	BYTE PTR [BP+10]
Gruen		EQU	BYTE PTR [BP+8]
Rot		EQU	BYTE PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
LastEntry	EQU	WORD PTR [BP-2]
FlagPixelPlus	EQU	BYTE PTR [BP-4] ; True, wenn zustzliches Pixel bentigt
;---------------
;  Lokale CALLs: GetListe, DrawRi, DrawDo, DrawLe, DrawUp
;---------------
PutCircle	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,4		; 2 lokale Word Var
;
;  Erzeuge eine Liste mit den Lngen der Geraden
;
		MOV	AX,[R]
		CALL	GetListe
		MOV	[LastEntry],DI	; Index-> letzten Eintrag
		MOV	AL,True 	; Zustzliches Pixel notwendig ?
		JNC	SHORT PutCircle_1 ; Ja, True bleibt
		MOV	AL,False	  ; Nein, kein zustzliches Pixel
PutCircle_1:
		MOV	[FlagPixelPlus],AL
;
;  Berechne die Adresse des 1. Byte (12 Uhr) im Video-Mem
;  DXDI = BytesPerScanline * (Ym - R) + Xm * BytesPerPixel
;
		MOVZX	EAX,[BytesPerScanline]	; EAX = BpSl

		SUB	EDX,EDX
		MOV	DX,[Ym] 	; EDX = Ym
		SUB	DX,[R]		; EDX = Ym - R
		MUL	EDX		; EDXEAX := BpSl * Ym - R
;
		MOVZX	EBX,[Xm]	; EBX := Xm
		MOVZX	EDX,[BytesPerPixel]
		IMUL	EBX,EDX 	; EBX := X * BytesPerPixel
		ADD	EAX,EBX	; EDXEAX := BpSl * (Ym -R) + Xm * BytesPerPixel
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10		; [Byte]
		DIV	EBX		; EDX := Offset EAX := Segm
		MOV	DI,DX		; DI := Offset
		MOV	DX,AX		; DX := Segm
;
		MOV	ES,[WinASegment]
;
		SetBanks		; Setze beide Windows := DX
;
		GetColor		; Bilde im EAX die Farbkomponenten
;
;  bertrage die Liste nach rechts in das Video-Mem
;  Es ist 12 Uhr
;
		MOV	SI,OFFSET Liste
		MOV	CH,0
PutCircle_2:
		MOV	CL,[SI]		; CX := Lnge

		CALL	DrawRi

		ADD	DI,[BytesPerScanLine]
		JNC	SHORT PutCircle_8
		CALL	IncRdWrBank
PutCircle_8:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_2
;
;  bertrage die Liste rckwrts nach unten in das Video-Mem
;  Es ist 1 Uhr 30
;
PutCircle_10:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_12
		INC	SI
PutCircle_12:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_14
		DEC	CX
PutCircle_14:
		CALL	DrawDo
		DEC	SI
		CMP	SI,OFFSET Liste
		JB	SHORT PutCircle_20
		ADD	DI,[BytesPerPixel]	; ES:DI-> ein Pixel nach rechts
		JNC	SHORT PutCircle_12
		CALL	IncRdWrBank
		JMP	SHORT PutCircle_12
;...............
;  bertrage die Liste vorwrts nach unten in das Video-Mem
;  Es ist 3 Uhr
;
PutCircle_20:	MOV	SI,OFFSET Liste
PutCircle_22:
		MOV	CL,[SI]			; CX := Lnge
		CALL	DrawDo
		SUB	DI,[BytesPerPixel]	; ES:DI-> ein Pixel nach links
		JNB	SHORT PutCircle_24
		CALL	DecRdWrBank
PutCircle_24:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_22
;
;  bertrage die Liste rckwrts nach links in das Video-Mem
;  Es ist 4 Uhr 30
;
PutCircle_30:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_32
		INC	SI
PutCircle_32:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_34
		DEC	CX
PutCircle_34:
		CALL	DrawLe
		DEC	SI
		CMP	SI,OFFSET Liste
		JB	SHORT PutCircle_40

		ADD	DI,[BytesPerScanLine]	; ES:DI-> nchste Scanline
		JNC	SHORT PutCircle_32
		CALL	IncRdWrBank
		JMP	SHORT PutCircle_32
;...............
PutCircle_40:
;  bertrage die Liste vorwrts nach links in das Video-Mem
;  Es ist 6 Uhr
;
		MOV	SI,OFFSET Liste
PutCircle_42:
		MOV	CL,[SI]			; CX := Lnge

		CALL	DrawLe

		SUB	DI,[BytesPerScanLine]	; ES:DI-> vorige Scanline
		JNB	SHORT PutCircle_48
		CALL	DecRdWrBank
PutCircle_48:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_42
;
;  bertrage die Liste rckwrts nach oben in das Video-Mem
;  Es ist 7 Uhr 30
;
PutCircle_50:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_52
		INC	SI
PutCircle_52:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_54
		DEC	CX
PutCircle_54:
		CALL	DrawUp
		DEC	SI
		CMP	SI,OFFSET Liste
		JB	SHORT PutCircle_60

		SUB	DI,[BytesPerPixel]	; ES:DI-> ein Pixel nach links
		JNB	SHORT PutCircle_52
		CALL	DecRdWrBank
		JMP	SHORT PutCircle_52
;...............
;  bertrage die Liste vorwrts nach oben in das Video-Mem
;  Es ist 9 Uhr
;
PutCircle_60:	MOV	SI,OFFSET Liste
PutCircle_62:
		MOV	CL,[SI]			; CX := Lnge
		CALL	DrawUp
		ADD	DI,[BytesPerPixel]	; ES:DI-> ein Pixel nach rechts
		JNC	SHORT PutCircle_64
		CALL	IncRdWrBank
PutCircle_64:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_62
;
;  bertrage die Liste rckwrts nach rechts in das Video-Mem
;  Es ist 10 Uhr 30
;
PutCircle_70:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_72
		INC	SI
PutCircle_72:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_74
		DEC	CX
PutCircle_74:
		CALL	DrawRi
		SUB	DI,[BytesPerScanLine]	; ES:DI-> vorige Scanline
		JNB	SHORT PutCircle_76
		CALL	DecRdWrBank
PutCircle_76:
		DEC	SI
		CMP	SI,OFFSET Liste
		JNB	SHORT PutCircle_72
PutCircle_80:
		MOV	SP,BP
		POP	BP
		RET	12		; Entferne 6 WORDs vom Stack
;
PutCircle	ENDP
;-------------------------------
;  Zeichnet eine Kreisscheibe ohne Verwendung von Winkelfunktionen
;  Die Mitte der Kreisscheibe liegt auf einem Pixel. Deshalb hat belegt die
;  Kreisscheibe in X- und Y-Richtung 2*R +1 Pixel.
;  Das kleinste R betrgt 2.
;
;  Bercksichtigt XorMode.
;
;  Aufruf: PutDisk (XM, YM, R, Blau, Gruen, Rot:WORD)
;---------------
Xm		EQU	WORD PTR [BP+16]
Ym		EQU	WORD PTR [BP+14]
R		EQU	WORD PTR [BP+12]
Blau		EQU	BYTE PTR [BP+10]
Gruen		EQU	BYTE PTR [BP+8]
Rot		EQU	BYTE PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
LastEntry	EQU	WORD PTR [BP-2]
FlagPixelPlus	EQU	BYTE PTR [BP-4]
;
;  Lokale CALLs: GetListe, DrawRi
;...............
PutDisk 	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,4		; 2 lokale Word Var
;
;  Erzeuge eine Liste mit den Lngenzunahmen der Horizontalen
;  Die Routine kommt mit NOCY zurck, wenn zustzliche Horizontalen um
;  10:30 und 7:30 notwendig sind.
;
		MOV	AX,[R]
		CALL	GetListe
		MOV	[LastEntry],DI
		MOV	AL,True
		JNC	SHORT PutDisk_1
		MOV	AL,False
PutDisk_1:
		MOV	[FlagPixelPlus],AL
;
;  Berechne die Adresse des 1. Byte (ber dem Nordpol) im Video-Mem
;  DXDI = BytesPerScanLine * (Ym - R - 1) + (Xm * BytesPerPixel)
;
		MOVZX	EAX,[BytesPerScanline]	; EAX = BpSl

		SUB	EDX,EDX
		MOV	DX,[Ym] 	; EDX:= Ym
		SUB	DX,[R]		; EDX:= Ym - R
		DEC	DX		; EDX:= Ym - R - 1
		MUL	EDX		; EDXEAX := BpSl * (Ym - R - 1)
;
		MOVZX	EBX,[Xm]	; EBX := Xm
		MOVZX	EDX,[BytesPerPixel]
		IMUL	EBX,EDX 	; EBX := Xm * BytesPerPixel
		ADD	EAX,EBX		; EDXEAX := BpSl * (Ym -R -1)
;						       + X * BytesPerPixel
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10		; [Byte]
		DIV	EBX		; EDX := Offset EAX := Segm
		MOV	DI,DX		; DI := Offset
		MOV	DX,AX		; DX := Segm
;
		MOV	ES,[WinASegment]
;
		SetBanks		; Setze beide Banks:= DX
;
		GetColor
;
;  Verwendung der Register:
;    EAX := Farbkomponenten fr DrawRi
;     BX := ganze Lnge der zuvor gezeichneten Sehne
;     CX := Lnge fr den Aufruf von DrawRi
;  ES:DI -> Pixel rechts neben der zuvor gezeichneten Sehne
;
;  bertrage die Liste vorwrts in das Video-Mem. Zeichne horizontale Sehnen.
;  Die halbe Lngenzunahme (Delta_L/2) von Sehne zu Sehne steht in der Liste.
;  Die Lnge der ersten Sehne betrgt nicht 2 * Delta_L, sondern 2 * Delta_L -1.
;  Deshalb beginnt der Loop mit einer vorigen Lnge von -1.
;
		MOV	SI,OFFSET Liste
		MOV	BX,-1		; Vorige Lnge = -1
		MOV	CH,0		; Hibyte der Lnge
PutDisk_4:
		MOV	CL,[SI]		; Hole Delta_L/2
		MOV	DX,[BytesPerScanLine]
		PUSH	CX
		PUSH	BX
		IMUL	BX,[BytesPerPixel]
		IMUL	CX,[BytesPerPixel]
		SUB	DX,BX		; Bpl - vorige Lnge
		SUB	DX,CX		; Bpl - vorige Lnge - Delta_L/2
		POP	BX
		POP	CX

		ADD	DI,DX		; DI-> nchste Scanline
		JNC	SHORT PutDisk_8
		CALL	IncRdWrBank
PutDisk_8:
		ADD	CX,CX		; CX = Delta_L
		ADD	CX,BX		; CX = Delta_L + alte Lnge
		MOV	BX,CX		; BX = alte lnge fr nchste Runde

		CALL	DrawRi		; Zeichne Horizontale

		INC	SI		; SI-> nchster Eintrag in Liste
		CMP	SI,[LastEntry]	; SI-> hinter letzten Eintrag
		JNA	SHORT PutDisk_4 ;  Nein, loop
;
;  bertrage die Liste rckwrts in das Video-Mem
;  Die Eintrge der Liste gelten jetzt als Hhen von Rechtecken
;  EING:    BX:= Lnge der zuletzt gezeichneten Sehne
;	 ES:DI-> rechts hinter das letzte Pixel
;
PutDisk_10:	MOV	SI,[LastEntry]		; SI-> letzter Eintrag
		CMP	[FlagPixelPlus],True	; Zustzliche Horizontale ?
		JNZ	SHORT PutDisk_12	;  Nein, skip
		INC	SI			; Ja, hinter letzten Eintrag
PutDisk_12:
		ADD	BX,2			; Jedes Rechteck 2 Pixel breiter
		ADD	DI,[BytesPerPixel]	; ES:DI-> ein Pixel nach rechts
		JNC	SHORT PutDisk_14	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_14:
		MOV	CL,[SI]			; Lobyte der Hhe
PutDisk_16:
		MOV	DX,[BytesPerScanLine]
		PUSH	BX
		IMUL	BX,[BytesPerPixel]
		SUB	DX,BX			; Bpl - Lnge
		POP	BX
		ADD	DI,DX			; ES:DI-> nchste Scanline
		JNC	SHORT PutDisk_18	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_18:
		PUSH	CX			; Rette Loopcount fr Hhe
		MOV	CX,BX			; Lnge
		CALL	DrawRi
		POP	CX

		DEC	CX			; Loop mit Hhe
		JNZ	SHORT PutDisk_16
		DEC	SI			; SI-> voriger Eintrag
		CMP	SI,OFFSET Liste 	; SI vor Listenanfang ?
		JNB	SHORT PutDisk_12	;   Nein, loop
;
;  bertrage die Liste vorwrts in das Video-Mem
;  Die Eintrge der Liste gelten wieder als Hhen von Rechtecken
;  EING:    BX:= Lnge der zuletzt gezeichneten Sehne
;	 ES:DI-> rechts hinter das letzte Pixel
;
PutDisk_20:	MOV	SI,OFFSET Liste 	; SI-> Liste
PutDisk_22:
		MOV	CL,[SI] 		; Lobyte der Hhe
		CMP	SI,OFFSET Liste 	; 1. Eintrag der Liste ?
		JNZ	SHORT PutDisk_24	;  Nein, skip
		DEC	CX			; Ja, DEC Hhe
PutDisk_24:
		MOV	DX,[BytesPerScanLine]
		PUSH	BX
		IMUL	BX,[BytesPerPixel]
		SUB	DX,BX
		POP	BX

		ADD	DI,DX			; ES:DI-> nchste Scanline
		JNC	SHORT PutDisk_26	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_26:
		PUSH	CX			; Rette Loopcount fr Hhe
		MOV	CX,BX			; CX:= Lnge
		CALL	DrawRi			; Zeichne Horizontale
		POP	CX			; Restore Loopcount fr Hhe

		DEC	CX			; Loop mit Hhe
		JNZ	SHORT PutDisk_24

		INC	SI			; SI-> nchster Eintrag
		CMP	SI,[LastEntry]		; Letzter Eintrag berschritten
		JA	SHORT PutDisk_30	; Ja, fertig

		SUB	BX,2			; Lnge -2
		SUB	DI,[BytesPerPixel]	; ES:DI-> ein Pixel nach links
		JNB	SHORT PutDisk_22	; Achte auf Bankswitch
		CALL	DecRdWrBank
		JMP	SHORT PutDisk_22
;...............
;  bertrage die Liste rckwrts in das Video-Mem
;  Zeichne horizontale Sehnen.
;  Die halbe Lngenabnahme (Delta_L/2) von Sehne zu Sehne steht in der Liste.
;  EING:    BX:= Lnge der zuletzt gezeichneten Sehne
;	 ES:DI-> rechts hinter das letzte Pixel
;
PutDisk_30:	MOV	CL,1			; Beginne mit Delta_L/2 := 1
		MOV	SI,[LastEntry]		; SI-> letzter Eintrag
		CMP	[FlagPixelPlus],True	; Zustzliche Horizontale ?
		JNZ	SHORT PutDisk_32	;  Nein, skip
		INC	SI			; Ja, SI-> hinter letzten Eintrag
PutDisk_32:
		MOV	DX,[BytesPerScanLine]
		PUSH	CX
		PUSH	BX
		IMUL	BX,[BytesPerPixel]
		IMUL	CX,[BytesPerPixel]
		SUB	DX,BX
		ADD	DX,CX
		POP	BX
		POP	CX
		ADD	DI,DX	; DI := DI + (Bpl - alte Lnge + Delta_L/2)
		JNC	SHORT PutDisk_38	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_38:
		ADD	CX,CX			; CX:= Delta_L
		SUB	BX,CX			; alte Lnge - Delta_L
		MOV	CX,BX

		CALL	DrawRi

		MOV	CL,[SI] 		; Delta_L/2

		DEC	SI			; SI-> voriger Eintrag
		CMP	SI,OFFSET Liste 	; SI-> vor Listenanfang ?
		JNB	SHORT PutDisk_32	;  Nein, loop
PutDisk_40:
		MOV	SP,BP
		POP	BP
		RET	12			; Skip 6 WORD-Variable
PutDisk 	ENDP
;-------------------------------
;  Fllt ein Sprite mit Farbe
;  Bercksichtigt XorMode
;
;  Aufruf: FillSprite (X,Y,Breite,Hoehe,Blau,Gruen,Rot:WORD);
;---------------
X		EQU	WORD PTR [BP+18]
Y		EQU	WORD PTR [BP+16]
Breite		EQU	WORD PTR [BP+14]
Hoehe		EQU	WORD PTR [BP+12]
Blau		EQU	BYTE PTR [BP+10]
Gruen		EQU	BYTE PTR [BP+8]
Rot		EQU	BYTE PTR [BP+6]
;---------------
FillSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Kehre gleich zurck, wenn Breite = 0 oder Hoehe = 0
;
		CMP	[Breite],0
		JZ	FillSprite_0
		CMP	[Hoehe],0
		JZ	FillSprite_0
;
;  Berechne ES:DI-> Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks			; Setze beide Windows := DX
;
		MOV	SI,[BytesPerScanline]
		MOV	DX,[Breite]
		IMUL	DX,[BytesPerPixel]	; DX := Breite in Byte
		SUB	SI,DX			; SI = Scanlineoffset
;
		GetColor			; EAX := Farbkomponenten
FillSprite_2:
		MOV	CX,[Breite]
		CALL	DrawRi			; Zeichne eine Horizontale

		ADD	DI,SI			; ES:DI-> nchste Scanline
		JC	SHORT FillSprite_3
FillSprite_4:
		DEC	[Hoehe]			; Loop mit Hoehe
		JNZ	SHORT FillSprite_2
FillSprite_0:
		POP	BP
		RET	14		; Entferne 7 WORDs vom Stack
;................
FillSprite_3:	CALL	IncRdWrBank
		JMP	SHORT FillSprite_4
;---------------
FillSprite	ENDP
;-------------------------------
;  Zoomt ein Rechteck auf doppelte Kantenlnge.
;  Die bertragung findet vom Save zum VGA-RAM statt.
;  Aufruf: ZoomSprite (X,Y,Breite,Hoehe:WORD; SaveAddr:POINTER);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Breite		EQU	WORD PTR [BP+12]
Hoehe		EQU	WORD PTR [BP+10]
SaveAddr	EQU	DWORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
LineCount	EQU	WORD PTR [BP-4]
LineOffset	EQU	WORD PTR [BP-6]
;---------------
ZoomSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,6		; 3 lokale Word-Variable
		MOV	[DSSave],DS
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		MOV	BL,0		; Window A
		CALL	[WinFuncPtr]
;
;  Initialisiere die lokalen Variablen
;
		MOV	AX,[Hoehe]
		SHR	AX,1
		MOV	[LineCount],AX	; LineCount := Hoehe /2
;
;  LineOffset := BpSl - Breite * BytesPerPixel
;
		MOV	AX,[BytesPerScanline]
		MOV	BX,[Breite]
		IMUL	BX,[BytesPerPixel]
		SUB	AX,BX
		MOV	[LineOffset],AX
;
;  Berechne den Offset fr das erste Byte aus dem Save
;  = (Breite * LineCount/2 + Breite/4) * BytesPerPixel
;
		MOV	AX,[LineCount]
		SHR	AX,1		; AX := LineCount /2
		MOV	BX,[Breite]	; BX := Breite
		MUL	BX		; DXAX := Breite * LineCount/2
		SHR	BX,2		; Breite/4
		ADD	AX,BX
		MUL	[BytesPerPixel]

		MOV	BX,[Breite]		; BX:= Breite
		IMUL	BX,[BytesPerPixel]	; BX:= Breite * BytesPerPixel
;
;  Unterscheide zwischen 3 und 4 BytesPerPixel
;
		CMP	[BytesPerPixel],4
		JZ	ZoomSprite_400
;
;  Wir haben 3 BytesPerPixel
;
ZoomSprite_300: LDS	SI,[SaveAddr]	; DS:SI-> Save
		ADD	SI,AX		; DS:SI-> 1.Byte
ZoomSprite_302:
		MOV	DX,2		; Anzahl Durchlufe/Zeile
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
ZoomSprite_304:	ADD	DI,BX		; + Breite * BytesPerPixel
		JC	SHORT ZoomSprite_310
		SUB	DI,BX		; - Breite * BytesPerPixel
;
;  Zoom eine Zeile zum Video-Mem
;
		PUSH	SI		; Rette SI-> Zeilenanfang
		PUSH	BX		; Rette BX = Breite * BytesPerPixel
		MOV	CX,[Breite]	; Anzahl Pixel/Zeile
		SHR	CX,1
ZoomSprite_306:
		LODSW			; Hole das Pixel vom Save
		MOV	BL,[SI]
		INC	SI

		STOSW			; Bringe das Pixel zum Video-Mem
		MOV	ES:[DI],BL
		INC	DI
		STOSW			; Bringe das Pixel nochmal zum Video-Mem
		MOV	ES:[DI],BL
		INC	DI

		DEC	CX		; Loop mit der Anzahl Pixel je Zeile
		JNZ	SHORT ZoomSprite_306
;
		POP	BX		; Restore BX = Breite * BytesPerPixel
		POP	SI		; Restore SI-> Zeilenanfang
		ADD	DI,[LineOffset]
		JNC	SHORT ZoomSprite_308

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_308:
		DEC	DX		; Loop mit Anzahl Durchlufe/Zeile
		JNZ	SHORT ZoomSprite_304
		ADD	SI,BX		; + Breite * BytesPerPixel
		DEC	[LineCount]	; Loop mit Anzahl Scanlines
		JNZ	SHORT ZoomSprite_302
;
;  Rume den Stack auf
;
ZoomSprite_0:	MOV	DS,[DSSave]
		MOV	SP,BP
		POP	BP
		RET	12		; Entferne 4 WORDs und 1 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig.
;  Der Bankswitch kann uns bei jedem Byte erwischen.
;  Schreibe deshalb byteweise und achte jedesmal auf Bankswitch.
;
;  Zoom eine Zeile zum Video-Mem
;
ZoomSprite_310:	SUB	DI,BX		; ES:DI-> alte Bank

		PUSH	SI		; Rette SI-> Zeilenanfang
		PUSH	BX		; Rette BX = Breite * BytesPerPixel
		MOV	CX,[Breite]	; Anzahl Pixel/Zeile
		SHR	CX,1
;
;  Hole ein Pixel vom Save
;
ZoomSprite_312:	LODSW
		MOV	BL,[SI]
		INC	SI
;
;  Bringe das Pixel zum Video-Mem
;
		MOV	ES:[DI],AL
		INC	DI
		JNZ	SHORT ZoomSprite_314

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_314:
		MOV	ES:[DI],AH
		INC	DI
		JNZ	SHORT ZoomSprite_316

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_316:
		MOV	ES:[DI],BL
		INC	DI
		JNZ	SHORT ZoomSprite_318

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_318:
;
;  Bringe das Pixel nochmal zum Video-Mem
;
		MOV	ES:[DI],AL
		INC	DI
		JNZ	SHORT ZoomSprite_320

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_320:
		MOV	ES:[DI],AH
		INC	DI
		JNZ	SHORT ZoomSprite_322

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_322:
		MOV	ES:[DI],BL
		INC	DI
		JNZ	SHORT ZoomSprite_324

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_324:
		DEC	CX		; Loop mit der Anzahl Pixel je Zeile
		JNZ	SHORT ZoomSprite_312
;
;  Berechne Startadr der nchsten Zeile (Nicht schon wieder Bankswitch)
;
		ADD	DI,[LineOffset]
		POP	BX		; Restore BX = Breite * BytesPerPixel
		POP	SI		; Restore SI-> Zeilenanfang
		JMP	SHORT ZoomSprite_308
;-------------------------------
;  Wir haben 4 BytesPerPixel
;
ZoomSprite_400: LDS	SI,[SaveAddr]	; DS:SI-> Save
		ADD	SI,AX		; DS:SI-> 1.Byte
ZoomSprite_402:
		MOV	DX,2		; Anzahl Durchlufe/Zeile
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
ZoomSprite_404:	ADD	DI,BX		; + Breite * BytesPerPixel
		JC	SHORT ZoomSprite_410
		SUB	DI,BX		; - Breite * BytesPerPixel
;
;  Zoom eine Zeile zum Video-Mem
;
		PUSH	SI		; Rette SI-> Zeilenanfang
		PUSH	BX		; Rette BX = Breite * BytesPerPixel
		MOV	CX,[Breite]	; Anzahl Pixel/Zeile
		SHR	CX,1
ZoomSprite_406:
		LODSD			; Hole das Pixel vom Save
		STOSD			; Bringe das Pixel zum Video-Mem..
		STOSD			; ..und nochmal
		DEC	CX		; Loop mit der Anzahl Pixel je Zeile
		JNZ	SHORT ZoomSprite_406
;
		POP	BX		; Restore BX = Breite * BytesPerPixel
		POP	SI		; Restore SI-> Zeilenanfang
		ADD	DI,[LineOffset]
		JNC	SHORT ZoomSprite_408

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_408:
		DEC	DX		; Loop mit Anzahl Durchlufe/Zeile
		JNZ	SHORT ZoomSprite_404
		ADD	SI,BX		; + Breite * BytesPerPixel
		DEC	[LineCount]	; Loop mit Anzahl Scanlines
		JNZ	SHORT ZoomSprite_402
;
;  Rume den Stack auf und return
;
		JMP	ZoomSprite_0
;................
;  Whrend einer Zeile ist Bankswitch notwendig.
;  Der Bankswitch kann uns nach jedem Pixel erwischen.
;
;  Zoom eine Zeile zum Video-Mem
;
ZoomSprite_410:	SUB	DI,BX		; ES:DI-> alte Bank
		PUSH	SI		; Rette SI-> Zeilenanfang
		PUSH	BX		; Rette BX = Breite * BytesPerPixel
		MOV	CX,[Breite]	; Anzahl Pixel/Zeile
		SHR	CX,1
;
;  Hole ein Pixel vom Save
;
ZoomSprite_412:	LODSD
;
;  Bringe das Pixel zum Video-Mem
;
		STOSD
		OR	DI,DI		; DI = 0 ?
		JNZ	SHORT ZoomSprite_414

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_414:
;
;  Bringe das Pixel nochmal zum Video-Mem
;
		STOSD
		OR	DI,DI		; DI = 0 ?
		JNZ	SHORT ZoomSprite_416

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
ZoomSprite_416:
		DEC	CX		; Loop mit der Anzahl Pixel je Zeile
		JNZ	SHORT ZoomSprite_412
;
;  Berechne Startadr der nchsten Zeile (Nicht schon wieder Bankswitch)
;
		ADD	DI,[LineOffset]
		POP	BX		; Restore BX = Breite * BytesPerPixel
		POP	SI		; Restore SI-> Zeilenanfang
		JMP	SHORT ZoomSprite_408
;...............
ZoomSprite	ENDP
;-------------------------------
;  bertrgt ein Sprite vom Video-Mem in das DOS-Mem
;
;  Aufruf: GetSprite (X,Y,Breite,Hoehe:WORD; SaveAddr:POINTER);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Breite		EQU	WORD PTR [BP+12]
Hoehe		EQU	WORD PTR [BP+10]
SaveAddr	EQU	DWORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
;---------------
GetSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,2		; 1 lokales Word
		MOV	[DSSave],DS
;
;  Berechne die Adresse der oberen linken Ecke
;  DXSI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
		MOV	SI,DI
;
;  Suche nach einem lesbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,1		; Bit#0 = Lesbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
;
;  Berechne die Scanlinedifferenz AX := BytePerLine - BytesPerPixel*Breite
;
		MOV	AX,[BytesPerScanline]
		MOV	BX,[Breite]		; BX := Breite
		IMUL	BX,[BytesPerPixel]	; BX := Breite in Byte
		SUB	AX,BX		; AX := BytePerLine-Breite*BytesPerPixel
;
		CLD				; String aufwrts

		MOV	DS,[WinASegment]	; DS:SI-> Video-Mem
		LES	DI,[SaveAddr]		; ES:DI-> Save

		ALIGN	4
GetSprite_2:
;  bertrage eine Zeile vom Video-Mem zum DOS-Mem
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		ADD	SI,BX
		JC	SHORT GetSprite_3
		SUB	SI,BX
;
;  Wir mssen nicht mit Bankswitch rechnen
;  Unterscheide zwischen gerader und ungerader Startadresse im Video-Mem
;
		TEST	SI,1
		JZ	SHORT GetSprite_4
;
;  Wir haben eine ungerade Startadresse im Video-Mem
;  bertrage erst ein Byte, dann wordweise und bei geraden Bytecount
;  noch ein Byte.
;
		MOV	CX,BX		; CX = Bytecount
		MOVSB			; Erst ein Byte..
		DEC	CX
		SHR	CX,1		; CX = Wordcount
		REP	MOVSW		; ...dann wordweise..
		RCL	CX,1		; ..und dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
		JMP	SHORT GetSprite_44
;...............
;  Wir haben eine gerade Startadresse im Video-Mem
;
GetSprite_4:	MOV	CX,BX		; CX = Bytecount
		SHR	CX,1		; CX = Wordcount
		REP	MOVSW		; Erst wordweise
		RCL	CX,1		; Dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
;
;  Berechne die ADR der nchsten Zeile und achte auf Bankswitch
;
GetSprite_44:	ADD	SI,AX		; SI-> nchste Zeile
		JC	SHORT GetSprite_5
GetSprite_6:
		DEC	[Hoehe]		; LOOP mit Zeilenzahl
		JNZ	SHORT GetSprite_2
;
;  Rume den Stack auf
;
GetSprite_0:	MOV	DS,[DSSave]
		MOV	SP,BP
		POP	BP
		RET	12	; Entferne 4 WORDs und 1 POINTER vom Stack
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  SI hat die Anzahl Byte in der nchsten Bank
;
GetSprite_3:	MOV	DX,SI		; DX = Anzahl Byte in neuer Bank
		SUB	SI,BX		; SI-> alte Bank
		MOV	CX,BX		; CX := Breite
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
		REP	MOVSB		; 1. Teil der Zeile...

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank	; ... Bankswitch...
		POP	DS

		MOV	CX,DX		; Bytezahl fr 2. Teil
		REP	MOVSB		; 2. Teil der Zeile
;
;  Berechne Startadr der nchsten Zeile
;
		ADD	SI,AX
		DEC	[Hoehe] 	; Dec Zeilenzahl
		JNZ	SHORT GetSprite_2
		JMP	SHORT GetSprite_0
;...............
GetSprite_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank
		POP	DS
		JMP	SHORT GetSprite_6
GetSprite	ENDP
;-------------------------------
;  bertrgt ein Sprite vom DOS-Mem zum Video-Mem
;
;  Aufruf: PutSprite (X,Y,Breite,Hoehe:WORD; SaveAddr:POINTER);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Breite		EQU	WORD PTR [BP+12]
Hoehe		EQU	WORD PTR [BP+10]
SaveAddr	EQU	DWORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
;---------------
PutSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,2		; 1 lokales Word
		MOV	[DSSave],DS
;
;  Berechne die Adresse der oberen linken Ecke
;  DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel);	ES:= [WinASegment]
;
		GetScreenAddr
;
;  Setze das Window := DX
;
		MOV	BH,0			; Window setzen
		MOV	BL,0			; Window A

		CALL	[WinFuncPtr]
;
;  Berechne die Scanlinedifferenz AX := BytePerLine - BytesPerPixel*Breite
;
		MOV	AX,[BytesPerScanline]
		MOV	BX,[Breite]		; BX := Breite
		IMUL	BX,[BytesPerPixel]	; BX := Breite in Byte
		SUB	AX,BX		; AX := BytePerLine-BytesPerPixel*Breite

		LDS	SI,[SaveAddr]		; DS:SI-> Save
		CLD				; String aufwrts
		ALIGN	4
PutSprite_2:
;
;  bertrage eine Zeile vom DOS-Mem zum Video-Mem
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		ADD	DI,BX
		JC	SHORT PutSprite_3
		SUB	DI,BX
;
;  Wir mssen nicht mit Bankswitch rechnen
;  Unterscheide zwischen gerader und ungerader Startadresse im Video-Mem
;
		TEST	DI,1
		JZ	SHORT PutSprite_4
;
;  Wir haben eine ungerade Startadresse im Video-Mem
;  bertrage erst ein einzelnes Byte, dann Words und bei gerader Bytezahl
;  noch ein Byte
;
		MOV	CX,BX		; CX:= Bytecount
		MOVSB			; bertrage ein Byte
		DEC	CX		; DEC Bytecount
		SHR	CX,1		; CX = Wordcount
		REP	MOVSW		; Erst wordweise..
		RCL	CX,1		; ..dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
		JMP	SHORT PutSprite_44
;...............
;  Wir haben eine gerade Startadresse im Video-Mem
;  bertrage Words und bei ungerader Bytezahl dann noch ein Byte
;
PutSprite_4:	MOV	CX,BX		; CX = BytesPerPixel*Breite (Byte)
		SHR	CX,1		; CX = Wordcount
		REP	MOVSW		; Erst wordweise
		RCL	CX,1		; Dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
;
;  Berechne die ADR der nchsten Zeile und achte auf Bankswitch
;
PutSprite_44:	ADD	DI,AX			; DI-> nchste Zeile
		JC	SHORT PutSprite_5	; Achte auf Bankswitch
PutSprite_6:
		DEC	[Hoehe] 		; LOOP mit Zeilenzahl
		JNZ	SHORT PutSprite_2
;
;  Rume den Stack auf
;
PutSprite_0:	MOV	DS,[DSSave]
		MOV	SP,BP
		POP	BP
		RET	12	; Entferne 4 WORDs und 1 POINTER vom Stack
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  DI hat die Anzahl Byte in der nchsten Bank
;
PutSprite_3:	MOV	DX,DI		; DX = Anzahl Byte in neuer Bank
		SUB	DI,BX		; DI-> alte Bank
		MOV	CX,BX		; CX := Breite
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
		REP	MOVSB		; bertrage 1.Teil der Zeile
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank	; Nchste Bank
		POP	DS
;
		MOV	CX,DX
		REP	MOVSB		; bertrage 2.Teil der Zeile
;
;  Berechne Startadr der nchsten Zeile
;
		ADD	DI,AX
		DEC	[Hoehe]		; Zeilenzahl -1
		JNZ	SHORT PutSprite_2
		JMP	SHORT PutSprite_0
;...............
PutSprite_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
		JMP	SHORT PutSprite_6
PutSprite	ENDP
;-------------------------------
;  bertrgt ein Sprite vom Video-Mem in einen File.
;  Die bertragung findet zunchst vom Video-Mem zeilenweise in einen Buffer
;  statt. Bufferlage und Gre ist von TP aus whlbar und beeinflut die
;  Laufzeit der PROC (mehr Buffer = schneller). DOS schreibt dann vom Buffer
;  zum File.
;
;  Der File enthlt keinen Header und keine Palette (wie ein .BMP-File).
;
;  Aufruf: Sprite2FileB (X,Y,Breite,Hoehe:WORD;
;			VAR Pathname:STRING; VAR ErrCode:WORD);
;			   BufferPtr:POINTER; BufferSize:WORD);
;---------------
X		EQU	WORD PTR [BP+26]
Y		EQU	WORD PTR [BP+24]
Breite		EQU	WORD PTR [BP+22]
Hoehe		EQU	WORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
ByteBreite	EQU	WORD PTR [BP-10]
;-------------------------------
Sprite2File	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,10		; 5 lokale Word-Variable
;...............................
;  Init die lokalen Variablen
;...............................
		MOV	[DSSave],DS
;
;  ByteBreite:=Breite*BytesPerPixel
;
		MOV	AX,[Breite]
		IMUL	AX,[BytesPerPixel]
		MOV	[ByteBreite],AX
;
;  LineDiff:= BytesPerScanLine-ByteBreite (AX hat noch ByteBreite)
;
		MOV	BX,[BytesPerScanLine]
		SUB	BX,AX
		MOV	[LineDiff],BX

		MOV	[BufferInhalt],0
;...............................
;  Kreiere einen File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	CX,0			; Fileattribute: Normal
		MOV	AH,3CH			; Function: Create Handle
		INT	21H			; DOS-Aufruf
		JC	Sprite2File_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXSI = (Y * BytesPerScanLine) + X * BytesPerPixel	ES:= [WinASegment]
;...............................
		MOV	DS,[DSSave]
		GetScreenAddr
		MOV	SI,DI
;
		SetBanks		; Setze das Window := DX
;...............................
;  Setze Zeiger	DS:SI-> Video-Mem und ES:DI-> Buffer
;...............................
		MOV	DS,[WinASegment]; DS:SI-> Video-Mem
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
Sprite2File_2:
;...............................
;  bertrage eine Zeile des Sprite vom Video-Mem zum Buffer
;...............................
;  Wenn BufferInhalt + ByteBreite <= BufferSize
;   dann pat die folgende Zeile noch in den Buffer
;
		MOV	AX,[BufferInhalt]
		ADD	AX,[ByteBreite]
		CMP	AX,[BufferSize]
		JNA	SHORT Sprite2File_4
;
;  Die Zeile pat nicht mehr in den Buffer
;  Schreibe den BufferInhalt zum File
;
		PUSH	DS			; Rette DS-> Video-Mem
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to write
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		POP	DS			; Restore DS-> Video-Mem
		JC	SHORT Sprite2File_0	; DOS-Aufruf fehlgeschlagen ?
;
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
		MOV	AX,[ByteBreite]	; Bereite BufferInhalt := ByteBreite vor
Sprite2File_4:
		MOV	[BufferInhalt],AX
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		MOV	CX,[ByteBreite]
		ADD	SI,CX
		JC	SHORT Sprite2File_3
		SUB	SI,CX
;
;  bertrage eine Zeile vom Video-Mem zum Buffer
;  Jetzt ist: DS:SI-> Video-Mem
;	      ES:DI-> Buffer
;		 CX = ByteBreite
;
		CLD				; String aufwrts
		REP	MOVSB
;...............................
;  Bestimme die ADR der nchsten Zeile des Sprite
;...............................
		ADD	SI,[LineDiff]
		JC	SHORT Sprite2File_5
Sprite2File_6:
;...............................
;  LOOP mit Hoehe
;...............................
		DEC	[Hoehe]
		JNZ	SHORT Sprite2File_2
;...............................
;  Schreibe den restlichen BufferInhalt zum File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer

		MOV	CX,[BufferInhalt]
		JCXZ	Sprite2File_8		; BufferInhalt = 0 ?
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2File_0	;  fehlgeschlagen ?
Sprite2File_8:
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
		MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2File_0	;  fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
Sprite2File_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr] ; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
;  Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]	;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	22		; Entferne 5 WORDs und 3 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  SI hat die Anzahl Byte in der nchsten Bank
;
Sprite2File_3:	MOV	DX,SI		; DX = Anzahl Byte in neuer Bank
		MOV	CX,[ByteBreite]	; CX := ByteBreite
		SUB	SI,CX		; SI-> alte Bank
		SUB	CX,DX		; CX := ByteBreite - Byte in neuer Bank
;
		REP	MOVSB		; 1. Teil der Zeile...
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank	; ... Bankswitch...
		POP	DS
;
		MOV	CX,DX		; Bytezahl fr 2. Teil
		REP	MOVSB		; 2. Teil der Zeile
;
;  Berechne Startadr der nchsten Zeile (Nicht schon wieder Bankswitch)
;
		ADD	SI,[LineDiff]
		JMP	SHORT Sprite2File_6
;...............
Sprite2File_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank
		POP	DS
		JMP	SHORT Sprite2File_6
;...............
Sprite2File	ENDP
;-------------------------------
;  bertrgt ein Sprite vom Video-Mem in einen .BMP-File.
;  Die bertragung findet zunchst vom Video-Mem zeilenweise in einen Buffer
;  statt. Bufferlage und Gre ist von TP aus whlbar und beeinflut die
;  Laufzeit der PROC (mehr Buffer = schneller). Der Buffer enthlt mehrere,
;  immer vollstndige Zeilen des Sprite.
;  DOS schreibt dann vom Buffer zum File.
;
;  Die Reihenfolge der drei Farbkomponenten im .BMP-File ist Blau:Grn:Rot.
;  Im Video-Mem ist die Reihenfolge dagegen durch Red/Green/BlueFieldPosition
;  festgelegt, die nicht unbedingt mit der des .BMP-Files bereinstimmen
;  mu. Deshalb sind die 3 Komponenten bei der bertragung vom Video-Mem
;  in den Buffer in die richtige Reihenfolge zu bringen.
;
;  Der File enthlt einen .BMP-Header.
;
;  Aufruf: Sprite2Bmp (X,Y,Breite,Hoehe:WORD;
;			   VAR Pathname:STRING; VAR ErrCode:WORD);
;			      BufferPtr:POINTER; BufferSize:WORD);
;---------------
X		EQU	WORD PTR [BP+26]
Y		EQU	WORD PTR [BP+24]
Breite		EQU	WORD PTR [BP+22]
Hoehe		EQU	WORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
FileBreiteBytes	EQU	WORD PTR [BP-10]   ; Breite des Sprite im File in Bytes
SpriBreiteBytes EQU	WORD PTR [BP-12]   ; Breite des Sprite a. d. Bildschirm
RestBytes	EQU	WORD PTR [BP-14]   ; FileBreitebyte - SpriBreiteBytes
;-------------------------------
Sprite2Bmp	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,14		; 7 lokale Word-Variable
;...............................
;  Init die lokalen Variablen
;...............................
		MOV	[DSSave],DS
;
;  SpriBreiteBytes:= Breite * BytesPerPixel
;
		MOV	AX,[Breite]
		IMUL	AX,[BytesPerPixel]
		MOV	[SpriBreiteBytes],AX
;
;  LineDiff:= BytesPerScanLine+SpriBreiteBytes (AX hat SpribreiteBytes)
;
		ADD	AX,[BytesPerScanLine]
		MOV	[LineDiff],AX
;
;  Wenn 3*Breite mod 4 <> 0,
;		dann FileBreiteBytes := (3*Breite mod 4) + 4
;  Sonst FileBreiteBytes := 3*Breite
;
		MOV	AX,[Breite]
		IMUL	AX,3		; AX:= 3*Breite
		MOV	BX,AX		; Fr spter
		TEST	AL,3
		JZ	SHORT Sprite2BMP_1
		AND	AL,NOT 3
		ADD	AX,4
Sprite2BMP_1:
		MOV	[FileBreiteBytes],AX
;
;  RestBytes:= 3*Breite AND 3
;
		SUB	AX,BX
		MOV	[RestBytes],AX
;
;  Bufferinhalt := 0
;
		MOV	[BufferInhalt],0
;...............................
;  Kreiere einen File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	CX,0			; Fileattribute: Normal
		MOV	AH,3CH			; Function: Create Handle
		INT	21H			; DOS-Aufruf
		JC	Sprite2BMP_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Bilde im Buffer @ BufferPtr den Header des .BMP-Files
;...............................
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
		SUB	EAX,EAX
		MOV	CX,36H/4
		REP	STOSD

		LDS	DI,[BufferPtr]	; DS:DI-> Buffer
		MOV	AL,'B'
		MOV	AH,'M'
		MOV	[DI],AX		; #0	Kennung 'BM'
;
		MOV	AX,[Breite]
		MOV	[DI+12H],AX	; #12	Breite
		MOV	AX,[Hoehe]
		MOV	[DI+16H],AX	; #16	Hhe

		MUL	[FileBreiteBytes]; DXAX = FileBreiteBytes * Hoehe
		ADD	AX,36H
		ADC	DX,0		; DXAX = Filelnge
;
		MOV	[DI+2],AX
		MOV	[DI+4],DX	; #2   Filelnge
;
		MOV	AX,36H
		MOV	[DI+0AH],AX	; #A	Offset Datenbereich

		MOV	AX,28H
		MOV	[DI+0EH],AX	; #E	Lnge Info Header
;
		MOV	AX,1
		MOV	[DI+1AH],AX	; #1A	Farbebenen
;
		MOV	AX,24
		MOV	[DI+1CH],AX	; #1C	Bit/Pel
;
;  Schreibe den Header in den .BMP-File
;
		MOV	DX,DI		; DS:DX-> Buffer
		MOV	CX,36H		; Bytes to write
		MOV	BX,[FileHandle]	; BX = HANDLE
		MOV	AH,40H		; Function: Write Handle
		INT	21H		; DOS-Aufruf
		JC	Sprite2Bmp_0	;  fehlgeschlagen ?
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXSI = ((Y+Hoehe-1) * BytesPerScanLine) + X * BytesPerPixel
;  GetScreenAddr ist ungeeignet, weil wir die untere linke Ecke brauchen
;...............................
		MOV	DS,[DSSave]

		MOVZX	EAX,[BytesPerScanline]
		MOVZX	EDX,[Y]			; EDX:= Y
		ADD	DX,[Hoehe]		; EDX:= Y+Hoehe
		DEC	DX			; EDX:= Y+Hoehe-1
		MUL	EDX	; EDXEAX:= BytesPerScanLine * (Y+Hoehe-1)
;
		MOVZX	EBX,[X]			; EBX:= X
		IMUL	BX,[BytesPerPixel]	; EBX:= X * BytesPerPixel
		ADD	EAX,EBX
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10			; [Byte]
		DIV	EBX			; EDX := Offset   EAX := Segm
		MOV	SI,DX			; SI := Offset
		MOV	DX,AX			; DX := Segm
;
		SetBanks			; Setze das Window := DX
;...............................
;  Setze Zeiger	FS:SI-> Video-Mem und ES:DI-> Buffer
;...............................
		MOV	FS,[WinASegment]; FS:SI-> Video-Mem
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
Sprite2Bmp_2:
;...............................
;  bertrage eine Zeile des Sprite vom Video-Mem zum Buffer
;...............................
;  Wenn BufferInhalt + FileBreiteBytes <= BufferSize
;   dann pat die folgende Zeile noch in den Buffer
;
		MOV	AX,[BufferInhalt]
		ADD	AX,[FileBreiteBytes]
		CMP	AX,[BufferSize]
		JNA	SHORT Sprite2Bmp_4
;
;  Die Zeile pat nicht mehr in den Buffer
;  Schreibe den BufferInhalt zum File
;
		PUSH	DS			; Rette DS-> Video-Mem
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to write
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		POP	DS			; Restore DS-> Video-Mem
		JC	Sprite2Bmp_0		; DOS-Aufruf fehlgeschlagen ?
;
		LES	DI,[BufferPtr]		; ES:DI-> Buffer
		MOV	AX,[FileBreiteBytes]	; Bereite BufferInhalt := FileBreite vor
Sprite2Bmp_4:
		MOV	[BufferInhalt],AX

		MOV	DX,[Breite]
;
;  Die Zeile pat sicher in den Buffer.
;  Beginne mit der bertragung einer Zeile vom Video-Mem zum Buffer.
;  Jetzt ist: FS:SI-> Video-Mem
;	      ES:DI-> Buffer
;		 DS-> .ASM 'Data'
;		 DX = Breite
;
Sprite2Bmp_40:	CLD			; String aufwrts
		MOV	AL,FS:[SI]	; Hole Komponente A vom Video-Mem
		INC	SI			; Inc FS:SI-> Video-Mem
		JNZ	SHORT Sprite2Bmp_42	; Achte auf Bankswitch
		CALL	IncRdBank
Sprite2Bmp_42:
		MOV	AH,FS:[SI]	; Hole Komponente B vom Video-Mem
		INC	SI			; Inc FS:SI-> Video-Mem
		JNZ	SHORT Sprite2Bmp_44	; Achte auf Bankswitch
		CALL	IncRdBank
Sprite2Bmp_44:
		MOV	BL,FS:[SI]	; Hole Komponente C vom Video-Mem
		INC	SI			; Inc FS:SI-> Video-Mem
		JNZ	SHORT Sprite2Bmp_46	; Achte auf Bankswitch
		CALL	IncRdBank
Sprite2Bmp_46:
;
;  Wenn wir 4 BytesPerPixel haben, dann INC FS:SI-> Video-Mem
;
		CMP	[BytesPerPixel],3
		JZ	SHORT Sprite2Bmp_48
		INC	SI			; Inc FS:SI-> Video-Mem
		JNZ	SHORT Sprite2Bmp_48	; Achte auf Bankswitch
		CALL	IncRdBank
Sprite2Bmp_48:
		SHL	EBX,16
		MOV	BX,AX			; EBX:= 0:C:B:A

		MOV	EAX,EBX 		; EAX:= 0:C:B:A
		MOV	CL,[BlueFieldPosition]
		SHR	EAX,CL			; AL:= Blau
		STOSB				; Bringe zum Buffer

		MOV	EAX,EBX 		; EAX:= 0:C:B:A
		MOV	CL,[GreenFieldPosition]
		SHR	EAX,CL			; AL:= Grn
		STOSB				; Bringe zum Buffer

		MOV	EAX,EBX 		; EAX:= 0:C:B:A
		MOV	CL,[RedFieldPosition]
		SHR	EAX,CL			; AL:= Rot
		STOSB				; Bringe zum Buffer

		DEC	DX
		JNZ	SHORT Sprite2Bmp_40	; Loop mit Breite

		MOV	AL,0			; Flle den Rest mit 0
		MOV	CX,[RestBytes]
		REP	STOSB
;...............................
;  Bestimme die Adr der nchsten Zeile des Sprite im Video-Mem
;...............................
		SUB	SI,[LineDiff]
		JNB	SHORT Sprite2Bmp_6	; Achte auf Bankswitch
		CALL	DecRdBank
Sprite2Bmp_6:
;...............................
;  LOOP mit Hoehe
;...............................
		DEC	[Hoehe]
		JNZ	Sprite2Bmp_2
;...............................
;  Schreibe den restlichen BufferInhalt zum File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer

		MOV	CX,[BufferInhalt]
		JCXZ	Sprite2Bmp_8		; BufferInhalt = 0 ?
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2Bmp_0	;  fehlgeschlagen ?
Sprite2Bmp_8:
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
Sprite2BMP_7:	MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2Bmp_0	;  fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
Sprite2Bmp_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr] ; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
;  Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]	;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	22		; Entferne 5 WORDs und 3 POINTER
;................
Sprite2Bmp	ENDP
;--------------------------------
;  Liest von einem File in ein Sprite.
;  DOS liest das Sprite in Stcken vom File in einen Buffer. Bufferlage und
;  Gre ist von TP aus whlbar und beeinflut die Laufzeit der PROC (mehr
;  Buffer = schneller). Der Buffer enthlt eine Anzahl vollstndiger Zeilen
;  des Sprite. Anschlieend findet die bertragung aus dem Buffer zum
;  Video-Mem statt.
;
;  Der File enthlt keinen Header und keine Farbe Register (wie ein .BMP-File).
;
;  Aufruf: File2SpriteB (X,Y,Breite,Hoehe:WORD;
;			VAR Pathname:STRING; VAR ErrCode:WORD);
;			   BufferPtr:POINTER; BufferSize:WORD);
;---------------
;  Stackaufbau:
X		EQU	WORD PTR [BP+26]
Y		EQU	WORD PTR [BP+24]
Breite		EQU	WORD PTR [BP+22]
Hoehe		EQU	WORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
LinesPerBuffer	EQU	WORD PTR [BP-10]
LineCount	EQU	WORD PTR [BP-12]
ByteBreite	EQU	WORD PTR [BP-14]
;-----------------------
File2Sprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,14		; 7 lokale Word-Variable
;...............................
;  Init die lokalen Variablen
;...............................
		MOV	[DSSave],DS
;
;  ByteBreite:= Breite * BytesPerPixel
;
		MOV	AX,[Breite]
		IMUL	AX,[BytesPerPixel]
		MOV	[ByteBreite],AX
;
;  LineDiff:= BytesPerScanLine-ByteBreite (AX hat noch ByteBreite)
;
		MOV	BX,[BytesPerScanLine]
		SUB	BX,AX
		MOV	[LineDiff],BX
;
;  LinesPerBuffer := LineCount := BufferSize / Breite
;
		MOV	AX,[BufferSize]
		SUB	DX,DX
		DIV	[ByteBreite]
		MOV	[LinesPerBuffer],AX
		MOV	[LineCount],AX
;
;  BufferInhalt := LinesPerBuffer * ByteBreite (AX hat LinesPerBuffer)
;
		MUL	[ByteBreite]
		MOV	[BufferInhalt],AX
;...............................
;  ffne den File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	AL,2			; Fileattr = Normal
		MOV     AH,3DH                  ; Function: Open Handle
		INT	21H			; DOS-Aufruf
		JC	File2Sprite_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + (X*BytesPerPixel)   ES:= [WinASegment]
;...............................
		MOV	DS,[DSSave]
		GetScreenAddr
;
		SetBanks		; Setze beide Windows:= DX
;...............................
;  Lies einen Buffer vom File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT File2Sprite_0	; fehlgeschlagen ?
;...............................
;  Setze Zeiger	ES:DI-> Video-Mem und DS:SI-> Buffer
;...............................
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;...............................
;  bertrage eine Zeile vom Buffer zum Video-Mem
;...............................
File2Sprite_2:
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		MOV	CX,[ByteBreite]
		ADD	DI,CX
		JC	SHORT File2Sprite_3
		SUB	DI,CX
;
;  Das Zeilenende liegt noch in der momentanen Bank
;  bertrage eine Zeile vom Buffer zum Video-Mem
;  Jetzt ist: DS:SI-> Buffer
;	      ES:DI-> Video-Mem
;		 CX = ByteBreite
;
		CLD				; String aufwrts
		REP	MOVSB
;...............................
;  Bestimme die Adr der nchsten Zeile des Sprite im Video-Mem
;...............................
		ADD	DI,[LineDiff]
		JC	SHORT File2Sprite_5
File2Sprite_6:
;...............................
;  Sieh nach, ob die nchste Zeile noch im Buffer enthalten ist
;...............................
		DEC	[LineCount]
		JNZ	SHORT  File2Sprite_8
;
;  Die nchste Zeile ist nicht mehr im Buffer enthalten
;  Lies einen weiteren Buffer vom File
;
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT File2Sprite_0	; fehlgeschlagen ?
;
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;
		MOV	AX,[LinesPerBuffer]
		MOV	[LineCount],AX		; LineCount := LinesPerBuffer
;...............................
;  LOOP mit Hoehe
;...............................
File2Sprite_8:	DEC	[Hoehe]
		JNZ	SHORT File2Sprite_2
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
		MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT File2Sprite_0	; fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
File2Sprite_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr] 	; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
;  Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]		;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	22		; Entferne 5 WORDs und 3 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  Jetzt ist: DI = Anzahl Byte in der nchsten Bank
;	      CX = ByteBreite
;
File2Sprite_3:	MOV	DX,DI		; DX = Anzahl Byte in neuer Bank
		SUB	DI,CX		; DI-> alte Bank
		SUB	CX,DX		; CX := ByteBreite - Byte in neuer Bank
;
;  bertrage den 1. Teil der Zeile
;
		CLD
		REP	MOVSB
;
;  Inkrementiere Write-Bank
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
;
;  bertrage den 2. Teil der Zeile
;
		MOV	CX,DX
		REP	MOVSB
;
;  Berechne Startadr der nchsten Zeile (Nicht schon wieder Bankswitch)
;
		ADD	DI,[LineDiff]
		JMP	SHORT File2Sprite_6
;...............
File2Sprite_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
		JMP	SHORT File2Sprite_6
;...............
File2Sprite	ENDP
;-------------------------------
;  bertrgt ein Sprite von einem .BMP-File zum Video-Mem.
;
;  DOS liest das Sprite in Stcken vom File in einen Buffer. Bufferlage und
;  Gre ist von TP aus whlbar und beeinflut die Laufzeit der PROC (mehr
;  Buffer = schneller). Der Buffer mehrere vollstndige Zeilen des Sprite.
;  Anschlieend findet die bertragung aus dem Buffer zum Video-Mem statt.
;
;  Die Reihenfolge der drei Farbkomponenten im .BMP-File ist Blau:Grn:Rot.
;  Im Video-Mem ist die Reihenfolge dagegen durch Red/Green/BlueFieldPosition
;  festgelegt, die nicht unbedingt mit der des .BMP-Files bereinstimmen
;  mu. Deshalb sind die 3 Komponenten bei der bertragung vom Buffer
;  zum Video-Mem in die richtige Reihenfolge zu bringen.
;
;  Der File besitzt einen .BMP-Header, in dem u.a. die Breite und Hhe des
;  enthalten sind. Die PROC liefert diese beiden Werte an TP zurck.
;
;  Aufruf: Bmp2Sprite (X,Y:WORD; VAR Breite,Hoehe:WORD;
;			   VAR Pathname:STRING; VAR ErrCode:WORD);
;			      BufferPtr:POINTER; BufferSize:WORD);
;---------------
;  Stackaufbau:
X		EQU	WORD PTR [BP+30]
Y		EQU	WORD PTR [BP+28]
BreitePtr	EQU	DWORD PTR [BP+24]
HoehePtr	EQU	DWORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
LinesPerBuffer	EQU	WORD PTR [BP-10]
LineCount	EQU	WORD PTR [BP-12]
Hoehe		EQU	WORD PTR [BP-14]
Breite		EQU	WORD PTR [BP-16]
FileBreiteBytes EQU	WORD PTR [BP-18]  ; Breite des Sprite im File in Bytes
SpriBreiteBytes	EQU	WORD PTR [BP-20]  ; Breite des Sprite a. d. Bildschirm
RestBytes	EQU	WORD PTR [BP-22]  ; FileBreiteByte - SpriBreiteBytes
;-----------------------
Bmp2Sprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,22		; 11 lokale WORD-Variable

		MOV	[DSSave],DS
;...............................
;  ffne den File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	AL,2			; Fileattr = Normal
		MOV     AH,3DH                  ; Function: Open Handle
		INT	21H			; DOS-Aufruf
		JC	Bmp2Sprite_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Lies den Header des .BMP-File
;  Er enthlt u.a. Breite und Hhe des Sprite
;...............................
		LDS	DX,[BufferPtr]	; DS:DX-> Buffer
		MOV	CX,36H		; Bytes to read
		MOV	BX,[FileHandle]
		MOV	AH,3FH		; Function: Read Handle
		INT	21H
		JC	Bmp2Sprite_0
;...............................
;  bertrage die Breite und Hhe des Sprite in die lokalen Variablen
;  und in die TP-Variablen, damit auch TP die Breite und Hoehe kennt.
;...............................
		LDS	SI,[BufferPtr]	; DS:SI-> Header im Buffer
		LES	DI,[BreitePtr]	; ES:DI-> TP-Variable Breite
		MOV	AX,[SI+12H]	; Hole Breite aus dem Header
		MOV	ES:[DI],AX	; Lege in der TP-Variablen ab
		MOV	[Breite],AX
;
;  Die im File tatschlich verwendete Zeilenlnge entspricht nur dann
;  der Breite, wenn Breite mod 4 = 0 ist. Sonst wird die Zeilenlnge
;  auf den nchsthheren Wert fr mod 4 = 0 aufgerundet.
;
		IMUL	AX,3
		MOV	BX,AX
		TEST	AL,03
		JZ	SHORT Bmp2Sprite_1
		AND	AL,NOT 03
		ADD	AX,0004
Bmp2Sprite_1:
		MOV	[FileBreiteBytes],AX ; im File verwendete Breite in Byte
		SUB	AX,BX
		MOV	[RestBytes],AX
;
;  bertrage die Hoehe in die lokale Variable, wo sie whrend der
;  Hauptschleife dekrementiert wird.
;
		LES	DI,[HoehePtr]	; ES:DI-> TP-Variable Hoehe
		MOV	AX,[SI+16H]	; Hole Hoehe aus dem Header
		MOV	ES:[DI],AX	; Lege in der TP-Variablen ab
		MOV	[Hoehe],AX
;...............................
;  Setze den Filepointer auf den Anfang des Datenbereiches im File
;...............................
		MOV	DX,[SI+0AH]	; Offset des Datenber. aus dem Header
		SUB	CX,CX		; CX:DX-> Datenbereich
		MOV	BX,[FileHandle]
		MOV	AL,0		; Method: Beginning of File + Offset
		MOV	AH,42H		; Function: Move File Pointer
		INT	21H
		JC	Bmp2Sprite_0
;...............................
;  Init die lokalen Variablen
;...............................
		MOV	DS,[DSSave]
;
;  SpriBreiteBytes:= Breite * BytesPerPixel
;
		MOV	AX,[Breite]
		IMUL	AX,[BytesPerPixel]
		MOV	[SpriBreiteBytes],AX
;
;  LineDiff:= BytesPerScanLine+SpriBreiteBytes	(AX hat SpriBreiteBytes)
;
		ADD	AX,[BytesPerScanLine]
		MOV	[LineDiff],AX
;
;  LinesPerBuffer := LineCount := BufferSize / FileBreiteBytes
;
		MOV	AX,[BufferSize]
		SUB	DX,DX
		DIV	[FileBreiteBytes]
		MOV	[LinesPerBuffer],AX
		MOV	[LineCount],AX
;
;  BufferInhalt := LinesPerBuffer * Zeilenlnge (AX hat LinesPerBuffer)
;
		MUL	[FileBreiteBytes]
		MOV	[BufferInhalt],AX
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = ((Y+Hoehe-1) * BytesPerScanLine) + X * BytesPerPixel
;  GetScreenAddr ist ungeeignet, weil wir die untere linke Ecke brauchen
;...............................

		MOVZX	EAX,[BytesPerScanline]
		MOVZX	EDX,[Y]		; EDX = Y
		ADD	DX,[Hoehe]	; EDX = Y+Hoehe
		DEC	DX		; EDX = Y+Hoehe-1
		MUL	EDX	; EDXEAX := BytesPerScanLine * (Y+Hoehe-1)
;
		MOVZX	EBX,[X]			; EBX := X
		IMUL	BX,[BytesPerPixel]
		ADD	EAX,EBX
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10			; [Byte]
		DIV	EBX			; EDX := Offset   EAX := Segm
		MOV	DI,DX			; DI := Offset
		MOV	DX,AX			; DX := Segm
;
		SetBanks		; Setze das Window := DX
;...............................
;  Lies einen Buffer vom File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	Bmp2Sprite_0		; fehlgeschlagen ?
;
;  Bereite die bertragung vom Buffer zum Video-Mem vor
;
		MOV	FS,[DSSave]		; FS-> .ASM 'Data'
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;...............................
;  bertrage eine Zeile vom Buffer zum Video-Mem
;...............................
Bmp2Sprite_2:
		MOV	DX,[Breite]
;
;  bertrage eine Zeile vom Buffer zum Video-Mem
;  Achte auf Bankswitch.
;  Jetzt ist: DS:SI-> Buffer
;	      ES:DI-> Video-Mem
;		 DX = Breite
;
		CLD				; String aufwrts
BMP2Sprite_4:
		SUB	EAX,EAX
		LODSB				; Hole Blau vom Buffer
		MOV	CL,FS:[BlueFieldPosition]
		SHL	EAX,CL			; Bringe in die BlauPosition
		MOV	EBX,EAX 		; Sammle die Komponenten im EBX

		SUB	EAX,EAX
		LODSB				; Hole Grn vom Buffer
		MOV	CL,FS:[GreenFieldPosition]
		SHL	EAX,CL			; Bringe in die GrnPosition
		OR	EBX,EAX 		; EBX:=Rot+Grn

		SUB	EAX,EAX
		LODSB				; Hole Rot vom Buffer
		MOV	CL,FS:[RedFieldPosition]
		SHL	EAX,CL			; Bringe in die RotPosition
		OR	EAX,EBX			; EAX:=Rot+Grn+Blau
;
;  Bringe die 3 Komponenten zum Video-Mem
;
		PUSH	DS
		MOV	DS,[DSSave]
;
;  Unterscheide zwischen 3 und 4 BytesPerPixel im Video-Mem
;
		CMP	[BytesPerPixel],4
		JZ	SHORT Bmp2Sprite_48
;
;  Wir haben 3 BytePerPixel
;
		STOSB
		OR	DI,DI
		JNZ	SHORT Bmp2Sprite_42
		CALL	IncWrBank
Bmp2Sprite_42:
		SHR	EAX,8
		STOSB
		OR	DI,DI
		JNZ	SHORT Bmp2Sprite_44
		CALL	IncWrBank
Bmp2Sprite_44:
		SHR	EAX,8
		STOSB
		OR	DI,DI
		JNZ	SHORT Bmp2Sprite_46
		CALL	IncWrBank
Bmp2Sprite_46:
		JMP	SHORT Bmp2Sprite_50
;...............
;  Wir haben 4 BytePerPixel
;
Bmp2Sprite_48:	STOSD
		OR	DI,DI
		JNZ	SHORT Bmp2Sprite_50
		CALL	IncWrBank
Bmp2Sprite_50:
		POP	DS

		DEC	DX			; Loop mit Breite
		JNZ	SHORT Bmp2Sprite_4

		ADD	SI,[RestBytes]
;
;  Bestimme die ADR der vorigen Zeile im Video-Mem
;
		SUB	DI,[LineDiff]
		JNB	SHORT Bmp2Sprite_6

		PUSH	DS
		MOV	DS,[DSSave]
		CALL	DecWrBank
		POP	DS
Bmp2Sprite_6:
;
;  Sieh nach, ob die nchste Zeile noch im Buffer enthalten ist
;
		DEC	[LineCount]
		JNZ	SHORT  Bmp2Sprite_8
;...............................
;  Die nchste Zeile ist nicht mehr im Buffer enthalten
;  Lies einen weiteren Buffer vom File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Bmp2Sprite_0	; fehlgeschlagen ?
;
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;
		MOV	AX,[LinesPerBuffer]
		MOV	[LineCount],AX		; LineCount := LinesPerBuffer
;...............................
;  LOOP mit Hoehe
;...............................
Bmp2Sprite_8:	DEC	[Hoehe]
		JNZ	Bmp2Sprite_2
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
		MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Bmp2Sprite_0	; fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
Bmp2Sprite_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr]        ; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
;  Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]		;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	26		; Entferne 3 WORDs und 5 POINTER
;................
Bmp2Sprite_5:
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	DecWrBank
		POP	DS
;
		JMP	SHORT Bmp2Sprite_6
;...............
Bmp2Sprite	ENDP
;-------------------------------
;  bertrgt ein ASCII-Zeichen in einer 16 x 8 Punkte Matrix in das Video-Mem.
;  Dabei wird die obere linke Ecke als Bezugspunkt fr die geforderten X,Y-
;  Koordinaten genommen.
;
;  Aufruf: PutChar (X,Y:WORD; Char, CharSize, Blau, Gruen, Rot :BYTE);
;---------------
X		EQU	WORD PTR [BP+18]
Y		EQU	WORD PTR [BP+16]
Char		EQU	BYTE PTR [BP+14]
CharSize	EQU	BYTE PTR [BP+12]
Blau		EQU	BYTE PTR [BP+10]
Gruen		EQU	BYTE PTR [BP+8]
Rot		EQU	BYTE PTR [BP+6]
;---------------
PutChar		PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne den Offset des Zeichens im CharSet
;
		MOV	AL,[Char]
		MOV	CX,16		   ; Jeder Eintrag hat 16 Bytes
		MUL	CL		   ; AX = 16 * CHAR #n
		PUSH	AX		   ; TOS = Offset
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X * BytesPerPixel ;	ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		   ; Setze beide Windows := DX
;
;  Init die Reg fr die bertragung vom  CharSet
;
		MOV	BX,[BytesPerScanline]	; BX = BpSl
		MOV	AX,[BytesPerPixel]
		SHL	AX,3
		SUB	BX,AX	   ; BX = BytesPerScanLine - 8*BytesPerPixel
;
		MOV	SI,OFFSET CharSet  ; CS:SI-> CharSet im CS
		POP	AX		   ; Restore Offset
		ADD	SI,AX		   ; DS:SI-> CharSet im CS CHAR #n
;
		GetColor		   ; EAX = Farbkomponenten
;
		MOV	CL,16		   ; Zeichenhhe
;
;  Jetzt ist:
;  DS:SI-> Zeichen im CharSet
;  ES:DI-> VGA-Mem
;  SS:BP-> Variable auf dem Stack
;    EAX = Farbkomponenten
;     BX = BytesPerScanLine - 8*BytesPerPixel
;     CL = LineCount = 16
;  Spter wird:
;     CH = 2 Zeilen/Byte (bei doppelter Zeichenhhe)
;     DL = das Byte aus dem CharSet
;     DH = Testmaske
;
;  Verzweige je nach Zeichengre
;
		CMP	[CharSize],1	   ;  CASE OF CharSize
		JZ	PutChar_10
		CMP	[CharSize],2
		JZ	PutChar_20
;...............
;  CharSize = 0	( Einfache Breite, einfache Hhe)
;
PutChar_00:	MOV	DL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	DH,80H		   ; Testmaske
PutChar_02:
		TEST	DL,DH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_04   ;   Nein, skip
		CALL	DrawPixel
		JMP	SHORT PutChar_06
;..............
PutChar_04:	ADD	DI,[BytesPerPixel] ; Ein Pixel nach rechts
		JC	SHORT PutChar_05   ; Achte auf Bankswitch
PutChar_06:
		SHR	DH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChar_02   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des VGA-Mem
		JC	SHORT PutChar_07   ; Achte auf Bankswitch
PutChar_08:
		DEC	CL		   ; LineCount
		JNZ	SHORT PutChar_00   ; Loop mit Zeilen/Char
PutChar_0:
		POP	BP
		RET	14		   ; Entferne 7 WORDs vom Stack
;---------------
PutChar_05:	CALL	IncRdWrBank
		JMP	SHORT PutChar_06
;---------------
PutChar_07:	CALL	IncRdWrBank
		JMP	SHORT PutChar_08
;------------------------------------------
;  CharSize = 1	 (Einfache Breite und doppelte Hhe)
;
PutChar_10:	MOV	DL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	CH,2		   ; Zeilen/Byte
PutChar_11:
		MOV	DH,80H		   ; Testmaske
PutChar_12:
		TEST	DL,DH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_14   ;	Nein, skip
		CALL	DrawPixel	   ; Setze Pixel := Farbe
		JMP	SHORT PutChar_16
;..............
PutChar_14:	ADD	DI,[BytesPerPixel] ; Ein Pixel nach rechts
		JC	SHORT PutChar_15   ; Achte auf Bankswitch
PutChar_16:
		SHR	DH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChar_12   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des VGA-Mem
		JC	SHORT PutChar_17   ; Achte auf Bankswitch
PutChar_18:
		DEC	CH		   ; Loop mit Zeilen/Byte
		JNZ	SHORT PutChar_11

		DEC	CL		   ; LineCount
		JNZ	SHORT PutChar_10   ; Loop mit Zeilen/Char
		JMP	SHORT PutChar_0
;---------------
PutChar_15:	CALL	IncRdWrBank
		JMP	SHORT PutChar_16
;---------------
PutChar_17:	CALL	IncRdWrBank
		JMP	SHORT PutChar_18
;---------------
;  CharSize = 2	(Doppelte Breite und doppelte Hhe)
;
PutChar_20:	MOV	DX,[BytesPerPixel]
		SHL	DX,3
		SUB	BX,DX	   ; BX = BytesPerScanLine -16*BytesPerPixel
PutChar_202:
		MOV	DL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	CH,2		   ; Zeilen/Byte
PutChar_21:
		MOV	DH,80H		   ; Testmaske
PutChar_22:
		TEST	DL,DH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_24   ;	Nein, skip
		CALL	DrawPixel	   ; Setze Pixel := Farbe
		JMP	SHORT PutChar_26
;...............
PutChar_24:	ADD	DI,[BytesPerPixel] ; Ein Pixel nach rechts
		JC	SHORT PutChar_25   ; Achte auf Bankswitch
PutChar_26:
		TEST	DL,DH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_28   ;	Nein, skip
		CALL	DrawPixel	   ; Setze Pixel := Farbe
		JMP	SHORT PutChar_30
;..............
PutChar_28:	ADD	DI,[BytesPerPixel] ; Ein Pixel nach rechts
		JC	SHORT PutChar_29   ; Achte auf Bankswitch
PutChar_30:
		SHR	DH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChar_22   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des VGA-Mem
		JC	SHORT PutChar_31   ; Achte auf Bankswitch
PutChar_32:
		DEC	CH		   ; Loop mit Zeilen/Byte
		JNZ	PutChar_21

		DEC	CL		   ; LineCount
		JNZ	SHORT PutChar_202  ; Loop mit Zeilen/Char
		JMP	PutChar_0
;..............
PutChar_25:	CALL	IncRdWrBank
		JMP	SHORT PutChar_26
;..............
PutChar_29:	CALL	IncRdWrBank
		JMP	SHORT PutChar_30
;..............
PutChar_31:	CALL	IncRdWrBank
		JMP	SHORT PutChar_32
;---------------
;...............
PutChar		ENDP
;-------------------------------
;  Lscht das ganze VGA-Mem (Fllt es mit schwarz)
;
ClearVGAMem	PROC	FAR
;
		MOV	SI,[TotalMemory]	; Anzahl Bnke
		MOV	DX,0			; Start-Window
		SUB	DI,DI			; Startadr
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		CLD				; String aufwrts
ClearVGAMem_2:
;
;  Setze das Window := DX und lsche es
;
		MOV	BH,0			; Window setzen
		MOV	BL,0			; Window A

		PUSH	DX
		CALL	[WinFuncPtr]
		POP	DX
;
		SUB	EAX,EAX			; Fillwert = 0
		MOV	CX,4000H
		REP	STOSD			; CX mal von EAX nach ES:[DI]
		ADD	DX,[WinSizePerGranu]
		DEC	SI			; Loop mit Anzahl Bnke
		JNZ	SHORT ClearVGAMem_2

		RET
ClearVGAMem	ENDP
;-------------------------------
;  Blendet die Bankgrenzen in der Farbe hellwei ein
;  Aufruf: ShowBanks
;---------------
ShowBanks	PROC	FAR
;
		MOV	SI,[TotalMemory]	; Anzahl Bnke
		SUB	DX,DX			; Beginne mit Bank #0
		MOV	ES,[WinASegment]	; ES-> Video-Mem
		CLD				; String aufwrts
ShowBanks_2:
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		MOV	BL,0		; Window A
		PUSH	DX
		CALL	[WinFuncPtr]
		POP	DX
;
;  Flle eine Zeile
;
		MOV	CX,[BytesPerScanLine]; Zeilenlnge
		SUB	DI,DI		; ES:DI-> Video-Mem
		MOV	AL,153		; Blau/Grn/Blau je 60%

		REP	STOSB

		ADD	DX,[WinSizePerGranu]

		DEC	SI
		JNZ	SHORT ShowBanks_2 ; Loop mit der Anzahl von Bnken

		RET
ShowBanks	ENDP
;-------------------------------
;======================================================================
;  Prozeduren, die innerhalb der UNIT mit NEAR CALL aufgerufen werden.
;=======================================================================
;  DrawPixel, DrawRi,
;  GetListe,
;  IncWrBank, DecWrBank, IncRdBank, DecRdWin, IncRdWrBank, DecRdWrBank,
;-------------------------------
;  Eing:   EAX = Farbkomponenten
;	 ES:DI-> 1. Byte des Pixel
;  AUSG: ES:DI-> rechts hinter das Pixel, evtl. in der nchsten Bank
;---------------
DrawPixel	PROC
		CMP	[BytesPerPixel],3
		JZ	SHORT DrawPixel_10
;
;  Wir haben 32 Bit/Pixel
;
		CMP	[XORMode],TRUE
		JZ	SHORT DrawPixel_4
;
;  Wir haben 32 Bit/Pixel und MOVMode.
;
		MOV	ES:[DI],EAX
DrawPixel_2:
		ADD	DI,4
		JNZ	SHORT DrawPixel_0	; Achte auf Bankberschreitung
		CALL	IncRdWrBank
DrawPixel_0:
		RET
;...............
;  Wir haben 32 Bit/Pixel und XORMode
;
DrawPixel_4:	XOR	ES:[DI],EAX
		JMP	SHORT DrawPixel_2
;...............
;  Wir haben 24 Bit/Pixel
;
DrawPixel_10:	CMP	[XORMode],TRUE
		JZ	SHORT DrawPixel_20
;
;  Wir haben 24 Bit/Pixel und MOVMode. Achte auf Bankberschreitung
;
		MOV	ES:[DI],AL
		INC	DI
		JZ	SHORT DrawPixel_11
DrawPixel_12:
		MOV	ES:[DI],AH
		INC	DI
		JZ	SHORT DrawPixel_13
DrawPixel_14:
		ROR	EAX,16
		MOV	ES:[DI],AL
		ROR	EAX,16
		INC	DI
		JNZ	SHORT DrawPixel_0
		CALL	IncWrBank
		JMP	SHORT DrawPixel_0
;...............
DrawPixel_11:	CALL	IncWrBank
		JMP	SHORT DrawPixel_12
;...............
DrawPixel_13:	CALL	IncWrBank
		JMP	SHORT DrawPixel_14
;...............
;  Wir haben 24 Bit/Pixel und XORMode. Achte auf Bankberschreitung
;
DrawPixel_20:	XOR	ES:[DI],AL
		INC	DI
		JZ	SHORT DrawPixel_21
DrawPixel_22:
		XOR	ES:[DI],AH
		INC	DI
		JZ	SHORT DrawPixel_23
DrawPixel_24:
		ROR	EAX,16
		XOR	ES:[DI],AL
		ROR	EAX,16
		INC	DI
		JNZ	SHORT DrawPixel_0
		CALL	IncRdWrBank
		JMP	SHORT DrawPixel_0
;...............
DrawPixel_21:	CALL	IncRdWrBank
		JMP	SHORT DrawPixel_22
;...............
DrawPixel_23:	CALL	IncRdWrBank
		JMP	SHORT DrawPixel_24
;...............
DrawPixel	ENDP
;-------------------------------
;  Zeichnet eine Gerade nach rechts beginnend bei ES:DI
;  Bercksichtigt XORMode
;  EING: ES:DI-> Start
;	    CX = Lnge, Anzahl Pixel (>=1) a' 3 oder 4 Byte
;	   EAX = Farbkomponenten   X:C:B:A
;
;  AUSG: ES:DI = hinter das letzte Pixel
;	    CX = 0
;...............
DrawRi		PROC
		PUSH	DX
		CLD			; String aufwrts
;
;  Sieh nach, ob wir 3 BytesPerPixel haben
;
		CMP	[BytesPerPixel],3
		JZ	SHORT DrawRi_300
;
;  Wir haben 4 BytesPerPixel. Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawRx_400
;
;  Wir haben 4 BytesPerPixel und MOV_Mode.
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
;
		SHL	CX,2		; CX := Anzahl Byte
		ADD	DI,CX
		JC	SHORT DrawRi_460
;
;  Wir haben 4 BytesPerPixel, MOV_Mode und keine Bankberschreitung.
;  Das macht mal richtig Spa.
;
		SUB	DI,CX		; DI-> zurck in alte Bank
		SHR	CX,2		; CX := Anzahl Pixel
		REP	STOSD		; CX mal EAX nach ES:[DI]
DrawRi_0:
		POP	DX
		RET
;...............
;  Wir haben 4 BytesPerPixel, MOVE_Mode, aber mit Bankberschreitung.
;  DI = Anzahl Byte in der nchsten Bank.
;  CX = Lnge in Byte
;
DrawRi_460:	MOV	DX,DI
		SHR	DX,2		; DX := Pixel in neuer Bank
		SUB	DI,CX		; ES:DI-> alte Bank
		SHR	CX,2		; CX := Lnge in Pixel
		SUB	CX,DX		; CX := Lnge - Pixel in neuer Bank

		REP	STOSD		; Flle den 1. Teil der Zeile
		CALL	IncWrBank	; Schalte um auf nchste Bank
		MOV	CX,DX		; CX := Pixel in neuer Bank
		REP	STOSD		; Flle den 2. Teil der Zeile
		JMP	SHORT DrawRi_0
;...............
;  Wir haben 4 BytesPerPixel und XORMode.
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
;
DrawRx_400:	SHL	CX,2		; CX := Anzahl Byte
		ADD	DI,CX
		JC	SHORT DrawRx_460
		SUB	DI,CX		; DI-> zurck in alte Bank
		SHR	CX,2		; CX := Anzahl Pixel
;
;  Wir haben 4 BytesPerPixel, XORMode und keine Bankberschreitung.
;
DrawRx_420:	XOR	ES:[DI],EAX
		ADD	DI,4
		DEC	CX
		JNZ	SHORT DrawRx_420
		JMP	SHORT DrawRi_0
;...............
;  Wir haben 4 BytesPerPixel, XORMode, aber mit Bankberschreitung.
;  DI = Anzahl Byte in der nchsten Bank.
;  CX = Lnge in Byte
;
DrawRx_460:	MOV	DX,DI
		SHR	DX,2		; DX := Pixel in neuer Bank
		SUB	DI,CX		; ES:DI-> alte Bank
		SHR	CX,2		; CX := Lnge in Pixel
		SUB	CX,DX		; CX := Lnge - Pixel in neuer Bank
DrawRx_462:
		XOR	ES:[DI],EAX	; Flle den 1. Teil der Zeile
		ADD	DI,4
		DEC	CX
		JNZ	SHORT DrawRx_462

		CALL	IncRdWrBank	; Schalte um auf nchste Bank
		OR	DX,DX
		JZ	SHORT DrawRi_0
DrawRx_464:
		XOR	ES:[DI],EAX	; Flle den 2. Teil der Zeile
		ADD	DI,4
		DEC	DX
		JNZ	SHORT DrawRx_464
		JMP	SHORT DrawRi_0
;...............
;  Wir haben 3 BytesPerPixel.
;  Wir wollen versuchen, so weit wie mglich wordweise und auf gerade
;  Adressen im Video-Mem zuzugreifen.
;
DrawRi_300:	PUSH	BX
		SHLD	EBX,EAX,16	; Eine Farbkomponente ins BL..
;					  ..die anderen beiden im AX
;  Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	DrawRx_300
;
;  Wir haben 3 BytesPerPixel und MOV_Mode.
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
;
		MOV	DX,CX		; DX := Anzahl Pixel
		IMUL	DX,3		; DX := Anzahl Byte
		ADD	DI,DX
		JC	SHORT DrawRi_360
;
;  Wir haben 3 BytesPerPixel, MOV_Mode und keine Bankberschreitung.
;
		SUB	DI,DX		; DI-> zurck in alte Bank
;
;  Verpacke 2 Pixel in 3 WORDs im AX BX DX.
;  EAX hat X:C:B:A   BL hat B
;
		SHLD	EDX,EAX,24
		MOV	BH,AL
;
;  Jetzt ist AX = B:A
;	     BX = A:C
;	     DX = C:B
;
;  Unterscheide zwischen gerader und ungerader Startadresse
;
		TEST	DI,1
		JZ	SHORT DrawRi_320
;
;  Wir haben 3 BytesPerPixel, MOV_Mode und keine Bankberschreitung.
;  Die Startadr ES:[DI] ist ungerade.  CX = Anzahl Pixel
;
DrawRi_340:	SHR	CX,1		; 1 Loop ergibt zwei Pixel
;					; CY = ungerade Pixelzahl
;
;  Bei gerader Pixelzahl (NC) mssen wir die Anzahl der Pixelpaare
;  um eins verringern, weil vor und nach dem Loop ein Pixel gesetzt wird.
;
		JC	SHORT DrawRi_342
		DEC	CX
;
;  Bringe erstmal ein Pixel zum Video-Mem, damit die Startadresse gerade wird
;
DrawRi_342:	MOV	ES:[DI],BH	; A zum Video-Mem
		INC	DI

		MOV	ES:[DI],DX	; C:B zum Video-Mem
		INC	DI
		INC	DI
;
;  Wenn nur ein oder zwei Pixel zu setzen sind, umspringe den Loop
;
		JCXZ	DrawRi_346
;
;  Jetzt ist die Startadresse gerade. Jeder Loop setzt zwei Pixel
;
DrawRi_344:	STOSW			; B:A zum Video-Mem

		MOV	ES:[DI],BX	; A:C zum Video-Mem
		INC	DI
		INC	DI

		MOV	ES:[DI],DX	; C:B zum Video-Mem
		INC	DI
		INC	DI

		DEC	CX		; Loop mit der Anzahl Pixelpaare
		JNZ	SHORT DrawRi_344
;
;  Bei gerader Pixelzahl fehlt noch ein Pixel
;  CY = ungerade Pixelzahl
;
DrawRi_346:	JC	SHORT DrawRi_350

		STOSW			; B:A zum Video-Mem
		MOV	ES:[DI],BL	; C zum Video-Mem
		INC	DI
DrawRi_350:
		POP	BX
		JMP	DrawRi_0
;...............
;  Wir haben 3 BytesPerPixel, MOV_Mode und keine Bankberschreitung.
;  Die Startadr ist gerade.
;
DrawRi_320:	SHR	CX,1		; 1 Loop ergibt zwei Pixel
;					; CY = ungerade Pixelzahl
		JCXZ	DrawRi_324
DrawRi_322:	STOSW			; B:A zum Video-Mem

		MOV	ES:[DI],BX	; A:C zum Video-Mem
		INC	DI
		INC	DI

		MOV	ES:[DI],DX	; C:B zum Video-Mem
		INC	DI
		INC	DI

		DEC	CX
		JNZ	SHORT DrawRi_322; Loop mit der Anzahl Pixelpaare
;
;  Bei ungerader Pixelzahl fehlt noch ein Pixel
;
DrawRi_324:	JNC	SHORT DrawRi_350

		STOSW			; B:A zum Video-Mem
		MOV	ES:[DI],BL	; C zum Video-Mem
		INC	DI

		JMP	DrawRi_350	; noch POP BX
;...............
;  Wir haben 3 BytesPerPixel, MOV_Mode aber mit Bankberschreitung.
;
DrawRi_360:	SUB	DI,DX		; DI-> zurck in alte Bank
DrawRi_362:
		MOV	ES:[DI],AL
		INC	DI
		JNZ	SHORT DrawRi_364
		CALL	IncWrBank
DrawRi_364:
		MOV	ES:[DI],AH
		INC	DI
		JNZ	SHORT DrawRi_366
		CALL	IncWrBank
DrawRi_366:
		MOV	ES:[DI],BL
		INC	DI
		JNZ	SHORT DrawRi_368
		CALL	IncWrBank
DrawRi_368:
		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawRi_362

		JMP	DrawRi_350	; noch POP BX
;...............
;  Wir haben 3 BytesPerPixel und XOR_Mode.
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
;
DrawRx_300:	CLD			; String aufwrts
		MOV	DX,CX		; DX := Anzahl Pixel
		IMUL	DX,3		; DX := Anzahl Byte
		ADD	DI,DX
		JC	SHORT DrawRx_360
;
;  Wir haben 3 BytesPerPixel, XOR_Mode und keine Bankberschreitung.
;
		SUB	DI,DX		; DI-> zurck in alte Bank
;
;  Verpacke 2 Pixel in 3 WORDs im AX BX DX.
;  EAX hat X:C:B:A   BL hat B
;
		SHLD	EDX,EAX,24
		MOV	BH,AL
;
;  Jetzt ist AX = B:A
;	     BX = A:C
;	     DX = C:B
;
;  Unterscheide zwischen gerader und ungerader Startadresse
;
		TEST	DI,1
		JZ	SHORT DrawRx_320
;
;  Wir haben 3 BytesPerPixel, XOR_Mode und keine Bankberschreitung.
;  Die Startadr ist ungerade.
;
DrawRx_340:	SHR	CX,1		; 1 Loop ergibt zwei Pixel
;					; CY = ungerade Pixelzahl
;
;  Bei gerader Pixelzahl (NC) mssen wir die Anzahl der Pixelpaare
;  um eins verringern, weil vor und nach dem Loop ein Pixel gesetzt wird.
;
		JC	SHORT DrawRx_342
		DEC	CX
;
;  Bringe erstmal ein Pixel zum Video-Mem, damit die Startadresse gerade wird
;
DrawRx_342:	PUSHF			; Rette CY wegen XOR
		XOR	ES:[DI],BH	; A zum Video-Mem
		INC	DI

		XOR	ES:[DI],DX	; C:B zum Video-Mem
		INC	DI
		INC	DI
;
;  Wenn nur ein oder zwei Pixel zu setzen sind, umspringe den Loop
;
		JCXZ	DrawRx_346
;
;  Jetzt ist die Startadresse gerade. Jeder Loop setzt zwei Pixel
;
DrawRx_344:	XOR	ES:[DI],AX	; B:A zum Video-Mem
		INC	DI
		INC	DI

		XOR	ES:[DI],BX	; A:C zum Video-Mem
		INC	DI
		INC	DI

		XOR	ES:[DI],DX	; C:B zum Video-Mem
		INC	DI
		INC	DI

		DEC	CX		; Loop mit der Anzahl Pixelpaare
		JNZ	SHORT DrawRx_344
;
;  Bei gerader Pixelzahl fehlt noch ein Pixel
;  CY = ungerade Pixelzahl;
;
DrawRx_346:	POPF			; Restore CY wegen XOR
		JC	SHORT DrawRi_350

		XOR	ES:[DI],AX	; B:A zum Video-Mem
		INC	DI
		INC	DI

		XOR	ES:[DI],BL	; C zum Video-Mem
		INC	DI

		JMP	DrawRi_350	; noch POP BX
;...............
;  Wir haben 3 BytesPerPixel, XOR_Mode und keine Bankberschreitung.
;  Die Startadr ist gerade.
;
DrawRx_320:	SHR	CX,1		; 1 Loop ergibt zwei Pixel
;					; CY = ungerade Pixelzahl
		JCXZ	DrawRx_324
		PUSHF			; Rette CY wegen XOR
DrawRx_322:
		XOR	ES:[DI],AX	; B:A zum Video-Mem
		INC	DI
		INC	DI

		XOR	ES:[DI],BX	; A:C zum Video-Mem
		INC	DI
		INC	DI

		XOR	ES:[DI],DX	; C:B zum Video-Mem
		INC	DI
		INC	DI

		DEC	CX
		JNZ	SHORT DrawRx_322; Loop mit der Anzahl Pixelpaare
		POPF			; Restore CY wegen XOR
;
;  Bei ungerader Pixelzahl fehlt noch ein Pixel
;
DrawRx_324:	JNC	DrawRi_350

		XOR	ES:[DI],AX	; B:A zum Video-Mem
		INC	DI
		INC	DI

		XOR	ES:[DI],BL	; C zum Video-Mem
		INC	DI

		JMP	DrawRi_350	; noch POP BX
;...............
;  Wir haben 3 BytesPerPixel, XOR_Mode aber mit Bankberschreitung.
;
DrawRx_360:	SUB	DI,DX		; DI-> zurck in alte Bank
DrawRx_362:
		XOR	ES:[DI],AL
		INC	DI
		JNZ	SHORT DrawRx_364
		CALL	IncRdWrBank
DrawRx_364:
		XOR	ES:[DI],AH
		INC	DI
		JNZ	SHORT DrawRx_366
		CALL	IncRdWrBank
DrawRx_366:
		XOR	ES:[DI],BL
		INC	DI
		JNZ	SHORT DrawRx_368
		CALL	IncRdWrBank
DrawRx_368:
		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawRx_362

		JMP	DrawRi_350	; noch POP BX
;...............
		JMP	SHORT DrawRx_364
;...............
DrawRx_365:	CALL	IncRdWrBank
		JMP	SHORT DrawRx_366
;...............
DrawRx_367:	CALL	IncRdWrBank
		JMP	SHORT DrawRx_368
;...............
DrawRi		ENDP
;-------------------------------
;  Zeichnet eine Gerade nach links beginnend bei ES:DI
;  Bercksichtigt XORMode
;  EING: ES:DI-> Start
;	    CX = Lnge, Anzahl Pixel (>=1) a' 3 oder 4 Byte
;	   EAX = Farbkomponenten
;
;  AUSG: ES:DI = vor das letzte Pixel
;	    CX = 0
;	    DX = Zerst
;...............
DrawLe		PROC
;
;  Sieh nach, ob wir 3 BytesPerPixel haben
;
		CMP	[BytesPerPixel],3
		JZ	SHORT DrawLe_3
;
;  Wir haben 4 BytesPerPixel. Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawLe_30
;
;  Wir haben 4 BytesPerPixel und MOV_Mode.
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
;
		STD			; String abwrts
		SHL	CX,2		; CX := Anzahl Byte
		SUB	DI,CX
		JB	SHORT DrawLe_20
;
;  Wir haben 4 BytesPerPixel, MOV_Mode und keine Bankberschreitung.
;  Das macht mal richtig Spa.
;
DrawLe_10:	ADD	DI,CX		; DI-> zurck in alte Bank
		SHR	CX,2		; CX := Anzahl Pixel
		REP	STOSD		; CX mal EAX nach ES:[DI]
DrawLe_0:
		RET
;...............
;  Wir haben 4 BytesPerPixel, MOVE_Mode, aber mit Bankberschreitung.
;  DI = Anzahl Byte in der neuen Bank.
;  CX = Lnge in Byte
;
DrawLe_20:	ADD	DI,CX		; ES:DI-> alte Bank
		MOV	DX,DI
		SHR	DX,2
		SHR	CX,2
		INC	DX		; DX := 1. Pixelcount
		SUB	CX,DX		; CX := 2. Pixelcount
		XCHG	CX,DX
		REP	STOSD		; Flle den 1. Teil der Zeile
		CALL	DecWrBank	; Schalte um auf vorige Bank
		XCHG	CX,DX
		JCXZ	DrawLe_0
		REP	STOSD		; Flle den 2. Teil der Zeile
		JMP	SHORT DrawLe_0
;...............
;  Wir haben 4 BytesPerPixel und XORMode.
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
;
DrawLe_30:	SHL	CX,2		; CX := Anzahl Byte
		SUB	DI,CX
		JB	SHORT DrawLe_40
		ADD	DI,CX		; DI-> zurck in alte Bank
		SHR	CX,2		; CX := Anzahl Pixel
;
;  Wir haben 4 BytesPerPixel, XORMode und keine Bankberschreitung.
;
DrawLe_32:	XOR	ES:[DI],EAX
		SUB	DI,4
		DEC	CX
		JNZ	SHORT DrawLe_32
		JMP	SHORT DrawLe_0
;...............
;  Wir haben 4 BytesPerPixel, XORMode, aber mit Bankberschreitung.
;  DI = Anzahl Byte in der nchsten Bank.
;  CX = Lnge in Byte
;
DrawLe_40:	ADD	DI,CX		; ES:DI-> alte Bank
		MOV	DX,DI
		SHR	DX,2
		SHR	CX,2		; CX := Lnge in Pixel
		INC	DX		; DX := 1. Pixelcount
		SUB	CX,DX		; CX := 2. Pixelcount
DrawLe_42:
		XOR	ES:[DI],EAX	; Flle den 1. Teil der Zeile
		SUB	DI,4
		DEC	DX
		JNZ	SHORT DrawLe_42

		CALL	DecRdWrBank	; Schalte um auf vorige Bank
		JCXZ	DrawLe_0
DrawLe_44:
		XOR	ES:[DI],EAX	; Flle den 2. Teil der Zeile
		SUB	DI,4
		DEC	CX
		JNZ	SHORT DrawLe_44
		JMP	SHORT DrawLe_0
;...............
;  Wir haben 3 BytesPerPixel.
;
DrawLe_3:	SHLD	EBX,EAX,16	; Eine Farbkomponente ins BL..
					; ..die anderen beiden im AX
		CLD			; String aufwrts
;
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
;
		ADD	DI,2		; DI-> 3. Farbkomponente
		JNC	SHORT DrawLe_34
		CALL	IncRdWrBank
DrawLe_34:
		MOV	DX,CX		; DX := Anzahl Pixel
		IMUL	DX,3		; DX := Anzahl Byte
		SUB	DI,DX
		JB	SHORT DrawLe_320
;
;  Wir haben 3 BytesPerPixel und keine Bankberschreitung.
;  Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawLe_350
;
;  Wir haben 3 BytesPerPixel, MOV-Mode keine Bankberschreitung.
;
		ADD	DI,DX		; DI-> zurck in alte Bank
DrawLe_342:
		MOV	ES:[DI],BL
		SUB	DI,2
		MOV	ES:[DI],AX
		DEC	DI

		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawLe_342

		JMP	DrawLe_00
;...............
;  Wir haben 3 BytesPerPixel, XORMode und keine Bankberschreitung.
;  CX = Anzahl Pixel
;
DrawLe_350:
		ADD	DI,DX
DrawLe_352:
		XOR	ES:[DI],BL
		SUB	DI,2
		XOR	ES:[DI],AX
		DEC	DI

		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawLe_352

		JMP	SHORT DrawLe_00
;---------------
;  Wir haben 3 BytesPerPixel und keine Bankberschreitung.
;  Sieh nach, ob wir XORMode haben
;
DrawLe_320:	CMP	[XORMode],True
		JZ	SHORT DrawLe_370
;
;  Wir haben 3 BytesPerPixel, MOV_Mode aber mit Bankberschreitung.
;
DrawLe_360:	ADD	DI,DX		; DI-> zurck in alte Bank
DrawLe_362:
		MOV	ES:[DI],BL
		SUB	DI,1
		JB	SHORT DrawLe_363
DrawLe_364:
		MOV	ES:[DI],AH
		SUB	DI,1
		JB	SHORT DrawLe_365
DrawLe_366:
		MOV	ES:[DI],AL
		SUB	DI,1
		JB	SHORT DrawLe_367
DrawLe_368:
		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawLe_362
DrawLe_00:
		SUB	DI,2		; DI-> 1. Farbkomponente
		JNB	SHORT DrawLe_02
		CALL	DecRdWrBank
DrawLe_02:
		JMP	DrawLe_0
;...............
DrawLe_363:	CALL	DecWrBank
		JMP	SHORT DrawLe_364
;...............
DrawLe_365:	CALL	DecWrBank
		JMP	SHORT DrawLe_366
;...............
DrawLe_367:	CALL	DecWrBank
		JMP	SHORT DrawLe_368
;...............
;  Wir haben 3 BytesPerPixel, XORMode, aber mit Bankberschreitung.
;  CX = Anzahl Pixel
;
DrawLe_370:	ADD	DI,DX
DrawLe_372:
		XOR	ES:[DI],AL
		SUB	DI,1
		JB	SHORT DrawLe_373
DrawLe_374:
		XOR	ES:[DI],AH
		SUB	DI,1
		JB	SHORT DrawLe_375
DrawLe_376:
		XOR	ES:[DI],BL
		SUB	DI,1
		JB	SHORT DrawLe_377
DrawLe_378:
		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawLe_372

		JMP	DrawLe_00
;...............
DrawLe_373:	CALL	DecRdWrBank
		JMP	SHORT DrawLe_374
;...............
DrawLe_375:	CALL	DecRdWrBank
		JMP	SHORT DrawLe_376
;...............
DrawLe_377:	CALL	DecRdWrBank
		JMP	SHORT DrawLe_378
;...............
DrawLe		ENDP
;-------------------------------
;  Zeichnet eine Gerade nach unten beginnend bei ES:DI
;  Bercksichtigt XORMode
;  EING: ES:DI-> Start
;	    CX = Lnge, Anzahl Pixel (>=1) a' 3 oder 4 Byte
;	   EAX = Farbkomponenten
;
;  AUSG: ES:DI = unter das letzte Pixel. Bank entsprechend
;	    BL = Farbkomponente
;	    CX = 0
;	    DX = Zerst
;---------------
DrawDo		PROC
		MOV	DX,[BytesPerScanLine];
;
;  Sieh nach, ob wir 3 BytesPerPixel haben
;
		CMP	[BytesPerPixel],3
		JZ	SHORT DrawDo_10
;
;  Wir haben 4 BytesPerPixel. Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawDo_2X
;
;  Wir haben 4 BytesPerPixel und MOV_Mode.
;
DrawDo_2:	MOV	ES:[DI],EAX
		ADD	DI,DX			; ES:DI-> nchste Scanline
		JC	SHORT DrawDo_3		; Bankswitch ?
DrawDo_4:
		DEC	CX			; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawDo_2
DrawDo_0:
		RET
;...............
DrawDo_3:	CALL	IncWrBank
		JMP	SHORT DrawDo_4
;---------------
;  Wir haben 4 BytesPerPixel und XORMode.
;
DrawDo_2X:	XOR	ES:[DI],EAX
		ADD	DI,DX			; ES:DI-> nchste Scanline
		JC	SHORT DrawDo_3X 	; Bankswitch ?
DrawDo_4X:
		DEC	CX			; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawDo_2X
		JMP	SHORT DrawDo_0
;...............
DrawDo_3X:	CALL	IncRdWrBank
		JMP	SHORT DrawDo_4X
;---------------
;  Wir haben 3 BytesPerPixel.
;
DrawDo_10:	SUB	DX,2		; DX:=BytesPerScanLine-2
		SHLD	EBX,EAX,16	; Eine Farbkomponente ins BL..
;					  ..die anderen beiden im AX
;  Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawDo_12X
;
;  Wir haben 3 BytesPerPixel und MOV_Mode.
;
DrawDo_12:	MOV	ES:[DI],AL
		INC	DI
		JZ	SHORT DrawDo_13
DrawDo_14:
		MOV	ES:[DI],AH
		INC	DI
		JZ	SHORT DrawDo_15
DrawDo_16:
		MOV	ES:[DI],BL
		ADD	DI,DX
		JC	SHORT DrawDo_17
DrawDo_18:
		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawDo_12
		JMP	DrawDo_0
;...............
DrawDo_13:	CALL	IncWrBank
		JMP	SHORT DrawDo_14
;...............
DrawDo_15:	CALL	IncWrBank
		JMP	SHORT DrawDo_16
;...............
DrawDo_17:	CALL	IncWrBank
		JMP	SHORT DrawDo_18
;---------------
;  Wir haben 3 BytesPerPixel und XORMode.
;
DrawDo_12X:	XOR	ES:[DI],AL
		INC	DI
		JZ	SHORT DrawDo_13X
DrawDo_14X:
		XOR	ES:[DI],AH
		INC	DI
		JZ	SHORT DrawDo_15X
DrawDo_16X:
		XOR	ES:[DI],BL
		ADD	DI,DX
		JC	SHORT DrawDo_17X
DrawDo_18X:
		DEC	CX		; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawDo_12X
		JMP	DrawDo_0
;...............
DrawDo_13X:	CALL	IncRdWrBank
		JMP	SHORT DrawDo_14X
;...............
DrawDo_15X:	CALL	IncRdWrBank
		JMP	SHORT DrawDo_16X
;...............
DrawDo_17X:	CALL	IncRdWrBank
		JMP	SHORT DrawDo_18X
;...............
DrawDo		ENDP
;-------------------------------
;  Zeichnet eine Gerade nach oben beginnend bei ES:DI
;  Bercksichtigt XORMode
;  EING: ES:DI-> Start
;	    CX = Lnge, Anzahl Pixel (>=1) a' 3 oder 4 Byte
;	   EAX = Farbkomponenten
;
;  AUSG: ES:DI = ber das letzte Pixel. Bank entsprechend
;	    BL = Farbkomponente
;	    CX = 0
;	    DX = Zerst
;---------------
DrawUp		PROC
		MOV	DX,[BytesPerScanLine]
;
;  Sieh nach, ob wir 3 BytesPerPixel haben
;
		CMP	[BytesPerPixel],3
		JZ	SHORT DrawUp_10
;
;  Wir haben 4 BytesPerPixel. Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawUp_2X
;
;  Wir haben 4 BytesPerPixel und MOV_Mode.
;
DrawUp_2:	MOV	ES:[DI],EAX		; Farbkomponenten zum Video-Mem
		SUB	DI,DX			; DI-> vorige Scanline
		JB	SHORT DrawUp_3		; Bankswitch ?
DrawUp_4:
		DEC	CX			; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawUp_2
DrawUp_0:
		RET
;...............
DrawUp_3:	CALL	DecWrBank
		JMP	SHORT DrawUp_4
;---------------
;  Wir haben 4 BytesPerPixel und XORMode.
;
DrawUp_2X:	XOR	ES:[DI],EAX		; Farbkomponenten zum Video-Mem
		SUB	DI,DX			; DI-> vorige Scanline
		JB	SHORT DrawUp_3X 	; Bankswitch ?
DrawUp_4X:
		DEC	CX			; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawUp_2X
		JMP	SHORT DrawUp_0
;...............
DrawUp_3X:	CALL	DecRdWrBank
		JMP	SHORT DrawUp_4X
;---------------
;  Wir haben 3 BytesPerPixel.
;
DrawUp_10:	ADD	DX,2		; DX:=BytesPerScanLine+2
		SHLD	EBX,EAX,16	; Eine Farbkomponente ins BL..
;					  ..die anderen beiden im AX
;  Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawUp_12X
;
;  Wir haben 3 BytesPerPixel und MOV_Mode.
;
DrawUp_12:	MOV	ES:[DI],AL
		INC	DI
		JZ	SHORT DrawUp_13 	; Bankswitch ?
DrawUp_14:
		MOV	ES:[DI],AH
		INC	DI
		JZ	SHORT DrawUp_15 	; Bankswitch ?
DrawUp_16:
		MOV	ES:[DI],BL
		SUB	DI,DX			; ES:DI-> vorige Scanline
		JB	SHORT DrawUp_17 	; Bankswitch ?
DrawUp_18:
		DEC	CX			; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawUp_12
		JMP	DrawDo_0
;...............
DrawUp_13:	CALL	IncWrBank
		JMP	SHORT DrawUp_14
;...............
DrawUp_15:	CALL	IncWrBank
		JMP	SHORT DrawUp_16
;...............
DrawUp_17:	CALL	DecWrBank
		JMP	SHORT DrawUp_18
;...............
;  Wir haben 3 BytesPerPixel und XORMode.
;
DrawUp_12X:	XOR	ES:[DI],AL
		INC	DI
		JZ	SHORT DrawUp_13X	; Bankswitch ?
DrawUp_14X:
		XOR	ES:[DI],AH
		INC	DI
		JZ	SHORT DrawUp_15X	; Bankswitch ?
DrawUp_16X:
		XOR	ES:[DI],BL
		SUB	DI,DX
		JB	SHORT DrawUp_17X	; Bankswitch ?
DrawUp_18X:
		DEC	CX			; Loop mit der Anzahl Pixel
		JNZ	SHORT DrawUp_12X
		JMP	DrawDo_0
;...............
DrawUp_13X:	CALL	IncRdWrBank
		JMP	SHORT DrawUp_14X
;...............
DrawUp_15X:	CALL	IncRdWrBank
		JMP	SHORT DrawUp_16X
;...............
DrawUp_17X:	CALL	DecRdWrBank
		JMP	SHORT DrawUp_18X
;...............
DrawUp		ENDP
;-------------------------------
		DB	"Jrgen Petsch fr c't 2.97"					 ;
;-------------------------------
;  Legt eine Liste mit den Lngen der Kreisstcke an
;  EING:    AX = R
;  AUSG: DS:DI-> OFFSET LastEntry
;	    CY = Zustzliches Pixel notwendig
;...............
PX		EQU	WORD PTR [BP-2]
PY		EQU	WORD PTR [BP-4]
A		EQU	WORD PTR [BP-6]
;...............
GetListe	PROC
		PUSH	BP
		MOV	BP,SP
		SUB	SP,6		; 3 lokale WORD-Variable

		MOV	[Px],0		; PX = 0
		MOV	[A],AX		; A = R
		MOV	[Py],AX 	; Py = R

		MOV	DI,OFFSET Liste
		MOV	AX,DS
		MOV	ES,AX		; ES := DS
		SUB	EAX,EAX
		MOV	CX,128
		CLD
		REP	STOSD

		MOV	DI,OFFSET Liste
		MOV	BH,0		; Summe aller Lngen
		MOV	BL,0		; Lngencounter
GetListe_2:
		CMP	[A],0		; A < 0 ?
		JNS	SHORT GetListe_4; Nein, skip

		DEC	[Py]		; PY = PY - 1
		MOV	[DI],BL 	; Lege Lnge ab
		ADD	BH,BL		; Summe aller Lngen
		INC	DI		; DI-> nchster Eintrag
		MOV	BL,0		; Init Lnge:= 0

		MOV	AX,[Py]
		ADD	AX,AX
		ADD	[A],AX		; A = A + PY + PY
GetListe_4:
		DEC	[A]		; A = A - PX - PX - 1
		MOV	AX,[Px]
		ADD	AX,AX
		SUB	[A],AX
		INC	[Px]		; PX = PX +1
		INC	BL		; Inc Lnge

		MOV	AX,[Py]
		CMP	AX,[Px]		; PY < PX ?
		JNB	SHORT GetListe_2; Nein, loop

		MOV	BL,1		; Lnge:= 1
		MOV	[DI],BL 	; Eintrag mit Lnge:= 1

		CMP	BH,AL		; Summe aller Lngen < PY ?
		JB	SHORT GetListe_6; Ja, zustzlicher Eintrag
		DEC	DI		; kein zustzlicher Eintrag
GetListe_6:
		CMP	BH,AL		; Summe aller Lngen = PY ?
		CLC			; Ja, zustzliches Pixel
		JZ	SHORT GetListe_0
		STC			; Kein zustzliches Pixel
GetListe_0:
		MOV	SP,BP
		POP	BP
		RET
GetListe	ENDP
;-------------------------------
IncWrBank	PROC
		PUSHA
;
;  Suche nach einem schreibbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,2		; Bit#0 = schreibbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		ADD	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
		POPA
		RET
IncWrBank	ENDP
;-------------------------------
DecWrBank	PROC
		PUSHA
;
;  Suche nach einem schreibbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,2		; Bit#0 = schreibbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		SUB	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
		POPA
		RET
DecWrBank	ENDP
;-------------------------------
IncRdBank	PROC
		PUSHA
;
;  Suche nach einem lesbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,1		; Bit#0 = Lesbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		ADD	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]

		POPA
		RET
IncRdBank	ENDP
;-------------------------------
DecRdBank	PROC
		PUSHA
;
;  Suche nach einem lesbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,1		; Bit#0 = Lesbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		SUB	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]

		POPA
		RET
DecRdBank	ENDP
;-------------------------------
IncRdWrBank	PROC
		PUSHA
;
;  Lies die Position des WindowA
;
		MOV	BL,0		; WindowA
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		ADD	DX,[WinSizePerGranu]
;
		SetBanks		; Setze beide Windows:= DX
;
		POPA
		RET
IncRdWrBank	ENDP
;-------------------------------
DecRdWrBank	PROC
		PUSHA
;
;  Lies die Position des WindowA
;
		MOV	BL,0
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		SUB	DX,[WinSizePerGranu]
;
		SetBanks		; Setze beide Windows:= DX
;
		POPA
		RET
DecRdWrBank	ENDP
;-------------------------------
;===============================
;  Zeichensatz 8*16
;===============================
CharSet LABEL Near
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,7EH,81H,0A5H,81H,81H,0BDH	   ; 
DB 99H,81H,81H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,7EH,0FFH,0DBH,0FFH,0FFH,0C3H	   ; 
DB 0E7H,0FFH,0FFH,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,6CH,0FEH,0FEH,0FEH	   ; 
DB 0FEH,7CH,38H,10H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,10H,38H,7CH,0FEH	   ; 
DB 7CH,38H,10H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,18H,3CH,3CH,0E7H,0E7H	   ; 
DB 0E7H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,18H,3CH,7EH,0FFH,0FFH	   ; 
DB 7EH,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,18H,3CH	   ; 
DB 3CH,18H,00H,00H,00H,00H,00H,00H	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0E7H,0C3H ; 
DB 0C3H,0E7H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 00H,00H,00H,00H,00H,3CH,66H,42H	   ;
DB 42H,66H,3CH,00H,00H,00H,00H,00H	   ;
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0C3H,99H,0BDH  ;
DB 0BDH,99H,0C3H,0FFH,0FFH,0FFH,0FFH,0FFH  ;
DB 00H,00H,1EH,0EH,1AH,32H,78H,0CCH	   ; 
DB 0CCH,0CCH,0CCH,78H,00H,00H,00H,00H	   ; 
DB 00H,00H,3CH,66H,66H,66H,66H,3CH	   ; 
DB 18H,7EH,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,3FH,33H,3FH,30H,30H,30H	   ; 

DB 30H,70H,0F0H,0E0H,00H,00H,00H,00H	   ; 

DB 00H,00H,7FH,63H,7FH,63H,63H,63H	   ; 
DB 63H,67H,0E7H,0E6H,0C0H,00H,00H,00H	   ; 
DB 00H,00H,00H,18H,18H,0DBH,3CH,0E7H	   ; 
DB 3CH,0DBH,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,80H,0C0H,0E0H,0F0H,0F8H,0FEH,0F8H   ; 
DB 0F0H,0E0H,0C0H,80H,00H,00H,00H,00H	   ; 
DB 00H,02H,06H,0EH,1EH,3EH,0FEH,3EH	   ; 
DB 1EH,0EH,06H,02H,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,3CH,7EH,18H,18H,18H	   ; 
DB 7EH,3CH,18H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,66H,66H,66H,66H,66H,66H	   ; 
DB 66H,00H,66H,66H,00H,00H,00H,00H	   ; 
DB 00H,00H,7FH,0DBH,0DBH,0DBH,7BH,1BH	   ; 
DB 1BH,1BH,1BH,1BH,00H,00H,00H,00H	   ; 
DB 00H,7CH,0C6H,60H,38H,6CH,0C6H,0C6H	   ; 
DB 6CH,38H,0CH,0C6H,7CH,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 0FEH,0FEH,0FEH,0FEH,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,3CH,7EH,18H,18H,18H	   ; 
DB 7EH,3CH,18H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,3CH,7EH,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,7EH,3CH,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,18H,0CH,0FEH	   ; 
DB 0CH,18H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,30H,60H,0FEH	   ; 
DB 60H,30H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,0C0H,0C0H	   ; 
DB 0C0H,0FEH,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,28H,6CH,0FEH	   ; 
DB 6CH,28H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,10H,38H,38H,7CH	   ; 
DB 7CH,0FEH,0FEH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,0FEH,0FEH,7CH,7CH	   ; 
DB 38H,38H,10H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,18H,3CH,3CH,3CH,18H,18H	   ; !
DB 18H,00H,18H,18H,00H,00H,00H,00H	   ; !
DB 00H,66H,66H,66H,24H,00H,00H,00H	   ; "
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; "
DB 00H,00H,00H,6CH,6CH,0FEH,6CH,6CH	   ; #
DB 6CH,0FEH,6CH,6CH,00H,00H,00H,00H	   ; #
DB 18H,18H,7CH,0C6H,0C2H,0C0H,7CH,06H	   ; $
DB 06H,86H,0C6H,7CH,18H,18H,00H,00H	   ; $
DB 00H,00H,00H,00H,0C2H,0C6H,0CH,18H	   ; %
DB 30H,60H,0C6H,86H,00H,00H,00H,00H	   ; %
DB 00H,00H,38H,6CH,6CH,38H,76H,0DCH	   ; &
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; &
DB 00H,30H,30H,30H,60H,00H,00H,00H	   ; '
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; '
DB 00H,00H,0CH,18H,30H,30H,30H,30H	   ; (
DB 30H,30H,18H,0CH,00H,00H,00H,00H	   ; (
DB 00H,00H,30H,18H,0CH,0CH,0CH,0CH	   ; )
DB 0CH,0CH,18H,30H,00H,00H,00H,00H	   ; )
DB 00H,00H,00H,00H,00H,66H,3CH,0FFH	   ; *
DB 3CH,66H,00H,00H,00H,00H,00H,00H	   ; *
DB 00H,00H,00H,00H,00H,18H,18H,7EH	   ; +
DB 18H,18H,00H,00H,00H,00H,00H,00H	   ; +
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; ,
DB 00H,18H,18H,18H,30H,00H,00H,00H	   ; ,
DB 00H,00H,00H,00H,00H,00H,00H,7EH	   ; -
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; -
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; .
DB 00H,00H,18H,18H,00H,00H,00H,00H	   ; .
DB 00H,00H,00H,00H,02H,06H,0CH,18H	   ; /
DB 30H,60H,0C0H,80H,00H,00H,00H,00H	   ; /
DB 00H,00H,38H,6CH,0C6H,0C6H,0D6H,0D6H	   ; 0
DB 0C6H,0C6H,6CH,38H,00H,00H,00H,00H	   ; 0
DB 00H,00H,18H,38H,78H,18H,18H,18H	   ; 1
DB 18H,18H,18H,7EH,00H,00H,00H,00H	   ; 1
DB 00H,00H,7CH,0C6H,06H,0CH,18H,30H	   ; 2
DB 60H,0C0H,0C6H,0FEH,00H,00H,00H,00H	   ; 2
DB 00H,00H,7CH,0C6H,06H,06H,3CH,06H	   ; 3
DB 06H,06H,0C6H,7CH,00H,00H,00H,00H	   ; 3
DB 00H,00H,0CH,1CH,3CH,6CH,0CCH,0FEH	   ; 4
DB 0CH,0CH,0CH,1EH,00H,00H,00H,00H	   ; 4
DB 00H,00H,0FEH,0C0H,0C0H,0C0H,0FCH,06H	   ; 5
DB 06H,06H,0C6H,7CH,00H,00H,00H,00H	   ; 5
DB 00H,00H,38H,60H,0C0H,0C0H,0FCH,0C6H	   ; 6
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 6
DB 00H,00H,0FEH,0C6H,06H,06H,0CH,18H	   ; 7
DB 30H,30H,30H,30H,00H,00H,00H,00H	   ; 7
DB 00H,00H,7CH,0C6H,0C6H,0C6H,7CH,0C6H	   ; 8
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 8
DB 00H,00H,7CH,0C6H,0C6H,0C6H,7EH,06H	   ; 9
DB 06H,06H,0CH,78H,00H,00H,00H,00H	   ; 9
DB 00H,00H,00H,00H,18H,18H,00H,00H	   ; :
DB 00H,18H,18H,00H,00H,00H,00H,00H	   ; :
DB 00H,00H,00H,00H,18H,18H,00H,00H	   ; ;
DB 00H,18H,18H,30H,00H,00H,00H,00H	   ; ;
DB 00H,00H,00H,06H,0CH,18H,30H,60H	   ; <
DB 30H,18H,0CH,06H,00H,00H,00H,00H	   ; <
DB 00H,00H,00H,00H,00H,7EH,00H,00H	   ; =
DB 7EH,00H,00H,00H,00H,00H,00H,00H	   ; =
DB 00H,00H,00H,60H,30H,18H,0CH,06H	   ; >
DB 0CH,18H,30H,60H,00H,00H,00H,00H	   ; >
DB 00H,00H,7CH,0C6H,0C6H,0CH,18H,18H	   ; ?
DB 18H,00H,18H,18H,00H,00H,00H,00H	   ; ?
DB 00H,00H,7CH,0C6H,0C6H,0C6H,0DEH,0DEH	   ; @
DB 0DEH,0DCH,0C0H,7CH,00H,00H,00H,00H	   ; @
DB 00H,00H,10H,38H,6CH,0C6H,0C6H,0FEH	   ; A
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; A
DB 00H,00H,0FCH,66H,66H,66H,7CH,66H	   ; B
DB 66H,66H,66H,0FCH,00H,00H,00H,00H	   ; B
DB 00H,00H,3CH,66H,0C2H,0C0H,0C0H,0C0H	   ; C
DB 0C0H,0C2H,66H,3CH,00H,00H,00H,00H	   ; C
DB 00H,00H,0F8H,6CH,66H,66H,66H,66H	   ; D
DB 66H,66H,6CH,0F8H,00H,00H,00H,00H	   ; D
DB 00H,00H,0FEH,66H,62H,68H,78H,68H	   ; E
DB 60H,62H,66H,0FEH,00H,00H,00H,00H	   ; E
DB 00H,00H,0FEH,66H,62H,68H,78H,68H	   ; F
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; F
DB 00H,00H,3CH,66H,0C2H,0C0H,0C0H,0DEH	   ; G
DB 0C6H,0C6H,66H,3AH,00H,00H,00H,00H	   ; G
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0FEH,0C6H   ; H
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; H
DB 00H,00H,7EH,18H,18H,18H,18H,18H	   ; I
DB 18H,18H,18H,7EH,00H,00H,00H,00H	   ; I
DB 00H,00H,1EH,0CH,0CH,0CH,0CH,0CH	   ; J
DB 0CCH,0CCH,0CCH,78H,00H,00H,00H,00H	   ; J
DB 00H,00H,0E6H,66H,66H,6CH,78H,78H	   ; K
DB 6CH,66H,66H,0E6H,00H,00H,00H,00H	   ; K
DB 00H,00H,0F0H,60H,60H,60H,60H,60H	   ; L
DB 60H,62H,66H,0FEH,00H,00H,00H,00H	   ; L
DB 00H,00H,0C6H,0EEH,0FEH,0FEH,0D6H,0C6H   ; M
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; M
DB 00H,00H,0C6H,0E6H,0F6H,0FEH,0DEH,0CEH   ; N
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; N
DB 00H,00H,7CH,0C6H,0C6H,0C6H,0C6H,0C6H	   ; O
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; O
DB 00H,00H,0FCH,66H,66H,66H,7CH,60H	   ; P
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; P
DB 00H,00H,7CH,0C6H,0C6H,0C6H,0C6H,0C6H	   ; Q
DB 0C6H,0D6H,0DEH,7CH,0CH,0EH,00H,00H	   ; Q
DB 00H,00H,0FCH,66H,66H,66H,7CH,6CH	   ; R
DB 66H,66H,66H,0E6H,00H,00H,00H,00H	   ; R
DB 00H,00H,7CH,0C6H,0C6H,60H,38H,0CH	   ; S
DB 06H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; S
DB 00H,00H,7EH,7EH,5AH,18H,18H,18H	   ; T
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; T
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0C6H,0C6H   ; U
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; U
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0C6H,0C6H   ; V
DB 0C6H,06CH,38H,10H,00H,00H,00H,00H	   ; V
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0D6H,0D6H   ; W
DB 0D6H,0FEH,0EEH,6CH,00H,00H,00H,00H	   ; W
DB 00H,00H,0C6H,0C6H,6CH,7CH,38H,38H	   ; X
DB 7CH,6CH,0C6H,0C6H,00H,00H,00H,00H	   ; X
DB 00H,00H,66H,66H,66H,66H,3CH,18H	   ; Y
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; Y
DB 00H,00H,0FEH,0C6H,86H,0CH,18H,30H	   ; Z
DB 60H,0C2H,0C6H,0FEH,00H,00H,00H,00H	   ; Z
DB 00H,00H,3CH,30H,30H,30H,30H,30H	   ; [
DB 30H,30H,30H,3CH,00H,00H,00H,00H	   ; [
DB 00H,00H,00H,80H,0C0H,0E0H,70H,38H	   ; \
DB 1CH,0EH,06H,02H,00H,00H,00H,00H	   ; \
DB 00H,00H,3CH,0CH,0CH,0CH,0CH,0CH	   ; ]
DB 0CH,0CH,0CH,3CH,00H,00H,00H,00H	   ; ]
DB 10H,38H,6CH,0C6H,00H,00H,00H,00H	   ; ^
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; ^
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; _
DB 00H,00H,00H,00H,00H,0FFH,00H,00H	   ; _
DB 30H,30H,18H,00H,00H,00H,00H,00H	   ; `
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; `
DB 00H,00H,00H,00H,00H,78H,0CH,7CH	   ; a
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; a
DB 00H,00H,0E0H,60H,60H,78H,6CH,66H	   ; b
DB 66H,66H,66H,7CH,00H,00H,00H,00H	   ; b
DB 00H,00H,00H,00H,00H,7CH,0C6H,0C0H	   ; c
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; c
DB 00H,00H,1CH,0CH,0CH,3CH,6CH,0CCH	   ; d
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; d
DB 00H,00H,00H,00H,00H,7CH,0C6H,0FEH	   ; e
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; e
DB 00H,00H,38H,6CH,64H,60H,0F0H,60H	   ; f
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; f
DB 00H,00H,00H,00H,00H,76H,0CCH,0CCH	   ; g
DB 0CCH,0CCH,0CCH,7CH,0CH,0CCH,78H,00H	   ; g
DB 00H,00H,0E0H,60H,60H,6CH,76H,66H	   ; h
DB 66H,66H,66H,0E6H,00H,00H,00H,00H	   ; h
DB 00H,00H,18H,18H,00H,38H,18H,18H	   ; i
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; i
DB 00H,00H,06H,06H,00H,0EH,06H,06H	   ; j
DB 06H,06H,06H,06H,66H,66H,3CH,00H	   ; j
DB 00H,00H,0E0H,60H,60H,66H,6CH,78H	   ; k
DB 78H,6CH,66H,0E6H,00H,00H,00H,00H	   ; k
DB 00H,00H,60H,60H,60H,60H,60H,60H	   ; l
DB 60H,64H,7CH,38H,00H,00H,00H,00H	   ; l
DB 00H,00H,00H,00H,00H,0ECH,0FEH,0D6H	   ; m
DB 0D6H,0D6H,0D6H,0C6H,00H,00H,00H,00H	   ; m
DB 00H,00H,00H,00H,00H,0DCH,66H,66H	   ; n
DB 66H,66H,66H,66H,00H,00H,00H,00H	   ; n
DB 00H,00H,00H,00H,00H,7CH,0C6H,0C6H	   ; o
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; o
DB 00H,00H,00H,00H,00H,0DCH,66H,66H	   ; p
DB 66H,66H,66H,7CH,60H,60H,0F0H,00H	   ; p
DB 00H,00H,00H,00H,00H,76H,0CCH,0CCH	   ; q
DB 0CCH,0CCH,0CCH,7CH,0CH,0CH,1EH,00H	   ; q
DB 00H,00H,00H,00H,00H,0DCH,76H,66H	   ; r
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; r
DB 00H,00H,00H,00H,00H,7CH,0C6H,60H	   ; s
DB 38H,0CH,0C6H,7CH,00H,00H,00H,00H	   ; s
DB 00H,00H,10H,30H,30H,0FCH,30H,30H	   ; t
DB 30H,30H,36H,1CH,00H,00H,00H,00H	   ; t
DB 00H,00H,00H,00H,00H,0CCH,0CCH,0CCH	   ; u
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; u
DB 00H,00H,00H,00H,00H,66H,66H,66H	   ; v
DB 66H,66H,3CH,18H,00H,00H,00H,00H	   ; v
DB 00H,00H,00H,00H,00H,0C6H,0C6H,0D6H	   ; w
DB 0D6H,0D6H,0FEH,6CH,00H,00H,00H,00H	   ; w
DB 00H,00H,00H,00H,00H,0C6H,6CH,38H	   ; x
DB 38H,38H,6CH,0C6H,00H,00H,00H,00H	   ; x
DB 00H,00H,00H,00H,00H,0C6H,0C6H,0C6H	   ; y
DB 0C6H,0C6H,0C6H,7EH,06H,0CH,0F8H,00H	   ; y
DB 00H,00H,00H,00H,00H,0FEH,0CCH,18H	   ; z
DB 30H,60H,0C6H,0FEH,00H,00H,00H,00H	   ; z
DB 00H,00H,0EH,18H,18H,18H,70H,18H	   ; {
DB 18H,18H,18H,0EH,00H,00H,00H,00H	   ; {
DB 00H,00H,18H,18H,18H,18H,00H,18H	   ; |
DB 18H,18H,18H,18H,00H,00H,00H,00H	   ; |
DB 00H,00H,70H,18H,18H,18H,0EH,18H	   ; }
DB 18H,18H,18H,70H,00H,00H,00H,00H	   ; }
DB 00H,00H,76H,0DCH,00H,00H,00H,00H	   ; ~
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; ~
DB 00H,00H,00H,00H,10H,38H,6CH,0C6H	   ; 
DB 0C6H,0C6H,0FEH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,3CH,66H,0C2H,0C0H,0C0H,0C0H	   ; 
DB 0C2H,66H,3CH,0CH,06H,7CH,00H,00H	   ; 
DB 00H,00H,0CCH,00H,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,0CH,18H,30H,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,10H,38H,6CH,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,0CCH,00H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,38H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,3CH,66H,60H,60H	   ; 
DB 66H,3CH,0CH,06H,3CH,00H,00H,00H	   ; 
DB 00H,10H,38H,6CH,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,0C6H,00H,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,66H,00H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,18H,3CH,66H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,0C6H,00H,10H,38H,6CH,0C6H,0C6H	   ; 
DB 0FEH,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 38H,6CH,38H,00H,38H,6CH,0C6H,0C6H	   ; 
DB 0FEH,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 18H,30H,60H,00H,0FEH,66H,60H,7CH	   ; 
DB 60H,60H,66H,0FEH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,6CH,0FEH,0B2H,32H	   ; 
DB 7EH,0D8H,0D8H,6EH,00H,00H,00H,00H	   ; 
DB 00H,00H,3EH,6CH,0CCH,0CCH,0FEH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,0CEH,00H,00H,00H,00H	   ; 
DB 00H,10H,38H,6CH,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,0C6H,00H,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,30H,78H,0CCH,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,0C6H,00H,00H,0C6H,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7EH,06H,0CH,78H,00H	   ; 
DB 00H,0C6H,00H,7CH,0C6H,0C6H,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,0C6H,00H,0C6H,0C6H,0C6H,0C6H,0C6H   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,18H,18H,3CH,66H,60H,60H,60H	   ; 
DB 66H,3CH,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,64H,60H,0F0H,60H,60H	   ; 
DB 60H,60H,0E6H,0FCH,00H,00H,00H,00H	   ; 
DB 00H,00H,66H,66H,3CH,18H,7EH,18H	   ; 
DB 7EH,18H,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,0F8H,0CCH,0CCH,0F8H,0C4H,0CCH,0DEH  ; 
DB 0CCH,0CCH,0CCH,0C6H,00H,00H,00H,00H	   ; 
DB 00H,0EH,1BH,18H,18H,18H,7EH,18H	   ; 
DB 18H,18H,18H,18H,0D8H,70H,00H,00H	   ; 
DB 00H,18H,30H,60H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,0CH,18H,30H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,18H,30H,60H,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,18H,30H,60H,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,76H,0DCH,00H,0DCH,66H,66H	   ; 
DB 66H,66H,66H,66H,00H,00H,00H,00H	   ; 
DB 76H,0DCH,00H,0C6H,0E6H,0F6H,0FEH,0DEH   ; 
DB 0CEH,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 00H,3CH,6CH,6CH,3EH,00H,7EH,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,6CH,38H,00H,7CH,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,30H,30H,00H,30H,30H,60H	   ; 
DB 0C0H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,0FEH,0C0H	   ; 
DB 0C0H,0C0H,0C0H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,0FEH,06H	   ; 
DB 06H,06H,06H,00H,00H,00H,00H,00H	   ; 
DB 00H,0C0H,0C0H,0C2H,0C6H,0CCH,18H,30H	   ; 
DB 60H,0DCH,86H,0CH,18H,3EH,00H,00H	   ; 
DB 00H,0C0H,0C0H,0C2H,0C6H,0CCH,18H,30H	   ; 
DB 66H,0CEH,9EH,3EH,06H,06H,00H,00H	   ; 
DB 00H,00H,18H,18H,00H,18H,18H,18H	   ; 
DB 3CH,3CH,3CH,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,36H,6CH,0D8H	   ; 
DB 6CH,36H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,0D8H,6CH,36H	   ; 
DB 6CH,0D8H,00H,00H,00H,00H,00H,00H	   ; 
DB 11H,44H,11H,44H,11H,44H,11H,44H	   ; 
DB 11H,44H,11H,44H,11H,44H,11H,44H	   ; 
DB 55H,0AAH,55H,0AAH,55H,0AAH,55H,0AAH	   ; 
DB 55H,0AAH,55H,0AAH,55H,0AAH,55H,0AAH	   ; 
DB 0DDH,77H,0DDH,77H,0DDH,77H,0DDH,77H	   ; 
DB 0DDH,77H,0DDH,77H,0DDH,77H,0DDH,77H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,0F8H,18H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0F6H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FEH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,0F8H,18H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 36H,36H,36H,36H,36H,0F6H,06H,0F6H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,0FEH,06H,0F6H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,0F6H,06H,0FEH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0FEH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,0F8H,18H,0F8H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,1FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,1FH,18H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,37H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,37H,30H,3FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,3FH,30H,37H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,0F7H,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,0FFH,00H,0F7H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,37H,30H,37H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,0FFH,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 36H,36H,36H,36H,36H,0F7H,00H,0F7H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 18H,18H,18H,18H,18H,0FFH,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,0FFH,00H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,3FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,1FH,18H,1FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,1FH,18H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,3FH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0FFH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 18H,18H,18H,18H,18H,0FFH,18H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0F8H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H ; 
DB 0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H ; 
DB 0FH,0FH,0FH,0FH,0FH,0FH,0FH,0FH	   ; 
DB 0FH,0FH,0FH,0FH,0FH,0FH,0FH,0FH	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,00H  ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,76H,0DCH,0D8H	   ; 
DB 0D8H,0D8H,0DCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,78H,0CCH,0CCH,0CCH,0D8H,0CCH	   ; 
DB 0C6H,0C6H,0C6H,0CCH,00H,00H,00H,00H	   ; 
DB 00H,00H,0FEH,0C6H,0C6H,0C0H,0C0H,0C0H   ; 
DB 0C0H,0C0H,0C0H,0C0H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,0FEH,6CH,6CH,6CH	   ; 
DB 6CH,6CH,6CH,6CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,0FEH,0C6H,60H,30H,18H	   ; 
DB 30H,60H,0C6H,0FEH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,7EH,0D8H,0D8H	   ; 
DB 0D8H,0D8H,0D8H,70H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,66H,66H,66H,66H	   ; 
DB 66H,7CH,60H,60H,0C0H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,76H,0DCH,18H,18H	   ; 
DB 18H,18H,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,7EH,18H,3CH,66H,66H	   ; 
DB 66H,3CH,18H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,38H,6CH,0C6H,0C6H,0FEH	   ; 
DB 0C6H,0C6H,6CH,38H,00H,00H,00H,00H	   ; 
DB 00H,00H,38H,6CH,0C6H,0C6H,0C6H,6CH	   ; 
DB 6CH,6CH,6CH,0EEH,00H,00H,00H,00H	   ; 
DB 00H,00H,1EH,30H,18H,0CH,3EH,66H	   ; 
DB 66H,66H,66H,3CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,7EH,0DBH,0DBH	   ; 
DB 0DBH,7EH,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,03H,06H,7EH,0DBH,0DBH	   ; 
DB 0F3H,7EH,60H,0C0H,00H,00H,00H,00H	   ; 
DB 00H,00H,1CH,30H,60H,60H,7CH,60H	   ; 
DB 60H,60H,30H,1CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,7CH,0C6H,0C6H,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,0FEH,00H,00H,0FEH	   ; 
DB 00H,00H,0FEH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,18H,18H,7EH,18H	   ; 
DB 18H,00H,00H,0FFH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,30H,18H,0CH,06H,0CH	   ; 
DB 18H,30H,00H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,0CH,18H,30H,60H,30H	   ; 
DB 18H,0CH,00H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,0EH,1BH,1BH,1BH,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 0D8H,0D8H,0D8H,70H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,18H,18H,00H,7EH	   ; 
DB 00H,18H,18H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,76H,0DCH,00H	   ; 
DB 76H,0DCH,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,6CH,38H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,18H	   ; 
DB 18H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,0FH,0CH,0CH,0CH,0CH,0CH,0ECH	   ; 
DB 6CH,6CH,3CH,1CH,00H,00H,00H,00H	   ; 
DB 00H,0D8H,6CH,6CH,6CH,6CH,6CH,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,70H,0D8H,30H,60H,0C8H,0F8H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,7CH,7CH,7CH,7CH	   ; 
DB 7CH,7CH,7CH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
;-------------------------------
CODE		ENDS
		END
