PROGRAM VESA24_T; (* Turbo Pascal + UNIT VESA24 *)

(* Anwendung der Unit VESA24 fr Grafik mit Truecolor (24 Bit/Farbe) *)

USES CRT, VESA24;

PROCEDURE WriteInfo;
BEGIN
  WRITELN ('Test der UNIT VESA24 unter Turbo Pascal.');
  WRITELN;
  WRITELN ('Die UNIT VESA24 enthlt Prozeduren fr Truecolor (24/32 Bit/Pixel),');
  WRITELN ('und Auflsungen von 640*400 bis 1200*1024.');
  WRITELN ('Sie setzt voraus, da ein VESA-Treiber auf der VGA-Karte ');
  WRITELN ('vorhanden ist oder als residentes Programm geladen wurde.');
  WRITELN;
  WRITELN ('Dieses Programm soll die Anwendung der UNIT VESA24 zeigen und');
  WRITELN ('gleichzeitig als Test fr die einzelnen Prozeduren dienen. Dazu ');
  WRITELN ('gestattet es, die zu testenden Objekte ber den Bildschirm zu');
  WRITELN ('bewegen, auszumessen, die Bankgrenzen anzuzeigen und whrend');
  WRITELN ('eines jeden Tests zwischen den verschiedenen Auflsungen');
  WRITELN ('umzuschalten.');
  WRITELN;
  WRITELN ('Jrgen Petsch fr c`t 2/97');
  WRITELN;
  WRITELN;
END;                                                  { PROCEDURE WriteInfo }

CONST
      ScanCuUp=$48;     ScanCuDo=$50;      ScanCuRi=$4D;       ScanCuLe=$4B;
  ScanCtrlCuUp=$8D; ScanCtrlCuDo=$91;  ScanCtrlCuRi=$74;   ScanCtrlCuLe=$73;
   ScanAltCuUp=$98;  ScanAltCuDo=$A0;   ScanAltCuRi=$9D;    ScanAltCuLe=$9B;

   ScanCuHo=71; ScanCuEnd=79;  ScanPageUp=73; ScanPageDo=81;
    ScanESC=$01;  ScanBS=$E;    ScanCR=$1C;
  ScanSpace=$39;   ScanB=48;

     ScanF1=$3B;   ScanF2=$3C;     ScanF3=$3D;   ScanF4=$3E;
     ScanF5=$3F;   ScanF6=$40;     ScanF7=$41;   ScanF8=$42;
     ScanF9=$43;   ScanF10=$44;
     Zeilabst=16;

TYPE
   Save = ^BYTE;

VAR
  SpriteSave, ZoomSave             : Save;
  x,y,b,br,h,ho,r,l,i              : WORD;
  Blau, Gruen, Rot                 : WORD;  { Farbkomponenten }
  Xmax, Ymax                       : WORD;  { Sichtbarer Bildschirm }
  Xfaecher, Yfaecher               : WORD;  { Gre des Hintergrundfchers }
  BytesPerPixel, VESAErr           : WORD;  { fr SetVESAMode }
  MemSize, Version                 : WORD;  { fr GetVESAInfo }
  ErrCode                          : WORD;  { fr Sprite2File, Sprite2Bmp ..}
  Buffer                           : ARRAY [0..9999] OF BYTE;
  BufferPtr                        : POINTER;
  f                                : FILE;
  Ch                               : CHAR;
  ScanCode                         : BYTE;
  OEMString, Title, PathName       : STRING;
  GlobalXOR, HelpOn                : BOOLEAN;
  X0mess, X1mess, Y0mess, Y1mess   : WORD; { Koordinaten des Memoduls }
  Xzoom, Yzoom, Bzoom, Hzoom       : WORD; { Koordinaten von Zoom }


PROCEDURE PutText (x,y,CharSize,Blau,Gruen,Rot:WORD; txt:STRING);
VAR i : BYTE;
BEGIN
  FOR i:=1 TO LENGTH(txt) DO BEGIN
    PutChar(x,y,BYTE(txt[i]),CharSize,Blau,Gruen,Rot);
    INC(x,8*((CharSize SHR 1)+1))        { Neue X-Pos }
  END
END;                                                    { PROCEDURE PutText }


PROCEDURE StartTimer;
BEGIN
  ASM           MOV	AL,$34		{ Select Counter #0, Read Lo/HIByte }
					{ Counter Mode 2, Binary Count }
		OUT	$43,AL		{ Command-Port = 43H }
		MOV	AL,0
		OUT	$40,AL		{ LoByte = 0 }
		OUT	$40,AL		{ HiByte = 0 }
  END;
END;


PROCEDURE DispTimer (X,Y : WORD);
VAR Timer : WORD; Zeit : STRING;
BEGIN
  ASM
		MOV	AL,0		{ Latch Counter #0 }
		OUT	$43,AL
		IN	AL,$40		{ Read Lobyte }
		XCHG	AL,AH		{ ins HiByte  }
		IN	AL,$40		{ Read HiByte }
		XCHG	AH,AL
		NEG	AX		{ Timer zhlt abwrts ! }
                MOV     [Timer],AX
  END;
  STR (LONGINT (Timer)*100 DIV 119,Zeit);
  SetMovMode;
  FillSprite (X,Y,48,16,0,0,0);
  PutText (X+8,Y,0,150,150,150,Zeit);
END;


PROCEDURE PutWord (x,y,CharSize,r,g,b,Zahl:WORD);
VAR txt : STRING;
    i : BYTE;
BEGIN
  STR(zahl,txt);
  FOR i:=1 TO LENGTH(txt) DO BEGIN
    PutChar(x,y,BYTE(txt[i]),CharSize,r,g,b);
    INC(x,8*((CharSize SHR 1)+1))        { Neue X-Pos }
  END
END;                                                    { PROCEDURE PutWord }


PROCEDURE PutHelp;
VAR x,y,y0,b,h  : WORD;
BEGIN
  x:=360; y:=120; y0:=8; b:=268; h:=304;
  BufferPtr:=@Buffer;
  IF HelpOn
  THEN BEGIN                                      { Restauriere Hintergrund }
    File2Sprite(x,y,b,h,Pathname,ErrCode,BufferPtr,SIZEOF(Buffer));
    ASSIGN (f,PathName);
    ERASE (f);
    HelpOn:=FALSE;
  END
  ELSE BEGIN                                          { Sichere Hintergrund }
    PathName:='C:SPRITE.SCR'+Chr(0);
    Sprite2File(x,y,b,h,Pathname,ErrCode,BufferPtr,SIZEOF(Buffer));            
    SetMOVMode;
    FillSprite(x,y,b,h,150,150,150);                 { Erzeuge Grundfche ..}
    PutRect (x+4,y+4,b-8,h-8,255,0,0);                     {..mit Umrandung }
    PutText (x+10,y+y0+0*ZeilAbst,0,255,0,0, '     Curs..bewegen um 8');
    PutText (x+10,y+y0+1*ZeilAbst,0,255,0,0, 'Ctrl Curs..bewegen um 1');
    PutText (x+10,y+y0+2*ZeilAbst,0,255,0,0, ' Alt Curs..grer/kleiner um 1');
    PutText (x+10,y+y0+3*ZeilAbst,0,255,0,0, '        B..Bankgrenzen ein');
    PutText (x+10,y+y0+4*ZeilAbst,0,255,0,0, '      1-6...Farbkomponenten');
    PutText (x+10,y+y0+5*ZeilAbst,0,255,0,0, '       F1..Help ein/aus');
    PutText (x+10,y+y0+6*ZeilAbst,0,255,0,0, '       F2..XOR ein/aus');
    PutText (x+10,y+y0+7*ZeilAbst,0,255,0,0, '       F3..Melinien');
    PutText (x+10,y+y0+8*ZeilAbst,0,255,0,0, '       F4..Zoom');
    PutText (x+10,y+y0+9*ZeilAbst,0,255,0,0, '       F5.. 640*400');
    PutText (x+10,y+y0+10*ZeilAbst,0,255,0,0,'       F6.. 640*480');
    PutText (x+10,y+y0+11*ZeilAbst,0,255,0,0,'       F7.. 800*600');
    PutText (x+10,y+y0+12*ZeilAbst,0,255,0,0,'       F8..1024*768');
    PutText (x+10,y+y0+13*ZeilAbst,0,255,0,0,'       F9..1152*864');
    PutText (x+10,y+y0+14*ZeilAbst,0,255,0,0,'      F10..1280*1024');
    PutText (x+10,y+y0+15*ZeilAbst,0,255,0,0,'       CR..nchster Test');
    PutText (x+10,y+y0+16*ZeilAbst,0,255,0,0,'       BS..voriger Test');
    PutText (x+10,y+y0+17*ZeilAbst,0,255,0,0,'      ESC..Abbruch');
    HelpOn:=TRUE;
    HelpOn:=TRUE;
  END;
END;                                                   { PROCEDURE PutHelp }


PROCEDURE DispVESAInfoBlock;
BEGIN
  WRITELN ('           VESA-Bios: vorhanden');
  GetVESAInfo (OEMString,MemSize,Version);
  WRITELN ('          Hersteller: ',OEMString);
  WRITELN ('             Version: ',Hi(Version),'.',Lo(Version));
  WRITELN ('Video-Memory [kByte]: ',MemSize);
  WRITELN;
END;                                         { PROCEDURE DispVESAInfoBlock }


PROCEDURE PutFaecher;
VAR x,y : WORD;
BEGIN
  FOR y:=0 TO Yfaecher DO
    PutLine(0,y,Xfaecher-1,Yfaecher-y,255-LONGINT(y)*255 DIV YFaecher,
                                    LONGINT(y)*255 DIV YFaecher,0);
  FOR x:=0 TO Xfaecher-1 DO
    PutLine(x,0,Xfaecher-x,Yfaecher,0,0,(LONGINT(x)*255) DIV Xfaecher);
END;                                                 { PROCEDURE PutFaecher }


PROCEDURE PutColorStatus;
BEGIN
  FillSprite (Blau+12,21,255-Blau,8,0,0,0);
  FillSprite (11,21,Blau,8,255,0,0);
  PutRect (10,20,257,9,128,128,128);

  FillSprite (Gruen+12,31,255-Gruen,8,0,0,0);
  FillSprite (11,31,Gruen,8,0,255,0);
  PutRect (10,30,257,9,128,128,128);

  FillSprite (Rot+12,41,255-Rot,8,0,0,0);
  FillSprite (11,41,Rot,8,0,0,255);
  PutRect (10,40,257,9,128,128,128);
END;                                            { PROCEDURE DispColorStatus }


PROCEDURE PutBackGnd;
VAR TxtX, TxtY, Zeile :STRING;

BEGIN
  SetMovMode;
  ClearVGAMem;
  PutFaecher;
  PutRect (0,0,XFaecher-1,YFaecher-1,255,255,255);
  PutText (10,4,0,200,200,200,'F1-> Hilfe');
  STR (XFaecher,TxtX); STR(YFaecher,TxtY); Zeile:= ('Auflsung: '+TxtX+'*'+TxtY);
  PutText (160,4,0,150,150,150,Zeile);
  IF GlobalXOR THEN PutText (360,4,0,150,150,150,'XOR-Mode')
               ELSE PutText (360,4,0,150,150,150,'MOV-Mode');
  PutColorStatus;
  PutText (100,60,2,150,150,150,Title);
END;                                                { PROCEDURE PutBackGnd }


PROCEDURE SetMode (Breite, Hoehe: WORD);
VAR NextVESAErr : WORD;
BEGIN
  HelpOn:=FALSE;
  SetVESAMode(Breite,Hoehe,BytesPerPixel,VESAErr);
  IF VESAErr<>0 THEN
  BEGIN
    SetVESAMode(Xmax+1,Ymax+1,BytesPerPixel,NextVESAErr);
    CASE VESAErr OF
      1 : PutText(100,100,1,180,180,180,'Modus nicht vom VESA-BIOS untersttzt');
      2 : PutText(100,100,1,180,180,180,'ModeInfoBlock nicht gefllt');
      3 : PutText(100,100,1,180,180,180,'Einschalten des Modus fehlgeschlagen');
    END;
    Ch:=READKEY;
  END
  ELSE BEGIN
    Xmax:=Breite-1; Ymax:=Hoehe-1;
    XFaecher:=Breite; YFaecher:=Hoehe;
  END;
  PutBackGnd;
END;                                                    { PROCEDURE SetMode }


PROCEDURE PutMess;             { Zeigt die Melinien und die Koordinaten an }
BEGIN
  PutLineH (0,Y0mess,Xmax,150,150,150);
  PutLineV (X0mess,0,Ymax,150,150,150);
  PutLineH (0,Y1mess,Xmax,150,150,150);
  PutLineV (X1mess,0,Ymax,150,150,150);
  PutText (10,80,0,150,150,150,'X = ');
  PutText (10,96,0,150,150,150,'Y = ');
  PutText (10,112,0,150,150,150,'dX = ');
  PutText (10,128,0,150,150,150,'dY = ');
  PutWord (70,80,0,150,150,150,X0mess);
  PutWord (70,96,0,150,150,150,Y0mess);
  PutWord (70,112,0,150,150,150,X1mess-X0mess);
  PutWord (70,128,0,150,150,150,Y1mess-Y0mess);
END;


PROCEDURE Zoom;               { Erlaubt die Bewegung einer gezoomten Flche }
BEGIN
  Xzoom:=150; Yzoom:=150; Bzoom:=128; Hzoom:=128;
  GETMEM (ZoomSave,Bzoom*Hzoom);
  REPEAT
    GetSprite (Xzoom,Yzoom,Bzoom,Hzoom,ZoomSave);     { Flche zum ZoomSave }
    SetXORMode;
    PutRect (Xzoom-1,Yzoom-1,Bzoom+2,Hzoom+2,150,150,150);{ Zeichne Umrandung}
    ZoomSprite(Xzoom,Yzoom,Bzoom,Hzoom,ZoomSave);{ Zoome vom Save zum Screen }
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    PutSprite (Xzoom,Yzoom,Bzoom,Hzoom,ZoomSave); { Restauriere Hintergrund }
    PutRect (Xzoom-1,Yzoom-1,Bzoom+2,Hzoom+2,150,150,150);{ Lsche Umrandung }
    CASE ScanCode OF
      ScanCtrlCuUp   : DEC (Yzoom);
      ScanCtrlCuDo   : INC (Yzoom);
      ScanCtrlCuRi   : INC (Xzoom);
      ScanCtrlCuLe   : DEC (Xzoom);
      ScanCuUp       : DEC (Yzoom,8);
      ScanCuDo       : INC (Yzoom,8);
      ScanCuRi       : INC (Xzoom,8);
      ScanCuLe       : DEC (Xzoom,8);
    END;
  UNTIL ScanCode IN [ScanCR, ScanESC];
  FREEMEM (ZoomSave,Bzoom*Hzoom);
  ScanCode:=255;
END;


PROCEDURE Mess;                       { Erlaubt die Bewegung von Melinien
                                       und zeigt die entspr. Koordinaten an }
BEGIN
  SetXORMode;
  PutMess;                                   { Zeige Melinien und Werte an }
  REPEAT
    ScanCode:=GetScanCode;
    IF ScanCode=ScanF4 THEN Zoom;
    PutMess;                                   { Lsche Melinien und Werte }
    CASE ScanCode OF
      ScanCtrlCuUp   : DEC (Y0Mess);
      ScanCtrlCuDo   : INC (Y0Mess);
      ScanCtrlCuRi   : INC (X0mess);
      ScanCtrlCuLe   : DEC (X0mess);
      ScanCuUp       : DEC (Y0mess,8);
      ScanCuDo       : INC (Y0mess,8);
      ScanCuRi       : INC (X0mess,8);
      ScanCuLe       : DEC (X0mess,8);
      ScanAltCuUp    : DEC (Y1mess);
      ScanAltCuDo    : INC (Y1mess);
      ScanAltCuRi    : INC (X1mess);
      ScanAltCuLe    : DEC (X1mess);
      ScanCuHo       : BEGIN DEC (X0mess); DEC (X1mess); END;
      ScanCuEnd      : BEGIN INC (X0mess); INC (X1mess); END;
      ScanPageUp     : BEGIN DEC (Y0mess); DEC (Y1mess); END;
      ScanPageDo     : BEGIN INC (Y0mess); INC (Y1mess); END;
    END;
    PutMess;                            { Zeige neue Melinien und Werte an }
  UNTIL ScanCode IN [ScanESC, ScanCR];
  PutMess;                                     { Lsche Melinien und Werte }
  ScanCode:=255;
END;                                                    { PROCEDURE PutMess }


PROCEDURE LookForCmd;    { erhlt einen ScanCode und verzweigt entsprechend }
BEGIN
  SetMOVMode;
  CASE ScanCode OF
         2  { Taste '1'} : BEGIN
                             IF Blau > 2 THEN DEC (Blau,2);
                             PutColorStatus;
                           END;
         3  { Taste '2'} : BEGIN
                             IF Blau < 254 THEN INC (Blau,2);
                             PutColorStatus;
                           END;
         4  { Taste '3'} : BEGIN
                             IF Gruen > 2 THEN DEC (Gruen,2);
                             PutColorStatus;
                           END;
         5  { Taste '4'} : BEGIN
                             IF Gruen < 254 THEN INC (Gruen,2);
                             PutColorStatus;
                           END;
         6  { Taste '5'} : BEGIN
                             IF Rot > 2 THEN DEC (Rot,2);
                             PutColorStatus;
                           END;
         7  { Taste '6'} : BEGIN
                             IF Rot < 254 THEN INC (Rot,2);
                             PutColorStatus;
                           END;
    ScanF1               : PutHelp;
    ScanF2               : BEGIN
                             GlobalXOR:=NOT GlobalXOR;
                             IF GlobalXOR THEN BEGIN
                               FillSprite (360,4,64,16,0,0,0);
                               PutText (360,4,0,150,150,150,'XOR-Mode');
                             END
                             ELSE BEGIN
                               FillSprite (360,4,64,16,0,0,0);
                               PutText (360,4,0,150,150,150,'MOV-Mode');
                               IF b>150 THEN b:=150;
                               IF h>100 THEN h:=100;
                               IF r>60 THEN r:=60;
                             END;
                           END;
    ScanF5               : SetMode (640,400);
    ScanF6               : SetMode (640,480);
    ScanF7               : SetMode (800, 600);
    ScanF8               : SetMode (1024, 768);
    ScanF9               : SetMode (1152,864);
    ScanF10              : SetMode (1280,1024);
    ScanB                : ShowBanks;
    ScanCuUp             : DEC(y,8);
    ScanCuDo             : INC(y,8);
    ScanCuRi             : INC(x,8);
    ScanCuLe             : DEC(x,8);
    ScanCtrlCuUp         : DEC(y);
    ScanCtrlCuDo         : INC(y);
    ScanCtrlCuRi         : INC(x);
    ScanCtrlCuLe         : DEC(x);
  END;
END;                                                 { PROCEDURE LookForCmd }


PROCEDURE LineVTest;                        { Erlaubt den Test von PutLineV }
VAR Zeit, Zeile : STRING;
BEGIN
  Title:='LineVTest';
  PutBackGnd;
  x:=250; y:=100; l:=200;
  REPEAT
    IF GlobalXOR THEN SetXORMode ELSE SetMOVMode;
    StartTimer;
    PutLineV(x,y,l,Blau,Gruen,Rot);                     { Zeichne Vertikale }
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN
      SetXORMode;
      PutLineV(x,y,l,Blau,Gruen,Rot);                    { Lsche Vertikale }
    END;
    LookForCmd;                                   { XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                                    { l }
      ScanAltCuUp    : IF l > 0 THEN DEC(l);
      ScanAltCuDo    : INC(l);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                  { PROCEDURE LineVTest }


PROCEDURE LineHTest;                        { Erlaubt den Test von PutLineH }
BEGIN
  Title:='LineHTest';
  PutBackGnd;
  x:=250; y:=100; l:=200;
  REPEAT
    IF GlobalXOR THEN SetXORMode ELSE SetMOVMode;
    StartTimer;
    PutLineH(x,y,l,Blau,Gruen,Rot);                   { Zeichne Horizontale }
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN                                  { Lsche Horizontale }
    BEGIN
      SetXORMode;
      PutLineH(x,y,l,Blau,Gruen,Rot);
    END;
    LookForCmd;                                   { XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                                    { l }
      ScanAltCuLe    : IF l > 0 THEN DEC (l);
      ScanAltCuRi    : INC (l);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                  { PROCEDURE LineHTest }


PROCEDURE LineTest;                          { Erlaubt den Test von PutLine }
VAR
  Xend, Yend   : WORD;
BEGIN
  Title:='LineTest';
  PutBackGnd;
  x:=100; y:=400; Xend:=420; Yend:=40;
  REPEAT
    PutText (100,100,0,150,150,150,'Alt Curs: anderes Ende bewegen');
    IF GlobalXOR THEN SetXORMode ELSE SetMOVMode;
    StartTimer;
    PutLine(x,y,Xend,Yend,Blau,Gruen,Rot);                 { Zeichne Gerade }
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN                                       { Lsche Gerade }
    BEGIN
      SetXorMode;
      PutLine(x,y,Xend,Yend,Blau,Gruen,Rot);
    END;
    LookForCmd;                                   { XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                           { Xend, Yend }
      ScanAltCuLe    : DEC (Xend);
      ScanAltCuRi    : INC (Xend);
      ScanAltCuUp    : DEC (Yend);
      ScanAltCuDo    : INC (Yend);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE LineTest }


PROCEDURE RectTest;                          { Erlaubt den Test von PutRect }
BEGIN
  Title:=('RectangleTest');
  PutBackGnd;
  x:=200; y:=200; b:=150; h:=100;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x,y,b+1,h+1,SpriteSave);
    END;
    StartTimer;
    PutRect(x,y,b,h,Blau,Gruen,Rot);
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN                                             { Lsche das Rechteck }
      SetXORMode;
      PutRect(x,y,b,h,Blau,Gruen,Rot);
    END
    ELSE PutSprite(x,y,b+1,h+1,SpriteSave);    { oder rest. es aus dem Mem. }
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>2 THEN DEC (b);
      ScanAltCuRi    : IF ((b*h<($FFF0 DIV BytesPerPixel-b))
                       OR GlobalXOR) THEN INC (b);
      ScanAltCuUp    : IF h>1 THEN DEC (h);
      ScanAltCuDo    : IF ((b*h<($FFF0 DIV BytesPerPixel-h))
                       OR GlobalXOR) THEN INC (h);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE RectTest }


PROCEDURE SpriteTest;   { Erlaubt Test von GetSprite, FillSprite, PutSprite }
BEGIN
  Title:='SpriteTest';
  PutBackGnd;
  x:=200; y:=200; b:=150; h:=100;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      StartTimer;
      GetSprite(x,y,b,h,SpriteSave);
      DispTimer (580,4);
      PutText (460,4,0,150,150,150,'GetSprite [s]:');
    END;
    StartTimer;
    FillSprite(x,y,b,h,Blau,Gruen,Rot);
    DispTimer (580,20);
    PutText (460,20,0,150,150,150,'FillSprite[s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN                                               { Lsche das Sprite }
      SetXorMode;
      FillSprite(x,y,b,h,Blau,Gruen,Rot);
    END
    ELSE BEGIN
      StartTimer;
      PutSprite(x,y,b,h,SpriteSave);  { oder restore das Sprite aus dem Mem }
      DispTimer (580,36);
      PutText (460,36,0,150,150,150,'PutSprite [s]:');
    END;
    LookForCmd;                                   { XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>1 THEN DEC (b);
      ScanAltCuRi    : IF ((b*h<($FFF0 DIV BytesPerPixel-b))
                       OR GlobalXOR) THEN INC (b);
      ScanAltCuUp    : IF h>1 THEN DEC (h);
      ScanAltCuDo    : IF ((b*h<($FFF0 DIV BytesPerPixel-h))
                       OR GlobalXOR) THEN INC (h);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                 { PROCEDURE SpriteTest }


PROCEDURE Sprite2FileTest;               { Erlaubt den Test von Sprite2File }
BEGIN
  Title:=('Sprite2FileTest');
  PutBackGnd;
  x:=160; y:=160; b:=300; h:=200;
  BufferPtr:=@Buffer;
  REPEAT
    PutText (100,96,0,150,150,150,'Leertaste: Sprite im File ablegen');
    PutText (100,112,0,150,150,150,'Bel.Taste: Sprite zurcklesen');
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,128,128,128);
    SetMOVMode;
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,128,128,128);
    SetMOVMode;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>2 THEN DEC(b);
      ScanAltCuRi    : INC(b);
      ScanAltCuUp    : IF h>2 THEN DEC(h);
      ScanAltCuDo    : INC(h);
      ScanSpace      : BEGIN
                         PathName:='C:SPRITE.SCR'+Chr(0);
                         Sprite2File (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         FillSprite (x,y,b,h,255,0,0);
                         Ch:=READKEY;
                         File2Sprite (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         ASSIGN (f,PathName);
                         ERASE (f);
                       END;
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                            { PROCEDURE Sprite2FileTest }


PROCEDURE Sprite2BmpTest;                 { Erlaubt den Test von Sprite2Bmp }
VAR BufferPtr : POINTER;

BEGIN
  Title:=('Sprite2BmpTest');
  PutBackGnd;
  x:=160; y:=140; b:=360; h:=240;
  BufferPtr:=@Buffer;
  REPEAT
    PutText (100,96,0,150,150,150,'Leertaste: Sprite im File ablegen');
    PutText (100,112,0,150,150,150,'Bel.Taste: Sprite zurcklesen');
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,150,150,150);
    SetMOVMode;
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,150,150,150);
    SetMOVMode;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>2 THEN DEC(b);
      ScanAltCuRi    : INC(b);
      ScanAltCuUp    : IF h>2 THEN DEC(h);
      ScanAltCuDo    : INC(h);
      ScanSpace      : BEGIN
                         PathName:='C:Sprite.BMP'+Chr(0);
                         Sprite2Bmp (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         FillSprite (x,y,b,h,255,0,0);
                         Ch:=READKEY;
                         PathName:='C:Parrots.BMP'+Chr(0);
                         Bmp2Sprite (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         Ch:=READKEY;
                         PathName:='C:Sprite.BMP'+Chr(0);
                         Bmp2Sprite (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                       END;
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                             { PROCEDURE Sprite2BmpTest }


PROCEDURE CircTest;                        { Erlaubt den Test von PutCircle }
BEGIN
  Title:=('CircTest');
  PutBackGnd;
  x:=200; y:=200; r:=50;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    END;
    StartTimer;
    PutCircle (x,y,r,Blau,Gruen,Rot);
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN
      SetXorMode;
      PutCircle (x,y,r,Blau,Gruen,Rot);
    END
    ELSE PutSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                               { Radius }
      ScanAltCuUp : IF ((2*r+2)*(2*r+2)< $FFF0 DIV BytesPerPixel)
                    OR (GlobalXOR) THEN INC (r);
      ScanAltCuDo : IF r>2 THEN DEC(r);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
  HelpOn:=FALSE;
END;                                                   { PROCEDURE CircTest }


PROCEDURE DiskTest;                          { Erlaubt den Test von PutDisk }
BEGIN
  Title:=('DiskTest');
  PutBackGnd;
  x:=200; y:=200; r:=50;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    END;
    StartTimer;
    PutDisk(x,y,r,Blau,Gruen,Rot);
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN
      SetXORMode;
      PutDisk(x,y,r,Blau,Gruen,Rot);
    END
    ELSE PutSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                               { Radius }
      ScanAltCuUp : IF ((2*r+2)*(2*r+2)< $FFF0 DIV BytesPerPixel)
                    OR (GlobalXOR) THEN INC (r);
      ScanAltCuDo : IF r>2 THEN DEC(r);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE DiskTest }


PROCEDURE PutCharTest;                       { Erlaubt den Test von PutChar }

PROCEDURE PutTestText;
BEGIN
    PutText(x,y,0,Blau,Gruen,Rot,'Einfach');
    PutText(x,y+16,1,Blau,Gruen,Rot,'Doppelt hoch');
    PutText(x,y+48,2,Blau,Gruen,Rot,'Doppelt h+b');
END;

BEGIN
  Title:=('PutCharTest');
  PutBackGnd;
  x:=200; y:=200; br:=180; ho:=80;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x,y,br,ho,SpriteSave);   { Sichere den Hintergrund fr Text }
    END;
    StartTimer;
    PutTestText;                                        { Schreibe den Text }
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN                { Lsche Text durch erneutes Schreiben }
    BEGIN
      SetXorMode;
      PutTestText;
    END
    ELSE PutSprite(x,y,br,ho,SpriteSave);   { oder durch Restaur. der Flche}
    LookForCmd;                                        { Verndere X oder Y }
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                { PROCEDURE PutCharTest }


PROCEDURE GetPixelTest;                     { Erlaubt den Test von GetPixel }
VAR U,V,Rot,Gruen,Blau:WORD;
BEGIN
  Title:=('GetPixelTest');
  PutBackGnd;
  X:=100; Y:=100; b:=100; h:=100;
  REPEAT
    GetSprite(x+200,y,b,h,SpriteSave);
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,100,100,100);
    IF GlobalXOR THEN SetXORMode ELSE SetMOVMode;
    FOR U:=X TO X+b-1 DO
    BEGIN
      FOR V:=Y TO Y+h-1 DO
      BEGIN
        GetPixel (U,V,Rot,Gruen,Blau);
        PutPixel (U+200,V,Rot,Gruen,Blau);
      END;
    END;
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,100,100,100);
    SetMOVMode;
    PutSprite(x+200,y,b,h,SpriteSave);               { Restore aus dem Mem. }
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                               { PROCEDURE GetPixelTest }


PROCEDURE PixelTest;

PROCEDURE PixelFill;                      { Fllt den Bildschirm pixelweise }
VAR            { Beim S3-Chip kann das etwas dauern, Bankswitch ist langsam }
 F1, F2, F3 :WORD;
BEGIN          
   FOR Y:=0 TO Ymax DO
   BEGIN
     IF KEYPRESSED THEN EXIT
     ELSE BEGIN
       FOR X:= 0 TO XMAX DO
       BEGIN
         F1:=(255*LongINT(X) DIV LONGINT(Xmax));
         F2:=(255*LONGINT(Y) DIV LONGINT(Ymax));
         F3:=F1+F2;
         PutPixel (X,Y,F1,F2,F3);
       END;
    END;
  END;
END;                                                  { PROCEDURE PixelFill }

BEGIN
  ClearVGAMem;
  SetMOVMode;
  PutText (100,400,2,200,200,200,'PixelFill (MOVMode)');
  PixelFill; 
  ScanCode:=GetScanCode;                                  { Warte auf Taste }
  IF ScanCode IN [ScanCR, ScanBS, ScanESC] THEN EXIT;
  SetXORMode;
  ClearVGAMem;
  PutText (100,400,2,200,200,200,'PixelFill(XORMode)');
  PixelFill;                                            { Zeichne die Pixel }
  ScanCode:=GetScanCode;                                  { Warte auf Taste }
  PutText (100,400,2,200,200,200,'PixelFill(XORMode)');       { Lsche Text }
  IF ScanCode IN [ScanCR, ScanBS, ScanESC] THEN EXIT;
  PutText (100,400,2,200,200,200,'PixelFill (Lschen im XORMode)');
  PixelFill;                                             { Lsche die Pixel }
  ScanCode:=GetScanCode;                                  { Warte auf Taste }
END;                                                  { PROCEDURE PixelTest }


PROCEDURE ZoomTest;                       { Erlaubt den Test von ZoomSprite }
BEGIN
  Title:=('ZoomTest');
  PutBackGnd;
  x:=200; y:=180; b:=128; h:=128;
  REPEAT
    GetSprite(x,y,b,h,SpriteSave);               { Flche in den SpriteSave }
    SetXORMode; PutRect (x-1,y-1,b+2,h+2,150,150,150);  { Zeichne Umrandung }
    StartTimer;
    ZoomSprite(x,y,b,h,SpriteSave);       { Zoome vom SpriteSave zum Screen }
    DispTimer (540,4);
    PutText (460,4,0,150,150,150,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    PutSprite(x,y,b,h,SpriteSave);                { Restauriere Hintergrund }
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,150,150,150);             { Lsche Umrandung }
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                     { Breite oder Hhe }
      ScanAltCuLe    : IF b>4 THEN b:=b-2;
      ScanAltCuRi    : IF b*h<($FFF0 DIV BytesPerPixel-2*b) THEN b:=b+2;
      ScanAltCuUp    : IF h>2 THEN DEC (h);
      ScanAltCuDo    : IF b*h<($FFF0 DIV BytesPerPixel-h) THEN INC (h);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE ZoomTest }


BEGIN                                                       { Hauptprogramm }
  SetAlfaMode;
  WriteInfo;
  IF VESAAvail
    THEN DispVESAInfoBlock
    ELSE BEGIN
           WRITELN ('Kein VESA-Bios vorhanden.');
           Ch:=READKEY;
           EXIT;
         END;
  Ch:=READKEY;
  Blau:=180; Gruen:=180; Rot:=180;
  SetVESAMode (640,480,BytesPerPixel,VESAErr);
  IF VESAErr<>0 THEN
  BEGIN
    SetAlfaMode;
    CASE VESAErr OF
       1 : WRITELN ('Modus wird nicht vom VESA-BIOS untersttzt');
       2 : WRITELN ('ModeInfoBlock konnte nicht gefllt werden');
       3 : WRITELN ('Einschalten des Modus fehlgeschlagen');
    END;
    Ch:=READKEY;
    EXIT;
  END;

  GETMEM (SpriteSave,$FFF0);          { Flche zum Retten des Hintergrundes }

  GlobalXOR:=FALSE; HelpOn:=FALSE;

  SetMOVMode;

  Xfaecher:=640; YFaecher:=480;
  Xmax:=639; Ymax:=479;

  X0mess:=200; Y0mess:=200; { Koordinaten des Memoduls }
  X1mess:=360; Y1mess:=400;

  i:=1;
  REPEAT
    CASE i OF
      1 : LineHTest;
      2 : LineVTest;
      3 : LineTest;
      4 : RectTest;
      5 : SpriteTest;
      6 : ZoomTest;
      7 : Sprite2FileTest;
      8 : Sprite2BmpTest;
      9 : CircTest;
     10 : DiskTest;
     11 : PutCharTest;
     12 : GetPixelTest;
     13 : PixelTest;
    END;
    IF ScanCode=ScanCR THEN
    BEGIN
      INC (i);
      IF i=14 THEN i:=1;
    END;
    IF ScanCode=ScanBS THEN
    BEGIN
      DEC (i);
      IF i=0 THEN i:=13;
    END;
  UNTIL ScanCode=ScanESC;
  SetAlfaMode;
  FREEMEM (SpriteSave,$FFF0);
END.
