unit Autohlpu; { Help-Generator, 15-DEC-96 as (Arne Schpers) }
{ Generator einfachster Art, bei eigentlich nur der Scanner
  komplett ist. Analysiert eine Delphi-Unit und macht aus
  ihrem Implementationsteil eine Art Hilfestellung (RTF). }
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, Grids, Outline;
type  { Button-Enable und "Speichern?"-Rckfragen }
  TProgState = (psStart, psGotPas, psParsed, psSaved);
const BUFSIZE = 32767;  { Maximalgre Interface-Teil }
type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;  { Datei ffnen }
    SaveDialog1: TSaveDialog;  { Datei speichern }
    mPCode: TMemo;   { fr Vor- und Nachbearbeitung }
    bLoadPas: TButton; { PAS-Datei laden }
    bParse: TButton;   { Analysieren }
    lPasName: TLabel;  { Name der PAS-Datei }
    bSaveAsRTF: TButton; { Als RTF-Datei speichern }
    bHelp: TButton;    { Kontextbezogene (naja) Kurzhilfe }
    bUnParse: TButton; { Zurck zum (bearbeiteten) Original }
    Outline1: TOutline;
    procedure bHelpClick(Sender: TObject);
    procedure bLoadPasClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure mPCodeChange(Sender: TObject);
    procedure bParseClick(Sender: TObject);
    procedure bUnParseClick(Sender: TObject);
    procedure bSaveAsRTFClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject;
                  var CanClose: Boolean);
    procedure Outline1Click(Sender: TObject);
    procedure Outline1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    TextBuf, ParseBuf: PChar;
    FState: TProgState;
    PASEdited, ParseEdited: Boolean;
    SymList: TList;         { Liste der erfaten Symbole }
    CurrSymIndex: Integer;  { Editing: SymList[...]^.TextData }
    procedure ClearSymList;
    procedure SetState(Value: TProgState);
    procedure SaveAsRTF(FName: TFileName);
    procedure AnalysisToOutline;
  public
    property ProgState : TProgState read FState write SetState;
  end;

var Form1: TForm1;

implementation
{$R *.DFM}
procedure TForm1.FormCreate(Sender: TObject);
begin
  ProgState := psStart;
  { Ein Byte mehr fr ein abschlieendes NUL }
  GetMem(TextBuf,BUFSIZE+1); GetMem(ParseBuf,BUFSIZE+1);
  mPCode.HideSelection := False;
  with mPCode do { Outline so hoch wie mPCode, 1/4 Breite }
     Outline1.SetBounds(Left,Top,Width div 4,Height);
  Outline1.SendToBack; { und ab in den Hintergrund }
  SymList := TList.Create;  { Analysierte Symbole }
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FreeMem(TextBuf,BUFSIZE+1); FreeMem(ParseBuf,BUFSIZE+1);
  ClearSymList;  { ziemlich weit hinten wg. Typdeklaration }
  SymList.Free;
end;

procedure TForm1.SetState(Value: TProgState);
begin  { Programmzustandswechsel - Button-Enable }
  FState := Value;
  bParse.Enabled := Value = psGotPAS;
  bUnParse.Enabled := Value >= psParsed;
  bSaveAsRTF.Enabled := Value >= psParsed;
  if Value < psParsed
    then bHelp.Caption := 'Hilfe'
    else bHelp.Caption := 'Outline';
  ActiveControl := mPCode;
  if ProgState < psParsed then
  begin  { Outline nach hinten, Editor volle Gre }
    Outline1.SendToBack;
    mPCode.SetBounds(0,mPCode.Top,ClientWidth-5,mPCode.Height);
  end else
  begin  { Outline nach vorne, Editor 3/4 Gre }
    Outline1.BringToFront;
    mPCode.SetBounds(Outline1.Width+1,mPCode.Top,
                    ClientWidth-6-Outline1.Width,mpCode.Height);
  end;
end;

procedure TForm1.bHelpClick(Sender: TObject);
begin
  if bHelp.Caption = 'Hilfe' then
    ShowMessage('Einfacher Help-Generator fr Delphi-Units.'#10+
     '1. Pascal-Unit laden, berflssiges rauswerfen'#10+
     '2. Parser starten, ggf. ber pUnParse zurcknehmen'#10+
     '3. Nachbearbeiten (separate "Hilfe")'#10+
     '4. Als RTF speichern, in WinWord weiter bearbeiten')
  else  { nach Parsing }
    ShowMessage('Nach Mausklick in der Outline:'#10+
     '  ENTF: Lscht den ausgewhlten Eintrag '#10+
     '  LEERTASTE: Nimmt das Lschen wieder zurck'#10#10+
'Verschieben von Textteilen im Editorfenster per STRG+X,V,C'#10+
     'SaveAsRTF -> RTF-Datei, UnParse: zurck zum Rohtext');
  ActiveControl := mPCode;
end;

procedure TForm1.FormCloseQuery(Sender: TObject;
                                var CanClose: Boolean);
begin  { Rckfrage bei manuell verndertem Text }
  if (ProgState <> psSaved) and (PasEdited or ParseEdited) then
    CanClose := MessageDlg('Text manuell bearbeitet und nicht'+
      ' gespeichert. nderungen verwerfen?', mtConfirmation,
      [mbYes, mbNo], 0) = IDYES;
end;

procedure TForm1.mPCodeChange(Sender: TObject);
begin  { mPCode.OnChange }
  case ProgState of
    psStart: ProgState := psGotPAS; { Laden }
    psGotPAS: PASEdited := True;  { manuelle Vorbearbeitung }
    psParsed, psSaved: ParseEdited := True; { man. Nachbearb. }
  end;
end;

procedure TForm1.bUnParseClick(Sender: TObject);
begin
  if ParseEdited then
    if MessageDlg('Zurck zum Stand vor dem letzten Parsing?',
      mtConfirmation,[mbYes,mbNo],0) <> IDYES then Exit;
  ParseEdited := False;
  ProgState := psStart;
  Outline1.Clear;
  mPCode.SetTextBuf(TextBuf);
end;

{ ----------- Scanner --------------------- }

function IsWhiteSpace(Ch: Char): Boolean;
begin
  Result := (Ch=' ') or (Ch=#9) or (Ch=#13) or (Ch=#10);
end;

function IsNameChar(Ch: Char; FirstChar: Boolean): Boolean;
begin
  Result := ((Ch >= 'A') and (UpCase(Ch) <= 'Z')) or (Ch = '_');
  if not FirstChar
    then Result := Result or (Ch >= '0') and (Ch <= '9');
end;

var LastCommentStart, { Zuordnung vorlaufender Kommentare }
    LastCommentStop: PChar;
{ Liefert das jeweils nchste Zeichen; Whitespace, Kommentare
  und Stringliterale werden bersprungen }
function NextChar(var ParsePtr: PChar;
                  var Delimiter: Boolean): Char;
var StartPoint: PChar;
Label DoneOrEof;
begin
  Delimiter := False; StartPoint := ParsePtr;
  repeat
    while (ParsePtr^ <> #0) and IsWhiteSpace(ParsePtr^) do
      Inc(ParsePtr);
    if ParsePtr^ = #0 then goto DoneOrEof;
    if ParsePtr^ = '{' then   { Kommentar }
    begin
      LastCommentStart := ParsePtr;
      while (ParsePtr^ <> #0) and (ParsePtr^ <> '}') do
        Inc(ParsePtr);
      if ParsePtr^ <> #0 then Inc(ParsePtr);
      LastCommentStop := ParsePtr;
    end else
     if (ParsePtr^ = '(') and (ParsePtr[1] = '*') then
     begin                   (* Kommentar *)
       LastCommentStart := ParsePtr;
       repeat
         Inc(ParsePtr);
       until (ParsePtr^ = #0) or ((ParsePtr[1] = '*') and
         (ParsePtr[2] = ')'));
       if ParsePtr^ <> #0 then Inc(ParsePtr,2);
       LastCommentStop := ParsePtr;
     end else
      if (ParsePtr^ = '/') and (ParsePtr[1] = '/') then
      begin                 { // Kommentar (Delphi32) }
        LastCommentStart := ParsePtr;
        while (ParsePtr^ <> #0) and (ParsePtr^ <> #10) do
          Inc(ParsePtr);  { bis LF; CR ist fakultativ(!) }
        LastCommentStop := ParsePtr;
      end else
       if ParsePtr^ = '''' then
       begin                 { 'Stringliteral' }
         Inc(ParsePtr);
         while (ParsePtr^ <> #0) and (ParsePtr^ <> '''') do
           Inc(ParsePtr);
         if ParsePtr^ <> #0 then Inc(ParsePtr);
       end
        else Break;  { irgendein anderes Zeichen }
  until ParsePtr^ = #0;
DoneOrEof:
  Result := ParsePtr^; Delimiter := ParsePtr <> StartPoint;
end;

{ Liefert den jeweils nchsten Bezeichner und erhht ParsePtr.
  Result = Uppercase(Bezeichner), ParsePtr = nchstes Zeichen
  hinter dem Bezeichner, TokenStart = Start des Bezeichners }
function NextName(var ParsePtr, TokenStart: PChar): String;
var Delim: Boolean; NextCh: Char;
begin
  Result := '';
  repeat
    NextCh := Upcase(NextChar(ParsePtr,Delim));
    TokenStart := ParsePtr;
    if NextCh = #0 then Exit;
    Inc(ParsePtr);
    if IsNameChar(NextCh,True) then Break; { Bezeichner-Anfang }
  until False;

  Result := NextCh;
  repeat
    NextCh := Upcase(NextChar(ParsePtr,Delim));
    if (NextCh = #0) or Delim then Break;
    if IsNameChar(NextCh,False) then
    begin
      Result := Result+NextCh; Inc(ParsePtr);
    end
      else Break;
  until False;
end;

procedure TForm1.bLoadPasClick(Sender: TObject);
var FStream: TFileStream; FSize: LongInt;
    NameP, NameStartP: PChar; NameStr: String;
begin
  if (PasEdited or ParseEdited) and (ProgState <> psSaved) then
    if MessageDlg('Bearbeiteten Text verwerfen?',mtConfirmation,
     [mbYes, mbNo],0) <> IDYES then Exit;
  with OpenDialog1 do
  begin
    InitialDir := ExtractFilePath(FileName);
    FileName := '*.PAS';
    { Eigenschaften der Reproduzierbeit halber direkt gesetzt }
    Filter := 'Delphi-Units|*.PAS';
    DefaultExt := '.PAS'; Options := [ofFileMustExist];
    Title := 'Quelltext einer Delphi-Unit laden';

    if Execute then
    begin
      FStream := TFileStream.Create(FileName,fmOpenRead);
      FSize := FStream.Size;
      if FSize > BUFSIZE then FSize := BUFSIZE;
      TextBuf[FSize] := #0;
      FStream.Read(TextBuf^,FSize); FStream.Destroy;
      { Text vor 'Implementation' absgen }
      NameP := TextBuf;
      repeat
        if NextName(NameP,NameStartP) = 'IMPLEMENTATION'
          then NameStartP^ := #0;
      until NameStartP^ = #0;  { bei EOF ist NameStartP^ = #0 }
      ProgState := psStart;
      PASEdited := False; ParseEdited := False;
      mPCode.SetTextBuf(TextBuf);  { setzt psGotPAS }
      lPasName.Caption := FileName;
    end;
  end;
end;

procedure TForm1.bSaveAsRTFClick(Sender: TObject);
var x: Integer;
begin
  with SaveDialog1 do
  begin
    InitialDir := ExtractFilePath(FileName);
    FileName := ExtractFileName(lPasName.Caption);
    x := Pos('.',FileName);
    if x <> 0 then FileName := Copy(FileName,1,x-1);
    FileName := FileName + '.RTF';
    { Eigenschaften der Reproduzierbeit halber direkt gesetzt }
    Filter := 'RTF-Dateien|*.RTF';
    DefaultExt := '.RTF'; Options := [ofOverwritePrompt];
    Title := 'Als .HLP-Quelltext (RTF) speichern';
    if Execute then
    begin
      SaveAsRTF(FileName);
      ProgState := psSaved;
    end;
  end;
end;

{ Suche nach dem Ende einer Prozedur- oder Funktionsdeklaration,
  auch fr property verwendet.
  procedure NAME ;
  procedure NAME(Parm1: Typ; Parm2: Typ[;]) ;
  function NAME : Ergebnistyp ;
  function NAME(Parm1: Typ; Parm2: Typ[;]) : Ergebnistyp ;
  procedure NAME... virtual; abstract; etc.
}
function FindProcFuncEnd(PStart: PChar): PChar;
const Modifiers: Array[0..3] of String[10] =
  ('ABSTRACT','OVERRIDE','VIRTUAL','FORWARD');
var NextCh: Char; Delim: Boolean; BraceLevel: Integer;
    NewEnd, Dummy: PChar; Modifier: String; x: Integer;
    GotModifier: Boolean;
begin
  BraceLevel := 0;
  repeat
    NextCh := NextChar(PStart,Delim); Result := PStart;
    case NextCh of
      #0: Exit;
      '(': Inc(BraceLevel);
      ')': Dec(BraceLevel);
      ';': if BraceLevel = 0 then Break;
    end;
    Inc(PStart);
  until False;

  repeat  { hngen da ABSTRACT & Co. hintendran? }
    GotModifier := False;
    Modifier := NextName(PStart,Dummy);
    for x := 0 to 3 do
     if Modifier = Modifiers[x] then
     begin
       GotModifier := True; Result := PStart;
       Break;
     end;
  until not GotModifier;
end;

{ Suche nach dem Ende einer Record-Deklaration:
  type NAME = record ... end; const NAME: record ... end;
  type xyz = class(abc) NAME : record ... end;
  var xyz: Record ... end;
}
function FindRecEnd(PStart: PChar): PChar;
var NameStart: PChar; NameStr: String; RecLevel: Integer;
    NextCh: Char; Delim: Boolean;
begin
  RecLevel := 1;
  repeat
    NameStr := NextName(PStart,NameStart);
    if (NameStr = 'RECORD') or (NameStr = 'CASE')
     then Inc(RecLevel)
     else if NameStr = 'END' then Dec(RecLevel);
  until (NameStr = '') or (RecLevel = 0);
  if NameStr <> '' then
  repeat
    NextCh := NextChar(PStart,Delim);
    if (NextCh = #0) or (NextCh = ';') then Break
      else Inc(PStart);
  until False;
  Result := PStart;
end;

type
  TSymKind = (sVar, sType, sConst, sProc, sFunc,
              sProperty, sConstructor, sDestructor,
              sPrivate, sProtected, sPublic, sPublished,
              sDefined,  { <- keines der Schlsselwrter }
              sClass, sRecord, sEvent);  { nur fr Ausgabe }
const
 StartSymbols: Array[TSymKind] of String[11] =
  ('VAR','TYPE','CONST','PROCEDURE', 'FUNCTION','PROPERTY',
   'CONSTRUCTOR','DESTRUCTOR',
   'PRIVATE', 'PROTECTED','PUBLIC','PUBLISHED',
   'UNIT','CLASS','RECORD','EVENT');  { <- nur wg. Ausgabe }
type
{ SymList wird vom Scanner mit Zeigern auf TSymRec gefllt;
  PStart..CommentStop = Zeiger in den Textpuffer (TextBuf).
  AnalysisToOutline: Aufbau Outline mit Zeigern auf die Elemente
  von SymList, Umkopieren der Texte aus TextBuf (PStart..
  CommentStop) in selbstbelegte Puffer (TextData). Mit diesen
  Puffern findet das Editing ber die Outline statt. }
  TSymRec = record
    SymName, ClassName: String;
    SymKind: TSymKind;   { Art der Deklaration }
    { Start, Ende der Deklaration, Start,Stop Kommentare }
    PStart, PEnd, CommentStart, CommentStop: PChar;
    { Eigenstndig belegter Puffer fr Outline-Bearbeitung }
    TextData: PChar; { Destroy durch ClearSymList }
    Deleted: Boolean;  { via Outline zum Lschen markiert }
  end;
  PSymRec = ^TSymRec;

procedure TForm1.ClearSymList;
var x: Integer; P: PSymRec;
begin  { Die bei der Analyse aufgebaute Symbolliste }
  with SymList do
  begin
    for x := 0 to Count-1 do
    begin
      P := Items[x];
      if P^.TextData <> nil
        then FreeMem(P^.TextData,StrLen(P^.TextData)+1);
      Dispose(P);
    end;
    Clear;
  end;
end;

function NextPublic(var ScanPtr,NameStart: PChar;
   var SymKind: TSymKind; InPublic: Boolean): String;
var x: TSymKind;
Label NextLoop, FoundPublic;
begin  { nchstes public-Element in Klassendeklarationen }
NextLoop:
  if not InPublic then
  begin
    repeat
      Result := NextName(ScanPtr,NameStart);
      if Result = '' then Exit;
      if Result = 'RECORD' then ScanPtr := FindRecEnd(ScanPtr);
    until (Result = 'PUBLIC') or (Result = 'PUBLISHED')
       or (Result = 'END');
    if Result = 'END' then Exit;
  end;
FoundPublic:
  Result := NextName(ScanPtr,NameStart);
  if Result = 'END' then Exit;  { private ... public end; }
  if Result = '' then Exit;
  InPublic := False;
  for x := sProc to sPublished do
    if Result = StartSymbols[x] then
    case x of
      sProc..sDestructor:
      begin { public function/procedure/property NAME }
        Result := NextName(ScanPtr,NameStart);
        SymKind := x;
        Exit;
      end;
      sPrivate, sProtected:  { public private ... }
        goto NextLoop;
      sPublic, sPublished:  { public public ... }
        goto FoundPublic;
    end;
  { Dann mu es wohl ein Variablenbezeichner sein }
  SymKind := sVar;
end;

procedure TForm1.bParseClick(Sender: TObject);
var ScanPtr, NameStart: PChar; NameStr, CurrClassName: String;
    xS, SymKind: TSymKind; FoundStart, FoundSymbol: Boolean;
    NewSym: PSymRec; x: Integer;
Label DoneOrEof;

  procedure EnterSym(Name: String; Kind: TSymKind; Start: PChar);
  var CommentPtr: PChar;
  begin  { Makro, sozusagen, checkt aber auch die Kommentare }
    New(NewSym); SymList.Add(NewSym);
    { Zeiger: nil, Boolean: False }
    FillChar(NewSym^,SizeOf(TSymRec),0);
    with NewSym^ do
    begin  { sonst kommt der Name in Grobuchstaben an }
      SymName := Copy(StrPas(Start),1,Length(Name));
      SymKind := Kind; ClassName := ''; PStart := Start;
      if LastCommentStop <> nil then
      begin  { steht da direkt ein Kommentar vornedran? }
        while (Start >= LastCommentStop) and (Start^ <> #10)
            do Dec(Start);  { Ende vorangehende Zeile }
        if Start^ = #10 then Dec(Start);
        if Start^ = #13 then Dec(Start);
        while (Start >= LastCommentStop)
          and IsWhiteSpace(Start^) do Dec(Start);
        if Start <= LastCommentStop then
        begin { ist ein direkt vorlaufender Kommentar }
          CommentStart := LastCommentStart;
          CommentStop := LastCommentStop;
        end;
        LastCommentStop := nil;
      end;
    end;
  end;

begin
  ClearSymList; NewSym := nil; LastCommentStop := nil;
  mPCode.GetTextBuf(TextBuf,BUFSIZE); ScanPtr := TextBuf;

  { 1. Vom Anfang der Unit bis zum ersten Start-Symbol }
  repeat
    NameStr := NextName(ScanPtr,NameStart);
    if NameStr = '' then goto DoneOrEof;
  until NameStr = 'UNIT';
  { Name der Unit als Symbol }
  NameStr := NextName(ScanPtr,NameStart);
  EnterSym(NameStr, sDefined,NameStart);
  NewSym^.PStart := TextBuf;
  { 1a. Suche nach dem ersten VAR .. FUNCTION }
  FoundStart := False;
  while not FoundStart do
  begin
    NameStr := NextName(ScanPtr, NameStart);
    if NameStr = '' then goto DoneOrEof;
    for SymKind := sVar to sFunc do
      if NameStr = StartSymbols[SymKind] then
      begin
        FoundStart := True; Break;
      end;
  end;
  NewSym^.PEnd := NameStart-1; { = Topic-Ende fr die Unit (LF) }
  ScanPtr := NameStart;  { "Unget" des gefundenen Symbols }

  { 2. Die Deklarationen der Unit }
  repeat
    { Type, Const und Var knnen beliebig oft wiederholt
      werden, procedure und function dagegen nicht:  }
    FoundSymbol := False;
    repeat
      NameStr := NextName(ScanPtr, NameStart);
      if NameStr = '' then goto DoneOrEof;
      for xS := sVar to sFunc do
        if NameStr = StartSymbols[xS] then
        begin  { neuer Abschnitt/Typ: Art eintragen }
          SymKind := xS; FoundSymbol := True; Break;
        end;
      if not FoundSymbol then FoundSymbol := True { Bezeichner }
       else if (SymKind = sFunc) or (SymKind = sProc) then
       begin  { Bezeichner kommt nach PROCEDURE / FUNCTION }
         NameStr := NextName(ScanPtr,NameStart);
         FoundSymbol := True;
       end else { VAR..TYPE: SymKind gesetzt, nchste Runde }
         FoundSymbol := False;
    until FoundSymbol;

    { 2a: NameStr = Bezeichner, SymKind = Art }
    EnterSym(NameStr, SymKind, NameStart);
    case SymKind of
      sProc, sFunc:
        begin
          ScanPtr := FindProcFuncEnd(ScanPtr);
          NewSym^.PEnd := ScanPtr;
        end;
      sVar, sType, sConst:
        begin
          NewSym^.PEnd := ScanPtr;  { CLASS, Backtrack Vars }
          NameStr := NextName(ScanPtr,NameStart);
          if NameStr = 'RECORD' then
          begin  { Records en bloc mitnehmen }
            ScanPtr := FindRecEnd(ScanPtr);
            NewSym^.PEnd := ScanPtr;
            NewSym^.SymKind := sRecord; { nur wg. Ausgabe }
          end else if NameStr = 'CLASS' then
          begin
            CurrClassName := NewSym^.SymName;
            NewSym^.SymKind := sClass;  { nur wg. Ausgabe }
            { innerhalb von Klassendeklarationen gelten
              zustzliche bzw. andere Regeln. }
            if NextChar(ScanPtr,FoundStart) = ';' then
            with SymList do
            begin   { forward-Deklaration: type abc = class; }
              Dispose(PSymRec(Items[Count-1]));
              Delete(Count-1);
              continue;  { -> ueres repeat }
            end;
            NameStr := NextName(ScanPtr,NameStart); { Basis }
            NewSym^.PEnd := ScanPtr;  { hinter Basisklasse }
            NextChar(ScanPtr,FoundStart); { ')' } Inc(ScanPtr);
            if NextChar(ScanPtr,FoundStart) = ';' then
            begin  { type abc = class(xyz); }
              NewSym^.PEnd := ScanPtr;
              continue;
            end;
            NameStr := NextPublic(ScanPtr,NameStart,xS,False);
            repeat
              if NameStr = '' then goto DoneOrEof;
              if NameStr = 'END' then Break;  { repeat }
              EnterSym(NameStr, xS, NameStart);
              NewSym^.ClassName := CurrClassName;
              case xS of
                sProc..sDestructor:
                begin
                  ScanPtr := FindProcFuncEnd(ScanPtr);
                  NewSym^.PEnd := ScanPtr;
                end;
                sVar:
                  begin
                    NewSym^.PEnd := ScanPtr;
                    if NextName(ScanPtr,NameStart) = 'RECORD'
                    then begin
                      ScanPtr := FindRecEnd(ScanPtr);
                      NewSym^.PEnd := ScanPtr;
                      NewSym^.SymKind := sRecord;
                    end; { else ist's der Typ der Variablen }
                  end;
              end;
              NameStr := NextPublic(ScanPtr,NameStart,xS,True);
            until False;  { Break bei NameStr = 'END' }
          end else
          begin { NameStr <> 'CLASS' and NameStr <> 'RECORD' }
            ScanPtr := FindProcFuncEnd(NewSym^.PEnd);{Backtrack}
            NewSym^.PEnd := ScanPtr;
          end;
        end; { case sVar ... }
      end; { case SymKind of }
  until NameStr = '';  { Eof }
DoneOrEof:
  if NewSym = nil then raise Exception.Create('Null Symbole!');
  NewSym^.PEnd := ScanPtr;

  ProgState := psParsed;
  AnalysisToOutline; { Analyse-Ergebnis -> Outline }
  ParseEdited := False;
end;

procedure TForm1.AnalysisToOutline;
var x,y: Integer; Line: String;
    CurrEnd: PChar; P: PSymRec;
    LastGlobalIndex: Integer;

  procedure DataToParseBuf(P: PSymRec);
  begin
    with P^ do
    begin
      if CommentStop = nil then
      case SymKind of
        sDefined,sClass,sRecord,sEvent:
                    ; { nichts voranstellen }
          else
            StrPCopy(CurrEnd,
                LowerCase(StartSymbols[SymKind])+' ');
            Inc(CurrEnd,StrLen(CurrEnd));
      end; { else Typbezeichner (hoffentlich) im Kommentar }
      if CommentStop = nil
        then StrLCopy(CurrEnd,PStart,PEnd-PStart+1)  { Text }
        else { vorlaufender Kommentar + Text }
          StrLCopy(CurrEnd,CommentStart,PEnd-CommentStart+1);
    end;
    StrCat(CurrEnd,#13#10);
    Inc(CurrEnd,StrLen(CurrEnd));
  end;

begin
  Outline1.Clear; LastGlobalIndex := 0;
  for x := 1 to SymList.Count-1 do
    with PSymRec(SymList.Items[x])^ do
    begin
  { Prfung auf Events (nachtrglich eingebaut, lexikalisch) }
      if SymKind = sProperty then
      begin
        Line := UpperCase(Copy(StrPas(PStart),1,PEnd-PStart+1));
        if (Pos('ON',Line) = 1) or (Pos('EVENT',Line) <> 0)
          then SymKind := sEvent;
      end;
  { PEnd auf Zeilenende. Von einer Checkbox abhngig machen? }
      CurrEnd := PEnd;  { CurrEnd als Temp }
      if CurrEnd^ = #10 then Dec(CurrEnd);
      if CurrEnd^ = #13 then Dec(CurrEnd);
      for y := 1 to 80 do
        if (CurrEnd^ <> #0) and (CurrEnd^ <> #13)
           then Inc(CurrEnd);
      if CurrEnd^ = #13 then
      begin
        Dec(CurrEnd); PEnd := CurrEnd;
      { Zeile bis auf Ende erweitert. Glaubt das nchste
        Element, hier stnde "sein" Kommentar drin? }
        if x < SymList.Count-1 then
          with PSymRec(SymList.Items[x+1])^ do
            if (CommentStart <= CurrEnd)  { gilt auch fr nil }
               then CommentStop := nil;
      end;
    end;
  { bertrag der globalen und lokalen Symbole in die Outline }
  for x := 0 to SymList.Count-1 do
  begin
    CurrEnd := ParseBuf; CurrEnd^ := #0;
    P := SymList.Items[x];
    with P^ do
    begin
      if (SymKind <> sConstructor) and (SymKind <> sDestructor)
        then DataToParseBuf(P);
      if SymKind = sClass then
        for y := x+1 to SymList.Count-1 do
        begin
          with PSymRec(SymList.Items[y])^ do
            if ClassName = '' then Break { nchste Klasse }
            else if (SymKind = sConstructor) or
                    (SymKind = sDestructor) then
            begin { Kon- und Destruktor zum Klassentext dazu }
              StrCat(CurrEnd,'   ');  { Optik }
              Inc(CurrEnd,StrLen(CurrEnd));
              DataToParseBuf(SymList.Items[y]);
              Deleted := True; { und nicht mehr bercksichtigen}
            end;
        end;

       { Eigenstndigen Puffer fr die Bearbeitung
         ber die Outline belegen }
       GetMem(TextData,StrLen(ParseBuf)+1);
       StrCopy(TextData,ParseBuf);
    end;
    if not P^.Deleted then  { Kon- und Destruktor }
    with Outline1 do
      if P^.ClassName = '' then
      begin
        AddObject(LastGlobalIndex,P^.SymName,P);
        LastGlobalIndex := ItemCount;
      end
       else AddChildObject(LastGlobalIndex,P^.SymName,P);
  end;
  CurrSymIndex := -1;
  Outline1.Row := 0; { Erstes Element (Unit) auswhlen }
  Outline1Click(Self);
end;

{ --- Nachbearbeitung ber die Outline ----------- }
procedure TForm1.Outline1Click(Sender: TObject);
var AlreadyParseEdited: Boolean;
begin
  { Wechsel des Texts im Puffer }
  if (CurrSymIndex <> -1) and ParseEdited then
  with PSymRec(SymList.Items[CurrSymIndex])^ do
  begin  { Momentan bearbeiteten Text zurck }
    FreeMem(TextData,StrLen(TextData)+1);
    GetMem(TextData,mPCode.GetTextLen+1);
    mPCode.GetTextBuf(TextData,BUFSIZE);
  end;
  { Neu gewhltes Item der Outline enthlt als Data einen
    Zeiger auf den SymRec. Welcher Eintrag ist das in SymList?}
  with Outline1 do
   CurrSymIndex := SymList.IndexOf(Items[SelectedItem].Data);
  { Text aus diesem SymRec in den Editor, und "Text bearbeitet"
    (OnChange) abfangen }
  AlreadyParseEdited := ParseEdited;
  with PSymRec(SymList.Items[CurrSymIndex])^ do
    mPCode.SetTextBuf(TextData);
  if not AlreadyParseEdited then ParseEdited := False;
end;

procedure TForm1.Outline1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var x: LongInt; DelKey, UnDelKey: Boolean; Node: TOutlineNode;
  procedure SetKey(Node: TOutlineNode);
  begin
    with Node do
      if DelKey and (Text[1] <> '*') then
      begin
        Text := '*'+Text;
        PSymRec(Data)^.Deleted := True;
      end else if UnDelKey and (Text[1] = '*') then
      begin
        Text := Copy(Text,2,255);
        PSymRec(Data)^.Deleted := False;
      end;
  end;
begin
  if Outline1.SelectedItem = 1 then
  begin
    ShowMessage('Unit wird als Sammeleintrag gebraucht');
    Exit;
  end;
  DelKey := Key = VK_DELETE; UndelKey := Key = VK_SPACE;
  if not (DelKey or UndelKey) then Exit;

  with Outline1 do Node := Items[SelectedItem];
  SetKey(Node); Node.Expand;
  { Alle untergeordneten Items ebenfalls abklappern.
    Der Scanner kommt nur mit einer Ebene zurecht, deshalb
    bleibt's auch hier ohne Rekursion }
  with Node do
  begin
    x := GetFirstChild;
    while x <> -1 do
    begin
      SetKey(OutLine1[x]);
      x := GetNextChild(x);
    end;
  end;
end;

{ ---- Keys, berschriften und Speicherung als RTF ---------- }
const  { Typen und Topic-IDs }
 Prefixes: Array[TSymKind] of String[11] =
  ('Var','Type','Const','proc_', 'func_','prop_',
   'CONSTRUCTOR','DESTRUCTOR',
   'PRIVATE', 'PROTECTED','PUBLIC','PUBLISHED',
   'unit_','class_','Var','event_');  { <- nur wg. Ausgabe }
const
 WW2RTFHead: Array[0..3] of String =
 ('{\rtf1\ansi \deff0\deflang1031'#13#10+ { Version 1, Deutsch }
  { Font-Tabelle }
  '{\fonttbl{\f0\froman Times New Roman;}{\f1\froman Symbol;}'+
  '{\f2\fswiss Arial;}{\f3\fmodern Courier New;}}'#13#10,

  '{\stylesheet' +   { Druckformatvorlage }
  '{\s245 \fs20\sbasedon0\snext245 footnote text;}' +
  '{\s253\sb240\sa60\b\f2\sbasedon0\snext0 heading 2;}'+
  '{\s254\sb240\sa60\keepn \b\f2\fs28\sbasedon0\snext0 '+
                                     'heading 1;}'+ #13#10,
  '{\fs20\snext0 Normal;}' +
  '{\s2 \f3\fs20\sbasedon0\snext2 Listing;}' +
  '{\s3\tx567\tx1985\tx3402\tx4820 \fs20\sbasedon0\snext3 '+
                                     'Tab4;}}'+ #13#10,
  { Seiteneinrichtung }
  '\paperw11906\paperh16838\margl1417\margr1417\margt1417'+
  '\margb1134\gutter0\deftab709' + #13#10 +
  '\widowctrl\ftnbj\hyphhotz425\makebackup\sectd' +
  '\linex0\headery709\footery709\colsx709\endnhere'+#13#10
 );
type   { Absatzformatierung }
 TParaType =
   (pHead, pFoot, pNormal, pHead2, pListing, pTab4);

const
 WW2Pars: Array[TParaType] of String =
  { berschrift: WWPars[pHead]+'Text'#13#10 }
 ('\pard\plain \s254\sb240\sa60\keepn \b\f2\fs28 ',
  (* Funote: FootFmt+ '$'+WWPars[pFoot]+'$ Text'+'}}'#13#10  *)
  '{\footnote \pard\plain \s245 \fs20 ',
  '\par \pard\plain \fs20 ',  { Normal: pNormalText }
  { berschrift 2. Ordnung: WWPars[pHead2]+'Text'#13#10 }
  '\par \pard\plain \s253\sb240\sa60\b\f2 ',
  { Listing: WWPars[pListing]+'Text'#13#10 }
  '\par \pard\plain \s2 \f3\fs20 ',
  { 4spaltige Tabelle: WWPars[pTab4]+'Text'#13#10 }
  '\par \pard\plain \s3\tx567\tx1985\tx3402\tx4820 \fs20 '
 );

 WW2Tab = '\tab ';  WW2Page = #13#10'\page'#13#10;{ Seitenende }
 WW2Underline = '{\uldb ';  (* WW2Unterline+Text+'}' *)
 WW2Hidden = '}{\v ';       (* WW2Hidden+Text+'}'    *)
 WW2Par = #13#10'\par ';    { RTF-Zeilenvorschub }
 WW2FootFmt = '{\fs16\up6 ';  { 8 pt, hochgestellt }

 (* Spezialzeichen: '{' -> '\{', '}' -> '\}', '\' -> '\\' *)
 { Umlaute sollten eigentlich als \'xx codiert werden, ein
   direkter Eintrag geht aber auch (zumindest von PC nach PC) }

procedure TForm1.SaveAsRTF;
var
 x,y: Integer; Line, UnitName: String;
 TargetStream: TFileStream; P,P1: PChar;

  function GenTopicID(SymRec: PSymRec): String;
  begin { Topic-ID fr das Symbol }
    with SymRec^ do
    begin
      if SymKind = sClass then Result := 'class_'+SymName
       else if ClassName <> '' then
          Result := Prefixes[SymKind]+ClassName+SymName
       else
          Result := Prefixes[SymKind]+SymName;
    end;
  end;

  procedure RTFWrite(Text: String); { direktes Schreiben }
  begin
    if Length(Text) > 0 then
       TargetStream.Write(Text[1],Length(Text));
  end;

  { RTF: Neue Zeile. #13#10 ist hier *nur* ein Delimiter }
  procedure RTFPara;
  begin
    RTFWrite(WW2Par);  { #13#10'\par'#13#10 }
  end;

  procedure RTFFoot(FMark: Char; FText: String);
  begin      { lfd. Text       Funote }
    RTFWrite(WW2FootFmt+FMark+WW2Pars[pFoot]+WW2FootFmt+
             FMark+'} '+FText+'}} '#13#10);
  end;

  procedure TextWrite(Text: String); { laufender Text als RTF }
  var x: Integer; NText: String;
  begin
    NText := ''; x := 1;
    while x <= Length(Text) do
    begin
      case Text[x] of
       '{': NText := NText + '\{';
       '}': NText := NText + '\}';
       '\': NText := NText + '\\';
       #9 : NText := NText + WW2Tab;
       else
         NText := NText + Text[x];
      end;
      Inc(x);
    end;
    NText := NText + #13#10;
    TargetStream.Write(NText[1],Length(NText));
  end;

   { Querverweis-Tabellen fr Unit und Klassen }
   procedure CreateSpots(Head: String; Kind: TSymKind;
                         StartIndex: Integer; IsClass: Boolean);
   var FoundItem: Boolean; ColCount: Integer; TopicID: String;
   begin
     FoundItem := False;
     while StartIndex < SymList.Count do
     with PSymRec(SymList.Items[StartIndex])^ do
     begin
       TopicID := GenTopicID(SymList.Items[StartIndex]);
       Inc(StartIndex);
       if IsClass and (ClassName = '') then Break;
       if not IsClass and (ClassName <> '') then continue;
       if Deleted then continue; { Benutzer, Kon-, Destruktor }
       if (Kind = SymKind) or
         ((Kind = sProc) and (SymKind = sFunc)) or
         ((Kind = sVar) and (SymKind = sRecord)) then
       begin
         if not FoundItem then  { Zwischenberschrift }
         begin
           RTFPara; RTFWrite(WW2Pars[pHead2]);
           TextWrite(Head);
           FoundItem := True; ColCount := 3; { Umbruch erzw. }
         end;
         Inc(ColCount);
         if ColCount > 3 then
         begin
           RTFWrite(WW2Pars[pTab4]); ColCount := 0;
         end;
            (*\tab {\uldb SYMNAME}{\v TOPIC-ID} *)
         RTFWrite(WW2Tab+WW2Underline+SymName+
                  WW2Hidden+TopicID+'}'#13#10);
       end;
     end;
     if FoundItem then RTFPara;
   end;

begin
  UnitName := PSymRec(SymList.Items[0])^.SymName;
  TargetStream := TFileStream.Create(FName,fmCreate);
  { Gedns am Anfang einer RTF-Datei (Minimalstversion) }
  for x := 0 to 3 do RTFWrite(WW2RTFHead[x]);

  for x := 0 to SymList.Count-1 do
  begin
     with PSymRec(SymList.Items[x])^do  { berschrift }
     begin  { abc, sVar -> '#$Kabc (var)' }
       if Deleted or (StrLen(TextData) = 0) then continue;

       RTFWrite(WW2Pars[pHead]); { Absatzformat: Heading1 }
       { Topic-ID: # in der berschrift, dann sofort Funote }
       RTFFoot('#',GenTopicID(SymList[x]));
       { Titel ($): NAME (Typ) }
       RTFFoot('$',SymName+
         ' ('+ Lowercase(StartSymbols[SymKind])+')');
       { K-Key: (K): NAME }
       RTFFoot('K',SymName);
       Line := '';  { B-Key notwendig? }
       if SymKind = sClass then Line := 'class_'+SymName
        else if ClassName <> '' then
         Line := Prefixes[SymKind]+ClassName+SymName;
       if Line <> '' then RTFFoot('B',Line);

       { Die berschrift selbst (uff) }
       Line := LowerCase(StartSymbols[SymKind])+' ';
       Line[1] := Upcase(Line[1]);  { naja - Optik }
       if ClassName <> '' then Line := Line + ClassName+'.';
       RTFWrite(Line+SymName);

       if x <> 0 then
       begin  { Querverweis auf die Unit }
         RTFWrite(WW2Pars[pNormal]);  { Normaler Text }
         RTFWrite('Unit: '+WW2Underline+UnitName+
                    WW2Hidden+'unit_'+UnitName+'}'#13#10);
         RTFPara;
       end;
       { Der in der Outline sichtbare Textteil: Listingschrift }
       RTFWrite(WW2Pars[pListing]);
       P := TextData;
       while (P <> nil) and (P^ <> #0) do
       begin  { Aufteilung in Zeilen }
         P1 := StrScan(P,#13);
         if P1 <> nil then
         begin
           Line := Copy(StrPas(P),1,P1-P); Inc(P1,2);
         end
           else Line := StrPas(P);
         P := P1;
         TextWrite(Line);  { ASCII -> RTF }
         RTFPara;
       end;

       if x = 0 then
       begin  { Unit - globale bersicht }
         CreateSpots('Globale Variablen',sVar,1,False);
         CreateSpots('Globale Konstanten',sConst,1,False);
         CreateSpots('Datentypen und Klassen',sClass,1,False);
         CreateSpots('Prozeduren/Funktionen',sProc,1,False);
       end;

       if SymKind = sClass then
       begin  { Klassen - lokale bersicht }
         CreateSpots('Variablen',sVar,x+1,True);
         CreateSpots('Eigenschaften',sProperty,x+1,True);
         CreateSpots('Events',sEvent,x+1,True); { (Hack) }
         CreateSpots('Methoden',sProc,x+1,True);
       end;
     end; { with PSymRec(SymList.Items[x]) }
     RTFWrite(WW2Page);
  end;
  RTFWrite('}'#13#10);  { Abschlu }
  TargetStream.Destroy;
end;

end.

