/****  Datei: banknote.c              ****/ 
/****  Autor: Jrg Michael, Hannover  ****/ 

/****  Prfung der Seriennummern      ****/ 
/****  deutscher Banknoten            ****/ 
/****         c't 4/97                ****/ 

#include <stdio.h> 
#include <ctype.h> 
#include <string.h> 

/****  Multiplikationstabelle der Diedergruppe  ****/ 
int multipl [10][10] = { { 0,1,2,3,4, 5,6,7,8,9 }, 
			 { 1,2,3,4,0, 6,7,8,9,5 }, 
			 { 2,3,4,0,1, 7,8,9,5,6 }, 
			 { 3,4,0,1,2, 8,9,5,6,7 }, 
			 { 4,0,1,2,3, 9,5,6,7,8 }, 

			 { 5,9,8,7,6, 0,4,3,2,1 }, 
			 { 6,5,9,8,7, 1,0,4,3,2 }, 
			 { 7,6,5,9,8, 2,1,0,4,3 }, 
			 { 8,7,6,5,9, 3,2,1,0,4 }, 
			 { 9,8,7,6,5, 4,3,2,1,0 } 
		       }; 

/****  Permutationstabelle fr deutsche Banknoten  ****/ 
int perm_bn [11][10] = { { 1,5,7,6,2, 8,3,0,9,4 }, 
			 { 5,8,0,3,7, 9,6,1,4,2 }, 
			 { 8,9,1,6,0, 4,3,5,2,7 }, 
			 { 9,4,5,3,1, 2,6,8,7,0 }, 
			 { 4,2,8,6,5, 7,3,9,0,1 }, 
			 { 2,7,9,3,8, 0,6,4,1,5 }, 
			 { 7,0,4,6,9, 1,3,2,5,8 }, 
			 { 0,1,2,3,4, 5,6,7,8,9 }, 
			 { 1,5,7,6,2, 8,3,0,9,4 }, 
			 { 5,8,0,3,7, 9,6,1,4,2 }, 
			 { 0,1,2,3,4, 5,6,7,8,9 } 
		       }; 

/****  Positionen und Umwandlungstabelle fr Buchstaben  ****/ 
char  pos_buchstabe[] = "++       + "; 
char  umwandlung[] = "Aa0Dd1Gg2Kk3Ll4Nn5Ss6Uu7Yy8Zz9"; 

int check_seriennummer (char zahl[]) 
{ 
 int  k=0,n=0,d=0; 
 char *s; 
 while ((k = (int) zahl[n]) != 0) 
   { 
    if (isalpha (k)  &&  pos_buchstabe [n] != ' ' 
    && (s = strchr (umwandlung, k)) != NULL) 
      { 
       /****  Buchstabe in Zahl umwandeln  ****/ 
       while (isalpha (*s)) 
	 { 
	  s++; 
	 } 
       k = (int) *s; 
      } 

    if (! isdigit (k) 
    || (isdigit (zahl[n])  &&  pos_buchstabe [n] != ' ')) 
      { 
       return (-1); 
      } 

    k = perm_bn [n] [k-'0']; 
    d = multipl [d] [k]; 
    n++; 
   } 
 return (d); 
} 

void main (int argc, char *argv[]) 
{ 
 int i; 

 if (argc != 2) 
   { 
    printf ("Aufruf:  banknote  <seriennummer>\n"); 
    return; 
   } 
 if ((int) strlen (argv[1]) != 11) 
   { 
    printf ("Fehler: Seriennummer ist nicht 11stellig\n"); 
    return; 
   } 

 i = check_seriennummer (argv[1]); 
 switch (i) 
   { 
    case -1 :  printf ("Fehler: ungltiges Zeichen\n"); break; 
    case  0 :  printf ("Seriennummer ist okay\n");      break; 
    default :  printf ("Prfziffer ist fehlerhaft\n");   break; 
   } 
} 
