{
  TEST13 - Testprogramm fr den Modus 13h ( 320 x 200 x 256 )

  Demonstration der VESA-SVGA-Routinen mit Borland Pascal 7.0 Protected Mode
  Dieses Programm ist SOWOHL im Protected als auch im Real Mode lauffhig.

  Ansgar Scherp   ( Ansgar.Scherp@Informatik.Uni-Oldenburg.DE )
  Joachim Gelhaus ( J.Gelhaus@Flight.Gun.DE )

  http://www.informatik.uni-oldenburg.de/~virtech/

  aus 'Patchwork' c't 4/97 S. 442

}

uses Video13, Crt;

var
  MyPage,
  MyBackground : TPage; { zwei virtuelle Bildschirmseiten }
  MySprite,
  MySprite2        : TSprite;   { zwei Sprites }
  x, y             : integer;   { Hilfvariable }
  DeltaX, DeltaY   : integer;   { zur Sin-/Cos-Berechnung }
  RealX, RealY     : real;
  Ende             : boolean;

begin
  ClrScr;
  { Mode 100h initialisieren }
  InitVideo13h;
  { visuelle Seite lschen }
  ClearPage( VisualPage );
  { virtuellen Seiten einrichten }
  InitPage( MyBackground );
  InitPage( MyPage );
  { virtuellen Seiten lschen }
  ClearPage( MyBackground );
  ClearPage( MyPage );
  { Fensterrahmen festlegen; kompletten Modus ausnutzen }
  SetWindow( 0, 0, 639, 479 );
  { Mode  einschalten }
  SetVideoMode( Mode13h );
  { Sprite initialisieren }
  InitSprite( MySprite, 100, 100 );
  { einen kleinen Farbverlauf erzeugen }
  for x := 0 to 31 do
    SetRGBColor( x, 0, 0, 2 * x );
  for x := 0 to 31 do
    SetRGBColor( x + 32, x, 0, 62 );
  { Sprite mit Pixeln fllen }
  for x := 0 to 99 do
    for y := 0 to 99 do
      PutPixel2Sprite( MySprite, x, y, Trunc ( sqrt ( x * y ) ) mod 256 );
  { nur, um zu sehen ob es luft }
  CopyP2P( MyPage, MyPage );
  { aktuelle I/O-Seite festlegen }
  ActivePage( MyPage );
  { Sprite an der Position 0,0 zeichnen }
  PutSprite( 0,0, MySprite );
  { testen von Put- und GetPixel; legt drei Kopien des Bildbereiches
    von 0,0 bis 99,99 an }
  RealX := 0; RealY := 0;
  for x := 0 to 99 do
    for y := 0 to 99 do
      begin
        PutPixel( x + 100, y      , GetPixel( 99 - x, y      ) );
        PutPixel( x      , y + 100, GetPixel( x     , 99 - y ) );
        PutPixel( x + 100, y + 100, GetPixel( 99 - x, 99 - y ) );
      end;
  { initialisiert ein zweites Sprite der Gre von 200 x 200 Pixeln }
  InitSprite( MySprite2, 200, 200 );
  { sichern des Bildinhaltes der gerade aktiven virtuellen Bildschirmseite
    in MySprite2 }
  GetSprite( 0,0, MySprite2 );
  { aktive virtuelle Bildschirmseite festlegen }
  ActivePage( MyBackground );
  { Hintergrundmuster erzeugen }
  for x := 0 to 3 do
    for y := 0 to 2 do
      PutSprite( x * 200, y * 200, MySprite2 );

  ActivePage( MyPage );
  Ende := false;
  repeat
    { Hinterrund nur zeichnen, wenn Ende = false }
    if not Ende then
      CopyP2P( MyBackground, MyPage );
    { Delta-Werte fr den Fensterrahmen berechnen }
    DeltaX := Round( Sin( RealX ) * 50 );
    DeltaY := Round( Cos( RealY ) * 50 );
    RealX := RealX + PI/128;
    RealY := RealY + PI/64;
    { Fensterrahmen stndig aendern }
    SetWindow( DeltaX, 300 + DeltaY, 320 - DeltaX, 50 - DeltaY );
    { Fensterrahmen mit Inhalt fllen }
    for x := -1 to 1 do
      for y := -1 to 1 do
        PutSprite( x * 200 + DeltaX, y * 200 + DeltaY, MySprite2 );
    { auf den vertikalen Strahlrcklauf des Monitors warten }
    WaitVerticalRetrace;
    { die aktive virtuelle Bildschirmseite in die visuelle Bildschirmseite
      kopieren }
    CopyP2P( MyPage, VisualPage );
    { wenn Taste gedrckt... }
    if ( Keypressed = true ) and ( Ende = false ) then
      begin
        ReadKey;        { ... dann Bildschirm lschen und zweiten Teil }
        Ende := true;   {     der Demonstration ausfhren }
        ClearPage( MyPage );
      end;
  until Keypressed and Ende;
  ReadKey;
  { allozierter Speicher fr die Sprites wieder freigeben }
  CloseSprite( MySprite );
  CloseSprite( MySprite2 );
  { virtuellen Bildschirmseiten schliessen }
  ClosePage( MyPage );
  ClosePage( MyBackground );
  { Textmodus 3h einschalten }
  SetVideoMode( Mode3h );
  WriteLn( 'Ende.' );
end.