function fw_error( ) {
  echo "error: $1" >/dev/stderr
  exit 1 }


function fw_spoofprotect() {
  $remark "spoofprotect $*"
  test $# -ne 2 && fw_error "spoofprotect: wrong parameter count"
  iplist=$1
  iflist=$2

  for ip in $iplist ; do
    for iface in $iflist ; do
      $rule -Ia deny -o -S $ip -D 0/0 -W $iface -b
    done
  done
}


function fw_parser() {
  $remark $*
  policy=$1
  service=$3
  case "$2-$4-$6" in

    # ============================================================
    # [allow|reject|deny] outgoing {service} to {IP}
    # ============================================================
    out*-to-)
      test $# -ne 5 && fw_error "outgoing: wrong parameter count"
      fw_makerule "$policy" out "$service" 0/0 "$5"
    ;;

    # ============================================================
    # [allow|reject|deny] incoming {service} from {IP}
    # ============================================================
    inc*-from-)
      test $# -ne 5 && fw_error "incoming: wrong parameter count"
      fw_makerule "$policy" in "$service" "$5" 0/0
    ;;

    # ============================================================
    # [allow|reject|deny] in_and_out {service} with {IP}
    # ============================================================
    in_and_out-with-)
      test $# -ne 5 && fw_error "in_and_out: wrong parameter count"
      fw_makerule "$policy" out "$service" 0/0 "$5"
      fw_makerule "$policy" in "$service" "$5" 0/0
    ;;

    # ============================================================
    # [allow|reject|deny] forwarding {service} from {IP} to {IP}
    # ============================================================
    forw*-from-to)
      test $# -ne 7 && fw_error "forwarding: wrong parameter count"
      fw_makerule "$policy" fwd "$service" "$5" "$7"
	;;

    # ============================================================
    # [allow|reject|deny] forwarding {service} between {IP} and {IP}
    # ============================================================
    forw*-between-and)
      test $# -ne 7 && fw_error "forwarding: wrong parameter count"
      fw_makerule "$policy" fwd_bi "$service" "$5" "$7"
	;;

    *)
      fw_error "syntax error ($2..$4..$6)"
    ;;
  esac
}
  

function fw_makerule() {
  policy=$1
  cmd=$2
  service=$3
  iplist1=$4
  iplist2=$5
  test -z "$policy" -o -z "$cmd" -o -z "$service" -o -z "$iplist1" \
    -o -z "$iplist2" -o $# -ne 5 && fw_error "internal error (makerule $*)" 

  # Masquerading: Policy auf "accept" und masq auf "-m" setzen
  if [ "$policy" = "masquerade" ] ; then
    test "$cmd" = "in" -o "$cmd" = "out" && \
      fw_error "masqerading only allowed in forwarding rules"
    policy="accept"
    masq="-m"
  else
    masq=""
  fi

  # Forwarding: Je nach Modus (Uni/Bidirektional) "bi" auf "-b" oder "" setzen
  if [ "$cmd" = "fwd_bi" ] ; then
    bi="-b"
    cmd="fwd"
  else
    bi=""
  fi

  # Sonderbehandlung fuer Spezial-Dienste
  case "$service" in
    tcp_all|udp_all)
      p="0:65535"
    ;;
    tcp_unpriv|udp_unpriv)
      p="1024:65535"
    ;;
    tcp_priv|udp_priv)
      p="0:1023"
    ;;
    tcp_all|udp_all)
      p="0:65535"
    ;;
    squid)
      p="3128"
    ;;
    *)
      p=$service
    ;;
  esac
    

  # Adressliste $iplist1 enthaelt zulaessige Clients (Quellen) fuer den Dienst
  for ip1 in $iplist1 ; do

    # Adressliste $iplist2 enthaelt zulaessige Server (Ziele) fuer den Dienst
    for ip2 in $iplist2 ; do

      # Die eigentlichen Firewall-Regeln sind in folgender case-Anweisung
      # nach dem Schema "service-" plus "in" (eingehend), "out" (ausgehend),
      # "fwd" (forwarding) oder "fwd_bi" (Bidirektionales Forwarding)
      # kodiert.
      case "$service-$cmd" in

        # ===================================================
        # TCP-basierte Protokolle mit nur einer Verbindung
        # ===================================================
        smtp-in|nntp-in|www-in|www-in|telnet-in|squid-in|\
        tcp_unpriv-in|tcp_priv-in|tcp_all-in)
          $rule -Ia $policy -S $ip1            -D $ip2 $p         -P tcp
          $rule -Oa $policy -S $ip2 $p         -D $ip1         -k -P tcp
        ;;

        smtp-out|nntp-out|www-out|www-out|telnet-out|squid-out|\
        tcp_unpriv-out|tcp_priv-out|tcp_all-out)
          $rule -Oa $policy -S $ip1 $unpriv    -D $ip2 $p         -P tcp
          $rule -Ia $policy -S $ip2 $p         -D $ip1 $unpriv -k -P tcp
        ;;

        smtp-fwd|nntp-fwd|www-fwd|www-fwd|telnet-fwd|squid-fwd|\
        tcp_unpriv-fwd|tcp_priv-fwd|tcp_all-fwd)
          # Dienstaufbau auf dem Hinweg
          $rule -Ia $policy       -S $ip1      -D $ip2 $p         -P tcp $bi
          $rule -Fa $policy $masq -S $ip1      -D $ip2 $p         -P tcp $bi
          $rule -Oa $policy       -S $ip1      -D $ip2 $p         -P tcp $bi
          # Antwortpakete (nur wenn Client != Server und nicht bidirektional)
          if [ -z "$bi" -a $ip1 != $ip2 ] ; then
            $rule -Ia $policy       -S $ip2 $p -D $ip1         -k -P tcp $bi
            $rule -Fa $policy $masq -S $ip2 $p -D $ip1         -k -P tcp $bi
            $rule -Oa $policy       -S $ip2 $p -D $ip1         -k -P tcp $bi
          fi
        ;;


        # ===================================================
        # Protokolle mit TCP und UDP und nur einer Verbindung
        # ===================================================
        domain-in)
          $rule -Ia $policy -S $ip1         -D $ip2 $p         -P tcp
          $rule -Oa $policy -S $ip2 $p      -D $ip1         -k -P tcp
          $rule -Ia $policy -S $ip1         -D $ip2 $p         -P udp
          $rule -Oa $policy -S $ip2 $p      -D $ip1         -k -P udp
        ;;

        domain-out)
          $rule -Oa $policy -S $ip1 $unpriv -D $ip2 $p         -P tcp
          $rule -Ia $policy -S $ip2 $p      -D $ip1 $unpriv -k -P tcp
          $rule -Oa $policy -S $ip1 $unpriv -D $ip2 $p         -P udp
          $rule -Ia $policy -S $ip2 $p      -D $ip1 $unpriv -k -P udp
        ;;

        domain-fwd)
          # Dienstaufbau auf dem Hinweg
          $rule -Ia $policy       -S $ip1       -D $ip2 $p        -P tcp $bi
          $rule -Fa $policy $masq -S $ip1       -D $ip2 $p        -P tcp $bi
          $rule -Oa $policy       -S $ip1       -D $ip2 $p        -P tcp $bi
          # Antwortpakete (nur wenn Client != Server und nicht bidirektional)
          if [ -z "$bi" -a $ip1 != $ip2 ] ; then
            $rule -Ia $policy       -S $ip2 $p  -D $ip1        -k -P tcp $bi
            $rule -Fa $policy $masq -S $ip2 $p  -D $ip1        -k -P tcp $bi
            $rule -Oa $policy       -S $ip2 $p  -D $ip1        -k -P tcp $bi
          fi
        ;;

        # ===================================================
        # reine UDP-Datagrammdienste
        # ===================================================
        ntp-in|udp_unpriv-in|udp_priv-in|udp_all-in)
          $rule -Ia $policy -S $ip1         -D $ip2 $p         -P udp
        ;;

        ntp-out|udp_unpriv-out|udp_priv-out|udp_all-out)
          $rule -Oa $policy -S $ip1         -D $ip2 $p         -P udp
        ;;

        ntp-fwd|udp_unpriv-fwd|udp_priv-fwd|udp_all-fwd)
          # Hinweg
          $rule -Ia $policy       -S $ip1       -D $ip2 $p        -P udp $bi
          $rule -Fa $policy $masq -S $ip1       -D $ip2 $p        -P udp $bi
          $rule -Oa $policy       -S $ip1       -D $ip2 $p        -P udp $bi
          # Antwortpakete (nur wenn Client != Server und nicht bidirektional)
          if [ -z "$bi" -a $ip1 != $ip2 ] ; then
            $rule -Ia $policy       -S $ip2 $p  -D $ip1        -k -P udp $bi
            $rule -Fa $policy $masq -S $ip2 $p  -D $ip1        -k -P udp $bi
            $rule -Oa $policy       -S $ip2 $p  -D $ip1        -k -P udp $bi
          fi
        ;;


        # ===================================================
        # Spezialfall "squid Inter-Cache Protocol":
        #  UDP-Port 3130 (Bidirektional) und TCP-Port 3128
        # ===================================================
        squid_icp-in)
          $rule -Ia $policy -S $ip1         -D $ip2 3128       -P tcp
          $rule -Oa $policy -S $ip2 3128    -D $ip1         -k -P tcp
          $rule -Ia $policy -S $ip1         -D $ip2 3130       -P udp
          $rule -Oa $policy -S $ip2 3130    -D $ip1            -P udp
          echo "# REMARK: squid udp port 3130 is also open for output"
        ;;

        squid_icp-out)
          $rule -Oa $policy -S $ip1         -D $ip2 3128       -P tcp
          $rule -Ia $policy -S $ip2 3128    -D $ip1         -k -P tcp
          $rule -Oa $policy -S $ip1         -D $ip2 3130       -P udp
          $rule -Ia $policy -S $ip2 3130    -D $ip1            -P udp
          echo "# REMARK: squid udp port 3130 is also open for input"
        ;;

        squid_icp-fwd)
          # Dienstaufbau auf dem Hinweg
          $rule -Ia $policy -S $ip1         -D $ip2 3128       -P tcp $bi
          $rule -Fa $policy -S $ip1         -D $ip2 3128       -P tcp $bi
          $rule -Oa $policy -S $ip1         -D $ip2 3128       -P tcp $bi
          $rule -Ia $policy -S $ip1         -D $ip2 3130       -P udp
          $rule -Fa $policy -S $ip1         -D $ip2 3130       -P udp
          $rule -Oa $policy -S $ip1         -D $ip2 3130       -P udp
          # Antwortpakete (nur wenn Client != Server und nicht bidirektional)
          if [ -z "$bi" -a $ip1 != $ip2 ] ; then
            $rule -Ia $policy -S $ip2 3128  -D $ip1         -k -P tcp
            $rule -Fa $policy -S $ip2 3128  -D $ip1         -k -P tcp
            $rule -Oa $policy -S $ip2 3128  -D $ip1         -k -P tcp
          fi
          $rule -Ia $policy -S $ip2 3130    -D $ip1            -P udp
          $rule -Fa $policy -S $ip2 3130    -D $ip1            -P udp
          $rule -Oa $policy -S $ip2 3130    -D $ip1            -P udp
        ;;


        # ===================================================
        # Spezialfall FTP: TCP-Protokoll mit zweitem Kanal
        # ===================================================
        ftp-in)
          $rule -Ia $policy -S $ip1            -D $ip2 $p         -P tcp
          $rule -Oa $policy -S $ip2 $p         -D $ip1         -k -P tcp
          $rule -Ia $policy -S $ip2 20         -D $ip1 $unpriv    -P tcp
          $rule -Oa $policy -S $ip1 $unpriv    -D $ip2 20         -P tcp
        ;;

        ftp-out)
          $rule -Oa $policy -S $ip1 $unpriv    -D $ip2 $p         -P tcp
          $rule -Ia $policy -S $ip2 $p         -D $ip1 $unpriv -k -P tcp
          # Datenkanal "normalerweise" auf Port 20
          $rule -Ia $policy -S $ip2 20         -D $ip1 $unpriv    -P tcp
          $rule -Oa $policy -S $ip1 $unpriv    -D $ip2 20         -P tcp

        ;;

        ftp-fwd)
          # Dienstaufbau auf dem Hinweg
          $rule -Ia $policy       -S $ip1      -D $ip2 $p         -P tcp $bi
          $rule -Fa $policy $masq -S $ip1      -D $ip2 $p         -P tcp $bi
          $rule -Oa $policy       -S $ip1      -D $ip2 $p         -P tcp $bi
          # Antwortpakete (nur wenn Client != Server und nicht bidirektional)
          if [ -z "$bi" -a $ip1 != $ip2 ] ; then
            $rule -Ia $policy       -S $ip2 $p -D $ip1         -k -P tcp $bi
            $rule -Fa $policy $masq -S $ip2 $p -D $ip1         -k -P tcp $bi
            $rule -Oa $policy       -S $ip2 $p -D $ip1         -k -P tcp $bi
          fi
        ;;


        # ===================================================
        # Spezialfall ping: ICMP-Protokoll
        # Echo-Request hat Typnr.8, Echo-Reply Typ Nr. 0
        # Der ICMP-Typ wird in der ipfwadm-Syntax als "Quell-
        # Portnummer" angegeben.
        # ===================================================
        ping-in)
          $rule -Ia $policy -S $ip1 8          -D $ip2            -P icmp
          $rule -Oa $policy -S $ip2 0          -D $ip1            -P icmp -b
        ;;

        ping-out)
          $rule -Oa $policy -S $ip1 8          -D $ip2            -P icmp
          $rule -Ia $policy -S $ip2 0          -D $ip1            -P icmp
        ;;

        ping-fwd)
          $rule -Ia $policy -S $ip1 8          -D $ip2            -P icmp
          $rule -Fa $policy -S $ip1 8          -D $ip2            -P icmp
          $rule -Oa $policy -S $ip1 8          -D $ip2            -P icmp
          $rule -Ia $policy -S $ip2 0          -D $ip1            -P icmp
          $rule -Fa $policy -S $ip2 0          -D $ip1            -P icmp
          $rule -Oa $policy -S $ip2 0          -D $ip1            -P icmp 
        ;;


        # ===================================================
        # ICMP-Protokoll (alle Dienste)
        # ===================================================
        icmp_all-in)
          $rule -Ia $policy -S $ip1            -D $ip2            -P icmp
        ;;

        icmp_all-out)
          $rule -Oa $policy -S $ip1            -D $ip2            -P icmp
        ;;

        icmp_all-fwd)
          $rule -Ia $policy       -S $ip1      -D $ip2            -P icmp -b
          $rule -Fa $policy $masq -S $ip1      -D $ip2            -P icmp -b
          $rule -Oa $policy       -S $ip1      -D $ip2            -P icmp -b
        ;;


        # ===================================================
        # Alle Protokolle
        # ===================================================
        all-in)
          $rule -Ia $policy -S $ip1            -D $ip2
        ;;

        all-out)
          $rule -Oa $policy -S $ip1            -D $ip2
        ;;

        all-fwd)
          $rule -Ia $policy       -S $ip1      -D $ip2
          $rule -Fa $policy $masq -S $ip1      -D $ip2
          $rule -Oa $policy       -S $ip1      -D $ip2
        ;;


        *)
          fw_error "protocol not supported ($service)"
        ;;

      esac
    done
  done
}

#########################################
#             Initialisierung
#########################################

# Pfade fuer ipfwadm und echo definieren
rule="/bin/echo /sbin/ipfwadm"
remark="/bin/echo -e \n#"

localhost="127/8"
special1="10/8"
special2="172.16/12"
special3="192.168/16"
specials="$special1 $special2 $special3"
all="0/0"

# Kurzformen fuer den Aufruf von fw_parser definieren
accept="fw_parser accept"
allow="fw_parser allow"
deny="fw_parser deny"
reject="fw_parser reject"
masquerade="fw_parser masquerade"
spoofprotect="fw_spoofprotect"

# Grundinitialisierung der Firewall:
# - Alle Regeln loeschen
# - Wenn keine Regel passt, Paket ignorieren (deny)
$remark "setup"
$rule -If
$rule -Ip deny
$rule -Of
$rule -Op deny
$rule -Ff
$rule -Fp deny

