import java.awt.*;
import java.awt.event.*;

public class PrintingTest extends Frame implements ActionListener, WindowListener
{
    PrintCanvas canvas;

    public PrintingTest()
    {
        super("Printing Test");
        addWindowListener (this);
        canvas = new PrintCanvas();
        add("Center", canvas);
        Button b = new Button("Print");
        b.setActionCommand("print");
        b.addActionListener(this);
        add("South", b);
        pack();
    }

    public void actionPerformed(ActionEvent e)
    {
        String cmd = e.getActionCommand();
        if (cmd.equals("print")) {
            PrintJob pjob = getToolkit().getPrintJob(this,
                               "Printing Test", null);
            if (pjob != null) {
                Graphics pg = pjob.getGraphics();
                if (pg != null) {
                    canvas.print(pg);
                    pg.dispose(); // flush page
                }
                pjob.end();
            }
        }
    }

    // Applikation schliessen
    public void windowClosing (WindowEvent e)
    {
        System.exit (0);
    }

    // Rest der Window-Events nicht beachten
    public void windowOpened (WindowEvent e) {}
    public void windowIconified (WindowEvent e) {}
    public void windowDeiconified (WindowEvent e) {}
    public void windowClosed (WindowEvent e) {}
    public void windowActivated (WindowEvent e) {}
    public void windowDeactivated (WindowEvent e) {}

    public static void main(String args[]) {
        PrintingTest test = new PrintingTest();
        test.show();
    }
}

class PrintCanvas extends Canvas {

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public void paint(Graphics g) {
        g.setFont (new Font ("SansSerif", Font.BOLD, 16));
        g.drawString ("Hallo Welt: jetzt kann Java drucken", 10, 100);
    }
}


