unit Diagsclu; { 10-MAR-96 as (Arne Schpers) }
{ ScrollDC mit Repaint. Als Datenquelle dient die
  Y-Koordinate des Mauszeigers, die Speicherung geschieht
  in einem Ringpuffer }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, ExtCtrls, StdCtrls, mmSystem;

type
  TIntArray = Array[0..999] of Integer;
  PIntArray = ^TIntArray;

  TDiagSclForm = class(TForm)
    Label1: TLabel;
    Timer1: TTimer;  { Abfrage der Mausposition alle 55 msec }
    PaintBox1: TPaintBox;
    cIdleLoop: TCheckBox; { Checked: Abfrage alle 20 msec }
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
  private
    BufElemCount: Integer;  { Gesamtzahl Elemente }
    ElemsSet,   { bereits gesetzte Elemente }
    DisplayStart: Integer; { Wert fr linken Fensterrand }
    DataBuf: PIntArray;
    function ScaleMouseY(MouseY: Integer): Integer;
    procedure OnIdle(Sender: TObject; var Done: Boolean);
    procedure NextSample(DataValue: Integer);
  end;

var
  DiagSclForm: TDiagSclForm;

implementation

{$R *.DFM}

procedure TDiagSclForm.FormCreate(Sender: TObject);
begin
 Timer1.Interval := 50; PaintBox1.Color := clWhite;
 BufElemCount := PaintBox1.Width;  { Maximalzahl }
 ElemsSet := 0; DisplayStart := 0;
 GetMem(DataBuf,BufElemCount*SizeOf(Integer));
 Application.OnIdle := OnIdle;
end;

procedure TDiagSclForm.FormDestroy(Sender: TObject);
begin
  FreeMem(DataBuf,BufElemCount*SizeOf(Integer));
end;

{ Umskalieren von Bildschirm- auf Fensterhhe }
function TDiagSclForm.ScaleMouseY(MouseY: Integer): Integer;
begin
  Result := MulDiv(MouseY,PaintBox1.Height,Screen.Height);
end;

procedure TDiagSclForm.NextSample(DataValue: Integer);
var Scroll, UpdRect: TRect; x: Integer;

 { "Line(XPos-1,DataBuf^[ToIndex-1],XPos,DataBuf^[ToIndex]" }
 procedure PaintLineTo(XPos,ToIndex: Integer);
 var FromIndex: Integer;
 begin
   ToIndex := ToIndex mod BufElemCount;
   if ToIndex = 0 then FromIndex := BufElemCount-1
    else FromIndex := ToIndex-1;
   with PaintBox1.Canvas do
   begin
     MoveTo(XPos-1,ScaleMouseY(DataBuf^[FromIndex]));
     LineTo(XPos,ScaleMouseY(DataBuf^[ToIndex]));
   end;
 end;

begin
  if ElemsSet = BufElemCount then
  begin  { Puffer und Fenster voll: nach links verschieben }
    DataBuf^[DisplayStart] := DataValue;
    Inc(DisplayStart);
    if DisplayStart = BufElemCount then DisplayStart := 0;

    Scroll := Rect(0,0,PaintBox1.Width,PaintBox1.Height);
    { Inhalt der Paintbox um 1 Pixel nach links verschieben;
      Clipping mit denselben Grenzen wie die Verschiebung }
    ScrollDC(PaintBox1.Canvas.Handle,-1,0,Scroll,Scroll,0,@UpdRect);
    with UpdRect do
    begin
      if (Right-Left > 1) then { sitzt ein anderes Fenster }
      begin { schrg davor -> rechte Seite extra }
        PaintBox1.Canvas.FillRect(Rect(Right-1,Top,Right,Bottom));
        PaintLineTo(Right-1,DisplayStart+Right-1);
        Right := Left+1;  { fr das folgende FillRect }
      end;
      { Standard: Neuzeichnen eines Wertes an der linken Kante }
      PaintBox1.Canvas.FillRect(UpdRect); { Hintergrund }
      PaintLineTo(Left,DisplayStart+Left);
    end;
  end else
  begin { noch kein Scrolling: XPos entspricht Datenindex }
    DataBuf^[ElemsSet] := DataValue;
    PaintLineTo(ElemsSet,ElemsSet);
    Inc(ElemsSet);
  end;
end;

procedure TDiagSclForm.FormPaint(Sender: TObject);
begin
  with Canvas do
  begin   { Rahmen fr die Paintbox }
    Brush.Style := bsClear;
    with PaintBox1 do
      Rectangle(Left-2,Top-2,Left+Width+2,Top+Height+2);
  end;
end;

{ Neuzeichnen der Elemente im ungltigen Rechteck }
procedure TDiagSclForm.PaintBox1Paint(Sender: TObject);
var x,LastX: Integer; ClipBox: TRect;
begin
  with PaintBox1 do
  begin
    GetClipBox(Canvas.Handle,ClipBox);
    Canvas.FillRect(ClipBox);  { Hintergrund }
    if ElemsSet < ClipBox.Left then Exit;
    Canvas.MoveTo(ClipBox.Left,  { Startpunkt }
       ScaleMouseY(DataBuf^[(DisplayStart+ClipBox.Left)
          mod BufElemCount]));
    LastX := ClipBox.Right;
    { Begrenzung auf ElemsSet, falls notwendig }
    if ElemsSet < LastX then LastX := ElemsSet;
    { Punkte innerhalb der ClipBox neu zeichnen }
    for x := ClipBox.Left to LastX-1 do
      Canvas.LineTo(x, ScaleMouseY(DataBuf^[(DisplayStart+x)
         mod BufElemCount]));
  end;
end;

{ Samples ber einen normalen Timer gesteuert (18 Samples/sec) }
procedure TDiagSclForm.Timer1Timer(Sender: TObject);
var MousePoint: TPoint;
begin
  GetCursorPos(MousePoint); NextSample(MousePoint.Y);
end;

{ Alternative "Datenquelle" mit 50 Samples pro Sekunde }
procedure TDiagSclForm.OnIdle(Sender: TObject; var Done: Boolean);
const NextSampleTime: LongInt = 0;  { Zeitpunkt nchstes Sample }
var MousePoint: TPoint;
begin
  Done := not cIdleLoop.Checked;
  if not Done and (timeGetTime > NextSampleTime) then
  begin
    NextSampleTime := timeGetTime+20;
    GetCursorPos(MousePoint); NextSample(MousePoint.Y);
  end;
end;

end.
