unit BigBrotherU; { 10-MAI-97 as (Arne Schpers) }
{ CreateProcess: Ein separater Thread signalisiert dem Haupt-
  Thread Start und Ende eines anderen Programms }
interface

{$IFNDEF WIN32}
{$ERROR 'Geht nicht fr 16 Bit!'}
{$ENDIF}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls;

type
  { Fr den Start von MiniProg32 - 100%ige Minimalistik }
  TWatcherThread = class(TThread)
  public
    ProcessID: THandle;
    OnProcessEnd: TNotifyEvent;  { RR Prozeende }
    procedure Execute; override;
  end;

  TForm1 = class(TForm)
    bStartMiniProg: TButton;
    bFindMiniProg: TButton;
    procedure bStartMiniProgClick(Sender: TObject);
    procedure bFindMiniProgClick(Sender: TObject);
  private
    FProcessActive: Boolean;
    StartupInfo: TStartUpInfo;   { fr CreateProcess }
    ProcessInfo: TProcessInformation;  { dito }
    WatcherThread: TWatcherThread;
    procedure ProcessEnd(Sender: TObject);
    procedure SetButtons;
  end;

var Form1: TForm1;

implementation

{$R *.DFM}

{ Warten auf das Ende des Prozesses }
procedure TWatcherThread.Execute;
begin
  WaitForSingleObject(ProcessID, INFINITE);
  if Assigned(OnProcessEnd) then OnProcessEnd(Self);
  Terminate;
end;

{ Start von Miniprog32. MiniProg32 mu im selben Verzeichnis wie
  BigBrother stehen und mit 32 Bit compiliert worden sein. }
procedure TForm1.bStartMiniProgClick(Sender: TObject);
begin
  FillChar(StartUpInfo,SizeOf(StartupInfo),0);
  with StartupInfo do
  begin  { praktisch ausschlielich Standardvorgaben }
    cb := SizeOf(StartupInfo);
    dwFlags := STARTF_USESHOWWINDOW or STARTF_FORCEONFEEDBACK;
    wShowWindow := SW_SHOWNORMAL;
  end;
  { Name, Kommandozeile, 2*Sicherheitsattribute }
  if CreateProcess(PChar(ExtractFilePath(ParamStr(0))
       +'MiniProg32.exe'),'',nil, nil,
  { Handle-Vererbung, CreationFlags (hier: nur Priorittsstufe) }
    False, NORMAL_PRIORITY_CLASS,
  { Environment, Startverzeichnis, StartupInfo, Prozessinfo }
    nil, nil, StartUpInfo, ProcessInfo) then
  begin { Warten, bis das Fenster erscheint }
    if WaitForInputIdle(ProcessInfo.hProcess,1000) <> 0 then
    begin
      ShowMessage('Da ist irgendetwas schiefgegangen!');
      Exit;
    end;
  end;
  { Fenster suchen und Prozess-ID ermitteln. Mte beim
    Direktstart natrlich nicht sein: ProcessInfo.hProcess
    hier bereits korrekt gesetzt }
  bFindMiniProgClick(Self);
end;

{ Buttons beim Ende von MiniProg32 wieder an }
procedure TForm1.ProcessEnd(Sender: TObject);
begin
  FProcessActive := False;
  SetButtons;
end;

procedure TForm1.SetButtons;
begin
  bStartMiniProg.Enabled := not FProcessActive;
  bFindMiniProg.Enabled := not FProcessActive;
end;
{$IFDEF VER90}
const  { Diese Definition fehlt in der Version 2.0 }
   PROCESS_ALL_ACCESS  = (STANDARD_RIGHTS_REQUIRED
                          or SYNCHRONIZE or $FFF);
{$ENDIF}
procedure TForm1.bFindMiniProgClick(Sender: TObject);
var TargetWnd: HWnd; ProcessID: LongInt; HProcess: THandle;
begin
  TargetWnd := FindWindow(nil,'MiniProgForm');
  FProcessActive := TargetWnd <> 0;
  if FProcessActive then
  begin
    { liefert erst mal die globale ID - nicht den Handle(!) }
    GetWindowThreadProcessID(TargetWnd,@ProcessID);
    { Ermittelt den Handle aus der ID }
    HProcess := OpenProcess(PROCESS_ALL_ACCESS,False,ProcessID);
    WatcherThread := TWatcherThread.Create(True);
    with WatcherThread do
    begin
      ProcessID := HProcess;
      OnProcessEnd := ProcessEnd; { Rckmeldung }
      FreeOnTerminate := True;
      Suspended := False;     { ... und ab }
    end;
  end;
  SetButtons;
end;
end.
