Option Explicit

Const DBPath = "C:\Adressen.mdb"
Const DBTable = "Adressen"
Dim DE As DBEngine
Dim DB As Database
Dim WS As Workspace
Dim RS As Recordset

Private Sub DBOpen()
    Set DE = CreateObject("DAO.DBEngine.35")
    Set WS = DE.Workspaces(0)
    Set DB = WS.OpenDatabase(DBPath)
End Sub

Private Sub DBClose()
    DB.Close
End Sub

Private Sub DBLookup()
    Dim Where As String
    DBOpen
    Where = " WHERE Name LIKE """ & Search.Value & "*"""
    Set RS = DB.OpenRecordset("SELECT * FROM " & DBTable & Where)
    
    Dim I As Integer
    I = 0
    Records.Enabled = False
    Records.Clear
    
    While Not RS.EOF
        Records.Enabled = True
        Records.AddItem
        Records.Column(0, I) = RS("AdressId")
        Records.Column(1, I) = RS("Name") & ", " & RS("Ort")
        I = I + 1
        RS.MoveNext
    Wend
    
    RS.Close
    DBClose
    
    Ok.Enabled = False
End Sub

Private Sub InsertText()
    Dim Where As String
    DBOpen
    Where = " WHERE AdressId = " & Records.Column(0, Records.ListIndex)
    Set RS = DB.OpenRecordset("SELECT * FROM " & DBTable & Where)
    
    Dim Field(4) As String
    Dim F
    Field(0) = "Name"
    Field(1) = "Vorname"
    Field(2) = "Strasse"
    Field(3) = "Plz"
    Field(4) = "Ort"
    
    For Each F In Field
        With ActiveDocument.Range.Find
            .Text = "<<" & F & ">>"
            .Replacement.Text = RS(F)
            .Forward = True
            .MatchCase = False
            .Execute Replace:=wdReplaceAll
        End With
    Next
    
    RS.Close
    DBClose
End Sub

Private Sub Records_Change()
    Ok.Enabled = True
End Sub

Private Sub Search_Exit(ByVal Cancel As MSForms.ReturnBoolean)
    DBLookup
End Sub

Private Sub Ok_Click()
    InsertText
    Adressen.Hide
End Sub

Private Sub Cancel_Click()
    Adressen.Hide
End Sub

