

// includes
#include <windows.h>
#include "CTagDir.hpp"


// global variables required for service routines
SERVICE_STATUS			svcStatus;
SERVICE_STATUS_HANDLE	hSvcStatus;

// global variables used by the functionality
ULONG		maxTags;
ULONG		nTags;
CTagDir**	tags = NULL;


// function to initialize CTagDir array and to start search threads
BOOL InitTags (VOID)
{
	HKEY	hKey;
	DWORD	typeCode;
	BOOL	retCode;
	ULONG	i;
	ULONG	nameLen;
	ULONG	dataLen;
	CHAR	valName[MAX_PATH];
	CHAR	valData[MAX_PATH];
	CHAR	tmpData[MAX_PATH];

	retCode = FALSE;
	// open the configuration directory key
	if (ERROR_SUCCESS == RegOpenKey(HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Services\\CleanSvc\\Parameters\\Directories", &hKey)) {
		// get information about the key
		if (ERROR_SUCCESS == RegQueryInfoKey(hKey, NULL, NULL, NULL, NULL, NULL, NULL, &maxTags, NULL, NULL, NULL, NULL)) {
			// create tags array that will keep the pointers to CTagDir instances
			tags = new CTagDir*[maxTags];
			if (NULL != tags) {
				nTags = 0;
				for (i=0; i<maxTags; i++) {
					nameLen = MAX_PATH;
					dataLen = MAX_PATH;
					// get a key's value and type
					RegEnumValue(hKey, i, valName, &nameLen, NULL, &typeCode, (LPBYTE) valData, &dataLen);
					// if necessary expand environment variables
					switch((INT) typeCode) {
						case (INT) REG_EXPAND_SZ:
							ExpandEnvironmentStrings(valData, tmpData, MAX_PATH-1);
							lstrcpy(valData, tmpData);
						case (INT) REG_SZ:
							// create new CTagDir instance
							tags[nTags] = new CTagDir(valData);
							// and start the directory search as thread
							tags[nTags]->StartSearch(THREAD_PRIORITY_IDLE);
							nTags++;
							break;
						default:
							break;
					}
				}
				retCode = TRUE;
			}
		}
		RegCloseKey(hKey);
	}
	return retCode;
} /* InitTags */


// handler for service control requests
VOID CALLBACK SvcCtrlHandler ( IN DWORD ctrlCode)
{
	UINT	i;

	// do what is necessary depending on command ctrlCode
	switch(ctrlCode) {
		case SERVICE_CONTROL_PAUSE:
			// pause service may take some time => report progress
			svcStatus.dwCurrentState = SERVICE_PAUSE_PENDING;
			svcStatus.dwWaitHint = 60000;	// assuming 1 min is enough
			for (i=0; i<nTags; i++) {
				svcStatus.dwCheckPoint++;
				SetServiceStatus(hSvcStatus, &svcStatus);
				tags[i]->StopSearch();
			}
			svcStatus.dwCurrentState = SERVICE_PAUSED;
			svcStatus.dwCheckPoint = 0;
			svcStatus.dwWaitHint = 0;
			break;
		case SERVICE_CONTROL_CONTINUE:
			// start or restart is done quickly => don't report progress
			for (i=0; i<nTags; i++) {
				tags[i]->StartSearch(THREAD_PRIORITY_IDLE);
			}
			svcStatus.dwCurrentState = SERVICE_RUNNING;
			break;
		case SERVICE_CONTROL_STOP:
			// stop service may take some time => report progress
			svcStatus.dwCurrentState = SERVICE_STOP_PENDING;
			svcStatus.dwWaitHint = 60000;	// assuming 1 min is enough
			for (i=0; i<nTags; i++) {
				svcStatus.dwCheckPoint++;
				SetServiceStatus(hSvcStatus, &svcStatus);
				tags[i]->StopSearch();
				delete tags[i];
			}
			delete []tags;
			svcStatus.dwCurrentState = SERVICE_STOPPED;
			svcStatus.dwCheckPoint = 0;
			svcStatus.dwWaitHint = 0;
			svcStatus.dwWin32ExitCode = 0;
			break;
		case SERVICE_CONTROL_INTERROGATE:	// this must be handled
			break;
		default:
			break;
	}
	// allways report final status to the service control manager
	SetServiceStatus(hSvcStatus, &svcStatus);
} /* SvcCtrlHandler */


// the service main (e.g. startup) function
VOID CALLBACK SvcMain (DWORD argc, LPTSTR* argv)
{
	// initialize the status structure
	svcStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
	svcStatus.dwCurrentState = SERVICE_START_PENDING;
	svcStatus.dwControlsAccepted = (SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_PAUSE_CONTINUE);
	svcStatus.dwWin32ExitCode = 0;
	svcStatus.dwServiceSpecificExitCode = 0;
	svcStatus.dwCheckPoint = 0;
	svcStatus.dwWaitHint = 0;
	// register the control handler function
	hSvcStatus = RegisterServiceCtrlHandler("CleanSvc", SvcCtrlHandler);
	// if registered successfully
	if ((SERVICE_STATUS_HANDLE) 0 != hSvcStatus) {
		// if successfully initialized set status to running else to stopped
		if (InitTags()) {
			svcStatus.dwCurrentState = SERVICE_RUNNING;
		}
		else {
			svcStatus.dwCurrentState = SERVICE_STOPPED;
			svcStatus.dwWin32ExitCode = 0;
			svcStatus.dwServiceSpecificExitCode = 0;
		}
		// report status
		SetServiceStatus(hSvcStatus, &svcStatus);
	}
} /* SvcMain */


// the process main function
VOID main (VOID)
{
	// only one service main routine to start - terminate table with double zero
	SERVICE_TABLE_ENTRY svcDispTable[] = {{"CleanSvc", SvcMain}, {NULL, NULL}};

	// start the service main function and do not return until service ends
	StartServiceCtrlDispatcher(svcDispTable);
} /* main */

