unit DeEditU; /// 03-DEC-97 as (Arne Schpers)
{ Praktisch verwendbare OLE-Automatisierung mit WinWord }

{$IFNDEF WIN32}
{$Sorry, aber mit 16 Bit ist hier nichts zu holen}
{$ENDIF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, ComObj, Clipbrd, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    // Parent von bEditText .. cMSWordEditing, Align = alBottom
    Panel1: TPanel;
    bEditText: TButton;
    cMSWordRunning: TCheckBox;
    cMSWordEditing: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure bEditTextClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject;
      var CanClose: Boolean);
  private
    FMSWordRunning, FMSWordEditing: Boolean;
    MSWord: Variant;
    CallbackWnd: HWnd; CallbackMsg: LongInt;
    BoldList: TList; TextBuf: String;
    MSWordDotName: String;  // Formatvorlage
  protected
    procedure CallbackWndProc(var Msg: TMessage);
    procedure ClearBoldList;
    procedure ClipBoardToTextBuf;  // Ergebnis von WinWord
    // nur zur Anzeige
    procedure SetMSWordRunning(Value: Boolean);
    // Anzeige und Enable/Disable von bEditText
    procedure SetMSWordEditing(Value: Boolean);
    // Fenster whrend Editing in den Hintergrund
    procedure OnActivateApp(Sender: TObject);
  public
    property MSWordRunning: Boolean read FMSWordRunning
      write SetMSWordRunning;
    property MSWordEditing: Boolean read FMSWordEditing
      write SetMSWordEditing;
  end;

var Form1: TForm1;

implementation

{$R *.DFM}

{ Start- und Stop-Indices fr Fettschrift werden in
  einer TList (BoldList) festgehalten }
type
  TBoldSpot = record
    Start, Stop: Integer;
  end;
  PBoldSpot = ^TBoldSpot;

procedure TForm1.FormCreate(Sender: TObject);
var NewSpot: PBoldSpot;
    KeyHandle: LongInt;  // Registrierung

 procedure RegSetVal(KeyHandle: LongInt; ValName, Value: String);
 begin  // Eintrag eines Strings in die Registrierung
   RegSetValueEx(KeyHandle,PChar(ValName), 0, REG_SZ,
     PChar(Value), Length(Value)+1);
 end;

begin
  CallbackMsg := RegisterWindowMessage('Callback von WinWord');
  CallbackWnd := AllocateHWnd(CallbackWndProc);
  BoldList := TList.Create;

  // Demotext mit zwei Boldspots
  TextBuf := 'Ein einzeiliger Text mit Fettschrift '+
    'zur Demonstration';
  New(NewSpot); BoldList.Add(NewSpot);
  NewSpot^.Start := 17; NewSpot^.Stop := 20;
  New(NewSpot); BoldList.Add(NewSpot);
  NewSpot^.Start := 26; NewSpot^.Stop := 36;
  Font.Name := 'Arial';  // reine Optik

  // Formatvorlage im .EXE-Verzeichnis
  MSWordDotName := ExtractFilePath(ParamStr(0))+'DeEdit.dot';
  // Fenstertitel nicht im Designer einsetzen, weil WordBasic
  // mit AnwAktiv und AnwAktivieren sonst das Design-Fenster
  // der Form anspricht...
  Caption := 'WinWord-Textbearbeitung ber OLE-Automatisierung';

  // Registrierungseintrge fr die Callbacks
  RegCreateKey(HKEY_CURRENT_USER,'Software\DelphiEdit',KeyHandle);
  RegSetVal(KeyHandle,'CallbackMsg',IntToStr(CallbackMsg));
  RegSetVal(KeyHandle,'CallbackWnd',IntToStr(CallbackWnd));
  RegSetVal(KeyHandle,'EditorTitle',Caption);
  RegCloseKey(KeyHandle);

  // Fenster in den Hintergrund, so lange das Editing luft
  Application.OnActivate := OnActivateApp;
end;

// XRef: ClipboardToTextBuf, FormDestroy
procedure TForm1.ClearBoldList;
var x: Integer;
begin
  for x := 0 to BoldList.Count-1 do
    Dispose(PBoldSpot(BoldList[x]));
  BoldList.Clear;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  DeallocateHWnd(CallbackWnd);
  ClearBoldList; BoldList.Free;
end;

procedure TForm1.SetMSWordRunning(Value: Boolean);
begin // reine Anzeigefunktion
  FMSWordRunning := Value; cMSWordRunning.Checked := Value;
end;

procedure TForm1.SetMSWordEditing(Value: Boolean);
begin // Anzeige und Mehrfachstart-Bremse
  FMSWordEditing := Value; cMSWordEditing.Checked := Value;
  bEditText.Enabled := not Value;
end;

// Reichlich primitive Textausgabe
procedure TForm1.FormPaint(Sender: TObject);
var x, BoldIndex, XPos, YPos, Tw: Integer;
  procedure NewLine;
  begin
    Inc(YPos,MulDiv(Canvas.TextHeight('M'),10,9));
    XPos := 0;
  end;
begin
  BoldIndex := 0; XPos := 0; YPos := 0;
  Canvas.Font.Style := []; Canvas.Brush.Style := bsClear;
  for x := 1 to Length(TextBuf) do
  begin
    if (BoldIndex < BoldList.Count) then
     with PBoldSpot(BoldList[BoldIndex])^ do
       if x = Start then Canvas.Font.Style := [fsBold]
        else if x = Stop+1 then
        begin
          Canvas.Font.Style := []; Inc(BoldIndex);
        end;
    case Textbuf[x] of
    #13: NewLine;
    #10: ;
     else
      Tw := Canvas.TextWidth(TextBuf[x]);
      // harter Umbruch, keine Worttrennung
      if (XPos+Tw > ClientWidth) then NewLine;
      Canvas.TextOut(XPos,YPos,TextBuf[x]);
      Inc(XPos,Tw);
     end;
  end;
end;

//---------- Kommunikation mit WinWord -------------//
{ Speichern eines vernderten Texts in WinWord:
  1. wParam = 3 (SendMessage, Makro StopEditing)
     -> wParam = 98 -> ClipBoardToTextBuf
  2. wParam = 2 (PostMessage, Makro AutoClose)

  Speichern ohne Vernderung
  1. wParam = 2 (SendMessage, Makro StopEditing)

  Abbruch der Bearbeitung
  1. wParam = 2 (PostMessage, Makro AutoClose)

  Schlieen von WinWord
  1. wParam = 1 (PostMessage, Makro AutoExit)
  2. wParam = 2 (PostMessage, Makro AutoClose)

  Klick auf der Form whrend des Editings
  1. wParam = 99 (von FormActivate)
}
procedure TForm1.CallbackWndProc(var Msg: TMessage);
begin
  with Msg do
    if Msg = CallbackMsg then
    begin
      case wParam of
        1: ;  // Close von WinWord
        2: ;  // Abort Editing
        3: if MSWordEditing
              then PostMessage(CallbackWnd,CallbackMsg,98,0);
        // Text aus der Zwischenablage (delayed)
        98: ClipBoardToTextBuf;
        99: // delayed BringToFront fr WinWord
          begin
            if MSWordEditing
              then MSWord.AnwAktivieren('Microsoft Word',1);
            Exit;
          end;
      end;
      MSWordEditing := False;
      if wParam = 1 then MSWordRunning := False;
      Result := 0;
    end
     else Result := DefWindowProc(CallbackWnd,Msg,wParam,lParam);
end;

procedure TForm1.OnActivateApp(Sender: TObject);
begin
  PostMessage(CallBackWnd,CallbackMsg,99,0);
end;

procedure TForm1.bEditTextClick(Sender: TObject);
var x: Integer; TempBuf: String;
begin
  if not MSWordRunning then
  begin
    MSWord := CreateOleObject('Word.Basic');
    MSWord.AnwWiederherstellen;  // falls Icon
    { Hier knnte man jetzt auch noch die Fensterposition
      setzen - in "Punkt"
      MSWord.AnwFensterLinks(...);
    }
    MSWordRunning := True;
  end;
  TempBuf := TextBuf;
  // Marker von hinten nach vorne einsetzen - Indices
  // verschieben sich durch den zustzlichen Text
  for x := BoldList.Count-1 downto 0 do
    with PBoldSpot(BoldList[x])^ do
    begin
      Insert('@B0@',TempBuf,Stop+1);
      Insert('@B1@',TempBuf,Start);
    end;

  // Neue Datei mit der vorbereiteten .DOT anlegen
  MSWord.DateiNeu(DokVorlage := MSWordDotName);
  MSWord.Einfgen(TempBuf);
  MSWord.ExtrasMakro(Name := 'StartEditing', Ausfhren := True);
  MSWord.DokumentMaximieren(1);
  MSWordEditing := True;
  MSWord.AnwAnzeigen;
end;

// @B1@Text@B0@ -> TextBuf, BoldList
procedure TForm1.ClipBoardToTextBuf;
var NewSpot: PBoldSpot; x: Integer;
begin
  ClearBoldList;
  TextBuf := ClipBoard.AsText;
  repeat
    x := Pos('@B1@',TextBuf);
    if x = 0 then Break;
    New(NewSpot); BoldList.Add(NewSpot);
    NewSpot^.Start := x; Delete(TextBuf,x,4);
    // das kann eigentlich nicht schiefgehen
    x := Pos('@B0@',TextBuf);
    NewSpot^.Stop := x-1; Delete(TextBuf,x,4);
  until False;
  Invalidate;  // Neuausgabe des Texts
end;



procedure TForm1.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if MSWordEditing and (MSWord.IstDokumentGendert <> 0) then
  begin
    // Hack: Editorfenster nicht in den Hintergrund schieben
    MSWordEditing := False;
    CanClose := MessageDlg('Textnderungen verwerfen?',
     mtConfirmation, [mbYes, mbNo], 0) = mrYes;
    // Vorherige Verhltnisse wiederherstellen
    MSWordEditing := True;
    OnActivateApp(Self);
  end;
end;

end.