unit MiniClientU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, MiniServ_TLB;

type
  TMiniclientForm = class(TForm)
    Memo1: TMemo;
    bCopy: TButton;
    bPaste: TButton;
    bShutdown: TButton;
    bCreateObj: TButton;
    bDestroyObj: TButton;
    bCreateLocal: TButton;
    bObjAsParam: TButton;
    procedure bCreateObjClick(Sender: TObject);
    procedure bDestroyObjClick(Sender: TObject);
    procedure bCopyClick(Sender: TObject);
    procedure bPasteClick(Sender: TObject);
    procedure bShutdownClick(Sender: TObject);
    procedure bCreateLocalClick(Sender: TObject);
    procedure bObjAsParamClick(Sender: TObject);
  private
    MiniServer: IMiniServer;
  public
    { Public declarations }
  end;

var
  MiniclientForm: TMiniclientForm;

implementation

{$R *.DFM}

procedure TMiniclientForm.bCreateObjClick(Sender: TObject);
begin
  MiniServer := CoMiniServer.Create;
end;

procedure TMiniclientForm.bDestroyObjClick(Sender: TObject);
begin
  MiniServer := nil;
end;

procedure TMiniclientForm.bCopyClick(Sender: TObject);
begin
  if MiniServer = nil then Exit;
  MiniServer.Text := Memo1.Lines.Text;
  ShowMessage(IntToStr(MiniServer.TextLen)+ ' Zeichen kopiert.');
end;

procedure TMiniclientForm.bPasteClick(Sender: TObject);
begin
  if MiniServer = nil then Exit;
  Memo1.SetTextBuf(PChar(String(MiniServer.Text)));
end;

procedure TMiniclientForm.bShutdownClick(Sender: TObject);
begin
  if MiniServer = nil then Exit;
  MiniServer.Shutdown;
end;

procedure TMiniclientForm.bCreateLocalClick(Sender: TObject);
var LocalServ: IMiniServer;
begin
  LocalServ := CoMiniServer.Create;
  ShowMessage(Format('Lnge: %d Zeichen',[LocalServ.TextLen]));
  LocalServ := nil;
end;

procedure COMObjAsParam(COMObj: IMiniServer); 
begin
  ShowMessage(Format('Lnge: %d Zeichen',[COMObj.TextLen]));
end;

procedure TMiniclientForm.bObjAsParamClick(Sender: TObject);
begin
  if MiniServer <> nil then COMObjAsParam(MiniServer);
end;

end.

