unit MiniServ_COM; // vom TLB-Editor erzeugt/modifiziert

interface

uses
  ComObj, ActiveX, MiniServ_TLB;

type
  TMiniserver = class(TAutoObject, IMiniserver)
  private
    ID: Integer; // manuell eingesetzt
  protected
    function Get_Text: WideString; safecall;
    function Get_TextLen: Integer; safecall;
    procedure Set_Text(const Value: WideString); safecall;
    procedure ShutDown; safecall;
    procedure Method1; safecall;
  public
    procedure Initialize; override;  // manuell eingesetzt
    destructor Destroy; override;    // dito
  end;

implementation

uses ComServ, MiniServMain;  // die Form

procedure TMiniserver.Initialize;
begin
  inherited;
  ID := Form1.IDToList;  // "Anmeldung"
end;

destructor TMiniserver.Destroy;
begin
  Form1.DeleteIDFromList(ID);
  inherited;
end;

function TMiniserver.Get_Text: WideString;
begin
  Result := Form1.TextBuffer;
end;

function TMiniserver.Get_TextLen: Integer;
begin
  Result := Length(Form1.TextBuffer);
end;

procedure TMiniserver.Set_Text(const Value: WideString);
begin
  Form1.TextBuffer := Value;
end;

procedure TMiniserver.ShutDown;
begin
  Form1.Shutdown;
end;

procedure TMiniserver.Method1;
begin

end;

initialization
  TAutoObjectFactory.Create(ComServer, TMiniserver, Class_Miniserver, ciMultiInstance);
end.
