unit MandelServ_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ MandelServ Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_MandelServ: TGUID = '{5A0CA7E1-8D1A-11D1-B84E-0080C8681C8A}';

const

{ Component class GUIDs }
  Class_MandelCalc: TGUID = '{5A0CA7E3-8D1A-11D1-B84E-0080C8681C8A}';

type

{ Forward declarations: Interfaces }
  IMandelCalc = interface;
  IMandelCalcDisp = dispinterface;

{ Forward declarations: CoClasses }
  MandelCalc = IMandelCalc;

{ Dispatch interface for MandelCalc Object }

  IMandelCalc = interface(IDispatch)
    ['{5A0CA7E2-8D1A-11D1-B84E-0080C8681C8A}']
    procedure Shutdown; safecall;
    function Get_ColStart: Integer; safecall;
    procedure Set_ColStart(Value: Integer); safecall;
    function Get_Cols: Integer; safecall;
    procedure Set_Cols(Value: Integer); safecall;
    function Get_Lines: Integer; safecall;
    procedure Set_Lines(Value: Integer); safecall;
    function Get_CurLine: Integer; safecall;
    procedure Set_CurLine(Value: Integer); safecall;
    procedure StartCalc; safecall;
    procedure StopCalc; safecall;
    function Get_Calculating: WordBool; safecall;
    function Get_ReStart: Double; safecall;
    procedure Set_ReStart(Value: Double); safecall;
    function Get_ImStart: Double; safecall;
    procedure Set_ImStart(Value: Double); safecall;
    function Get_ReStep: Double; safecall;
    procedure Set_ReStep(Value: Double); safecall;
    function Get_ImStep: Double; safecall;
    procedure Set_ImStep(Value: Double); safecall;
    function Get_IterMax: Integer; safecall;
    procedure Set_IterMax(Value: Integer); safecall;
    function Get_VPixels: OleVariant; safecall;
    procedure Set_VPixels(Value: OleVariant); safecall;
    procedure SetAll(Params: OleVariant); safecall;
    property ColStart: Integer read Get_ColStart write Set_ColStart;
    property Cols: Integer read Get_Cols write Set_Cols;
    property Lines: Integer read Get_Lines write Set_Lines;
    property CurLine: Integer read Get_CurLine write Set_CurLine;
    property Calculating: WordBool read Get_Calculating;
    property ReStart: Double read Get_ReStart write Set_ReStart;
    property ImStart: Double read Get_ImStart write Set_ImStart;
    property ReStep: Double read Get_ReStep write Set_ReStep;
    property ImStep: Double read Get_ImStep write Set_ImStep;
    property IterMax: Integer read Get_IterMax write Set_IterMax;
    property VPixels: OleVariant read Get_VPixels write Set_VPixels;
  end;

{ DispInterface declaration for Dual Interface IMandelCalc }

  IMandelCalcDisp = dispinterface
    ['{5A0CA7E2-8D1A-11D1-B84E-0080C8681C8A}']
    procedure Shutdown; dispid 1;
    property ColStart: Integer dispid 2;
    property Cols: Integer dispid 3;
    property Lines: Integer dispid 4;
    property CurLine: Integer dispid 5;
    procedure StartCalc; dispid 6;
    procedure StopCalc; dispid 7;
    property Calculating: WordBool readonly dispid 8;
    property ReStart: Double dispid 9;
    property ImStart: Double dispid 10;
    property ReStep: Double dispid 11;
    property ImStep: Double dispid 12;
    property IterMax: Integer dispid 13;
    property VPixels: OleVariant dispid 14;
    procedure SetAll(Params: OleVariant); dispid 15;
  end;

{ MandelCalcObject }

  CoMandelCalc = class
    class function Create: IMandelCalc;
    class function CreateRemote(const MachineName: string): IMandelCalc;
  end;



implementation

uses ComObj;

class function CoMandelCalc.Create: IMandelCalc;
begin
  Result := CreateComObject(Class_MandelCalc) as IMandelCalc;
end;

class function CoMandelCalc.CreateRemote(const MachineName: string): IMandelCalc;
begin
  Result := CreateRemoteComObject(MachineName, Class_MandelCalc) as IMandelCalc;
end;


end.
