unit MandelCltU;  // 10-FEB-98 as
{ Dieser Client dirigiert eine fast beliebige Zahl von DCOM-
  Servern zur streifenweisen Berechnung von Apfelmnnchen
  und bernimmt dabei auch die Lastverteilung }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, MandelServ_TLB, StdCtrls, ExtCtrls,
  MandelTypes;  // <- TParamBlock fr .SetAll

type  // Primitiv-Klasse fr (D)COM-Objekt plus Daten
  TCalcObject = class(TComponent)
  public
    ServerName: String; // ebendies (nur Anzeige)
    JobsDone: Integer;  // Job-Zhler (nur Anzeige)
    ComObject: IMandelCalc;  // DCOM-Objekt
  end;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    bStart: TButton;
    bStop: TButton;
    Timer1: TTimer;
    Label1: TLabel;
    bConnect: TButton;
    BarIterMax: TScrollBar;
    Label2: TLabel;
    lGlobalIterMax: TLabel;
    Label3: TLabel;
    lTime: TLabel;
    BarServersUsed: TScrollBar;
    Label4: TLabel;
    lServersUsed: TLabel;
    Label5: TLabel;
    lJobCount: TLabel;
    BarJobCount: TScrollBar;
    bDirect: TButton;
    cLocal: TCheckBox;
    cRecur: TCheckBox;
    Label6: TLabel;
    lReStart: TLabel;
    Label7: TLabel;
    lReEnd: TLabel;
    Label8: TLabel;
    lImStart: TLabel;
    bReset: TButton;
    cSetAll: TCheckBox;
    ServerBox: TMemo;
    procedure bStartClick(Sender: TObject);
    procedure bStopClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bConnectClick(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure BarIterMaxChange(Sender: TObject);
    procedure BarServersUsedChange(Sender: TObject);
    procedure BarJobCountChange(Sender: TObject);
    procedure bDirectClick(Sender: TObject);
    procedure cLocalClick(Sender: TObject);
    procedure bResetClick(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    ObjList: TList;    // TCalcObject-Liste
    PaintBMP: TBitmap; // -> PaintBox1.Paint
    StartTime: TDateTime;
    ServersUsed, JobCount: Integer;
    DirectStop: Boolean; // Abbruch bei lokaler Berechnung
    GlobalReStart, GlobalReEnd, GlobalImStart: Double;
    GlobalReStep, GlobalImStep: Double;
    // Spalte und Breite fr den nchsten Streifen
    NextColStart, NextColWidth: Integer;
    procedure NextStrip(CalcObject: TCalcObject);
    procedure ShowValues;
    procedure PaintMouseRect;  // Auswahl per Maus
  end;


var Form1: TForm1;

const  // Grenzen fr die Gesamtansicht des Apfelmnnchens
  InitReStart = -2.267; InitReEnd = 1.00;
  InitImStart = -1.125;
  GlobalIterMax: Integer = 250;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ObjList := TList.Create;  // TCalcObject-Objekte
  PaintBMP := TBitmap.Create;  // -> PaintBox1Paint
  PaintBMP.Width := PaintBox1.Width;
  PaintBMP.Height := PaintBox1.Height;
  // Anstelle "unsichtbarer" Einstellungen im Object Inspector
  with BarIterMax do
  begin  // maximale Iterationstiefe
    Max := 100000; Position := GlobalIterMax; Min := 250;
  end;
  BarServersUsed.Enabled := False; lServersUsed.Caption := '0';
  with BarJobCount do
  begin  // Maximalzahl Jobs pro Server
    Max := 20; Min := 1; Position := 1;
  end;
  lTime.Caption := '---'; cLocal.Enabled := False;
  Timer1.Interval := 200;  // 5 Abfragen pro Sekunde

  // Primitiv-Ersatz fr das Durchsuchen des Netzwerks
  ServerBox.Clear;
  ServerBox.Lines.Add('Hier die Servernamen einsetzen');
  ServerBox.Lines.Add('(ein Name pro Zeile)');

  bResetClick(Self); bStart.Enabled := False;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ObjList.Free; PaintBMP.Free;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  bStopClick(Self);
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  PaintBox1.Canvas.Draw(0,0,PaintBMP);
end;

procedure TForm1.bConnectClick(Sender: TObject);
var x: Integer; CalcObject: TCalcObject;
begin
  if Serverbox.Lines.Count = 0 then
  begin
    ShowMessage('Bitte erst Servernamen in die Box eintragen...');
    Exit;
  end;
  bConnect.Enabled := False; bConnect.Caption := 'Wait...';
  Cursor := crHourglass;
  // Leerzeilen raus
  with ServerBox do
    for x := Lines.Count-1 downto 0 do
      if Trim(Lines[x]) = '' then Lines.Delete(x);

  x := 0;
  while x < ServerBox.Lines.Count do
  begin
    Application.ProcessMessages;
    CalcObject := TCalcObject.Create(Self);
    try
      with CalcObject do
      begin
        ServerName := ServerBox.Lines[x];
        ComObject := CoMandelCalc.CreateRemote(ServerName);
        Application.ProcessMessages;
      end;
      ObjList.Add(CalcObject);
      Inc(x);
    except  // ist kein Server, Servername falsch usw.
      on E: Exception do
      begin
        ShowMessage(CalcObject.ServerName+': '+E.Message);
        CalcObject.Free;
        ServerBox.Lines.Delete(x);
      end;
    end;
  end;
  if ObjList.Count > 0 then
  begin  // wenigstens einen Server gefunden
    with BarServersUsed do
    begin
      Enabled := True; Max := ObjList.Count; Min := 1;
      Position := ObjList.Count;
    end;
    cLocal.Enabled := True; bStart.Enabled := True;
    bConnect.Visible := False;
  end else
  begin  // fr den nchsten Versuch
    bConnect.Enabled := True;
    bConnect.Caption := 'Connect';
  end;
  Cursor := crDefault;
end;

// Zyklische Abfrage aller Server, kann auch rekursiv laufen
procedure TForm1.Timer1Timer(Sender: TObject);
var S, x,y: Integer; StartCol,ColCount,LineCount: Integer;
    PixelData: Variant; PPixels: ^TColor;
    AllDone: Boolean;
begin
  if not cRecur.Checked then Timer1.Enabled := False;
  for S := 0 to ObjList.Count-1 do
  with TCalcObject(ObjList[S]) do
    with ComObject do
     if not Calculating
        then ServerBox.Lines[S] := Format('%s: Idle (%d Jobs)',
          [ServerName,JobsDone])
     else if CurLine < Lines then
       ServerBox.Lines[S] := Format('%s: Col %d, Line %d, Job %d',
          [ServerName, ColStart,CurLine, JobsDone])
    else // Berechnung beendet: Ergebnis abholen, NextStrip
    begin
      Inc(JobsDone);
      StopCalc;  // Calculating := False
      StartCol := ColStart; ColCount := Cols; LineCount := Lines;
      PixelData := VPixels; PPixels := VarArrayLock(PixelData);
      // Den Server so schnell wie mglich wieder beschftigen
      NextStrip(TCalcObject(ObjList[S]));
      // Alle Berechnungen beendet (Zeitmessung)?
      AllDone := True;
      for x := 0 to ObjList.Count-1 do
        if TCalcObject(ObjList[x]).ComObject.Calculating then
        begin
          AllDone := False; Break;
        end;
      if AllDone then lTime.Caption := TimeToStr(Now-StartTime);
      for y := 0 to LineCount-1 do
        for x := 0 to ColCount-1 do
        begin
          SetPixel(PaintBox1.Canvas.Handle,StartCol+x,y,PPixels^);
          SetPixel(PaintBMP.Canvas.Handle,StartCol+x,y,PPixels^);
          Inc(PPixels);
          // Hier kann im rekursiven Betrieb das nchste
          // Timer-Ereignis reinplatzen
          Application.ProcessMessages;
        end;
      VarArrayUnlock(PixelData);
    end;
  Timer1.Enabled := True;
end;

procedure TForm1.bStartClick(Sender: TObject);
var x: Integer;
begin
  if ObjList.Count = 0 then Exit;
  bStopClick(Self);
  with PaintBMP do  // auf wei zurcksetzen
  begin
    Canvas.Brush.Style := bsSolid;
    Canvas.FillRect(Rect(0,0,Width,Height));
  end;
  PaintBox1.Invalidate;
  NextColStart := 0;
  GlobalReStep := (GlobalReEnd-GlobalReStart) / PaintBox1.Width;
  GlobalImStep := GlobalReStep;
  StartTime := Now;
  if cLocal.Checked then
  begin  // lokales COM-Objekt (= 1 Server)
    NextColWidth := PaintBox1.Width div JobCount + 1;
    TCalcObject(ObjList[ObjList.Count-1]).JobsDone := 0;
    NextStrip(TCalcObject(ObjList[ObjList.Count-1]));
  end else
  begin  // DCOM-Objekte (mehrere Server)
    NextColWidth := PaintBox1.Width div (ServersUsed*JobCount) + 1;
    for x := 0 to ServersUsed-1 do
    begin
      TCalcObject(ObjList[x]).JobsDone := 0;
      NextStrip(TCalcObject(ObjList[x]));
    end;
  end;
end;

procedure TForm1.bStopClick(Sender: TObject);
var x: Integer;
begin
  lTime.Caption := '---'; DirectStop := True;
  for x := 0 to ObjList.Count-1 do
    TCalcObject(ObjList[x]).ComObject.StopCalc;
end;

procedure TForm1.NextStrip(CalcObject: TCalcObject);
var Params: OleVariant; PParams: PParamBlock;
begin
  // alle Streifen erledigt?
  if NextColStart >= PaintBox1.Width then Exit;
  if cSetAll.Checked then
  begin  // Parameter en bloc
    Params := VarArrayCreate([0,SizeOf(TParamBlock)-1],varByte);
    PParams := VarArrayLock(Params);
    with PParams^ do
    begin
      _ColStart := NextColStart;
      if NextColStart+NextColWidth > PaintBox1.Width
        then _Cols := PaintBox1.Width-NextColStart
        else _Cols := NextColWidth;
      _Lines := PaintBox1.Height; _CurLine := 0;
      _ReStart := GlobalReStart; _ImStart := GlobalImStart;
      _ReStep := GlobalReStep; _ImStep := GlobalImStep;
      _IterMax := GlobalIterMax;
    end;
    VarArrayUnlock(Params);
    with CalcObject.ComObject do
    begin
      SetAll(Params);
      StartCalc;
    end;
  end else
  begin  // Parameter ber einzelne Eigenschaften
    with CalcObject.ComObject do
    begin
      ColStart := NextColStart;
      if NextColStart+NextColWidth > PaintBox1.Width
        then Cols := PaintBox1.Width-NextColStart
        else Cols := NextColWidth;
      Lines := PaintBox1.Height; CurLine := 0;
      ReStart := GlobalReStart; ImStart := GlobalImStart;
      ReStep := GlobalReStep; ImStep := GlobalImStep;
      IterMax := GlobalIterMax;
      StartCalc;
    end;
  end;
  Inc(NextColStart,NextColWidth);  // fr den nchsten Streifen
end;

// Direktausfhrung zum Vergleich. Grundstzlich erheblich lang-
// samer, weil das System gleichzeitig rechnen und zeichnen mu
procedure TForm1.bDirectClick(Sender: TObject);
var x,y: Integer; RePart, ImPart: Double;
    PColor: TColor; IterMax: Integer;
Label CalcStopped;

  // Exakt dieselbe Rechenroutine wie in MandelServ
  function Iterate(Re, Im: Double): Integer;
  var x,y,x2,y2: Double; k: Integer;
  begin
    x := 0; y := 0; x2 := y; y2 := 0; k := 0;
    repeat
      y := 2 * x * y + Im; x := x2 - y2 + Re;
      x2 := Sqr(x); y2 := Sqr(y);
      Inc(k);
    until (x2+y2 > 4) or (k >= IterMax);
    Result := k;
  end;
begin
  bStopClick(Self); DirectStop := False;
  lTime.Caption := 'Direct...';
  StartTime := Now;
  with PaintBMP do
  begin
    Canvas.Brush.Style := bsSolid;
    Canvas.FillRect(Rect(0,0,Width,Height));
  end;
  PaintBox1.Invalidate;
  ImPart := GlobalImStart; IterMax := GlobalIterMax;
  GlobalReStep := (GlobalReEnd-GlobalReStart) / PaintBox1.Width;
  GlobalImStep := GlobalReStep;
  for y := 0 to PaintBox1.Height-1 do
  begin
    RePart := GlobalReStart;
    for x := 0 to PaintBox1.Width-1 do
    begin
      // 0..MAXITER -> 0..MAXCOLOR
      PColor := TColor(Iterate(RePart,ImPart) *
         (256*256*256 div (IterMax)));
      SetPixel(PaintBMP.Canvas.Handle,x,y,PColor);
      SetPixel(PaintBox1.Canvas.Handle,x,y,PColor);
      RePart := RePart + GlobalReStep;
      Application.ProcessMessages;
      if DirectStop then goto CalcStopped;
    end;
    ImPart := ImPart + GlobalImStep;
  end;
CalcStopped:
  if not DirectStop then
  begin
    lTime.Caption := TimeToStr(Now-StartTime);
    PaintBox1.Invalidate;
  end;
end;

// --- Oberflche -----------------------------------
procedure TForm1.BarIterMaxChange(Sender: TObject);
begin
  GlobalIterMax := BarIterMax.Position;
  lGlobalIterMax.Caption := IntToStr(GlobalIterMax);
end;

procedure TForm1.BarServersUsedChange(Sender: TObject);
begin
  ServersUsed := BarServersUsed.Position;
  lServersUsed.Caption := IntToStr(ServersUsed);
end;

procedure TForm1.BarJobCountChange(Sender: TObject);
begin
  JobCount := BarJobCount.Position;
  lJobCount.Caption := IntToStr(JobCount);
end;

procedure TForm1.cLocalClick(Sender: TObject);
var LocalObject: TCalcObject;
begin
  if cLocal.Checked then
  begin
    LocalObject := TCalcObject.Create(Self);
    ObjList.Add(LocalObject);
    LocalObject.ServerName := '"LOCAL"';
    ServerBox.Lines.Add(LocalObject.ServerName);
    LocalObject.ComObject := CoMandelCalc.Create;
  end else
  begin
    LocalObject := ObjList[ObjList.Count-1];
    ObjList.Remove(LocalObject);
    LocalObject.ComObject := nil;
    LocalObject.Free;
    with ServerBox do Lines.Delete(Lines.Count-1);
  end;
end;

procedure TForm1.bResetClick(Sender: TObject);
begin
  bStopClick(Self);
  GlobalReStart := InitReStart; GlobalReEnd := InitReEnd;
  GlobalImStart := InitImStart; ShowValues;
end;

// Auswahl des Ausschnitts per Mauszeiger
procedure TForm1.ShowValues;
begin
  lReStart.Caption := FloatToStr(GlobalReStart);
  lReEnd.Caption := FloatToStr(GlobalReEnd);
  lImStart.Caption := FloatToStr(GlobalImStart);
end;

var MouseRect: TRect; MouseDrag: Boolean;

procedure TForm1.PaintMouseRect;
begin
  with PaintBMP.Canvas do
  begin
    Brush.Style := bsClear;
    Pen.Mode := pmXor; Pen.Color := RGB(128,128,128);
    with MouseRect do Rectangle(Left,Top,Right,Bottom);
    Pen.Mode := pmCopy;
  end;
  PaintBox1.Canvas.Draw(0,0,PaintBMP);
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    bStopClick(Self);
    MouseRect := Rect(X,Y,X,Y); MouseDrag := True;
    PaintMouseRect;
  end else if (Button = mbRight) and MouseDrag then
  begin  // Abbruch der momentanen Auswahl
    PaintMouseRect; MouseDrag := False;
  end;
end;

procedure TForm1.PaintBox1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if not MouseDrag then Exit;
  PaintMouseRect;  // alte Version vom Bildschirm
  MouseRect.Right := X; MouseRect.Bottom := Y;
  PaintMouseRect;
end;

procedure TForm1.PaintBox1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if not MouseDrag then Exit;
  MouseDrag := False;
  with MouseRect do
  begin
    if Left > Right then
    begin  // ggf. umdrehen
      X := Left; Left := Right; Right := X;
    end;
    if Top > Bottom then
    begin
      X := Top; Top := Bottom; Bottom := X;
    end;
    if Left < 0 then Left := 0; if Top < 0 then Top := 0;
    // Minimalbreite und -Hhe ist 1
    if Right-Left = 0 then Inc(Right);
    if Bottom-Top = 0 then Inc(Bottom);

    // Neuer Startpunkt (mit der alten Schrittweite)
    GlobalReStart := GlobalReStart+Left*GlobalReStep;
    GlobalImStart := GlobalImStart+Top*GlobalReStep;
    // grbere Schrittweite aussuchen
    if (Right-Left)*PaintBox1.Height > (Bottom-Top)*PaintBox1.Width
     then
      GlobalReStep := GlobalReStep*(Right-Left)/PaintBox1.Width
     else
      GlobalReStep := GlobalReStep*(Bottom-Top)/PaintBox1.Height;
    // aus GlobalReEnd ergibt sich wieder die Schrittweite (naja)
    GlobalReEnd := GlobalReStart+GlobalReStep*PaintBox1.Width;
    ShowValues;
  end;
end;

end.


