unit SmallLittleFrame;

{The Little Richard Editor
 (C) 1996, 1997, 1998 by Johannes Leckebusch
 23. 04. 98}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, Buttons, ComCtrls, ExtDlgs,
  SDateimanager;

CONST
{$IFDEF Explorer}
   cVersion = 'SLRE (c''t): S.9834';
{$ELSE}
   cVersion = 'SLR2 (c''t): S.9834';
{$ENDIF}
   VK_X = $58;

type

  TWindowEinstellungen =
  RECORD
    FrameWinDefault: BOOLEAN;
    FramePos:        TPosition;
    FrameWin:        TWindowState;
    FrameTop, FrameLeft, FrameHeight,
    FrameWidth:      Integer;
    ChildWinDefault: BOOLEAN;
    ChildPos:        TPosition;
    ChildWin:        TWindowState;
    ChildTop, ChildLeft, ChildHeight,
    ChildWidth:      Integer;
    ChildLoad:       BOOLEAN;
    ChildFull:       BOOLEAN;
  END;

  TKonfiguration =
       RECORD
         HistoryAnzeigen:          BOOLEAN;
         AusHistoryLaden:          BOOLEAN;
         SchaltleisteAnzeigen:     BOOLEAN;
         Schaltleiste2Anzeigen:    BOOLEAN;
         LinealAnzeigen:           BOOLEAN;
         ISOAnzeigen:              BOOLEAN;
         WortUmbruch:              BOOLEAN;
         TextModus:                BOOLEAN;
         (*------------------------------*)
         BAKErstellen:             BOOLEAN;
         TerminalStart:            BOOLEAN;
         StatusLeiste:             BOOLEAN;
         AutoSaveAbfrage:          BOOLEAN;
         Schaltleiste3Anzeigen:    BOOLEAN;
         LetztenLaden, AutoSaveKonfig,
         bool7:      BOOLEAN;
         MaxHistory:               Integer;
         MaxTextLaenge:            Integer;
         ZeichenAufSeite,
         MaxFavorite,
         saveIntervall,
         LastHistory, DateiFilterIndex, Int7:   Integer;
       END (* TKonfiguration *);

  TLRFrame = class(TForm)
    FrameMenu: TMainMenu;
    Datei1: TMenuItem;
    Neu1: TMenuItem;
    Oeffnen1: TMenuItem;
    N1: TMenuItem;
    Beenden1: TMenuItem;
    Fenster1: TMenuItem;
    Nebeneinander1: TMenuItem;
    Ueberlappend: TMenuItem;
    Symboleanordnen1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Neu2: TMenuItem;
    Oeffnen2: TMenuItem;
    Test31: TMenuItem;
    Beenden2: TMenuItem;
    OpenFileDialog: TOpenDialog;
    N2: TMenuItem;
    Fenster2: TMenuItem;
    Nebeneinander2: TMenuItem;
    Ueberlappend1: TMenuItem;
    Symboleanordnen2: TMenuItem;
    Timer1: TTimer;
    LRSchnellschalter: TPanel;
    SpeedLaden: TSpeedButton;
    SpeedSpeichern: TSpeedButton;
    SpeedDrucken: TSpeedButton;
    SpeedNeuText: TSpeedButton;
    SpeedCut: TSpeedButton;
    SpeedKopieren: TSpeedButton;
    SpeedEinfuegen: TSpeedButton;
    SpeedEinstellungen: TSpeedButton;
    SpeedSchliessen: TSpeedButton;
    SpeedFonts: TSpeedButton;
    SpeedDateiManager: TSpeedButton;
    SpeedSuchen: TSpeedButton;
    SpeedErsetzen: TSpeedButton;
    ZeitDatum: TPanel;
    Tagesanzeige: TLabel;
    Datumsanzeige: TLabel;
    SpeedLoeschen: TSpeedButton;
    FindDialog1: TFindDialog;
    ReplaceDialog1: TReplaceDialog;
    Einstellungen: TMenuItem;
    GlobalEinstellungen: TMenuItem;
    History1: TMenuItem;
    Einstellungen1: TMenuItem;
    GlobaleEinstellungen1: TMenuItem;
    SpeedUndo: TSpeedButton;
    Alleoeffnen1: TMenuItem;
    Alleffnen1: TMenuItem;
    N4: TMenuItem;
    HistoryListe2: TMenuItem;
    N5: TMenuItem;
    HistoryListe3: TMenuItem;
    LRSchnellSchalter2: TPanel;
    FontNamen: TComboBox;
    FontGroesseUpDown1: TUpDown;
    FontGroesse: TEdit;
    SpeedFett: TSpeedButton;
    SpeedKursiv: TSpeedButton;
    SpeedUnter: TSpeedButton;
    SpeedLinks: TSpeedButton;
    SpeedMitte: TSpeedButton;
    SpeedRechts: TSpeedButton;
    SpeedPunkte: TSpeedButton;
    StatusBar1: TStatusBar;
    SpeedButtonHistory: TSpeedButton;
    Favoriten1: TMenuItem;
    HaeufigbenoetigteVerzeichnisse1: TMenuItem;
    N6: TMenuItem;
    AktuellesVerzeichnisentfernen1: TMenuItem;
    N8: TMenuItem;
    History2: TMenuItem;
    Favourites2: TMenuItem;
    AktuelleDateiinFavoritesaufnehmen1: TMenuItem;
    AktuelleDateiausFavoriteslschen1: TMenuItem;
    N9: TMenuItem;
    FavoritenListe1: TMenuItem;
    FavoritenListe2: TMenuItem;
    OpenPictureDialog1: TOpenPictureDialog;
    SpeedButtonOpenPicture: TSpeedButton;
    Hilfe1: TMenuItem;
    Help1: TMenuItem;
    N11: TMenuItem;
    berLittleRichard1: TMenuItem;
    WebTools1: TMenuItem;
    IExplorer1: TMenuItem;
    SpeedButtonWebBrowser: TSpeedButton;
    LRSchnellschalter3: TPanel;
    SpeedButtonHTMLBody: TSpeedButton;
    SpeedButtonHorline: TSpeedButton;
    SpeedButtonAbsatz: TSpeedButton;
    SpeedButtonKonvertiere: TSpeedButton;
    SpeedButtonAbsaetze: TSpeedButton;
    SpeedButtonLinks: TSpeedButton;
    Dateifilter1: TMenuItem;
    SpeedButtonTagselect: TSpeedButton;
    SpeedButtonRemoveTags: TSpeedButton;
    SpeedButtonBreak: TSpeedButton;
    SpeedButtonSyntax: TSpeedButton;
    Anwendungen1: TMenuItem;
    Anwendung1: TMenuItem;
    N7: TMenuItem;
    PopupMenuDatum: TPopupMenu;
    Kopieren1: TMenuItem;
    LetztenTextoeffnen1: TMenuItem;
    LetztenTextffnen2: TMenuItem;
    SpeedButtonNoframes: TSpeedButton;
    Druckertest1: TMenuItem;
    SpeedButtonSelLinks: TSpeedButton;
    SpeedButtonGrafik: TSpeedButton;
    SpeedButtonLink: TSpeedButton;
    SpeedButtonHeadline: TSpeedButton;
    SpeedSuchliste: TSpeedButton;
    SpeedButtonStringDialog: TSpeedButton;
    TimerSetup: TTimer;
    SpeedButtonRekonvertiere: TSpeedButton;
    SpeedButtonHTMLInsert: TSpeedButton;
    N3: TMenuItem;
    ExplorerTest1: TMenuItem;
    SpeedButtonFonttag: TSpeedButton;
    SpeedButtonAttrTag: TSpeedButton;
    SpeedButtonZiel: TSpeedButton;
    CheckBoxTagassStart: TCheckBox;
    procedure Beenden1Click(Sender: TObject);
    procedure Neu1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Nebeneinander1Click(Sender: TObject);
    procedure UeberlappendClick(Sender: TObject);
    procedure Symboleanordnen1Click(Sender: TObject);
    procedure Oeffnen1Click(Sender: TObject);
    procedure UeberLittleRichard1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedLadenClick(Sender: TObject);
    procedure SpeedSpeichernClick(Sender: TObject);
    procedure SpeedDruckenClick(Sender: TObject);
    procedure SpeedNeuTextClick(Sender: TObject);
    procedure SpeedCutClick(Sender: TObject);
    procedure SpeedKopierenClick(Sender: TObject);
    procedure SpeedEinfuegenClick(Sender: TObject);
    procedure TextOptButton1Click(Sender: TObject);
    procedure SpeedSchliessenClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedFontsClick(Sender: TObject);
    procedure Dateimanager1Click(Sender: TObject);
    procedure SpeedDateiManagerClick(Sender: TObject);
    procedure SpeedSuchenClick(Sender: TObject);
    procedure SpeedErsetzenClick(Sender: TObject);
    procedure SpeedLoeschenClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure StringSuchen(Sender: TObject);
    procedure StringTauschen(Sender: TObject);
    procedure SpeedHighlightClick(Sender: TObject);
    procedure DateiMenuEndeClick(Sender: TObject);
    procedure FavoritesClick(Sender: TObject);
    procedure GlobalEinstellungenClick(Sender: TObject);
    procedure HistoryListe1Click(Sender: TObject);
    procedure FontNamenChange(Sender: TObject);
    procedure FontGroesseChange(Sender: TObject);
    procedure SpeedFettClick(Sender: TObject);
    procedure SpeedKursivClick(Sender: TObject);
    procedure SpeedUnterClick(Sender: TObject);
    procedure SpeedAusrichten(Sender: TObject);
    procedure SpeedPunkteClick(Sender: TObject);
    procedure SpeedUndoClick(Sender: TObject);
    procedure Alleoeffnen1Click(Sender: TObject);
    procedure HistoryListe2Click(Sender: TObject);
    procedure Favoriten1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FavoritenListe1Click(Sender: TObject);
    procedure SpeedButtonOpenPictureClick(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure HTMLBrowser1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure IExplorer1Click(Sender: TObject);
    procedure SpeedButtonHTMLBodyClick(Sender: TObject);
    procedure SpeedButtonHorlineClick(Sender: TObject);
    procedure SpeedButtonAbsatzClick(Sender: TObject);
    procedure SpeedButtonKonvertiereClick(Sender: TObject);
    procedure SpeedButtonAbsaetzeClick(Sender: TObject);
    procedure SpeedButtonLinksClick(Sender: TObject);
    procedure Dateifilter1Click(Sender: TObject);
    procedure SpeedButtonTagselectClick(Sender: TObject);
    procedure SpeedButtonRemoveTagsClick(Sender: TObject);
    procedure SpeedButtonBreakClick(Sender: TObject);
    procedure SpeedButtonSyntaxClick(Sender: TObject);
    procedure Anwendungen1Click(Sender: TObject);
    procedure Anwendung1Click(Sender: TObject);
    procedure Kopieren1Click(Sender: TObject);
    procedure LetztenTextoeffnen1Click(Sender: TObject);
    procedure SpeedButtonNoframesClick(Sender: TObject);
    procedure Druckertest1Click(Sender: TObject);
    procedure SpeedButtonSelLinksClick(Sender: TObject);
    procedure SpeedButtonGrafikClick(Sender: TObject);
    procedure SpeedButtonLinkClick(Sender: TObject);
    procedure SpeedButtonHeadlineClick(Sender: TObject);
    procedure SpeedSuchlisteClick(Sender: TObject);
    procedure SpeedButtonStringDialogClick(Sender: TObject);
    procedure TimerSetupTimer(Sender: TObject);
    procedure SpeedButtonRekonvertiereClick(Sender: TObject);
    procedure SpeedButtonHTMLInsertClick(Sender: TObject);
    procedure ExplorerTest1Click(Sender: TObject);
    procedure SpeedButtonFonttagClick(Sender: TObject);
    procedure SpeedButtonAttrTagClick(Sender: TObject);
    procedure SpeedButtonZielClick(Sender: TObject);
    procedure CheckBoxTagassStartClick(Sender: TObject);
//    procedure Terminal1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    Zaehlvar: Integer;
    Initialisiert:  Boolean;
    Setup:          Boolean;
    strIExplore: String;
    FIExplorerInstalliert: BOOLEAN;

    function ExplorerTest: BOOLEAN;
    function LiesExplorer: BOOLEAN;
    function LiesZaehlVar: Integer;
    procedure UpdateStatusBar;
    procedure tausche (findpos: Integer; VAR endpos: Integer; von, nach: String; ST: TSearchTypes);
  public
    MyDateimanager: TDateimanagerForm;
    HistoryListe: TStringList;
    FavouriteListe: TStringList;
    AnwendungsListe: TStringList;
    Dateifilter: String;
    {HistoryListeAnzeigen: BOOLEAN;}
    DefaultFont: TFont;
    DefaultWindow: TWindowEinstellungen;
    Konfig:        TKonfiguration;
    FUpdating:     Boolean;
    Shutdown:      BOOLEAN;
    lastSave:      Integer;

    procedure AlleSchliessen;
    procedure DisplayHint (Sender: TObject);
    procedure SyntaxHighlight (Editor: TRichedit);
    procedure warte (ms: Integer);
    property IExplorerInstalliert: Boolean Read LiesExplorer;
    procedure doSaveKonfig;

  published
    property Zaehler: Integer Read LiesZaehlVar;
  end;

var
  LRFrame: TLRFrame;

Type
     TFontNam = String [32];
     TFontEinstellungen =
     RECORD
       col: TColor;
//       Nam: TFontName;
       Nam: TFontNam;
       Pit: TFontPitch;
       Siz: Integer;
       Styl: TFontStyles;
       Hei: Integer;
     END;

implementation

uses SLREdit, SGlobalEinstellungen, Bild, registry,
{$IFDEF Explorer}
  IExplorer,
{$ENDIF}
  HyperlinkForm,
  MyFmxUtils, Clipbrd, Printers, STexteinstellungen, JPEG, StringForm {, web, ftp, Mail, News,
  TermEinstell, LScripter};

{$R *.DFM}

procedure TLRFrame.warte (ms: Integer);
VAR Msg: TMsg;
begin
  Setup := TRUE;
  TimerSetup.Interval := ms; TimerSetup.Enabled := TRUE;
  while Setup DO
    while PeekMessage (Msg, 0, 0, 0, pm_Remove) do begin
      TranslateMessage (Msg);
      DispatchMessage (Msg);
    end (* while *);
  TimerSetup.Enabled := FALSE;
end (* warte *);

function TLRFrame.LiesZaehlVar: Integer;
begin
  INC (Zaehlvar);
  result := Zaehlvar;
end;

procedure TLRFrame.Beenden1Click(Sender: TObject);
begin
  Close;
end;


procedure TLRFrame.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  ShutDown := TRUE;
//  Timer1.Interval := 0;
end;

procedure TLRFrame.Nebeneinander1Click(Sender: TObject);
begin
  Tile;
end;

procedure TLRFrame.UeberlappendClick(Sender: TObject);
begin
  Cascade;
end;

procedure TLRFrame.Symboleanordnen1Click(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TLRFrame.Oeffnen1Click(Sender: TObject);
VAR mr: TModalResult;
begin
//showMessage ('DateiFilterIndex: ' + IntToStr (Konfig.DateiFilterIndex));
  WITH TDateiManagerForm.ECreate (Self, FALSE,
    'Textdatei laden', 'In Textfenster laden', '', '', Konfig.DateiFilterIndex,
    TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
//showMessage ('Oeffnen1Click TEditForm.Create ... ');
      Konfig.DateiFilterIndex := FilterIndex;
//showMessage ('DateiFilterIndex: ' + IntToStr (Konfig.DateiFilterIndex));
      WITH TEditForm.Create (Self) DO
        Open (Dateiauswahl);
//showMessage ('Oeffnen1Click TEditForm.Create fertig ');
    END (* IF mrOk *);
//showMessage ('Oeffnen1Click Release DateiManager');
    warte (300);
    Release;
  END (* WITH *);
end (* Oeffnen1Click *);

procedure TLRFrame.UeberLittleRichard1Click(Sender: TObject);
begin
  MessageDlg ('Little Richard ist ein Universaleditor fr Windows 95' +
               #13 + '(C) by Johannes Leckebusch 1996, 1997, 1998' +
               #13 + 'Freeware, Version ' + cVersion,
               mtInformation, [mbOk], 0);
end;

procedure TLRFrame.Timer1Timer(Sender: TObject);
VAR day: Integer;
    dayStr: String [10];
    i:      Integer;
begin
  Timer1.Interval := 1000;
  day := DayOfWeek (Date);
  CASE day OF
    1: dayStr := 'Sonntag';
    2: dayStr := 'Montag';
    3: dayStr := 'Dienstag';
    4: dayStr := 'Mittwoch';
    5: dayStr := 'Donnerstag';
    6: dayStr := 'Freitag';
    7: dayStr := 'Samstag';
  END (* CASE *);
  Tagesanzeige.Caption := dayStr;
  Datumsanzeige.Caption := DateToStr (Date) +
  '  ' + TimeToStr (Time) + 'h';
  INC (lastSave);
  IF (Konfig.saveIntervall <> 0) AND(lastSave >= Konfig.saveIntervall) THEN BEGIN
    lastSave := 0;
    FOR i := 0 TO MDIChildCount - 1 DO BEGIN
      IF MDIChildren [i] IS TEditForm THEN
        WITH MDIChildren [i] AS TEditForm DO
          IF AutoSave AND Editor.modified THEN Speichern1Click (Sender);
    END (* FOR *);
    IF Konfig.AutoSaveKonfig THEN
      doSaveKonfig;
  END (* IF time *);

  (* Anzeige Current-Dir aktualisieren: *)
  UpdateStatusBar;
end;

procedure TLRFrame.FormCreate(Sender: TObject);
VAR FontFile: File OF TFontEinstellungen;
    TextAttr: TFontEinstellungen;
    WindowFile: FILE OF TWindowEinstellungen;
    KonfigFile: FILE OF TKonfiguration;
    FilterFile: TextFile;
begin
  FIExplorerInstalliert := ExplorerTest;
{$IFDEF Explorer}
  SpeedButtonWebBrowser.Enabled := IExplorerInstalliert;
  IExplorer1.Enabled := IExplorerInstalliert;
{$ELSE}
  SpeedButtonWebBrowser.Visible := FALSE;
  IExplorer1.Visible := FALSE;
{$ENDIF}
  Caption := 'Special edition of Little Richard with Explorer ' + CVersion;
  Zaehlvar := 0; //DateiFilterIndex := LastFilterIndex;
  Application.ShowHint := TRUE;
  ParentShowHint := TRUE;
  Application.OnHint := DisplayHint;

  IF FileExists (ChangeFileExt (Application.Exename, '.WIN')) THEN BEGIN
    AssignFile (WindowFile, ChangeFileExt (Application.Exename, '.WIN'));
    Reset (WindowFile);
    Read (WindowFile, DefaultWindow);
    CloseFile (WindowFile);
    WITH DefaultWindow DO BEGIN
      IF NOT FrameWinDefault THEN BEGIN
        Position := FramePos; WindowState := FrameWin;
        Top := FrameTop; Left := FrameLeft; Height := FrameHeight; Width := FrameWidth;
      END (* IF NOT WinDefault *);
    END (* WITH *);
  END (* WindowFile *);

  IF FileExists (ChangeFileExt (Application.Exename, '.CFG')) THEN BEGIN
    AssignFile (KonfigFile, ChangeFileExt (Application.Exename, '.CFG'));
    Reset (KonfigFile);
    Read (KonfigFile, Konfig);
    CloseFile (KonfigFile);
    IF Konfig.ZeichenAufSeite = 0 THEN Konfig.ZeichenAufSeite := 1500;
//    DateiFilterIndex := Konfig.LastFilterIndex;
  END (* IF KonfigFile *)
  ELSE Konfig.ZeichenAufSeite := 1500;

  IF FileExists (ChangeFileExt (Application.Exename, '.FIL')) THEN BEGIN
    AssignFile (FilterFile, ChangeFileExt (Application.Exename, '.FIL'));
    Reset (FilterFile);
    Read (FilterFile, Dateifilter);
    CloseFile (FilterFile);
  END
  ELSE Dateifilter := '';

  HistoryListe := TStringList.Create;
  IF FileExists (ChangeFileExt (Application.Exename, '.HIS')) THEN BEGIN
    HistoryListe.LoadFromFile (ChangeFileExt (Application.Exename, '.HIS'));
  END (* IF *);

  FavouriteListe := TStringList.Create;
  FavouriteListe.Sorted := TRUE;
  IF FileExists (ChangeFileExt (Application.Exename, '.FAV')) THEN BEGIN
    FavouriteListe.LoadFromFile (ChangeFileExt (Application.Exename, '.FAV'));
  END (* IF *);

  AnwendungsListe := TStringList.Create;
//  AnwendungsListe.Sorted := TRUE;
  IF FileExists (ChangeFileExt (Application.Exename, '.ANW')) THEN BEGIN
    AnwendungsListe.LoadFromFile (ChangeFileExt (Application.Exename, '.ANW'));
  END (* IF *);

  IF Konfig.HistoryAnzeigen THEN
    Konfig.HistoryAnzeigen := TRUE
  ELSE Konfig.HistoryAnzeigen := FALSE;

  IF FileExists (ChangeFileExt (Application.Exename, '.FON')) THEN BEGIN
    DefaultFont := TFont.Create;
    AssignFile (FontFile, ChangeFileExt (Application.Exename, '.FON'));
    Reset (FontFile);
    Read (FontFile, TextAttr);
    CloseFile (FontFile);
    WITH DefaultFont, TextAttr DO BEGIN
      Color := col; Name := Nam; Pitch := Pit; Size := Siz; Style := Styl;
      Height := Hei;
    END (* WITH *);
    WITH DefaultFont DO BEGIN
      FontGroesse.Text := IntToStr (Size);
      FontNamen.Text := Name;
      SpeedFett.Down := fsBold in Style;
      SpeedKursiv.Down := fsItalic in Style;
      SpeedUnter.Down := fsUnderline in Style;
      {
      CASE ORD (Alignment) OF
        0: SpeedLinks.Down := TRUE;
        1: SpeedRechts.Down := TRUE;
        2: SpeedMitte.Down := TRUE;
      END (* CASE *);
      }
    END (* WITH *);
 END (* FontFile *);

end;

procedure TLRFrame.SpeedLadenClick(Sender: TObject);
begin
  Oeffnen1Click (Sender);
end;

procedure TLRFrame.SpeedSpeichernClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
      WITH ActiveMDIChild AS TEditForm DO Speichern1Click (Sender);
end;

procedure TLRFrame.SpeedDruckenClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Drucken1Click (Sender);
end;

procedure TLRFrame.Neu1Click(Sender: TObject);
begin
  TEditForm.Create (Self);
  lastSave := 0; //??? hm - lstig, wenn das sofort zuschlgt!
end;

procedure TLRFrame.SpeedNeuTextClick(Sender: TObject);
begin
  Neu1Click (Sender);
end;

procedure TLRFrame.SpeedCutClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Ausschneiden (Sender);
end;

procedure TLRFrame.SpeedKopierenClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Kopieren (Sender);
end;

procedure TLRFrame.SpeedEinfuegenClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Einfuegen (Sender);
end;

procedure TLRFrame.TextOptButton1Click(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO EditorEinstellungenClick (Sender);
end;

procedure TLRFrame.SpeedSchliessenClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN BEGIN
    ActiveMDIChild.Close;
  END;
end;

procedure TLRFrame.doSaveKonfig;
VAR    KonfigFile: FILE OF TKonfiguration;
       WindowFile: FILE OF TWindowEinstellungen;
begin
  HistoryListe.SaveToFile (ChangeFileExt (Application.ExeName, '.HIS'));
  FavouriteListe.SaveToFile (ChangeFileExt (Application.ExeName, '.FAV'));
  AnwendungsListe.SaveToFile (ChangeFileExt (Application.ExeName, '.ANW'));

  WITH DefaultWindow DO BEGIN
    FramePos := Position;
    FrameWin := WindowState;
    IF (WindowState <> wsMaximized) AND (NOT FrameWinDefault) THEN BEGIN
      FrameLeft := Left; FrameTop := Top; FrameHeight := Height; FrameWidth := Width;
    END (* IF *);
  END (* WITH *);
  AssignFile (WindowFile, ChangeFileExt (Application.Exename, '.WIN'));
  Rewrite (WindowFile);
  Write (WindowFile, DefaultWindow);
  CloseFile (WindowFile);

  AssignFile (KonfigFile, ChangeFileExt (Application.Exename, '.CFG'));
  Rewrite (KonfigFile);
  Write (KonfigFile, Konfig);
  CloseFile (KonfigFile);
end (* doSaveKonfig *);

procedure TLRFrame.FormDestroy(Sender: TObject);
begin
//  Timer1.Enabled := FALSE;
//  Timer1.Free;
  doSaveKonfig;
  HistoryListe.Free;
  FavouriteListe.Free;
  AnwendungsListe.Free;
end;

procedure TLRFrame.SpeedFontsClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Schriftart1Click (Sender);
end;

procedure TLRFrame.Dateimanager1Click(Sender: TObject);
begin
  IF MyDateiManager = NIL THEN
//    MyDateiManager := TDateiManagerForm.Create (Self);
    MyDateiManager := TDateiManagerForm.ECreate (Self, TRUE, 'Favoritenbrowser',
      '', '', '', Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE);
{  MyDateimanager.SelfDestroy := TRUE;
  MyDateimanager.Filterindex := Konfig.DateifilterIndex;
}
  MyDateimanager.Show;
end;

procedure TLRFrame.SpeedDateiManagerClick(Sender: TObject);
begin
  DateiManager1Click (Sender);
end;

procedure TLRFrame.SpeedSuchenClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Suchen1Click (Sender);
end;

procedure TLRFrame.SpeedErsetzenClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Ersetzen1Click (Sender);
end;

procedure TLRFrame.SpeedLoeschenClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO Loeschen (Sender);
end;

FUNCTION getPathname (CONST s: STRING): STRING;
VAR i:      Integer;
    count:  Integer;
    res:    String;
BEGIN
  i := 1; count := 0;
  WHILE (i <= Length (s)) AND (count < 2) DO BEGIN
    IF s [i] = '"' THEN INC (count);
    INC (i);
  END (* WHILE *);
  INC (i);
  res := Copy (s, i, Length (s) - i + 1);
  Result := res;
END (* getPathname *);

procedure TLRFrame.FormActivate(Sender: TObject);
VAR Datei:     String;
    command:   pChar;
    Ext:       String;
    urlstr:    String;
begin
  IF Initialisiert THEN Exit;
//showMessage ('FormActivate');
  command := GetCommandLine;
  {showMessage (command);}
  Datei := getPathname (command);
  {showMessage (Datei);}
  IF Datei <> '' THEN BEGIN
    Ext := Uppercase (ExtractFileExt (Datei));
{    IF Pos ('HTM', Ext) > 0 THEN BEGIN
      Hypertext := TWebBrowser.Create (Self);
      urlstr := Datei;
      IF (Length (urlstr) > 2) AND (urlstr [2] = ':') THEN
        urlstr [2] := '|';
      Hypertext.HTML1.RequestDoc ('file:///' + urlstr);
      Hypertext.Statusbar1.Panels[0].Text := Hypertext.HTML1.RequestURL;
      Hypertext.BringToFront;
    END
}
{    ELSE IF Pos ('SCR', Ext) > 0 THEN BEGIN
     IF Terminal = NIL THEN Terminal := TLRTerm.Create (Self)
     ELSE Terminal.Show;
     LScriptForm.Open (Datei);
     LScriptForm.SpeedButtonScriptRunClick(NIL);
    END
}
    {ELSE}
    WITH TEditForm.Create (Self) DO
      Open (Datei);
  END;
{  IF Konfig.TerminalStart THEN BEGIN
    IF Terminal = NIL THEN Terminal := TLRTerm.Create (Self)
    ELSE Terminal.Show;
  END;
}

  (* Erst hier, zuvor FALSE, sonst stimmt bei Vollbildanzeige das
     Koordinatensystem nicht - Ursache unklar: *)
  LRSchnellSchalter.Visible := Konfig.SchaltleisteAnzeigen;
  LRSchnellSchalter2.Visible := Konfig.Schaltleiste2Anzeigen;
  LRSchnellSchalter3.Visible := Konfig.Schaltleiste3Anzeigen;
  StatusBar1.Visible := Konfig.StatusLeiste;

  IF Konfig.AusHistoryLaden THEN
    AlleOeffnen1Click (Self)
  ELSE IF Konfig.LetztenLaden THEN
    LetztenTextoeffnen1Click (Self);
  Initialisiert := TRUE;
end;

procedure TLRFrame.StringTauschen(Sender: TObject);
CONST i: Integer = 0;
begin
  WITH Sender AS TReplaceDialog DO
//      IF frWholeWord IN Options THEN ST := [stWholeWord];
//      IF frMatchCase IN Options THEN ST := ST + [stMatchCase];
    WHILE True DO BEGIN
      WITH ActiveMDICHild AS TEditForm DO BEGIN
        IF Editor.SelText <> FindText THEN
          StringSuchen(Sender);
        IF Editor.SelLength = 0 THEN Break;
        Editor.SelText := ReplaceText; INC (i);
        IF NOT (frReplaceAll IN Options) THEN Break;
      END (* WITH ActiveMDIChild *);
    END (* WHILE *);
    ShowMessage (IntToStr (i) + ' Vorkommen von "' + ReplaceDialog1.FindText +
                 '" durch "' + ReplaceDialog1.ReplaceText + '" ersetzt.');
end;

procedure TLRFrame.StringSuchen(Sender: TObject);
VAR
  ST:    TSearchTypes;
  Rslt:  Integer;
begin
  IF ActiveMDIChild = NIL THEN EXIT;
  ST := [];
  WITH Sender AS TFindDialog DO BEGIN
      IF frWholeWord IN Options THEN ST := [stWholeWord];
      IF frMatchCase IN Options THEN ST := ST + [stMatchCase];
      IF ActiveMDIChild IS TEditForm THEN
        WITH ActiveMDIChild AS TEditForm DO BEGIN
          Rslt := Editor.FindText(FindText, Editor.SelStart +
            Editor.SelLength, Editor.GetTextLen, ST);
          IF Rslt > -1 THEN
            BEGIN
              Editor.SelStart := Rslt;
              Editor.SelLength := Length(FindText);
            END
          ELSE BEGIN
            IF NOT (Sender IS TReplaceDialog) THEN
              ShowMessage ('Suchbegriff "' + FindDialog1.FindText +
              '" nicht gefunden!');
          END (* ELSE *);
        END (* WITH ActiveMDIChild *);
      (*CloseDialog;*)
    END (* WITH *);
end;

procedure TLRFrame.SpeedHighlightClick(Sender: TObject);
VAR ST:           TSearchTypes;
    Rslt1, Rslt2: Integer;
begin
  IF ActiveMDIChild = NIL THEN EXIT;
  ST := [];
  IF ActiveMDIChild IS TEditForm THEN
  WITH ActiveMDIChild AS TEditForm DO BEGIN
    Editor.SelStart := 0; Editor.HideSelection := TRUE; {Editor.Color := clSilver;}
    Rslt1 := 0; Rslt2 := 0;
    REPEAT
      Rslt1 := Editor.FindText ('/', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
      IF Rslt1 > -1 THEN BEGIN
        Editor.SelStart := Rslt1; Editor.SelLength := 1;
        Rslt2 := Editor.FindText ('/', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
        IF Rslt2 > -1 THEN BEGIN
          Editor.SelStart := Rslt1 + 1;
          Editor.SelLength := Rslt2 - Rslt1 - 1;
          WITH Editor.SelAttributes DO BEGIN
            Style := [fsItalic];
          END (* WITH *);
        END (* Rslt2 *);
      END (* IF Rslt1 *);
    UNTIL (Rslt1 = -1) OR (Rslt2 = -1);

    Editor.SelStart := 0;
    REPEAT
      Rslt1 := Editor.FindText ('*', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
      IF Rslt1 > -1 THEN BEGIN
        Editor.SelStart := Rslt1; Editor.SelLength := 1;
        Rslt2 := Editor.FindText ('*', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
        IF Rslt2 > -1 THEN BEGIN
          Editor.SelStart := Rslt1 + 1;
          Editor.SelLength := Rslt2 - Rslt1 - 1;
          WITH Editor.SelAttributes DO BEGIN
            Style := [fsBold];
          END (* WITH *);
        END (* Rslt2 *);
      END (* IF Rslt1 *);
    UNTIL (Rslt1 = -1) OR (Rslt2 = -1);

    Editor.SelStart := 0;
    REPEAT
      Rslt1 := Editor.FindText ('_', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
      IF Rslt1 > -1 THEN BEGIN
        Editor.SelStart := Rslt1; Editor.SelLength := 1;
        Rslt2 := Editor.FindText ('_', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
        IF Rslt2 > -1 THEN BEGIN
          Editor.SelStart := Rslt1 + 1;
          Editor.SelLength := Rslt2 - Rslt1 - 1;
          WITH Editor.SelAttributes DO BEGIN
            Style := [fsUnderline];
          END (* WITH *);
        END (* Rslt2 *);
      END (* IF Rslt1 *);
    UNTIL (Rslt1 = -1) OR (Rslt2 = -1);

    Editor.SelStart := 0;
    REPEAT
      Rslt1 := Editor.FindText ('=', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
      IF Rslt1 > -1 THEN BEGIN
        Editor.SelStart := Rslt1; Editor.SelLength := 1;
        Rslt2 := Editor.FindText ('=', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
        IF Rslt2 > -1 THEN BEGIN
          Editor.SelStart := Rslt1 + 1;
          Editor.SelLength := Rslt2 - Rslt1 - 1;
          WITH Editor.SelAttributes DO BEGIN
            Style := [fsUnderline, fsBold];
          END (* WITH *);
        END (* Rslt2 *);
      END (* IF Rslt1 *);
    UNTIL (Rslt1 = -1) OR (Rslt2 = -1);

    Editor.SelStart := 0;
    REPEAT
      Rslt1 := Editor.FindText ('>', Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
      IF Rslt1 > -1 THEN BEGIN
        Editor.SelStart := Rslt1; Editor.SelLength := 1;
        Rslt2 := Editor.FindText (#13, Editor.SelStart + Editor.SelLength,
                                Editor.GetTextLen, ST);
        IF Rslt2 > -1 THEN BEGIN
          Editor.SelStart := Rslt1 + 1;
          Editor.SelLength := Rslt2 - Rslt1 - 1;
          WITH Editor.SelAttributes DO BEGIN
            Color := clBlue;
          END (* WITH *);
        END (* Rslt2 *);
      END (* IF Rslt1 *);
    UNTIL (Rslt1 = -1) OR (Rslt2 = -1);

    Editor.SelLength := 0; Editor.SelStart := 0; Editor.HideSelection := FALSE;
  END (* WITH *);
end;

procedure TLRFrame.DateiMenuEndeClick(Sender: TObject);
begin
  WITH Sender AS TMenuItem DO
    IF NOT FileExists (Caption) THEN BEGIN
      ShowMessage ('Die Datei "' + Caption + '" ist nicht vorhanden!');
      Exit;
    END (* IF *);

  WITH TEditForm.Create (Self) DO
    WITH Sender AS TMenuItem DO
      Open (Caption);
end;

procedure TLRFrame.HistoryListe1Click(Sender: TObject);
VAR i: Integer;
    menitem: TMenuItem;
CONST cBreak =  30;
begin
{  i := History1.Count;
  WHILE (History1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); History1.Delete (i);
  END (* WHILE *);


  i := History2.Count;
  WHILE (History2.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); History2.Delete (i);
  END (* WHILE *);

  FOR i := 0 TO HistoryListe.Count - 1 DO BEGIN

    IF (i + 1) MOD cBreak = 0 THEN BEGIN
      menitem := TMenuItem.Create (PopupMenu1);
      menitem.break := mbBarBreak;
      History2.Add (menitem);
      menitem := TMenuItem.Create (FrameMenu);
      menitem.break := mbBarBreak;
      History1.Add (menitem);
    END (* IF *);

    menitem := TMenuItem.Create (PopupMenu1);
    WITH menitem DO BEGIN
      Caption := HistoryListe.Strings [i];
      OnClick := DateiMenuEndeClick;
    END (* WITH *);
    History1.Add (menitem);

    menitem := TMenuItem.Create (FrameMenu);
    WITH menitem DO BEGIN
      Caption := HistoryListe.Strings [i];
      OnClick := DateiMenuEndeClick;
    END (* WITH *);
    History2.Add (menitem);
  END (* FOR *);
}  
end (* HistoryListe1Click *);

procedure TLRFrame.GlobalEinstellungenClick(Sender: TObject);
begin
  IF AllgEinstellDialog = NIL THEN
    AllgEinstellDialog := TAllgEinstellDialog.Create (Self)
  ELSE BEGIN
    AllgEinstellDialog.Visible := TRUE;
    AllgEinstellDialog.BringToFront;
  END;
end;

procedure TLRFrame.AlleSchliessen;
VAR i: Integer;
BEGIN
  FOR i := 0 TO MDIChildCount -1 DO BEGIN
    WITH MDIChildren [i] AS TEditForm DO
      Schliessen1Click (MDIChildren [0]);
  END (* WHILE *);
END (* AlleSchliessen *);

procedure TLRFrame.DisplayHint (Sender: TObject);
begin
//  Statusbar1.SimpleText := GetLongHint (Application.Hint);
  IF GetLongHint (Application.Hint) = '' THEN
    Statusbar1.Panels [0].Text := 'Mauszeiger auf Men oder Button'
  ELSE
    Statusbar1.Panels [0].Text := GetLongHint (Application.Hint);
end (* DisplayHint *);

procedure TLRFrame.FontNamenChange(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
  IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      IF FUpdating OR (SelectedText = NIL) THEN EXIT;
      SelectedText.Name := FontNamen.Items [FontNamen.ItemIndex];
      Editor.Modified := TRUE; CursorDaten (Sender);
    END (* WITH *);
end;

procedure TLRFrame.FontGroesseChange(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
    IF ActiveMDIChild IS TEditForm THEN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      IF FUpdating OR (SelectedText = NIL) THEN EXIT;
      SelectedText.Size := StrToInt (FontGroesse.Text);
      Editor.Modified := TRUE; CursorDaten (Sender);
    END (* WITH *);
end;

procedure TLRFrame.SpeedFettClick(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
    IF ActiveMDIChild IS TEditForm THEN
  WITH ActiveMDIChild AS TEditForm DO BEGIN
    IF FUpdating OR (SelectedText = NIL) THEN EXIT;
    IF SpeedFett.Down THEN
      SelectedText.Style := SelectedText.Style + [fsBold]
    ELSE
      SelectedText.Style := SelectedText.Style - [fsBold];
    Editor.Modified := TRUE; CursorDaten (Sender);
  END (* WITH *);
end;

procedure TLRFrame.SpeedKursivClick(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
    IF ActiveMDIChild IS TEditForm THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF FUpdating OR (SelectedText = NIL) THEN EXIT;
        IF SpeedKursiv.Down THEN
          SelectedText.Style := SelectedText.Style + [fsItalic]
        ELSE
          SelectedText.Style := SelectedText.Style - [fsItalic];
        Editor.Modified := TRUE; CursorDaten (Sender);
      END (* WITH *);
end;

procedure TLRFrame.SpeedUnterClick(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
    IF ActiveMDIChild IS TEditForm THEN
  WITH ActiveMDIChild AS TEditForm DO BEGIN
    IF FUpdating OR (SelectedText = NIL) THEN EXIT;
    IF SpeedUnter.Down THEN
      SelectedText.Style := SelectedText.Style + [fsUnderline]
    ELSE
      SelectedText.Style := SelectedText.Style - [fsUnderline];
    Editor.Modified := TRUE; CursorDaten (Sender);
  END (* WITH *);
end;

procedure TLRFrame.SpeedAusrichten(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
    IF ActiveMDIChild IS TEditForm THEN
  WITH ActiveMDIChild AS TEditForm DO BEGIN
    IF FUpdating THEN EXIT;
    Editor.Paragraph.Alignment := TALignment (TControl (Sender).Tag);
    Editor.Modified := TRUE; CursorDaten (Sender);
  END (* WITH *);
end;

procedure TLRFrame.SpeedPunkteClick(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
    IF ActiveMDIChild IS TEditForm THEN
  WITH ActiveMDIChild AS TEditForm DO BEGIN
    IF FUpdating THEN EXIT;
    Editor.Paragraph.Numbering := TNumberingStyle (SpeedPunkte.Down);
    Editor.Modified := TRUE; CursorDaten (Sender);
  END (* WITH *);
end;

procedure TLRFrame.SpeedUndoClick(Sender: TObject);
begin
  IF ActiveMDIChild = NIL THEN EXIT;
    IF ActiveMDIChild IS TEditForm THEN
  WITH ActiveMDIChild AS TEditForm DO BEGIN
    Rueckgaengig1.Click;
  END (* WITH *);
end;

procedure TLRFrame.Alleoeffnen1Click(Sender: TObject);
VAR i: Integer;
begin
  i := 0;
  WHILE (i < HistoryListe.Count) AND (i < Konfig.LastHistory) DO BEGIN
      IF FileExists (HistoryListe.Strings [i]) THEN BEGIN
        WITH TEditForm.Create (Self) DO
          Open (HistoryListe.Strings [i]);
        INC (i);
      END (* IF *)
      ELSE BEGIN
        ShowMessage ('Die Datei "' + HistoryListe.Strings [i] + '" ist nicht vorhanden');
        HistoryListe.Delete (i);
      END (* ELSE *);
  END (* FOR *);
end;

procedure TLRFrame.HistoryListe2Click(Sender: TObject);
VAR History: TEditform;
begin
  History := TEditForm.Create (Self);
  WITH History, History.Editor DO BEGIN
    PfadName := ChangeFileExt (Application.ExeName, '.his');
    Caption := PfadName;
    Lines := HistoryListe;
    Modified := FALSE;
    SendMessage(Editor.Handle, EM_ScrollCaret, 0, 0);
  END (* WITH *);
end;

procedure TLRFrame.FavoritesClick (Sender: TObject);
VAR FavFilter: String;
    FavStart, FavEnd: Integer;
    FavStr:    String;
begin
  WITH Sender AS TMenuItem DO BEGIN
    OpenFileDialog.Title := 'Textdatei ffnen';
    OpenFileDialog.FileName := '';
    OpenFileDialog.InitialDir := ExtractFilePath (Caption);
    FavStr := FavouriteListe [MenuIndex - 3];
    FavStart := Pos ('/', FavStr);
    FavEnd := Pos ('#', FavStr);
    IF FavStart > 0 THEN
      FavFilter := Copy (FavStr, FavStart + 1, FavStart - FavEnd)
    ELSE FavFilter := DateiFilter;
//showMessage ('Fav: ' + FavStr + ', FS: ' + IntToStr (FavStart) + ', FE: ' + IntToStr (FavEnd));
    IF Favfilter <> '' THEN OpenFileDialog.Filter := Favfilter;
    IF FavEnd > 0 THEN
      OpenFileDialog.FilterIndex := StrToInt (Copy (FavStr, FavEnd + 1, Length (FavStr)))
    ELSE OpenFileDialog.FilterIndex := Konfig.DateiFilterIndex;
    IF OpenFileDialog.Execute THEN BEGIN
      Konfig.DateiFilterIndex := OpenFileDialog.FilterIndex;
      WITH TEditForm.Create (Self) DO
        Open (OpenFileDialog.FileName);
    END (* IF *);
  END (* WITH *);
END (* FavoritesClick *);

procedure TLRFrame.Favoriten1Click(Sender: TObject);
VAR i: Integer;
    menitem: TMenuItem;
begin
  i := Favoriten1.Count;
  WHILE (Favoriten1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Favoriten1.Delete (i);
  END (* WHILE *);

  i := Favourites2.Count;
  WHILE (Favourites2.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Favourites2.Delete (i);
  END (* WHILE *);

  FOR i := 0 TO FavouriteListe.Count - 1 DO BEGIN
    menitem := TMenuItem.Create (PopupMenu1);
    WITH menitem DO BEGIN
//      Caption := FavoriteListe.Strings [i];
      Caption := Copy (FavouriteListe.Strings [i], 1, Pos ('/', FavouriteListe.Strings [i]) - 1);
      OnClick := FavoritesClick;
    END (* WITH *);
    Favoriten1.Add (menitem);

    menitem := TMenuItem.Create (FrameMenu);
    WITH menitem DO BEGIN
//      Caption := FavoriteListe.Strings [i];
      Caption := Copy (FavouriteListe.Strings [i], 1, Pos ('/', FavouriteListe.Strings [i]) - 1);
      OnClick := FavoritesClick;
    END (* WITH *);
    Favourites2.Add (menitem);
  END (* FOR *);
end;

procedure TLRFrame.UpdateStatusBar;
CONST  K = $400;
       M = $100000;
       G = $40000000;
VAR status1, freesuff, sizesuff: String;
    dsksize, dskfree: Integer;
begin
  dskfree := Diskfree (0); dsksize := Disksize (0);

  IF dskfree < K THEN
     freesuff := Format ('%d Byte', [dskfree])
  ELSE IF dskfree < M THEN
     freesuff := Format ('%n KB', [dskfree / K])
  ELSE IF dskfree < G THEN
     freesuff := Format ('%n MB', [dskfree / M])
  ELSE
     freesuff := Format ('%n GB', [dskfree / G]);

  IF dsksize < K THEN
     sizesuff := Format ('%d Byte', [dsksize])
  ELSE IF dsksize < M THEN
     sizesuff := Format ('%n KB', [dsksize / K])
  ELSE IF dsksize < G THEN
     sizesuff := Format ('%n MB', [dsksize / M])
  ELSE
     sizesuff := Format ('%n GB', [dsksize / G]);

  status1 := 'CurDir: ' + GetCurrentDir + ', frei: ' + freesuff +
              ', ges: ' + sizesuff;
  IF Statusbar1 <> NIL THEN Statusbar1.Panels [1].Text := status1;
//Exit;
end (* UpdateStatusBar *);

procedure TLRFrame.FormShow(Sender: TObject);
begin
//showMessage ('FormShow');
  UpdateStatusBar;
{  showMessage (IntToStr (GetComCtlVersion) + ': IE3 = ' + IntToStr (ComCtlVersionIE3) +
    ', IE4: ' + IntToStr (ComCtlVersionIE4));}
end;

procedure TLRFrame.FavoritenListe1Click(Sender: TObject);
VAR Favorites: TEditform;
begin
  Favorites := TEditForm.Create (Self);
  WITH Favorites, Favorites.Editor DO BEGIN
    PfadName := ChangeFileExt (Application.ExeName, '.fav');
    Caption := PfadName;
    Lines := FavouriteListe;
    Modified := FALSE;
    SendMessage(Editor.Handle, EM_ScrollCaret, 0, 0);
  END (* WITH *);
end;

procedure TLRFrame.SpeedButtonOpenPictureClick(Sender: TObject);
begin
  OpenPictureDialog1.DefaultExt := GraphicExtension (TJPEGImage);
  OpenPictureDialog1.Filter := GraphicFilter (TGraphic);
  IF OpenPictureDialog1.Execute THEN BEGIN
    WITH TBildForm.Create (Self) DO BEGIN
      Image1.Picture.LoadFromFile (OpenPictureDialog1.FileName);
      Caption := OpenPictureDialog1.FileName;
//      Height := Image1.Picture.Height + 27;
//      Width := Image1.Picture.Width + 8;
      HorzScrollBar.Range := Image1.Picture.Width;
      VertScrollBar.Range := Image1.Picture.Height;
      Show;
    END (* WITH *);
  END (* IF *);
end;

procedure TLRFrame.Help1Click(Sender: TObject);
begin
  showMessage ('Sorry - eine richtige Hilfe-Funktion gibt es noch nicht.');
end;

procedure TLRFrame.HTMLBrowser1Click(Sender: TObject);
begin
//  TWebBrowser.Create (Self);
end;

procedure TLRFrame.Button1Click(Sender: TObject);
begin
  LRFrame.Close;
end;

procedure TLRFrame.IExplorer1Click(Sender: TObject);
begin
{$IFDEF Explorer}
  TIExplorerForm.Create (Self);
{$ENDIF}  
end;

const cr = #13#10;

procedure TLRFrame.SpeedButtonHTMLBodyClick(Sender: TObject);
begin
  Neu1Click (Sender);
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      Editor.SelText := '<html>' + cr +
                        '<!-- Diese Seite wurde vom SLRE erzeugt -->' + cr +
                        '<head>' + cr +
                        '<title>Seitentitel einf&uuml;gen</title>' + cr +
                        '<meta name="Author" content="Johannes Leckebusch">' + cr +
                        '</head>' + cr +
                        '<body bgcolor="#FFFFFF">' + cr +
                        'Text der Seite einf&uuml;gen' + cr +
                        '</body>' + cr +
                        '</html>';
      Editor.SelStart := 0;
    END (* WITH *);
  END (* IF *);
  Timer1.Enabled := FALSE;
  SpeedButtonSelLinksClick (Sender);
  Timer1.Enabled := TRUE;
end;

procedure TLRFrame.SpeedButtonHorlineClick(Sender: TObject);
VAR  start:       Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        start := Editor.SelStart;
        SelText := '<hr>' + cr;
        Editor.SelStart := start;
//        SelAttributes.Style := [fsbold];
//        SelAttributes.Color := clMaroon;
      END (* WITH Editor *);
    END (* WITH *);
    IF CheckBoxTagassStart.checked THEN SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.SpeedButtonAbsatzClick(Sender: TObject);
VAR start: Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<p>' + Editor.SelText +
                        '</p>' + cr;
      Editor.SelStart := start;
    END (* WITH *);
    IF CheckBoxTagassStart.checked THEN SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.tausche (findpos: Integer; VAR endpos: Integer; von, nach: String; ST: TSearchTypes);
VAR offset, startpos: Integer;
begin
  offset := Length (nach) - Length (von);
  startpos := findpos;
  WITH ActiveMDIChild AS TEditForm DO BEGIN
    WITH Editor DO BEGIN
      WHILE (findpos > -1) AND (findpos < endpos) DO BEGIN
        findpos := FindText (von, findpos, endpos - startpos, ST);
        IF (findpos > -1) AND (findpos < endpos) THEN BEGIN
          SelStart := findpos;
          SelLength := Length (von);
          SelText := nach;
          findpos := SelStart + SelLength;
          INC (endpos, offset);
        END (* IF *);
      END (* WHILE *);
    END (* WITH Editor *);
  END (* WITH *);
end (* tausche *);


procedure TLRFrame.SpeedButtonKonvertiereClick(Sender: TObject);
VAR  ST: TSearchTypes;
     findpos:  Integer;
     endpos:   Integer;

begin
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      ST := [stMatchCase];
      WITH Editor DO BEGIN
        IF SelLength > 0 THEN BEGIN
          findpos := SelStart; endpos := SelStart + SelLength;
        END
        ELSE BEGIN
          findpos := 0; endpos := getTextLen;
        END;
        dontShow := TRUE;
        Visible := FALSE;
        Enabled := FALSE;
      END (* WITH Editor *);
      tausche (findpos, endpos, #160, '&nbsp;', ST);
      tausche (findpos, endpos, '', '&iexcl;', ST);
      tausche (findpos, endpos, '', '&cent;', ST);
      tausche (findpos, endpos, '', '&pound;', ST);
      tausche (findpos, endpos, '', '&curren;', ST);
      tausche (findpos, endpos, '', '&yen;', ST);
      tausche (findpos, endpos, '', '&brvbar;', ST);
      tausche (findpos, endpos, '', '&sect;', ST);
      tausche (findpos, endpos, '', '&uml;', ST);
      tausche (findpos, endpos, '', '&copy;', ST);
      tausche (findpos, endpos, '', '&ordf;', ST);
      tausche (findpos, endpos, '', '&laquo;', ST);
      tausche (findpos, endpos, '', '&not;', ST);
      tausche (findpos, endpos, '', '&shy;', ST);
      tausche (findpos, endpos, '', '&reg;', ST);
      tausche (findpos, endpos, '', '&macr;', ST);
      tausche (findpos, endpos, '', '&deg;', ST);
      tausche (findpos, endpos, '', '&plusmn;', ST);
      tausche (findpos, endpos, '', '&sup2;', ST);
      tausche (findpos, endpos, '', '&sup3;', ST);
      tausche (findpos, endpos, '', '&acute;', ST);
      tausche (findpos, endpos, '', '&micro;', ST);
      tausche (findpos, endpos, '', '&para;', ST);
      tausche (findpos, endpos, '', '&middot;', ST);
      tausche (findpos, endpos, '', '&cedil;', ST);
      tausche (findpos, endpos, '', '&sup1;', ST);
      tausche (findpos, endpos, '', '&ordm;', ST);
      tausche (findpos, endpos, '', '&raquo;', ST);
      tausche (findpos, endpos, '', '&frac14;', ST);
      tausche (findpos, endpos, '', '&frac12;', ST);
      tausche (findpos, endpos, '', '&frac34;', ST);
      tausche (findpos, endpos, '', '&iquest;', ST);
      tausche (findpos, endpos, '', '&Agrave;', ST);
      tausche (findpos, endpos, '', '&Aacute;', ST);
      tausche (findpos, endpos, '', '&Acirc;', ST);
      tausche (findpos, endpos, '', '&Atilde;', ST);
      tausche (findpos, endpos, '', '&Auml;', ST);
      tausche (findpos, endpos, '', '&Aring;', ST);
      tausche (findpos, endpos, '', '&Aelig;', ST);
      tausche (findpos, endpos, '', '&Ccedil;', ST);

      tausche (findpos, endpos, '', '&Egrave;', ST);
      tausche (findpos, endpos, '', '&Eacute;', ST);
      tausche (findpos, endpos, '', '&Ecirc;', ST);
      tausche (findpos, endpos, '', '&Euml;', ST);
      tausche (findpos, endpos, '', '&Igrave;', ST);
      tausche (findpos, endpos, '', '&Iacute;', ST);
      tausche (findpos, endpos, '', '&Icirc;', ST);
      tausche (findpos, endpos, '', '&Iuml;', ST);
      tausche (findpos, endpos, '', '&ETH;', ST);
      tausche (findpos, endpos, '', '&Ntilde;', ST);
      tausche (findpos, endpos, '', '&Ograve;', ST);
      tausche (findpos, endpos, '', '&Oacute;', ST);
      tausche (findpos, endpos, '', '&Ocirc;', ST);
      tausche (findpos, endpos, '', '&Otilde;', ST);
      tausche (findpos, endpos, '', '&Ouml;', ST);
      tausche (findpos, endpos, '', '&times;', ST);
      tausche (findpos, endpos, '', '&Oslash;', ST);
      tausche (findpos, endpos, '', '&Ugrave;', ST);
      tausche (findpos, endpos, '', '&Uacute;', ST);
      tausche (findpos, endpos, '', '&Ucirc;', ST);
      tausche (findpos, endpos, '', '&Uuml;', ST);
      tausche (findpos, endpos, '', '&Yacute;', ST);
      tausche (findpos, endpos, '', '&THORN;', ST);
      tausche (findpos, endpos, '', '&szlig;', ST);
      tausche (findpos, endpos, '', '&agrave;', ST);
      tausche (findpos, endpos, '', '&aacute;', ST);
      tausche (findpos, endpos, '', '&acirc;', ST);
      tausche (findpos, endpos, '', '&atilde;', ST);
      tausche (findpos, endpos, '', '&auml;', ST);
      tausche (findpos, endpos, '', '&aring;', ST);
      tausche (findpos, endpos, '', '&aelig;', ST);
      tausche (findpos, endpos, '', '&ccedil;', ST);
      tausche (findpos, endpos, '', '&egrave;', ST);
      tausche (findpos, endpos, '', '&eacute;', ST);
      tausche (findpos, endpos, '', '&ecirc;', ST);
      tausche (findpos, endpos, '', '&euml;', ST);
      tausche (findpos, endpos, '', '&igrave;', ST);
      tausche (findpos, endpos, '', '&iacute;', ST);
      tausche (findpos, endpos, '', '&icirc;', ST);
      tausche (findpos, endpos, '', '&iuml;', ST);
      tausche (findpos, endpos, '', '&eth;', ST);
      tausche (findpos, endpos, '', '&ntilde;', ST);
      tausche (findpos, endpos, '', '&ograve;', ST);
      tausche (findpos, endpos, '', '&oacute;', ST);
      tausche (findpos, endpos, '', '&ocirc;', ST);
      tausche (findpos, endpos, '', '&tilde;', ST);
      tausche (findpos, endpos, '', '&ouml;', ST);
      tausche (findpos, endpos, '', '&divide;', ST);
      tausche (findpos, endpos, '', '&oslash;', ST);
      tausche (findpos, endpos, '', '&ugrave;', ST);
      tausche (findpos, endpos, '', '&uacute;', ST);
      tausche (findpos, endpos, '', '&ucirc;', ST);
      tausche (findpos, endpos, '', '&uuml;', ST);
      tausche (findpos, endpos, '', '&yacute;', ST);
      tausche (findpos, endpos, '', '&thorn;', ST);
      tausche (findpos, endpos, '', '&yuml;', ST);


      WITH Editor DO BEGIN
        dontShow := FALSE;
        Visible := TRUE;
        Enabled := TRUE;
      END (* WITH Editor *);
    END (* WITH *);
  END (* IF gltiger Text *);
end;

procedure TLRFrame.SpeedButtonAbsaetzeClick(Sender: TObject);
VAR  ST:              TSearchTypes;
     start, ende:     Integer;

  procedure tausche (von, nach: String);
  VAR findpos:  Integer;
  begin
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        findpos := start;
        WHILE findpos < ende DO BEGIN
          SelStart := findpos; SelLength := 0; SelText := '<p>';
          findpos := FindText (von, findpos, ende, ST);
          IF findpos > -1 THEN BEGIN
            SelStart := findpos;
            SelLength := Length (von);
            SelText := nach;
            findpos := SelStart + SelLength + 2;
          END (* IF *)
          ELSE break;
        END (* WHILE *);
      END (* WITH Editor *);
    END (* WITH *);
  end (* tausche *);

begin (* SpeedButtonAbsaetzeClick *)
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN BEGIN
    ST := [stMatchCase];
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        start := SelStart; ende := SelStart + SelLength;
      END (* WITH Editor *);
    END (* WITH ActiveMDIChild *);
    tausche (#10, #10 + '</p>');
  END (* IF gltiger Text *);
end;

procedure TLRFrame.SpeedButtonLinksClick(Sender: TObject);
VAR  mr:            TModalResult;
begin
  IF ActiveMDIChild IS TEditForm THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      SetCurrentDir (ExtractFileDir (Pfadname));
      IF Tagassistent <> NIL THEN Tagassistent.Show
      ELSE BEGIN
        Tagassistent := THyperLinkForm1.Create (Self.ActiveMDIChild);
        WITH Tagassistent AS THyperlinkForm1 DO BEGIN
          Caption := Self.ActiveMDIChild.Caption;
          Show;
//          MeinEditor := Self.ActiveMDIChild AS TEditForm;
{          mr := ShowModal;
          IF mr = mrOK THEN BEGIN
            Editor.SelText := EditSelected.Text;
          END (* IF *);
          Release;}
        END (* WITH *);
      END (* ELSE *);
    END (* WITH *);
  END (* IF *);
end;

procedure TLRFrame.Dateifilter1Click(Sender: TObject);
VAR Filter: TEditform;
begin
  Filter := TEditForm.Create (Self);
  WITH Filter, Filter.Editor DO BEGIN
    PfadName := ChangeFileExt (Application.ExeName, '.fil');
    Caption := PfadName;
    Text := Dateifilter;
    Modified := FALSE;
    SendMessage(Editor.Handle, EM_ScrollCaret, 0, 0);
  END (* WITH *);
end;

procedure TLRFrame.SpeedButtonTagselectClick(Sender: TObject);
VAR  ST:                       TSearchTypes;
     Level:                    Integer;
     otagend:                  Integer;

  procedure keinTag;
  BEGIN
    showMessage ('Kein Tag gefunden');
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      tagname := '';
    END (* WITH *);
  END;

// Tagselect wei nicht, welche Tags paarig sind, dh. ein Endtag besitzen,
// und welche nicht. Das ist einerseits eine Strke - es erkennt beliebige
// Tagpaare - andererseits eine Schwche: Es mu immer das ganze Dokument
// nach einem ev. Endtag durchsuchen. Nur wenn dieses nicht existiert,
// schliet es, da es sich um ein unres Tag handelt.

begin
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        tagstart := SelStart + 1;
        (* zuerst nach links suchen: *)
        WHILE (tagstart > 0) AND (Text [tagstart] <> '<') DO
          DEC (tagstart);
        IF (Text [tagstart] <> '<') THEN BEGIN keinTag; EXIT; END;

        (* tagname ermitteln *)
        tagname := '';
        tagend := tagstart + 1;
        WHILE NOT (Text [tagend] IN [' ', '>', #13, #10]) AND (tagend <= GetTextLen) DO BEGIN
          tagname := tagname + Text [tagend];
          INC (tagend);
        END (* WHILE *);

        IF tagname [1] = '/' THEN BEGIN keinTag; Exit; END;
// showMessage (tagname);

        tagend := tagstart;
        WHILE (Text [tagend] <> '>') AND (tagend < GetTextLen) DO
          INC (tagend);
        IF (Text [tagend] <> '>') THEN BEGIN keinTag; EXIT; END;

        (* Versuche, ein Endtag zu finden *)
        Level := 1;
        pairstart := 0; pairend := 0; otagend := tagend;
//showMessage (tagname);
        ST := [stWholeWord];
        WHILE (Level > 0) DO BEGIN
//          pairstart := FindText ('</' + tagname + '>', tagend + 1, GetTextLen, ST);
          pairstart := FindText (tagname, tagend + 1, GetTextLen, ST);
          IF pairstart < 0 THEN BEGIN
//showMessage (tagname + ' nicht gefunden, Level: ' + IntToStr (Level));
            tagend := otagend; Break;
          END (* IF *);
          IF (Text [pairstart] = '/') AND (Text [pairstart-1] = '<')
            THEN BEGIN
            DEC (Level);
//showMessage ('/' + tagname + ' gefunden, Level: ' + IntToStr (Level));
          END (* IF *)
          ELSE IF (Text [pairstart] = '<') THEN BEGIN
            INC (Level);
//showMessage (tagname + '> gefunden, Level: ' + IntToStr (Level));
          END (* ELSE *);
          tagend := pairstart + Length (tagname);
          IF Level = 0 THEN BEGIN
            pairend := pairstart + Length (tagname + '>');
            DEC (pairstart, 2);
// ups - bercksichtigt nicht ev. Leerzeichen zwischen endtagname und >
          END (* IF Level = 0 *);
        END (* WHILE Level > 0 *);

        DEC (tagstart);
        Selstart := tagstart;
        IF pairend > 0 THEN
          Sellength := pairend - tagstart
        ELSE
          Sellength := tagend - tagstart;
        TagSelected := TRUE;
      END (* WITH Editor *);
    END (* WITH ActiveMDIChild *);
  END (* IF gltiger Text *);
end;

procedure TLRFrame.SpeedButtonRemoveTagsClick(Sender: TObject);
VAR  ST:                  TSearchTypes;
     tagind, tagendind:   Integer;
     extTagname:          String;
begin
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        IF NOT TagSelected THEN BEGIN
          showMessage ('Bitte zuerst Tag selektieren und prfen');
          EXIT;
        END (* NOT TagSelected *);

        tagind := FindText ('<' + tagname + '>', tagstart, GetTextLen, ST);
        IF tagind = tagstart THEN BEGIN
          SelStart := tagind; SelLength := Length (tagname) + 2;
          SelText := '';
          DEC (pairstart, Length (tagname) + 2);
        END
        ELSE BEGIN
          tagind := FindText ('<' + tagname, tagstart, GetTextLen, ST);
          IF tagind = -1 THEN BEGIN
            showMessage ('Konnte Starttag "' + tagname + '" nicht finden; tagind: ' +
                         IntToStr (tagind) + ', tagstart: ' + IntToStr (tagstart));
            EXIT;
          END
          ELSE BEGIN
            ExtTagname := '';
            tagend := tagstart + 1;
            WHILE NOT (Text [tagend] = '>') AND (tagend <= GetTextLen) DO BEGIN
              ExtTagname := ExtTagname + Text [tagend];
              INC (tagend);
            END (* WHILE *);
            IF (Text [tagend] = '>') THEN BEGIN
              ExtTagname := ExtTagname + Text [tagend];
              IF NOT (MessageDlg ('Entferne Tag: "' + ExtTagname + '"', mtConfirmation,
                [mbYes, mbNo], 0) = mrYes) THEN Exit;
//showMessage ('Entferne Tag: "' + ExtTagname + '"');
              SelStart := tagstart; SelLength := Length (ExtTagname);
              SelText := '';
              DEC (pairstart, Length (ExtTagname));
            END
            ELSE BEGIN
              showMessage ('Tagende fr " + ExtTagname + " nicht gefunden');
              Exit;
            END;
          END (* ELSE *);
        END (* ELSE *);

        IF pairstart < 0 THEN BEGIN
          TagSelected := FALSE; tagname := '';
//          tagstart := -1; pairstart := -1;
          EXIT; // kein EndTag
        END (* IF kein EndTag *);

        tagendind := FindText ('</' + tagname + '>', pairstart -2, GetTextLen, ST);
        IF tagendind = pairstart THEN BEGIN
          SelStart := tagendind; SelLength := Length (tagname) + 3;
          SelText := '';
          TagSelected := FALSE; tagname := '';
//          tagstart := -1; pairstart := -1;
        END
        ELSE
          showMessage ('Konnte Endtag "' + tagname + '" nicht finden; tagendind: ' +
                       IntToStr (tagendind) + ', pairstart: ' + IntToStr (pairstart));

      END (* WITH Editor *);
    END (* WITH ActiveMDIChild *);
  END (* IF gltiger Text *);
end (* SpeedButtonRemoveTagsClick *);

procedure TLRFrame.SpeedButtonBreakClick(Sender: TObject);
VAR  start:     Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        start := Editor.SelStart;
        SelText := Editor.SelText + '<br>' + cr;
//        SelAttributes.Style := [fsbold];
//        SelAttributes.Color := clMaroon;
      END (* WITH Editor *);
      IF CheckBoxTagassStart.checked THEN BEGIN
        Editor.SelStart := start;
        SpeedButtonSelLinksClick (Sender);
      END (* IF *);
    END (* WITH *);
  END (* IF *);
end (* SpeedButtonBreakClick *);

procedure TLRFrame.SyntaxHighlight (Editor: TRichedit);
VAR  start, ende, Laenge: Integer;
     oldpos, oldende:     Integer;
begin
  WITH Editor DO BEGIN
    oldpos := SelStart;
    IF SelLength > 0 THEN BEGIN
      start := SelStart; Laenge := start + SelLength;
      SelAttributes.Style := [];
      SelAttributes.Color := clBlack;
    END
    ELSE BEGIN
      start := 0; Laenge := GetTextLen;
      SelStart := 0; SelLength := Laenge;
      SelAttributes.Style := [];
      SelAttributes.Color := clBlack;
    END;
    Visible := FALSE;
    Enabled := FALSE;
    REPEAT
      start := FindText ('<', start, Laenge - start, []);
      IF start > -1 THEN BEGIN
        oldende := ende + 1;
        ende := start + 1;
        ende := FindText ('>', ende, Laenge - start, []);
        IF ende > -1 THEN BEGIN
          Selstart := start; SelLength := ende - start + 1;
          SelAttributes.Style := [fsbold];
          SelAttributes.Color := clNavy; //clPurple; //clGreen; //clRed; //clTeal; //clMaroon;
          IF start = FindText ('</a>', start, Laenge - start, []) THEN BEGIN
{showMessage ('Link: oldende: ' + IntToStr (oldende) +
', Len: ' + IntToStr (start - oldende));}
            SelStart := oldende; SelLength := start - oldende;
            SelAttributes.Style := [fsUnderline];
            SelAttributes.color := clBlue;
          END (* IF end-Anker *);
          start := ende + 1;
        END (* IF > gefunden *);
      END (* IF < gefunden *)
      ELSE ende := Laenge;
    UNTIL (ende >= Laenge);
    Visible := TRUE;
    SelLength := 0; SelStart := oldpos;
    Enabled := TRUE; SetFocus;
  END (* WITH Editor *);
end (* SyntaxHighlight *);

procedure TLRFrame.SpeedButtonSyntaxClick(Sender: TObject);
begin
  IF (ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      dontShow := TRUE;
      SyntaxHighlight (Editor);
      dontShow := FALSE;
    END (* WITH EditForm *);
  END (* IF *);
end;

procedure TLRFrame.Anwendungen1Click(Sender: TObject);
VAR  i:        Integer;
     menitem:  TMenuItem;
begin
  i := Anwendungen1.Count;
  WHILE (Anwendungen1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Anwendungen1.Delete (i);
  END (* WHILE *);

  FOR i := 0 TO Anwendungsliste.Count - 1 DO BEGIN
    IF Anwendungsliste.Strings [i] <> '' THEN BEGIN
      menitem := TMenuItem.Create (FrameMenu);
      WITH menitem DO BEGIN
        Caption := Anwendungsliste.Strings [i];
        OnClick := Anwendung1Click;
      END (* WITH *);
      Anwendungen1.Add (menitem);
    END (* IF kein leerer Eintrag *);
  END (* FOR *);
end;

procedure TLRFrame.Anwendung1Click(Sender: TObject);
VAR Argument: String;
begin
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
      Argument := Pfadname;
    END (* WITH *)
  ELSE Argument := '';
  WITH Sender AS TMenuItem DO BEGIN
    IF Caption <> '' THEN BEGIN
      TRY
        ExecuteFile (Caption, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Caption + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;


procedure TLRFrame.Kopieren1Click(Sender: TObject);
// Datum in Clipboard kopieren
VAR Clip: TClipboard;
begin
  Clip := Clipboard;
  Clip.AsText := Tagesanzeige.Caption + ', den ' + Datumsanzeige.Caption;
end;

procedure TLRFrame.LetztenTextoeffnen1Click(Sender: TObject);
begin
  IF HistoryListe.Count > 0 THEN BEGIN
    IF FileExists (HistoryListe.Strings [0]) THEN BEGIN
        WITH TEditForm.Create (Self) DO
          Open (HistoryListe.Strings [0]);
    END (* IF *)
    ELSE BEGIN
      ShowMessage ('Die Datei "' + HistoryListe.Strings [0] + '" ist nicht vorhanden');
      HistoryListe.Delete (0);
    END (* ELSE *);
  END (* IF *);
end;

procedure TLRFrame.SpeedButtonNoframesClick(Sender: TObject);
VAR  start:         Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<noframes>' + Editor.SelText +
                        '</noframes>' + cr;
      Editor.SelStart := start;
    END (* WITH *);
    IF CheckBoxTagassStart.checked THEN SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.Druckertest1Click(Sender: TObject);
Var 
  outf: TextFile;
  C: Char;
begin
  AssignPrn (Outf);
  Rewrite(outf);
  C := 'D';
  Write(outf,C);
  WriteLn (outf);
  closeFile (outf);
end;

procedure TLRFrame.SpeedButtonSelLinksClick(Sender: TObject);
begin
  SpeedButtonTagselectClick (Sender);
  SpeedButtonLinksClick (Sender);
end;

procedure TLRFrame.SpeedButtonGrafikClick(Sender: TObject);
VAR  start: Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<img src="bild.gif" alt="Hier ist ein Bild">' + cr;
      Editor.SelStart := start;
    END (* WITH *);
    SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.SpeedButtonLinkClick(Sender: TObject);
VAR  start: Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<a>' + Editor.SelText + '</a>' + cr;
      Editor.SelStart := start;
    END (* WITH *);
    SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.SpeedButtonHeadlineClick(Sender: TObject);
VAR  start: Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<h1>' + Editor.SelText + '</h1>' + cr;
      Editor.SelStart := start;
    END (* WITH *);
    IF CheckBoxTagassStart.checked THEN SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.SpeedSuchlisteClick(Sender: TObject);
begin
  IF ActiveMDIChild <> NIL THEN
    IF ActiveMDIChild IS TEditForm THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        EditorEinstellungenClick (Sender);
        WITH TextFormatDialog DO BEGIN
          PageControl1.ActivePage := Suchmarken;
        END (* WITH TextFormatDialog *);
      END (* WIHT ActiveMDIChild AS *);
end;

procedure TLRFrame.SpeedButtonStringDialogClick(Sender: TObject);
VAR  mr: TModalResult;
begin
  WITH TStringDialog.ECreate (Self, 'Historyliste', 'Datei laden',
                              ChangeFileExt (Application.Exename, '.HIS'),
                              HistoryListe, 0, TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      HistoryListe := Liste;
      WITH TEditForm.Create (Self) DO
        Open (Auswahl);
    END (* IF mrOk *)
    ELSE IF mr = mrYes THEN BEGIN
      HistoryListe := Liste;
//showMessage (HistoryListe [1]);      
    END;
    Release;
  END (* WITH *);
end;

procedure TLRFrame.TimerSetupTimer(Sender: TObject);
begin
  Setup := FALSE;
end;

procedure TLRFrame.SpeedButtonRekonvertiereClick(Sender: TObject);
VAR  ST: TSearchTypes;
     findpos:  Integer;
     endpos:   Integer;

begin
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        IF SelLength > 0 THEN BEGIN
          findpos := SelStart; endpos := SelStart + SelLength;
        END
        ELSE BEGIN
          findpos := 0; endpos := getTextLen;
        END;
        dontShow := TRUE;
        Visible := FALSE;
        Enabled := FALSE;
      END (* WITH Editor *);
      ST := [stMatchCase];

      tausche (findpos, endpos, '&nbsp;', #160, ST);
      tausche (findpos, endpos, '&iexcl;', '', ST);
      tausche (findpos, endpos, '&cent;', '', ST);
      tausche (findpos, endpos, '&pound;', '', ST);
      tausche (findpos, endpos, '&curren;', '', ST);
      tausche (findpos, endpos, '&yen;', '', ST);
      tausche (findpos, endpos, '&brvbar;', '', ST);
      tausche (findpos, endpos, '&sect;', '', ST);
      tausche (findpos, endpos, '&uml;', '', ST);
      tausche (findpos, endpos, '&copy;', '', ST);
      tausche (findpos, endpos, '&ordf;', '', ST);
      tausche (findpos, endpos, '&laquo;', '', ST);
      tausche (findpos, endpos, '&not;', '', ST);
      tausche (findpos, endpos, '&shy;', '', ST);
      tausche (findpos, endpos, '&reg;', '', ST);
      tausche (findpos, endpos, '&macr;', '', ST);
      tausche (findpos, endpos, '&deg;', '', ST);
      tausche (findpos, endpos, '&plusmn;', '', ST);
      tausche (findpos, endpos, '&sup2;', '', ST);
      tausche (findpos, endpos, '&sup3;', '', ST);
      tausche (findpos, endpos, '&acute;', '', ST);
      tausche (findpos, endpos, '&micro;', '', ST);
      tausche (findpos, endpos, '&para;', '', ST);
      tausche (findpos, endpos, '&middot;', '', ST);
      tausche (findpos, endpos, '&cedil;', '', ST);
      tausche (findpos, endpos, '&sup1;', '', ST);
      tausche (findpos, endpos, '&ordm;', '', ST);
      tausche (findpos, endpos, '&raquo;', '', ST);
      tausche (findpos, endpos, '&frac14;', '', ST);
      tausche (findpos, endpos, '&frac12;', '', ST);
      tausche (findpos, endpos, '&frac34;', '', ST);
      tausche (findpos, endpos, '&iquest;', '', ST);
      tausche (findpos, endpos, '&Agrave;', '', ST);
      tausche (findpos, endpos, '&Aacute;', '', ST);
      tausche (findpos, endpos, '&Acirc;', '', ST);
      tausche (findpos, endpos, '&Atilde;', '', ST);
      tausche (findpos, endpos, '&Auml;', '', ST);
      tausche (findpos, endpos, '&Aring;', '', ST);
      tausche (findpos, endpos, '&Aelig;', '', ST);
      tausche (findpos, endpos, '&Ccedil;', '', ST);
      tausche (findpos, endpos, '&Egrave;', '', ST);
      tausche (findpos, endpos, '&Eacute;', '', ST);
      tausche (findpos, endpos, '&Ecirc;', '', ST);
      tausche (findpos, endpos, '&Euml;', '', ST);
      tausche (findpos, endpos, '&Igrave;', '', ST);
      tausche (findpos, endpos, '&Iacute;', '', ST);
      tausche (findpos, endpos, '&Icirc;', '', ST);
      tausche (findpos, endpos, '&Iuml;', '', ST);
      tausche (findpos, endpos, '&ETH;', '', ST);
      tausche (findpos, endpos, '&Ntilde;', '', ST);
      tausche (findpos, endpos, '&Ograve;', '', ST);
      tausche (findpos, endpos, '&Oacute;', '', ST);
      tausche (findpos, endpos, '&Ocirc;', '', ST);
      tausche (findpos, endpos, '&Otilde;', '', ST);
      tausche (findpos, endpos, '&Ouml;', '', ST);
      tausche (findpos, endpos, '&times;', '', ST);
      tausche (findpos, endpos, '&Oslash;', '', ST);
      tausche (findpos, endpos, '&Ugrave;', '', ST);
      tausche (findpos, endpos, '&Uacute;', '', ST);
      tausche (findpos, endpos, '&Ucirc;', '', ST);
      tausche (findpos, endpos, '&Uuml;', '', ST);
      tausche (findpos, endpos, '&Yacute;', '', ST);
      tausche (findpos, endpos, '&THORN;', '', ST);
      tausche (findpos, endpos, '&szlig;', '', ST);
      tausche (findpos, endpos, '&agrave;', '', ST);
      tausche (findpos, endpos, '&aacute;', '', ST);
      tausche (findpos, endpos, '&acirc;', '', ST);
      tausche (findpos, endpos, '&atilde;', '', ST);
      tausche (findpos, endpos, '&auml;', '', ST);
      tausche (findpos, endpos, '&aring;', '', ST);
      tausche (findpos, endpos, '&aelig;', '', ST);
      tausche (findpos, endpos, '&ccedil;', '', ST);
      tausche (findpos, endpos, '&egrave;', '', ST);
      tausche (findpos, endpos, '&eacute;', '', ST);
      tausche (findpos, endpos, '&ecirc;', '', ST);
      tausche (findpos, endpos, '&euml;', '', ST);
      tausche (findpos, endpos, '&igrave;', '', ST);
      tausche (findpos, endpos, '&iacute;', '', ST);
      tausche (findpos, endpos, '&icirc;', '', ST);
      tausche (findpos, endpos, '&iuml;', '', ST);
      tausche (findpos, endpos, '&eth;', '', ST);
      tausche (findpos, endpos, '&ntilde;', '', ST);
      tausche (findpos, endpos, '&ograve;', '', ST);
      tausche (findpos, endpos, '&oacute;', '', ST);
      tausche (findpos, endpos, '&ocirc;', '', ST);
      tausche (findpos, endpos, '&tilde;', '', ST);
      tausche (findpos, endpos, '&ouml;', '', ST);
      tausche (findpos, endpos, '&divide;', '', ST);
      tausche (findpos, endpos, '&oslash;', '', ST);
      tausche (findpos, endpos, '&ugrave;', '', ST);
      tausche (findpos, endpos, '&uacute;', '', ST);
      tausche (findpos, endpos, '&ucirc;', '', ST);
      tausche (findpos, endpos, '&uuml;', '', ST);
      tausche (findpos, endpos, '&yacute;', '', ST);
      tausche (findpos, endpos, '&thorn;', '', ST);
      tausche (findpos, endpos, '&yuml;', '', ST);

// ups - soll das hier herein oder in einen Extrabefehl???      
      tausche (findpos, endpos, '&amp;', '&', ST);
      tausche (findpos, endpos, '&lt;', '<', ST);
      tausche (findpos, endpos, '&gt;', '>', ST);
      tausche (findpos, endpos, '&quot;', '"', ST);

      WITH Editor DO BEGIN
        dontShow := FALSE;
        Visible := TRUE;
        Enabled := TRUE;
      END (* WITH Editor *);
    END (* WITH *);
  END (* IF gltiger Text *);
end;

procedure TLRFrame.SpeedButtonHTMLInsertClick(Sender: TObject);
VAR  ST: TSearchTypes;
     findpos:  Integer;
     endpos:   Integer;

begin
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      WITH Editor DO BEGIN
        IF SelLength > 0 THEN BEGIN
          findpos := SelStart; endpos := SelStart + SelLength;
        END
        ELSE BEGIN
          showMessage ('Bitte markieren Sie zur Sicherheit einen Textbereich!');
          Exit;
        END;
        dontShow := TRUE;
        Visible := FALSE;
        Enabled := FALSE;
      END (* WITH Editor *);
      ST := [stMatchCase];
      tausche (findpos, endpos, '&', '&amp;', ST);
      tausche (findpos, endpos, '<', '&lt;', ST);
      tausche (findpos, endpos, '>', '&gt;', ST);
      tausche (findpos, endpos, '"', '&quot;', ST);
//      tausche (findpos, endpos, #10, #10 + '<br>', ST);
      WITH Editor DO BEGIN
        dontShow := FALSE;
        Visible := TRUE;
        Enabled := TRUE;
      END (* WITH Editor *);
    END (* WITH *);
  END (* IF gltiger Text *);
end (* SpeedButtonHTMLInsertClick *);

function TLRFrame.ExplorerTest: BOOLEAN;
// var strIExplore: String;
begin
   with TRegistry.Create do
      try
         RootKey := HKEY_CLASSES_ROOT;
         if (OpenKey('CLSID\{FBF23B42-E3F0-101B-8488-' +
                     '00AA003E56F8}\Shell\Open\Command', False)) then
            try
               strIExplore := ReadString('');
            finally
               CloseKey;
            end;
      finally
         Free;
      end;
   IF (Length (strIExplore) > 0) AND (strIExplore [1] = '"') THEN
     strIExplore := Copy (strIExplore, 2, Length (strIExplore) - 2);
// showMessage (strIExplore);
   IF Length (strIExplore) > 0 THEN
     Result := FileExists(strIExplore)
   ELSE Result := FALSE;
end (* ExplorerTest *);

function TLRFrame.LiesExplorer: BOOLEAN;
begin
  Result := FIExplorerInstalliert;
end (* LiesExplorer *);

procedure TLRFrame.ExplorerTest1Click(Sender: TObject);
begin
   if ExplorerTest then
      ShowMessage('Internet-Explorer installiert: ' + strIExplore)
   else
      ShowMessage('Internet-Explorer ist nicht installiert');
end;

procedure TLRFrame.SpeedButtonFonttagClick(Sender: TObject);
VAR  start:     Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<font>' + Editor.SelText +
                        '</font>';
      Editor.SelStart := start;
    END (* WITH *);
    IF CheckBoxTagassStart.checked THEN SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.SpeedButtonAttrTagClick(Sender: TObject);
VAR  start:     Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<b>' + Editor.SelText +
                        '</b>';
      Editor.SelStart := start;
    END (* WITH *);
    IF CheckBoxTagassStart.checked THEN SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.SpeedButtonZielClick(Sender: TObject);
VAR  start: Integer;
begin
  IF (LRFrame.ActiveMDIChild <> NIL) AND (LRFrame.ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      start := Editor.SelStart;
      Editor.SelText := '<a name="' + Editor.SelText + '">' + Editor.SelText + '</a>' + cr;
      Editor.SelStart := start;
    END (* WITH *);
    IF CheckBoxTagassStart.checked THEN SpeedButtonSelLinksClick (Sender);
  END (* IF *);
end;

procedure TLRFrame.CheckBoxTagassStartClick(Sender: TObject);
begin
  SpeedButtonAbsatz.Flat := NOT CheckBoxTagassStart.checked;
  SpeedButtonBreak.Flat := NOT CheckBoxTagassStart.checked;
  SpeedButtonFonttag.Flat := NOT CheckBoxTagassStart.checked;
  SpeedButtonAttrtag.Flat := NOT CheckBoxTagassStart.checked;
  SpeedButtonHorline.Flat := NOT CheckBoxTagassStart.checked;
  SpeedButtonZiel.Flat := NOT CheckBoxTagassStart.checked;
  SpeedButtonHeadline.Flat := NOT CheckBoxTagassStart.checked;
  SpeedButtonNoframes.Flat := NOT CheckBoxTagassStart.checked;
end;

end.
