procedure TIExplorerForm.WebBrowser1DownloadBegin(Sender: TObject);
begin
  SpeedButtonStop.Enabled := TRUE;
  SpeedButtonRefresh.Enabled := TRUE;
end;

procedure TIExplorerForm.SpeedButtonRefreshClick(Sender: TObject);
begin
  TRY
    WebBrowser1.Refresh;
  EXCEPT
    ON EOleException DO showMessage ('Nichts nachzuladen');
  END;
end;

procedure TIExplorerForm.SpeedButtonStopClick(Sender: TObject);
begin
  WebBrowser1.Stop;
end;

procedure TIExplorerForm.SpeedButtonBackClick(Sender: TObject);
begin
  TRY
    WebBrowser1.GoBack;
  EXCEPT
    ON EOleException DO showMessage ('Kann nicht zurckgehen');
  END;
end;

procedure TIExplorerForm.SpeedButtonForwardClick(Sender: TObject);
begin
  TRY
    WebBrowser1.GoForward;
  EXCEPT
    ON EOleException DO showMessage ('Kann nicht vorwrtsgehen');
  END;
end;

procedure TIExplorerForm.SpeedButtonMailClick(Sender: TObject);
begin
  IF MailerName = '' THEN Mailer1Click (Sender);
  IF MailerName <> '' THEN ExecuteFile (MailerName, '', '', SW_SHOW);
end;

procedure TIExplorerForm.SpeedButtonGoHomeClick(Sender: TObject);
begin
//  WebBrowser1.GoHome;
  ComboBoxURL.Text := HomeName;
  ButtonLoadClick (Sender);
end;

procedure TIExplorerForm.SpeedButtonGoSearchClick(Sender: TObject);
begin
  WebBrowser1.GoSearch;
end;

procedure TIExplorerForm.Druckerdialog1Click(Sender: TObject);
VAR eQuery:           OLECMDF;
    Question:         OLEVariant;
    nothing:          OLEVariant;
begin
  Question := 'Bereit zum Drucken?';
  WITH WebBrowser1 DO BEGIN
    try
// Prfen, ob der Befehl momentan ausfhrbar ist
      eQuery := QueryStatusWB (OLECMDID_PRINT);
      if eQuery = OLECMDF_ENABLED then
        ExecWB (OLECMDID_PRINT, OLECMDEXECOPT_PROMPTUSER,
                nothing, Question)
      else showMessage ('Kann nichts drucken!');
    except
      showMessage ('Fehler beim Drucken');
    end (* try *);
  END (* WITH *);
end;

procedure TIExplorerForm.Merklisteanzeigen1Click(Sender: TObject);
VAR  mr:   TModalResult;
     Ole:  OleVariant;
begin
  WITH TStringDialog.ECreate (Self, 'Merkliste', 'URL whlen',
                         ChangeFileExt (Application.Exename, '.BOK'),
                              Merkliste, 0, TRUE, TRUE, FALSE, FALSE) 
DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      Merkliste := Liste;
      Ole := 0;
      ComboBoxURL.Text := Auswahl;
      WebBrowser1.Navigate (Auswahl, Ole, Ole, Ole, Ole);
    END (* IF mrOk *)
    ELSE IF mr = mrYes THEN
      Merkliste := Liste;
    Release;
  END (* WITH *);
end (* Merklisteanzeigen1Click *);

procedure TIExplorerForm.SpeedButtonOnOfflineClick(Sender: TObject);
begin
  WebBrowser1.Offline := NOT WebBrowser1.Offline;
  IF WebBrowser1.Offline THEN SpeedButtonOnOffline.Glyph := OfflineBit
  ELSE SpeedButtonOnOffline.Glyph := OnlineBit;
end;

