procedure THyperlinkForm1.Tabellenanalyse;
VAR     border, summary, tabAlign,
        tabWidth, cell:         String;
        celltag, tagbody:       String;
        FLen:                   Integer;
        tagpos,
        coltagpos, celloff,
        colarg, colargend:      Integer;
        cols, rows:             Integer;
        maxcols:                Integer;
        i:                      Integer;

  function findCellTag (start: Integer; var celltag: String): Integer;
  VAR ctp: Integer;
  begin
    WITH EditSelected DO BEGIN
      ctp := findText ('<t', start, FLen, []);
      IF ctp >= 0 THEN BEGIN
        IF ((upCase (Text [ctp + 3]) = 'H') OR
            (upCase (Text [ctp + 3]) = 'D')) AND
           ((Text [ctp + 4] = '>') OR
            (Text [ctp + 4] = ' '))  THEN BEGIN
          Result := ctp;
          celltag := Copy (text, ctp + 2, 2);
        END
        ELSE Result := -1;
      END (* IF *)
      ELSE Result := ctp;
    END (* WITH *);
  end (* findCellTag *);

begin (* Tabellenanalyse *)
  FLen := EditSelected.GetTextLen;
  border := getArg (EditSelected, 0, 'border', FLen, TRUE);
  IF border <> '' THEN
    UpDownFormborder.Position := StrToInt (border);

  summary := getArg (EditSelected, 0, 'summary', FLen, FALSE);
  RichEditTabSummary.Text := summary;

  tabWidth := getArg (EditSelected, 0, 'width', FLen, FALSE);
  EditTabellenbreite.Text := tabWidth;

  tabAlign := getArg (EditSelected, 0, 'align', FLen, TRUE);
  IF tabAlign = 'left' THEN RadioGroupTableAlign.ItemIndex := 0
  ELSE IF tabAlign = 'center' THEN RadioGroupTableAlign.ItemIndex := 1
  ELSE IF tabAlign = 'right' THEN RadioGroupTableAlign.ItemIndex := 2
  ELSE RadioGroupTableAlign.ItemIndex := 3;

  WITH EditSelected DO BEGIN
    tagpos := findText ('<caption>', 0, FLen, []);
  END (* WITH *);

  IF tagpos >= 0 THEN
    tagpos := SelectTag (EditSelected, tagpos, 'caption', tagbody);
  EditFormCaption.Text := tagbody;

  // Jetzt mu die Anzahl Zeilen und Spalten der Tabelle ermittelt 
  // werden, damit das Display-Grid auf die erforderliche Gre 
  // gebracht werden kann. Probleme gibt es, wenn die Tabelle entartet 
  // ist, dh. eine Reihe lauter Zellen enthlt, die mehr als eine 
  // Reihe hoch sind - dann fehlt eine Reihe!
//showMessage ('First Pass');

  WITH EditSelected DO BEGIN
    rows := 0; maxcols := 0; // maxrows := 0;
    tagpos := findText ('<tr>', 0, FLen, []);
    WHILE tagpos >= 0 DO BEGIN
      INC (rows);
      coltagpos := tagpos + Length ('<tr>');
      coltagpos := findCellTag (coltagpos, celltag);
      cols := 0;
      WHILE coltagpos >= 0 DO BEGIN

        colargend := findText ('>', coltagpos + 3, 
                               FLen, []) - coltagpos - 3;
        cell := getArg (EditSelected, coltagpos + 3,
                        'colspan', colargend, TRUE);
        IF cell <> '' THEN BEGIN
          INC (cols, StrToInt (cell));
        END
        ELSE INC (cols);

        coltagpos := findCellTag (coltagpos +
                                  Length ('<th>'), celltag);
      END (* WHILE coltagpos *);
      IF cols > maxCols THEN maxCols := cols;

      tagpos := findText ('<tr>', tagpos + Length ('<tr>'), FLen, []);
    END (* WHILE *);
  END (* WITH *);
  StringGridTables.RowCount := rows;
  StringGridTables.ColCount := maxCols;
  SetTableStringGrid;
  UpdownFormReihen.Position := rows;
  UpdownFormSpalten.Position := maxCols;
//showMessage ('RowCount: ' + IntToStr (rows) +
               ', ColCount: ' + IntToStr (maxCols));
  // Jetzt mssen wir die Definition nochmal scannen, um die 
  // Zellendefinitionen zu ermitteln.

//showMessage ('Second Pass');
  WITH EditSelected DO BEGIN
    rows := 0; maxcols := 0; // maxrows := 0;
    tagpos := findText ('<tr>', 0, FLen, []);
    WHILE tagpos >= 0 DO BEGIN
      INC (rows);
      coltagpos := tagpos + Length ('<tr>');
      coltagpos := findCellTag (coltagpos, celltag);
      cols := 0; celloff := 0;
      WHILE coltagpos >= 0 DO BEGIN
        INC (cols);
        WHILE (cols + celloff < StringGridTables.ColCount) AND
         (((StringGridTables.Objects 
         [cols - 1 + celloff, rows - 1] AS TCellAttribs).colspan = 0)
        OR ((StringGridTables.Objects 
         [cols - 1 + celloff, rows - 1] AS TCellAttribs).rowspan = 0))
            DO
          INC (celloff);
{showMessage ('cols: ' + IntToStr (cols) + ', celloff: ' +
              IntToStr (celloff) + ', rows: ' + IntToStr (rows));
}
        StringGridTables.Col := cols - 1 + celloff;
        StringGridTables.Row := rows - 1;

        colargend := findText ('>', coltagpos +
                               3, FLen, []) - coltagpos - 3;
        cell := getArg (EditSelected, coltagpos +
                        3, 'colspan', colargend, TRUE);
        IF cell <> '' THEN BEGIN
          UpDownSpanCols.Position := StrToInt (cell); + 
{showMessage ('cols: ' + IntToStr (cols) +', celloff: '
              IntToStr (celloff) + ', rows: ' + IntToStr (rows) +
              ', colspan: ' + cell);
}
        END (* IF cell *);

        cell := getArg (EditSelected, coltagpos +
                        3, 'rowspan', colargend, TRUE);
        IF cell <> '' THEN BEGIN
          UpDownSpanRows.Position := StrToInt (cell);
{showMessage ('cols: ' + IntToStr (cols) + ', celloff: ' +
              IntToStr (celloff) + ', rows: ' + IntToStr (rows) +
              ', rowspan: ' + cell);
}
        END (* IF cell *);

        WITH StringGridTables DO (Objects [col, row] AS
                           TCellAttribs).celltype := celltag;

        colarg := selectCellCont (EditSelected,coltagpos,
                                  celltag, tagbody);
{showMessage ('coltagpos: ' + IntToStr (coltagpos) + ' "' +
              Copy (Text, coltagpos + 1, GetTextLen) + '"' +
              #13#10 + ', celltag: ' + celltag + ', tagbody: ' +
              tagbody);
}
        FOR i := 1 TO 2 DO
          IF (Length (tagbody) > 0) AND 
             (tagbody [Length (tagbody)] IN [#10, #13]) THEN
            Delete (tagbody, Length (tagbody), 1);

        WITH StringGridTables DO Cells [col, row] := tagbody;

        coltagpos := findCellTag (coltagpos +
                                  Length ('<th>'), celltag);
      END (* WHILE coltagpos *);
      IF cols > maxCols THEN maxCols := cols;

      tagpos := findText ('<tr>', tagpos + Length ('<tr>'), FLen, []);
    END (* WHILE *);
  END (* WITH EditSelected *);
  WITH StringGridTables DO BEGIN
    Col := 0; Row := 0;
  END;
  StringGridTablesClick (Self);
  StringGridTables.Repaint;
end (* TabellenAnalyse *);
