;***********************************************************
;3DNOW! and MMX Macro Library for TASM in MASM Mode or MASM
;c't 15/98 Andreas Stiller
;***********************************************************
IFDEF ??VERSION           ; Is defined only  in TASM
  %Nolist              ; Do not list Macro definition
  %MACS
  TASM EQU 1
  IFDEF @32BIT
   IF @32BIT EQ 0
    APP_16BIT EQU 1    ; It is a 16 Bit App
   ENDIF
  ENDIF
ELSE
.NOLIST
.LISTALL                  ; list Macro expansion which generate Code
   TASM EQU 0
  ;APP_16BIT EQU 1     ; set yourself if 16 Bit Application
ENDIF

; .SALL                ; alternativ: Do not list Macro expansion
; .LALL                ;             list complete expansion


.486p

; MMX-OPCodes
opc_Rdpmc     = 033H
opc_Emms      = 077H
opc_Movd2     = 06EH
opc_Movd      = 07EH
opc_Movd1     = 07EH
opc_Movq      = 06FH
opc_Movq1     = 06FH
opc_Movq2     = 07FH
opc_Packssdw  = 06BH
opc_Packsswb  = 063H
opc_Packuswb  = 067H
opc_Paddb     = 0FCH
opc_Paddd     = 0FEH
opc_Paddsb    = 0ECH
opc_Paddsw    = 0EDH
opc_Paddusb   = 0DCH
opc_Paddusw   = 0DDH
opc_Paddw     = 0FDH
opc_Pand      = 0DBH
opc_Pandn     = 0DFH
opc_Pcmpeqb   = 074H
opc_Pcmpeqd   = 076H
opc_Pcmpeqw   = 075H
opc_Pcmpgtb   = 064H
opc_Pcmpgtd   = 066H
opc_Pcmpgtw   = 065H
opc_Pmaddwd   = 0F5H
opc_Pmulhw    = 0E5H
opc_Pmullw    = 0D5H
opc_Por       = 0EBH

opc_PSHimd    = 072H
opc_PSlld1    = 072H
opc_PSrld1    = 072H
opc_PSrad1    = 072H

opc_PSHimq    = 073H
opc_Psllq1    = 073H
opc_Psrlq1    = 073H

opc_PSHimw    = 071H
opc_Psllw1    = 071H
opc_Psrlw1    = 071H
opc_Psraw1    = 071H

opc_Pslld2    = 0F2H
opc_Psllq2    = 0F3H
opc_Psllw2    = 0F1H

opc_Psrad2    = 0E2H
opc_Psraw2    = 0E1H
opc_Psrld2    = 0D2H
opc_Psrlq2    = 0D3H
opc_Psrlw2    = 0D1H

opc_Psubb     = 0F8H
opc_Psubd     = 0FAH
opc_Psubsb    = 0E8H
opc_Psubsw    = 0E9H
opc_Psubusb   = 0D8H
opc_Psubusw   = 0D9H
opc_Psubw     = 0F9H
opc_Punpcklbw = 060H
opc_Punpckldq = 062H
opc_Punpcklwd = 061H
opc_Punpckhbw = 068H
opc_Punpckhdq = 06AH
opc_Punpckhwd = 069H
opc_Pxor      = 0EFH

; end of MMX- Area

; 3DNow Opcodes !!!
opc_FEMMS    = 0Eh   ;Faster entry/exit of the MMX/FP-state
opc_PfMUL    = 0B4h  ;Packed FP Multiplication
opc_PfACC    = 0AEh  ;Packed FP Accumulate
opc_PFADD    = 09Eh  ;Packed FP Addition
opc_PFSUB    = 09Ah  ;Packed FP Subtraction
opc_PFSUBR   = 0AAh  ;Packed FP Reverse Subtraction
opc_PFCMPGE  = 090h  ;Packed FP Comparison
opc_PFCMPGT  = 0A0h  ;Packed FP Comparison, Greater
opc_PFCMPEQ  = 0B0h  ;Packed FP Comparison, Equal
opc_PFMIN    = 094h  ;Packed FP Minimum
opc_PFMAX    = 0A4h  ;Packed FP Maximum
opc_PI2FD    = 00Dh  ;Packed 32-bit Integer to FP Conv.
opc_PF2ID    = 01Dh  ;Packed FP to 32-bit Integer
opc_PFRCP    = 096h  ;Packed FP Reciprocal Approximation
opc_PFRSQRT  = 097h  ;Packed FP Reciprocal Square Root Appr.
opc_PFRCPIT1 = 0A6h  ;Packed FP Reciprocal First Iteration
opc_PFRSQIT1 = 0A7h  ;Packed FP Reciprocal Square Root 1. iter
opc_PFRCPIT2 = 0B6h  ;Packed FP Rec/Square  2.  Iteration
opc_PMULHRW  = 0B7h  ;Packed 16-bit Integer Mult with rounding
opc_PREFETCH = 00Dh  ;Prefetch at least a 32-byte line into D-L1
opc_PAVGUSB  = 0BFh  ;Packed 8-bit Unsigned Integer Averaging

AliasR0 EQU <AX>
AliasR1 EQU <CX>
AliasR2 EQU <DX>
AliasR3 EQU <BX>
AliasR4 EQU <SP>
AliasR5 EQU <BP>
AliasR6 EQU <SI>
AliasR7 EQU <DI>

ERROR macro txt
If tasm eq 1
 .ERR "&txt&"
else
 .ERR <txt>
endif
endm

setname Macro name, n
ifdef app_16bit
 name&alias EQU <AliasR&N>
else
 name&alias CATSTR <E>,%AliasR&N
endif
endm

Showname macro n1,n2
endm

SetAttr macro reg,name            ; => name@attr = m: MMn, name@alias=Rn
                                  ; =>             r: r32n,name@alias=Rn
                                  ; =>             x: other
  local ptype,ctype,len
  name&alias EQU <reg>
  name&attr  EQU <x>
  len SIZESTR <reg>
  ptype=.type reg

  if ((.type reg) and 30h) eq 20h ; Name is defined but no reg
    ctype=type reg
    ifdef app_16bit
     name&alias EQU word ptr &reg
    else
     name&alias EQU dword ptr &reg
    endif
    exitm
  endif;  { Is defined }

  if len NE 3                     ; name with 3 chars
    exitm                         ; no => no MMn, no r32
  endif

  if (.type reg) EQ 30h             ; its a 32 bit reg
    ifdef  app_16bit
      name&alias SUBSTR <reg>,2,2 ; 16 Bit alias
    endif
    name&attr EQU <r>
    exitm
  endif


  aliasfirst2 SUBSTR <reg>,1,2         ; the first 2 chars
  aliaslast   SUBSTR <reg>,3,1         ; last char
  IFIDNI aliasfirst2,<MM>
    name&attr EQU <m>
    setname name, %aliaslast
    exitm
    endif
endm

Setmasc macro dst:req, src:req, xoff
      ifnb <xoff>
       Prefixcnt=xoff
      else
       Prefixcnt=0
      endif
      setattr dst, <MMd>
      setattr src, <MMs>
endm

;; ************** fixed macros for MMX  **********
rdpmc     macro
              db	0fh, opc_Rdpmc
endm

emms     macro
	      db	0fh, opc_Emms
endm

;;************* Macro generator for MMX  ******************


psx    macro  name, dst:req, src:req
       local  x, y
x:            CMPXCHG src,dst
y:            org x+1+Prefixcnt
              db opc_&name
              org  y
        endm


psd    macro  name, dst:req, src:req, off
              local s,p
              setmasc dst,src,off
              s CATSTR MMdattr,MMsattr
              p INSTR <mm,mx>, s

              if p EQ 0
              error <**Error** in MMX instruction>
               exitm
              endif
              psx name, MMdalias,MMsalias
endm


Movd macro dst:req, src:req, off
      local p, s
      setmasc dst,src,off
      s CATSTR MMdattr,MMsattr
      p INSTR <mr,mx>, s
      IF p NE 0
              psx movd2, MMdalias, MMsalias
              exitm
      endif
      p INSTR <rm,xm>, s
      IF p NE 0
              psx movd1, MMsalias, MMdalias
              exitm
      endif
      ERROR <**Error** wrong Parameter in MOVD>
endm

MOVD1 macro dst:req, src:req, off
   MOVD dst,src,off
endm

MOVD2 macro dst:req, src:req, off
   MOVD dst,src,off
endm

MovQ macro dst:req, src:req,off
      local s,p
      setmasc dst,src,off
      s CATSTR MMdattr,MMsattr
      p INSTR <mm,xm>, s
      IF p NE 0
              psx movq2, MMsalias, MMdalias,
              exitm
      ENDIF
      IFIDN <mx>, s
              psx movq1, MMdalias, MMsalias
              exitm
      ENDIF
      ERROR  <**Error** wrong parameter in MOVQ>
endm


MOVQ1 macro dst:req, src:req, off
   MOVQ dst, src,off
endm


MOVQ2 macro dst:req, src:req, off
   MOVQ dst,src,off
endm


irp x,<punpcklbw,punpckhdq,punpcklwd,punpckhbw,punpckldq,punpckhwd>
  &x macro dst:req, src:req,off
       psd x, dst, src,off
      endm
endm

irp x, <paddd,paddsb,paddsw,paddusb,paddusw,paddb,paddw>

  &x macro dst:req, src:req,off
       psd x, dst, src,off
      endm
endm

irp x, <psubd,psubsb,psubsw,psubusb,psubusw,psubb,psubw>
  &x macro dst:req, src:req,off
       psd x, dst, src, off
      endm
endm

irp x, <pand,pandn,por,pxor>
  &x macro dst:req, src:req, off
       psd x, dst, src, off
      endm
endm

irp x, <pcmpeqb,pcmpeqd,pcmpeqw,pcmpgtb,pcmpgtd,pcmpgtw>
  &x macro dst:req, src:req, off
       psd x, dst, src, off
      endm
endm

irp x, <pmaddwd, pmulhw,pmullw>
  &x macro dst:req, src:req, off
       psd x, dst, src,off
      endm
endm

; ********* Macro Generator for MMX with immediates *******

pm      macro   name,dst:req, src:req, imm, off
        local s,x,y,p
              setmasc dst,imm,off
              s CATSTR MMdattr,MMsattr
              p Instr <mm>,s
               if p eq 0
                 error <*** error in MMX instruction***>
                 exitm
               endif

x:            db 0Fh
              MOV     MMsalias,MMdalias
	      db      src
y:
              org     x+1
              db    opc_&name
              org     y
        endm

im_pslld equ 6
im_psllw equ 6
im_psllq equ 6
im_psrad equ 4
im_psraw equ 4
im_psrlw equ 2
im_psrld equ 2
im_psrlq equ 2

irp x, <psllq,psrlq,pslld,psllw,psrad,psraw,psrld,psrlq,psllq,psrlw>
  &x macro dst:req, src:req, off
        if (.type src) eq 24h               ; SRC = const ?
              pm  x&1,dst,src,MM%im_&x,off
        else
              psd x&2,dst,src,off
        endif
      endm
endm

;*******************  3DNOW! Macros ******************
pfxxx   macro   name, dst:req, src:req, off
        local   s,x, y,p
	      setmasc dst, src,off
              s CATSTR MMdattr,MMsattr
              p instr <mm,mx>, s
              if p eq 0
               error <****error  in 3DNow! instruction***>
               exitm
              endif
x:            CMPXCHG MMsalias,MMdalias
y:            org     x+prefixcnt+1
              db      0Fh
              org     y
              db      name
              endm

irp x, <add,sub,subr,acc,cmpge,cmpgt,cmpeq,min,max,2id,rcp,rsqrt>
 PF&x macro dst:req, src:req, off
              pfxxx opc_pf&x, dst, src
      endm
endm

irp x, <mul,rcpit1,rsquit1,rcpit2,>
  PF&x macro dst:req, src:req,off
              pfxxx opc_pf&x, dst, src
      endm
endm

irp x, <pavgusb,pmulhrw,pi2fd>
   &x macro dst:req, src:req, off
              pfxxx opc_&x, dst, src
      endm
endm

femms     macro
              db	0fh, opc_Femms
endm


prefetch  macro   dst:req
	DB	0Fh
MMX_OPCODE = $
	inc dst
MMX_NEXT = $
	org	MMX_OPCODE
	if (.Type (dst)) AND 00010100y ; register
error <*** Error: Instruction requires memory address>
	else
	db	0Dh
	endif
	org	MMX_NEXT
	endm




prefetchw macro  dst:req
	DB	0Fh
MMX_OPCODE = $
	inc dst
MMX_NEXT = $
	org	MMX_OPCODE
	if (OPATTR(dst)) AND 00010100y ; register
error <*** Error: Instruction requires memory address>
	else
	db	0Dh
	endif
	org	MMX_NEXT
	endm

CPUID     macro
          db 0fh, 0A2h
          endm

.list
; and now a real subroutine to determine wether 3DNow! is present

public Test3Dnow
Test3Dnow proc near
; Test auf 3Dnow-Support
   pushfd              ; save EFLAGS
   pop eax             ; EFLAGS ins EAX-Register
   mov ebx, eax        ; merken in EBX
   xor eax, 00200000h  ; toggle Bit 21
   push eax            ; und via stack
   popfd               ; ins EFLAGS-Register
   pushfd              ; Von dort wieder via Stack
   pop eax             ; zurck  nach EAX
   cmp eax, ebx        ; Hat sich Bit 21 gendert?
   jz @@err_exit       ; nein => no CPUID
   mov eax, 80000001h  ; Setup Extended function 1
   CPUID               ; Darf man jetzt aufrufen
   test edx, 80000000h ; Bit 31 gesetzt?
   jnz @@3DNowok      ; Jau=> 3DNow! vorhanden
@@err_exit:
   mov ax,1
   stc
   ret
@@3Dnowok:
   mov ax,0
   clc
   ret
Test3Dnow endp
