import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;

/**
 * Eine Menge von Komponenten, die mit einem Datenmodell arbeiten
 */
public class MVCListenBeispiel extends JPanel {

  static JFrame frame;

  public MVCListenBeispiel() {
   
    // Erzeugen des Modells
    final BeispielListModel model = new BeispielListModel();

    // Setzen des Layoutmanagers, ordnet die Komponenten 
    // von oben nach unten an
    setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));

    // Erzeugen des Eingabefeldes und der Listen

    final JTextField inputField = new JTextField();
    final JList listbox1 = new JList(model);
    // JList kann nicht scrollen, daher in JScrollPane verpacken
    JScrollPane scrollPane1 = new JScrollPane(listbox1);
    final JList listbox2 = new JList(model);
    JScrollPane scrollPane2 = new JScrollPane(listbox2);

    // bei Doppelklick soll das Element gelscht werden
    MouseListener mouseListener = new MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        JList list = (JList) e.getSource();
        if (e.getClickCount() == 2) {
          int index = list.locationToIndex(e.getPoint());
          // hier ndert der MouseListener (Controller) das Modell 
          if (index > -1) model.removeElementAt(index);
        }
      }
    };

    listbox1.addMouseListener(mouseListener);
    listbox2.addMouseListener(mouseListener);

	 JButton button = new JButton("Hinzufgen");

    // Der ActionListener fgt den Text der Liste hinzu und lscht 
    // das Textfeld. 

    ActionListener buttonActionListener = new ActionListener() {
      public void actionPerformed(ActionEvent e) {
         model.addElement(inputField.getText());
         inputField.setText("");
      }
    };
    button.addActionListener(buttonActionListener);

    JTextField countField = new JTextField();

    // Adapterklasse erzeugen
    CountFieldAdapter adapter = new CountFieldAdapter(model, countField);

    // Hinzufgen der Komponenten zum Panel
    add(inputField);
	 add(button);
    add(scrollPane1);
    add(scrollPane2);
    add(countField);
  }

  public static void main(String s[]) {
    MVCListenBeispiel panel = new MVCListenBeispiel();
	 frame = new JFrame("MVC-Listenbeispiel");

    // damit das Programm beendet wird,
    // wenn das Fenster geschlossen wird
	 frame.addWindowListener(new WindowAdapter() {
	     public void windowClosing(WindowEvent e) {System.exit(0);}
	 });

	 frame.getContentPane().add("Center", panel);
	 frame.pack();
	 frame.setVisible(true);
  }
}
