import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.table.*;
import java.util.*;

public class TableBeispiel extends JPanel {
  static JFrame frame;

  public TableBeispiel() {
   
    // Setzen des Layoutmanagers, ordnet die Komponenten 
    // von oben nach unten an
    setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
    final RestaurantModel model = new RestaurantModel();
    JTable table = new JTable(model);
    table.setRowHeight(60);
    JScrollPane scrollpane = JTable.createScrollPaneForTable(table);

    // Laden der Icons, diese sind im Swing-Verzeichnis unter
    // examples/swingset/classes/images/food zu finden
    ImageIcon icon[] = new ImageIcon[9];
    icon[0] = new ImageIcon("food/burger.gif", "Burger");
    icon[1] = new ImageIcon("food/pizza.gif", "Pizza");
    icon[2] = new ImageIcon("food/hotdog.gif", "Hotdog");
    icon[3] = new ImageIcon("food/banana.gif", "Bananen");
    icon[4] = new ImageIcon("food/broccoli.gif", "Brokoli");
    icon[5] = new ImageIcon("food/cake.gif", "Kuchen");
    icon[6] = new ImageIcon("food/cantaloupe.gif", "Melone");
    icon[7] = new ImageIcon("food/carrot.gif", "Karotten");
    icon[8] = new ImageIcon("food/donut.gif", "Donuts");

    // Nun fr die erste Spalte den Editor und den Renderer ndern
    LookUpCellEditor editor = new LookUpCellEditor(new ImageDropDownBox(icon));
    LookUpCellRenderer renderer = new LookUpCellRenderer(new JLabel(), icon);

    table.getColumnModel().getColumn(1).setCellEditor(editor);
    table.getColumnModel().getColumn(1).setCellRenderer(renderer);

    // Druck auf Knopf erzeugt neuen Datensatz
    JButton button = new JButton("Neu");
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
         model.addRow();
      }
    });

    // Komponenten auf das Formular
    add(scrollpane);
    add(button);

  }

  public static void main(String s[]) {
    TableBeispiel panel = new TableBeispiel();
	 frame = new JFrame("Tablebeispiel");

    // damit das Programm beendet wird,
    // wenn das Fenster geschlossen wird
	 frame.addWindowListener(new WindowAdapter() {
	     public void windowClosing(WindowEvent e) {System.exit(0);}
	 });

	 frame.getContentPane().add("Center", panel);
	 frame.pack();
	 frame.setVisible(true);
  }
}
