
procedure AutoIncSetup(for_read:boolean);
// AutoInc vorbereiten: Lnge, Start an SPI bermitteln
begin
  lo(FPGAreg):=AutoIncReg+1;  // Schreib-Register Core-Select
  SendFPGAreg;
  FPGAsendbyte:=AutoIncSel; // AutoIncSel-Ziel ans FPGA, resettet Auto-Increment
  SendFPGA8;
  if for_read then
    hi(FPGAreg):=$80;
    lo(FPGAreg):=AutoIncReg+3;  // Lesen triggern, SubCh 131
    SendFPGAreg;
    FPGAsendLong:=AutoIncBlockStart; // AutoIncBlockStart ans FPGA, resettet Auto-Increment
    SendFPGA32;
    hi(FPGAreg):=0;
    lo(FPGAreg):=AutoIncReg;  // Schreib-Register Daten fr DAT-Files
    SendFPGAreg;
  else
    hi(FPGAreg):=$80;
    lo(FPGAreg):=AutoIncReg+2;  // Schreib-Register Startadresse, SubCh 130
    SendFPGAreg;
    FPGAsendLong:=AutoIncBlockStart; // AutoIncBlockStart ans FPGA, resettet Auto-Increment
    SendFPGA32;
    hi(FPGAreg):=$80;
    lo(FPGAreg):=AutoIncReg;  // Schreib-Register Daten fr DAT-Files
    SendFPGAreg;
  endif;
end;

procedure AutoIncReset;
// AutoInc zurcksetzen, Core freigeben
begin
  hi(FPGAreg):=$80;
  lo(FPGAreg):=AutoIncReg+1;  // Schreib-Register Adress-Reset
  SendFPGAreg;
  FPGAsendByte:=0; // resettet Core Select
  SendFPGA8;
end;


procedure MEMload(myMEMfileName:String[12]; myHEXmode:Boolean);
// liest MEM-Datei von SD- oder MMC-Karte und bertrgt in SPI-Register AutoIncReg
begin
  ReadErr:=true;
  if CardOK and F16_FileExist ('\', myMEMfileName, faFilesOnly) then
    F16_FileAssign (MemFile, '',myMEMfileName);
    F16_FileReset (MemFile); // Datei zum Lesen ffnen
    AutoIncSetup(false);
    while (not ButtonPressed) and (not F16_EndOfFile(MemFile)) do // read the entire file
      ReadLn(MemFile,SerInpStr);
      if (SerInpStr[1]<>'@') and (length(SerInpStr)>1) then
      // Hex- ode Dezimal-String lesen, wandeln und senden
        if myHEXmode then  // Hex-Zahlen
          FPGAsendLong:=hexToInt(SerInpStr);
        else
          FPGAsendLong:=StrToInt(SerInpStr);
        endif;
        SendFPGA32;
      endif;
    endwhile; // until end of file
    AutoIncReset;
    F16_FileClose (MemFile);
    ReadErr:=false;
  endif;
  NoCard:=not CardOK;
end;


procedure DATload(myDATfileName:String[12]);
var BytesRead, aWord: Word;
    myFilePos: longWord;
begin
  ReadErr:=true;
  if CardOK and F16_FileExist ('\', myDATfileName, faFilesOnly) then
    F16_FileAssign (BinFile, '',myDATfileName);
    F16_FileReset (BinFile); // Datei zum Lesen ffnen
    AutoIncSetup(false);  // Schreib-Register Daten fr DAT-Files
    while not F16_EndOfFile (BinFile) do // read the entire file
      F16_BlockRead (BinFile, @BlockArray, 256, BytesRead);
      if BytesRead>0 then
        case AutoIncWidth of
        2: // DAT aus Words, Little-Endian-Folge
          FPGAsendLong:=0;
          for aWord:=0 to ((BytesRead-2) shr 1) do
            FPGAsendWord:=BlockArray2[byte(aWord)];
            SendFPGA16;  // nur Word-Breite, soll Auto-Inkrement der Adresse ausfhren!
          endfor;
        |
        4: // DAT aus LongWords, Little-Endian-Folge
          for aWord:=0 to ((BytesRead-4) shr 2) do
            FPGAsendLong:=BlockArray4[byte(aWord)];
            SendFPGA32;  // volle Breite, soll Auto-Inkrement der Adresse ausfhren!
          endfor;
        |
        else
          for aWord:=0 to BytesRead-1 do
            FPGAsendByte:=BlockArray[byte(aWord)];
            SendFPGA8;  // nur Byte-Breite, soll Auto-Inkrement der Adresse ausfhren!
          endfor;
        endcase;
      endif;
    endwhile; // until end of file
    F16_FileClose (BinFile);
    ReadErr:=false;
    AutoIncReset;
    mdelay(20); // Erholzeit fr T65-Core
  endif;
  NoCard:=not CardOK;
end;

procedure InitLoad(myfileName:String[12]);
// liest Datei von SD- oder MMC-Karte und interpretiert Befehle nach
// c't-Lab-Syntax
var
  WaitLoops:Integer; verboseSave:Boolean;
  myFileExt:String[3];
begin
  TerminateFlag:=false;
  myFileExt:=ExtractFileExt(myfileName);
  if myFileExt<>'INI' then
    return;
  endif;
  RunningMsg;
  for i:=0 to 31 do
    LabelValidArray[i]:=false;
  endfor;
  LEDactivity:=low;
  verboseSave:=verbose;
  ReadErr:=true;
  LabelSeek:=false;
  GetWaitFlag:=false;
  if CardOK then
    BusyFlag:=true;
    if F16_FileExist ('\', myfileName, faFilesOnly) then
      F16_FileAssign (InitFile, '',myfileName);
      F16_FileReset (InitFile); // Datei zum Lesen ffnen
      INITfileIsOpen:=true;
      TerminateFlag:= TerminateFlag or ButtonPressed;
      while (not TerminateFlag) and (not F16_EndOfFile(InitFile)) do // read the entire file
        ReadLn(InitFile,SerInpStr);
        if SerInpStr[1]<>'/' then
          ParseSubCh;
          RunningMsg;
        endif;
        SerInpStr:='';
        if serstat then
          CheckSer;
        endif;
        Waitloops:=GetTimeout;
        TerminateFlag:= TerminateFlag or ButtonPressed;
        while ((not TerminateFlag) and GetWaitFlag and (Waitloops>0)) do // auf Antwort warten
          CheckSer;
          dec(Waitloops);
        endwhile;
        GetWaitFlag:=false; // nach Timeout
      endwhile; // until end of file
      F16_FileClose (InitFile);
      SerInpStr:='';
      ReadErr:=false;
    endif;
  endif;
  INITfileIsOpen:=false;
  GetWaitFlag:=false; // nach Timeout
  LabelSeek:=false;
  BusyFlag:=false;
  NoCard:=not CardOK;
  verbose:=verboseSave;
  RunningMsgOff;
end;

{###########################################################################}

procedure DispBitCount;
begin
  if isSystimerzero(DisplayTimer)then
    setsystimer(DisplayTimer, 20);
    if LCDpresent then
      LCDxy_M(LCD_m1, 0, 0);
      write(LCDOut_M, LongToStr(BitCount : 8));
      LCDclrEOL_m(LCD_m1);
    endif;
    write(serout, '.');
  endif;
end;

procedure writeF16err(my_err:tDiskError);
begin
 if my_err <> deNone then
   Write(serout,'*');
   Write(serout,bytetostr(byte(my_err)));
   Write(serout,' ');
 endif;
end;

procedure FPGAload(myBinFileName:String[12]);
// liest Datei "FPGAn.bin" von SD- oder MMC-Karte und programmiert
// Spartan-3-FPGA ber SPI damit

var firstBlock, FPGAresponse: Boolean;
  F16_err: tDiskError;
  BytesRead:word;

begin
  TerminateFlag:=false;
  FPGAresponse:=false;
  BitCount:=0;
  ReadErr:=false;
  ConfErr:=false;
  if CardOK then
    if F16_FileExist ('\', myBinFileName, faFilesOnly) then
      SubCh:= 240;
      WriteChPrefix;
      write(serout, '0 [Config FPGA ');
      write(serout, myBinFileName);
      write(serout, ' ');
      LastBinFileNum:=FileNum; // Binrdateinummer merken
      F16_FileAssign (BinFile, '',myBinFileName);
      F16_err:=F16_GetDiskError;
      writeF16err(F16_err);
      F16_FileReset (BinFile); // Datei zum Lesen ffnen
      F16_err:=F16_GetDiskError;
      writeF16err(F16_err);
      firstBlock:=true;
      while not F16_EndOfFile (BinFile) do // read the entire file
        F16_BlockRead (BinFile, @BlockArray, 256, BytesRead);
//        F16_err:=F16_GetDiskError;
//        writeF16err(F16_err);
        if firstBlock then
          FPGA_PROG:=low;
          udelay(1);
          FPGA_PROG:=high;
          mdelay(10);     // Setup-Zeit FPGA Spartan-3
          if not FPGA_Done then
            FPGAresponse:=true;
          endif;
          if LCDpresent then
            LCDxy_M(LCD_m1, 0, 1);
            Write(LCDOut_M, 'BitCount');
            LCDxy_M(LCD_m1, 0, 0);
            LCDclrEOL_m(LCD_m1);
            setsystimer(DisplayTimer,10);
          endif;
          firstBlock:=false;
        endif;
        ShiftFPGAconfblock;
        BitCount:= BitCount +2048;
        DispBitCount;
        if FPGA_Done then break; endif;
      endwhile; // until end of file
      setsystimer(DisplayTimer,100);
      FPGAbyte:= 255;  // Wichtig: noch ein paar CCLK-Impulse nachschieben
      ShiftFPGAconf;
      F16_FileClose (BinFile);
      writeln(serout, ']');
      if (not FPGAresponse) or (not FPGA_DONE) then
        WriteChPrefix;
        write(serout, '-5 [Config failed');
        if not FPGAresponse then
          writeln(serout, ' - no response]');
        else
          writeln(serout, ' - no DONE]');
        endif;
        if LCDpresent then
          LCDxy_M(LCD_m1, 0, 0);
          write(LCDOut_M, 'ConfFail');
          mdelay(200);
          setsystimer(DisplayTimer, 200);
        endif;
        ConfErr:= true;
      endif;
    else
      if LCDpresent then
        LCDxy_M(LCD_m1, 0, 0);
        Write(LCDOut_M, 'NotFound');
        setsystimer(DisplayTimer,200);
      endif;
      ReadErr:=true;
    endif;
  endif;
  NoCard:=not CardOK;
  // Conf-Bits werden als F_RS/REGSEL und F_DS/DATASEL weiterbenutzt
  PA4:= high;
  PA5:= high;
end;



procedure FileLoad(myLoadfileName:String[12]);
// ldt File je nach Extension in das FPGA oder ins AutoInc-RAM

var myFileExt:String[3]; myFileName:String[8]; myReadErr:Boolean;
begin
  SubCh:= 240;
  myFileExt:=ExtractFileExt(myLoadfileName);
  myFileName:=ExtractFileName(myLoadfileName);
  LEDactivity:=low;
  myReadErr:=true;
  if (myFileExt='BIN') or (myFileExt='BIT') then
    FPGAload(myLoadfileName);
    myReadErr:=ReadErr;
  endif;
  if myFileExt='INI' then
    InitLoad(myLoadfileName);
    myReadErr:=ReadErr;
  endif;
  if myFileExt='DAT' then
    // AutoIncReg muss manuell gesetzt sein, sonst Default Register/SubCh 128
    DATload(myLoadfileName);
    myReadErr:=ReadErr;
  endif;
  if myFileExt='MEM' then
    // AutoIncReg muss manuell gesetzt sein, sonst Default Register/SubCh 128
    MEMload(myLoadfileName,true);
    myReadErr:=ReadErr;
  endif;
  if myFileExt='DEC' then
    // AutoIncReg muss manuell gesetzt sein, sonst Default Register/SubCh 128
    MEMload(myLoadfileName,false);
    myReadErr:=ReadErr;
  endif;
  RunningMsg;
  ReadErr:=myReadErr;
end;

