;
;---------------------------------------------------------------------
; DSP56002 Demonstration Program
;---------------------------------------------------------------------
; 
;  The program does the following:
;    1. clear accumulator A
;    2. increment A
;    3. save A (A2, A1, AND A0)
;    4. goto 2.
;    5. end of program
;
;---------------------------------------------------------------------

        org     x:0                     ; Data block starts at zero
VALUE_A2        dc      0               ; define storage for A2
VALUE_A1        dc      0               ; define storage for A1 
VALUE_A0        dc      0               ; define storage for A0 
;
;---------------------------------------------------------------------
;                
        org     p:$0000                 ; Program block starts at zero
RESET   jmp     START                   ; Skip over interrupt vectors
        org     p:$0040 
START   clr     a                       ; Clear accumulator A
LOOP    inc     a                       ; increment accumulator A
        move    a2,x:VALUE_A2           ; Save A2
        move    a1,x:VALUE_A1           ; Save A1
        move    a0,x:VALUE_A0           ; Save A0
        jmp     LOOP                    ; Loop to increment again
        end
;
;---------------------------------------------------------------------
;
