;----------------------------------------------------------------------------
; Demonstration program for the LINK-56K
; The program amplitude modulates a sine wave with a ramp wave
;----------------------------------------------------------------------------
;
; To demonstrate this program with LINK-56K do the following:
;       .  Load DEMO2.CLD
;       .  Open a data window
;       .  Display the data window from location 0
;       .  Display the data window in DEC or FRA
;       .  Put LINK-56K in continous data-window update mode (UPD:ON) (F6)
;       .  Run the DSP
;       .  Display the data window graphically
;       .  Scroll the window to show the ramp and the amplitude
;
;----------------------------------------------------------------------------
	page    132,66,0,10
;----------------------------------------------------------------------------
;
;------------------------- Macro definitions --------------------------------
MIX     MACRO
	move    x:(r0)+,x1
	mpy     x1,x0,a                 ; MIXER
	move    a,x:(r1)+
	ENDM

WAIT_M  MACRO
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	ENDM

;--------------------------- MEMORY DECLARATION -----------------------------
;
; Data storage
;
	  org x:0
AM_WAVE                                 ;    Amplitude modulation block
	  dc       0.000000000
	  dc       0.195090324
	  dc       0.382683426
	  dc       0.555570245
	  dc       0.707106769
	  dc       0.831469595
	  dc       0.923879504
	  dc       0.980785251
	  dc       0.999999999
	  dc       0.980785251
	  dc       0.923879504
	  dc       0.831469595
	  dc       0.707106769
	  dc       0.555570245
	  dc       0.382683426
	  dc       0.195090324
	  dc       0.000000000
	  dc      -0.195090324
	  dc      -0.382683426
	  dc      -0.555570245
	  dc      -0.707106769
	  dc      -0.831469595
	  dc      -0.923879504
	  dc      -0.980785251
	  dc      -1.000000000
	  dc      -0.980785251
	  dc      -0.923879504
	  dc      -0.831469595
	  dc      -0.707106769
	  dc      -0.555570245
	  dc      -0.382683426
	  dc      -0.195090324
     
SINTBL                                  ;    32 POINT SINE TABLE     
	  dc       0.000000000
	  dc       0.195090324
	  dc       0.382683426
	  dc       0.555570245
	  dc       0.707106769
	  dc       0.831469595
	  dc       0.923879504
	  dc       0.980785251
	  dc       0.999999999
	  dc       0.980785251
	  dc       0.923879504
	  dc       0.831469595
	  dc       0.707106769
	  dc       0.555570245
	  dc       0.382683426
	  dc       0.195090324
	  dc       0.000000000
	  dc      -0.195090324
	  dc      -0.382683426
	  dc      -0.555570245
	  dc      -0.707106769
	  dc      -0.831469595
	  dc      -0.923879504
	  dc      -0.980785251
	  dc      -1.000000000
	  dc      -0.980785251
	  dc      -0.923879504
	  dc      -0.831469595
	  dc      -0.707106769
	  dc      -0.555570245
	  dc      -0.382683426
	  dc      -0.195090324

RAMP                        ;    32 POINT RAMP TABLE
       dc        0*255      ;    positive slope area
       dc     2048*255        
       dc     4096*255        
       dc     6144*255        
       dc     8192*255        
       dc    10240*255        
       dc    12288*255        
       dc    14336*255        
       dc    16384*255        
       dc    18432*255        
       dc    20480*255        
       dc    22528*255        
       dc    24576*255        
       dc    26624*255        
       dc    28672*255        
       dc    30720*255              
       dc    31744*255        
       dc    29696*255          ; Negative slope area
       dc    27648*255        
       dc    25500*255        
       dc    23552*255        
       dc    21504*255        
       dc    19456*255        
       dc    17408*255        
       dc    15360*255        
       dc    13312*255        
       dc    11264*255        
       dc     9216*255        
       dc     7168*255        
       dc     5120*255        
       dc     3072*255        
       dc     1024*255        

AM_VALUE  dc    0               ; AMPLIDUDE VALUE
	  dc    0
SPEED     dc    2000           ; USED TO CONTROL WAIT LOOP
;
;----------------------------------------------------------------------------
;
; MODULATE SINE CYCLE WITH RAMP CYCLE
	ORG	p:$0                    
RESET:
        jmp     START                   ; SKIP OVER INTERRUPT VECTORS

	ORG     p:$40
START:
	jsr     initialize              ; INITIALIZE POINTERS
;
LOOP:
	do      #32,end2                ; MODULATE FULL SINE CYCLE
	jsr     WAIT        
	move    x:(r2)+,x0
	move    x0,x:AM_VALUE
	do      #32,end1
	MIX
end1:
	nop
end2:
	nop                       

	do      #32,end3                ; DO FOR NEGATIVE RAMP
	jsr     WAIT        
	move    x:(r2)+,b
	neg     b
	move    b,x0
	move    x0,x:AM_VALUE
	do      #32,end4
	MIX
end4:
	nop
end3:
	nop                       
	jmp     LOOP                    ; START AGAIN FOR ANOTHER CYCLE
;
;
;----------------------------------------------------------------------------
;
initialize:   
	MOVE    #>0,SR
	move    #>SINTBL,r0             ; POINTER TO STATIC SINE CYCLE
	move    #>31,m0
	move    #>AM_WAVE,r1            ; POINTER TO DYNAMIC SINE CYCLE
	move    #>31,m1
	move    #>RAMP,r2               ; POINTER TO RAMP
	move    #>31,m2
	rts
;
;----------------------------------------------------------------------------
;
WAIT:
	move    x:SPEED,x1
	do      x1,end_wait
	WAIT_M
	WAIT_M
end_wait:
	rts
;----------------------------------------------------------------------------
	end  
