/*=======================================================================*/
/*   evmtest.c - utility to evaluate ASCII data files from EVM tests     */
/*                  quick and VERRRRRRRRY DIRTY                          */
/*   16 October 1994: RLR   Original                                     */
/*   03 March   1995: RLR   remind user of need for external loopback    */
/*=======================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <conio.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <math.h>


char  hex2char(unsigned char  num);
int   char2hex(         char  kar);
int   data_in (void);
int   get_ascBuff(long *buff);
void  mag_Buff(long *Lbuff, float *Fmags);
int   test(float *Fbuff, float *REF, char *Flags);
FILE  *fopen(), *hdev, *sdev;

void
  main()
{
 char   serial[6],command[20],fname[20];       /* input file name           */
 long	Lbuff[30];
 float  Fmags[30];
 char   *str_now;
 long   secs_now;
 int    i,FailFlag;
 char   Flags[20];

 float REF[] = {   10.0, /*  DC Offset   */
		   10.0, /*  noise       */
		  -20.0, /*   24    kHz  */
		   -6.0, /*>   6    kHz  */
		   -6.0, /*>   1.5  kHz  */
		   -6.0, /*>     375 Hz  */
		   -6.0, /*>      94 Hz  */
		    0.0, /*       23 Hz  */
		    0.0, /*       12 Hz  */
		  -20.0  /*        6 Hz  */
               };

 printf (" --- EVMTEST Version 950411 ---\n\n");
 printf ("---------------------------------------------------------------\n");
 printf (" --- INSTALL LOOPBACK CABLE  between Audio IN and Audio OUT ---\n");
 printf ("---------------------------------------------------------------\n");
 system ("pause");
 system ("del temp.log");
 system  ("evm56k fltr_tst");

 printf (" EVM Serial No:   ");
 scanf  ("%s",serial);                 /* get serial no. of board   */
 strcpy (fname,serial);
 strcat(fname,".tst");                 /* build output file name    */
 sdev = fopen("temp.log","rt");        /* open the input file       */
 hdev = fopen(fname,"at");             /* append to output file     */

 time(&secs_now);
 str_now = ctime(&secs_now);
/*------------------------------------------------------------------*/
/* Here we convert ASCII input data  */
/*------------------------------------------------------------------*/

 get_ascBuff(Lbuff);                              /* get raw_data   */
 for (i=0; i<20; i++)
    Lbuff[i] = Lbuff[i]>>8;
 mag_Buff(Lbuff,Fmags);                /* convert to floating pt dB */
 FailFlag = test(Fmags,REF,Flags);

 fprintf(hdev,"\n________________________________________________________________\n");
 fprintf(hdev,"\n -- DSP56002EVM Performance Analysis    Ver.1.2 --");
 fprintf(hdev,"\n EVM Serial No.: %s             %s",serial,str_now);
 fprintf(hdev,"\n                 LEFT       RIGHT   --dB below MAX--");
 fprintf(hdev,"\n________________________________________________________________");
 fprintf(hdev,"\nDC Offset :     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[0], Lbuff[1], Fmags[0], Fmags[1], REF[0],Flags[0], Flags[1]);
 fprintf(hdev,"\nNOISE     :     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[2], Lbuff[3], Fmags[2], Fmags[3], REF[1],Flags[2], Flags[3]);
 fprintf(hdev,"\n24     kHz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[4], Lbuff[5], Fmags[4], Fmags[5], REF[2],Flags[4], Flags[5]);
 fprintf(hdev,"\n 6     kHz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[6], Lbuff[7], Fmags[6], Fmags[7], REF[3],Flags[6], Flags[7]);
 fprintf(hdev,"\n 1.5   kHz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[8], Lbuff[9], Fmags[8], Fmags[9], REF[4],Flags[8], Flags[9]);
 fprintf(hdev,"\n   375  Hz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[10],Lbuff[11],Fmags[10],Fmags[11],REF[5],Flags[10],Flags[11]);
 fprintf(hdev,"\n    94  Hz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[12],Lbuff[13],Fmags[12],Fmags[13],REF[6],Flags[12],Flags[13]);
 fprintf(hdev,"\n    23  Hz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[14],Lbuff[15],Fmags[14],Fmags[15],REF[7],Flags[14],Flags[15]);
 fprintf(hdev,"\n    12  Hz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[16],Lbuff[17],Fmags[16],Fmags[17],REF[8],Flags[16],Flags[17]);
 fprintf(hdev,"\n     6  Hz:     %6ld    %6ld    %6.2f  %6.2f      %6.2f%c%c",Lbuff[18],Lbuff[19],Fmags[18],Fmags[19],REF[9],Flags[18],Flags[19]);
 fprintf(hdev,"\n");
 fprintf(hdev,"\n Pass:  %4ld      Address:   X:%04lX  Y:%04lX",Lbuff[24],Lbuff[20],Lbuff[20]);
 fprintf(hdev,"\n                  Expected:  %06lX  %06lX",Lbuff[21],Lbuff[21]);
 fprintf(hdev,"\n                  Received:  %06lX  %06lX",Lbuff[22],Lbuff[23]);
 if (Lbuff [20] != 0)
    fprintf(hdev,"\n\a %6d MEMORY ERRORS FOUND!  (check J12 is in 16k position) \n");

 if (FailFlag == 0)
    fprintf(hdev,"\n -------- PASS ------\n");
 else
    fprintf(hdev,"\n\a *** FAIL *** FAIL *** FAIL *** FAIL *** \a\n");

 fclose(sdev);                         /* close source file...      */
 fclose(hdev);                         /* close results file        */

 command[0] = '\0';
 strcat (command,"type ");
 strcat (command,fname);
 system (command);
}

/*=======================================================================*/
/*    look for the X:0080 string to find the start of the data, then     */
/*    read the ASCII data into a buffer of long ints.  If EOF is found,  */
/*    inform the caller.                                                 */
/*=======================================================================*/
int  get_ascBuff(long *buff)

{
     int	i=0;
     char	stmp[80];

     do	{			       /* look for first data word  */
	if( fscanf(sdev,"%s",&stmp) == EOF)
	   return(-1);                 /* return if EOF found early */
	}  while ( (stmp[0] != 'X') | (stmp[1] != ':') );

/*  now, get the data and convert from ASCII to long		   */
/*  NOTE that intervening address strings are read as zero         */

     for (i=0; i<8; i++)
	 fscanf(sdev,"%X",&buff[i]);
     fscanf(sdev,"%s",&stmp);

     for (i=8; i<16; i++)
	 fscanf(sdev,"%X",&buff[i]);
     fscanf(sdev,"%s",&stmp);

     for (i=16; i<24; i++)
	 fscanf(sdev,"%X",&buff[i]);
     fscanf(sdev,"%s",&stmp);

     if( fscanf(sdev, "%X",&buff[i]) == EOF)
	return(-1);
     return(i);
}

/*********************************************************************/
void mag_Buff (long *samp, float *fbuff)
{
 int     i;
 double  dsamp,dtemp,dmax_val=32767.0;
 float   ftemp;

 for (i=0; i<22; i++)
 {
 dsamp = (double)samp[i];
 dtemp = dsamp/dmax_val;
 if (dtemp <  0.0)
     dtemp = -dtemp;
 if (dtemp != 0.0)
     dtemp  = 20.0 * log10(dtemp);
 ftemp = (float)dtemp;
 fbuff[i] = ftemp;
 }
  dtemp     = (double) fbuff[2];       /* get rms of noise values */
  if (dtemp < 0.0)
      dtemp = -dtemp;
  dtemp     = sqrt (dtemp);
  fbuff[2]  = (float) dtemp;

  dtemp     = (double) fbuff[3];
  if (dtemp < 0.0)
      dtemp = -dtemp;
  dtemp     = sqrt (dtemp);
  fbuff[3]  = (float) dtemp;
}
/******************************************************************/
int test(float *Fbuff, float *REF, char *Flags)
{
   int  i,j;

	for (i=0; i<20; i++)                /* clear all flags       */
       Flags[i] = ' ';

	i=0;

   if (Fbuff[0]  >= REF[i])     Flags[0] = ' ';  /*  left DC Offset   */
   if (Fbuff[1]  >= REF[i++])   Flags[1] = ' ';  /* right DC Offset   */
   if (Fbuff[2]  >= REF[i])     Flags[2] = ' ';  /*  left noise       */
   if (Fbuff[3]  >= REF[i++])   Flags[3] = ' ';  /* right noise       */
   if (Fbuff[4]  >= REF[i])     Flags[4] = '*';  /*  left  24    kHz  */
   if (Fbuff[5]  >= REF[i++])   Flags[5] = '*';  /* right  24    kHz  */
   if (Fbuff[6]  <= REF[i])     Flags[6] = '*';  /*  left   6    kHz  */
   if (Fbuff[7]  <= REF[i++])   Flags[7] = '*';  /* right   6    kHz  */
   if (Fbuff[8]  <= REF[i])     Flags[8] = '*';  /*  left   1.5  kHz  */
   if (Fbuff[9]  <= REF[i++])   Flags[9] = '*';  /* right   1.5  kHz  */
   if (Fbuff[10] <= REF[i])     Flags[10] = '*';  /*  left     375 Hz  */
   if (Fbuff[11] <= REF[i++])   Flags[11] = '*';  /* right     375 Hz  */
   if (Fbuff[12] <= REF[i])     Flags[12] = '*';  /*  left      94 Hz  */
   if (Fbuff[13] <= REF[i++])   Flags[13] = '*';  /* right      94 Hz  */
   if (Fbuff[14] >= REF[i])     Flags[14] = ' ';  /*  left      23 Hz  */
   if (Fbuff[15] >= REF[i++])   Flags[15] = ' ';  /* right      23 Hz  */
   if (Fbuff[16] >= REF[i])     Flags[16] = ' ';  /*  left      12 Hz  */
   if (Fbuff[17] >= REF[i++])   Flags[17] = ' ';  /* right      12 Hz  */
   if (Fbuff[18] >= REF[i])     Flags[18] = '*';  /*  left       6 Hz  */
   if (Fbuff[19] >= REF[i++])   Flags[19] = '*';  /* right       6 Hz  */

   for (i=0,j=0; i<20; i++)
      if (Flags[i] == '*')	 j = 1;

	return (j);
}
