	page    132,60
;****************************************************************************
;	FLTR_TST.ASM
;	Test program for the external memory, analog circuitry, and OnCE
;	Port circuitry of the DSP56002EVM evaluation board
;
;	Copywrite (c) MOTOROLA 1994
;		      Semiconductor Products Sector 
;		      Digital Signal Processing Division
;
;****************************************************************************
;
;

Fs      set     48000.0                         ;Specify sampling frequency.
PI      set     2.0*@asn(1.0)                   ;Compute PI as 2.0*arcsin(1.0)
factor  set     PI/180.0                        ;Multiplier for degrees to radians

; Specification for tone a.
freq_a  set     Fs/2.0                        ;Specify frequency in Hertz.
phi_a   set     360.0*(freq_a/Fs)               ;Compute phi
phase_a set     90.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_a   set     0.8                             ;Specify amplitude (0-1).
theta2_a        set     (phase_a-(2.0*phi_a))   ;Compute theta2
theta1_a        set     (phase_a-phi_a)         ;Compute theta1
s2_a    set     amp_a*@sin(factor*theta2_a)     ;Compute s2
s1_a    set     amp_a*@sin(factor*theta1_a)     ;Compute s1
coeff_a set     @cos(factor*phi_a)              ;Compute rcoef in 2:14 format

; Specification for tone b.
freq_b  set     Fs/8.0                         ;Specify frequency in Hertz.
phi_b   set     360.0*(freq_b/Fs)               ;Compute phi
phase_b set     0.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_b   set     0.8                             ;Specify amplitude (0-1).
theta2_b        set     (phase_b-(2.0*phi_b))   ;Compute theta2
theta1_b        set     (phase_b-phi_b)         ;Compute theta1
s2_b    set     amp_b*@sin(factor*theta2_b)     ;Compute s2
s1_b    set     amp_b*@sin(factor*theta1_b)     ;Compute s1
coeff_b set     @cos(factor*phi_b)              ;Compute rcoef in 2:14 format

; Specification for tone c.
freq_c  set     Fs/32.0                          ;Specify frequency in Hertz.
phi_c   set     360.0*(freq_c/Fs)               ;Compute phi
phase_c set     90.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_c   set     0.8                             ;Specify amplitude (0-1).
theta2_c        set     (phase_c-(2.0*phi_c))   ;Compute theta2
theta1_c        set     (phase_c-phi_c)         ;Compute theta1
s2_c    set     amp_c*@sin(factor*theta2_c)     ;Compute s2
s1_c    set     amp_c*@sin(factor*theta1_c)     ;Compute s1
coeff_c set     @cos(factor*phi_c)              ;Compute rcoef in 2:14 format

; Specification for tone d.
freq_d  set     Fs/128.0                        ;Specify frequency in Hertz.
phi_d   set     360.0*(freq_d/Fs)               ;Compute phi
phase_d set     0.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_d   set     0.8                             ;Specify amplitude (0-1).
theta2_d        set     (phase_d-(2.0*phi_d))   ;Compute theta2
theta1_d        set     (phase_d-phi_d)         ;Compute theta1
s2_d    set     amp_d*@sin(factor*theta2_d)     ;Compute s2
s1_d    set     amp_d*@sin(factor*theta1_d)     ;Compute s1
coeff_d set     @cos(factor*phi_d)              ;Compute rcoef in 2:14 format

; Specification for tone e.
freq_e  set     Fs/512.0                         ;Specify frequency in Hertz.
phi_e   set     360.0*(freq_e/Fs)               ;Compute phi
phase_e set     0.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_e   set     0.8                             ;Specify amplitude (0-1).
theta2_e        set     (phase_e-(2.0*phi_e))   ;Compute theta2
theta1_e        set     (phase_e-phi_e)         ;Compute theta1
s2_e    set     amp_e*@sin(factor*theta2_e)     ;Compute s2
s1_e    set     amp_e*@sin(factor*theta1_e)     ;Compute s1
coeff_e set     @cos(factor*phi_e)              ;Compute rcoef in 2:14 format

; Specification for tone f.
freq_f  set     Fs/2048.0                          ;Specify frequency in Hertz.
phi_f   set     360.0*(freq_f/Fs)               ;Compute phi
phase_f set     0.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_f   set     0.8                             ;Specify amplitude (0-1).
theta2_f        set     (phase_f-(2.0*phi_f))   ;Compute theta2
theta1_f        set     (phase_f-phi_f)         ;Compute theta1
s2_f    set     amp_f*@sin(factor*theta2_f)     ;Compute s2
s1_f    set     amp_f*@sin(factor*theta1_f)     ;Compute s1
coeff_f set     @cos(factor*phi_f)              ;Compute rcoef in 2:14 format

; Specification for tone g.
freq_g  set     Fs/4096.0                         ;Specify frequency in Hertz.
phi_g   set     360.0*(freq_g/Fs)               ;Compute phi
phase_g set     0.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_g   set     0.8                             ;Specify amplitude (0-1).
theta2_g        set     (phase_g-(2.0*phi_g))   ;Compute theta2
theta1_g        set     (phase_g-phi_g)         ;Compute theta1
s2_g    set     amp_g*@sin(factor*theta2_g)     ;Compute s2
s1_g    set     amp_g*@sin(factor*theta1_g)     ;Compute s1
coeff_g set     @cos(factor*phi_g)              ;Compute rcoef in 2:14 format

; Specification for tone h.
freq_h  set     Fs/8192.0                          ;Specify frequency in Hertz.
phi_h   set     360.0*(freq_h/Fs)               ;Compute phi
phase_h set     0.0                             ;Specify the phase angle in 
						; degrees (-180 -- +180).
amp_h   set     0.8                             ;Specify amplitude (0-1).
theta2_h        set     (phase_h-(2.0*phi_h))   ;Compute theta2
theta1_h        set     (phase_h-phi_h)         ;Compute theta1
s2_h    set     amp_h*@sin(factor*theta2_h)     ;Compute s2
s1_h    set     amp_h*@sin(factor*theta1_h)     ;Compute s1
coeff_h set     @cos(factor*phi_h)              ;Compute rcoef in 2:14 format
Fs	set	48000

BUFF_BASE       EQU     $100
BUFF_LENGTH     EQU     $2000


	include 'codec.asm'
TONE_OUTPUT	EQU     HEADPHONE_EN+LINEOUT_EN+(0*LEFT_ATTN)+(0*RIGHT_ATTN)   
NOISE_OUTPUT	EQU     HEADPHONE_EN+LINEOUT_EN   
TONE_INPUT	EQU     MIC_IN_SELECT+(15*MONITOR_ATTN)+(4*LEFT_GAIN)+(4*RIGHT_GAIN)
NOISE_INPUT	EQU     MIC_IN_SELECT+(15*MONITOR_ATTN)+(15*LEFT_GAIN)+(15*RIGHT_GAIN)

	org	x:	
DOSC_BUFF_BASE  EQU     *
coeff           ds      1       ; data location for osc. a's coeff.
s1              ds      1       ; data location for osc. a's sr1.
s2              ds      1       ; data location for osc. a's sr2.
LOOP_COUNT      ds      1       ; data location for the loop counter.
LEFT_PEAK       ds      1       ; data location for the peak value.
RIGHT_PEAK      ds      1       ; data location for the peak value.
OUTPUT          EQU     $80
output_data     ds      20      ; 2*8 tone peaks + 2*(peak+average)=20

	org     p:
main
noise_ini
	move    #Fs/4,n1
	move    #$0,x0
	move    x0,x:TX_BUFF_BASE
	move	x0,x:TX_BUFF_BASE+1
	move    #NOISE_OUTPUT,x0        
	move	x0,x:TX_BUFF_BASE+2
	move    #NOISE_INPUT,x0 
	move    x0,x:TX_BUFF_BASE+3
noise_loop1
	do	n1,begin_record
	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.
	nop
begin_record
	move    #$400,n2
	move    #BUFF_BASE,r0           ; Load the base address of buffer
	move    #-1,m0                  ; Linear addressing.
	do	n2,acquire_noise
	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.
	move    x:RX_BUFF_BASE,A	; Load left ch data.
	move    x:RX_BUFF_BASE+1,B
	rep	#8
	asr	A
	rep	#8
	asr	B	
	move	A,x:(r0)		; Store left channel data.
	move    B,y:(r0)+		; Store right channel data.
acquire_noise

	move    #BUFF_BASE,r0           ; Load the base address of buffer
	movep   #$3b00,x:CRB            ; Disable SSI interrupts.
	clr	a	x:(r0),x0 	; load left  channel data sample #1
	clr	b	y:(r0)+,y0	; load right channel data sample #1
	do      n2,sum_loop		; stored in the data buffer.
	add     x0,a    x:(r0)+,x0
	add     y0,b    y:(r0)+,y0
sum_loop

			;---------------------------------
			;  shift to form average
			;---------------------------------
	rep	#10
	asr	A
	rep	#10
	asr	B
	move    a,x:OUTPUT              ; Store the left  average
	move    b,x:OUTPUT+1            ; Store the right average


			;----------------------------------
			; remove DC offset...
			;----------------------------------
	neg	A
	neg	B	A,X0
	move		B,Y0
	move    #BUFF_BASE,r0		; Load the base address of buffer
	do      n2,remove_DC		; stored in the data buffer.
	move		x:(r0),A	; get  left sample
	move		y:(r0),B	; get right sample
	add	x0,a			; subtract DC from samples
	add	y0,b	A,X:(r0)	; ...and save new samples
	move		B,Y:(r0)+
remove_DC
	move    #BUFF_BASE,r0		; Load the base address of buffer
	clr	A
	clr	B
	do	n2,sum_squares
	move		x:(r0),X0
	move		y:(r0),Y0
	move		x0,x1
	move		y0,y1
	mac	x0,x1,a
	mac	y0,y1,b
sum_squares
	move    a,x:OUTPUT+2            ; Store the average value.
	move    b,x:OUTPUT+3            ; Store the peak value.


;--------------------------------------------------------------------------
;	send out tones to test the frequency response of the system
;--------------------------------------------------------------------------	
	movep   #$fb00,x:CRB            ; Enable the SSI interrupts.
	movep   #0,x:$fffe              ; Zero wait state ext. memory.
dosc_a 
	move    #coeff_a,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. a.
	move    #s1_a,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. a.
	move    #s2_a,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. a.
	move    #Fs/4,n1		; Initialize the loop counter
	move    #TONE_OUTPUT,y0		; headphones, line out, mute spkr, no attn.
	move            y0,x:TX_BUFF_BASE+2
	move    #TONE_INPUT,y0		; no input gain, monitor mute
	move            y0,x:TX_BUFF_BASE+3
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	move    #Fs/4,n2                 ; Initialize the loop counter
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+4           ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+5           ; and store in ouptut buffer.

dosc_b 
	move    #coeff_b,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. b.
	move    #s1_b,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. b.
	move    #s2_b,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. b.
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+6           ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+7           ; and store in ouptut buffer.

dosc_c 
	move    #coeff_c,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. c.
	move    #s1_c,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. c.
	move    #s2_c,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. c.
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+8           ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+9           ; and store in ouptut buffer.

dosc_d 
	move    #coeff_d,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. d.
	move    #s1_d,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. d.
	move    #s2_d,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. d.
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+10          ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+11          ; and store in ouptut buffer.

dosc_e 
	move    #coeff_e,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. e.
	move    #s1_e,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. e.
	move    #s2_e,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. e.
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+12          ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+13          ; and store in ouptut buffer.

dosc_f 
	move    #coeff_f,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. f.
	move    #s1_f,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. f.
	move    #s2_f,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. f.
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+14          ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+15          ; and store in ouptut buffer.

dosc_g 
	move    #coeff_g,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. g.
	move    #s1_g,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. g.
	move    #s2_g,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. g.
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+16          ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+17          ; and store in ouptut buffer.

dosc_h 
	move    #coeff_h,x0
	move    x0,x:DOSC_BUFF_BASE        ; Load coeff. for osc. h.
	move    #s1_h,x0
	move    x0,x:DOSC_BUFF_BASE+1      ; Load s1 for osc. h.
	move    #s2_h,x0
	move    x0,x:DOSC_BUFF_BASE+2      ; Load s2 for osc. h.
	jsr     <init_loop               ; Jump to the loop that lets the analog settle.
	jsr     <log_loop                ; Jump to the loop that logs data.
	move    x:LEFT_PEAK,x0          ; Get left channel peak value
	move    x0,x:OUTPUT+18          ; and store in output buffer.
	move    x:RIGHT_PEAK,x0         ; Get right channel peak value
	move    x0,x:OUTPUT+19          ; and store in ouptut buffer.
finished
	movep   #$3b00,x:CRB            ; Disable SSI interrupts.
	jmp	u_memtst		; Jump to memory test.


;*************************************************************************************
init_loop
	do	n1,end_init_loop
	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.
	move    #-1,m0                  ; Linear addressing.
	move    #DOSC_BUFF_BASE,r0      ; Load pointer to osc's coeff, sr1 and sr2
	jsr     <dosc_sin               ; Jump to get next sine value, new value in a.
	move    a,x:TX_BUFF_BASE        ; Put value in left channel tx.
	move    a,x:TX_BUFF_BASE+1      ; Put value in right channel tx.
end_init_loop
	rts

;---------------------------------------------------------------------------
log_loop
	move	#0,x0
	move	x0,x:LEFT_PEAK		; Zero out LEFT_PEAK.
	move	x0,x:RIGHT_PEAK		; Zero out RIGHT_PEAK.
	do	n2,end_log_loop
	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.
	move    x:RX_BUFF_BASE,a        ; Load lft ch data.
	move    x:RX_BUFF_BASE+1,b	; Load rt ch data.
	move    x:LEFT_PEAK,x0          ; Load peak value
	cmpm    x0,a                    ; Compare magnitudes of peak an new sample.
	jle     <left_log_done		; Do nothing if not new peak.
	abs     a                       ; Take magnitude.
	move    a,x:LEFT_PEAK           ; Store new peak magnitude.
left_log_done
	move    x:RIGHT_PEAK,y0         ; Load peak value
	cmpm    y0,b                    ; Compare magnitudes of peak an new sample.
	jle     <right_log_done         ; Do nothing if not new peak.
	abs     b                       ; Take magnitude.
	move    b,x:RIGHT_PEAK          ; Store new peak magnitude.
right_log_done
	move    #-1,m0                  ; Linear addressing.
	move    #DOSC_BUFF_BASE,r0      ; Load pointer to osc's coeff, sr1 and sr2
	jsr     <dosc_sin               ; Jump to get next sine value, new value in a.
	move    a,x:TX_BUFF_BASE        ; Put value in left channel tx.
	move    a,x:TX_BUFF_BASE+1      ; Put value in right channel tx.
end_log_loop
	rts     


;---------------------------------------------------------------------------
; The following subroutine calculates the next sinusoidal output value as a 
; function by the digital oscillator given that r0 points to the memory 
; location that contains the "coeff" value followed by the memory location 
; that contains the "s1" value, followed by the memory location that contains
; the "s2" value.  The formula and block diagram of the oscillator are:
;
;               s1[n] = coeff*s1[n-1] - s2[n-1] = coeff*s1[n-1] - s1[n-2]
;
;                 _______         _______
;                |       |  s1   |       |  s2
;           +--->|  z^-1 |--+--->|  z^-1 |----+
;           |    |_______|  |    |_______|    |
;           |               |                 |
;           |            ___V___           ___V___
;           |           |       |         |       |
;           |           | coeff |         |  -1   |  
;           |           |_______|         |_______|
;           |               |                 |
;           |               |                 |
;           |               |                 |
;           |               +----->( + )<-----+
;           |                        |
;           |                        |
;           +------------------------+---------> sine output
dosc_sin

	move    x:(r0)+,x0              ; Load coeff
	move    x:(r0)+,y0              ; Load s1 into a.
	move    x:(r0)-,b               ; Load s2 into b, r0 points to s1.
	mpy     x0,y0,a                 ;Get coef*s1 in a in 2:14 format
	subl    b,a          ;y0,b      ;Get (coef*s1 -s2)=sin_val in a
					;  in fractional format
	move    a,x:(r0)+               ; Save new s1.
	move    y0,x:(r0)               ; Save new s2.
	rts
	
	include	'u_memtst.asm'		; Include the memory test.
	end
