;sample macro command file
;
;line starting with ";" character is a comment line
;and is skipped during macro execution
;

;initialize radix to hexadecimal
radix hex

;define function key alias to execute reset sequence
alias F11 "force r; wait break; change omr 0"

;wait until DSP gets in debug mode of operation
wait  break

;clear first 16 X memory locations
change x:0#10 0

;initialize memory locations to defined values
change x:1 111111
change x:2 222222
change x:3 333333

;reset DSP
force r
wait break

;set Operating Mode Register
change OMR $0

;load demo program
load demo2

;start execution
go

;start logging commands to the log file (TEST.LOG)
log on test

;stop execution
force b

;wait until DSP gets in debug mode of operation
wait break

;trace next instruction
trace 

;wait until DSP gets in debug mode of operation
wait break

;set breakpoint at the loop start
break LOOP
go
wait break
break off

;log to file first 16 locations of the memory space X
log mem x:0#10

;execute program for a 1 second
log reg PC
go
wait 1
force break
wait break
log reg PC

;log memory again
log mem x:0#10

;disable logging
log off

;view the log file
view TEST.LOG




