/************************************************************************
 *     amp2.c   -- FFT plot support routines                            *
 *                                                                      *
 *	23 Oct. 95 - RLR:  First Relase                                      *
 *                                                                      *
 *       Copyright (c) MOTOROLA 1995											   *
 *                     Semiconductor Products Sector							*
 *                     Digital Signal Processing Division					*
 ************************************************************************/

#ifdef __TINY__
#error BGIDEMO will not run in the tiny model.
#endif

#include <dos.h>
#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <graphics.h>


int    GraphDriver;          /* The Graphics device driver               */
int    GraphMode;            /* The Graphics mode value		         */
double AspectRatio;          /* Aspect ratio of a pixel on the screen    */
int    MaxX, MaxY;           /* The maximum resolution of the screen     */
int    MaxColors;            /* The maximum # of colors available        */
int    ErrorCode;            /* Reports any graphics errors	         */
struct palettetype palette;  /* Used to read palette info                */


/*									*/
/*                        Function prototypes                           */
/*									*/

void Initialize(void);
void PrePlot(float f);
void MainWindow(char *header);
void StatusLine(char *msg);
void DrawBorder(void);
void changetextstyle(int font, int direction, int charsize);
void amp_plot(unsigned char *uc, int a, int b, int c);

/*************************************************************************/
/*                    Begin main function                                */
/*************************************************************************/

static  int   h;
					  /* smooth increments of color*/
static  int paint[16] = { WHITE, LIGHTGRAY, LIGHTRED, YELLOW, LIGHTGREEN,
			  GREEN, LIGHTCYAN, CYAN, LIGHTBLUE, BLUE, LIGHTMAGENTA,
			  MAGENTA, RED, BROWN, DARKGRAY, BLACK};

void cft_init(float f_inc)
{

  Initialize(); 	     /* Set system into Graphics mode	        */
  PrePlot(f_inc);            /* plot the FFT data                       */
/*  cleardevice(); */	     /* Clear the graphics screen	        */
/*  closegraph();  */	     /* Return the system to text mode	        */
/*  return(0);     */
}

/*======================================================================*/
/*	INITIALIZE: Initializes the graphics system and reports 	            */
/*	any errors which occured.					                              */
/*======================================================================*/

void Initialize(void)
{
  int xasp, yasp;			               /* Used to read the aspect ratio */

  GraphDriver = DETECT; 		         /* Request auto-detection	      */
  initgraph( &GraphDriver, &GraphMode, "" );
  ErrorCode = graphresult();		      /* Read result of initialization */
  if( ErrorCode != grOk )   	         /* Error occured during init	   */
    {
     printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
     exit( 1 );
    }

  getpalette( &palette );		         /* Read the palette from board	*/
  MaxColors = getmaxcolor() + 1;	      /* Read maximum number of colors */

  MaxX = getmaxx();
  MaxY = getmaxy();			            /* Read size of screen		      */

  getaspectratio( &xasp, &yasp );      /* read the hardware aspect	   */
  AspectRatio = (double)xasp / (double)yasp; /* Get correction factor	*/

}

/*----------------------------------------------------------------------*/
/*									                                             */
/*	PrePlot: Display FFT info on the screen.	         	               */
/*									                                             */
/*----------------------------------------------------------------------*/

void PrePlot(float f_inc)
{
  struct viewporttype vp;
  int i, j;
  char buffer[100];

  MainWindow( " MOTOROLA DSP56002EVM    Time-Frequency FFT Plot" );


  settextjustify ( LEFT_TEXT, TOP_TEXT );        /* label data of graph */
  changetextstyle( SMALL_FONT, HORIZ_DIR, 4);
  h = textwidth("H");

  sprintf(buffer,"Relative:");
  outtextxy( 20,  8, buffer );
  sprintf(buffer,"Time:  %4d >",70);
  outtextxy( 24,  18, buffer );
  sprintf(buffer," %4d >",60);
  outtextxy( 60,  68, buffer );
  sprintf(buffer," %4d >",50);
  outtextxy( 60, 118, buffer );
  sprintf(buffer," %4d >",40);
  outtextxy( 60, 168, buffer );
  sprintf(buffer," %4d >",30);
  outtextxy( 60, 218, buffer );
  sprintf(buffer," %4d >",20);
  outtextxy( 60, 268, buffer );
  sprintf(buffer," %4d >",10);
  outtextxy( 60, 318, buffer );
  sprintf(buffer," %4d >",1);
  outtextxy( 60, 363, buffer );


  settextjustify ( CENTER_TEXT, TOP_TEXT );      /* label axes of graph */
  changetextstyle( TRIPLEX_FONT, VERT_DIR, 1 );
  outtextxy      ( 20, 90, "Amplitude (6 dB)" );
  setlinestyle   (SOLID_LINE,0xFF,THICK_WIDTH);
                                            /* add color scale          */
  moveto(40,260);                           /* place cursor at origin   */
  for( i=0, j=160 ; i < 160; i++, j--)      /*...and draw all points... */
     {                                      /* count 6 db steps         */
       setcolor(paint[j/10]);               /* select color for this one*/
       lineto( 40, 260 - i );
     }                                      /* restore normal settings  */
  setlinestyle   (SOLID_LINE,0xFF,NORM_WIDTH);
  setcolor       (WHITE);


  h = 3 * textheight( "H" );
  changetextstyle( TRIPLEX_FONT, HORIZ_DIR, 2 );
  outtextxy      ( 300, 415, "Frequency (HZ)" );

                                                 /* Horiz=512, Vert=240 */
  changetextstyle( DEFAULT_FONT, HORIZ_DIR, 1 );
  getviewsettings( &vp );
  setviewport( vp.left+80, vp.top+3, vp.left+512+90, vp.top+340+h+h, 1 );
  getviewsettings( &vp );
                                                 /*-----------------*/
  line(  20, vp.top+351,    h+451, vp.top+351 ); /* horiz, front    */


  settextjustify( CENTER_TEXT, TOP_TEXT );  /*--------------------------*/
  setcolor(MaxColors - 1);                  /* annotate frequency axis  */
  for( i=0, j=20 ; i<=481 ; ++i,j++ )       /*--------------------------*/
  {
    if((i % 20) == 0)                       /* tic marks every 20 pixels*/
       line( j, vp.top+351, j, vp.top+348+(h/2) );
    if ((i % 60) == 0)                      /* label every 3rd tic mark */
      {
       itoa( (int)(i * f_inc*2), buffer, 10 );
       outtextxy( j, vp.top+353+(h/2), buffer );
      }
  }
}


/*----------------------------------------------------------------------*/
/*                                                                      */
/*  amp_plot:  rasterizes the FFT data                                  */
/*                                                                      */
/*----------------------------------------------------------------------*/

void amp_plot(unsigned char *amp, int x, int y, int len)
{
	int i;

        len = len > 511 ?  511 : len;       /* limit plot length if reqd*/
        setlinestyle(SOLID_LINE,0xFF,THICK_WIDTH);
	moveto(x,y);                        /* place cursor at origin   */
        for( i=0 ; i < len; i++,x++)        /*...and draw all points... */
           {
	     setcolor(paint[amp[i]]);       /* select color for this one*/
             lineto( x, y );
           }
}

/*----------------------------------------------------------------------*/
/*                                                                      */
/*	MAINWINDOW: Establish the main window for the demo and set	*/
/*	a viewport for the demo code.	                                */
/*                                                                      */
/*----------------------------------------------------------------------*/

void MainWindow( char *header )
{
  int height;

  cleardevice();			/* Clear graphics screen	*/
  setcolor( MaxColors - 1 );		/* Set current color to white	*/
  setviewport( 0, 0, MaxX, MaxY, 1 );	/* Open port to full screen	*/

  height = textheight( "H" );           /* Get basic text height        */

  changetextstyle( DEFAULT_FONT, HORIZ_DIR, 1 );
  settextjustify( CENTER_TEXT, TOP_TEXT );
  outtextxy( MaxX/2, 2, header );
  setviewport( 0, height+4, MaxX, MaxY-(height+4), 1 );
  DrawBorder();
  setviewport( 1, height+5, MaxX-1, MaxY-(height+5), 1 );

}

/*----------------------------------------------------------------------*/
/*									*/
/*	STATUSLINE: Display a status line at the bottom of the screen.	*/
/*									*/
/*----------------------------------------------------------------------*/

void StatusLine( char *msg )
{
  int height;

  setviewport( 0, 0, MaxX, MaxY, 1 );	/* Open port to full screen	*/
  setcolor( MaxColors - 1 );		/* Set current color to white	*/

  changetextstyle( DEFAULT_FONT, HORIZ_DIR, 1 );
  settextjustify( CENTER_TEXT, TOP_TEXT );
  setlinestyle( SOLID_LINE, 0, NORM_WIDTH );
  setfillstyle( EMPTY_FILL, 0 );

  height = textheight( "H" );           /* Detemine current height      */
  bar( 0, MaxY-(height+4), MaxX, MaxY );
  rectangle( 0, MaxY-(height+4), MaxX, MaxY );
  outtextxy( MaxX/2, MaxY-(height+2), msg );
  setviewport( 1, height+5, MaxX-1, MaxY-(height+5), 1 );

}

/*----------------------------------------------------------------------*/
/*									*/
/*	DRAWBORDER: Draw a solid single line around the current 	*/
/*	viewport.							*/
/*									*/
/*----------------------------------------------------------------------*/

void DrawBorder(void)
{
  struct viewporttype vp;

  setcolor( MaxColors - 1 );		/* Set current color to white	*/

  setlinestyle( SOLID_LINE, 0, NORM_WIDTH );

  getviewsettings( &vp );
  rectangle( 0, 0, vp.right-vp.left, vp.bottom-vp.top );

}

/*----------------------------------------------------------------------*/
/*									*/
/*	CHANGETEXTSTYLE: similar to settextstyle, but checks for	*/
/*	errors that might occur while loading the font file.		*/
/*									*/
/*----------------------------------------------------------------------*/

void changetextstyle(int font, int direction, int charsize)
{
  int ErrorCode;

  graphresult();			/* clear error code		*/
  settextstyle(font, direction, charsize);
  ErrorCode = graphresult();		/* check result 		*/
  if( ErrorCode != grOk ){		/* if error occured		*/
    closegraph();
    printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
    exit( 1 );
  }
}


