	page    132,60
;****************************************************************************
;       SPECSCOP.ASM    Rev.1.2    23 Oct. 1995
;       Example program to move audio through CS4215
;               This program performs a 1023 pt FFT and outputs 
;               the results to the DACs for oscilloscope output
;
;       Copyright (c) MOTOROLA 1995
;                     Semiconductor Products Sector
;                     Digital Signal Processing Division
; 
;******************************************************************************

	include 'sincos'
	include 'fftr2cn'

START           equ       $40
FFT_SIZE        equ      1024           ;1024 point FFT
IN_BUFF         equ     $0400
OUT_BUFF        equ     $0800
TWIDDLE_BUFF    equ     $0C00
TBUFF		equ	$1000		;FFT_SIZE*4 for analog Input buffer
PLOTSIZE        equ       480

;---Port-B bit position names
ACK     equ     13              ;acknowledge back to host
STR     equ     12              ;data strobe from host
INI     equ     11
DSL     equ     10

	sincos  FFT_SIZE,TWIDDLE_BUFF

	org     p:0                     ;RESET Vector
	jmp     START

	org     p:$000C
	jsr     ssi_rx_isr              ;SSI RX
	jsr     ssi_rx_isr              ;SSI RX w/Exception
	jsr     ssi_tx_isr              ;SSI TX
	jsr     ssi_tx_isr              ;SSI TX w/Exception
;******************************************************************************

;---------------------------------------------------------------------------
;
;      DSP/codec initialization
;
;---------------------------------------------------------------------------
	org     p:START

	movep   #$261009,x:PLL          ;set PLL for MPY of 10x
	movep   #$0000,x:BCR            ;zero wait states in all ext. memory
	ori     #3,mr                   ;disable interrupts
	movec   #0,sp                   ;clear hardware stack pointer
	move    #0,omr                  ;mode 0: enable int. P:RAM, rst=0000
	move    #$40,r3                 ; initialize stack pointer
	move    #-1,m3                  ; linear addressing
	move	#TBUFF,r7		; initialize pointer to analog I/O
	move	#FFT_SIZE-1,m7		;     buffer and its modulus...

	include 'ada_init.asm'

;******************************************************************************
; the following two EQUates will define the operatonal parameters
;   of the codec.  Please refer to the ADA_INIT.ASM source file
;   for a description of the parameters selections available.  The
;   variables defined by the EQUates are sent to the  codec via 
;   the transmit buffer, TX_BUFF.
;
;   Since the parameters are defined in ADA_INIT.ASM, these line must
;   follow the include statement.
;******************************************************************************

TONE_OUTPUT     EQU     HEADPHONE_EN+LINEOUT_EN+(0*LEFT_ATTN)+(0*RIGHT_ATTN)
TONE_INPUT      EQU     MIC_IN_SELECT+(0*LEFT_GAIN)+(0*MONITOR_ATTN)+(0*RIGHT_GAIN)


	movep   #$0000,X:PBC            ;set up port-B for parallel out
	movep   #$20FF,X:PBDDR          ; PB12(STR)=input, PB13(ACK)=output
	movep   #$2000,X:PBD

loop_1
	move    #>TONE_OUTPUT,y0        ; headphones, line out, mute spkr, no attn.
	move            y0,x:TX_BUFF_BASE+2
	move    #>TONE_INPUT,y0         ; no input gain, monitor mute
	move            y0,x:TX_BUFF_BASE+3

	move    #IN_BUFF,r4
	move    #FFT_SIZE-1,m4
	clr	b
	move	m4,m0
	move	r7,r0			;get pointer to oldest analog input

	do      #FFT_SIZE,fill_loop
	move	x:(r0)+,a	b,y:(r4)
	move    a,x:(r4)+       	;save the real (left) sample & bump pointer
fill_loop

;----- we now have the input buffer full.  apply a window before the FFT
;       use the twiddle factor table already in memory.  Recall that
;       the sin/cos table is FFT_SIZE/2 in length
;
	move    #IN_BUFF,r4             ;point to start of data
	move    #IN_BUFF+FFT_SIZE-1,r5  ;point to last sample
	move    #TWIDDLE_BUFF,r0        ;point to window values
	move    #-1,m0
	do      #FFT_SIZE/4,window
	move    y:(r0)+,y0      x:(r4),x1       ;get the window value & 1st sample
	mpy     -y0,x1,a        x:(r5),x0       ;apply begin window, get end sample
	mpy     -y0,x0,b        a,x:(r4)+       ;apply end   window, store begin sample
	move    x:(r4),x1                       ;get next begin window sample
	move    b,x:(r5)-                       ;store end window sample
	mpy     -y0,x1,a        x:(r5),x0       ;window next begin sample, get next end sample
	mpy     -y0,x0,b        a,x:(r4)+       ;
	move    b,x:(r5)-
window

	fftr2cn  FFT_SIZE,IN_BUFF,OUT_BUFF,TWIDDLE_BUFF

	move    #OUT_BUFF,r0
	move    #-1,m0

	do      #PLOTSIZE,psd_loop
	clr     A               x:(r0),x0     ; get the sum of squares
	move    x0,x1           
	mpy     x0,x1,a         y:(r0)+,y0    ; square of real
	move                    y0,y1
	mac     y0,y1,a         #0,r1         ; ...plus...square of imag.

	bset    #ACK,r1
	movep   r1,x:PBD
	movep   #$2000,x:PBD
	jmp     loop_1                 ; Loop back.

;----- the following adds the interrupt service routines to the program
;*****************************************************************************
;
;     The basic Interrupt Service Routines (ISR) 
;       used to service the SSI Transmit and SSI Receive Interrupts:
;               ssi_rx_isr
;               ssi_tx_isr
;
;       Before using these routines, the appropriate interrupt
;       vectors must be initialized to jump to the associated 
;       handler. (e.g., P:$000C, the SSI RX interrupt vector should
;       have an instruction which forces the DSP to jump to the
;       address of ssi_rx_isr).  In addition, the DSP's Interrupt
;       Priority Register (IPR) must choose an interrupt level for
;       the SSI interrupts and the DSP56002's Mode Register must 
;       enable that interrupt level.
;
;    The ISRs which follow require that r6 has been established as 
;      a pointer to a stack which grows towards increasing addresses.
;*****************************************************************************
;
;       Copyright (c) MOTOROLA 1995
;                     Semiconductor Products Sector 
;                     Digital Signal Processing Division
;
;*****************************************************************************


;--------------------------------------------------------------------
;   SSI Receive ISR
;   This Interrupt Service Routine is the destination of the SSI RX
;      vector located at p:$000C.   In many cases the SSI RX w/Exception
;      vector will also jump here.
;   R7 should point to the first free location in the buffer (in X:memory).
;      Sync is verified/restored every frame.
;--------------------------------------------------------------------
ssi_rx_isr
	move    r0,x:(r3)+              ; Save r0 to the stack.
	move    m0,x:(r3)+              ; Save m0 to the stack.
	move	x0,x:(r3)+
	move    #3,m0                   ; Modulus 4 buffer.
	move    x:RX_PTR,r0             ; Load the pointer to the rx buffer.
	jclr    #3,x:SSISR,next_rx      ; If not frame sync, jump to transmit data.
	move    #RX_BUFF_BASE,r0  	; If frame sync, reset pointer.
	move	x:(RX_BUFF_BASE),x0
	move	x0,x:(r7)+
next_rx
	movep	x:SSIDR,x:(r0)+         ; SSI transfer data register.
	move    r0,x:RX_PTR             ; Update tx buffer pointer.
	move    x:-(r3),x0
	move    x:-(r3),m0              ; Restore m0.
	move    x:-(r3),r0              ; Restore r0.
	rti


;--------------------------------------------------------------------
;   SSI Transmit ISR
;   This Interrupt Service Routine is the destination of the SSI TX
;      vector located at p:$0010.   In many cases the SSI TX w/Exception
;      vector will also jump here.
;   R3 should point to the first free location on the stack (in X:memory).
;   The data is taken from a 1 frame (4 word) buffer and sync.
;      is verified/restored every frame.
;--------------------------------------------------------------------
ssi_tx_isr
	move    r0,x:(r3)+              ; Save r0 to the stack.
	move    m0,x:(r3)+              ; Save m0 to the stack.
	move    #3,m0                   ; Modulus 4 buffer.
	move    x:TX_PTR,r0             ; Load the pointer to the tx buffer.
	jclr    #2,x:SSISR,next_tx      ; If not frame sync, jump to transmit data.
	move    #TX_BUFF_BASE+1,r0      ; If frame sync, reset pointer.
	nop
next_tx
	movep   x:(r0)+,x:SSIDR         ; SSI transfer data register.
	move    r0,x:TX_PTR             ; Update tx buffer pointer.
	move    x:-(r3),m0              ; Restore m0.
	move    x:-(r3),r0              ; Restore r0.
	rti

    end





















