unit Sio; {$R+}  {Ekkehard Pofahl, 23-Mar-99, pofahl@gmx.de }
{In dieser Routine sind alle Routinen zusammengefasst, die fuer den
Betrieb von IRdeo benoetigt werden.
Die Pascal Unit ist mit Turbo-Pascal Version 7.0 und Delphi 1 bis 4
ohne Aenderung compilierbar.
Fruehere Versionen von Turbo-Pascal koennen keine offenen Feldgrenzen.
Gegebenenfalls mu man die entprechenden Routinen anpassen.
Bei langsameren Prozessoren muss gegebenenfalls die Verzoegerungsschleife
"warte" auf Assembler umgestellt werden. }

 interface
{*********}

const TIR_max = 190 ;
type  TIR_Befehl = record IR_Muster : array [ 0 .. TIR_max ] of longint ; end;
      TZaehler   = record Vorzeichen : char ;
                   Stunden, Minuten, Sekunden, HFrames : longint; end ;

procedure clear_Befehl (var cBefehl : TIR_Befehl) ;

procedure Sio_Info ( XSIO_Kanal, Delay_Drehg_msec, Anfragen_pSec,
                     XAbfallzeit_IR_Detektor,  SonyS1, SonyS2 :longint);
procedure Setup_9600 ;

procedure Bestimme_Drehzahl (
      var Delay_Drehg_msec, Anfragen_pSec, PNr, PAbweichung, PQuote : longint;
      var Fehlercode : string  ) ;

procedure IR_Lernen ( var XL_Befehl : TIR_Befehl ;
                      var XL_Code, XL_Error, XL_Kommentar : String );

procedure IR_Senden ( XS_Befehl : TIR_Befehl ) ;

procedure Warte         ( d_usx         : Longint ) ;
procedure Warte_ms      ( d_ms          : Longint ) ;
function  IR_Status : Boolean ;

procedure Get_CTS_DSR ( var v_CTS, v_DSR : Boolean ) ;
procedure Set_RTS_DTR (      sRTS,  sDTR : Boolean ) ;

procedure Burst_out      ( Nr_Bursts : longint );

procedure Update_Zaehler ( UKanal: longint; var m_Zaehler: TZaehler;
                           var Cam_Typ, CStatus: string; var Playing: Boolean );

procedure COM_setup ( COM_Nr : longint ; CBaud_Rate, Byte_Format : word ) ;
function  UART_Messroutine(U_Tiefe : longint; var sox1, sox2: longint): longint;
procedure Warte_exact  (Kanal_Nummer, Warte_Zeit : longint ) ;
procedure Waehle_Kanal (Kanal_Nummer : longint ) ;

function  Sende_Draht_Befehl ( KKanal, KBefehl : longint) : longint ;

{Drei Zeittypen : Z : Zaehler record, Str : String, ZInt : Zeit als LongInt}

procedure ZClear (var cl_zeit : TZaehler ) ;
function  Z2Zint (     c_zeit : TZaehler ) : longint ;
function  Z2Str  (     c_zeit : TZaehler ) : string  ;
function  Z2Str_frame (c_zeit : TZaehler ) : string  ;

procedure ZInt2Z         ( DezZeit : longint; var c_zeit : TZaehler ) ;
function  ZInt2Str       ( ci_zeit : longint ) : string ;
function  ZInt2Str_Frame ( ci_zeit : longint ) : string ;

function  Str2I    (zt_string: String; sindx: longint) : longint ;
function  Str2ZInt (zt_string: String; sindx: longint) : longint ;
procedure Str2Z    (zt_string: String; zindx: longint; var loc_Zeit: TZaehler);
function  Str2ms   (zt_string: String ) : longint ;

function  incZString (ZStr : string) : string ;
function  decZString (ZStr : string) : string ;

function  NurZeitString (zt_string : string; zindx: longint) : string ;
function  Voll_Format   (zt_string : string; zindx: longint) : string ;

function  Befehl       (zl: String ) : String ;
function  Kommentar    (zl: String ) : String ;
function  Vorkomma     (zl: String ) : String ;
function  Nachkomma    (zl: String ) : String ;
function  Trim         (zl: String ) : String ;

{ Befehlskonstante, Fabrikat unabhaengig }
const
CPlay    = 1  ;               CReverse = 7  ; {Einzelbild }
CStop    = 2  ;               CForward = 8  ;
CPause   = 3  ;               CZero    = 9  ; {Nullstellung }
CRew     = 4  ;{spulen}       CUp      = 10 ;
CFF      = 5  ;               CDown    = 11 ;
CRecord  = 6  ;               COff     = 12 ; {Ausschalten}

{ Konstante fuer SIO Bausteine INS 8250, 16450, 16550 }

bits5 = 0 ; bits6 = 1 ; bits7 = 2 ; bits8 = 3 ;
stops_1     = 0   ; stops_2    = $04 ;
parity_on   = $08 ; parity_off = $00 ;
parity_even = $10 ; parity_odd = 0   ;
Break_Bit   = $40 ;

 implementation
{**************}

type TStatus = record Zaehler : TZaehler ;
                      Zeichen : string ;
                      Wert    : byte ;
end ;

const Sony_max = 130 ;
type TSony_Tel = record Chars   : array [0 .. Sony_max] of byte ;
                        Zeit    : array [0 .. Sony_max] of longint ;
                        Status  : TStatus ;
end ;

const Pana_max = 450  ;
type TPana_Tel = record clock, data  : array [0..Pana_max] of Longint ;
                        telegramm    : array [0 .. 10    ] of LongInt ;
                        Status       : TStatus ;
end ;

const Hex_max = 100 ;
type  THex_Code  = array [0 .. Hex_max] of longint ;

var Sony_tel : TSony_Tel ;
    Pana_tel : TPana_Tel ;

const
  { Konstante fuer INS 8250, 16450, 16550 }

   RX_TX_buffer      = $08 ;
   Divisor_Latch_LSB = $08 ;
   Divisor_Latch_MSB = $09 ;
   Interrupt_enable_register         = $09 ;
   Interrupt_identification_register = $0A ;
   Line_Control_Register  = $0B ;
   Modem_Control_Register = $0C ;
   Line_Status_Register   = $0D ;
   Modem_Status_Register  = $0E ;

   DLAB        = $80 ;
   {LSR, Line Status Register, Bits } LSR_TX_Empty = $20 ;
   {MS , Modem Status Port }          MS_DSD       = $20 ; {Data Set Ready}

const max_X = 1200 ;
var   X_Array   : array [ 0 .. max_X ] of longint ;
const max_Code = 25 ;
var   Bef_array : array [ 0 .. max_Code ] of THex_Code ;
      MS_Port, X_Port, LSR_Port, MCR_Port : word ;
      Errorcode : String ;
      CTL_Verzoegerung : array [0 .. 10 ] of longint ;
      send_timeout, Old_CTS, Old_DSR : Boolean ;
      Abfallzeit_IR_Detektor_SIO,      { usec, effektiv, gemessen } 
      AN_Bit_Zeit, AUS_Bit_Zeit, Last_correct_Bit,
      Sony_Schwelle, Pana_Byte_Schwelle, Pana_Telegramm_Schwelle,
      S_Delay_Drehg_msec, S_Anfragen_pSec,
      SIO_Kanal, laengste_Pause,   kuerzeste_Pause,
      laengster_Impuls, kuerzester_Impuls, IR_Burstende,
      Anzahl_Wiederholungen, Anzahl_Befehlspausen, Single_Laenge: longint ;

procedure clear_Befehl (var cBefehl : TIR_Befehl) ;
var cbc : longint ;
begin with cBefehl do for cbc := 0 to TIR_max do IR_Muster [cbc] := 0 ; end;


{ leider gibt es bei Delphi 2 + 3 keinen "port" Befehl mehr ..., also :}

function PortIn(IOport:word):byte; assembler;
  {$ifdef VER90  } stdcall; {$endif  Delphi 2 }
  {$ifdef VER100 } stdcall; {$endif  Delphi 3 } 
  {$ifdef VER120 } stdcall; {$endif  Delphi 4 }

   asm
     mov dx,IOport
     in al,dx
   end;

procedure PortOut(IOport:word; Value:byte); assembler;
  {$ifdef VER90  } stdcall; {$endif  Delphi 2 }
  {$ifdef VER100 } stdcall; {$endif  Delphi 3 } 
  {$ifdef VER120 } stdcall; {$endif  Delphi 4 }

   asm
     mov dx,IOport
     mov al,Value
     out dx,al
   end;

function Befehl    (zl: string ) : string ;
begin Befehl := zl ;
      if pos (';', zl) <> 0 then Befehl := copy (zl, 1, pos (';', zl)-1 );
end;

function Kommentar (zl: string ) : string ;
begin Kommentar := '' ;
      if pos (';', zl) <> 0 then Kommentar := copy (zl, pos (';', zl)+1, 500);
end;

function  Vorkomma     (zl: String ) : String ;
begin if pos (',', zl) = 0 then Vorkomma := ''
      else Vorkomma := copy (zl, 2, pos (',', zl) - 2 ) ;
end ;

function  Nachkomma    (zl: String ) : String ;
begin if pos (',', zl) = 0 then Nachkomma := ''
      else Nachkomma := copy (zl, pos (',', zl) + 1, 100 );
end ;

function  Trim         (zl: String ) : String ;
var tr : string ;
begin tr := zl ;
      while (tr <> '') and (tr[1] in [' ', chr (9)] ) do delete (tr,1,1) ;
      while (tr <> '') and (tr[length (tr)] in [' ', chr (9)] )
                       do delete (tr,length(tr),1) ;
      Trim := tr ;
end ;

procedure Setup_9600 ; begin COM_setup ( SIO_Kanal, 9600, Bits8 ) ; end ;

function hexb (c : byte) : string ;  { BYTE zu Hex-Ziffern }
const  hexdig : string [16] = '0123456789ABCDEF';
begin  hexb := hexdig [(c DIV 16) + 1] + hexdig [(c MOD 16) + 1]; end;

procedure ZClear ( var cl_zeit : TZaehler ) ;
begin with cl_zeit do begin Vorzeichen := ' '; Stunden := 0;
                  Minuten := 0; Sekunden := 0; HFrames := 0;
end; end;

function Str2I ( zt_string : String; sindx: longint) : longint ;
var vs : string ; i_err : Integer; E_I, sptr, sii : longint;
begin Str2I := 0 ;
      sptr := 1 ;
      for sii := 1 to sindx do begin
        while (( sptr <= length (zt_string) ) and
	  (NOT ( zt_string [sptr] in [ '0' .. '9' ] ))) do inc (sptr) ;
        vs := '' ;
        while ( ( sptr <= length (zt_string)         ) and
	      ( zt_string [sptr] in [ '0' .. '9' ] )      ) do begin
	  vs := vs + zt_string [sptr] ;
	  inc (sptr) ;
        end ;
        val (vs, E_i, i_err ) ;
        if i_err <> 0 then E_i := 0;
        Str2I := E_i ;
      end ;
end;

procedure Str21Z ( E_string : string; var E_zeit : TZaehler);
var E_Stunden, E_Minuten, E_HFrames : Boolean ;
    s21 : string ; i21 : longint ;
begin
   ZClear (E_zeit);
   s21 := E_String ;
   if ( pos ('-', s21 ) <> 0 ) then E_zeit.Vorzeichen := '-';
   E_Minuten := false ;
   if pos (':', s21) <> 0 then begin
	 E_Minuten := true ;
	 s21 [pos (':', s21) ] := ' ' ;
      end ;
   E_Stunden := ( pos (':', s21) <> 0 ) ;
   E_HFrames := ( pos ('.', s21) <> 0 ) ;
   i21 := 1 ;
   with E_Zeit do begin
   if E_Stunden then begin Stunden := Str2I (s21,i21);inc(i21);end;
   if E_Minuten then begin Minuten := Str2I (s21,i21);inc(i21);end;
                           Sekunden:= Str2I (s21,i21);inc(i21);
   if E_HFrames then       HFrames := 2*Str2I (s21,i21);
   end;
end ;

function NurZeitString ( zt_string : string; zindx: longint) : string ;
var szi, zptr : longint ; ZeitZiffer : set of char ; z_strg : string ;
    Ziffer_gefunden : Boolean ;
begin ZeitZiffer := [' ', ':', '-', '.', '0' .. '9'] ;
      Ziffer_gefunden := false ;
      zptr := 1 ;
      for szi := 1 to zindx do begin
        while ( zptr <= length (zt_string) ) AND
	 (NOT ( zt_string [zptr] in ZeitZiffer )) do inc (zptr);
        z_strg := '' ;
        Ziffer_gefunden := false ;
        while ( zptr <= length (zt_string) ) AND
	  ( zt_string [zptr] in ZeitZiffer ) do
         begin
           z_strg := z_strg + zt_string [zptr];
           if zt_string [zptr] in ['0'..'9'] then Ziffer_gefunden := true ;
           inc (zptr);
         end;
    end ;
    if not Ziffer_gefunden then z_strg := '' ;
    NurZeitString := trim (z_strg) ;
end ;

procedure Str2Z(zt_string: String; zindx: longint; var loc_Zeit: TZaehler);
begin Str21z ( NurZeitString ( zt_string, zindx), loc_Zeit ) ; end ;

function  Str2ZInt (zt_string: String; sindx: longint) : longint ;
var  loc_Zeit : TZaehler ;
begin Str2ZInt := 0 ;
      if NurZeitString ( zt_string, sindx) <> '' then begin
        ZClear  ( loc_Zeit ) ;
        Str21z  ( NurZeitString ( zt_string, sindx), loc_Zeit ) ;
        Str2ZInt := Z2Zint (loc_Zeit) ;
      end ;
end ;

const HFrames_sec = 50 ; { Anzahl Halbframes / Sekunde }

function  Str2ms   (zt_string: String ) : longint ;
begin     Str2ms := Str2ZInt (zt_string,1) * ( 1000 div HFrames_sec ) ; end ;

function  ZInt2Str ( ci_zeit : longint) : string ;
var ziz : TZaehler ;
begin ZInt2Z (ci_zeit, ziz) ; ZInt2Str := Z2Str (ziz) ; end ;

function  ZInt2Str_Frame ( ci_zeit : longint ) : string ;
var ziz : TZaehler ;
begin ZInt2Z (ci_zeit, ziz) ;
      ZInt2Str_Frame := Z2Str_Frame (ziz) ;
end ;

function Voll_Format (zt_string : string ; zindx : longint ) : string ;
begin    Voll_Format := Zint2Str_Frame ( Str2Zint (zt_string, zindx) ) ; end ;

function  incZString (ZStr : string) : string ;
begin if NurZeitString (ZStr, 1 ) = '' then incZString := ZStr
         else incZString := Zint2Str_Frame ( Str2Zint (ZStr,1) + 2 ) ;
end;

function  decZString (ZStr : string) : string ;
begin if NurZeitString (ZStr, 1 ) = '' then decZString := ZStr
         else decZString := Zint2Str_Frame ( Str2Zint (ZStr,1) - 2 ) ;
end;

function ziffer (zf_i : longint) : string ;
var zf_s : string ;
begin str (zf_i, zf_s) ;
      if zf_i < 10 then zf_s := '0' + zf_s ;
      ziffer := zf_s ;
end ;

function Z2Str ( c_zeit : TZaehler ) : string ;
var dummy : string ;
begin with c_zeit do begin
  dummy := ziffer (Stunden) ;
  Z2Str := Vorzeichen +  dummy [2]  + ':' +
             ziffer (Minuten) + ':' + ziffer (Sekunden) ;
end ; end ;

function Z2Str_frame ( c_zeit : TZaehler ) : string ;
begin Z2Str_frame := Z2Str (c_zeit) + '.' + ziffer (c_zeit.HFrames div 2);end;

procedure ZInt2Z ( DezZeit : longint; var c_zeit : TZaehler ) ;
var hd : longint ;
begin with c_zeit do begin
    if DezZeit < 0 then Vorzeichen := '-' else Vorzeichen := ' ';
    hd       := abs (DezZeit) ;
    Stunden  := hd div ( HFrames_sec * 60 * 60 ) ;
    hd       := hd mod ( HFrames_sec * 60 * 60 ) ;
    Minuten  := hd div ( HFrames_sec * 60 ) ;
    hd       := hd mod ( HFrames_sec * 60 ) ;
    Sekunden := hd div ( HFrames_sec ) ;
    HFrames  := hd mod ( HFrames_sec ) ;
end; end ;

function Z2Zint ( c_zeit : TZaehler ) : longint ;
var dzt : longint ;
begin with c_zeit do begin
        dzt := HFrames + ( HFrames_sec * Sekunden          )
                       + ( HFrames_sec * 60 * Minuten      )
                       + ( HFrames_sec * 60 * 60 * Stunden ) ;
        if Vorzeichen = '-' then dzt := -dzt ;
        Z2Zint := dzt ;
end; end ;

procedure   Quadrat_anpassung (var QFeld : array of LongInt ;
                       q_anfang, q_ende, anz_ex : longint ) ;
{Anpassung nach der Methode der kleinsten Quadrate }
var a0, a1, N_q, S_x, S_y, S_xy, S_x_2, xx, yy : real ;
    qi : longint ;
begin
   N_q := (q_ende - q_anfang) + 1 ;
   S_x := 0 ; S_y := 0; S_xy := 0;  S_x_2 := 0 ;
   for qi := q_anfang to q_ende do begin
      xx    := qi ;
      yy    := QFeld [qi] ;
      S_x   := S_x   +   xx        ;
      S_y   := S_y   +   yy        ;
      S_xy  := S_xy  + ( xx * yy ) ;
      S_x_2 := S_x_2 + ( xx * xx ) ;
   end;

   a0 := ( (S_y * S_x_2) - (S_x * S_xy) ) /
         ( (N_q * S_x_2) - (S_x * S_x ) )   ;

   a1 := ( (N_q * S_xy ) - (S_x * S_y) ) /
         ( (N_q * S_x_2) - (S_x * S_x) )    ;

   for qi := 0 to anz_ex do begin
      xx    := qi ;
      yy    := a0 + ( a1 * xx ) ;
      QFeld [qi] := round (yy) ;
   end;
end ;

procedure Sio_Info ( XSIO_Kanal, Delay_Drehg_msec, Anfragen_pSec,
                     XAbfallzeit_IR_Detektor, SonyS1, SonyS2 :longint);
begin
      S_Delay_Drehg_msec := Delay_Drehg_msec ;
      if S_Delay_Drehg_msec = 0 then S_Delay_Drehg_msec := 95000 ;
      S_Anfragen_pSec    := Anfragen_pSec ;
      if S_Anfragen_pSec    = 0 then S_Anfragen_pSec    := 700000 ;
      SIO_Kanal          := XSIO_Kanal ;
      Abfallzeit_IR_Detektor_SIO := XAbfallzeit_IR_Detektor ;
      Sony_Schwelle := 0 ;
      CTL_Verzoegerung [1] := SonyS1 ;
      CTL_Verzoegerung [2] := SonyS2 ;
      Quadrat_anpassung (CTL_Verzoegerung,1,2,8) ;
end ;

procedure Set_RTS_DTR ( srts, sdtr : Boolean ) ;
var   rts_dtr_Status : byte ;
begin rts_dtr_Status := 0 ;
      if srts then rts_dtr_Status := rts_dtr_Status + $02;
      if sdtr then rts_dtr_Status := rts_dtr_Status + $01;
      portout ( MCR_Port, rts_dtr_Status );
end ;

procedure Waehle_Kanal ( Kanal_Nummer : longint ) ;
var   rts_dtr_Status : byte ;
begin rts_dtr_Status := Kanal_Nummer AND $00000003 ;
      portout ( MCR_Port, rts_dtr_Status ) ;
      if rts_dtr_Status = 3 then warte_ms (20); {Wegen Spannungsaufbau, HW Bug}
end ;


procedure COM_setup ( COM_Nr : longint ; CBaud_Rate, Byte_Format : word ) ;
var port_basis, X_Speed : word ;
begin  case COM_Nr of
          1 :  port_basis := $3F0 ;
          2 :  port_basis := $2F0 ;
          3 :  port_basis := $3E0 ;
          4 :  port_basis := $2E0 ;
          else port_basis := $3F0 ;
       end ; { case }


       MS_Port  := port_basis + Modem_Status_register ;
       X_port   := port_basis + RX_TX_buffer ;
       LSR_port := port_basis + Line_Status_Register ;
       MCR_port := port_basis + Modem_Control_Register ;

       case CBaud_Rate of
             600 : X_Speed := 192 ;
            1200 : X_Speed := 96 ;
            2400 : X_Speed := 48 ;
            4800 : X_Speed := 24 ;
            9600 : X_Speed := 12 ;
           19200 : X_Speed :=  6 ;
           38400 : X_Speed :=  3 ;
           57600 : X_Speed :=  2 ;
             115 : X_Speed :=  1 ;
              else X_Speed := 12 ;
       end ; { case }

       portOut (port_basis + Line_control_register , DLAB OR Byte_Format );
       portOut (port_basis + Divisor_latch_LSB     , X_Speed );
       portOut (port_basis + Divisor_latch_MSB     , $00 );
       portOut (port_basis + Line_Control_Register , Byte_Format ); { DLAB=0}
       portOut (port_basis + Interrupt_enable_register , $00 ); {Int. disable}
end;

procedure Wait_till_out ;
var   wtli : longint ;
begin wtli := 0 ;
      while ( ( portIn (LSR_port) and LSR_TX_Empty ) = 0 )
            AND (Not send_timeout) do begin
         inc (wtli) ;
         if wtli > 20000 then Send_timeout := true ;
      end ;
end ;


function toggle (var vtoggle : Boolean) : Boolean;
begin vtoggle := not vtoggle; toggle := vtoggle ; end ;

procedure get_CTS_DSR ( var V_CTS, V_DSR : Boolean ) ;
var modem_status : byte ; l_CTS, l_DSR : Boolean ;
begin modem_status := portIn ( MS_Port ) ;
      l_CTS := (modem_status and $10 ) <> 0 ;
      l_DSR := (modem_status and $20 ) <> 0 ;
      {Haben sich die Bits geaendert ? }
      if ( modem_status and $01 ) <> 0 then l_CTS := toggle (Old_CTS);
      if ( modem_status and $02 ) <> 0 then l_DSR := toggle (Old_DSR) ;
      V_CTS := l_CTS ;
      V_DSR := l_DSR ;
end ;

function IR_Status : Boolean ;
var   sio1, sio2  : Boolean ;
begin get_CTS_DSR ( sio1, sio2) ; IR_Status := sio2 ; end ;

{********************}
const { SONY Befehle (Bf) und Status fuer Control - L }
Bf_Play = $34 ;    Sony_Status_Play = $06 ;
Bf_Rew  = $36 ;    Sony_Status_Rew  = $83 ;
Bf_FF   = $38 ;    Sony_Status_FF   = $03 ;
Bf_Stop = $30 ;    Sony_Status_Stop = $02 ;
Bf_Cue  = $38 ;    Sony_Status_Cue  = $46 ;
Bf_Pause= $32 ;
Bf_Start_Stop = $33 ;
Bf_Display = $B4 ;  { schaltet Datendisplay + HF ein !}
Bf_Record  = $3A ; Sony_Status_Record         = $04 ;
                   Sony_Status_Record_Pause   = $14 ;
                   Sony_Status_Playback_Pause = $07 ;
                   Sony_Status_Reverse_Pause  = $97 ;
                   Sony_Status_Frame_Advance  = $67 ;
                   Sony_Status_rev_Frame_Advance = $77 ;
Bf_Reverse  =   $60 ;
Bf_Forward  =   $62 ;
Bf_Counter_Reset = $8C ;
Bf_Power_Off     = $5E ;

function Sony_Status (SSt : byte) : string ;
begin case SSt of
    Sony_Status_Play              : Sony_Status :=  '> ' ;
    Sony_Status_Rew               : Sony_Status :=  '<<' ;
    Sony_Status_FF                : Sony_Status :=  '>>' ;
    Sony_Status_Record            : Sony_Status :=  '* ' ;
    Sony_Status_Record_Pause      : Sony_Status :=  'II' ;{nochmal gruebeln}
    Sony_Status_Playback_Pause    : Sony_Status :=  'II' ;{ auch >I mgl. }
    Sony_Status_Reverse_Pause     : Sony_Status :=  'I<' ;
    Sony_Status_Frame_Advance     : Sony_Status :=  '+ ' ;
    Sony_Status_rev_Frame_Advance : Sony_Status :=  '- ' ;
    else                            Sony_Status :=  '  ' ;
end ; end ;

procedure  Clear_n ( var cv : array of longint ; cvi : longint );
var cvii : longint ;
begin for cvii := 0 to cvi do cv [cvii] := 0 ; end ;

function  Mittel_wert ( viele_is : array of LongInt  ;
                        VGrenze  : LongInt ) : LongInt ;
var mw_ix, M_Summe, sumx : longint ;
begin Mittel_wert := 0 ;
      M_Summe     := 0 ;
      sumx        := 0 ;
      mw_ix := 0 ;
      while viele_is [mw_ix] >= 0 do begin
        if viele_is [mw_ix] > VGrenze then begin
          inc (M_Summe, viele_is [mw_ix] ) ;
          inc (sumx) ;
        end ;
        inc (mw_ix) ;
      end ;
      if sumx <> 0 then Mittel_wert := M_Summe div sumx ;
end ;

function Abweichung ( viele_is : array of LongInt ) : longint ;
var Mittel, abw_n : longint ; XSumme, x_minus_x_quer : real ;
begin Mittel := Mittel_wert (viele_is, 0) ;
      XSumme := 0  ;
      abw_n  := -1 ;
      repeat begin
         inc (abw_n) ;
         x_minus_x_quer :=  viele_is [abw_n] - Mittel  ;
         XSumme := XSumme + (x_minus_x_quer * x_minus_x_quer) ;
      end until viele_is [abw_n + 1] < 0 ;
      if abw_n <> 0 then Abweichung := round ( sqrt (XSumme/abw_n) )
                    else Abweichung := 0 ;
end ;

function byte_da : boolean;
begin    byte_da := (portIn (LSR_port) and $01) <> 0 ; end;

procedure Sony_Read_Puffer ( ranz, Max_Wartezeit : Longint ) ;
var ri, Warti : longint ;
begin with Sony_Tel do begin
   ri := 0 ;
   Chars [0] :=  0 ;
   Zeit  [0] :=  0 ;
   repeat begin
      inc ( ri ) ;
      Warti := 0 ;
      while (not byte_da) and (Warti <= Max_Wartezeit) do inc (Warti);
      Chars [ri] := NOT PortIn ( X_port ) ;
      Zeit  [ri] := Warti ;
   end until ((ri >= ranz) OR (Warti >= Max_Wartezeit ));
   Chars [ri+1] :=  0 ;
   Zeit  [ri+1] := -1 ;
end ; end ;

procedure Sony_Read_Telegramm ;
begin     Sony_Read_Puffer (20, Sony_Schwelle ) ; end ;

procedure Sony_Bestimme_Schwelle ;
var CTL_1 : Longint ;
begin setup_9600 ;
      Sony_Read_Puffer (50,  S_Anfragen_pSec) ;
      ctl_1         :=  Mittel_wert (Sony_Tel.Zeit, 0 ) ;
      Sony_Schwelle := (Mittel_wert (Sony_Tel.Zeit, ctl_1 ) * 3) div 5 ;
end ;

const Clock_Pin = $20        ; Data_Pin = $10        ;
      Clock_Change_Pin = $02 ; Data_Change_Pin = $01 ;

function Erkenne_Fabrikat : string ;
var df_i, clk_i, data_i : LongInt ; sty : byte ;
begin clk_i  := 0 ;
      data_i := 0 ;
      for df_i := 1 to (S_Anfragen_pSec div 20) {50 msec} do begin
      { sty := PortIn ( MS_port ) ;}
       asm
         mov dx,MS_Port
         in al,dx
         mov sty,al
       end ;
       if (sty AND Clock_Change_Pin) <> 0 then inc (clk_i ) ;
       if (sty AND Data_Change_Pin ) <> 0 then inc (data_i) ;
      end ;
      Erkenne_Fabrikat := '' ;
      if (data_i > 5)                  then Erkenne_Fabrikat := 'Sony'      ;
      if (data_i > 5) and (clk_i  > 5) then Erkenne_Fabrikat := 'Panasonic' ;
end ;

procedure Pana_Read_Puffer (panz, pmaxwait : longint );
var stx : byte ; pana_i, Loc_Timer : longint ;
begin with Pana_Tel do begin
      pana_i    := 0 ;
      Loc_Timer := 0 ;
      repeat begin
       {stx := PortIn ( MS_port ) ;}
       asm
         mov dx,MS_Port
         in al,dx
         mov stx,al
       end ;

       if  (stx AND Clock_Change_Pin) <> 0 then begin
          clock [pana_i] := loc_Timer ;
          loc_Timer := 0 ;
          inc (pana_i);
       end else inc ( loc_Timer ) ;
       if ((stx AND Data_Pin) <> 0 ) then inc (data [pana_i] ) ;

      end until (pana_i >= panz) or (Loc_Timer > pmaxwait) ;

      clock [pana_i  ] := loc_Timer ;
      clock [pana_i+1] := -1 ;
end ; end ;

procedure Pana_Bestimme_Schwellen  ;
var Schwelle1 : longint ;
begin with Pana_Tel do begin
    Pana_Read_Puffer ( 340, S_Anfragen_pSec ) ;  { 1 Telegramm = 112 Werte }
    Pana_Byte_Schwelle  := Mittel_wert (clock, 0) ;
    Schwelle1           := Mittel_wert (clock, Pana_Byte_Schwelle) ;
    Pana_Telegramm_Schwelle := ( Mittel_wert (clock, Schwelle1) * 3 ) div 5 ;
end ; end ;

function Nibbles_to_dez ( c_puf : longint ) : longint ;
begin    Nibbles_to_dez :=(   ( (c_puf) AND $0000000F ) +
                            ( ( (c_puf) AND $000000F0 ) shr 4 ) * 10 )
                          and $00FF  ;
end ;

function Pana_Status (pst : byte) : string ;
begin Pana_Status := '  ' ;
      case (pst AND $0F) of
        $0 : Pana_Status := '  ' ; {stop}
        $2 : Pana_Status := '<<' ; {rewind}
        $3 : Pana_Status := '>>' ; {fast forward}
        $8 : Pana_Status := '> ' ; {play}
        $9 : Pana_Status := 'II' ; {pause}
        $A : Pana_Status := '* ' ; {record}
      end ;
end ;


procedure Pana_Read_Telegramm ;
begin     Pana_Read_Puffer ( 340, Pana_Telegramm_Schwelle ); end;

procedure Pana_Decode ;
var ii_x, tx_j, tx_index, dx_index : longint ;
begin with Pana_Tel do begin
      clear_n (Telegramm, 10) ;
      ii_x := 0 ;
      repeat begin
        inc (ii_x) ;
        if (         ii_x   >  65                       ) AND
           ( clock [ ii_x ] >= Pana_Telegramm_Schwelle  ) then begin

           for tx_j := 111 downto 0 do if (ii_x >= tx_j ) AND
                               ( (tx_j mod 2) = 1 ) then begin
             tx_index  :=  tx_j  div 16 ;
             tx_index  :=  7 - tx_index  ;
             dx_index  :=  ii_x - tx_j   ;
             Telegramm [tx_index] := (Telegramm [tx_index] * 2) AND $00FF ;
             if data   [dx_index] <= 1 then inc (Telegramm [tx_index]) ;
           end ;

           { Hier evtl. noch andere Unterscheidungen, abhaengig von
             Telegramm [5], machen. Ausgetestet mit den Panasonic Geraeten
             Camcorder NV-S6 und Videorekorder HD-6xx  : }
           if   ( (Telegramm [5] and $60 ) = $20 )       AND
                ( clock [ii_x-16] > Pana_Byte_Schwelle ) AND
                ( clock [ii_x-32] > Pana_Byte_Schwelle ) AND
                ( clock [ii_x-48] > Pana_Byte_Schwelle ) AND
                ( clock [ii_x-64] > Pana_Byte_Schwelle )
             then with Status.Zaehler do begin
                Stunden  := Nibbles_to_dez ( Telegramm [5] AND $000F ) ;
                Minuten  := Nibbles_to_dez ( Telegramm [6] );
                Sekunden := Nibbles_to_dez ( Telegramm [7] );
                HFrames  := 0 ;
                if (Telegramm[5] AND $10 ) = 0 then Vorzeichen := ' '
                                               else Vorzeichen := '-' ;
                Status.Wert := Telegramm [4] ;
                with Status do Zeichen := Pana_Status(Wert) + ' ' + hexb(Wert);
             end ;

        end ;

     end until ( clock [ii_x] < 0 )  ;
end ; end ;

procedure Sony_Decode ;
var ii_x, Guide_code : longint ;
begin with Sony_Tel do begin
      ii_x := 0 ;
      while Zeit [ii_x] >= 0 do begin
       if (ii_x > 5) and (Zeit[ii_x] > Sony_Schwelle) then begin
         Status.Wert := Chars [ii_x-4] ;
         with Status do Zeichen := Sony_Status(Wert)+ '  '+hexb(Wert AND $00FF);
         Guide_code := Chars [ii_x-3] AND $0000F0 ;
         Guide_code := Guide_code div 16 ;
         Status.Zaehler.HFrames := 0 ;
         with Status.Zaehler do
         case Guide_code of
            2: Sekunden := Nibbles_to_dez ( Chars [ii_x-2] )
                           +      ( 100 * ( Chars [ii_x-1] ));
            3: begin Sekunden := Nibbles_to_dez ( Chars [ii_x-2] );
                     Minuten  := Nibbles_to_dez ( Chars [ii_x-1] );
               end ;
            4: begin Stunden := Nibbles_to_dez ( Chars [ii_x-2] );
                     if ( (Chars [ii_x-1]) AND $80 ) = 0
                         then Vorzeichen := ' ' else Vorzeichen := '-';
               end ;
         end ;
       end ;
       inc (ii_x) ;
      end ;
end ; end ;

const Max_Exakt_Wartezeit = 500 ;{in HalbFrames, 1 Sekunde = 50 HFrames}

procedure Sony_Warte_exact ( Warte_Zeit_Sekunde, Warte_Zeit_HFrame : longint ) ;
var  Warte_c : longint ; SW_Timeout : Boolean ;
begin
   Warte_c := 0 ;
   Sony_Bestimme_Schwelle ;
   repeat begin
      inc ( Warte_c ) ;
      SW_Timeout := ( Warte_c >  Max_Exakt_Wartezeit ) ;
      Sony_Read_Telegramm ;
      Sony_decode ;
   end until (Z2Zint (Sony_Tel.Status.Zaehler) >= Warte_Zeit_Sekunde)
             or SW_Timeout ;
   for Warte_c := 0 to Warte_Zeit_HFrame do Sony_Read_Telegramm;
end ;

procedure Pana_Warte_exact (Warte_Zeit_Sekunde, Warte_Zeit_HFrame : longint );
var  Warte_c : longint;
begin
   Warte_c := 0 ;
   repeat begin
      inc ( Warte_c ) ;
      Pana_Read_Telegramm ;
      Pana_Decode ;
   end until ( Z2Zint (Pana_tel.Status.Zaehler ) >= Warte_Zeit_Sekunde )
         OR  ( Warte_c                           >  Max_Exakt_Wartezeit ) ;

   for Warte_c := 0 to Warte_Zeit_HFrame do Pana_Read_Telegramm ;
end ;

procedure Warte_exact ( Kanal_Nummer, Warte_Zeit : longint ) ;
var  Fabrikat : string ; Warte_Sek, Warte_HFrame : longint ;
begin Warte_Sek   := Warte_Zeit div HFrames_sec ;
      if Warte_Sek < 0 then dec (Warte_Sek) ;
      Warte_Sek   := Warte_Sek  *   HFrames_sec ;

      Warte_HFrame := Warte_Zeit mod HFrames_sec ;
      if Warte_HFrame < 0 then Warte_HFrame := HFrames_sec - abs(Warte_HFrame);
      inc (Warte_HFrame) ;

      Waehle_Kanal ( Kanal_Nummer ) ;
      Fabrikat   := Erkenne_Fabrikat ;
      if Fabrikat = 'Sony'      then Sony_Warte_exact (Warte_Sek,Warte_HFrame);
      if Fabrikat = 'Panasonic' then Pana_Warte_exact (Warte_Sek,Warte_HFrame);
end ;

procedure Byte_to_CTL (in_byte : byte; var out_byte  : byte ;
                                       var Bit_Shift : longint );
{Transformiert Byte in Control-L faehige Variante }
var bi : longint ;
begin Bit_shift := 0 ;
      for bi := 7 downto 0 do
             if ((in_byte SHR bi ) AND $01 ) <> 0 then Bit_shift := bi ;
      out_byte := in_byte SHR (Bit_shift + 1) ;
      out_byte := NOT out_byte ;
end ;

function Sony_Send ( Tx_1, Tx_2, erwarteter_Status : byte ;
                      Max_Versuche : longint ) : longint ;
var Sende_Zeit, txdx1, txdx2, Zeit_nach_erstem_Byte,
    S_Versuche, d_shift : longint ;
    d_byte1, d_byte2 : byte ;
    CTL_Status : byte ;
begin
Sony_Send := -1 ;
Sony_Bestimme_Schwelle ;
if Sony_Schwelle <> 0 then begin
   {930 usec, 1 Start +8 Sendebits a 104 usec, ohne Stopbits}
   Sende_Zeit := (930 * S_Delay_Drehg_msec ) div 1000  ;

   Byte_to_CTL ( Tx_1,  d_byte1, d_shift ) ; {Befehlsbyte 0, meist $18 }
   txdx1 := CTL_Verzoegerung [  d_shift ] ;
   Zeit_nach_erstem_Byte := Sende_Zeit - txdx1 ;

   Byte_to_CTL ( Tx_2, d_byte2, d_shift ) ; {Befehlsbyte 1}
   txdx2 := CTL_Verzoegerung [  d_shift ] ;

   S_Versuche := 0 ;

   Sony_Read_Telegramm ;

   repeat begin
      while (portIn (MS_Port) AND $10) = 0 do {xxxxx} ;
      Warte (txdx1) ;
      portOut   (X_port, d_byte1) ;
      Warte (Zeit_nach_erstem_Byte ) ;

      while (portIn (MS_Port) AND $10) = 0 do {xxxxxx} ;
      Warte (txdx2) ;
      portOut   (X_port, d_byte2) ;
      Sony_Read_Telegramm ;
      inc ( S_Versuche ) ;
      CTL_Status := Sony_Tel.Chars [ 5 ] ;
   end until ( ( CTL_Status = erwarteter_Status ) or
               ( S_Versuche >= Max_Versuche )         ) ;

   Sony_Send := S_Versuche ;


end; end;

function  Sende_Draht_Befehl (KKanal,KBefehl : longint) : longint ;
var sdb : longint ; KTyp : string ;
begin Sende_Draht_Befehl := -1 ;
      if KKanal in [1..3] then begin
        Waehle_Kanal (KKanal) ;
        KTyp := Erkenne_Fabrikat ;

        if KTyp = 'Sony' then begin
          Sony_Read_Telegramm ;
          Sony_Decode ;
          sdb := -2 ;
          case KBefehl of
             CPlay    : sdb := Sony_Send ($18,Bf_Play  , Sony_Status_Play, 90 );
             CStop    : sdb := Sony_Send ($18,Bf_Stop  , Sony_Status_Stop, 90 );
             CPause   :
                case Sony_tel.Status.Wert of
                  Sony_Status_Playback_Pause :
                   sdb := Sony_Send($18,Bf_Pause,Sony_Status_Play, 90 ) ;
                  Sony_Status_Play :
                   sdb := Sony_Send($18,Bf_Pause,Sony_Status_Playback_Pause,90);
                  else sdb := Sony_Send ($18,Bf_Pause , 0      , 10 ) ;
                end ; {case case }
             CRew     : sdb := Sony_Send ($18,Bf_Rew   , Sony_Status_Rew , 90 );
             CFF      : sdb := Sony_Send ($18,Bf_FF    , Sony_Status_FF  , 90 );
             CRecord  : sdb := Sony_Send ($18,Bf_Record, Sony_Status_Record,90);
             CReverse : sdb := Sony_Send ($18,Bf_Reverse,        0, 4 ) ;
             CForward : sdb := Sony_Send ($18,Bf_Forward,        0, 4 ) ;
             CZero    : sdb := Sony_Send ($18,Bf_Counter_Reset,  0, 6 ) ;
             COff     : sdb := Sony_Send ($18,Bf_Power_Off,      0, 4 ) ;
          end ;
          if sdb > 88 then sdb := -3 ;
          Sende_Draht_Befehl := sdb ;
        end ;

        if KTyp = 'Panasonic' then Sende_Draht_Befehl := -4 ; { spaeter ... }

   end ;
end ;

function Eichschleife ( Eich_i : longint ) : Byte  ;
begin Sony_Read_Telegramm ;
      while (portIn (MS_Port) AND $10) = 0 do {xxxx} ;
      Warte (Eich_i) ;
      portOut (X_port, $55) ;
      repeat until (portIn (LSR_port) and $01) > 0  ;
      Eichschleife := NOT portIn ( X_port ) ;
end;

procedure Try_Control_L ( Max_versatz : longint ) ;
var expected : array [0 .. 7] of longint ;
    wx, wx1, wx2, wx2_sum : Longint ;
    wbyteA, wbyteB, wbyteC : byte ;
    Max_evaluate, CTL_i, TC_index, Schrittweite  : Longint ;
    Muster_E : array [ 0 .. 1005 ] of longint ;
begin if Sony_Schwelle <> 0 then begin
   Max_evaluate := 1000 ; {1 Millisekunde }
   expected [0] := $55 ;
   expected [1] := $AA ;
   expected [2] := $54 ;
   expected [3] := $A8 ;
   expected [4] := $50 ;
   expected [5] := $A0 ;
   expected [6] := $40 ;
   expected [7] := $80 ;
   CTL_i     := 0 ;
   TC_index  := 0 ;
   Schrittweite := S_Delay_Drehg_msec div 1000 ; { Schritte von 1 Usec }
   if Schrittweite < 1 then Schrittweite := 1 ;
   repeat begin
      wbyteA := Eichschleife ( CTL_i ) ;
      wbyteB := Eichschleife ( CTL_i ) ;
      wbyteC := 0 ;
      if wbyteA <> wbyteB then wbyteC := Eichschleife ( CTL_i ) ;

      X_Array [TC_Index] := 0 ; { Zwei von drei Auswahl :}
      if         wbyteA = wbyteB then X_Array [TC_Index] := wbyteA
         else if wbyteB = wbyteC then X_Array [TC_Index] := wbyteB
         else if wbyteC = wbyteA then X_Array [TC_Index] := wbyteC ;

      Muster_E [TC_Index] := 0     ;
      for wx := 1 to 5 do
         if X_Array [TC_Index] = expected [wx] then Muster_E [TC_Index] := wx ;

      inc (CTL_i, Schrittweite) ;
      inc (TC_Index) ;

   end until (TC_Index = Max_evaluate) or
             (Muster_E [(TC_Index-1)] = Max_versatz) ;


   for wx := 1 to ( Max_versatz - 1 ) do begin
      CTL_Verzoegerung [ wx] := 0 ;
      wx2 := 0 ; wx2_sum := 0 ;
      for wx1 := 0 to (CTL_i div Schrittweite) - 1 do
         if Muster_E [wx1] = wx then begin
               inc (wx2) ;
               inc (wx2_sum, wx1) ;
         end ;
      if wx2 <> 0 then CTL_Verzoegerung [ wx] := wx2_sum div wx2 ;
   end ;

    for wx := 1 to ( Max_versatz - 1 ) do begin
      CTL_Verzoegerung [wx] := CTL_Verzoegerung [wx] * Schrittweite ;
    end ;
    Quadrat_anpassung (CTL_Verzoegerung,1,( Max_versatz - 1 ),8) ;

end; end;

function UART_Messroutine( U_Tiefe : longint; var sox1, sox2 : longint):longint;
begin UART_Messroutine := -1 ;
      sox1 := 0 ;
      sox2 := 0 ;
      if Erkenne_Fabrikat = 'Sony' then begin
         Sony_Bestimme_Schwelle ;
         Try_Control_L ( U_Tiefe ) ;
         sox1 := CTL_Verzoegerung [1] ;
         sox2 := CTL_Verzoegerung [2] ;
         UART_Messroutine := 1 ;
      end ;
end ;

function Bef_Hex_String ( BHS_Code : THex_Code) : string ;
var bhs_str : string ; bhs_i : longint ;
begin bhs_str := '' ;
      bhs_i   := 1 ;
      while BHS_Code [bhs_i] >= 0 do begin
        bhs_str := bhs_str + hexb (BHS_Code [bhs_i] AND $00FF) + ' ';
        inc (bhs_i) ;
      end ;
      Bef_Hex_String := bhs_str ;
end ;

procedure Update_Zaehler ( UKanal : longint ; var m_Zaehler : TZaehler ;
                           var Cam_Typ, CStatus : string; var Playing: Boolean);
begin CStatus  := '??' ;
      Cam_Typ := '' ;
      if UKanal in [1..3] then begin
        Waehle_Kanal     (UKanal ) ;
        Cam_Typ := Erkenne_Fabrikat ;
        if Cam_Typ = 'Sony'      then with Sony_tel do begin
                  Sony_Bestimme_Schwelle ;
                  Sony_Decode ;
                  m_Zaehler := Status.Zaehler ;
                  CStatus   := Status.Zeichen ;
                  playing   := ( Status.Wert = Sony_Status_Play )  ;
        end ;
        if Cam_Typ = 'Panasonic' then with pana_tel do begin
                  Pana_Bestimme_Schwellen ;
                  Pana_Decode ;
                  m_Zaehler := Status.Zaehler ;
                  CStatus   := Status.Zeichen ;
                  playing   := ( (Status.Wert AND $0F) = $08 ) ;
        end;
      end ;
      if Cam_Typ = '' then Playing := false ;
end ;

procedure Warte ( d_usx : longint );
var d_w : longint ; begin for d_w := 1 to d_usx do ; end ;


{procedure Warte_1 ( d_usx : longint );
label schleife_d ;
begin
  asm
  mov ecx,d_usx          cx
  inc ecx
  schleife_d:
               loop schleife_d
  end;
end ;
}

procedure Warte_ms  ( d_ms : Longint ) ;
var dxi : longint; begin for dxi := 1 to d_ms do Warte(S_Delay_Drehg_msec); end;

function Maximum (m1, m2 : longint ) : longint ;
begin if m2 > m1 then Maximum := m2 else Maximum := m1 ; end ;

function Minimum (m1, m2 : longint ) : longint ;
begin if m2 < m1 then Minimum := m2 else Minimum := m1 ; end ;

procedure  Messe_1000_mal_aus ( Ml_Verzoegerungswert : longint ;
                                var Ml_Ergebnis, Ml_Anzahl : longint );
var bd_i, mess_pointer, Giga_Summe, Giga_Zaehler,
    Runden_Zaehler, R_maximum, R_Schwelle, Bandbreite : longint ;
    p_wert : byte ;
begin
   Runden_Zaehler := 0 ;
   Mess_pointer   := 0 ;
   setup_9600 ;
   repeat begin
      asm
         mov dx,LSR_Port
         in al,dx
         and al,$20
         mov p_wert,al
      end;

      if p_wert <> 0 then begin
          X_Array [mess_pointer] := Runden_Zaehler ;
          Runden_Zaehler := 0 ;
          inc (Mess_pointer) ;
          portOut (X_port, $FF );
          Warte (Ml_Verzoegerungswert) ;
      end else inc ( Runden_Zaehler ) ;
    end until mess_pointer > 1020 ;


    R_maximum := 0 ;
    for bd_i := 11 to 1010 do begin
        inc ( X_Array [bd_i] ) ; { Offset, wegen = 0 in Schleife }
        R_maximum := Maximum (R_maximum, X_Array [bd_i]);
    end ;

    Bandbreite := ( 2 { % } * (R_maximum div 100 ) ) + 1 ;

    R_schwelle := R_maximum - Bandbreite ;

    Giga_Summe   := 0 ;
    Giga_Zaehler := 0 ;
    for bd_i := 11 to 1010 do if X_Array [bd_i] > R_schwelle then begin
        inc ( Giga_Summe, X_Array [bd_i] ) ;
        inc ( Giga_Zaehler ) ;
    end ;

    Giga_Summe := (1000 * Giga_Summe) div Giga_Zaehler ;

    Ml_Ergebnis := ( Giga_Summe * 96 ) div 100 ;
    Ml_Anzahl  := Giga_Zaehler ;
end ;

function XI_Delay ( M_Ergeb, B_Ergeb, B_Vorgab : longint ) : longint ;
var      x_Differenz, x_Delayzeit_in_Sek, x_DrehZeit_in_Sek :  real ;
begin XI_Delay := 100 ;
      if (B_Vorgab = 0) and (M_Ergeb <> 0) then XI_Delay := M_Ergeb div 40 ;
      if ( M_Ergeb > B_Ergeb ) AND (B_Vorgab > 0 ) AND
         ( M_Ergeb > 0       ) AND (B_Ergeb  > 0 ) then begin
       x_Differenz := M_Ergeb - B_Ergeb ;
       x_Delayzeit_in_Sek  := (x_Differenz * 1000000.0) / M_Ergeb   ;
       x_DrehZeit_in_Sek   := x_Delayzeit_in_Sek / (B_Vorgab * 960) ;
       XI_Delay            := round ( 1000.0 / x_DrehZeit_in_Sek )  ;
      end ;
end ;

procedure Bestimme_Drehzahl (
      var Delay_Drehg_msec, Anfragen_pSec, PNr, PAbweichung, PQuote : longint;
      var Fehlercode : string  ) ;
var iteration : longint ;
    Vorgabe, Ergebnis, Quote, Delays : array [0 .. 31] of longint ;
begin
    Fehlercode := '' ;
    Delay_Drehg_msec := 1000   ;
    Anfragen_pSec    := 100000 ;
    PNr         := 0 ;
    PAbweichung := 0 ;
    PQuote      := 0 ;
    com_setup (SIO_Kanal, 9600, Bits8 + Parity_off + stops_1 ) ;

  if(portIn(LSR_Port) and LSR_TX_Empty)= 0 then insert(' *COM ? ',Fehlercode,1);

if Fehlercode = '' then begin

   iteration   := -1 ;
   Vorgabe [0] :=  0 ;
   repeat begin
     inc ( iteration ) ;
     Messe_1000_mal_aus
            ( Vorgabe [iteration], Ergebnis [iteration], Quote [iteration] );
     Delays [iteration] :=
          XI_Delay ( Ergebnis [0], Ergebnis [iteration], Vorgabe [iteration]);
     Vorgabe [iteration + 1] :=
            ( Delays [iteration] * (iteration + 1) * 25 ) div 960 ;
   end until ( Ergebnis [iteration] <  (Ergebnis[0] div 20) ) or
             ( Quote    [iteration] <  400 ) or
             ( iteration            >= 30  )     ;


   Delays              [0] := Delays [1] ;
   Delays  [iteration +1 ] := - 1        ;
   PNr                     := iteration ;

   Quote [0]               := Quote [1] ;
   Quote [iteration + 1 ]  := -1        ;

   if iteration < 3 then insert ('** Achtung: Iterationen < 3 **',Fehlercode,1);


   Delay_Drehg_msec        := Mittel_wert ( Delays , 0 ) ;

   PAbweichung             := Abweichung  ( Delays ) ;
   PQuote := Mittel_wert (Quote, 0) ;
   Anfragen_pSec           := Ergebnis [0] ;

end;
end ;


procedure IR_einlesen ;
var p_wert, p_wert_alt : byte ;
    mess_pointer, lir,
    ms_counter, Zu_kurz_Schwelle, Laengster_Impuls,
    Zaehler_IRBefehl_Ende, Runden_Zaehler1, T_15_Sekunden  : longint ;
    IR_Impulse_zu_kurz : Boolean ;
begin
  Zaehler_IRBefehl_Ende := S_Anfragen_pSec div 2 ;
  T_15_Sekunden := 15 * S_Anfragen_pSec ;

  Runden_Zaehler1 := 0 ;
  mess_pointer    := 1 ;

  ms_counter := 0 ;
  p_wert     := portIn ( MS_Port ) and MS_DSD ;
  p_wert_alt := p_wert ;

  repeat begin
       inc (ms_counter ) ;
       p_wert := portIn ( MS_Port ) and MS_DSD ;
  end until (p_wert <> p_wert_alt ) OR ( ms_counter > T_15_Sekunden );

  p_wert_alt := p_wert ;
  repeat begin  { so schnell wie moeglich }
      asm
         mov dx,MS_Port
         in al,dx
         and al,$20
         mov p_wert,al
      end;

      if  p_wert_alt <> p_wert then begin
          p_wert_alt := p_wert  ;
          X_Array [mess_pointer] := Runden_Zaehler1 ;
          Runden_Zaehler1 := 0 ;
          if Mess_pointer < (max_X-3) then inc (Mess_pointer) ;
      end else inc ( Runden_Zaehler1 ) ;
    end until Runden_Zaehler1 > Zaehler_IRBefehl_Ende ;

  X_Array [Mess_pointer   ] := 0 ; {Endemarkierung}
  X_Array [Mess_pointer+1 ] := 0 ;
  X_Array [Mess_pointer+2 ] := 0 ;

  dec (mess_pointer) ;
  IR_Burstende := mess_pointer ;
  { Ausgleich fuer := 0 setzen }
  for lir := 1 to mess_pointer do inc (X_Array[lir]) ;

  if Mess_pointer >= (max_X-3) then insert (' *Ueberlauf* ', Errorcode, 1 );

  if ms_counter >= T_15_Sekunden then insert (' *Timeout* ', Errorcode, 1 );

  {Bei 38 kHz dauert ein Impuls 26 usec. Spikes, die
  weniger als 4 Impulse, 100 usec dauern, raus ! }
  Zu_kurz_Schwelle := S_Anfragen_pSec div 10000 ;
  IR_Impulse_zu_kurz := false ;
  Laengster_Impuls := X_Array [1] ;
  for lir := 1 to Mess_pointer do begin
    if X_Array [lir] < Zu_kurz_Schwelle then IR_Impulse_zu_kurz := true ;
    Laengster_Impuls := Maximum ( Laengster_Impuls, X_Array [lir] );
  end ;

  if IR_Impulse_zu_kurz then insert (' *Impulse zu kurz* ', Errorcode, 1); 
  if NOT ODD (Mess_Pointer) then insert(' *falsche # IR Impulse ', Errorcode,1);

end;

function Bestimme_Bit_Zeit ( BS_Start, BS_Ende : longint ) : longint ;
var bb_i : longint ;
    x_minimum, MW_i, MW_Summe, BBZ_Arbeit : longint ;
begin
   bb_i := BS_Start ;
   x_minimum := X_Array [bb_i] ;
   repeat begin
      X_Minimum := Minimum ( X_Minimum, X_Array [bb_i] ) ;
      inc (bb_i,2) ;
   end until bb_i > BS_Ende ;

   bb_i := BS_Start ;
   MW_i := 0 ;
   MW_Summe := 0 ;
   repeat begin
      if X_Array [bb_i] < ((X_Minimum * 3) div 2 ) then begin
         inc (MW_Summe, X_Array [bb_i] );
         inc (MW_i) ;
      end ;
      inc (bb_i,2) ;
   end until bb_i > BS_Ende ;
   if MW_i <> 0 then    BBZ_Arbeit := (MW_Summe div MW_i) else BBZ_Arbeit := 1;
   Bestimme_Bit_Zeit := BBZ_Arbeit ;
end ;

procedure Bestimme_Bitlaenge ;
begin if Last_correct_Bit < 3 then Last_correct_Bit := IR_Burstende ;
      AN_Bit_Zeit := Bestimme_Bit_Zeit ( 1, Last_correct_Bit ) ;
      AUS_Bit_Zeit := Bestimme_Bit_Zeit ( 2, Last_correct_Bit ) ;
end;

procedure Puzzle_Bits_Auseinander (start_bit : longint;
             var stop_bit : longint;
             var PBA_Code : THex_Code );
const max_anzbits = 300 ;
var PB_anzbits : array [0 .. max_anzbits] of longint ;
    mittlere_Bit_Laenge, pb_i, pb_j,
    bFaktor, bit_counter, byte_c, bit_pos  : longint ;
begin
    for pb_i := 0 to Hex_max     do PBA_Code   [pb_i] := 0 ;
    Bestimme_Bitlaenge ;
    stop_bit := start_bit ;
    bit_counter := 0 ;
    mittlere_Bit_Laenge := ( AN_Bit_Zeit + AUS_Bit_Zeit ) div 2 ;
    while ( X_Array [stop_bit] <> 0 )
     and (( X_Array [stop_bit] div mittlere_Bit_Laenge ) < 30 ) do begin
       pb_i := (X_Array [stop_bit] *100 ) div mittlere_Bit_Laenge ;
       if pb_i < 1 then pb_i := 1 ;
       pb_anzbits [bit_counter] := pb_i ;
       inc (stop_bit) ;
       if bit_counter < (max_anzbits - 3) then inc (bit_counter) ;
    end ;
    pb_anzbits [bit_counter    ] := 0 ;
    pb_anzbits [bit_counter + 1] := 0 ;

    dec (stop_bit) ;

    byte_c  := 0 ;
    bit_pos := 0 ;
    for pb_j := 0 to bit_counter - 1 do
       for pb_i := 1 to round (pb_anzbits [pb_j]/100) do begin
          bit_pos := bit_pos mod 8 ;
          if (bit_pos = 0) and (byte_c < (Hex_max-1)) then inc (byte_c) ;
          if not odd ( pb_j ) then begin
            case bit_pos of
               0 : bFaktor := 128 ;  3 : bFaktor := 16 ;  6 : bFaktor := 2 ;
               1 : bFaktor :=  64 ;  4 : bFaktor :=  8 ;  7 : bFaktor := 1 ;
               2 : bFaktor :=  32 ;  5 : bFaktor :=  4 ;
               else bFaktor :=   1 ;
            end ;
            PBA_Code [byte_c] := (PBA_Code [byte_c] + bFaktor) mod 256 ;
          end ;
          inc (bit_pos) ;
       end ;

    inc (byte_c) ;
    PBA_Code [byte_c] := -1 ;
end ;

procedure Bestimme_Basisbefehle ;
var bb_i, bb_j, Wiederholungs_zaehler : longint ;
begin
    Wiederholungs_zaehler := 0 ;
    bb_i := 1 ;
    while (X_Array [bb_i] <> 0) and (bb_i < (Max_X - 3))
          and (Wiederholungs_zaehler < max_Code) do begin
       inc (Wiederholungs_zaehler) ;
       Puzzle_Bits_Auseinander(bb_i, bb_j, Bef_array [Wiederholungs_zaehler]);
       if Wiederholungs_zaehler = 1 then Single_Laenge := bb_j ;

       bb_i := bb_j + 2 ;
    end ;
end;

procedure Suche_Wiederholung_und_Korrigiere_Messwerte;
{ Die Messung wird durch Interrupts verfaelscht. _Wenn_ die
Befehle mehrfach kommen, kann man diese Verfaelschungen korrigieren ! }
var xxi, xxj, Zeit_zwischen_Befehlen : longint ;
    Aufsatzpunkte : array [0 .. 20] of longint ;
    Falscher_Aufsetzpunkt : Boolean ;
begin
    Zeit_zwischen_Befehlen := 4 * (laengster_Impuls + kuerzeste_Pause);

    Anzahl_Befehlspausen := 0 ;
    Falscher_Aufsetzpunkt := false ;
    Aufsatzpunkte [1] := 0 ;

    for xxi := 1 to IR_Burstende do
        if X_Array [xxi] > Zeit_zwischen_Befehlen then begin
           inc (Anzahl_Befehlspausen) ;
           Aufsatzpunkte [Anzahl_Befehlspausen] := xxi ;
           if xxi <> (Anzahl_Befehlspausen * Aufsatzpunkte [1]) then begin
              Falscher_Aufsetzpunkt := true ;
           end ;
        end ;

    Anzahl_Wiederholungen := Anzahl_Befehlspausen + 1 ;  {erste Vermutung }
    { Richtiges Ende ? }
    if  (IR_Burstende + 1 ) <> ( Anzahl_Wiederholungen * Aufsatzpunkte [1] )
       then begin
           dec (Anzahl_Wiederholungen) ;
           insert('* Wiederholung nur teilweise *',Errorcode,1);
       end ;

    if Falscher_Aufsetzpunkt then insert(' * Aufsetzpunkt falsch*',Errorcode,1);

    { Hier wird korrigiert : }
    for xxi := 1 to Anzahl_Wiederholungen - 1 do
        for xxj := 1 to Aufsatzpunkte [1] do
           X_Array [xxj] := Maximum (
              X_Array [xxj],
              X_Array [xxj + Aufsatzpunkte [xxi] ] ) ;

    if Anzahl_Befehlspausen > 0 then Last_correct_Bit := Aufsatzpunkte [1] - 1 ;
end ;

procedure Korrigiere_Totzeiten ;
{ Die Messung wird dadurch verfaelscht, da der verwendete
Baustein, z.B. TSL 261, Totzeiten hat. TSL 261 Flanken sind laut Datenblatt
symetrisch und jeweils ca. 90 usec lang. Durch die niedrige
Schaltschwelle des V.24 Treibers 14c88 bedingt schaltet der TSL 261
"unmittelbar" beim ersten IR Puls ein, "sieht" also die ansteigende
Flanke gar nicht. Allerdings hat er beim Ausschalten eine
messbare Verzoegerung von
Abfallzeit_IR_Detektor_SIO   usec. Um Typstreuungen auszugleichen
sind genaue Messung auch per SW moeglich, aber noch nicht drin.
SFH 506 oder SFH 507 o.ae. noch nicht getestet, sollte aber gehen}

var K_Anzahl : longint ; Impuls_zu_kurz : Boolean ;
begin

    K_Anzahl       := 1 ;
    Impuls_zu_kurz := false ;
    repeat begin
        if ( X_Array [K_anzahl  ] <> 0 ) and
           ( X_Array [K_anzahl  ]  > Abfallzeit_IR_Detektor_SIO ) then
            dec (X_Array [K_anzahl  ] , Abfallzeit_IR_Detektor_SIO ) ;

        if ( X_Array [K_anzahl  ]  <= Abfallzeit_IR_Detektor_SIO ) then
               Impuls_zu_kurz := true ;

        if X_Array [K_anzahl+1] <> 0 then
            inc (X_Array [K_anzahl+1] , Abfallzeit_IR_Detektor_SIO ) ;

        inc (K_Anzahl,2) ;
    end until (X_Array [K_anzahl    ] = 0 ) OR
              (X_Array [K_anzahl - 1] = 0 ) ;
    if Impuls_zu_kurz then insert ('Impuls zu kurz ', Errorcode, 1) ;
end ;

procedure Rechne_auf_usec_um ;
var K_Anzahl : longint ;
begin
    K_Anzahl := 1 ;
    repeat begin
      X_Array [K_anzahl] := ( ( (X_Array [K_anzahl] * 10000 )div
              (S_Anfragen_pSec div 1000) )
                                + 5 ) div 10;
      inc (K_Anzahl) ;
    end until ( X_Array [K_anzahl] = 0 ) ;
end ;

procedure Code_Statistik ;
var coi : longint ;
begin
      kuerzester_Impuls := X_Array [1] ;
      laengster_Impuls  := X_Array [1] ;

      coi := 1 ;

      while X_Array [ 2*coi + 1 ] <> 0 do begin
        kuerzester_Impuls := Minimum (kuerzester_Impuls, X_Array [2*coi + 1]);
        laengster_Impuls  := Maximum (laengster_Impuls,  X_Array [2*coi + 1]);
        inc (coi) ;
      end ;

      kuerzeste_Pause := X_Array [2] ;
      laengste_Pause  := X_Array [2] ;

      coi := 1 ;
      while X_Array [ 2*coi + 1] <> 0 do begin
        kuerzeste_Pause := Minimum (kuerzeste_Pause, X_Array [2*coi ]);
        laengste_Pause  := Maximum (laengste_Pause,  X_Array [2*coi ]);
        inc (coi) ;
      end ;
end ;


procedure IR_Lernen ( var XL_Befehl : TIR_Befehl ;
                      var XL_Code, XL_Error, XL_Kommentar  : String  ) ;
var ir_i , i_egal : longint ;  dirty_hex : THex_Code ;
begin
    Setup_9600 ;
    Waehle_Kanal (3) ;
    XL_Befehl.IR_Muster [0] := 1  ;  {Vorbesetzung, damit immer was da ist}
    XL_Code      := '' ;
    XL_Error     := '' ;
    XL_Kommentar := '' ;
    Errorcode    := '' ;

    IR_einlesen ;

    Last_correct_Bit := IR_Burstende ;

    if Errorcode = '' then Rechne_auf_usec_um ;
    if Errorcode = '' then Korrigiere_Totzeiten ;
    Code_Statistik ;

    { Falls Errorcode <> '', soll wenigstens das Gemessene uebertragen
      werden, nach welchen Regeln immer es komponiert wurde }
    for ir_i := 1 to TIR_max do XL_Befehl.IR_Muster [ir_i] := X_Array [ir_i] ;
    XL_Befehl.IR_Muster [TIR_max] := 0 ; { Deckel drauf }

    Anzahl_Wiederholungen := 0 ;
    Anzahl_Befehlspausen  := 0 ;
    if Errorcode = '' then Suche_Wiederholung_und_Korrigiere_Messwerte ;

    Bestimme_Basisbefehle ;

    if Errorcode = '' then begin
        XL_Befehl.IR_Muster [0] := Anzahl_Wiederholungen ;
        for ir_i := 1 to Single_Laenge + 1 do
                          XL_Befehl.IR_Muster [ir_i] := X_Array [ir_i] ;
        XL_Befehl.IR_Muster [Single_Laenge + 2] := 0 ;
        XL_Befehl.IR_Muster [Single_Laenge + 3] := 0 ;
        XL_Code   := Bef_Hex_String ( Bef_array [1] ) ;
    end else begin
        Puzzle_Bits_Auseinander (1, i_egal, dirty_hex ) ;
        XL_Code := Bef_Hex_String ( dirty_hex ) ;
        XL_Kommentar := 'Befehl nicht sauber' ;
    end ;

    XL_Error  := Errorcode ;
    { quick and very very very dirty : }
    with XL_Befehl do if IR_Muster [0] < 1 then IR_Muster [0] := 1  ;
end;

procedure  Burst_out (Nr_Bursts : longint) ; {Sendet Infrarotblitze}
var bo_i : longint ;
begin if not Send_timeout then begin
   for bo_i := 1 to (Nr_Bursts div 3 ) do begin
           Wait_till_out ;
           portOut (x_port, $5B ){Muster 100100100 } ;
   end ;
   case ( Nr_Bursts mod 3 ) of
      1 : begin  Wait_till_out ;
                 portOut (x_port, $FF ) {Muster 100000000 } ;
          end ;
      2 : begin  Wait_till_out ;
                 portOut (x_port, $FB ) {Muster 100100000 } ;
          end ;
   end ; { case }
   Wait_till_out ;
end ; end ;

procedure IR_Senden ( XS_Befehl : TIR_Befehl ) ;
var Zeit, Zeit_zuviel, Warte_wert : real ; { in usec }
    Anz_pulse : longint ;
    Puls_Nummer, ir_j : longint ;
begin COM_setup (SIO_Kanal, 115, bits7 + stops_1 + parity_off );
      Waehle_Kanal (0) ;
      Send_timeout := false ;
      Warte_ms ( 100 ) ;
      Zeit_zuviel := 0 ;
      Puls_Nummer := 1 ;
      repeat begin  {erst rechnen, dann blitzen; Sonst mehr Jitter ! }
        Zeit := XS_Befehl.IR_Muster [Puls_Nummer]  ; ;
        if odd (Puls_Nummer) then begin  { IR Senden }
           Anz_Pulse := round (Zeit * 38400.0/1000000.0 ) ;
           X_Array [Puls_Nummer] := Anz_pulse ;
           Zeit_zuviel := (Anz_pulse mod 3) * ((10000/384)/3) ;
        end else begin  { Schweigen ... }
           Zeit := Zeit - Zeit_zuviel ;
           Warte_wert := (Zeit * S_Delay_Drehg_msec) / 1000.0  ;
           X_Array [Puls_Nummer] := - round (Warte_wert) ;
        end ;
        inc (Puls_Nummer) ;
        X_Array [Puls_Nummer] := XS_Befehl.IR_Muster [Puls_Nummer] ;
      end until XS_Befehl.IR_Muster [Puls_Nummer] = 0 ;

      for ir_j := 1 to XS_Befehl.IR_Muster [0] do begin
        Puls_Nummer := 1 ;
        while  X_Array [Puls_Nummer] <> 0 do begin
            if X_Array [Puls_Nummer] > 0
               then Burst_Out (   X_Array [Puls_Nummer] )
               else Warte     ( - X_Array [Puls_Nummer] ) ;
            inc (Puls_Nummer) ;
        end ;
      end ;
end;

end.
