/* Event-Handler/Mapper Routines for the CT-Player-Project,version 1.0.

	Copyright (C) 1999 Marcus Schwatke, Andreas Kemper

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <conio.h>
#include "parms.h"
#include "events.h"
#include "regio.h"

EMapEntry EMap[EVNTID_COUNT];
extern lcdemu;

/* Init der EventMap */
void Evnt_Init()
{
	int i;
	for(i=0;i<EVNTID_COUNT;i++)	/* Alle moeglichen Events zunaechst 0 setzen */
	{
		EMap[i].rc5		= 0;
		EMap[i].dreh	= 0;
		EMap[i].taste	= 0;
	}
}

/* Laed die Map aus Datei */
int Evnt_Load(char *fn)
{
	FILE *in;
	int ir,taste,dreh,cmd,cnt=0,ret;

	if ((in = fopen(fn, "r")) == NULL)	/* Versuche Inidatei zu oeffnen */
	{
		/* Default-Werte annehmen falls Datei nicht geoeffnet wurde */
		Evnt_Assign();
		return FALSE;
	}

	do
	{
		ret=fscanf(in, "%d: %d %d %d", &cmd,&ir,&taste,&dreh);

		if(ret!=EOF)	/* Werte aus Datei lesen und in Struktur schreiben */
		{
			if(cmd<EVNTID_COUNT)
			{
				EMap[cmd].rc5	= ir;
				EMap[cmd].taste	= (byte)taste;
				EMap[cmd].dreh	= (char)dreh;
			}
			else
				break;
		}
		cnt++;
	} while ((ret != EOF)||(cnt==20));

	fclose(in);
	return TRUE;
}

/* Belegt die Map mit default-Werten (Keine Datei gefunden)*/
void Evnt_Assign()
{
	EMap[EVNTID_CURSORUP].rc5	 = 0;
	EMap[EVNTID_CURSORUP].dreh	 = -1;
	EMap[EVNTID_CURSORUP].taste	 = 2;

	EMap[EVNTID_CURSORDWN].rc5	 = 0;
	EMap[EVNTID_CURSORDWN].dreh	 = 1;
	EMap[EVNTID_CURSORDWN].taste = 1;

	EMap[EVNTID_OK].rc5	         = 0;
	EMap[EVNTID_OK].dreh         = 0;
	EMap[EVNTID_OK].taste        = 8;

	EMap[EVNTID_CANCEL].rc5	     = 0;
	EMap[EVNTID_CANCEL].dreh	 = 0;
	EMap[EVNTID_CANCEL].taste	 = 4;

	EMap[EVNTID_TOGGLE].rc5	     = 0;
	EMap[EVNTID_TOGGLE].dreh	 = 0;
	EMap[EVNTID_TOGGLE].taste	 = 128;

	EMap[EVNTID_NEXTDIR].rc5	 = 0;
	EMap[EVNTID_NEXTDIR].dreh	 = 0;
	EMap[EVNTID_NEXTDIR].taste	 = 64;

	EMap[EVNTID_PREVDIR].rc5	 = 0;
	EMap[EVNTID_PREVDIR].dreh	 = 0;
	EMap[EVNTID_PREVDIR].taste	 = 32;
}

/* Ordnet einem externen Event (rc5,dreh,taste) einen internen */
/* Befehl zu (play,skip, usw.)*/
int Evnt_Map(byte type,int cmd)
{
	int i;

	if (cmd==0)		/* Bei ungueltigem Event keinen Steuerbefehl zurueckgeben */
		return EVNT_UNKNOWN;

	for(i=0;i<EVNTID_COUNT;i++)	/* Alle acht internen Ereignisse pruefen */
	{
		/* Besonderheit bei RC5-Events - diese werden auch ohne internes */
		/* Mapping zu Kontroll- und Anpassungszwecken ausgegeben */
		if((type==EVNT_RC5)&&(EMap[i].rc5==cmd))
		{
				if(lcdemu==TRUE)
				{
					gotoxy(1,8);
					printf("ir received %5d\n",cmd);
				}
				return i;
		}
		else if(type==EVNT_RC5)
		{
				if(lcdemu==TRUE)
				{
					gotoxy(1,8);
					printf("ir received %5d\n",cmd);
				}
		}
		/* Fuer den Drehknopf werden je nach Richtung zwei Events unterschieden */
		if(type==EVNT_DREH)
		{
			if(((cmd^0x80)&&(EMap[i].dreh==1))||((cmd&0x80)&&(EMap[i].dreh==-1)))
			{
				if(lcdemu==TRUE)
				{
					gotoxy(1,9);
					printf("dial turned %2d,%3d\n",EMap[i].dreh,cmd);
				}
				return i;
			}
		}
		/* Die max. acht Tasten koennen an Hand der binaeren */
		/* Wertigkeit unterschieden werden */
		if((type==EVNT_TASTE)&&(EMap[i].taste&cmd))
		{
				if(lcdemu==TRUE)
				{
					gotoxy(1,10);
					printf("key pressed %3d\n",cmd);
				}
				return i;
		}
	}
	return EVNT_UNKNOWN;		/* Kein passenden Befehl gefunden */
}

/* Prueft, ob ein RC, IR, oder Tastencode anliegt */
int Evnt_Check()
{
	int ir_code, event;
	char stat;
	if(lcdemu==TRUE)	/* Im Emulationsmodus zuerst moegliche Tastaturein- */
							/* gabe abfangen und zuordnen */
	{
		if( kbhit() )
		{
				switch(getch())	/* Genau eine Taste einlesen und zuordnen */
				{
					case  27:
						return EVNTID_CANCEL;
					case 'q':
						return EVNTID_CANCEL;
					case 'i':
						return EVNTID_CURSORUP;
					case 'm':
						return EVNTID_CURSORDWN;
					case 'l':
						return EVNTID_OK;
					case 'j':
						return EVNTID_CANCEL;
					case 'o':
						return EVNTID_NEXTDIR;
					case 'u':
						return EVNTID_PREVDIR;
					case 'k':
						return EVNTID_TOGGLE;
				}
		}
	}

	/* Vorinitialisierung des Rueckgabewertes mit ungueltigem Event */
	event=EVNT_UNKNOWN;

	/* Vor dem Auslesen etwaiger HW-events INTs sperren, um nicht durch */
	/* MP3-Daten unterbrochen zu werden */
	asm cli;

	/* Zum Lesen von HW-Events zunaechst Typ des Events durch */
	/* ersten Lesezugriff bestimmen */
	stat = Reg_Read(RD_INP_STAT)&RD_STAT_MASK;

	/* Zur weiteren Auswertung einer der drei moeglichen Eventtypen wird */
	/* prinzipiell zunaechst ein Schreibzugriff durchgefuehrt, um im folgenden */
	/* Schritt die gewuenschten Daten aus dem dynamisch zugewiesenen Atmel- */
	/* Register zu lesen */
	if(stat&EVNTMASK_TASTE)
	{
		Reg_Write(WR_INP_SEL,GET_KEY_INP);				/* Tastendaten auswaehlen */
		event=Evnt_Map(EVNT_TASTE, Reg_Read(RD_INP_VAL));
		asm sti;
		return event;
	}
	if(stat&EVNTMASK_DREH)
	{
		Reg_Write(WR_INP_SEL,GET_KNOP_INP);			/* Drehknopfdaten auswaehlen */
		event=Evnt_Map(EVNT_DREH, Reg_Read(RD_INP_VAL));
		asm sti;
		return event;
	}
	if(stat&EVNTMASK_RC5)
	{
		/* Achtung: Hier ist es wichtig erst die Adresse, dann die Daten zu */
		/* lesen, da andernfalls die Informationen u.U. ungueltig sind */
		Reg_Write(WR_INP_SEL,GET_IR_ADR);				/* IR-Adresse lesen */
		ir_code=((Reg_Read(RD_INP_VAL)&0x1f)<<8);		/* 5 Adressbits auswerten */
		Reg_Write(WR_INP_SEL,GET_IR_DATA);				/* IR-Daten lesen */
		ir_code+=(Reg_Read(RD_INP_VAL)&0x3f);			/* 6 Datenbits auswerten */
		event=Evnt_Map(EVNT_RC5, ir_code);
		asm sti;
		return event;
	}
	asm sti;
	return event;
}
