/* LowLevel Routines for the CT-Player-Project,version 1.0.

	Copyright (C) 1999 Marcus Schwatke, Stefan Verse, Andreas Kemper

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "parms.h"
#include "masisr.h"
#include "regio.h"
#include "dos.h"

extern MASLPTPARAMS lptP;

/* Byte direkt an Port schreiben */
int Reg_Write(byte reg,byte data)
{
	int tot=0;

	/* Bedeutung der uebergebenen Registerkommandos */
	/* strg[0]->WR_MP3: Ausgabe von MP3-Daten */
	/* strg[1]->WR_INP_SEL: Ausgabe eines Atmel-Steuerbefehls */
	/* strg[2]->WR_LCD_CMD: LCD Steuerkommando schreiben */
	/* strg[3]->WR_LCD_CHAR: LCD Zeichen schreiben */
	const byte strg[]= {0x1a,0x12,0x18,0x10};

	/* Schreibzugriff mit Strobeflag=0 ankuendigen */
	outp(lptP.lptCtrl,strg[reg]);
	/* Daten parallel anlegen */
	outp(lptP.lptAdr,data);
	/* Daten mit Strobeflag=1 gueltig setzen */
	outp(lptP.lptCtrl,strg[reg]+STROBE);

	/* Setzen des BUSY-Flags abwarten */
	tot=0;
	while(!(inp(lptP.lptStat)&BUSY)&&(tot++<1000));

	/* Strobeflag zuruecknehmen */
	outp(lptP.lptCtrl,strg[reg]);

	/* Ruecknahme des BUSY-Flags abwarten */
	tot=0;
	while((inp(lptP.lptStat)&BUSY)&&(tot++<1000));

	return TRUE;
}

/* Byte direkt vom Port lesen */
byte Reg_Read(byte reg)
{
	int tot=0;

	/* strg[0]->RD_INP_STAT: Atmelstatus lesen */
	/* strg[1]->RD_INP_VAL: Benutzereingabe lesen */
	const byte strg[]= {0x3e,0x36};
	byte  i,x,p,ret=0;

	if(lptP.lptUnidir==PMODE_UNIDIR) /* Serielles Lesen  */
	{
		/* Strobesignal togglen um Lesen anzukuendigen */
		outp(lptP.lptCtrl,strg[reg]);
		outp(lptP.lptCtrl,strg[reg]+STROBE);

		/* Warten auf Busyflag=high und Auslesen des ersten Bits ber Error-Ltg */
		while(!((p=inp(lptP.lptStat))&BUSY)&&(tot++<100));

		/* Gelesenes Bit auswerten */
		if(p&0x08)
			x=1;
		else
			x=0;

		/* Auslesen der restlichen sieben Bits */
		for(i=1;i<8;i++)
		{
			/* Strobeflag setzen, Initflag zuruecknehmen */
			outp(lptP.lptCtrl,strg[reg]+STROBE-INIT);

			/* Warten auf Busyflag=low innerhalb des Timeout */
			tot=0;
			while((inp(lptP.lptStat)&BUSY)&&(tot++<1000));

			/* Initflag erneut setzen */
			outp(lptP.lptCtrl,strg[reg]+STROBE);

			/* Warten auf Busyflag=high innerhalb des Timeout */
			tot=0;
			while(!((p=inp(lptP.lptStat))&BUSY)&&(tot++<1000));

			/* Gelesenes Bit auswerten */
			if (p&0x08)
				x = x +(1<<i);
		}

		/* Steuerregister auf urspruenglichen Wert zuruecksetzen */
		outp(lptP.lptCtrl,strg[reg]);

		/* Vor Beendigung der Routine noch auf Ruecknahme des Busyflags warten */
		tot=0;
		while(((p=inp(lptP.lptStat))&BUSY)&&(tot++<1000));

		ret=x;
	}
	else	/* Paralleles Lesen */
	{
		/* Strobesignal togglen um Lesen anzukndigen */
		outp(lptP.lptCtrl,strg[reg]);
		outp(lptP.lptCtrl,strg[reg]+STROBE);

		/* Warten auf Busy=high innerhalb des Timeout */
		tot=0;
		while(!(inp(lptP.lptStat)&BUSY)&&(tot++<1000));

		/* Lesen des parallel anliegenden Bytes */
		ret = inp(lptP.lptAdr);

		/* Steuerregister auf urspruenglichen Wert zuruecksetzen */
		outp(lptP.lptCtrl,strg[reg]);

		/* Vor Beendigung der Routine noch auf Ruecknahme des Busyflags warten */
		tot=0;
		while((inp(lptP.lptStat)&BUSY)&&(tot++<1000));
	}

	return ret;
}

