'   Stand: 24.03.1999
'   ----------------------------------------------------------------------
'
'   NoAd: Keine Werbung auf dem Viorekorder: PC Steuerung
'   Copyright (C) 1999 Peter Richert (Richert@FH-Muenster.DE)
'
'   Telefon +49 2551 9-62125, Fax -62391
'
'   Fachhochschule Mnster, Fachbereich Elektrotechnik
'   eLKaTe - Labor Kommunikationstechnik
'   Stegerwaldstrasse 39, 48565 Steinfurt, GERMANY
'
'   ----------------------------------------------------------------------
'   This program is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License as published by
'   the Free Software Foundation; either version 2 of the License, or
'   (at your option) any later version.
'
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'   ----------------------------------------------------------------------
'

Attribute VB_Name = "Modul2"
'Konstanten
Const VK_SNAPSHOT As Byte = &H2C

Private Type PALETTEENTRY
       peRed As Byte
       peGreen As Byte
       peBlue As Byte
       peFlags As Byte
End Type

Private Type LOGPALETTE
       palVersion As Integer
       palNumEntries As Integer
       palPalEntry(255) As PALETTEENTRY ' Enough for 256 colors
End Type

Private Type GUID
       Data1 As Long
       Data2 As Integer
       Data3 As Integer
       Data4(7) As Byte
End Type

Private Const RASTERCAPS As Long = 38
       Private Const RC_PALETTE As Long = &H100
       Private Const SIZEPALETTE As Long = 104

Private Type RECT
       Left As Long
       Top As Long
       Right As Long
       Bottom As Long
End Type

Private Type PicBmp
       Size As Long

Type As Long
       hBmp As Long
       hPal As Long
       Reserved As Long
End Type

Private Declare Function OleCreatePictureIndirect Lib "olepro32.dll" (PicDesc As PicBmp, RefIID As GUID, ByVal fPictureOwnsHandle As Long, IPic As IPicture) As Long
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Private Declare Function GetDeviceCaps Lib "gdi32" (ByVal hdc As Long, ByVal iCapabilitiy As Long) As Long
Private Declare Function GetSystemPaletteEntries Lib "gdi32" (ByVal hdc As Long, ByVal wStartIndex As Long, ByVal wNumEntries As Long, lpPaletteEntries As PALETTEENTRY) As Long
Private Declare Function CreatePalette Lib "gdi32" (lpLogPalette As LOGPALETTE) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function BitBlt Lib "gdi32" (ByVal hDCDest As Long, ByVal XDest As Long, ByVal YDest As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hDCSrc As Long, ByVal XSrc As Long, ByVal YSrc As Long, ByVal dwRop As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Public Declare Function GetForegroundWindow Lib "user32" () As Long
Private Declare Function SelectPalette Lib "gdi32" (ByVal hdc As Long, ByVal hPalette As Long, ByVal bForceBackground As Long) As Long
Private Declare Function RealizePalette Lib "gdi32" (ByVal hdc As Long) As Long
Public Declare Function GetWindowDC Lib "user32" (ByVal hWnd As Long) As Long
Public Declare Function GetDC Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function GetWindowRect Lib "user32" (ByVal hWnd As Long, lpRect As RECT) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hWnd As Long, ByVal hdc As Long) As Long
Private Declare Function GetDesktopWindow Lib "user32" () As Long
Private Declare Function SystemParametersInfo Lib "user32" Alias "SystemParametersInfoA" (ByVal uAction As Long, ByVal uParam As Long, ByVal lpvParam As Boolean, ByVal fuWinIni As Long) As Long

Public Function CreateBitmapPicture(ByVal hBmp As Long, ByVal hPal As Long) As Picture
       Dim r As Long

Dim Pic As PicBmp
'     ' IPicture requires a reference to "Standard OLE Types"
Dim IPic As IPicture
Dim IID_IDispatch As GUID
'     ' Fill in with IDispatch Interface ID
With IID_IDispatch
.Data1 = &H20400
.Data4(0) = &HC0
.Data4(7) = &H46
End With

'     ' Fill Pic with necessary parts
With Pic
.Size = Len(Pic) ' Length of structure
.Type = vbPicTypeBitmap ' Type of Picture (bitmap)
.hBmp = hBmp ' Handle to bitmap
.hPal = hPal ' Handle to palette (may be null)
End With

'     ' Create Picture object
r = OleCreatePictureIndirect(Pic, IID_IDispatch, 1, IPic)
'     ' Return the new Picture object
Set CreateBitmapPicture = IPic
End Function
Public Function CaptureWindow(ByVal hWndSrc As Long, ByVal Client As Boolean, ByVal LeftSrc As Long, _
       ByVal TopSrc As Long, ByVal WidthSrc As Long, ByVal HeightSrc As Long) As Picture
       Dim hDCMemory As Long
       Dim hBmp As Long
       Dim hBmpPrev As Long
       Dim r As Long
       Dim hDCSrc As Long
       Dim hPal As Long
       Dim hPalPrev As Long
       Dim RasterCapsScrn As Long
       Dim HasPaletteScrn As Long
       Dim PaletteSizeScrn As Long

Dim LogPal As LOGPALETTE
' Depending on the value of Client get the proper device con
'     text

If Client Then
       hDCSrc = GetDC(hWndSrc) ' Get device context for client area
Else
       hDCSrc = GetWindowDC(hWndSrc) ' Get device context for entire window
End If

'     ' Create a memory device context for the copy process
hDCMemory = CreateCompatibleDC(hDCSrc)
'     ' Create a bitmap and place it in the memory DC
hBmp = CreateCompatibleBitmap(hDCSrc, WidthSrc, HeightSrc)
hBmpPrev = SelectObject(hDCMemory, hBmp)
'     ' Get screen properties
RasterCapsScrn = GetDeviceCaps(hDCSrc, RASTERCAPS) ' Raster capabilities
HasPaletteScrn = RasterCapsScrn And RC_PALETTE ' Palette support
PaletteSizeScrn = GetDeviceCaps(hDCSrc, SIZEPALETTE) ' Size of palette
'     ' If the screen has a palette make a copy and realize it

If HasPaletteScrn And (PaletteSizeScrn = 256) Then
       '     ' Create a copy of the system palette
       LogPal.palVersion = &H300
       LogPal.palNumEntries = 256
       r = GetSystemPaletteEntries(hDCSrc, 0, 256, LogPal.palPalEntry(0))
       hPal = CreatePalette(LogPal)
       '     ' Select the new palette into the memory DC and realize it
       hPalPrev = SelectPalette(hDCMemory, hPal, 0)
       r = RealizePalette(hDCMemory)
End If

'     ' Copy the on-screen image in   to the memory DC
r = BitBlt(hDCMemory, 0, 0, WidthSrc, HeightSrc, hDCSrc, _
LeftSrc, TopSrc, vbSrcCopy)
'     ' Remove the new copy of the the on-screen image
hBmp = SelectObject(hDCMemory, hBmpPrev)
' If the screen has a palette get back the palette that was
'     selected
'     ' in previously

If HasPaletteScrn And (PaletteSizeScrn = 256) Then
       hPal = SelectPalette(hDCMemory, hPalPrev, 0)
End If

'     ' Release the device context resources back to the system
r = DeleteDC(hDCMemory)
r = ReleaseDC(hWndSrc, hDCSrc)
' Call CreateBitmapPicture to create a picture object from t
'     he bitmap
' and palette handles. Then return the resulting picture obj
'     ect.
Set CaptureWindow = CreateBitmapPicture(hBmp, hPal)

End Function

