Unit Teletext;

{$D-,L-,R-,N-,E-,I+,V-,B-,S-,G+}
{ Genderte und erweiterte UNIT aus der c't 11/91
  Gerald Sinzig
  Ostring 30
  D-50259 Pulheim
  Tel.:02238-56621
  Auch ber FIDO-Netz erreichbar
  (SLURP 2:2450/850, 2:2450/851)

  Ich bitte jeden, der dieses Programm nutzt, mir entdeckte Fehler
  mitzuteilen.
  Auch Anfragen und Tips fr Erweiterungen sind erwnscht !!!!!!
  Wegen aktuellen Versionen bitte anrufen.

  Die Grundlagen fr Videotext und VGA-Zeichenstze habe ich aus der c't.
  Auch bentigte Zusatzprogramme sind mit anbei.
  Dieses Programmpaket darf nur vollstndig weitergegeben werden !
  ------------------------------------------------------------
  nderungen des Programms sind erlaubt, Verbesserungen sollten auch
  mir mitgeteilt werden. Bei der Weitergabe darf der Name des Programmierers,
  der die nderungen durchgefhrt hat eingefgt werden, jedoch drfen
  Herkunft und Grundlagenquellen, sowie der Hinweis auf die Programmiersprache
  nicht gelscht werden.
}

Interface

Uses  Crt,  Dos, hex, Printer, vgaprog, stasten;

Type
  PageTyp      = string[3];
  UPageTyp     = string[4];
  T_Sendername = String[6];
  T_status     = (teleok,telenopage,telenoanswer,teletimeout,telebreak,telewait);

Var
  mainstatus       : T_status;      { Funktionsstatus }
  Statuswin        : word;
  checkoutwin      : word;
  MainUPs          : word;    { anzuzeigende Seiten bei getpage }
  ShowPage         : Pagetyp;
  ShowUP           : word;
  AktuellerSender  : T_Sendername;
  Hauptmenueda     : boolean;
  NoSetupDatei     : Boolean;
  NoWait           : Boolean;       {Warte nicht auf Seitenankunft}
{###################################################################}
function  i2cstat(var stat:byte):boolean;
function  writeregister (registernr:byte) : BOOLEAN;
function  inittele (First:boolean) : BOOLEAN;
Procedure initVTScreen (Mode:Integer);
procedure freetele;
procedure readCCTpage(speicher:byte);
procedure getpage (SuchSeite:pagetyp; VAR UPs : Word);
procedure asciipage(UPNr,UPNeu:word);
procedure writepage (UPNr:word);
Function  Statustext (stat:t_status):String;
procedure printtele(von,bis:word);
Procedure SpeichereSeite (VAR Dateiname:String;Seite:Pagetyp;UPs:Word);
procedure fill(speicher:byte;page:pagetyp;upage:upagetyp);
procedure teletime (VAR Timestr : string);
procedure showVTStand(x,Y:word);
procedure writeto(speicher, row, col : byte; Teltext:string);
function  arrived(speicher:byte):boolean;
function  update(speicher:byte):boolean;
Procedure Meldung (x,y,MeldeNr : Word);
Procedure Fehler  (x,y,FehlerNr : Word);
procedure changehidden;
procedure Register (X, Y : word);
procedure clearseite (page : PageTyp);
procedure cleardisk (Sender:String);
Function  PageUPs (Page : PageTyp) : Word;
Procedure GetWinPageNr  (x,y:Word;VAR Seitenstr:pagetyp;VAR RC:T_Staste);
Procedure GetADIPmenue (x,y,Zeilen:word;Sender:T_Sendername;VAR page:PageTyp; VAR RC:t_staste);
Procedure cctfreigabe (Nr:Byte;AuftragFreigabe:boolean);
procedure parallel;
Procedure WriteSuchseitenzeile;
procedure Seitenmenue;
procedure setup;
procedure Sonderfunktionen;
Function  setpctime : boolean;
Procedure Senderwechsel(Nachfrage : Boolean);
Procedure ClearVTWin;
Procedure ShowSeitenStatus;
{**************************************************************************}
Implementation

Uses windows, user,vttexte;

Type
  Bytearraytyp = ARRAY [0..255] OF BYTE;

Const
{---------------------------------------------------------}
      Version           = 'Version 4.1 , 18.02.95';
{---------------------------------------------------------}
      DOCARE            = 16;        { Datenbyte fr CCT-Seitenadresse verwenden }
      NOTHOLD           =  8;        { Videotextlesen nicht anhalten }
      MAXADIP           =  5;        { Maximale Anzahl der ADIP-Tabellen }
      SeitenLaenge      = 1010;
      MaxUPages         = 60;
      MaxSender         = 30;
      Firstpage         = 256;       {Hex 100}
      Lastpage          = 2303;      {Hex 8FF}
      Televerzeichnis   = '\TELE';   { Verzeichnisname der Seitenverzeichnisse }
      { CCT-Adressen }
      CCTR0 = 0;   CCTR1 = 1;  CCTR2 = 2;  CCTR3 = 3;  CCTR4 = 4;
      CCTR5 = 5;   CCTR6 = 6;  CCTR7 = 7;  CCTR8 = 8;  CCTR9 = 9;
      CCTR10=10;   CCTR11=11;
      CCTW  = $22;  {Bausteinadresse zum Schreiben}
      CCTR  = $23;  {Bausteinadresse zum Lesen}
  { bersetzungstabelle fr Hamming-Code}
  Hamming : Bytearraytyp =
   (  1,255,  1,255,255,  0,255,255,255,  2,  1,255, 10,255,255,  7,
    255,  0,255,255,  0,  0,255,  0,  6,255,255, 11,255,  0,  3,255,
    255, 12,  1,255,  4,255,255,  7,  6,255,255,  7,255,  7,  7,  7,
      6,255,255,  5,255,  0, 13,255,  6,255,  6,255,255,255,255,255,
    255,  2,255,255,  4,255,255,  9,  2,  2,255,  2,255,255,  3,255,
      8,255,255,  5,255,255,  3,255,255,255,  3,255,  3,255,  3,255,
      4,255,255,  5,  4,255,  4,255,255,  2, 15,255,  4,255,255,255,
    255,  5,  5,  5,255,255,255,255,255,255,255,  5,255, 14,  3,255,
    255, 12,  1,255, 10,255,255,  9, 10,255,255, 11, 10,255, 10,255,
      8,255,255, 11,255,  0, 13,255,255, 11, 11, 11,255,255,255,255,
     12, 12,255, 12,255,255, 13,255,255, 12, 15,255, 10,255,255,  7,
    255,255, 13,255, 13,255, 13,255,  6,255,255, 11,255, 14, 13,255,
      8,255,255,  9,255,  9,  9,  9,255,  2, 15,255,255,255,255,  9,
      8,255,  8,255,255,255,255,255,  8,255,255,255,255, 14,  3,255,
    255,255, 15,255,  4,255,255,  9, 15,255, 15,255,255, 14,255,255,
      8,255,255,  5,255, 14,255,255,255, 14,255,255, 14, 14,255, 14 );

{ Es folgen nun Tabellen zur Zeichendarstellung

}
{ Zeichen 7Bit-mit parity, bis $80 auch ohne parity}
  bit7p : Bytearraytyp =
   ($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,
    $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
    $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,
    $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F,
    $15,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,
    $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$8E,$99,$9A,$5E,$5F,
    $F8,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,
    $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$84,$94,$81,$E1,$FE,
    $00,$20,$20,$03,$20,$05,$06,$20,$20,$09,$0A,$20,$0C,$20,$20,$0F,
    $20,$11,$12,$20,$14,$20,$20,$17,$18,$20,$20,$1B,$20,$1D,$1E,$20,
    $20,$21,$22,$20,$24,$20,$20,$27,$28,$20,$20,$2B,$20,$2D,$2E,$20,
    $30,$20,$20,$33,$20,$35,$36,$20,$20,$39,$3A,$20,$3C,$20,$20,$3F,
    $20,$41,$42,$20,$44,$20,$20,$47,$48,$20,$20,$4B,$20,$4D,$4E,$20,
    $50,$20,$20,$53,$20,$55,$56,$20,$20,$59,$5A,$20,$99,$20,$20,$5F,
    $F8,$20,$20,$63,$20,$65,$66,$20,$20,$69,$6A,$20,$6C,$20,$20,$6F,
    $20,$71,$72,$20,$74,$20,$20,$77,$78,$20,$20,$84,$20,$81,$E1,$20);

{ Grafikzeichen 7Bit-mit parity, bis $80 auch ohne parity}
  bit7pG : Bytearraytyp =
   ($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,
    $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
    $20,$80,$82,$83,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8F,$90,$91,
    $92,$93,$95,$96,$97,$98,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,
    $15,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,
    $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$8E,$99,$9A,$5E,$5F,
    $A5,$A6,$A7,$A8,$A9,$AA,$AD,$AE,$AF,$B0,$B1,$B2,$E0,$E2,$E4,$E5,
    $E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F7,
    $00,$20,$20,$03,$20,$05,$06,$20,$20,$09,$0A,$20,$0C,$20,$20,$0F,
    $20,$11,$12,$20,$14,$20,$20,$17,$18,$20,$20,$1B,$20,$1D,$1E,$20,
    $20,$80,$82,$20,$85,$20,$20,$88,$89,$20,$20,$8C,$20,$8F,$90,$20,
    $92,$20,$20,$96,$20,$98,$9B,$20,$20,$9E,$9F,$20,$A1,$20,$20,$A4,
    $20,$41,$42,$20,$44,$20,$20,$47,$48,$20,$20,$4B,$20,$4D,$4E,$20,
    $50,$20,$20,$53,$20,$55,$56,$20,$20,$59,$5A,$20,$99,$20,$20,$5F,
    $A5,$20,$20,$A8,$20,$AA,$AD,$20,$20,$B0,$B1,$20,$E0,$20,$20,$E5,
    $20,$E8,$E9,$20,$EB,$20,$20,$EE,$EF,$20,$20,$F2,$20,$F4,$F5,$20);

{ Grafikzeichen 7Bit-mit parity, bis $80 auch ohne parity ohne Blockgrafik}
bit7pGA : Bytearraytyp =
   ($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,
    $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,
    $15,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,
    $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$8E,$99,$9A,$5E,$5F,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,
    $00,$20,$20,$03,$20,$05,$06,$20,$20,$09,$0A,$20,$0C,$20,$20,$0F,
    $20,$11,$12,$20,$14,$20,$20,$17,$18,$20,$20,$1B,$20,$1D,$1E,$20,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,
    $20,$41,$42,$20,$44,$20,$20,$47,$48,$20,$20,$4B,$20,$4D,$4E,$20,
    $50,$20,$20,$53,$20,$55,$56,$20,$20,$59,$5A,$20,$99,$20,$20,$5F,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,
    $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20);
Type
    { Checktable fuer eingelesene Teletextseiten }
    checkpagetyp = array[1..MaxUpages] of boolean;
    { Zwischenspeicher fr Daten ber I2C-Bus }
    i2cdatentyp=array[1..960] of byte;
    Auftragtyp = RECORD
                   Seite           : Pagetyp;
                   Gesamtanzahl    : word;
                   lastnummer      : word;
                   PageOK          : checkpagetyp;
                   frei            : Boolean;
                   freigabe        : Boolean;
                   Zeit            : LongInt;
                   OutTime         : LongInt;
                 END;
    t_cctTabeintrag   = RECORD
                         soll,ist : BOOLEAN;
                       END;
    t_cctTab     = ARRAY [FirstPage..LastPage] OF t_cctTabeintrag;


    T_eineseite = array[0..Seitenlaenge-1] of byte; {40*25+10 Status}
    T_seitework  = array[0..3] of T_eineseite;

    T_Auswahltab = ARRAY [FirstPage..LastPage] OF BOOLEAN;

    ADIPEintrag = RECORD CASE INTEGER OF
                  1:
                   (Seite  : PageTyp;
                    Space1 : CHAR;
                    Titel  : ARRAY[1..12]OF CHAR;
                    Space2 : Char;
                    Hilfe  : char);
                  2:
                   (Space  : char;
                    Stri   : ARRAY[1..18] OF char);
                  END;
    T_ADIPTab   = ARRAY [1..44*MAXADIP] OF ADIPEintrag;

    t_lpt = Array[1..3] OF Word;

Const
    lpt : t_lpt =($378,$278,$3B0);

var
  ctDekoder, ELVDekoder      : Boolean;
  LPTDekoder, PortDekoder    : Boolean;
  I2CBasis                   : Word;
  SDAADDR, SCLADDR, SDAINADDR    : Word;
  SDAMASKE, SCLMASKE, SDAINMASKE : Byte;
  SDAINV, SCLINV, SDAININV       : Byte;
  SDAPort, SCLPort, I2CPort      : Byte;
  portc                      : Byte;
  ADIPTab                    : T_ADIPTab;
  AnzSubpage                 : Word;    { Anzahl der max Unterseiten (ist)}
  AnzSubpagesoll             : Word;    { Gewuenschte anzahl der Unterseiten}
  TeleDir                    : STRING;
  Seiteptrwork               : ^t_seitework;
  seiteptr                   : Array [0..3] OF Pointer;
  seiteptrakt                : Pointer;
  Seiteptrvergl              : Pointer;
  i2cd                       : i2cdatentyp;
  Verzoegerung               : Word;
  Oldtime                    : string;
  Reg                        : ARRAY [0..12] OF BYTE;
  hidden                     : BOOLEAN;
  status                     : ARRAY [ 0..7] OF T_status;  { Funktionsstatus }
  MainPage                   : PageTyp; { Suchseite vom Hauptprogramm }
  Maincct                    : byte;    { der Suchseite zugeordneter cct }
  Auftrag                    : ARRAY [0..3] OF Auftragtyp;
  Lesestand                  : ARRAY [0..3] OF Word;
  Durchlauf                  : ARRAY [1..2] OF Integer;
  Speicherstand              : WORD;

  Waitstatuswin              : BOOLEAN;
  Writelater                 : Boolean;
  Laterpage                  : PageTyp;
  LaterUpage                 : word;

  vtwin                      : word;
{ Setup-Variablen   }
  TOPTextcct                 : Word;
  timeout, TimeoutTOP,
  TimeoutUPs, Abstand        : word;
  TOPTime                    : Longint; {Zeitintervall TOP-Text-Seiten einlesen}
  Watchdog                   : Longint; {Toptext-Zeitaktualisierungsberwachung}
  parity                     : boolean;
  cct0freigabe               : boolean;
  ADIPSortieren              : boolean;
  Videotextzeichen           : boolean;
  VideotextFarben            : Boolean;
  Zeichen8x16                : Boolean;
  TOPTimeStart               : LongInt; {Zeitueberwachung TOPTEXTSeite holen}
  TOPSeite, MULTISeite       : PageTyp;
  ADIPSeite                  : ARRAY [1..MAXADIP] OF PageTyp;
  TOPPage                    : ARRAY [Firstpage..Lastpage+80] OF BYTE;
  MULTIPage                  : ARRAY [Firstpage..Lastpage] OF BYTE;
  ccttab                     : ARRAY [1..2] OF t_ccttab;
  auswahltab, oktab          : T_Auswahltab;
  Gettoptext                 : boolean;
  SenderMitTOPText, ToppageDa: Boolean;
  Videosignal, Textsignal    : char;

  Mainpagetab                : ARRAY [0..255] of PageTyp;{Eintrag 0 ungenutzt}
  Mainpagestand              : Word;
  Seitenkontrolle            : Boolean;
  Senderkontrolle            : Boolean;
  Senderarray                : ARRAY [1..Maxsender] OF T_Sendername;
  Weitersuche                : ARRAY [1..Maxsender] OF Boolean;
  Auswahlsuche               : Array [1..Maxsender] OF boolean;
  Hexseiten                  : ARRAY [1..Maxsender] OF boolean;
  ScanSenderTopText          : Array [1..Maxsender] OF boolean;
  ScandauerTopText           : Array [1..Maxsender] OF Word;

  Oldsendername              : T_Sendername;
  Aktweitersuche             : boolean;
  AktAuswahlsuche            : Boolean;
  AktHexseiten               : Boolean;
  Aktscantoptext             : Boolean;
  AktScanDauerTopText        : Word;
  gescannt                   : BOOLEAN;
  Senderlaenge               : word;
  SenderStart                : word;
  Senderwechselnachfrage     : Boolean;
  Senderaenderung            : word;
  Scantoptextnachfrage       : Boolean;
  SenderOutTime              : word;
  WinTimeOut                 : word;
  WinTimeOutaktiv            : Boolean;
  WinInfo                    : Word;

{ TOP-Page-Zuordnung :
  0 = Seite nicht im Zyclus
  1 = Untertitel mit Text
  2 = Programmvorschaublock mit Text
  3 = Programmvorschaublock mit Text, Mehrfachseite
  4 = Blockseite mit Text
  5 = Blockseite mit Text, Mehrfachseite
  6 = Gruppenseite mit Text
  7 = Gruppenseite mit Text, Mehrfachseite
  8 = Normalseite
  9 = Normalseite mit Text
  A = Nornale Mehrfachseite
  B = Normale Mehrfachseite mit Text
  C-F = frei

In der MultiPAGE steht die Anzahl der Unterseiten, wobei Werte ab
$A mehr als 9 Seiten bedeutet.
}

{**************************************************************************}
{------------------------- Ebene 1  I2C-Bus Routinen ----------------------}
{**************************************************************************}
{$I Telei2c.inc}

{**************************************************************************}
{------------------------- Ebene 2  CCT-Routinen --------------------------}
{**************************************************************************}
{$I Telecct.inc}

{***************************************************************************}
Procedure ClearVTWin;
BEGIN
  ResetWindow (VTWin);
END;

{***************************************************************************}
Procedure Meldung (x,y,MeldeNr : Word);
BEGIN
  Windowmeldung (x, y, white,blue,links,blockred,
                     Meldetext[0],MeldeText[MeldeNr]);
END;

{***************************************************************************}
Procedure Fehler (x,y,FehlerNr : Word);
BEGIN
  Windowmeldung (x, y, white,blue,links,blockred,
                     Fehlertext[0],Fehlertext[FehlerNr]);
END;

{***************************************************************************}
function  longtime : longint;
{ Ausgabe des aktuellen Sekundenstand }
Assembler;
asm
  cli
  push ds
  mov ax, $40
  mov ds, ax
  mov ax, [$6C]
  mov cx, [$6E]
  mov bx, 3601
  mul bx
  push dx
  mov ax, cx
  mul bx
  pop bx
  add ax, bx
  adc dx, 0
  sti
  pop ds
end;

{***************************************************************************}
procedure teletime (VAR Timestr : string);
{Holt die aktuelle Zeit aus CCT-Speicher}
{
var
  Timestr : String;
  x : integer;
begin
  Timestr[0] := CHR(8);
  I2Cd[1] := CCTR8;
  I2Cd[2] := REG[4]; {Speichernummer}
{  I2Cd[3] := $00; {Beginne bei Zeile 0}
{  I2Cd[4] := $32; {Beginne bei Spalte 32}
{  if (sendI2C (CCTW,4,i2cd)) then
    if receiveI2C (CCTR,8,ADDR(Timestr[1]))) then
      for x := 1 TO 8 DO BEGIN
        Timestr[x] := Timestr[x] AND chr($7F);
        IF NOT ((timestr[x] in ['0'..'9']) OR (x IN [3,6]) THEN begin
          Timestr := '';
          x := 8
        end;
      end;
  Teletime := Timestr;
end;}
assembler;
asm
  push es
  lea di, i2cd
  mov byte [di], cctr8
  inc di
  lea si, reg
  add si, 4
  mov bl, [si]
  mov [di], bl
  inc di
  mov byte [di], 0  { Zeile 0 }
  inc di
  mov byte [di], 32 {Spalte 32}
  push cctw
  push 4            { 4 Daten }
  lea di, i2cd
  push ds
  push di
  call sendi2c
  les di, Timestr
  mov bl, 8         { Lnge }
  mov es:[di], bl
  push di
  inc di
  or al, al
  je @@5
    push cctr
    push 8
    push es
    push di
    call receivei2c
    or al, al
    je @@5
    pop di
    push di
    inc di
    mov cx, 8
@@1:
    mov al, es:[di]
    and al, $7F      { Parity-Bit ausblenden }
    cmp cx, 3
    je @@2
    cmp cx, 6
    jne @@3
@@2:
    mov al, ':'
    jmp @@4
@@3:
    cmp al, '0'      { pruefe Zeichen auf 0 .. 9 }
    jc @@5
    cmp al, ':'
    jnc @@5
@@4:
    mov es:[di], al
    inc di
    loop @@1
    pop di
    jmp @@6
@@5:
  pop di             { Bei Fehler Leerstring Ausgeben }
  mov es: byte [di], 0
@@6:
  pop es
end;

{***************************************************************************}
Procedure ClearAuftrag(Nr:BYTE);
VAR j : Byte;
{ Die Seitenbezeichnung darf nicht gelscht werden ! Sonst ist eine
  Doppelbelegung mglich }
BEGIN
  WITH Auftrag[Nr] DO BEGIN
    GesamtAnzahl   := ANZSUBPAGE;
    lastnummer     := 0;
    For j := 1 TO Maxupages DO
      PageOK[j]    := false;
    frei           := True;
    Zeit           := 0;
  END;
END;

{***************************************************************************}
Procedure AuftragAbbrechen(Nr:BYTE);
VAR
  SeitenNr : Word;
BEGIN
  With Auftrag[Nr] DO BEGIN
    SeitenNr := HexDec (Seite);
    IF Freigabe AND (SeitenNr >= Firstpage) AND (SeitenNr <= Lastpage) THEN
      IF ccttab[1,SeitenNr].soll THEN
        ccttab[1,SeitenNr].ist := false
      else
        if ccttab[2,SeitenNr].soll THEN
          ccttab[2,SeitenNr].ist := false;
  END;
  clearAuftrag(Nr);
END;

{***************************************************************************}
Procedure InitAktVariables;
BEGIN
  Aktweitersuche      := True;
  AktAuswahlsuche     := false;
  AktHexseiten        := false;
  Aktscantoptext      := false;
  AktScanDauerTopText := 40;
  gescannt        := False;
END;

{***************************************************************************}
Procedure InitAuftrag (Freigabe: boolean);
Var i : Byte;
BEGIN
  For i := 0 To 3 DO BEGIN
    Clearauftrag (i);
    Auftrag[i].Seite := '';
    If NOT Freigabe THEN Auftrag[i].freigabe := False;
    Lesestand [I] := Abstand - Abstand DIV (I+1) ;
  END;
  Speicherstand := 0;
  Maincct       := 255;
  MainPage      := '';
  Durchlauf [1] := 0;
  Durchlauf [2] := 0;
END;

{***************************************************************************}
procedure clearoktab;
assembler;
asm
  push es
  cld
  lea di, oktab
  push ds
  pop es
  mov cx, 1024
  mov ax, $0
  rep stosw
  pop es
end;

{***************************************************************************}
procedure resetauswahltab (VAR Tabelle:T_Auswahltab;besetzen:boolean);
assembler;
asm
  push es
  cld
  les di, tabelle
  mov cx, 1024
  mov al, besetzen
  mov ah, al
  rep stosw
  pop es
end;

{***************************************************************************}
Procedure setauswahltab(VAR Sender:T_Sendername;Auswahlsuche:boolean;VAR da: Boolean;
                        VAR Tabelle:T_Auswahltab);
VAR
  Datei : TEXT;
  i, j  : WORD;
  SHelp : String;
  OldUpdatesperre : Boolean;
BEGIN
  resetauswahltab (Tabelle,false);
  OldUpdatesperre := UpdateSperre;
  Updatesperre := (Videomode = CO40) OR Updatesperre;
  Da := false;
  IF Auswahlsuche THEN BEGIN
    if Sender > '000'THEN BEGIN
      shelp := Sender+'.stb';
      assign (Datei, shelp);
{$I-}
      RESET (datei);
{$I+}
      IF IOResult = 0 THEN BEGIN
        REPEAT
          READLN (Datei, Shelp);
          i := HexDec (SHelp);
          IF (i >= Firstpage) AND (i < Lastpage)  THEN
            Tabelle [i] := true
          else
            i := 0;
        UNTIL (i = 0);
        close (Datei);
        Da := True;
      end
      else begin
        Meldung (46,12,StrKeineAuswahltabelleGefunden);
        resetauswahltab (Tabelle,true);
      end;
    end
    else begin { Senderkennung ungltig }
      resetauswahltab(Tabelle,true);
      Melde (52,4,i, Menuetext[StrSender],Sender);
      Meldung (46,12,StrSenderNichtErkannt);
      CloseWindow (i);
    end;
  end
  else
    resetauswahltab (Tabelle,true);
  Updatesperre := OldUpdatesperre;
end;

{***************************************************************************}
procedure initccttab;
{Sucharray setzen}
VAR i : WORD;
BEGIN
  For i := FirstPage TO LastPage DO BEGIN
    ccttab[1,i].soll := (Toppage[i] IN [1,2,4,6,8,9]);
    ccttab[2,i].soll := (Toppage[i] IN [3,5,7,$A,$B,255]);
  END;
end;

{***************************************************************************}
procedure clearccttab (Nr:word);
{VAR i : WORD;
BEGIN
  For i := Firstpage TO Lastpage DO BEGIN
    ccttab[Nr,i].ist := false;
  END
END;}
assembler;
asm
  push es
  mov ax, nr
  dec ax
  je @@1
  mov ax, Lastpage
  sub ax, Firstpage
  shl ax, 1
@@1:
  mov cx, Lastpage
  sub cx, Firstpage
  lea di, ccttab
  add di, ax
  mov si, di
  push ds
  pop es
  mov bx, $00FF
@@2:
  lodsw
  and ax, bx
  stosw
  loop @@2
  pop es
end;

{***************************************************************************}
procedure initTOPText;
VAR i,j : WORD;
BEGIN
{  For i := Firstpage TO Lastpage DO BEGIN
    TOPPAGE[i]   := 255;
    MULTIPage[i] := 255;
  END;}
ASM
    Push es
    push ds
    pop es
    lea di, Multipage
    mov cx, Lastpage-Firstpage + 1 / 2
    mov ax, $ffff
    rep stosw
    lea di, Toppage
    mov cx, Lastpage - Firstpage + 1 / 2
    mov ax, $ffff
    rep stosw
{ Wird zur Zeit immer ohne Hexseiten gesetzt, Da die Hexseiten nicht in der
  TOPTEXT-Information des Senders ist.
  Um Hexseiten zu setzen, mu die Routine SCAN eingesetzt werden oder die
  Hexseiten mssen per Hand-Suche eingesetzt werden !!!!!}
{    mov al, Hexpages
    or al, al
    jne @@3
}
    lea di, Toppage
    mov ax, 0    { ohne Hex-Seiten}
    mov bl, 8    { pages $1xx .. $8xx}
@@1:
    mov bh, 10
@@2:
    add di, 10   { 2*10 Bytes $x10 .. $x90}
    mov cx, 3    { 6 Bytes  $xxA .. $xxF }
    rep stosw
    dec bh
    jne @@2
    mov cx, 48  { $xA0..$XFF}
    rep stosw
    dec bl
    jne @@1
@@3:
    pop es
  end;
  FOR i := Lastpage +1 TO Lastpage + 80  DO
    TOPPage[i] := 255;
  FillChar (ADIPTab,SizeOf (ADIPTab),' ');
  For i := 1 TO 44*MaxADIP DO
    ADIPTAb[i].Seite[0]:= CHR(3);
  TOPSeite := '1F0';
  MULTISeite := '   ';
  For I := 1 TO MAXADIP DO
    ADIPSeite[I] := '   ';
  setauswahltab(AktuellerSender,AktAuswahlsuche,Toppageda,Auswahltab);
  ToppageDa := False;
  GetTopText := True;
  SenderMitToptext := True;
  AktHexSeiten := False;
  initcctTab;
  clearcctTab(1);
  clearccttab(2);
  clearoktab;
END;

{***************************************************************************}
procedure GetpageMem;
Const Rest = 20*1024;{Restspeicher fr Mens in Byte}
Var i : Byte;
    Memory : LongInt;
begin
  Anzsubpage := AnzsubpageSoll;
  Memory := MemAvail;
  {Teste ob Speicher fr min. 2 Unterseiten vorhanden}
  IF Memory < Rest + 2 * LongInt (6*1024) THEN BEGIN
    Fehler (42,12,StrZuwenigSpeicher);
    Halt(1);
  END;
  IF Memory - rest - Anzsubpage * Longint(6*1024) < 0 THEN
    Anzsubpage := (Memory - Rest) DIV (6*1024);
  { Seitenspeicher, den cct-Speichern zugeordnet }
  For i := 0 TO 3 DO BEGIN
    Getmem (seiteptr[i],Seitenlaenge*ANZSUBPAGE);
    fillchar(seiteptr[i]^,Seitenlaenge*Anzsubpage,chr(0));
  end;
  Getmem (seiteptrakt, Seitenlaenge*ANZSUBPAGE);
  fillchar(seiteptrakt^,Seitenlaenge*Anzsubpage,chr(0));
  Getmem (Seiteptrvergl, Seitenlaenge*ANZSUBPAGE);
  fillchar(Seiteptrvergl^,Seitenlaenge*Anzsubpage,chr(0));
end;

{***************************************************************************}
Function inittele (First:boolean) : BOOLEAN;
var x    :word;
    stat : Byte;
    init : boolean;
Begin
  SDAPort:=0; SCLPort:=0; I2CPort:=0;
  for x := 0 to 3 do
    cctfreigabe (x,false);
  initAuftrag (false);
  initTOPTEXT;
  ToptimeStart  := 0;
  Gettoptext := true;
  Init := True;
  I2CAdress;
  If ctDekoder THEN   {c't-Karte}
    { Achtung Adresse 200H funktioniert nicht auf allen Rechnern !!!! }
  ELSE IF LPTDekoder THEN BEGIN
    stat := 0;
    For x := 1 TO 3 DO BEGIN
      I2CBasis := lpt[x];
      stopi2c;
      IF I2CStat(stat) AND (stat IN [1..254]) THEN x := 3;
    end;
    If stat IN [0,255] THEN init := false;
  END
  ELSE IF ELVDekoder THEN BEGIN    {ELV-Decoder}
    Portc := $0F;
  END
  ELSE IF PortDekoder THEN;
  { CCT aktivieren und Register 11 setzen}
  stopi2c;
  Reg[CCTR0] := 0;
  IF NOT (writeRegister (CCTR0)) THEN init := False;
  { Baustein aktiv setzen}
  IF parity THEN REG[CCTR1] := $4
            ELSE Reg[CCTR1] := $44;
  IF NOT (writeRegister (CCTR1)) THEN BEGIN
    init       := False;
    Reg[CCTR1] := 4;
  end;
  { TV-Bild und VT-Bild ein}
  Reg[CCTR4] := 0; {Zeige auf dem TV CCT-Seite 0 }
  IF NOT (writeRegister (CCTR4)) THEN  init := False;
  Reg[CCTR5] := $A;
  IF NOT (writeRegister (CCTR5)) THEN begin
    init := False;
    reg[cctr5] := 0;
  end;
  Reg[CCTR6] := $A;
  IF NOT (writeRegister (CCTR6)) THEN begin
    init := False;
    reg[cctr6] := 0;
  end;
  Reg[CCTR7] := 0;
  Hidden := TRUE; {Verdeckte Ausgabe}
  IF NOT (writeRegister (CCTR7)) THEN init := False;
  clearall;
  Auftrag[0].freigabe := init and cct0freigabe;
  for x := 1 to 3 do
    Auftrag[x].freigabe := init;
  inittele := init;
  IF first then BEGIN
    NEW (Seiteptrwork);
    getPageMEM;
  end;
End;{ inittele }

{***************************************************************************}
procedure freetele;
Var i: byte;
Begin
  closeallwindows;
  clearallmenues;
  dispose (Seiteptrwork);
  for i := 0 TO 3 DO
    FREEMEM (seiteptr[i],Anzsubpage*Seitenlaenge);
  FREEMEM (seiteptrakt,Anzsubpage*Seitenlaenge);
  FREEMEM (Seiteptrvergl,Anzsubpage*Seitenlaenge);
end;

{***************************************************************************}
{**************      Alles zur Speicherung auf Disk      *******************}
{***************************************************************************}
{$I Teledisk.inc}

{***************************************************************************}
function readpageNr : Pagetyp;
{ extrahiert Pagenummer aus eingelesener Teletextseite
  Die eingelesene Seite mu sich in seiteptrwork^[0] befinden }
VAR PageNr : PageTyp;
Begin
  PageNr :=   HexASCII(seiteptrwork^[0,1008])
            + HexASCII(seiteptrwork^[0,1001])
            + HexASCII(Seiteptrwork^[0,1000]);
  IF PageNr[1] = '0' THEN PageNr[1] := '8';
  ReadpageNr := PageNr;
End;{readpageNr}

{***************************************************************************}
function ReadUpageNr : word;
{ extrahiert Unter-Pagenummer aus eingelesener Teletextseite
  Die eingelesene Seite mu sich in seiteptrwork^[0] befinden
  Wenn die Nummer grer als die maximal zu speichernde Unterseiten ist,
  wird die maximale Unterseite eingetragen. }
{Var nummer : Word;
Begin
  nummer:=  (seiteptrwork^[0,1005] and 3) * 1000
          + (seiteptrwork^[0,1004] and 15)* 100
          + (seiteptrwork^[0,1003] and 7) * 10
          + (seiteptrwork^[0,1002] and 15);
  IF nummer > ANZSUBPAGE THEN nummer := ANZSUBPAGE;
  readUpageNr := nummer;
End;{readUPageNr}

ASSEMBLER;
ASM
  push es
  les di, seiteptrwork
  add di, 1002
  xor cx, cx
  mov cl, es:[di]
  and cl, $F
  inc di
  xor bx, bx
  mov bl, es:[di]
  and bl, $7
  mov ax, 10
  mul bx
  add cx, ax
  inc di
  mov bl, es:[di]
  and bl, $F
  mov ax, 100
  mul bx
  add cx, ax
  inc di
  mov bl, es:[di]
  and bl, $3
  mov ax, 1000
  mul bx
  add ax, cx
  pop es
  cmp ax, ANZSUBPAGE
  jc @@1
  mov ax, ANZSUBPAGE
@@1:
end;

{***************************************************************************}
{***************************************************************************}
{***************************************************************************}
procedure Senderwechsel(nachfrage:boolean);
Var i : word;
BEGIN
  If Nachfrage THEN
    IF bestaetigen (48,10,white, red, black,lightgray,links, doppelt,
                    true,MenueText[StrAlteSeitenloeschen]) THEN Cleardisk('');
  { Alte Information lschen, TOPTEXT anfordern }
  initTOPText;
  initAuftrag(true);
  Senderkontrolle := SenderOutTime > 0;
{  fillchar(seiteptrakt^,Seitenlaenge*ANZSUBPAGE,chr(0));
  Fillchar(Seiteptrwork^,Seitenlaenge,chr(0));
  writepage(1);}
  Showpage   := '100';
{  MainPage   := '100';}
  ShowUp     := 1;
  IF Checkoutwin > 0 THEN BEGIN
    closewindow (checkoutwin);
    ShowSeitenStatus;
  END;
  IF Statuswin > 0 THEN BEGIN
    Clearwindow (statuswin);
    WriteCWin (Statuswin,2,Menuetext[StrSenderwechsel]);
  end;
  If Not UPDateSperre THEN BEGIN
    Resetwindow (VTWin);
    WriteCWin (VTWin,6,MenueText[StrSenderwechsel_]);
    WriteCWin (VTWin,14,MenueText[StrNeuerSender]+ ' : "'+AktuellerSender+'"');
  end;
end;

{***************************************************************************}
Procedure HoleSender;
VAR
  Sendertab    : TEXT;
  SHelp        : String;
  i,ok, IHelp  : word;
BEGIN
  assign (Sendertab, 'Sender.tab');
{$I-}
  RESET (Sendertab);
{$I+}
  IF IOResult <> 0 THEN BEGIN
    REWRITE (Sendertab);
    WRITELN (Sendertab,'ARD');
    WRITELN (Sendertab,'J'); { Weitersuche}
    WRITELN (Sendertab,'N'); { Auswahlsuche}
    WRITELN (Sendertab,'N'); { Hexseiten }
    WRITELN (Sendertab,'N'); { ScanSendertoptext}
    Writeln (Sendertab,'40');
    close (sendertab);
    RESET (Sendertab);
  end;
  i:= 1;
  repeat
    readln (Sendertab, Senderarray[i]);
    IF Senderarray[i] > '000'THEN BEGIN
      readln (Sendertab, SHelp);
      Weitersuche[i] := (SHelp = 'J');
      readln (Sendertab, SHelp);
      Auswahlsuche[i] := (SHelp = 'J');
      readln (Sendertab, SHelp);
      HexSeiten[i] := (SHelp = 'J');
      readln (Sendertab, SHelp);
      ScanSenderTopText[i] := (SHelp = 'J');
      readln (sendertab, Shelp);
      VAL (SHelp, IHelp, ok);
      ScandauerTopText[i] := IHelp;
    end
    ELSE BEGIN
      Weitersuche[i]       := true;
      Auswahlsuche[i]      := false;
      Hexseiten[i]         := false;
      ScanSenderToptext[i] := false;
      ScanDauerTopText[i]  := 40;
    END;
    INC (i);
  UNTIL (i>Maxsender) OR (Senderarray[i-1] = '');
  for i := i TO Maxsender DO BEGIN
    Senderarray[i]       := '';
    Weitersuche[i]       := true;
    Auswahlsuche[i]      := false;
    Hexseiten[i]         := false;
    ScanSenderToptext[i] := false;
    ScanDauerTopText[i]  := 40;
  end;
  close (Sendertab);
END;

{**************************************************************************}
{***************            Ausgabe Routinen            *******************}
{**************************************************************************}
procedure WriteSeite (UPNr : WORD);
{ Gibt eine Teletextseite (UPNr) aus dem PC-RAM am Bildschirm aus.}
{ Wenn UPNr = 0 wird workseite angezeigt, sonst seiteptrakt}
var spalte,zeile, OFFS    : Word;
    attralt               : byte;
    oldcctchr,cctc        : CHAR;
    grafikflag,                  { Grafik ein/aus }
    blinkflag,                   { Blinken ein/aus }
    holdflag              : boolean;   { Zeichenhalten ein/aus }
    SHELP                 : String[4];
{************************************************}
  procedure cctcolor;
  begin
    grafikflag   := ORD (cctc) AND $10 > 0;
    CASE ord (cctc) AND $F OF
      0 : Textattr := Textattr AND $70 OR black     OR (ord(Blinkflag)SHL 7);
      1 : Textattr := Textattr AND $70 OR red       OR (ord(Blinkflag)SHL 7);
      2 : Textattr := Textattr AND $70 OR green     OR (ord(Blinkflag)SHL 7);
      3 : Textattr := Textattr AND $70 OR brown     OR (ord(Blinkflag)SHL 7);
      4 : Textattr := Textattr AND $70 OR blue      OR (ord(Blinkflag)SHL 7);
      5 : Textattr := Textattr AND $70 OR magenta   OR (ord(Blinkflag)SHL 7);
      6 : Textattr := Textattr AND $70 OR cyan      OR (ord(Blinkflag)SHL 7);
      7 : Textattr := Textattr AND $70 OR lightgray OR (ord(Blinkflag)SHL 7);
    end;
  end;

{----------------------------   M A I N   ----------------------------------}
Begin
  gotoxy (1,1);
  attralt      := textattr;
  If UPNr = 0 THEN
    offs := 0
  ELSE
    offs := (UPNr-1) * Seitenlaenge;
  for zeile := 0 to 23 do begin
    Holdflag     := false;
    grafikflag   := false;
    blinkflag    := false;
    textattr     := white  { schwarz/weiss} ;
    for spalte := 0 to 39 do begin
      ASM
{      if grafikflag then
        cctc := chr(bit7pG[Adresse^[(Useitenr)*Seitenlaenge+zeile*40+spalte]])
      else
        cctc := chr(bit7p[Adresse^[(Useitenr)*Seitenlaenge+zeile*40+spalte]]);}
        mov ax, UPNr
        or ax, ax
        je @@1
        les di, seiteptrakt
        jmp @@2
      @@1:
        les di, seiteptrwork
      @@2:
        mov ax, zeile
        mov bx, 40
        mul bx
        add ax, spalte
        add ax, offs
        add di, ax
        xor bx, bx
        mov bl, es:[di]
        mov al, grafikflag
        or al, al
        je @@4
        mov al, Videotextzeichen
        or al,al
        je @@3
        lea di, bit7pG
        jmp @@5
@@3:
        lea di, bit7pGA
        jmp @@5
@@4:
        lea di, bit7p
@@5:
        mov al,[di+bx]
        mov cctc, al
      end;
      IF cctc >= ' ' THEN begin
        write(cctc);
        oldcctchr := cctc;
      end
      ELSE begin
        case ord(cctc) of
          0..7,
         16..23 : cctcolor;
          8:begin
              blinkflag:=true;
              textattr:=textattr or 128;
            end; { Blinken ein }
          9: begin
               blinkflag := false;
               textattr := textattr and 127;
             end;
         24: if hidden then
                Textattr := textattr AND $F0 OR (textattr shr 4) AND $F7;
         28: Textattr := textattr AND $F; {black}
         29: Textattr := Textattr or ((textattr shl 4) AND $70);
         30: Holdflag := true;
         31: Holdflag := false;
        end; {case}
        if Grafikflag and holdflag then
          Write (oldcctchr)
        else
          write (' ');
      end; {else}
    end;{ 1 Zeile }
    GotoXY(1,Zeile+2);
  end;
  textattr := white;
  ASM
    push ds
    mov ax, UPNr
    or ax, ax
    je @@1
    les di, seiteptrakt
    add di, offs;
    jmp @@2
  @@1:
    les di, seiteptrwork
  @@2:
    add di, 1005
    lea si, shelp
    push ss
    pop ds
    mov byte [si], 4
    inc si
    mov al, es:[di]
    AND al, $3
    OR al, $30
    MOV [si], al
    inc si
    dec di
    mov al, es:[di]
    AND al, $F
    OR al, $30
    cmp al, $3A
    jl @@3
    ADD al, 7
  @@3:
    MOV [si], al
    inc si
    dec di
    mov al, es:[di]
    AND al, $7
    OR al, $30
    MOV [si], al
    inc si
    dec di
    mov al, es:[di]
    AND al, $F
    OR al, $30
    cmp al, $3A
    jl @@4
    ADD al, 7
  @@4:
    MOV ss:[si], al
    pop ds
  end;
  writeline(1,25,19,white,Menuetext[StrUnterseite]+' : '+ SHELP);
  textattr   := attralt;
End;{writeSeite}

{**************************************************************************}
procedure WritePage(UPNr : WORD);
BEGIN
  Waitstatuswin := false;
  IF Updatesperre {AND (UPNr > 0)} THEN BEGIN
    Writelater := true;
    LaterPage  := Showpage;
    LaterUpage := UPNr;
  end
  else
    WriteSeite(UPNr);
end;

{***************************************************************************}
procedure writeTeletime;
VAR Newtime : string;
i : longint;

Begin
  Teletime (Newtime);
  IF Oldtime <> NewTime then
    IF Length (Newtime) = 8 THEN BEGIN
      writeline (33, 1, 8, black shl 4 OR green, Newtime);
      Oldtime := newtime;
      Watchdog := longtime;
      if Wintimeout > 0 THEN Closewindow (Wintimeout);
      exit;
    end;
    i := longtime;
  If Longtime - Watchdog > SenderOutTime THEN BEGIN
    If Senderkontrolle AND (NOT Wintimeoutaktiv) THEN BEGIN
      Wintimeoutaktiv := true;
      Melde (46,10,WinTimeout, Meldetext[0],MeldeText[StrSendereinstellungpruefen]);
      TitelWindow (WinTimeout, umitte, Meldetext[StrWeiterMitEinerTaste]);
      Sound (1000);
      delay (700);
      nosound;
      REPEAT
        TopTimeStart := Longtime; { alle berwachungszeiten zurcksetzen }
        FOR i := 0 TO 3 DO
          With Auftrag [i] DO
             Zeit := TOPTimeStart;
        parallel;
      until KeyDa OR (WinTimeout = 0);
      KillKey;
      IF Wintimeout > 0 THEN CloseWindow (Wintimeout);
      Wintimeoutaktiv := false;
      Watchdog := longtime;
    end;
  end
end;

{***************************************************************************}
procedure asciipage(UPNr,UPNeu:word);
{ Wandelt eine Teletextseite im PC-RAM so um, da keine Grafikzeichen
  mehr enthalten sind.
  Die UPNr wird aus dem aktuellen Seitenspeicher (seiteptrakt^) geholt.
  Die umgewandelte Teletextseite wird auf Seitenummer (seiteneu)
  in seiteptrwork gespeichert.}

var spalte,zeile, offs : word;
    attralt            : byte;
    grafikflag         : boolean;  { Flag ob Grafik ein/aus }
    cctc               : char;
Begin
  grafikflag:=false;
  offs := Seitenlaenge * (UPNr -1);
  for zeile:=0 to 23 do begin
    for spalte:=0 to 39 do begin
{      if grafikflag then
        cctc := chr(bit7pGA[(seiteptrakt^[offset+zeile*40+spalte]]))
      else
        cctc := chr(bit7p[seiteptrakt^[offset+zeile*40+spalte]]);
}     ASM
        les di, seiteptrakt
        mov ax, Zeile
        mov bx, 40
        mul bx
        add ax, spalte
        add ax, offs
        add di, ax
        xor bx, bx
        mov bl, es:[di]
        mov al, grafikflag
        or al, al
        je @@1
        lea si, bit7pGA
        jmp @@2
      @@1:
        lea si, bit7p
      @@2:
        add si, bx
        mov al, [si]
        mov cctc, al
      end;
      case ord (cctc) of
           0..7 : grafikflag := false;
         16..23 : grafikflag := true;
      end;
      IF cctc < ' ' THEN cctc := ' ';
      seiteptrwork^[UPneu,zeile*40+spalte] := byte(cctc);
    end;
    grafikflag:=false;
  end;
End; { asciipage }

{***************************************************************************}
Function Statustext (stat:t_status):String;
BEGIN
  Statustext := MeldeText[StrStatusstart + ORD(Stat)]
END;

{***************************************************************************}
procedure checkout(speicher,subanzahl,seitenr:word);
{ Gibt eine bersicht ber die bereits eingelesenen Subpages aus.}
var x  : word;
    st : string;
begin
  If not Hauptmenueda or Updatesperre or (videomode = co40) THEN exit;
  If Statuswin > 0 THEN Closewindow(Statuswin);
  If Checkoutwin = 0 THEN BEGIN
    openwindow (44,22-(Anzsubpage-1) div 12,37 ,(Anzsubpage-1) DIV 12 + 3,
                yellow,blue, links,doppelt,Checkoutwin);
    titelWindow (checkoutwin, omitte,Menuetext[StrGeleseneUnterseiten]);
  end;
  for x:=1 to subanzahl do begin
    str(x:2, st);
    if Auftrag[speicher].pageok[x] THEN str (x:2,st)
                                  ELSE st := '--';
    writewin (checkoutwin,((x-1) mod 12)*3+1, 1+((x-1) DIV 12),st);
  end;
  FOR x := subanzahl + 1 TO ANZSUBPAGE DO
    writewin (checkoutwin,((x-1) mod 12)*3+1, 1+((x-1) DIV 12),'  ');
  str (seitenr:2,st);
  titelwindow (checkoutwin,ulinks,MenueText[StrAktuelleUnterseite]+ ' : '+st);
end;(*checkout*)

{**************************************************************************}
{******************   Status der angezeigten Seite   **********************}
{**************************************************************************}
Procedure ShowSeitenStatus;
VAR
  st        : string;
  i         : Integer;
begin
  If not Hauptmenueda THEN exit;
  If videomode = co40 THEN BEGIN
    If NOT (Mainstatus in [teleok, telewait]) THEN BEGIN
      WriteCWin (VTWin,21, MenueText[StrSeitennummer] +' : ' + showpage);
      WriteCWin (VtWin,22,Statustext(Mainstatus));
    end;
  end
  else BEGIN
    If Checkoutwin > 0 THEN Closewindow(Checkoutwin);
    IF Statuswin = 0 THEN
      openwindow(44,20,35,5,white,cyan,links,doppelt,Statuswin)
    else
      clearwindow(Statuswin);
    titelwindow (Statuswin,omitte,MenueText[StrSeitenstatus]);
    writecwin (Statuswin,1,Statustext(Mainstatus));
    writecwin (Statuswin,2,MenueText[StrSeitennummer] +'   ' + ShowPage);
    i := Length (Menuetext[StrSeitennummer])- LENGTH(MenueText[StrUnterseiten])+2;
    str (MainUPs:i+4, st);
    writecwin (Statuswin,3,MenueText[StrUnterseiten] + st);
    IF showpage >= '100' THEN
      IF oktab[HexDec(showpage)] THEN
        TitelWindow (Statuswin, umitte,menueText[StrSeiteGeprueft])
      ELSE
        Cleartitel (Statuswin,umitte);
  end;
end;

{***************************************************************************}
procedure printtele (von, bis : word);
{ Druckt die aktuellen Unterseiten von .. bis.
  Es werden 3 Teletextseiten nebeneinander und
  3 Teletextseiten untereinander pro Druckerblatt gedruckt.
  Angepat an STAR-NL10 !!!!! }
var onside,counter   : word;
    zeile            : string;
{-----------------------------}
function Printerok : Boolean;
ASSEMBLER;
ASM
  push ds
  mov ax, $40
  mov ds, ax
  mov si, 8
  mov dx, [si]
  inc dx
  in al, dx
  and al, $E8
  cmp al, $C8
  je @@1
  xor al, al
  jmp @@2
@@1:
  inc al
@@2:
  pop ds
end;

begin
  IF (LPTDekoder AND (I2CBasis = $378)) OR
     (PortDekoder AND ((SDAADDR = $378) OR (SCLADDR = $378) OR
                       (SDAINADDR = $378))) THEN BEGIN
      WindowMeldung (46,12,white,blue,links,blockred,
                     Meldetext [StrVideotextdecoderNutztLPT1],
                     Meldetext [StrAusdruckenNichtMoeglich]);
      exit
    end;
  IF PrinterOk THEN BEGIN
    IF von < 1 THEN von := 1;
    onside := 0;
    { ANPASSUNG !!!!! }
    writeln(lst,#27,'A',#10,#27,'2');  { line spacing 10/72 inch }
    writeln(lst,#15);           { condensed on: 136 Zeichen/Zeile}
    { ANPASSUNG ENDE }
    while (von <= bis) do begin
     { nur ASCII-Zeichen knnen gedruckt werden }
      asciipage(von  , 1);
      asciipage(von+1, 2);
      asciipage(von+2, 3);
      for counter:=0 to 23 do begin
        move(seiteptrwork^[1,counter*40],zeile[1],40);
        zeile[0]:=chr(40);
        write(lst,zeile:40,'  ');
        if (succ(von)) > bis then
          writeln(lst,'')
        else begin
          move(seiteptrwork^[2,counter*40],zeile[1],40);
          zeile[0]:=chr(40);
          write(lst,zeile:40,'  ');
          if (von+2) > bis then
            writeln(lst,'')
          else begin
            move(seiteptrwork^[3,counter*40],zeile[1],40);
            zeile[0]:=chr(40);
            writeln(lst,zeile:40);
          end;
        end;
      end;
      writeln(lst,'');
      inc (von, 3);
      inc (onside,3);
      { neues Blatt }
      if onside = 9 then begin
        write(lst,#12);   { TOF: neue Seite anfahren }
        onside:=0;
      end;
    end;
    { ANPASSUNG !!!!!, diese 2 Zeilen knnen auch entfallen }
    writeln(lst,#18);              { condensed off: 80 Zeichen/Zeile }
    writeln(lst,#27,'A',#12,#27,'2'); { line spacing 12/72 ", normal }
   { ANPASSUNG ENDE }
  end
  else
    Fehler (46,12,StrDruckerNichtBereit);
end; (* printtele *)

{***************************************************************************}
procedure savetele(dateiname:STRING; seite : PageTyp; UPs : WORD);
{ Speichert die aktuelle Teletextseiten ab }
var akt        :word;
    counter,i  :byte;
    zeile      :string;
    datei      :text;
begin
  Assign (datei, Dateiname);
{$I-}
  append (datei);
  IF IOResult IN [2,3] THEN ReWrite (datei);
{$I+}
  for akt := 1 to UPs do begin
   { nur ASCII-Zeichen an Datei ausgeben }
    asciipage(akt,1);
    for counter := 0 to 23 do begin
      move(seiteptrwork^[1,counter*40],zeile[1],40);
      i := 40;
      while (zeile[i] = ' ') AND (i > 0) do
        i := pred (i);
      zeile[0] := chr(i);
      writeln(datei,zeile);
    end;
    writeln(datei,'');
  end;
  close (datei);
end; (* savetele *)

{***************************************************************************}
procedure showVTStand(x,Y:word);
Var i,
    Einzel, einzelda, Einzelok : word;
    Mehrfach, Mehrfachda, Mehrfachok : WORD;
    l : longint;
    Winout : Word;
    SHelp  : string;
BEGIN
  openwindow(x,y,36,12,white,magenta,links,doppelt, winout);
  titelwindow (Winout, omitte, Menuetext[StrSeitenEinlesestand]);
  titelwindow (Winout, umitte, MenueText[StrWeiterMitEinerTaste]);
  For i := 1 TO 8 DO
    WriteWin(Winout, 2, i, Menuetext[StrSeitenEinlesestand+i]);
  IF nowait then
    {Seiten in der Warteschlange:}
    writeWin (winout, 2, 9, Menuetext[StrSeitenEinlesestand+ 9]);
  {Maximale Unterseitenanzahl : }
  str (Anzsubpage:4,SHelp);
  writeWin (winout, 2,10, MenueText[StrSeitenEinlesestand + 10]+SHelp);
  Repeat
    Einzel     := 0;
    Mehrfach   := 0;
    EinzelDa   := 0;
    Einzelok   := 0;
    Mehrfachda := 0;
    Mehrfachok := 0;
    FOR i := Firstpage TO Lastpage DO BEGIN
      IF Auswahltab [i] THEN
        IF ccttab[1,i].soll THEN BEGIN
          INC (Einzel);
          IF ccttab[1,i].ist THEN inc (EinzelDa);
          IF oktab[i] THEN inc (Einzelok);
        end
        else IF ccttab[2,i].soll THEN BEGIN
          inc (Mehrfach);
          IF ccttab[2,i].ist  THEN inc (Mehrfachda);
          IF oktab[i] THEN inc (Mehrfachok);
        end;
    END;
    str (Einzel:3,Shelp);
    writewin (winout,31, 1, Shelp);
    str (Einzelda:3,SHelp);
    writewin (winout,31, 2, Shelp);
    IF Seitenkontrolle THEN
      str (Einzelok:3,SHelp)
    else
      SHELP := '---';
    writewin (winout,31, 3, Shelp);
    str (Durchlauf[1]:3,SHelp);
    writewin (winout,31, 4, Shelp);
    str (Mehrfach:3,SHelp);
    writewin (winout,31, 5, Shelp);
    str (Mehrfachda:3,SHelp);
    writewin (winout,31, 6, Shelp);
    IF Seitenkontrolle THEN
      str (Mehrfachok:3,SHelp)
    else
      SHELP := '---';
    writewin (winout,31, 7, SHelp);
    str (Durchlauf[2]:3,SHelp);
    writewin (winout,31, 8, Shelp);
    If nowait then begin
      str (mainpagestand:3,shelp);
      writeWin (winout, 31,9, Shelp);
    end;
    l := longtime;
    repeat
      Userprocedure
    UNTIL Keyda OR (l+2 < Longtime);
  until keyDa;
  KillKey;
  Closewindow(winout);
END;

{***************************************************************************}
Procedure SpeichereSeite (VAR Dateiname:String;Seite:Pagetyp;UPs:Word);
VAR
  Win          : Word;
  RC           : t_STaste;
  Olddateiname : String;
BEGIN
  olddateiname := dateiname;
  openwindow(47,12,32,3,white,cyan,links,doppelt,win);
  titelWindow(win,omitte,MenueText[StrDateiname]);
  if Olddateiname[1] > ' 'THEN
  titelWindow(win,umitte,OldDateiname);
  getwinCstring (win,1,28,yellow,dateiname,RC);
  IF RC = cr THEN BEGIN
    IF Dateiname[1] <= ' ' Then
      IF (olddateiname[1] > ' ') then
        Dateiname := Olddateiname;
        IF Dateiname[1] > ' ' THEN
          savetele(Dateiname,Seite,UPs)
        else
          Fehler (48, 18, StrUngueltigerDateiname);
  end;
  closewindow(win);
end;

{***************************************************************************}
Procedure Bereichbearbeiten(Sender : T_Sendername;Tabelle:T_Auswahltab);
VAR
  Win1, Win2 : Word;
  x, y       : Word;
  Speichern  : Boolean;
  Auswahl, da: Boolean;
  UMenuePos  : Word;
  URC1, URC2 : T_STaste;
  SHelp      : String;

Procedure DruckenoderSpeichern;
VAR
  Win1, Win2, Win3, Win4 : Word;
  RC                     : T_STaste;
  Dateiname, SHelp       : String;
  datei                  : text;
  Menuepos, UPs          : Word;
  von, bis, Ihelp        : Integer;
  vonHex, bisHex         : PageTyp;

BEGIN
  Dateiname := '';
  vonHex := '100';
  IF Auswahl THEN
    RC := cr
  ELSE BEGIN
    Melde (45,4,Win1, '',Menuetext[StrStartseite]);
    GetWinPageNr  (52,10, vonHex ,RC);
    CloseWindow(Win1);
    Melde (45,4,Win1,Menuetext[StrStartseite],VonHex);
  END;
  IF RC = cr THEN BEGIN
    IF Auswahl THEN
      bisHex := '899'
    Else BEGIN
      BisHex := vonHex;
      Melde (63,5,Win2, '',Menuetext[StrLetzteseite]);
      GetWinPageNr  (64,11,BisHex ,RC);
      CloseWindow(Win2);
      Melde (63,5,Win2,Menuetext[StrLetzteseite],bisHex);
    end;
    IF RC = cr THEN
      IF (bisHex >= vonHex) THEN BEGIN
        If Speichern THEN BEGIN
          openwindow(46,13,32,3,black,cyan,links,doppelt,win3);
          titelWindow(win3,omitte,MenueText[StrDateiname]);
          getwinCstring (win3,1,28,yellow,dateiname,RC);
          IF RC = cr THEN BEGIN
            IF Dateiname[1] > ' ' THEN BEGIN
              IF Length (FSearch(Dateiname,'')) > 0 THEN BEGIN
                SetMenue (Win4, 26,2,StrDateiSchonVorhandenMenue);
                OpenMenue (48,17,0,1,yellow,cyan,black,lightgray,win4,
                           links,doppelt);
                Getmenuepos (win4,[cr, esc], Menuepos,rc);
                clearmenue(win4);
                if rc = cr THEN
                  IF Menuepos = 2 THEN BEGIN
                    Assign(datei,Dateiname);
                    erase (datei);
                  end;
              end;
            end
            else BEGIN
              Fehler (45, 19, StrUngueltigerDateiname);
              RC := esc;
            END;
          END;
        END;
        if rc = cr THEN BEGIN
          openwindow(52,11,25,4,white,green,links,blockred,win4);
          TitelWindow(win4,omitte,MainText[StrBitteWarten]);
          If Speichern THEN SHelp := Menuetext[StrSpeichereSeite]
                       Else SHelp := MenueText[StrDruckeSeite];
          WriteCWin(win4,1,SHelp);
          von := HexDec(vonHex);
          bis := HexDec(BisHex);
          For IHelp := von to bis do begin
            IF Tabelle[IHelp] OR NOT Auswahl THEN BEGIN
              getdiskseite (DecHex(IHelp),Sender,Seiteptrakt,UPs);
              IF UPs > 0 THEN BEGIN
                Writecwin(win4,2,DecHex(IHelp));
                IF Speichern THEN
                  savetele(Dateiname,SHelp,UPs)
                ELSE
                  Printtele (1,UPs);
              end;
            end;
            If KeyDa THEN
              IF GetKey = CHR(27) THEN Ihelp := bis;
          end;
          closewindow(win4);
        end;
        IF speichern THEN closewindow(win3);
      end
      else
        Fehler (49, 17,StrUngueltigeEingabe);
      if not Auswahl THEN
        closewindow(win2);
    end;
    if not Auswahl THEN
      closewindow(win1);
end;

{--------------------------       M A I N       ----------------------------}
BEGIN
  x := 46; Y := 2;
  SetMenue (Win1, 20, 2, StrMenueDruckenSpeichern);
  Getmenue (x+2,y+8,0,1,white,green,lightcyan,black,win1,links,doppelt,
            [esc,cr],Umenuepos,uRC1);
  IF URC1 = cr THEN BEGIN
    Speichern := (UMenuepos = 1);
    If Speichern THEN SHElp := MenueTExt[StrSpeichern]
                 ELSE SHelp := MenueText[StrDrucken];
    initmenue(win2,26,2,omitte,umitte,SHELP,MenueText[StrAbbruchmitESC]);
    setmenuetext (win2,1,MenueText [StrBereichsmenue]);
    Setmenuetext (win2,2,menueText [StrBereichsmenue+1]);
    Getmenue (x+2,y+13,0,1,white,green,lightcyan,black,win2,links,doppelt,
              [esc,cr],Umenuepos,uRC2);
    IF URC2 = cr THEN BEGIN
      Auswahl := (UMenuepos = 1);
      SetAuswahltab(Sender, Auswahl, da,Tabelle);
      IF DA or NOT Auswahl THEN DruckenoderSpeichern;
    END;
    Clearmenue (Win2);
  END;
  ClearMenue (Win1);
END;

{***************************************************************************}
{****************       TOP - TEXT - ROUTINEN        ***********************}
{***************************************************************************}
Procedure GetADIPmenue (x,y,Zeilen:word;Sender:T_Sendername;VAR page:pagetyp; VAR RC:t_staste);
Const Zeilenlaenge = 20;
VAR i,Position     : Word;
    Anzahl         : Word;
    menue, sp      : word;
    ADIPTab        : T_ADIPTab;
    ADIPDatei      : File OF ADIPEintrag;

procedure Shellsort;
  Var Offset, VerglNr, Maxvergl,Limit : Integer;
      Tauschen : Integer;
      Help     : ADIPEintrag;
  Begin
    Maxvergl := Anzahl;
    Offset := Maxvergl DIV 2;
    WHILE Offset > 0 DO BEGIN       { Wiederhole, bis Offset null wird.}
      Limit := Maxvergl - Offset;
      REPEAT
        Tauschen := 0;              { Nimm an, da nicht getauscht wird.}
        { Vergleiche die Elemente und vertausche diejenigen, die nicht in der
          richtigen Reihenfolge liegen}
        FOR VerglNr := 1 TO Limit DO BEGIN
          IF ADIPTab[verglNr].Seite > ADIPTab[VerglNr+Offset].Seite THEN BEGIN
            Help.stri := ADIPTab[VerglNr+offset].stri;
            ADIPTab[VerglNr+Offset].Stri := ADIPTab[VerglNr].Stri;
            ADIPTab[VerglNr].Stri := Help.stri;
            Tauschen := VerglNr;
          end;
        end;
        { Sortiere im nchsten Schritt nur bis dahin, wo der letzte Tausch
          durchgefhrt wurde}
        Limit := Tauschen - Offset;
      UNTIL Tauschen = 0;
      { Kein Tausch beim letzten Offset, versuche es mit dem halbierten Offset}
      Offset := Offset DIV 2;
    END;
  END;

{ ---------------------------    M A I N    --------------------------------}
BEGIN
  ASSIGN (ADIPDatei, Teledir+Televerzeichnis + '1\'+ Sender + 'AP.vtx');
{$I-}
  RESET (ADIPDatei);
{$I+}
  IF IOResult <> 0 THEN
    Anzahl := 0
  ELSE BEGIN
    Anzahl := Filesize (ADIPDatei);
    For i := 1 TO Anzahl DO
      READ (ADIPDatei,ADIPtab[i]);
    close(ADIPDatei);
  END;
  IF Anzahl > 0 THEN BEGIN
    IF ADIPSortieren THEN Shellsort;
    initmenue(menue,Zeilenlaenge,Anzahl,omitte,umitte,MenueText[StrADIPTabelle],'');
    For i := 1 TO Anzahl DO
      WITH ADIPTab[i] DO BEGIN
        SetMenuetext(menue,i,', '+ADIPTab[i].Stri);
        IF ADIPSortieren THEN BEGIN
          IF Seite <= Page THEN sp := i;
        end
        else
          IF Seite = Page THEN sp := i;
      end;
    getmenue (x,y,Zeilen,sp,white, magenta,black,lightgray,menue,
              links, doppelt,[cr,esc], Position, RC);
    IF RC = cr THEN
      Page := ADIPTab[Position].seite;
    Clearmenue(menue);
  END
  ELSE
    Meldung (46,8,StrKeineAuswahltabelleGefunden);
end;

{***************************************************************************}
Function HamChar (Code:BYTE) : CHAR;
{BEGIN
 IF Code IN [0..$F] THEN Hamchar := HexASCII(code)
                    else Hamchar := '?';
}
ASSEMBLER;
ASM
  mov bl, Code
  xor bh, bh
  mov al, '?'
  xor ah, ah
  cmp bx, $F
  jg @@1
  push bx
  call Hexascii
@@1:
END;

{***************************************************************************}
Procedure SetTopPage;
{ Die Tabelleneintrge werden nur bei korrektem Wert berschrieben,
  somit kann nach mehrmaligem lesen mit Fehlern die Tabelle doch
  korrekt und komplett sein}
Var i, j : WORD;
    c    : CHAR;
    p    : PageTyp;
    pp   : ARRAY [0..9] OF PageTyp;
    code : ARRAY [0..9] OF CHAR;
BEGIN
  For i := 40 TO 839 DO BEGIN  { Info fngt Zeile 2 (40. Zeichen) an}
    j := seiteptrwork^[0,i];
    IF Hamming [j] < 255 THEN BEGIN
      STR (i+60:3,p);
      TOPPage[HEXDEC(P)] := Hamming[j];
    END;
  end;
  { Hole ADIP-Seitennummern }
  For j := 0 To 9 DO BEGIN
    pp[j] := '---';
    Code [j] := '0';
  END;
  For j := 0 TO 9 DO BEGIN   { Maximal 10 Seiteneintrge }
    For i := 1 TO 3 DO BEGIN
      pp[j,i] := HamChar(Hamming[Seiteptrwork^[0,839+8*j+i]]);
      IF pp[j,i] = '?' THEN BEGIN
        pp[j] := '---';
        i := 3;
      END;
    END;
    IF pp[j,1] = 'F'THEN BEGIN       {Endekennung}
      pp[j] := '---';
      j := 9;
    END
    ELSE IF pp[j,1] = 'E' THEN       {Freikennung}
      pp[j] := '---'
    ELSE
      code[j] := HamChar(Hamming[Seiteptrwork^[0,839+8+8*j]]);{je 8. Zeichen}
  END;
  i := 1;
  { Hole ADIP- und Multipage-Information }
  For j := 0 TO 9 DO BEGIN
    CASE Code[j] OF
     '1': MultiSeite := pp[j];
     '2': BEGIN
            ADIPSeite[i] := pp[j];
            INC(i);
          END;
    END;
  END;
  IF AktHexseiten THEN
  ASM
    Push es
    lea di, Toppage
    mov ax, $FFFF
    mov bl, 8    { pages $1xx .. $8xx}
@@1:
    mov bh, 10
@@2:
    add di, 10   { 2*10 Bytes $x10 .. $x90}
    mov cx, 3    { 6 Bytes  $xxA .. $xxF }
    rep stosw
    dec bh
    jne @@2
    mov cx, 48  { $xA0..$XFF}
    rep stosw
    dec bl
    jne @@1
@@3:
    pop es
  end;
  TopPageDa := True;
  initccttab;
END;

{***************************************************************************}
Procedure SetMULTIPage;
{ Die Tabelleneintrge werden nur bei korrektem Wert berschrieben,
  somit kann nach mehrmaligem lesen mit Fehlern die Tabelle doch
  korrekt und komplett sein}
Var i, j : WORD;
    c    : CHAR;
    p    : Pagetyp;
BEGIN
  For i := 100 TO 899 DO BEGIN
    j := seiteptrwork^[0,i-60];
    IF Hamming [j] < 255 THEN BEGIN
      str (i:3,p);
      MULTIPage[HexDec(p)] := Hamming[j];
    END;
  END;
END;

{***************************************************************************}
Procedure SetADIPTAB (Nr:BYTE);
Var
  ab, i, j, k : WORD;
  SNr         : Integer;
  ch          : Char;
  ADIPDatei   : File OF ADIPEintrag;

BEGIN
  ab := 44 * (Nr-1)+1;
  For i := 0 TO 43 DO BEGIN
    For j := 1 TO 3 DO BEGIN
      ch := HAMChar(HAMMING[seiteptrwork^[0,39+i*20+j]]);
      IF ch <> '?' THEN ADIPTab[i+ab].seite[j] := ch;
    END;
    ch := HAMChar(HAMMING[seiteptrwork^[0,46+i]]);
    IF ch <> '?' THEN ADIPTab[i+ab].Hilfe := ch;
    for k := 0 TO 11 DO
      ADIPTAb[i+ab].Titel[1+k] := chr(bit7p[seiteptrwork^[0,48+i*20+k]]);
  END;
  assign (ADIPDatei,TeleDir+Televerzeichnis + '1\'+ AktuellerSender + 'AP.vtx');
{$I-}
  REWRITE (ADIPDatei);
{$I+}
  IF IOResult = 3 THEN BEGIN
    mkdir (Teledir+Televerzeichnis+'1');
    REWRITE (ADIPDatei);
  end;
  For i := 1 TO 44 * MAxADIP DO WITH ADIPTab[i] DO begin
    SNr := HexDec (Seite);
    IF (SNr >= Firstpage) AND (SNr <= Lastpage) THEN
      WRITE (ADIPDatei, ADIPTab[i]);
  END;
  close(ADIPDatei);
END;

{***************************************************************************}
procedure scantoptext (Zeit:word);
{ Diese Routine ist in mehreren Varianten geprft worden.
  Zuerst alle Status-Bytes lesen, Auswerten und anschlieend als gelesen
  kennzeichnen fhrte zu einer fast unbrauchbaren TOP-TEXT-Tabelle.
  Jetzt wird zuerst nur das FOUND - Bit abgefragt, sofort wieder gesetzt
  und dann die ersten 9 STATUS-BYTES gelesen. Ist das FOUND-Bit noch
  immer gesetzt, so wurde keine neue Seite empfangen und die Auswertung
  wird durchgefhrt.
  Der Fehler liegt, sofern die Seitenzycluszeit nicht unterschritten wird,
  bei weniger als 1 %
  Diese Routine geht nur auf Zeit, da selbst wenn man genau einen
  Zyklus messen wrde, ein TIMEOUT mitbeachtet werden muesste und
  gerade beim ersten Lesen ist die Fehlerquote relativ hoch.
  mit den vorgeschlagenen 40 Sekunden liegt man ganz gut, besser sind 60
  Sekunden
  Wenn schon Toptextinformation eingelesen wurde, wird die Information
  ergnzt, ansonsten ganz neu erstellt.
}

VAR winout, lauf   : Word;
    SHelp          : String;
    Starttime      : LongInt;
    Seite          : array [0..3] OF PageTyp;
    magbyte        : byte;
begin
  IF NOT Toppageda THEN
    For lauf := firstpage to lastpage do
      Toppage[lauf] := 0;
  For lauf := 0 TO 3 do begin { da keine Paralle-Verarbeitung alle stoppen}
    Seite[Lauf] := Auftrag[Lauf].Seite;
    writeline (20+lauf*4, 25, 3, red, '---');
  end;
  fill(0,'1F*','****');
  fill(1,'***','****');
  openwindow(45,10,33,5,white,cyan,links,doppelt, winout);
  IF TopPageDa THEN
    WritecWin(winout,2,MenueText[StrScanTOPTextSeite])
  ELSE
    WritecWin(winout,2,MenueText[StrScanTOPText_neu]);
  Starttime := longtime;
  str(Zeit:3,SHelp);
  Titelwindow(winout,umitte,Menuetext[StrScanDauer]+' : '+SHelp+' sec');
  repeat
{    I2Cd[1]   := CCTR8;
    i2cd[2]   := 1;
    i2cd[3]   := 25;
    i2cd[4]   :=  0;
    IF sendi2c(CCTW, 4,I2cd) THEN BEGIN }
    ASM
      lea di, i2cd
      mov byte [di], cctr8
      inc di
      mov byte [di], 1
      inc di
      mov byte [di], 25
      inc di
      mov byte [di], 8
      push cctw
      push 4
      lea di, i2cd
      push ds
      push di
      call sendi2c
      or al, al
      je @@8
{     if receivei2c(CCTR,1,i2cd) then begin}
        push cctr
        push 1
        lea di, i2cd
        push ds
        push di
        call receivei2c
        or al, al
        je @@7
{        IF (i2cd[1] AND $10) = 0 THEN BEGIN}
          lea di, i2cd
          mov al, [di]
          and al, $10
          jne @@6
{         magbyte   := I2cd[1] or $10
          I2Cd[1]   := CCTR8;
          i2cd[2]   := 1;
          i2cd[3]   := 25;
          i2cd[4]   := 8;
          i2cd[6]   := magbyte;
          if (sendi2c(CCTW,5,i2cd)) then;}
          lea di, i2cd
          mov al, [di] { rette Hunderterstelle der Seite}
          mov byte [di], CCTR8
          inc di
          mov Byte [di], 1
          inc di
          mov byte [di], 25
          inc di
          mov byte [di], 8
          inc di
          or al, $10
          mov MagByte, al
          mov byte [di], al
          push cctw
          push 5
          lea di, i2cd
          push ds
          push di
          call sendi2c
          or al, al
          je @@8
{         i2cd[4] := 0;
          if (sendi2c(CCTW,4,i2cd)) then;}
          lea di, i2cd
          add di, 3
          mov byte [di], 0
          push cctw
          push 4
          lea di, i2cd
          push ds
          push di
          call sendi2c
          or al, al
          je @@8
{         if receivei2c(CCTR,9,i2cd) then begin}
            push cctr
            push 9
            lea di, i2cd
            push ds
            push di
            call receivei2c
            or al, al
            je @@7
{        IF i2cd[9] = magbyte THEN BEGIN}
            lea di, i2cd
            add di, 8
            mov al, [di]
            cmp al, magbyte
            jne @@6
{          IF (i2cd[1] or i2cd[2] or i2cd[3] or i2cd[4] OR i2cd[5])
              AND $10 = 0 THEN BEGIN { kein Ham-Fehler}
            lea di, i2cd
            mov al, [di]
            inc di
            or al, [di]
            inc di
            or al, [di]
            inc di
            or al, [di]
            inc di
            or al, [di]
            and al, $10
            jne @@5
{            IF NOT ((i2cd[9] = 1 ) AND (i2cd[2] = $0F)) THEN BEGIN {keine Top-Info}
              lea di, i2cd
              inc di
              mov al, [di]
              cmp al, $0f
              jne @@0
              add di, 7
              mov al, [di]
              and al, $7
              cmp al, 1
              je @@4
              @@0:
{              Seitennr := i2cd[9] * 256 + i2cd[2] *  16 +i2cd[1];}
                lea di, i2cd
                mov bl, [di]   { Seite Einer }
                xor bh, bh
                inc di
                mov al, [di]   { Seite Zehner }
                mov cl, 16
                mul cl
                add bx, ax
                mov al, magbyte { Seite Hunderter }
                and al, $07
                mov cx, 256
                mul cx
                add bx, ax
{              If Seitennr < Firstpage THEN seitennr := seitennr + Lastpage - Firstpage + 1;}
                cmp bx, Firstpage
                jge @@1
                add bx, Lastpage - Firstpage + 1
@@1:
                push bx
{              UPage :=   (I2cd[6] AND  3) * 1000
                       + I2cd[5]          *  100
                       + (I2cd[4] AND  7) *   10
                       + I2cd[3];}
                inc di
                mov bl, [di]   { Unterseite Einer }
                xor bh, bh
                inc di
                mov al, [di]   { Unterseite Zehner }
                and al, $7
                mov cl, 10
                mul cl
                add bx, ax
                inc di
                mov al, [di]   { Unterseite Hunderter }
                mov cl, 100
                mul cl
                add bx, ax
                inc di
                mov al, [di]  { Unterseite Tausender }
                and al, $3
                xor ah,ah
                mov cx, 1000
                mul cx
                add bx, ax
{              IF Upage = 0 THEN TopPage[Seitennr] := 8  { Normalseite }
{                           ELSE TOPPage[Seitennr] := $A;{ Mehrfachseite }
                lea di, Toppage
                pop dx
                sub dx, Firstpage
                add di, dx
                or bx,bx
                je @@2
                  mov byte [di], $A
                  jmp @@3
                @@2:
                  mov byte [di], $8
                @@3:
              @@4:
{            end;}
            @@5:
{        end; {arrived}
          @@6:
{      end;}
        @@7:
      @@8:
    end;
  until longtime - starttime > Zeit; { xx Sekunden einlesen}
  Closewindow(winout);
  IF AktHexseiten THEN
  ASM
    Push es
    lea di, Toppage
    mov ax, $FFFF
    mov bl, 8    { pages $1xx .. $8xx}
@@1:
    mov bh, 10
@@2:
    add di, 10   { 2*10 Bytes $x10 .. $x90}
    mov cx, 3    { 6 Bytes  $xxA .. $xxF }
    rep stosw
    dec bh
    jne @@2
    mov cx, 48  { $xA0..$XFF}
    rep stosw
    dec bl
    jne @@1
@@3:
    pop es
  end;
  TopPageDa := True;
  For lauf := 0 TO 3 DO
    If Auftrag[Lauf].Freigabe THEN BEGIN
      fill(lauf,Auftrag[Lauf].Seite,'****');
      Auftrag[Lauf].Zeit := Longtime;
      Auftrag[Lauf].LastNummer := 0;
    END;
  initcctTab;
  WriteSuchseitenzeile;
  KillKey;
end;

{***************************************************************************}
{***********************  Auftragsbearbeitung ******************************}
{***************************************************************************}
Procedure cctfreigabe (Nr:Byte;AuftragFreigabe:boolean);
BEGIN
  With Auftrag[Nr] DO BEGIN
    Auftragabbrechen(Nr);
    freigabe := Auftragfreigabe;
    frei     := true;
  end;
END;

{***************************************************************************}
Procedure SetzeAuftrag(speicher:Byte;Page:PageTyp; UPs:Byte);
VAR
  lauf : word;
BEGIN
  For lauf := 0 to 3 do                   { Doppelbelegung vermeiden}
    IF Auftrag[Lauf].seite = Page THEN BEGIN
    speicher := Lauf;
    lauf := 3
  end;
  With Auftrag[speicher] DO BEGIN
    IF frei or not freigabe THEN BEGIN
      status[speicher] := teleok;
      FILL (speicher,page,'****');
      Seite        := Page;
    { ggf UPs auf Anzsubpage setzen, somit ist die Suche nach Seiten, die
      in der TOPPage-Information nicht eingetragen sind mglich}
      if (UPs = 0) OR (UPs > AnzSubPage) Then UPs := ANZSUBPAGE;
      GesamtAnzahl := UPs;
      Zeit         := LongTime;
      Frei         := False;
      IF Seite >= '100' THEN
        IF Gesamtanzahl > 1 THEN Outtime := TimeOutUPs
                            else Outtime := Timeout
      else
        OutTime := TimeOutTOP;
    end;
    writeline (20+speicher*4, 25, 3, green, seite);
  END;
END;

{***************************************************************************}
Procedure WriteSuchseitenzeile;
{Schreibe alle in suche befindlichen Seiten in die unteren Zeile}
VAR speicher : Byte;
BEGIN
  For Speicher := 0 To 3 DO
    With Auftrag[Speicher] DO
    If freigabe THEN
      writeline (20+speicher*4, 25, 3, green, seite)
    ELSE
      writeline (20+speicher*4, 25, 3, red, '---');
END;

{***************************************************************************}
{Wird nicht auf das Eintreffen der Seite gewartet, so wird auf der
 Teletextseite die Anzahl der noch zu suchenden Seiten angezeigt}
Procedure Waitstatus;
VAR i,j   : Integer;
BEGIN
  Waitstatuswin := True;
  IF (Checkoutwin = 0) AND (Videomode <> CO40) THEN
    Showseitenstatus;
  IF not updatesperre THEN BEGIN
    ResetWindow(VTWin);
    TitelWindow(VTwin,omitte,'ͻ ͻ ͻ ͻ      ͻ');
    WriteCWIN(VTwin,1,'                             ');
    WriteCWIN(VTwin,2,'         ͼ                 ');
    WriteCWIN(VTwin,3,'                              ');
    WriteCWIN(VTwin,4,'      ͼ                   ');
    WriteCWin (VTwin,5,'Gerald Sinzig');
    WriteCwin (VTwin,6,Version);
    WriteCwin (VTwin,7,MenueText[StrProgInfo+2]+ ' c''t 11/91-10/92');
    WriteWin (VTwin,1,8,MenueText[StrNachfolgendenSeitenwirdgesucht]);
    j := integer(Mainpagestand - 14*8);
    IF j < 0 THEN j := 0;
    For i := 1 TO Mainpagestand-j Do BEGIN
      WriteWin (VTwin,pred(i)*5 MOD 40,9+pred(i)*5 div 40,Mainpagetab[i] +',');
    end;
  end;
end;

{***************************************************************************}
Procedure DelMainpage (Eintrag:PageTyp);
{Sucht nach dem Eintrag und trgt ihn ggf. aus}
VAR Lauf : Word;
BEGIN
  FOR lauf := 1 TO Mainpagestand DO
    IF Mainpagetab[lauf] = Eintrag THEN BEGIN
      FOR lauf := lauf TO Pred (Mainpagestand) DO
        mainpagetab[lauf] := mainpagetab [succ(lauf)];
      DEC (Mainpagestand)
    END;
END;

{***************************************************************************}
Procedure SetMainpagetab (Eintrag:PageTyp);
BEGIN
  DelMainpage(Eintrag);
  INC (Mainpagestand);
  MainpageTab[Mainpagestand] := Eintrag;
END;

{***************************************************************************}
Function PageUps (PAGE : Pagetyp) : Word;
ASSEMBLER;
ASM
  push es
  les di, page
  mov bl, es:[di] {3 Zeichen}
  cmp bl, 3
  jnz @@2
  inc di
  xor bx, bx
  mov bl, es:[di]  {256-er Basis}
  sub bl, $30
  cmp bl, $8
  jnc @@2
  dec bl
  mov ax, 256
  mul bx
  mov cx, ax
  inc di
  mov bl, es:[di] {16-er basis}
  sub bl, $30
  cmp bl, $A
  jc @@1
  sub bl, 7
  cmp bl, $F+1
  jnc @@4
@@1:
  mov ax, 16
  mul bx
  add cx, ax
  inc di
  mov bl, es:[di]  {einer}
  sub bl, $30
  cmp bl, $A
  jc @@2
  sub bl, 7
  cmp bl, $F+1
  jnc @@4
@@2:
  add cx, bx
  cmp cx, Lastpage-Firstpage
  jnc @@4
  lea di, toppage
  add di, cx
  mov ax, 1
  mov bl, [di]
  cmp bl, 1
  jz @@5
  cmp bl, 2
  jz @@5
  cmp bl, 4
  jz @@5
  cmp bl, 6
  jz @@5
  cmp bl, 8
  jz @@5
  cmp bl, 9
  jz @@5
  cmp bl, 0
  jz @@4 { Seite nicht vorhanden }
  lea di, Multipage
  add di, cx
  mov al, [di]
  xor ah, ah
  cmp ax, 1
  jc @@3
  cmp ax, 10
  jc @@5
@@3:
  mov ax, ANZSUBPAGE
  jmp @@5
  inc ax
  jmp @@5
@@4:
  xor ax, ax
@@5:
  pop es
end;

{***************************************************************************}
procedure getpage (SuchSeite:pagetyp; VAR UPs : Word);
{ Liest alle gewnschten subpages einer Teletextseite in das PC-RAM.
    Seite......enthlt neuen Seitenwunsch
    status.....Erfolgsbericht der Prozedur
    Wenn UPs bei Eintritt 9999 ist, Seite auf jeden Fall neu einlesen
    Wenn Seite = 0 dann ist Showpage nicht geaendert
  Folgende Schritte werden ausgefhrt:
    1) Wenn Seite noch nicht vorhanden :
       MainPage setzten und dann automatisch in der Procedure parallel
       bearbeitet
    2) repeat until Auftrag erledigt oder abgebrochen
    3) Kennzeichne ggf. wenn Seite nicht vorhanden oder abgebrochen
    4) Seite anzeigen
}
VAR
  SuchPage : Pagetyp;
  NewPage  : Boolean;
  OldPage  : BOOLEAN;
Begin
  OldPage := Suchseite = '000';
  If OldPage THEN
    SuchSeite := Showpage
  ELSE BEGIN
    Showpage := Suchseite;
    ShowUP := 1;
  END;
  Writeline (5,1,3,Yellow,ShowPage);
  IF WriteLater THEN BEGIN
    WriteLater := false;
    IF Mainstatus = telewait THEN BEGIN
      IF (Showpage = Laterpage) THEN BEGIN
        Writepage(LaterUpage);
        ShowSeitenstatus;
        exit;
      end;
    end;
  end;
  Mainstatus:=teleok;
  if checkoutwin > 0 THEN closewindow (checkoutwin);
  NewPage := Ups = 9999;
  IF not Newpage THEN Getdiskseite (Showpage, AktuellerSender, seiteptrakt, MainUPs)
                 ELSE MainUPs := 0;
  IF MainUPs = 0 THEN BEGIN
    MainUPs := pageUPs(ShowPage);
    IF (MainUPs = 0) THEN
      IF ((ShowPage[1] = '1') AND (ShowPage[2] = 'F') and TOPPageDa) THEN
        MainUPs := ANZSUBPAGE;
    IF (MainUPs = 0) THEN
      IF bestaetigen (44,15,white, red, black,lightgray,links, doppelt,
                      false,MenueText[StrSeitenichteingetragen_suchen]) THEN
        MainUPs := ANZSUBPAGE;
    IF MainUPs > 0 THEN BEGIN
      IF NOWAIT THEN BEGIN
        IF Mainpagestand < 255 THEN BEGIN
          SetMainpagetab (Showpage);
          Mainstatus := Telewait;
        end;
        IF not (Newpage or OldPage) THEN Waitstatus;
      END
      ELSE BEGIN
        MAINPage := Showpage;
        repeat
          parallel;
          IF Maincct < 4 THEN mainstatus := status [Maincct];
          if keyda then if readkey=#27 then begin
            mainstatus:=telebreak;
            IF maincct < 4 THEN
              Laterpage := '   ';
            Maincct    := 255;
            MainPage   := '';
            Mainups    := 0;
          end;
        until (MAINPage = '');
      end;
    END
    ELSE BEGIN
      Mainstatus := telenopage;
      MainUPs := 0;
    end;
  END;
  UPs := MainUPs;
  IF UPs = 0 THEN
    fillchar(seiteptrakt^,sizeof(T_Eineseite)*ANZSUBPAGE,chr(0));
  IF Mainstatus <> telewait THEN
    writepage (ShowUP);
  ShowSeitenstatus;
End; { getpage }

{***************************************************************************}
{******     Routine , die Parallel zu Tastatureingabe luft         ********}
{***************************************************************************}
Procedure Parallel;
VAR i, Lauf, speicher : WORD;
    Nummer            : WORD;
    aktzeit           : longint;
    Statusbyte        : Byte;
    Lastseite         : PageTyp;
    LastshowPage      : Pagetyp;
    SHelp             : String;
    Lastgesamtanzahl  : Word;
    SeitenNr          : Word;
    ok                : boolean;
    IsTOPPage         : Boolean;
{***************************************************************************}
Function NameVorhanden (Var Lauf:word): Boolean;
VAR Start  : Word;
    shelp1 : string;
BEGIN
  ASM
    lea di, shelp1
    push ss
    pop es
    push ds
    lds si, seiteptrwork
    add si, 8
    mov cx, 14
    mov es:[di], cl
    inc di
@@1:
    lodsb
    and al, $7f
    stosb
    dec cx
    jne @@1
    pop ds
  end;
  lauf := 0;
  repeat
    inc (lauf);
    Start := pos (senderarray[lauf], shelp1);
  until (Start > 0) OR (Lauf >= MaxSender);
  IF (Start > 0) AND (length(Senderarray[lauf]) > 1) then begin
    SenderStart := Start;
    Namevorhanden := True;
  end
  else
    namevorhanden := false;
END;

{***************************************************************************}
procedure Vergleiche (speicher: word; SuchSeite:PageTyp);
VAR
  IHelp  : Word;
  gleich : boolean;
BEGIN
  GetDiskSeite (SuchSeite, Aktuellersender, Seiteptrvergl, IHelp);
  IF IHELP > 0 THEN BEGIN
    gleich := true;
    asm
      push ds
      mov ax, speicher
      mov bx, 4
      mul bx
      lea si, seiteptr
      add si, bx
      les di, Seiteptrvergl
      mov bx, Seitenlaenge
      mov ax, IHelp
      lds si, [si]
      cld
    @@1:
      add si, 40   {Statuszeile nicht vergleichen}
      add di, 40
      mov cx, 23*20 {23 Zeilen a 40 Zeichen (/2 da Wortsuche)}
      repe cmpsw
      jne @@3
      sub si, 24*40     { Seite stimmt berein }
      mov cl, [si]
      cmp cl, '0'
      jge @@2
      mov cl, $30
    @@2:
      inc cl
      mov [si], cl
      add si, bx        { nchste Seite setzen }
      add di, Seitenlaenge - (24 * 40)
      jmp @@4
    @@3:
      mov gleich, 00   { Seite ist nicht wie die letzte }
      shl cx, 1
      add di, cx
      add si, cx
      add di, Seitenlaenge - (24*40)
      add si, Seitenlaenge - (24*40)
    @@4:
      dec ax
      jne @@1
            pop ds
    end;
    val (Suchseite, IHelp,speicher);
    oktab[HexDec(SuchSeite)] := gleich;
  end;
end;            

{***************************************************************************}
Procedure SetzeNeuenAuftrag;
{ 1: neue Zeit ausgeben
  2: Wenn Hauptprogramm Seite anfordert, testen, ob diese
     schon in Auftrag ist.
  3: Wenn cctSpeicher 0 frei und Hauptprogramm Seite anfordert, diese
     vergeben.
  4: Allen freien cctSpreichern neue Seiten zuordnen
}

VAR
  LastLesestand, j, k, Anzahl: WORD;
  cctspeicher                : word;
  PageNr                     : String[3];
  Gefunden                   : boolean;
begin
  IF (not Nowait) THEN
    IF MainPage >= '100' THEN BEGIN
      IF Auftrag[speicher].frei OR (Speicher < 2) AND (Auftrag[speicher].Gesamtanzahl > 1) THEN BEGIN
        IF Auftrag[speicher].Gesamtanzahl > 1 THEN AuftragAbbrechen(speicher);
        k := PageUPs(MainPage);
        SetzeAuftrag(speicher,MainPage,k);
        Showpage   := Mainpage;
        MainPage := '---';
        Maincct  := speicher;
        Checkout (speicher,k,0);
      END;
    END;
  { TOPText holen ? }
  IF speicher = TOPTEXTcct THEN
    IF Auftrag[TOPTEXTcct].freigabe AND Auftrag[TOPTEXTcct].frei THEN BEGIN
      IF ABS (LongTime-TOPtimestart) >= Toptime THEN
        Gettoptext := SenderMitToptext;
      IF Gettoptext THEN begin
         SetzeAuftrag (TOPTEXTcct,TOPSeite,1);
         TOPTimeStart := LongTime;
         Gettoptext := false;
      END;
    end;
  IF Auftrag[speicher].frei THEN
  IF Nowait AND (Mainpagestand > 0) THEN BEGIN
{Suche die Seite die zuerst angefordert wurde.
 soll die zuletzt eingegebene Seite zuerst gesucht werden, so ist
 die -1- durch Mainpagestand zu ersetzten}
      PageNr := MainPageTab[1];
      Delmainpage(Mainpagetab[1]);
      SetzeAuftrag (speicher,PageNr,PageUPs(PageNr));
    end
    ELSE IF Auftrag[speicher].freigabe THEN BEGIN
      LastLesestand := Lesestand[speicher];
      Anzahl := 0;
      k := speicher div 2 + 1;
      cctspeicher := speicher;
      repeat
        ASM
          mov ax, k
          dec ax
          je @@1
          mov ax, (LastPage - Firstpage + 1) * 2
        @@1:
          lea di, ccttab
          add di, ax
          mov bx, di        {Adresse von ccttab nach bx}
          lea si, Lesestand
          clc
          add si, cctspeicher
          add si, cctspeicher
          mov dx, si        {Adresse von Lesestand[speicher] nach dx}
          mov cx, [si]      { hole Lesestandstand}
        @@2:
          mov di, bx
          add di, cx
          add di, cx        {ccttab-Eintrag}
          lea si, auswahltab
          add si, cx
          mov ax, [di]
          dec ah
          and ah, al
          and ah, [si]
          mov gefunden, ah
          je @@3
          mov word [di],  $0101  {Istseite als true eintragen}
          jmp @@5
        @@3:
          inc cx
          cmp cx, Lastpage - Firstpage + 1
          jl @@4
          sub cx, Lastpage - Firstpage + 1
       @@4:
          mov si, dx
          mov [si], cx
          cmp cx, Lastlesestand
          jne @@2
       @@5:
        end;
        IF gefunden THEN BEGIN
          PageNr := DecHex (Lesestand[speicher]+FirstPage);
          SetzeAuftrag (speicher,PageNr,PageUPs(PageNr));
          Lesestand [speicher] := (Lesestand[speicher] + Abstand) MOD (SUCC(LastPage-FirstPage));
          exit;
        end
        ELSE BEGIN
          inc (anzahl);
          CASE ANZAHL OF
            1, 3: BEGIN
                    If AktAuswahlsuche AND Aktweitersuche THEN BEGIN
                    {Bei Auswahlsuche feststellen, ob alles eingelesen ist}
                      j := Pred(Firstpage);
                      REPEAT
                        inc (j)
                      UNTIL (j = LastPage) OR (Auswahltab[j] and (
                            (ccttab[1,j].soll and not ccttab[1,j].ist) OR
                            (ccttab[2,j].soll and not ccttab[2,j].ist)));
                      if (j = LastPage) THEN
                        ResetAuswahltab(Auswahltab,true);
                    end;
                    clearccttab(k);
                    For j := 0 TO 3 DO
                      WITH Auftrag[j] DO BEGIN
                        SeitenNr := HexDec (Seite);
                        IF (not frei) AND (SeitenNr >= FirstPage) THEN
                          ccttab[k,SeitenNr].ist := ccttab[k,SeitenNr].soll;
                      END;
                    inc (durchlauf[k]);
                  end;
            2   : Begin
                    dec (durchlauf[k]);
                    k := k mod 2 + 1;
                  END
             else BEGIN
                    dec (durchlauf[k]);
                    exit;
                  End;
          end;{CASE}
        END; {ELSE BEGIN}
      UNTIL false;
    end;
end;

{***************************************************************************}
Procedure SetTopText;
VAR i,j : BYTE;
  GetMultipage, GetADIP : BOOLEAN;
BEGIN
  GetMultipage := false;
  GetAdip      := false;
  IF Auftrag[speicher].Seite = TOPSeite THEN BEGIN
    IF Status[speicher] = teleok THEN SetTOPPage;
    ClearAuftrag(speicher);
    Getmultipage := true;
  END
  ELSE IF Auftrag[speicher].Seite = MULTISeite THEN BEGIN
    IF Status[speicher] = teleok THEN SetMULTIPage;
    ClearAuftrag(speicher);
    GetADIP := true;
  END
  ELSE BEGIN
    i := 0;
    For j := 1 TO MaxADIP DO
      IF ADIPSeite[j] = Auftrag[speicher].seite THEN i := j;
    IF i > 0 THEN BEGIN
      IF Status[speicher] = teleok then SetADIPTab(i);
      ClearAuftrag (Speicher);
      ADIPSeite[i] := '  ';
      GetADIP := true;
    END;
  END;
  IF GetMultipage THEN
    IF MultiSeite > '---'THEN
      SetzeAuftrag(speicher,MULTISeite,1)
    ELSE
      GetADIP := True;
  IF GetADIP THEN BEGIN
    i := 0;
    WHILE i < MaxADIP DO BEGIN
      INC (i);
      IF ADIPSeite[i] > '---'THEN BEGIN
        SetzeAuftrag(speicher,ADIPSeite[i],1);
        EXIT;
      END;
    end;
    IF AktScanTopText AND NOT gescannt AND (i = MaxADIP) THEN BEGIN
      ScanTopText (AktScanDauerTopText);
      gescannt := true;
    END;
  END;
END;

{***********************************************************************}
Procedure Videotextqualitaet;
BEGIN
  Videosignal := '?';
  Textsignal  := '?';
  IF i2cstat (statusbyte) THEN BEGIN
    IF Statusbyte AND 1 > 0 THEN Videosignal := '+'
                            ELSE Videosignal := '-';
    IF Statusbyte AND 2 > 0 THEN Textsignal  := '+'
                            ELSE Textsignal  := '-';
  END;
  Writeline (36,25,5,green,'V' + Videosignal +' T' + Textsignal);
END;

{********************* M A I N *********************************}
{ Wenn eine Seite eingelesen wurde, Schleife abbrechen }
BEGIN
  IF MainPage >= '100' THEN BEGIN
    FOR Lauf := 0 TO 3 DO
      {Teste ob angeforderte Seite schon in Auftrag}
      IF Auftrag[lauf].Seite = MainPage THEN BEGIN
        i := Pageups(Mainpage);
        IF Auftrag[lauf].frei then
          SetzeAuftrag(lauf,MainPage,i);
        Showpage        := Mainpage;
        MainPage        := '---';
        Maincct         := lauf;
        mainstatus      := status[lauf];
        Checkout (lauf,i, 0);
        lauf := 3; { Schleife beenden }
      END;
    IF Maincct <> 0 THEN WITH Auftrag[0] DO
      IF Gesamtanzahl > 1 THEN BEGIN
        i := 0;
        FOR Lauf := 1 TO GESAMTANZAHL DO
          if pageok[Lauf] THEN INC (i);
        IF Gesamtanzahl - i > 1 THEN Clearauftrag(0);
      end;
  end;
  For lauf := 0 TO 3 DO BEGIN
    speicher := (lauf + Speicherstand) MOD 4;
    IF not Auftrag[speicher].frei THEN BEGIN
      IF arrived (speicher) THEN BEGIN
        {Delay ist wichtig fr die ersten beiden Zeilen}
        { Das Delay wird durch Multitaskfreigabe und Videosignalabfrage
          erreicht}
        asm
          mov ax, $40
          mov es, ax
          mov dx, es:[$6c]
        @@1:
          push es
          push dx
          mov ax, $1680
          int $2F
          pop dx
          pop es
          mov cx, es:[$6c]
          sub cx, dx
          cmp cx, 1
          jl @@1
        end;
        Videotextqualitaet;
        If (mainstatus = telewait) AND (Checkoutwin = 0) AND
            Hauptmenueda AND Waitstatuswin then waitstatus;
        DelMainpage(auftrag[speicher].Seite);
        readcctpage(speicher);
        IF AktuellerSender = '' THEN
          IF Namevorhanden (i) THEN BEGIN
            AktuellerSender      := Senderarray[i];
            Senderlaenge         := LENGTH(AktuellerSender);
            AktWeitersuche       := Weitersuche[i];
            AktAuswahlsuche      := Auswahlsuche[i];
            AktHexseiten         := Hexseiten[i];
            Aktscantoptext       := ScanSenderToptext[i];
            AktScandauerTopText  := ScanDauerTopText[i];
            gescannt             := false;
            setauswahltab(AktuellerSender,AktAuswahlsuche,ok,Auswahltab);
          END
          ELSE BEGIN
            Senderlaenge := 0;
            AktuellerSender := '';
            InitAktVariables;
            resetauswahltab (Auswahltab,true);
          end;
        ASM
          lea di, shelp
          push ss
          pop es
          push ds
          mov dx, Senderstart
          add dx, 7
          mov cx, Senderlaenge
          lds si, seiteptrwork
          add si, dx
          mov es:[di], cl
          or cx,cx
          je @@2
          inc di
        @@1:
          lodsb
          and al, $7f
          stosb
          dec cx
          jne @@1
        @@2:
          pop ds
        end;
        IF shelp <> AktuellerSender THEN BEGIN
          IF NameVorhanden(i) THEN BEGIN
            AktuellerSender := Senderarray[i];
            Senderlaenge := LENGTH(AktuellerSender);
            AktWeitersuche      := Weitersuche[i];
            AktAuswahlsuche     := Auswahlsuche[i];
            AktHexseiten        := Hexseiten[i];
            Aktscantoptext      := ScanSenderToptext[i];
            AktScanDauerTopText := ScanDauerTopText[i];
            Senderwechsel(false);
            gescannt := false;
            setauswahltab(Aktuellersender,AktAuswahlsuche,ok,Auswahltab);
            exit;
          END
          ELSE BEGIN
            If Shelp = OldSendername THEN BEGIN
              INC (SenderAenderung);
              IF SenderAenderung > 2 THEN BEGIN
                IF not Senderwechselnachfrage THEN BEGIN
                  Senderwechselnachfrage := true;
                  IF bestaetigen (52,11,white, red, black,lightgray,links, doppelt,
                                  true,MenueText[StrSenderwechsel]+' ?') THEN BEGIN
                    AktuellerSender := '';
                    Senderlaenge := 0;
                    InitAktVariables;
                    Resetauswahltab (Auswahltab,true);
                    Senderwechsel(true);
                  end;
                  Senderwechselnachfrage := false;
                  Speicherstand := succ (speicher) MOD 4;
                end;
              end;
              exit;
            end
            else begin
              Oldsendername := SHelp;
              SenderAenderung := 0;
              exit;
            end
          end {ELSE BEGIN (Name nicht vorhanden)}
        end{If Shelp <> Aktuellername}
        ELSE BEGIN
          Oldsendername := SHelp;
          SenderAenderung := 0;
        end;
        With Auftrag[speicher] DO BEGIN
          SeitenNr := HexDec (Seite);
          IF NOT ((Seite[1] = '1') AND (Seite[2] = 'F')) THEN BEGIN
            nummer := ReadUpageNr;      {Unterseitennummer erkennen}
            IF nummer = 0 THEN BEGIN
              Gesamtanzahl := 1;
              Pageok[1] := True;
              {ggf TOPText-Information aufbessern}
              IF Toppage[SeitenNr] IN [0,3,5,7,$A,$B,255] THEN BEGIN
                Toppage[SeitenNr] := $8;
                ccttab[1,SeitenNr].soll := true;
                ccttab[2,SeitenNr].soll := false;
              end;
            END
            ELSE BEGIN
              IF MULTIPAGE[SeitenNr] IN [1..9] THEN
                 gesamtanzahl := Multipage[SeitenNr]
              else
                IF (Gesamtanzahl = ANZSUBPAGE) AND (nummer < lastnummer) THEN
                  Gesamtanzahl := lastnummer;
              if (nummer > Gesamtanzahl) OR (GESAMTANZAHL = 1) THEN
                Gesamtanzahl   := ANZSUBPAGE;
              lastnummer       := nummer;
              pageok[nummer]   := True;
              Zeit             := LongTime;
              OutTime          := TimeoutUPs;
              dec (nummer);                         {nummer von 0 ..  }
              {ggf TOPText-Information aufbessern}
              IF Toppage[SeitenNr] IN [0..2,4,6,8,9] THEN BEGIN
                Toppage[SeitenNr] := $A;
                ccttab[2,SeitenNr].soll := true;
                ccttab[1,SeitenNr].soll := false;
                Multipage[SeitenNr] := Gesamtanzahl;
              end;
            end;
            { Kopiere von Seiteptrwork[0] nach Seiteptr[....]}
            {move (seiteptrwork^[0],seiteptr[speicher]^+nummer*Seitenlaenge),Seitenlaenge;}
            asm
              push es
              push ds
              mov cx, Seitenlaenge
              mov ax, speicher
              mov bx, 4
              mul bx
              lea di, seiteptr
              add di, ax
              les di, [di]
              mov ax, nummer
              mul cx
              add di, ax
              lds si, seiteptrwork
              shr cx, 1
              cld
              rep movsw
              pop ds
              pop es
            end;
            IF Seite = ShowPage THEN
            { Kopiere von Seiteptrwork[0] nach Seiteptrakt[....]}
            {move (seiteptrwork^[0],seiteptrakt^+nummer*Seitenlaenge),Seitenlaenge;}
              asm
                push es
                push ds
                mov cx, Seitenlaenge
                les di, seiteptrakt
                mov ax, nummer
                mul cx
                add di, ax
                lds si, seiteptrwork
                shr cx, 1
                cld
                rep movsw
                pop ds
                pop es
              end;
            ok := true;    { Alle Seiten Eingelesen? }
            FOR i := 1 TO Gesamtanzahl DO
              ok := ok AND pageok[i];
            IF ok then begin
              If speicher = Maincct THEN BEGIN
                MainUPs   := Gesamtanzahl;
                Maincct   := 255;
                MainPage  := '';
              end;
              IF Gesamtanzahl = 1 THEN
                ccttab[1,HexDec(Auftrag[speicher].Seite)].ist := true
              else
                ccttab[2,HexDec(Auftrag[speicher].Seite)].ist := true;
              Lastseite        := Seite;
              Lastgesamtanzahl := Gesamtanzahl;
              LastshowPage   := ShowPage;
              ClearAuftrag(speicher);
              setzeNeuenAuftrag;
              IF Seitenkontrolle THEN Vergleiche (speicher,lastSeite);
              PutDiskSeite(speicher,LastSeite,LastGesamtAnzahl);
              if nowait THEN Delmainpage(LastSeite);
              IF LastShowPage = LastSeite THEN BEGIN
              { Kopiere von Seiteptr nach Seiteptrakt[....]}
              {move (seiteptr^[speicher],seiteptrakt^,Seitenlaenge*LastgesamtAnzahl);}
                asm
                  push es
                  push ds
                  mov cx, Seitenlaenge
                  les di, seiteptrakt
                  shr cx,1
                  lea si, Lastgesamtanzahl
                  mov ax, ss:[si]
                  mul cx
                  mov cx, ax
                  mov ax, speicher
                  mov bx, 4
                  mul bx
                  lea si, seiteptr
                  add si, ax
                  lds si, [si]
                  cld
                  rep movsw
                  pop ds
                  pop es
                end;
                MainUPs := Lastgesamtanzahl;
                If (Checkoutwin > 0) OR (MainStatus = telewait) THEN
                  ShowUP := 1;
                Mainstatus := teleok;
                Writepage(ShowUP);
                Showseitenstatus;
              end;
            end { IF ok}
            else
              IF showpage = Seite THEN BEGIN
                IF (Gesamtanzahl > 1) AND ((Checkoutwin>0) or (Mainstatus = telewait)) THEN BEGIN
                  Checkout (speicher,Gesamtanzahl,nummer+1);
                  showUP := nummer + 1;
                  Writepage (ShowUP);
                  Setcolor(1,25,18,1,green);
                end
                ELSE BEGIN
                  If ShowUP = nummer + 1 THEN
                    Writepage (ShowUP);
                end;
              end;
          end { IF NOT (Seite[1] = '1') AND (Seite[2] = 'F'))}
          else begin
            If Seite = ShowPage THEN BEGIN
              Lastseite        := Seite;
              Lastgesamtanzahl := Gesamtanzahl;
              LastshowPage   := ShowPage;
              ClearAuftrag(speicher);
              setzeNeuenAuftrag;
              MainUPs   := 1;
              Maincct   := 255;
              MainPage  := '';
              { Kopiere von Seiteworkptr nach Seiteptrakt[....]}
              {move (seiteworkptr^[speicher],seiteptrakt^,Seitenlaenge);}
              asm
                push es
                push ds
                mov cx, Seitenlaenge
                shr cx,1
                les di, seiteptrakt
                lds si, seiteptrwork
                cld
                rep movsw
                pop ds
                pop es
              end;
              MainUPs := 1;
              ShowUP := 1;
              Mainstatus := teleok;
              Writepage(ShowUP);
              Showseitenstatus;
            end { IF Seite = Showpage}
            else
              settoptext;
          end; {ELSE BEGIN }
        end; {With Auftrag..}
        Speicherstand := succ (speicher) MOD 4;
        exit;
      end { IF arrived }
      ELSE WITH Auftrag[speicher] DO BEGIN
        aktzeit := longtime;
        IF aktzeit - Zeit > Outtime  THEN BEGIN
          status[speicher] := teletimeout;
          { Wenn Multipage nicht gesetzt, Seite austragen }
          SeitenNr := HexDec (Seite);
          IF SeitenNr > 0 THEN begin
            IF Toppage[SeitenNr] IN [1,2,4,6,8,9] THEN
              ccttab[1,SeitenNr].soll := false
            else
              ccttab[2,SeitenNr].soll := false;
            TOPPage[SeitenNr] := 0;
          end;
          Videotextqualitaet;
        end
        else IF Aktzeit - Zeit < 0 THEN
          Zeit := Aktzeit;
        IF status [speicher] <> teleok THEN BEGIN
          IF Maincct = speicher THEN BEGIN
            mainstatus := status [Maincct];
            Maincct    := 255;
            MainPage   := '';
            Mainups    := 0;
          end;
          If (showpage = Seite) AND (CheckoutWin = 0) THEN BEGIN
            MAinstatus := status[speicher];
            ShowSeitenstatus;
          end;
          ClearAuftrag(speicher);
          LastSeite := Seite;
          setzeNeuenAuftrag;
          if (LastSeite >= '1F0') AND (LastSeite <= '1FF') THEN
            IF not (Scantoptextnachfrage or Senderwechselnachfrage) THEN BEGIN
              Scantoptextnachfrage := true;
              SenderMitTOPTEXT := False;
              IF bestaetigen (43,11,white, red, black,lightgray,links, doppelt,
                        false,MenueText[StrTOPTEXTInfoselbsterstellen]) THEN
                        scantoptext (50);
              Scantoptextnachfrage := false;
            end;
        END;{Status <> Teleok}
      END; {With Auftrag[Speicher]}
    END {not frei}
    else
      SetzeNeuenAuftrag;
  end; {for}
  writeteletime;
end;{parallel}

{***************************************************************************}
procedure programminfo;
VAR SHelp   : string;
BEGIN
  openwindow(20,8,40,14,white,red,links,doppelt, wininfo);
  titelwindow (wininfo,omitte,MenueText[StrProgInfo]);
  writecWin (Wininfo,2,Menuetext[StrProgInfo +1]);
  writecwin (wininfo,4,'Gerald Sinzig,  ++49-2238-56621');
  writecwin (wininfo,6, Version);
  writecwin (wininfo,8,Menuetext[StrProgInfo + 2] + 'c''t 11/91-10/92');
  writecwin (wininfo,9,Menuetext[StrProgInfo + 3] + ' TURBO-PASCAL 6.0');
  str (memavail DIV 1000, shelp);
  writecwin (wininfo,11,MenueText[StrProgInfo + 4] + ' '+shelp+' KB');
end;

{***************************************************************************}
Procedure GetWinPageNr  (x,y:Word;VAR Seitenstr:pagetyp;VAR RC:T_Staste);
VAR SHelp : STRING;
    win   : Word;
    ok    : Boolean;
BEGIN
  openwindow(x,y,16,3,white,cyan,links,doppelt,win);
  titelwindow(Win,omitte,menueText [StrSeitennummer]);
  Repeat
    SHelp := Seitenstr;
    GetwinCselect (Win,1,3,yellow,['0'..'9','A'..'F','a'..'f','*'],SHelp,RC);
    IF RC = cr THEN BEGIN
      ok := Checkchar(SHelp[1],'8');
      IF ok THEN ok := Checkchar(SHelp[2],'0');
      IF ok THEN ok := Checkchar(SHelp[3],'0');
      IF ok THEN
        Seitenstr := SHelp
      ELSE
        Fehler(48,y+3,StrUngueltigeEingabe);
    END;
  UNTIL OK or (RC = ESC);
  Closewindow(Win);
end;

{***************************************************************************}
{*************         INCLUDE - DATEI fr VGA                **************}
{***************************************************************************}
{$I TOPTXVGA.INC}

{***************************************************************************}
{*******************   Register-direkt-setzen/lesen   **********************}
{***************************************************************************}
{$I register.inc}

{***************************************************************************}
{****************   Schon eingelesene Senderseiten anzeigen   **************}
{***************************************************************************}
{$I Seiten.inc}

{***************************************************************************}
{*************      INCLUDE - DATEI fr Sonderfunktionen      **************}
{***************************************************************************}
{$I SONDER.INC}

{***************************************************************************}
{*************         INCLUDE - DATEI frs Setup             **************}
{***************************************************************************}
{$I SETUP.INC}

{***************************************************************************}
{*************                M A I N                         **************}
{***************************************************************************}
Var i,sel       : word;
begin
  Loadsetup; { Hole Setup }
  InitVTScreen (co80);
  { Alle cct-RegisterKopien lschen}
  For I := 0 TO 11 DO
    REG[I] := 0;
  showpage   := '---';
  showup   := 1;
  mainups  := 1;
  statuswin := 0;
  checkoutwin := 0;
  Mainpagestand := 0;
  MainStatus    := telebreak;
  AnzSubPage := AnzSubPageSoll;
  Auftrag[0].Seite := '000';
  Auftrag[1].Seite := '000';
  Auftrag[2].Seite := '000';
  Auftrag[3].Seite := '000';
  Hauptmenueda := false;
  senderwechselnachfrage := false;
  scantoptextnachfrage := false;
  InitAktVariables;
  WinTimeOut := 0;
  WinTimeoutaktiv := false;
  Watchdog := longtime;
  Updatesperre := false;
  Writelater   := false;
  AktuellerSender := '';
  Senderlaenge := 0;
  openwindow(1,2,40,23,white,black,ohne,blockblack,VTwin);
  HoleSender;
end.
