{**************************************************************************}
{************************ I2C-Bus-Routinen  *******************************}
{**************************************************************************}
{ include-Datei fr Teletext.pas }

{-------------------  c't Dekoder ----------------------}
procedure SDAHct;  { setze SDA von I2C-Bus = HIGH }
{begin
  portc := Port [I2CBASIS + 2];
end;
}
ASSEMBLER;
ASM
  mov dx, i2cbasis
  add dx, 2
  in al, dx
  in al, dx
end;

procedure SDALct;  { setzte SDA von I2C-Bus = LOW }
{begin
  Portc := Port [I2CBASIS + 3];
end;
}
ASSEMBLER;
ASM
  mov dx, i2cbasis
  add dx, 3
  in al, dx
  in al, dx
end;

procedure SCLHct;  { setzte SCL von I2C-Bus = HIGH }
{begin
  Portc := Port [I2CBASIS];
end;
}
ASSEMBLER;
ASM
  mov dx, i2cbasis
  in al, dx
  in al, dx
  mov cx,verzoegerung
@@9:
  loop @@9
end;

procedure SCLLct;  { setzte SCL von I2C-Bus = LOW }
{begin
  Portc := Port [I2CBASIS + 1];
end;
}
ASSEMBLER;
ASM
  mov dx, i2cbasis
  add dx, 1
  in al, dx
  in al, dx
  mov cx,verzoegerung
@@9:
  loop @@9
end;

function SDAinct:boolean;  { Liest Datenbit von I2C-Bus }
{  true..Datenbit=HIGH
  false..Datenbit=LOW  }
{begin
  portc := port [I2CBASIS + 2];
  SDAin := ((portc and $01) > 0);
end;
}
ASSEMBLER;
ASM
  mov dx, i2cbasis
  add dx, 2
  in  al, dx
  in  al, dx
  and al, $1
end;


{-------------------- LPT Dekoder -------------------}
procedure SDAHLPT; ASSEMBLER;  { setze SDA von I2C-Bus = HIGH }
ASM
  MOV dx, I2CBASIS
  in al, dx
  and al, $7F
  out dx, al
 { Port [I2CBASIS] := Port [I2CBASIS] AND $7F;}
end;

procedure SDALLPT;ASSEMBLER;  { setzte SDA von I2C-Bus = LOW }
ASM
  MOV dx, I2CBASIS
  in al,dx
  in al, dx
  or al, $80
  out dx,al
{  Port [I2CBASIS] := Port [I2CBASIS] OR $80;}
end;

procedure SCLHLPT;ASSEMBLER;  { setzte SCL von I2C-Bus = HIGH }
ASM
  MOV dx, I2CBASIS
  in al, dx
  in al, dx
  or al, $01
  out dx, al
  mov cx,verzoegerung
@@9:
  loop @@9
{  Port [I2CBASIS] := Port [I2CBASIS] OR $01;}
end;

procedure SCLLLPT;assembler;  { setzte SCL von I2C-Bus = LOW }
ASM
  MOV dx, I2CBASIS
  in al, dx
  in al, dx
  and al, $FE
  out dx,al
  mov cx,verzoegerung
@@9:
  loop @@9
  END;
{  Port [I2CBASIS] := Port [I2CBASIS] AND $FE;}

function SDAinLPT : boolean;ASSEMBLER;  { Liest Datenbit von I2C-Bus }
ASM
  MOV dx, I2CBASIS
  inc dx
  in  al, dx
  in  al, dx
  shr al, 7
  xor al, 1
{
  portc := PORT[I2CBASIS+1] AND $80;
  SDAin := (portc = 0)
}
end;

{-------------------- ELV Dekoder -------------------}
procedure SDAHELV; ASSEMBLER;  { setze SDA von I2C-Bus = HIGH }
ASM
  MOV dx, I2CBASIS
  mov al, portc
  or al, $1
  mov portc, al
  out dx, al
end;

procedure SDALELV;ASSEMBLER;  { setzte SDA von I2C-Bus = LOW }
ASM
  MOV dx, I2CBASIS
  mov al, portc
  and al, $FE
  mov portc, al
  out dx,al
end;

procedure SCLHELV;ASSEMBLER;  { setzte SCL von I2C-Bus = HIGH }
ASM
  MOV dx, I2CBASIS
  mov al, portc
  or al, $02
  mov portc, al
  out dx, al
  mov cx,verzoegerung
@@9:
  loop @@9
end;

procedure SCLLELV;assembler;  { setzte SCL von I2C-Bus = LOW }
ASM
  MOV dx, I2CBASIS
  mov al, portc
  and al, $FD
  mov portc, al
  out dx, al
  mov cx,verzoegerung
@@9:
  loop @@9
  END;

function SDAinELV : boolean;ASSEMBLER;  { Liest Datenbit von I2C-Bus }
ASM
  MOV dx, I2CBASIS
  in  al, dx
  in  al, dx
  and al, $1
  or portc, al
end;

{-------------------- Port Dekoder -------------------}
procedure SDAHPort1; ASSEMBLER;  { setze SDA von I2C-Bus = HIGH }
ASM
  mov dx, SDAADDR
  mov cl, SDAMASKE
  mov ch, SDAINV
  mov al, I2CPort
  not cl
  and al, cl
  or al, ch
  mov I2CPort, al
  out dx, al
 { I2CPort := (I2CPort AND NOT SDAMASKE) OR SDAINV;
   Port [SDAADDR] := I2CPort; }
end;

procedure SDALPort1;ASSEMBLER;  { setzte SDA von I2C-Bus = LOW }
ASM
  mov dx, SDAADDR
  mov cl, SDAMASKE
  mov ch, SDAINV
  mov al, I2CPort
  or al, cl
  not ch
  and al, ch
  mov I2CPort, al
  out dx, al
 { I2CPort := (I2CPort OR SDAMASKE) AND NOT SDAINV;
   Port [SDAADDR] := I2CPort; }
end;

procedure SCLHPort1;ASSEMBLER;  { setzte SCL von I2C-Bus = HIGH }
ASM
  mov dx, SCLADDR
  mov cl, SCLMASKE
  mov ch, SCLINV
  mov al, I2CPort
  not cl
  and al, cl
  or al, ch
  mov I2CPort, al
  out dx, al
  mov cx,verzoegerung
@@9:
  loop @@9
 { I2CPort := (I2CPort AND NOT SCLMASKE) OR SCLINV;
   Port [SCLADDR] := I2CPort; }
end;

procedure SCLLPort1;assembler;  { setzte SCL von I2C-Bus = LOW }
ASM
  mov dx, SCLADDR
  mov cl, SCLMASKE
  mov ch, SCLINV
  mov al, I2CPort
  or al, cl
  not ch
  and al, ch
  mov I2CPort, al
  out dx, al
  mov cx,verzoegerung
@@9:
  loop @@9
 { I2CPort := (I2CPort OR SCLMASKE) AND NOT SCLINV;
   Port [SCLADDR] := I2CPort; }
end;

procedure SDAHPort2; ASSEMBLER;  { setze SDA von I2C-Bus = HIGH }
ASM
  mov dx, SDAADDR
  mov cl, SDAMASKE
  mov ch, SDAINV
  mov al, SDAPort
  not cl
  and al, cl
  or al, ch
  mov SDAPort, al
  out dx, al
 { SDAPort := (SDAPort AND NOT SDAMASKE) OR SDAINV;
   Port [SDAADDR] := SDAPort; }
end;

procedure SDALPort2;ASSEMBLER;  { setzte SDA von I2C-Bus = LOW }
ASM
  mov dx, SDAADDR
  mov cl, SDAMASKE
  mov ch, SDAINV
  mov al, SDAPort
  or al, cl
  not ch
  and al, ch
  mov SDAPort, al
  out dx, al
 { SDAPort := (SDAPort OR SDAMASKE) AND NOT SDAINV;
   Port [SDAADDR] := SDAPort; }
end;

procedure SCLHPort2;ASSEMBLER;  { setzte SCL von I2C-Bus = HIGH }
ASM
  mov dx, SCLADDR
  mov cl, SCLMASKE
  mov ch, SCLINV
  mov al, SCLPort
  not cl
  and al, cl
  or al, ch
  mov SCLPort, al
  out dx, al
  mov cx,verzoegerung
@@9:
  loop @@9
 { SCLPort := (SCLPort AND NOT SCLMASKE) OR SCLINV;
   Port [SCLADDR] := SCLPort; }
end;

procedure SCLLPort2;assembler;  { setzte SCL von I2C-Bus = LOW }
ASM
  mov dx, SCLADDR
  mov cl, SCLMASKE
  mov ch, SCLINV
  mov al, SCLPort
  or al, cl
  not ch
  and al, ch
  mov SCLPort, al
  out dx, al
  mov cx,verzoegerung
@@9:
  loop @@9
 { SCLPort := (SCLPort OR SCLMASKE) AND NOT SCLINV;
   Port [SCLADDR] := SCLPort; }
end;

function SDAinPort : boolean;ASSEMBLER;  { Liest Datenbit von I2C-Bus }
ASM
  mov dx, SDAINADDR
  mov cl, SDAINMASKE
  mov ch, SDAININV
  in al, dx
  in al, dx
  and al, cl
  xor al, ch
  jz @@9
  mov al, 1
@@9:
{
  portc := (PORT[SDAINADDR] AND SDAINMASKE) XOR SDAININV;
  SDAin := (portc <> 0)
}
end;

{************    Einsprungadressen fr die Dekoder setzen    ************}
Var sdaladress, sdahadress, sclladress,sclhadress,sdainadress : Word;
Procedure I2CAdress;
BEGIN
  IF LPTDekoder THEN BEGIN
    sdaladress := OFS (SDALLPT);
    sdahadress := OFS (SDAHLPT);
    sclhadress := OFS (SCLHLPT);
    sclladress := OFS (SCLLLPT);
    sdainadress := OFS (sdainLPT);
  END
  ELSE IF ELVDekoder THEN BEGIN
    sdaladress := OFS (SDALELV);
    sdahadress := OFS (SDAHELV);
    sclhadress := OFS (SCLHELV);
    sclladress := OFS (SCLLELV);
    sdainadress := OFS (sdainELV);
  END
  ELSE IF CTDekoder THEN BEGIN
    sdaladress := OFS (SDALCT);
    sdahadress := OFS (SDAHCT);
    sclhadress := OFS (SCLHCT);
    sclladress := OFS (SCLLCT);
    sdainadress := OFS (sdainCT);
  END
  ELSE IF PortDekoder THEN BEGIN
    IF SDAADDR=SCLADDR THEN BEGIN
      sdaladress := OFS (SDALPort1);
      sdahadress := OFS (SDAHPort1);
      sclhadress := OFS (SCLHPort1);
      sclladress := OFS (SCLLPort1);
    END
    ELSE BEGIN
      sdaladress := OFS (SDALPort2);
      sdahadress := OFS (SDAHPort2);
      sclhadress := OFS (SCLHPort2);
      sclladress := OFS (SCLLPort2);
    END;
    sdainadress := OFS (sdainPort);
  END;
END;

{-------------------  Ab hier gemeinsame Routinen -----------------}

procedure sdal;ASSEMBLER;
ASM
  call [sdaladress]
end;

procedure sdah;ASSEMBLER;
ASM
  call sdahadress
end;

procedure sclh;ASSEMBLER;
ASM
  call sclhadress
end;

procedure scll;ASSEMBLER;
ASM
  call sclladress
end;

procedure sdain;ASSEMBLER;
ASM
  call sdainadress
end;

{---------------- allgemeine Routinen ---------------------}

procedure starti2c;  { Start fr I2C-Bus }
begin
  sdal;  scll;  { am Schlu: SDA=SCL=LOW }
end;

procedure stopi2c;   { Ende der bertragung }
begin
  sdal;  sclh;  sdah; sclh; { Am Schlu: SDA=SCL=HIGH }
end;

function sendbytei2c(daten:byte):boolean; { ohne Start/Stop }
{ bertrgt ein Datenbyte ber den I2C-Bus vom PC zum CCT-Baustein
  am Anfang mu SCL=L sein
  am Schlu ist SCL=L }
ASSEMBLER;
asm
  mov bh, 1
  mov bl, daten
@@1:
  shl bl,1
  jc @@2
  call sdal
  jmp @@3
@@2:
  call sdah
@@3:
  call sclh
  call scll
  shl bh, 1
  jne @@1
  call sdah
  call sclh
  call sdain
  xor al, 1
  push ax
  call scll
  pop ax
end;

function sendi2c(cctaddr:byte;i2canzahl:integer;
                 var i2cdaten:i2cdatentyp):boolean;
{ Sendet kompletten Datenblock ber I2C-Bus.
   Die Variable i2cdaten ist nur der Geschwindigkeit wegen als
   VAR declariert, da so nur ein Pointer statt des gesamten ARRAYs
   auf dem STACK landet ! (Wichtig fr die ASSEMBLER-Routinen
   speicher...CCT-Adresse fr Schreiben
  i2canzahl...Anzahl der zu bertragenen Datenbytes
   i2cdaten...Datenblock
   sendi2c:  true...alles ok
            false...ERROR }

{var
  x : word;
begin
  starti2c;
  if sendbytei2c(cctaddr) then BEGIN
    for x := 1 to i2canzahl do
      IF not sendbytei2c (i2cdaten[x]) THEN BEGIN
        scll; sendi2c := false; stopi2c; exit; {Fehler}
{      end;{for}
{    sendi2c:=true; {alles ok}
{  end
  else
    sendi2c:=false; {Fehler}
{  stopi2c;
end;
}
Assembler;
ASM
  push es
  call starti2c
  mov al, cctaddr
  push ax
  call sendbytei2c
  or al, al
  je @@2
    mov cx, i2canzahl
    les di, i2cdaten
@@1:
    mov al, es:[di]
    push cx
    push ax
    call sendbytei2c
    pop cx
    or al, al
    je @@2
    inc di
    loop @@1
@@2:
    push ax
    call stopi2c
    pop ax
    pop es
end;


function receivebytei2c(letzte:boolean): byte;
{ Empfngt ein Datenbyte ber den I2C-Bus vom CCT.
   daten...empfangenes Datenbyte
  letzte...Flag ob dieses Byte das letzte ist.
           Wenn ja dann invertiertes Quittierungsbit senden.
  am Anfang mu SCL=L sein
  am Schlu ist SCL=L        }
ASSEMBLER;
asm
  call sdah            { sdah fr Empfangen }
  call scll
  xor bx, bx
  inc bh
@@1:
  call sclh
  shl bl, 1
  call sdain
  or bl, al
  call scll
  shl bh ,1
  jne @@1
  or bh, letzte {Quittierungs-Bit senden}
  je @@2
  call sdah
  jmp @@3
@@2:
  call sdal
@@3:
  push bx
  call sclh
  call scll
  call sdah
  pop ax
end;

function receivei2c(speicher:byte;i2canzahl:integer;
                    i2cdaten:pointer):boolean;
{ Empfngt kompletten Datenblock ber I2C-Bus.
       addr...CCT-Adresse fr Lesen
  i2canzahl...Anzahl der zu empfangenden Datenbytes
   i2cdaten...empfangener Datenblock
   receivei2c:  true...alles ok
                false...ERROR }

{var x        : integer;
begin
  receivei2c := false;
  starti2c;
  if sendbytei2c(speicher) then begin
    sdah;
    for x := 1 to i2canzahl do
      i2cdaten[x] := receivebytei2c(x=i2canzahl);
    receivei2c:=true;
  end;
  stopi2c;
end;
}
ASSEMBLER;
ASM
  call starti2c
  mov al, speicher
  push ax
  call sendbytei2c    { Bausteinadresse }
  or al, al
  je @@3
    call sdah { lesen }
    mov cx, i2canzahl
    push es
    les di, i2cdaten
    dec cx
    je @@2
@@1:
    push cx
    push di
    push 0
    call receivebytei2c
    pop di
    pop cx
    mov es:[di], al
    inc di
    loop @@1
@@2:
    push di
    push 1
    call receivebytei2c
    pop di
    mov es:[di], al
    pop es
    mov ax, 1
@@3:
    push ax
    call stopi2c
    pop ax
end;


Function writeregister (registernr : Byte) : BOOLEAN;
Begin
  I2Cd[1] := registernr;
  I2Cd[2] := Reg[Registernr];
  Writeregister := sendI2C (CCTW, 2, I2Cd)
end;
