UNIT VTTexte;
{$D-,L-,R-,N-,E-,I+,V-,B-,S-,G+}

INTERFACE

USES dos, crt;

CONST
  MaxMeldeanzahl               =  25;
  MAXMenueTexte                = 350;

{ -----------  Fehlertexte  -----------}
  StrZuwenigSpeicher              =  2;
  StrRegisterinitialisierungfehler=  3;
  StrUngueltigeEingabe            =  4;
  StrUngueltigerDateiname         =  5;
  StrUngueltigeSenderbezeichnung  =  6;
  StrDruckerNichtBereit           =  7;
  StrSeitennummerVon100bis8FF     =  8;
  StrNur100Bis8FFgueltig          =  9;
  StrKannSetupNichtAbspeichern    = 10;
  StrMin3ZeichenEingeben          = 11;
  StrVerzeichnisNichtVorhanden    = 12;
  StrMindesten15Sekunden          = 13;
  StrRegisterSchreibfehler        = 14;
  StrUebertragungsfehler          = 15;
  StrFehlerBeimStatuslesen        = 16;
{ -----------  Meldetexte  -----------}
  StrWeiterMitEinerTaste          =  1;
  StrWertebereich                 =  2;
  StrKeineaktuelleSeitevorhanden  =  3;
  StrKeineEingabeBeimSchreiben    =  5;
  StrKeinSetup                    =  6;
  StrNeuinitialisierung           =  7;
  StrSendereinstellungpruefen     =  8;
  StrSenderNichtErkannt           =  9;
  StrKeineAuswahltabelleGefunden  = 10;
  StrVideotextdecoderNutztLPT1    = 11;
  StrAusdruckenNichtMoeglich      = 12;
  StrUeberwachungszeitIst0        = 13;
  StrPCZeitGesetzt                = 14;
  StrStatusstart                  = 15;


{ -----------  Menuetexte  -----------}
 { 0 muss freibleiben !!!}
 StrHauptmenue              =   1;

 StrSondermenue             =  20;


 StrSeitenmenue             =  40;

 StrSetupMenue              =  60;

 StrRegistermenue           =  80;
 StrEnterESC                =  93;
 StrUebernehmen             =  94;
 StrControl                 =  95;
 StrModus                   = 104;
 StrDatenEmpfangen          = 113;
 StrAnzeigeNormal           = 119;
 StrBlitzTitel              = 120;
 StrAnzeigefeld             = 129;
 StrSpeicherZumTV           = 138;
 StrRAMLesenSchreiben       = 141;

 StrCctMenue                = 150;
 StrWeiterMitESC            = 151;
 StrCctSpeicher_            = 152;
 StrAutomatik               = 153;
 StrGesperrt                = 154;

 StrSendereinstellung       = 155;

 StrEinstellungUebernehmen  = 165;

 StrVGAEinstellungen        = 170;
 StrHardwareMenue           = 177;
 StrToptextCctSpeicher      = 185;
 StrDekodermenue            = 186;
 StrPortEinstellungenMenue  = 220;
 StrSuchDauerMenue          = 195;
 StrDateiSchonVorhandenMenue= 200;
 StrAbbruchMitESC           = 201;
 StrVorhandeneSeiten        = 204;
 StrBeendenMitESC           = 205;

 StrMenueDruckenSpeichern   = 207;

 StrBereichsmenue           = 211;

 StrADIPTabelle             = 215;

 StrScanTOPTextSeite        = 217;
 StrScanTOPTEXT_neu         = 218;

 StrSeitenEinlesestand      = 250;
 StrProgInfo                = 265;
 StrDatenfehler             = 271;
 StrDateiName               = 273;
 StrProgEnde                = 275;
 StrStatusRegister          = 280;
 StrLoesche                 = 286;
 StrVideotextseiten         = 287;
 StrVerzeichnis             = 288;
 StrAufSeiteWarten          = 290;
 StrMaxUnterseiten          = 291;
 StrSeitenkontrolle         = 292;
 StrAutoSuchecct0           = 293;
 StrSeitenabstand           = 294;
 StrMeldeverzoegerung       = 296;
 StrIntervallinMinuten      = 297;
 StrADIPSortieren           = 298;
 StrMultitasking            = 299;

 StrSender                  = 300;
 StrSenderwechsel           = 301;
 StrSenderwechsel_          = 302;
 StrNeuerSender             = 303;
 StrSeite                   = 304;

 StrEinzelseiten            = 305;
 StrMehrfachseiten          = 306;
 StrHauptseiten             = 307;
 StrUnterseiten             = 308;
 StrToptextseiten           = 309;
 StrUnterseite              = 310;
 StrGeleseneUnterseiten     = 311;
 StrAktuelleUnterseite      = 312;
 StrSeitennummer            = 313;
 StrSeitenStatus            = 314;
 StrSeiteGeprueft           = 315;
 StrStartSeite              = 316;
 StrLetzteSeite             = 317;
 StrSpeichereSeite          = 318;
 StrDruckeSeite             = 319;

 StrAlteSeitenLoeschen      = 320;
 StrTOPTextLoeschen         = 321;
 StrSeitenueberwachung      = 322;
 StrScanDauer               = 323;
 StrSpeichern               = 324;
 StrDrucken                 = 325;
 StrNachfolgendenSeitenwirdgesucht = 326;
 StrSeitenichtEingetragen_Suchen = 327;
 StrTopTextInfoSelbstErstellen = 328;
 StrHoleSeite               = 329;
 StrDrucken_                = 330;
 StrNichtVorhanden          = 331;
 StrNurAuswahl              = 332;
 StrSeitenLoeschen          = 333;
 StrTopTextInfoLoeschen     = 335;
 StrCCTSpeicher             = 336;

 StrZeile                   = 338;
 StrSpalte                  = 339;
 StrAnzahl                  = 340;
 StrInhaltHex               = 341;
 StrGewuenschtenTextEingeben= 342;
 StrAdresse                 = 343;
 Strcctclock                = 344;

 StrCCTParity               = 346;

 StrAUS                     = 347;
 StrJa                      = 348;
 StrNein                    = 349;

 StrSdaAdresse              = 235;
 StrSdaMaske                = 236;
 StrSdaInvertiert           = 237;
 StrSdaInAdresse            = 238;
 StrSdaInMaske              = 239;
 StrSdaInInvertiert         = 240;
 StrSclAdresse              = 241;
 StrSclMaske                = 242;
 StrSclInvertiert           = 243;



TYPE
  T_Meldetexte = ARRAY [0.. MaxmeldeAnzahl] OF String[40];

VAR
  FehlerText    : T_Meldetexte;
  MeldeText    : T_Meldetexte;
  MenueText    : ARRAY [0..MaxMenueTexte] Of String[40];
  UpdateSperre : Boolean;
  Deutsch      : Boolean;
Procedure ErrorWindow (TextNummer:Word);
Procedure MeldeWindow (TextNummer:Word);
Procedure WaitWindow  (VAR WinNr:Word;WaitText,Waittext2:String);
Procedure SetMenue    (VAR MenueNr: Word; Spalten, Zeilen, Startpunkt : word);


IMPLEMENTATION

uses Windows;

{*************************************************************************}
{******************             ErrorWindow            *******************}
{*************************************************************************}
Procedure ErrorWindow;
Var i, WinNr : Word;
BEGIN
  i := LENGTH (FehlerText[TextNummer]) + 4;
  IF i < 25 THEN i := 25;
  openwindow((40-(i DIV 2)), 7,i,5,White,Red,links,doppelt,WinNr);
  titelWindow(WinNr,omitte,MainText[StrFehler]);
  titelWindow(WinNr,umitte,MainText[StrWeitermitTaste]);
  Writecwin(WinNr,2,FehlerText[TextNummer]);
  UPDATESPERRE := true;
  KillKey;
  If GetKey > CHR(0) THEN ;
  CloseWindow (WinNr);
  UPDATESperre := False;
END;

{*************************************************************************}
{******************             MeldeWindow            *******************}
{*************************************************************************}
Procedure MeldeWindow;
Var i, WinNr : Word;
BEGIN
  i := LENGTH (MeldeText[TextNummer]) + 4;
  IF i < 25 THEN i := 25;
  openwindow((40-(i DIV 2)), 11,i,5,White,blue,links,doppelt,WinNr);
  titelWindow(WinNr,omitte,MainText[StrMeldung]);
  titelWindow(WinNr,umitte,MainText[StrWeitermitTaste]);
  Writecwin(WinNr,2,MeldeText[TextNummer]);
  Updatesperre := true;
  KillKey;
  If GetKey > CHR(0) THEN ;
  CloseWindow (WinNr);
  UpdateSperre := False;
END;

{*************************************************************************}
{******************              WAITWindow            *******************}
{*************************************************************************}
{ Dieses Fenster mu vom von Ausserhalb geschlossen werden, ebenso die
  Window-UpdateSperre}
Procedure WaitWindow;
Var i,j : Word;
BEGIN
  i := LENGTH (WaitText) + 4;
  j := LENGTH (Waittext2) + 4;
  IF j > i THEN i := j;
  IF i < 25 THEN i := 25;
  openwindow((40-(i DIV 2)), 10,i,5,White,blue,links,doppelt,WinNr);
  titelWindow(WinNr,omitte,MainText[StrBitteWarten]);
  TitelWindow(WinNr,umitte,Waittext2);
  Writecwin(WinNr,2,WaitText);
END;

{*************************************************************************}
{******************               Setmenue             *******************}
{*************************************************************************}
Procedure SetMenue (VAR MenueNr: Word; Spalten, Zeilen, Startpunkt: word);
VAR
  i : Word;
BEGIN
  initmenue(MenueNr, Spalten, Zeilen,omitte,umitte,MenueText[Startpunkt],MenueText[Startpunkt+1]);
  For i := 1 TO Zeilen  DO
    setmenuetext(MenueNr,i,Menuetext[Startpunkt+1+i]);
END;

{*************************************************************************}
{******************             M  A  I  N             *******************}
{*************************************************************************}
CONST
  ErrorDatei = 'ERRTEXTE.TOP';
  MeldeDatei = 'MELDETXT.TOP';
  MenueDatei  = 'VTMENUE.TOP';

VAR
  Lauf,nr    : Word;
  ok, ok1    : Word;
  DateiName  : String;
  TextZeile  : String;
  TextDatei  : TEXT;

BEGIN
  For lauf := 0 TO MaxMeldeAnzahl DO BEGIN
    Fehlertext[Lauf] := '';
    Meldetext[Lauf] := '';
  END;
  For Lauf := 0 TO MaxMenuetexte DO
    Menuetext[Lauf] := '';
  For Lauf := 1 TO 3 DO BEGIN
    CASE Lauf OF
      1: Dateiname := ErrorDatei;
      2: Dateiname := MeldeDatei;
      3: Dateiname := MenueDatei;
    end;
    ASSIGN (TextDatei, DateiName);
{$I-}
    RESET (TextDatei);
{$I+}
    IF IOResult <> 0 THEN BEGIN
      CLRSCR;
      GOTOXY (10, 10);
      WRITELN ('!!!!!!!!!!!!!!!!!  Programmabbruch !!!!!!!!!!!!!!!');
      GOTOXY (10, 12);
      WRITELN ('Datei : ', Dateiname,' nicht gefunden ');
      HALT(1);
    END
    ELSE BEGIN
      WHILE NOT EOF (TextDatei) DO BEGIN
        ZerlegeText (TextDatei,TextZeile, Nr);
        CASE Lauf OF
          1: IF (Nr >=0) AND (Nr < MaxMeldeAnzahl) THEN FehlerText[Nr] := TextZeile;
          2: IF (Nr >=0) AND (Nr < MaxMeldeAnzahl) THEN MeldeText[Nr] := TextZeile;
          3: IF (Nr >=0) AND (Nr < MaxMenueTexte) THEN MenueText[Nr] := TextZeile;
        END;
      end;
    END;
  END;
  Updatesperre := false;
  Deutsch      := True;
END.