#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
		/* Mauspfeil-Konstanten */
#include <X11/keysym.h>
		/* Tastatur-Konstanten */
#include <signal.h>
		/* wegen "Timer-Message" */
#include <X11/Xatom.h>
		/* wegen XA_CUT_BUFFER0 */
#include <errno.h>
#define FALSE 0
		/* Ich mag Pascal mehr */
#define TRUE 1
typedef unsigned long dword;
typedef unsigned short word;
typedef unsigned char byte;	/* Geordnete Verhltnisse im */
typedef byte bool;		/* C-Datentypen-Dschungel */

/********************************/
/* Internationale Stringtabelle */
/********************************/
char *sApp[]={
 "Teletext",
 "Videotext"};
char *sDisplayAbort[]={
 "VTX: Fatal: Cannot open display `%s'!\n",
 "VTX Abbruch: Display '%s' kann nicht geffnet werden!\n"};
char *sHelp[]={
"Teletext viever for X window system X11 by haftmann#software\n\
Usage: vtx [options] filename[.vt]\n\
Available options:\n\
-d displayame\tOutput display (i.e. \"-d oasis.etc:0\")\n\
-l{d|f}\tChoose language {German|(French not installed)}\n\
-p xxx/yy\toutput page/subpage as plain text to stdout without starting X\n\
-m xxx\tUse this display flags (see README)\n\
-f xx\tUse this font number (see README)\n\
-n\tSuppress all flashing characters and rolling subpages\n\
-s xx\tUse this search mode (see README)\n\
-v xxx\tVolume of XBell (-100..0..100)\n\
-h\tThis help\n",

"Videotext-Betrachter fr X Window System X11 von haftmann#software\n\
Anwendung: vtx [optionen] dateiname[.vt]\n\
Mgliche Optionen:\n\
-d displayname\tAusgabe-Display (z.B. \"-d toaster.csn:0\")\n\
-l{d|f}\tSprache auswhlen {deutsch|(franzsisch noch nicht installiert)}\n\
-p xxx/yy\tAusgabe des Inhalts von Seite xxx Unterseite yy als Text; ohne X\n\
-m xxx\tDiese Anzeige-Flags verwenden (s. LIESMICH)\n\
-f xx\tDiese Zeichensatz-Nummer verwenden (s. LIESMICH)\n\
-n\tKeinerlei blinkende Anzeige und rollende Unterseiten\n\
-s xx\tDiesen Suchmodus benutzen (s. LIESMICH)\n\
-v xxx\tLautstrke von XBell (-100..0..100) bei falschen Tasten\n\
-h\tDiese Hilfe\n"};

char *sGotoPage[]={
 "Go to page number:",
 "Gehe zu Seite Nummer:"};
char *sNoPage[]={
 "Page %hX doesn't exist!",
 "Seite %hX existiert nicht!"};
char *sGotoSubp[]={
 "Go to subpage number:",
 "Gehe zu Unterseite Nummer:"};
char *sNoSubp[]={
 "Subpage %04hX doesn't exist!",
 "Unterseite %04hX existiert nicht!"};
char *sOnlyOneSubp[]={
 "This page has only one subpage!",
 "Diese Seite hat nur eine Unterseite!"};
char *sNoBack[]={
 "\"Back\" impossible!",
 "Rckschritt nicht mglich!"};
char *sNoMatch[]={
 "No (more) matching pages!",
 "Keine (weiteren) bereinstimmungen!"};
char *sOpenFile[]={
 "Filename:",
 "Dateiname:"};
char *sChooseFont[]={
 "Choose font:",
 "Zeichensatz:"};
char *sFileError[]={
 "Error reading file %1.10s, code %hd!",
 "\"%1.10s\"-Dateiladefehler, Code %hd"};
char *sWriteError[]={
 "Error writing file %1.10s, code %hd!",
 "Kann nicht speichern \"%1.6s\", Code %hd"};
char *sSuchString[]={
 "Seach pattern:",
 "Suchkette:"};
char *sPageInfo[]={
 "CBits=%hXh, PageFont=%s",
 "CBits=%04hXh, Zeichens.=%s"};
char *sFontName[][16]={
 "auto detect", "*German", "*English", "*Scandinavian",
 "Polish", "Czech/Slovak", "*Italian", "*French",
 "*Spanish", "Icelandic", "Hungarian", "Turkish",
 " reserved", " reserved", "Cyrillic", "Arabic",

 "automatisch", "*deutsch", "*englisch", "*skandinavisch",
 "polnisch", "tschechoslowakisch", "*italienisch", "*franzsisch",
 "*spanisch", "islndisch", "ungarisch", "trkisch",
 " reserviert", " reserviert", "kyrillisch", "arabisch"};
/*^--------------^---Trick-Leerzeichen! Bitte stehen lassen! */

char *sHelpPage[]={"\
\0\0\0\0\0\0\0\7         Help page              \
\4\x1d\7   *** navigate ***                  \
\6o F4                \7open a file...    \
\6g Home              \7page 100          \
\6j PgDn + CurDn      \7next page         \
\6k PgUp - CurUp      \7previous page     \
\6l CurRight Tabulator\7next subpage      \
\6h CurLeft           \7previous subpage  \
\6  Spacebar          \7next subpage or pg\
\6q ^C                \7quit VTX          \
\6y F1                \7this help         \
\6/ F2                \7find...           \
\6n F3                \7find next         \
\6p Left mouse button \7go to page xxx    \
\6s                   \7go to subpage xxxx\
\6b BkSp RightButton  \7go back           \
\6f                   \7go forward        \
\4\x1d\7   *** render options ***            \
\2Q\7toggle QUIZ (on remote control)      \
\2D\7toggle displaying DoubleHeight       \
\2M\7toggle mixed mode                    \
\2I\7toggle invers rendering              \
\2W\7toggle black/white or color display  \
\2B\7toggle debug display (control codes) \
\2F\7choose font... (then use cursor keys)\
","\
\0\0\0\0\0\x40\0\7         Hilfeseite             \
\4\x1d\7   *** Navigation ***                \
\6o F4                \7Datei |ffnen...   \
\6g Pos1              \7Seite 100         \
\6j BildAb  + PfeilAb \7N{chste Seite     \
\6k BildAuf - PfeilAuf\7Vorherige Seite   \
\6l PfeilRechts Tab.  \7N{chste Unterseite\
\6h PfeilLinks        \7Vorherige Unters. \
\6  Leertaste         \7N{chste Unters.+S.\
\6q F10 ^C            \7VTX beenden       \
\6y F1                \7Diese Hilfe       \
\6/ F2                \7Suchen...         \
\6n F3                \7Weitersuchen      \
\6p Linke Maustaste   \7Gehe zu Seite xxx \
\6s                   \7Gehe zu Unterseite\
\6b Rechte Maustaste  \7Gehe zur}ck       \
\6f                   \7Gehe vorw{rts     \
\4\x1d\7   *** Anzeige-Optionen ***          \
\2Q\7Quiz-Taste ein/aus                   \
\2D\7Anzeige von doppelt hohen Zeichen e/a\
\2M\7Mix-Betrieb ein/aus                  \
\2I\7Invers-Darstellung                   \
\2W\7Schwarz/Wei~- oder farbige Darstellg.\
\2B\7Debug-Anzeige (Steuercodes)          \
\2F\7Font ausw{hlen (benutze Cursortasten)\
"};


char *sPagedefault[]={"\
\0\0\0\0\0\0\0\7   Welcome Page   \5h_s \00700:00:00\
 pppppppppppppppppppppppppppppppppppp  \
   \
|||||||||||||||||| \
 \
 \
######## \
         \
         \
         \
         \
\7                                       \
\7  Teletext viewer for X window system  \
\7         by haftmann_software          \
\7                                       \
               \
                 \
                     \
                     \
                       \
                         \
                           \
              //////////               \
                             \
\6 Press F1 for help or F4 to open a file\
","\
\0\0\0\0\0\x40\0\7 Begr}~ungsseite  \5h#s \00700:00:00\
 pppppppppppppppppppppppppppppppppppp  \
   \
|||||||||||||||||| \
 \
 \
######## \
         \
         \
         \
         \
\7                                       \
\7   Videotext-Betrachter f}r X-Windows  \
\7         von haftmann#software         \
\7                                       \
               \
                 \
                     \
                     \
                       \
                         \
                           \
              //////////               \
                             \
\6    F1 f}r Hilfe oder F4 zum \\ffnen    \
"};

int country=0;			/* Default: englisch */
int volume=0;
/******************/
/* Display ffnen */
/******************/
Display *display;		/* Zeiger auf Display-Struktur */
Screen *screen;
Colormap cmap;

void InitDisplay(char *DName){
 display=XOpenDisplay(DName);
 if (display==NULL){
  fprintf(stderr,sDisplayAbort[country],XDisplayName(DName));
  exit(1);
 }
 screen=DefaultScreenOfDisplay(display);
 cmap=DefaultColormap(display,DefaultScreen(display));
}

/**********************************************/
/* Hauptfenster erstellen, Ressourcen belegen */
/**********************************************/
#define FONTW 8
#define FONTH 10
#define GetLines(x) ( ((x) & f1)? 1: (((x) & f25)? 25 : 24) )
#define GetCols(x) ( ((x) & f41)? 41 : 40 )
Window window;
GC MainGC,XorGC;
XContext Linklist;
#include "vticon.h"
Pixmap icon;
Cursor idc_arrow,idc_hand,idc_wait;
dword Farbe[9];		/* globale Pixelwerte */

typedef struct{
 byte R,G,B;
} tRGBTriple;

tRGBTriple RGBWerte[16];	/* Farbwerte fr Abspeicherung als GIF */

struct{
Pixmap hbm;
bool valid;
} Pixmaps[2]={None,FALSE,None,FALSE};

short BMIdx=-1;			/* Keine Bitmap */


void SetWindowTitle(char *FileName){
 char CatBuf[256];
 strcpy(CatBuf,sApp[country]);	/* Neuen Fenstertitel aufbauen */
 if (FileName){			/* Nur wenn einer vorhanden dann anhngen */
  strcat(CatBuf,": ");
  strcat(CatBuf,FileName);
 }
 XSetStandardProperties(display,window,CatBuf,CatBuf,icon,NULL,0,NULL);
}

void GetColors(bool invert){
 XColor TempColor,ExactColor;
 static char *Farbname[9]={
 "black","red","green","yellow","blue","magenta","cyan","white","gray"};
 static char *InvFarbe[9]={
 "white","red","green4","yellow4","blue","magenta4","cyan4","black","gray50"};
 int i; char *s;
 for (i=0; i<9; i++){
  s=invert? InvFarbe[i] : Farbname[i];
  if (!XAllocNamedColor(display,cmap,s,&TempColor,&ExactColor))
   fprintf(stderr,"VTX Warning: Error allocating color '%s'.\n",s);
  RGBWerte[i].R=ExactColor.red >>8;	/* Farben fr den GIF-Packer ablegen */
  RGBWerte[i].G=ExactColor.green >>8;
  RGBWerte[i].B=ExactColor.blue >>8;
  Farbe[i]=TempColor.pixel;	/* Pixelwert fr BitBlt-Operationen ablegen */
 }
}

void CreateMainWindow(){
 XSizeHints xsh;
 XSetWindowAttributes xswa;
 XGCValues xgcv;

/* Fenster erzeugen */
/* printf("Hier vorbei: Fenster erstellen\n");*/
 xsh.flags=PSize|PMaxSize|PMinSize;
 xsh.min_width=xsh.max_width=xsh.width=41*FONTW;
 xsh.min_height=xsh.max_height=xsh.height=25*FONTH;

 xswa.cursor=idc_arrow=XCreateFontCursor(display,XC_top_left_arrow);
 xswa.border_pixel = BlackPixelOfScreen(screen);
 xswa.background_pixmap=None;
 xswa.event_mask = ButtonPressMask|ButtonReleaseMask|Button1MotionMask|
  KeyPressMask|ExposureMask;

 window=XCreateWindow(display,RootWindowOfScreen(screen),
 0,0,xsh.width,xsh.height,1,
 CopyFromParent, CopyFromParent, CopyFromParent,
 CWBorderPixel|CWCursor|CWBackPixmap|CWEventMask,&xswa);

/* Icon erzeugen und Fenster-Name geben */
 icon=XCreateBitmapFromData(display,RootWindowOfScreen(screen),
 vticon, vticon_w, vticon_h);

 XSetStandardProperties(display,window,sApp[country],sApp[country],
 icon,NULL,0,&xsh);
 XMapWindow(display,window);

/* Fenster-GC dauerhaft holen */
 xgcv.subwindow_mode=IncludeInferiors;
 xgcv.graphics_exposures=FALSE;
 xgcv.foreground=WhitePixelOfScreen(screen);
 xgcv.background=BlackPixelOfScreen(screen);
 MainGC=XCreateGC(display,RootWindowOfScreen(screen),
 GCForeground|GCBackground|GCSubwindowMode|GCGraphicsExposures,&xgcv);

/* XorGC dauerhaft belegen */
 xgcv.function=GXxor;
 xgcv.foreground^=BlackPixelOfScreen(screen);
 XorGC=XCreateGC(display,RootWindowOfScreen(screen),
  GCFunction|GCForeground|GCBackground|GCSubwindowMode|
  GCGraphicsExposures,&xgcv);

/* Weitere Ressourcen belegen */
 idc_hand=XCreateFontCursor(display,XC_hand2);
 idc_wait=XCreateFontCursor(display,XC_watch);
 Linklist=XUniqueContext();
 Pixmaps[0].hbm=XCreatePixmap(display,window,
  41*FONTW,25*FONTH,DefaultDepthOfScreen(screen));
 Pixmaps[1].hbm=XCreatePixmap(display,RootWindowOfScreen(screen),
  41*FONTW,25*FONTH,DefaultDepthOfScreen(screen));
 GetColors(FALSE);
/* printf("WeissPixel=%d, SchwarzPixel=%d.\n",
  WhitePixelOfScreen(screen),
  BlackPixelOfScreen(screen));*/
}

/*****************************/
/* Videotext-Font "hochladen"*/
/*****************************/
Pixmap vtfont1=None,vtfont2=None;	/* Die beiden Handles auf die Fonts */
#define ZEICHEN (512+128)
#include "vtfont.h"	/* Die binren Daten */

void FontUpload(){
 byte *Puffer,*Zeiger1,*Zeiger2;
 int i;
 if (vtfont1!=None) {
  XFreePixmap(display,vtfont1); vtfont1=None;
 }
 if (vtfont2!=None) {
  XFreePixmap(display,vtfont2); vtfont2=None;
 }
 vtfont1=XCreateBitmapFromData(display,window,vtfont,FONTW,ZEICHEN*FONTH);
/* Doppelt hohe Zeichen generieren */
 Zeiger1=vtfont;
 Zeiger2=Puffer=(byte *) calloc(FONTH*2,ZEICHEN);
 for (i=0; i<ZEICHEN*FONTH; i++){
  *Zeiger2++ = *Zeiger1;
  *Zeiger2++ = *Zeiger1++;
 }
 vtfont2=XCreateBitmapFromData(display,window,Puffer,FONTW,ZEICHEN*FONTH*2);
 free(Puffer);
}

/* Bedeutung der C-Bits
C4  - Lschen einer Seite
C5  - Schlagzeilen
C6  - Untertitel
C7  - Unterdrcken der Kopfzeile
C8  - Texterneuerung
C9  - Unterbrochene Sequenz
C10 - Unterdrckung der Darstellung
C11 - Serielle Magazinfolge

C12 .. C14
000 - Englisch(0)
001 - Deutsch(4)
010 - Schwedisch/Finnisch(2)
011 - Italienisch(6)
100 - Belgisch/Franzsisch(1)
101 - Portugisisch/Spanisch(5)
110 - dynamische Zeichenzuordnung(3)
111 - reserviert(7)
Ersetzkette  40 60 7B 23 24 ** ** ** 7C 7D 7E 5B 5C 5D 5E 5F */
/****************************/
/* Videotext-Seite zeichnen */
/****************************/
#define bit 1 <<
#define fQuiz (bit 0)
#define fBlink (bit 1)
#define fDblH (bit 2)
#define fMix (bit 3)
#define fInvers (bit 4)
#define fBunt (bit 5)
#define fDebug (bit 6)
#define fRoll (bit 7)
#define fDblSize (bit 8)
#define f41 (bit 9)
#define f25 (bit 10)
#define f1 (bit 11)
#define fBBar (bit 12)
#define fNoX (bit 13)

#define fGraf (bit 8)
#define fHold (bit 9)
#define fSep (bit 10)
#define fShift (bit 11)
#define fLatin (bit 12)

typedef union{
 dword L;
 struct{
  word Page,Subp;
 } W;
} tIdx;

/*#define IdxL(x) (*(long *)&(x))*/

typedef byte VTLine[40];

typedef union{
 dword L;
 struct{
  word Page,Subp;
  word CBits;
  byte errors;
 } W;
} tHeader;


typedef struct{
 VTLine L[25];		/* 25*40=1000 Bytes Text */
 byte Page10,Page1,Subp1000,Subp100,Subp10,Subp1,Page100,C1,C2,PBLF;
/* struct tHSFTrail{	/* haftmann#software und FifiSoft Schwanz */
 byte Acqisitor;	/* Wer eingelesen hat */
 byte MaxSubp;		/* nur aus der Angabe xx/yy auf der Seite entnommen */
 dword MsDosTime;	/* Einlesezeitpunkt, zeitzonenabhngig */
 word CRC;		/* Prfsumme ber diese Seite fr Fehlerkorrektur */
 word Mirror;		/* Adresse einer Spiegelseite whrend des Einlesens */
 long UnixTime;	/* Einlesezeitpunkt, Universal Time */
/* } E;			/* 14 Bytes freie Zusatz-Info (wie oben definiert) */
} tTrail;

typedef union{
 byte B[1024];		/* 1 Kilobyte */
 VTLine L[25];		/* 25 Zeilen mit je 40 Zeichen */
 tTrail T;		/* 25 Zeilen und der Trailer */
 tHeader H;		/* 7 Bytes kompaktierte SAA-Info */
 char TopLeft[7];	/* Zum berschreiben des Headers, Nicht nullterminiert! */
} tPage;


static tHeader Header;
tPage Page;		/* eine passende Variable definieren */

static char Ansitab[]={
' ','!','\"','#','$','%','&','\'','(',')','*','+',',','-','.','/',
'0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?',
0xa7,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z',0xc4,0xd6,0xdc,'^','_',
0xb0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z',0xe4,0xf6,0xfc,0xdf,' ',
'@','-',0xbc,0xa3,'$',' ',' ',' ',0xa6,0xbe,0xad,0xab,0xbd,0xbb,'^','#',
0xc9,0xe9,0xe4,'#',0xa4,' ',' ',' ',0xf6,0xe5,0xfc,0xc4,0xd6,0xc5,0xdc,'_',
0x20,0x20,0x20,0x20,0x20,0x20,0x20,'l',0x20,0x20,'S','L',0x20,0x20,0x20,0x20,
'c',0xe9,0xe1,'#',0xf9,0x20,0x20,0x20,0xe8,0xfa,'s','t','z',0xff,0xed,'r',
0xe9,0xf9,0xe0,0xa3,'$',0xe3,0xf5,0xb7,0xf2,0xe8,0xec,0xb0,0xe7,0xbb,'^','#',
0xe0,0xe8,0xe2,0xe9,0xef,0xc3,0xd5,0xc7,0xf4,0xfb,0xe7,0xeb,0xea,0xf9,0xee,'#',
0xa1,0xbf,0xfc,0xe7,'$',0xaa,0xba,0xd1,0xf1,0xe8,0xe0,0xe1,0xe9,0xed,0xf3,0xfa,
0xc1,0xc0,0xc8,0xcd,0xcf,0xd3,0xd2,0xda,0xe6,0xc6,'d','D',0xf8,0xd8,0xfe,0xee};

void DrawBWAnsiChar(byte col,byte line,char code){
 char *Such;
 Such=(char *)strchr(Ansitab,code);	/* Ersatz gefunden? */
 if (Such) code=(char)(Such-Ansitab)+0x20;	/* umwandeln in VT-Font-Zeichen (?) */
 XCopyPlane(display,vtfont1,window,MainGC,
  0,(code+128)*FONTH,FONTW,FONTH,
  (short)col*FONTW,(short)line*FONTH,1);
}
static byte LandMap[8]={2,7,3,0,1,8,6,0};


short Translate(byte c,word FlagReg,word Font){
 byte *ChChar;
 short code;
 static byte ErsetzKette[16]={
  0x40, 0x60, 0x7B, 0x23, 0x24, 0x40, 0x40, 0x40,
  0x7C, 0x7D, 0x7E, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F};

 code=(short)c;	/* Standardfall */
 if (FlagReg & (fBlink|fQuiz)){
  return 32;		/* Leerzeichen ausgeben */
 }
 if (FlagReg & fGraf){
  if ((code>=32) && (code<64)) code=(short)c-128-32;
  if ((code>=96) && (code<128)) code=(short)c-128-96+32;
			/* Negative Codes fr Grafiksymbole */
  if (FlagReg & fSep) code+=64;	/* Separierte Grafik */
  return code;
 }
 if ((Font>=2) && (Font<14)){
			/* 12 = reserve I, 13 = reserve II */
  ChChar=(byte *)memchr(ErsetzKette,c,16);	/* in Ersetzkette suchen */
  if (ChChar){		/* Gefunden ? */
   code=((Font+6) <<4) + (word)(ChChar-ErsetzKette);
/*   printf("Zeichen-Ersetzung! Zeichen-Nummer %hu, neuer Code %hd\n",
    (word)(ChChar-ErsetzKette),code);*/
   return code;
			/* Code im Bereich 80..13F */
  }
  return code;
 }
 if ((Font>=14) && (Font<16) && !(FlagReg & fLatin)){
  return (Font-14)*96+0x140+(c-32);
			/* Kyrillisch, arabisch im Bereich 140..1FF */
 }
 return code;
}


void DrawVT(Pixmap drw, word Flags, word Font){
 GC gc;		/* GC fr Vorder- und Hintergrundfarbe */
 XGCValues xgcv;
 word FlagReg;
 byte lines,line,col;
 auto byte vfarbe=7,vfarbc=7,hfarbe=0,hfarbc=0;	/* Farbbytes und Caches */
 auto bool Mixc=FALSE;
 bool LineContainsDblH;
 byte OldByte,CurByte;

 void WriteChar(short code){
/* Folgender Code vermeidet unntige XSet{Fore|Back}ground's */
  if (Flags & fBunt){			/* Nur wenn farbig! */
   if (FlagReg & fMix){			/* fMix gesetzt? */
    if (!Mixc){				/* fMix verndert? */
     Mixc=TRUE;
     XSetBackground(display,gc,Farbe[8]);	/* Transparente Farbe */
/*     printf("Hier vorbei [8]\n");*/
    }
   }else{				/* fMix gelscht? */
    if ((hfarbe != hfarbc) || (Mixc)){	/* Neue HFarbe oder Mix war gesetzt? */
     Mixc=FALSE;
     XSetBackground(display,gc,Farbe[hfarbc=hfarbe]); /* Farbe setzen */
    }
   }
   if (vfarbe != vfarbc)		/* Vordergrund gendert? */
    XSetForeground(display,gc,Farbe[vfarbc=vfarbe]); /* Farbe setzen */
  }
/* Jetzt das Zeichen ausgeben */
  if (FlagReg & fDblH){
   XCopyPlane(display,vtfont2,drw,gc,
    0,(code+128)*FONTH*2,FONTW,FONTH*2,
    col*FONTW,line*FONTH,1);
  }else{
   XCopyPlane(display,vtfont1,drw,gc,
    0,(code+128)*FONTH,FONTW,FONTH,
    col*FONTW,line*FONTH,1);
   if (LineContainsDblH)
    XCopyPlane(display,vtfont1,drw,gc,
     0,(32+128)*FONTH,FONTW,FONTH,
     col*FONTW,(line+1)*FONTH,1);
  }
 } /* Prozedur WriteChar */

 void WriteCharTranslate(byte c){
  WriteChar(Translate(c,FlagReg,Font));	/* Jetzt ausgeben */
 }

 bool CanDblH(){	/* Doppelte Zeichenhhe erlaubt? */
  return((line>0) && (line<23) && (Flags & fDblH));
 }

 void SetMix(){
  if ((Flags & fMix) || (Header.W.CBits & 0x60))
   FlagReg|= fMix;		/* InBox aus, also Mix ein */
 }

/* Gertekontexte erstellen */
/* hgc=XCreateGC(display,drw,0,NULL);*/
 xgcv.subwindow_mode=IncludeInferiors;
 xgcv.graphics_exposures=FALSE;
 xgcv.foreground=Farbe[vfarbe];
 xgcv.background=Farbe[hfarbe];
 gc=XCreateGC(display,drw,
 GCForeground|GCBackground|GCSubwindowMode|GCGraphicsExposures,&xgcv);
/* Land-Variable aufbereiten */
 if (Font==0)
  Font=LandMap[(Header.W.CBits >> 12) & 7];
			/* Wenn default(Auto-detect) dann aus den C-Bits*/

 lines=GetLines(Flags);
/* mit Schleifen loslegen */
 LineContainsDblH=FALSE;
 for (line=0; line<lines; line++){
  if (LineContainsDblH){	/* hier: vorhergehende Linie! */
   LineContainsDblH=FALSE;	/* nichts weiter tun, dann nchste Zeile */
  }else{
   LineContainsDblH=CanDblH() && memchr(Page.L[line],13,40);
			/* Stellen; 13 ist Code fr DblH */

   FlagReg=0;
   SetMix();      	/* auf Null oder Mixbetrieb setzen */
   hfarbe=0;		/* Hintergrundfarbe */
   vfarbe=7;
   OldByte=32;		/* auch das vorhergehende Byte zu Space machen */
   for(col=0; col<40; col++){
    CurByte=Page.L[line][col];	/* aus der Seite holen */
/* Sofort wirksame Schalter auswerten *//* Ein Zeichen ausgeben */
    switch (CurByte) {
     case 28:
      hfarbe=0;
      break;
     case 29:
      hfarbe=vfarbe;
      break;
    }
    if ((CurByte<0x20) && ((Flags & fDebug)==0)){
     if ((FlagReg & fHold) && (FlagReg & fGraf) &&
	/* HoldGrafix und GrafikFlag */
      ((OldByte&0xbf)>=0x20) && ((OldByte&0xbf)<0x40)){
	/* Zeichen mit Codes 0x20..0x3f sowie 0x60..0x7f */
      WriteCharTranslate(OldByte);
     }else{
      WriteCharTranslate(32);	/* Leerzeichen */
/*       if ((FlagReg & fHold) && (FlagReg & fGraf))
	printf("Haltegrafik+Grafikflag, aber OldByte=%hX und geANDed=%hX\n",
	 OldByte,OldByte&0xbf);*/
     };				/* Auf jeden Fall OldByte behalten! */
    }else{
     WriteCharTranslate(CurByte);
     OldByte=CurByte;
    }
/* Nachher wirksame Schalter */
    if (CurByte<0x20)
     FlagReg&= ~fQuiz;		/* Secret aus */
    switch (CurByte){
     case 0:
     case 1:
     case 2:
     case 3:
     case 4:
     case 5:
     case 6:
     case 7:
      FlagReg&= ~fGraf;		/* Grafikflag aus */
      vfarbe=CurByte;
      break;
     case 8:
      if (!(Flags & fBlink))	/* wenn "blinkende Zeichen AUS" */
       FlagReg|= fBlink;	/* Blinken ein */
      break;
     case 9:
      FlagReg&= ~fBlink;	/* Blinken aus */
      break;
     case 10:
      SetMix();
      break;
     case 11:
      FlagReg&= ~fMix;		/* InBox ein */
      break;
     case 12:
      FlagReg&= ~fDblH;		/* DoubleHeigth aus */
      break;
     case 13:
      if (CanDblH())		/* wenn nicht verboten */
       FlagReg|= fDblH;		/* DoubleHeigth ein */
      break;
     case 14:
      FlagReg&= ~fShift;	/* Shift aus (spter verwendet) */
      break;
     case 15:
      FlagReg|= fShift;		/* Shift ein (spter verwendet) */
      break;
     case 16:
     case 17:
     case 18:
     case 19:
     case 20:
     case 21:
     case 22:
     case 23:
      FlagReg|= fGraf;		/* Grafikflag ein */
      vfarbe=(CurByte & 7);
      break;
     case 24:
      if (!(Flags & fQuiz))	/* wenn "Quiz-Zeichen AUS" */
       FlagReg|= fQuiz;		/* Secret ein */
      break;
     case 25:
      FlagReg&= ~fSep;		/* separated aus */
      break;
     case 26:
      FlagReg|= fSep;		/* separated ein */
      break;
     case 27:
      FlagReg^= fLatin;		/* Sprachumschaltung Lateinisch */
      break;
     case 30:
      FlagReg|= fHold;		/* holdgrafix ein */
      break;
     case 31:
      FlagReg&= ~fHold;		/* holdgrafix aus */
      break;
    }
   } /* 1 Zeile */
   if (Flags & f41){
    hfarbe=0;			/* schwarz */
    WriteCharTranslate(32);	/* noch ein Space dran */
   }
  } /* if-else */
 } /* for */
/* Kontexte auflsen */
 XFreeGC(display,gc);
}

void InvokeExpose(){
 XClearArea(display,window,0,0,0,0,TRUE);
}

void Page2Asc(char *dest, word Flags, word Font,
 short left, short top, short right, short bottom){
 word FlagReg;
 byte lines,line,col;
 bool LineContainsDblH;
 byte CurByte;

 void WriteChar(short code){
/* Jetzt das Zeichen ausgeben */
  if ((col>=left) && (col<=right) &&
   (line>=top) && (line<=bottom)){
   if ((code>=32) && (code<256)){
    *dest++=Ansitab[code-32];	/* nach ANSI gewandeltes Zeichen */
   }else{
    *dest++=' ';		/* sonst Leerzeichen */
   }
   if (col==right){
    *dest++='\n';		/* Newline dranhngen */
   }
  }
 } /* Prozedur WriteChar */

 void WriteCharTranslate(byte c){
  WriteChar(Translate(c,FlagReg,Font));	/* Jetzt ausgeben */
 }

 bool CanDblH(){	/* Doppelte Zeichenhhe erlaubt? */
  return((line>0) && (line<23) && (Flags & fDblH));
 }

/* Land-Variable aufbereiten */
 if (Font==0)
  Font=LandMap[(Header.W.CBits >> 12) & 7];
			/* Wenn default(Auto-detect) dann aus den C-Bits*/

 lines=GetLines(Flags);
/* mit Schleifen loslegen */
 LineContainsDblH=FALSE;
 for (line=0; line<lines; line++){
  if (LineContainsDblH){	/* hier: vorhergehende Linie! */
   LineContainsDblH=FALSE;	/* nichts weiter tun, dann nchste Zeile */
  }else{

   FlagReg=0;
   for(col=0; col<40; col++){
    CurByte=Page.L[line][col];	/* aus der Seite holen */
/* Ein Zeichen ausgeben */
    if (CurByte<0x20){
     WriteCharTranslate(32);	/* Leerzeichen */
    }else{
     WriteCharTranslate(CurByte);
    }
/* Nachher wirksame Schalter */
    if (CurByte<0x20)
     FlagReg&= ~fQuiz;		/* Secret aus */
    switch (CurByte){
     case 0:
     case 1:
     case 2:
     case 3:
     case 4:
     case 5:
     case 6:
     case 7:
      FlagReg&= ~fGraf;		/* Grafikflag aus */
      break;
     case 12:
      FlagReg&= ~fDblH;		/* DoubleHeigth aus */
      break;
     case 13:
      if (CanDblH()){		/* wenn nicht verboten */
       FlagReg|= fDblH;		/* DoubleHeigth ein */
       LineContainsDblH=TRUE;
      }
      break;
     case 16:
     case 17:
     case 18:
     case 19:
     case 20:
     case 21:
     case 22:
     case 23:
      FlagReg|= fGraf;		/* Grafikflag ein */
      break;
     case 24:
      if (!(Flags & fQuiz))	/* wenn "Quiz-Zeichen AUS" */
       FlagReg|= fQuiz;		/* Secret ein */
      break;
     case 27:
      FlagReg^= fLatin;		/* Sprachumschaltung Lateinisch */
      break;
    }
   } /* 1 Zeile */
   if (Flags & f41){
    WriteCharTranslate(32);	/* noch ein Space dran */
   }
  } /* if-else */
 } /* for */
 *dest++='\0';			/* Abschlu-Null dranbammeln */
}

/* Such-Definitionen */
#define BACKWARD (bit 0)
#define NOCASESENS (bit 1)
#define NOHIGHCHARS (bit 2)
#define USEREGEXP (bit 3)
/* Umkodierungstabelle fr "hohe ASCIIs" */
static char AnsiUmcodTab[64]={
'A','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I',
'D','N','O','O','O','O','O',0xd7,'O','U','U','U','U','Y','P','s',
'a','a','a','a','a','a','a','c','e','e','e','e','i','i','i','i',
'd','n','o','o','o','o','o',0xf7,'o','u','u','u','u','y','p','y'};

void PrepareString(char *Str, word How){
 if (Str){			/* Wenn nicht NULL */
  for(;*Str;Str++){		/* String bis zum \0-Zeichen parsen */
   if ((How & NOHIGHCHARS) && ((byte)*Str >0xc0))
    *Str=AnsiUmcodTab[*Str-0xc0];
   if (How & NOCASESENS)
    *Str=toupper(*Str);
  }
 }
}

/****************************/
/* Datei browsen nach Index */
/****************************/

#ifdef motorola
void byteswap(short *i){
 byte t;
 t=((byte *)i)[0];
 ((byte *)i)[0]=((byte *)i)[1];
 ((byte *)i)[1]=t;
}
void longswap(long *i){
 byte t;
 t=((byte *)i)[0];
 ((byte *)i)[0]=((byte *)i)[3];
 ((byte *)i)[3]=t;
 t=((byte *)i)[1];
 ((byte *)i)[1]=((byte *)i)[2];
 ((byte *)i)[2]=t;
}
#endif

/* #define INDIZES 2048		/* Maximale Dateigre in Kilobytes */

#ifdef motorola
#define MAGIC 0xd6d4e8e6	/* ('VThf'^0x80808080) */
#define MAGIC_HS 0xd6d4e8f3	/* ('VThs'^0x80808080) */
#else
#define MAGIC 0xe6e8d4d6	/* 'VThf' mit gesetzten Bit7 rckwrts */
#define MAGIC_HS 0xf3e8d4d6	/* 'VThs' mit gesetzten Bit7 rckwrts */
#endif
#define INDEXPP 249		/* Indexeintrge pro fhrender Index-Seite */
#define INDEXPP_HS 255		/* im h#s-Format passen mehr Eintrge 'rein */


static tIdx *Index=NULL;	/* der Index ber die Datei */

static word IndexCnt=0;
FILE *VTFile=NULL;		/* Aktueller Datei-Pointer */
char FName[256];		/* aktueller Dateiname (undefiniert) */

void CloseFile(){
 if (VTFile){
  fclose(VTFile);
  VTFile=NULL;
 }
}

int LoadFile(char *FileName){	/* Tatschlicher Dateiname wird rckgeschrieben! */
 word i;
 long hdr;
 char CatBuf[256];
 tIdx *NewIndex;
 FILE *VTTemp;			/* solange bis Datei OK ist */

 void ReadNewIndex(word indexpp){
  /* Routine zum Einlesen eines New-Format-VT-Files */
  /* Die Kennung sei bereits vorher gecheckt! (schneller) */
  word i,i1;
  i=(IndexCnt+indexpp) / (indexpp+1);	/* Reservierte Seiten am Beginn */
  for (i1=0; i1<i; i1++)
   Index[i1].L=MAGIC;		/* Erste Indexeintrge sperren */
  for (; i<IndexCnt; i+=i1){
   fread(&Page,sizeof(tPage),1,VTFile);
/*   if (Page.B[0]<0x80)
    printf("Warnung: VT-Datei-Index inkonsistent oder zu kurz (evtl. Bug)!\n");*/
   i1=IndexCnt-i;
   if (i1>indexpp) i1=indexpp;
   memcpy(&Index[i],&Page.B[4],sizeof(tIdx)*i1);	/* Indizes kopieren */
  }
 }

 if (!FileName) return 9;	/* NULL bergeben? - Fehler! */
 strcpy(CatBuf,FileName);	/* die Katze verwurschteln
				   (oder kann jemand "strcpy" richtig aussprechen:-)*/
 VTTemp=fopen(CatBuf,"rb");
 if (!VTTemp){			/* Bei Fehler: Versuche es mit Suffix ".vt" */
  strcat(CatBuf,".vt");		/* die Katze aus dem Sack lassen */
  VTTemp=fopen(CatBuf,"rb");	/* Zweiter Versuch */
  if (!VTTemp){
   return errno;		/* Jetzt wei "LoadFile()" nicht mehr weiter */
  }
 }
 fread(&hdr,4,1,VTTemp);	/* Kennung lesen */
 fseek(VTTemp,0L,SEEK_END);	/* Gre feststellen */
 i=ftell(VTTemp) / 1024;	/* Erforderliche Gre */
 if (i==0) return 11;		/* Null ist falsch (Ungltiges Format) */
 rewind(VTTemp);
 NewIndex=(tIdx *)realloc(Index,i*sizeof(tIdx));
			/* Dieser Heapbefehl trifft den Nagel auf dem Kopf */
 if (!NewIndex){		/* Kein (neuer) Speicher? */
  return 8;			/* alten Zustand beibehalten! */
 }
 Index=NewIndex;		/* Neuer Index-Zeiger */
 IndexCnt=i;			/* in globale Variable schreiben */
 CloseFile();			/* Jetzt erst alte Datei zumachen */
 VTFile=VTTemp;			/* neuen Zeiger zuweisen */
 strcpy(FName,CatBuf);		/* neuer Name - alles roger */
/* printf("'%s' geoeffnet, Laenge: %hu Seiten, Datei-Typ: ",FileName,IndexCnt); */

 switch (hdr){
  case MAGIC:			/* das Haftmann-Fiedler-Format */
/*   printf("VThf\n"); */
   ReadNewIndex(INDEXPP);
   break;
  case MAGIC_HS:		/* das etwas speichersparsamere Haftmann-F. */
/*   printf("VThs\n"); */
   ReadNewIndex(INDEXPP_HS);
   break;
  case 0x20202020:		/* Uralt-Format (immer noch von Fiedel benutzt!) */
/*   printf("uralt\n"); */
   for (i=0; i<IndexCnt; i++){
    fread(&Page,1024,1,VTFile);
    Index[i].W.Page=
     ((Page.T.Page100 & 7) <<8)|
     ((Page.T.Page10 & 0xf) <<4)|
      (Page.T.Page1 & 0xf);
    Index[i].W.Subp=
     ((Page.T.Subp1000 & 3) <<12)|
     ((Page.T.Subp100 & 0xf) <<8)|
     ((Page.T.Subp10 & 7) <<4)|
      (Page.T.Subp1 & 0xf);
   }
   break;
  default:			/* Reine Seitennummer: "File of TPage" */
/*   printf("traditionell\n"); */
   for (i=0; i<IndexCnt; i++){
    fseek(VTFile,(long)i*1024,SEEK_SET);
    fread(&Index[i],sizeof(tIdx),1,VTFile);
   }
 }
#ifdef motorola
 if (hdr!=0x20202020){		/* im Falle "Uralt" stimmt der Index schon! */
  for (i=0; i<IndexCnt; i++){
   byteswap(&Index[i].W.Page);
   byteswap(&Index[i].W.Subp);	/* Gesamten Index "behandeln" */
  }
 }
#endif
 return 0;			/* fehlerfrei */
}



/*****************************/
/* Seite auswhlen und laden */
/*****************************/

/* Suchmodi, wenn angegebene Seite nicht gefunden: */
#define EQUALPAGE 1
/* Seite und Unterseite mu stimmen */
#define NEXTPAGE 2
/* Gehe zur nchsten Seite, minimale Unterseite */
#define PREVPAGE 3
/* Gehe zur vorherigen Seite, minimale Unterseite */
#define NEXTSUB 4
/* Gehe zur nchsten Unterseite mit Wrap-Around, Seite mu stimmen */
#define PREVSUB 5
/* Gehe zur vorherigen Unterseite mit Wrap-Around, Seite mu stimmen */
#define NEXTSUBPAGE 6
/* Gehe zur nchsten Unterseite, wenn nicht dann zur nchsten Seite */
#define PREVSUBPAGE 7
/* Gehe zur vorherigen Unterseite, wenn nicht dann zur vorherigen Seite */
#define ADDNEXTPAGE 10
/* wie NEXTPAGE, jedoch nicht die angegebene Seite nehmen */
#define SUBPREVPAGE 11
/* wie PREVPAGE, jedoch nicht die angegebene Seite nehmen */
#define ADDNEXTSUB 12
/* wie NEXTSUB, jedoch nicht die angegebene Unterseite nehmen */
#define SUBPREVSUB 13
/* wie PREVSUB, jedoch nicht die angegebene Unterseite nehmen */
#define ADDNEXTSUBPAGE 14
/* wie NEXTSUBPAGE, jedoch nicht die angegebene Seite nehmen */
#define SUBPREVSUBPAGE 15
/* wie PREVSUBPAGE, jedoch nicht die angegebene Seite nehmen */


/* Videotext-Seite in "gewhnliches Format" wandeln */
word UsualPage(word Page){
 Page&=0x7FF;			/* Obere Bits lschen */
 if (Page<0x100) return Page+0x800; /* 000..0FF --> 800..8FF */
 return Page;			/* alles andere so lassen */
}

/* Videotext-Index in String wandeln */
char *Idx2Str(tIdx Index){	/* Nicht reentrant! */
 static char Puffer[10];
 sprintf(Puffer,"%03hX/%02hX",
  UsualPage(Index.W.Page),Index.W.Subp & 0x3f7f);
 return Puffer;
}

/* Seite auswhlen, liefert Index-Nummer oder FFFF bei Fehler */
word SelectPage(word DP,word DS,byte SearchMode){
 word i,idx;		/* Indizes */
#define CP ((Index[i].W.Page) & 0x7ff)
#define CS ((Index[i].W.Subp) & 0x3f7f)
 dword BB,OO;		/* BB=Bester Abstand, OO=Abstand */
 auto word f01=0;	/* Entscheidet, ob GLEICHE Seite gefunden wird */

 BB=OO=0xffffffff;
 idx=0xffff;		/* ungltigen Indexeintrag erzeugen */
 DP&=0x7FF;
 DS&=0x3F7F;
/*printf("SelectPage: %hx/%hx Suchmodus %hd, ",
 UsualPage(DP),DS,SearchMode);*/
 if (SearchMode & 8){
  SearchMode&=~8;
  f01++;
 }
/* if (!Index){
  printf("SelectPage aufgerufen mit Index=NULL!\n");
 } */
 for (i=0; i<IndexCnt; i++){
  if (CP < 0x1000){	/* Nur mit gltigen Eintrgen arbeiten */
/* Ziel ist es, BP bzw. BS zu minimieren und bei Erfolg wird "idx" gesetzt */
   switch (SearchMode){
    case NEXTPAGE:
     OO=(((dword)CP-DP-f01)<<16)+(CS-0);
			/* Vorwrts, DesiredSub verwerfen */
     break;

    case PREVPAGE:
     OO=(((dword)DP-CP-f01)<<16)+(CS-0);
			/* Rckwrts & Vorwrts, DesiredSub verwerfen */
     break;

    case NEXTSUB:
     if (CP==DP)	/* Gleiche Seite? */
      OO=(dword)CS-DS-f01;	/* Vorwrts */
     break;

    case PREVSUB:
     if (CP==DP)	/* Gleiche Seite? */
      OO=(dword)DS-CS-f01;	/* Rckwrts */
     break;

    case NEXTSUBPAGE:
     OO=(((dword)CP<<16)+CS)-(((dword)DP<<16)+DS)-f01;
			/* Vorwrts, Abstand als dword */
     break;

    case PREVSUBPAGE:
     OO=(((dword)DP<<16)+DS)-(((dword)CP<<16)+CS)-f01;
			/* Rckwrts, Abstand als dword */
     break;

    case EQUALPAGE:
     if ((DP==CP) && (DS==CS))
      OO=0;		/* Nur wenn gleich den Index setzen */
     break;
   } /* switch */
   if (OO<BB){		/* "Bessere" Seite? */
    BB=OO;		/* merken */
    idx=i;		/* Heien Index merken */
   }
  } /* if */
 } /* for */
/*printf("Ergebnis %s Index %hu Abst.%X\n",(idx==0xffff)?"Nicht gefunden":
 Idx2Str(Index[idx]),idx,BB);*/
 return idx;
}

/* Seite.Zeile[24] im Speicher mit "Buttonleiste" versehen */
void PatchPage(word Flags){

 word PageOf(word Page, byte Mode){
  Page=Index[SelectPage(Page,0,Mode)].W.Page;	/* berschreibend */
  return UsualPage(Page);
 }
 sprintf((char *)&Page.L[24],
  "\4\x1d\7(B) \7\x1d\4%03hX %03hX << >> %03hX %03hX \4\x1d\7(F) ",
  PageOf(Header.W.Page&0x700,NEXTPAGE),	/* zum Hunderter */
  PageOf(Header.W.Page, SUBPREVPAGE),	/* Seite Ab */
  PageOf(Header.W.Page, ADDNEXTPAGE),	/* Seite Auf */
  PageOf((Header.W.Page+0x100)& 0x700,NEXTPAGE));	/* zum nchsten Hunderter */
}

/* Word- und Long-Angaben korrekt ausrichten und Headerbytes extrahieren */
/* Header auf magenta Spaces setzen */
void SetupPage(){
#ifdef motorola
 byteswap(&Page.H.W.Page);
 byteswap(&Page.H.W.Subp);
 byteswap(&Page.H.W.CBits);
 longswap(&Page.T.MsDosTime);	/* Einlesezeitpunkt, zeitzonenabhngig */
 byteswap(&Page.T.CRC);		/* Prfsumme ber diese Seite fr Fehlerkorrektur */
 byteswap(&Page.T.Mirror);	/* Adresse einer Spiegelseite whrend des Einlesens */
 longswap(&Page.T.UnixTime);	/* Einlesezeitpunkt, Universal Time */
#endif
 memcpy(&Header,&Page.H,sizeof(tHeader));	/* Header auslagern */
 Page.B[0]=5;					/* magenta (also lila) */
 memset(&Page.B[1],' ',6);
}

/* Seite auswhlen und laden */
/* sowie oben und unten "dekorieren" */
/* Ist Index=NULL dann wird die Begrungsseite geladen */
/* sowie das Ergebnis ebenfalls auf "Not found" 0xffff gesetzt */

word SelectLoadPage(tIdx *Desire,byte SearchMode,word Flags){
 word i;		/* Lade-Index */
 if (!Index){
  memcpy(&Page,sPagedefault[country],1024);
  SetupPage();			/* kopieren und Header extrahieren */
  return 0xffff;		/* "Fehler" melden */
 }
/* char CatBuf[8];*/
 if (SearchMode==0)	/* Defaultwert? */
  SearchMode=NEXTSUB;	/* Default-Suchmodus */
 i=SelectPage(Desire->W.Page,Desire->W.Subp,SearchMode);
 if (i!=0xffff){	/* Suche erfolgreich */
  fseek(VTFile,(long)i*1024,SEEK_SET);
  if (fread(&Page,sizeof(Page),1,VTFile)!=1){
/*   printf("Fehler beim Lesen der VT-Datei an Position %hu Kilobytes",i); */
  }else{
   SetupPage();
   Desire->L=Header.L;		/* Ergebnis rckschreiben */
   memcpy(&Page.B[1],Idx2Str(*Desire),6);	/* links oben hinpinseln */
   if (Flags & fBBar)
    PatchPage(Flags);				/* Button-Bar anfgen */
/*   if (Desire->L!=Index[i].L){
    printf("Warnung: VT-Datei inkonsistent oder Programm-Bug!\n");
   }*/
  }
 }else{
/*  printf("Seite %s im Suchmodus %hd nicht gefunden\n",
   Idx2Str(*Desire),SearchMode); */
 }
 return i;
}

/*********************************************************/
/* History, ein Objekt? zur Verwaltung der History-Liste */
/*********************************************************/
#define HISTSIZE 100
				/* merkt sich maximal 100 Eintrge */
#define History_CanFwd (HistPtr<HistLen)
#define History_CanBack (HistPtr>=2)
#define History_FwdIdx (Hist[HistPtr])
#define History_BackIdx (Hist[HistPtr-2])
tIdx Hist[HISTSIZE];		/* Das Gedchtnis */
word HistPtr,HistLen;		/* Zwei Arrayzeiger */

void History_Init(){		/* Ein Objekt emulieren? */
 HistPtr=HistLen=0;
}

void History_Append(tIdx *That){/* geht immer, notfalls wird das Array verschoben */
 if ((HistPtr>0) &&
  (Hist[HistPtr-1].L==That->L)){
/*  printf("Nichtstun\n"); */
  return;			/* Nichtstun */
 }
 if ((History_CanBack) &&	/* Zurck denkbar? */
  (Hist[HistPtr-2].L==That->L)){/* Dort liege diese Seite bereits? */
/*  printf("Zurueck\n"); */
  --HistPtr;
 }else{
  if (HistPtr>=HISTSIZE){	/* berlauf? */
   memmove(&Hist[0],&Hist[1],sizeof(tIdx)*(--HistPtr));
				/* Jeden Index vorschieben */
/*   printf("Pufferschieben\n"); */
  }
  if ((HistPtr<HistLen) &&
   (Hist[HistPtr].L==That->L)){
   HistPtr++;			/* Vorwrtsschritt zu gleicher Seite */
/*   printf("Vorwrts\n"); */
  }else{
   Hist[HistPtr++]=*That;
   HistLen=HistPtr;		/* Lnge krzen oder verlngern */
/*   printf("Neue Seite\n");*/
  }
 }
}

word MenuFlags, MenuFont;	/* Haupt-Einstell-Organe */
tIdx CurIdx;			/* Momentaner Index */

int OpenVTFile(char *FileName){
 int Returncode;
 Returncode=LoadFile(FileName);	/* ffnen, parsen */
 if (!Returncode){		/* Erfolgreich? */
  History_Init();		/* Geschichte totlegen */
  CurIdx.W.Page=0x100;
  CurIdx.W.Subp=0;		/* Definierte Startwerte */
  SetWindowTitle(FName);	/* Fenstertitel anpassen */
  SelectLoadPage(&CurIdx,NEXTSUBPAGE,MenuFlags);
 }
 return Returncode;
}

/***************************************************************/
/* "unsichtbare" Unterfenster erstellen und mit Link verbinden */
/***************************************************************/
/* Basisroutine, Rechteckangaben in Zeicheneinheiten */
void CreateInputWindow(byte x,byte y,byte b,byte h, tIdx *Indexp){
 Window sw;
 tIdx *hilfidx;
 XSetWindowAttributes xswa;

/* printf("CreateInputWindow(%hd,%hd,%hd,%hd; %s)\n",
  x,y,b,h,Idx2Str(*Indexp));*/
 xswa.cursor=idc_hand;
 sw=XCreateWindow(display,window,
  (short)x*FONTW,(short)y*FONTH,(word)b*FONTW,(word)h*FONTH,0,
  0, InputOnly, CopyFromParent, CWCursor, &xswa);

 XSaveContext(display,sw,Linklist,(caddr_t) Indexp);

/* XFindContext(display,sw,Linklist,(caddr_t *) &hilfidx);
 if (hilfidx!=Indexp)
  printf("Nicht korrekt gespeichert!\n");*/
/* XMapWindow(display,sw);*/
}

/*************************/
/* Link-Fenster erzeugen */
/*************************/

/* Spezialbehandlungsroutine fr "forward" und "back"-Knpfe */
void MkLinkBF(word Flags){
 if (History_CanBack){
  CreateInputWindow(3,24,3,1,&History_BackIdx);
/*  printf("Back=%s\n",Idx2Str(History_BackIdx));*/
 }
 if (History_CanFwd){
  CreateInputWindow(35,24,3,1,&History_FwdIdx);
/*  printf("Fwd=%s\n",Idx2Str(History_FwdIdx));*/
 }
}

/* eine Rechteckliste erzeugen */
/* anhand 3stelliger Zahlen und ">"..">>>", "<".."<<<" */
void MkLinkList(word Flags){
 word FlagReg;
 byte lines,line,col;
 bool LineContainsDblH;
 byte CurByte;
 byte Ziffern,Winkel;
 char cWinkel;		/* WELCHER Winkel */
 word Seite;

 bool CanDblH(){	/* Doppelte Zeichenhhe erlaubt? */
  return((line) && (line!=lines-1) && (Flags & fDblH));
 }

 void TestZiffern(){
  word i;
  if ((Ziffern==3) && (Seite>=0x100) && (Seite<=0x899) &&
   ((i=SelectPage(Seite&0x7FF,0,NEXTSUB))!=0xffff) &&
   (Index[i].L!=CurIdx.L)){ /* nicht zufllig dieselbe Seite? */
   CreateInputWindow(col-Ziffern,line,
    Ziffern,(FlagReg & fDblH)? 2 : 1,
    &Index[i]);
  }
  Ziffern=0;			/* Zhler erneut scharfmachen */
  Seite=0;
 }

 void TestWinkel(){
  word i;
/*  printf("TestWinkel\n");*/
  if ((Winkel>=1) && (Winkel<=3) &&	/* Hier: 1, 2 oder 3 Winkel zulassen */
   ((i=SelectPage(Header.W.Page,Header.W.Subp,
    (cWinkel=='>')? ADDNEXTSUBPAGE : SUBPREVSUBPAGE))!=0xffff) &&
   (Index[i].L!=CurIdx.L)){ /* nicht zufllig dieselbe Seite? */
   CreateInputWindow(col-Winkel,line,
    Winkel,(FlagReg & fDblH)? 2 : 1,
    &Index[i]);
  }
  Winkel=0;			/* Zhler erneut scharfmachen */
  cWinkel='\0';
 }

/* printf("MkLinkList\n");*/
 lines=GetLines(Flags);
/* mit Schleifen loslegen */
 LineContainsDblH=FALSE;
 for (line=0; line<lines; line++){
  if (LineContainsDblH){	/* hier: vorhergehende Linie! */
   LineContainsDblH=FALSE;	/* nichts weiter tun, dann nchste Zeile */
  }else{
   FlagReg=0; Ziffern=Winkel=0; Seite=0; cWinkel='\0';
   for (col=0; col<40; col++){	/* Neue Zeile, neues Glck */
    CurByte=Page.L[line][col];	/* aus der Seite holen */
    if (CurByte <0x20)
     FlagReg&=~fQuiz;
    switch (CurByte){
     case 0:
     case 1:
     case 2:
     case 3:
     case 4:
     case 5:
     case 6:
     case 7:
      FlagReg&= ~fGraf;		/* Grafikflag aus */
      break;
     case 12:
      FlagReg&= ~fDblH;		/* DoubleHeigth aus */
      break;
     case 13:
      if (CanDblH())		/* wenn nicht verboten */
       FlagReg|= fDblH;		/* DoubleHeigth ein */
       LineContainsDblH=TRUE;
      break;
     case 16:
     case 17:
     case 18:
     case 19:
     case 20:
     case 21:
     case 22:
     case 23:
      FlagReg|= fGraf;		/* Grafikflag ein */
      break;
     case 24:
      if (!(Flags & fQuiz))	/* wenn "Quiz-Zeichen AUS" */
       FlagReg|= fQuiz;		/* Secret ein */
      break;
     case 27:
      FlagReg^= fLatin;		/* Sprachumschaltung Lateinisch */
      break;
    } /* case */
    if (FlagReg & (fQuiz|fGraf))
     CurByte=0x20;
    if ((CurByte>=0x30) && (CurByte<=0x39)){	/* Ziffer? */
     Ziffern++;				/* Eine Ziffer mehr */
     Seite=(Seite << 4)+(CurByte-0x30);	/* Seitennummer zusammenschieben */
    }else TestZiffern();
    switch ((char)CurByte){
     case '>':
      if (cWinkel=='>'){
       Winkel++;
      }else{
       cWinkel='>';
       Winkel=1;
      }
      break;
     case '<':
      if (cWinkel=='<'){
       Winkel++;
      }else{
       cWinkel='<';
       Winkel=1;
      }
      break;
     default:
      TestWinkel();
    }
   } /* for col */
   TestZiffern();
   TestWinkel();
  } /* else */
 } /* for line */
}


/******************/
/* GIF-Foto-Schu */
/******************/
bool SchiessEinFoto(FILE *f, Pixmap hbm,
 word width, word height, char *comment){
 XImage *image;
#include "gifsave.h"
 byte GetPixelValue(short x, short y){
  long pixval;
  byte b;
/* if (x==0) printf("%hd ",y);	/* Scan-Zeie */
  pixval=XGetPixel(image,x,y);	/* Pixel-Wert erhalten */
  for (b=0; b<9; b++){		/* Index rckgewinnen durch Suchen */
   if (Farbe[b]==pixval) break;	/* Gefunden; b=Index */
  }
  return b;			/* ausgeben */
 }
/* printf("Start GetImage \n",image); */
 image=XGetImage(display,hbm,0,0,width,height,AllPlanes,ZPixmap);
/* printf("Image besorgt, hat Adresse %p.\n",image); */
 WriteGIF89(f,width,height,4,RGBWerte,8,comment,GetPixelValue);
/* printf("Fertig.\n",image); */
 XDestroyImage(image);
}
/**************************/
/* Benutzer-Schnittstelle */
/**************************/
XPoint P1,P2,Pn;		/* Punkt, wo Maustaste gedrckt bzw. losgelassen */
static bool moved;		/* True=Markierung auf Bildschirm vorhanden */
static byte autoredrawlock=0;	/* <>0=Kein Blinken und keine rollenden Unterseiten */
static bool AppDone=FALSE;
static bool HelpActive=FALSE;
tIdx Suchstart;
char Suchkette[40];
word SuchArt=6;			/* vorwrts/rckwrts, mit RegExp oder ohne usw. */
word KindOfInput;		/* Eingabezeilen-Flag */
char ClipBuff[42*25+1];
char FindBuff[41*24+1];

/* Suchen bzw. Weitersuchen */
bool Suche(SuchArt){		/* liefert FALSE wenn nichts gefunden */
 XDefineCursor(display,window,idc_wait);	/* Sanduhr (wre das unter MS-Windows) */
 XFlush(display);
 do{
  SelectLoadPage(&CurIdx,
   (SuchArt & BACKWARD)? SUBPREVSUBPAGE : ADDNEXTSUBPAGE, MenuFlags);
  if (CurIdx.L==Suchstart.L){
   XDefineCursor(display,window,idc_arrow);	/* normaler Mauspfeil */
   return FALSE;
  }
  Page2Asc(FindBuff,MenuFlags,MenuFont,0,0,39,23);
  PrepareString(FindBuff,SuchArt);
 }while (!strstr(FindBuff,Suchkette));	/* bis ein "Matsch" gefunden wurde */
 XDefineCursor(display,window,idc_arrow);	/* normaler Mauspfeil */
 return TRUE;
}

/**************************/
/* grafische Eingabezeile */
/**************************/
char Topline[50];		/* Reserve fr zu lange Strings lassen */
byte StartInput,Cursorpos;

void DrawInputLine(){
 byte i;
 for (i=0; i<40; i++){
  DrawBWAnsiChar(i,0,Topline[i]);	/* darstellen der Zeile */
 }
}

void BeginInput(char *What, char *Item){
 autoredrawlock++;		/* Fenster "statisch" machen */
 if (What)
  strncpy(Topline,What,38);
 StartInput=strlen(Topline);
 Topline[StartInput++]=' ';	/* Leerzeichen nach 1. String */
 Cursorpos=StartInput;
 if (Item){			/* Eingabezeilen-Vorgabe vorhanden? */
  strncpy(&Topline[Cursorpos],Item,38-Cursorpos);
  Cursorpos+=strlen(Item);
  if (Cursorpos>38)
   Cursorpos=38;		/* begrenzen */
 }
 memset(&Topline[Cursorpos],' ',sizeof(Topline)-Cursorpos);
 Topline[Cursorpos]='\x7f';	/* Cursor-Symbol */
 DrawInputLine();
}

void InputChar(char What){	/* 1 Zeichen eingeben, Sonderfall ist '\b' */
 if (What=='\b'){
  if (Cursorpos==StartInput){
   XBell(display,volume);
  }else{
   DrawBWAnsiChar(Cursorpos,0,Topline[Cursorpos]=' ');
   Cursorpos--;
   DrawBWAnsiChar(Cursorpos,0,Topline[Cursorpos]='\x7f');
  }
 }else{
  if (Cursorpos==39){
   XBell(display,volume);
  }else{			/* Ansi-Zeichen abspeichern */
   DrawBWAnsiChar(Cursorpos,0,Topline[Cursorpos]=What);
   Cursorpos++;
   DrawBWAnsiChar(Cursorpos,0,Topline[Cursorpos]='\x7f');
  }
 }
}
#define GetInputChars() (Cursorpos-StartInput)

char *EndInput(bool NeedRedraw){/* Zeichenkette zurckgeben */
 DrawBWAnsiChar(Cursorpos,0,' ');	/* Cursor verschwinden lassen */
 autoredrawlock--;
 if (NeedRedraw) InvokeExpose();/* Bildschirm restaurieren */
 Topline[Cursorpos]='\0';	/* Null-terminieren */
 return &Topline[StartInput];	/* Zeiger auf Stringanfang */
}


void UpdateBitmaps(bool);	/* solche Prototypen sollten wieder weg */

/*********************************/
/* Maus-Ereignisse und Markieren */
/*********************************/
void XorRect(Window window){
 auto short x=P1.x, y=P1.y;
 auto word w=P2.x-P1.x, h=P2.y-P1.y;

/* printf("XorRect(%hd,%hd,%hd,%hd)\n",P1.x,P1.y,P2.x,P2.y);*/
/* Sicherstellen, da Breite und Hhe positiv */
 if (P1.x>P2.x){
  w=P1.x-P2.x;
  x=P2.x;
 }
 if (P1.y>P2.y){
  h=P1.y-P2.y;
  y=P2.y;
 }
/* printf("Umgerechnet(%hd,%hd,%hd,%hd)\n",x,y,x+w,y+h);*/
 XFillRectangle(display,window,XorGC,x*FONTW,y*FONTH,(w+1)*FONTW,(h+1)*FONTH);
}

void XorPixmapRect(short bmidx){
 if (Pixmaps[bmidx].valid) XorRect(Pixmaps[bmidx].hbm);
}
void RemoveAnySelection(){
 if (moved){
  XorRect(window);		/* Evtl. noch vorhandenes Rechteck entfernen */
  XorPixmapRect(0);
  XorPixmapRect(1);
  moved=FALSE;			/* Cache-Pixmaps nicht vergessen! */
 }
}

void WMLButtonDown(XEvent *event){
/* printf("WMLButtonDown\n");*/
 RemoveAnySelection();
 P1.x=P2.x=event->xbutton.x/FONTW;
 P1.y=P2.y=event->xbutton.y/FONTH;
 autoredrawlock++;	/* Blinken u.. sperren */
}

void WMMouseMove(XEvent *event){
/* printf("WMMouseMove\n"); */
 Pn.x=event->xmotion.x/FONTW;		/* Neue Koordinaten */
 Pn.y=event->xmotion.y/FONTH;
 if (Pn.x<0) Pn.x=0;		/* gegen Fenstergrenzen begrenzen */
 if (Pn.x>=41) Pn.x=41-1;
 if (Pn.y<0) Pn.y=0;
 if (Pn.y>=25) Pn.y=25-1;
 if ((P2.x!=Pn.x) ||		/* nderung der Position von Belang? */
  (P2.y!=Pn.y)){		/* (Flackern minimieren) */
  if (moved) XorRect(window);
  P2=Pn;			/* Neuer 2. Punkt */
  moved=TRUE;			/* Berhrt - gefhrt: fortan Rechteck */
  XorRect(window);
 }
}

void WMLButtonUp(XEvent *event){
 auto short left=P1.x,top=P1.y,right=P2.x,bottom=P2.y;
 tIdx *IdxPtr;			/* zur Hilfe ein Zeiger auf einen Index */
 XEvent hevent;

/* printf("WMLButtonUp, moved=%s\n",
  moved?"TRUE":"FALSE"); */
 autoredrawlock--;	/* Blinken u.. wieder freigeben */
 if (moved){		/* Rechtecke nun auch in Cachepixmaps nachfhren */
  XorPixmapRect(0);
  XorPixmapRect(1);	/* Cache-Pixmaps nachfhren, wenn gltig */
/* "Schnelles Clipboard" (wie sonst in X blich */
  if (P1.x>P2.x){	/* erst wieder die Koordinaten sortieren */
   left=P2.x;
   right=P1.x;
  }
  if (P1.y>P2.y){
   top=P2.y;
   bottom=P1.y;
  }
  Page2Asc(ClipBuff,MenuFlags,MenuFont,left,top,right,bottom);
/*  printf("left=%hd, top=%hd, right=%hd, bottom=%hd\n",
   left,top,right,bottom);*/
  ClipBuff[strlen(ClipBuff)-1]='\0';	/* Letztes '\n' abschneiden */
/*  printf("%s<END>\n",ClipBuff);*/
  XSetSelectionOwner(display,XA_PRIMARY,window,event->xbutton.time);
  if (XGetSelectionOwner(display,XA_PRIMARY)==window){
/*   printf("Selektion erfolgreich gekapert!\n"); */
   XStoreBytes(display,ClipBuff,strlen(ClipBuff));
  }else{
   XBell(display,volume);
   RemoveAnySelection();
  }
/*
  XChangeProperty(display, RootWindowOfScreen(screen),
   XA_CUT_BUFFER0,XA_STRING,8,PropModeReplace,ClipBuff,strlen(ClipBuff));
  XChangeProperty(display, RootWindowOfScreen(screen),
  hevent.type=PropertyNotify;
  hevent.xproperty.time=event->xbutton.time;
  hevent.xproperty.display=display;
  hevent.xproperty.window=RootWindowOfScreen(screen);
  hevent.xproperty.atom=XA_CUT_BUFFER0;
  hevent.xproperty.state=PropertyNewValue;
  if (XSendEvent(display,RootWindowOfScreen(screen),TRUE,0xffffff,&hevent))
   printf("Hier vorbei(XSendEvent)\n");
  XFlush(display);*/
 }else{			/* zur neuen Seite hpfen? */
  if (XFindContext(display,event->xbutton.subwindow,Linklist,
   (caddr_t *)&IdxPtr)==0){
/*   printf("subwindow im Kontext gefunden\n");*/
   if (SelectLoadPage(IdxPtr,EQUALPAGE,MenuFlags)!=0xffff){
    CurIdx=*IdxPtr;		/* aktualisieren */
    UpdateBitmaps(TRUE);
   }else{
/*    printf("Programm-Bug: Seite %s nicht (mehr) da!\n",Idx2Str(*IdxPtr));*/
   }
  }else{
/*   printf("subwindow im Kontext NICHT gefunden\n");*/
  }
 }
}

void WMRButtonDown(XEvent *event){
/*
 if (moved){
/* ergnzen: Rechteck ins Clipboard bringen *
  XorRect(window);		/* Evtl. noch vorhandenes Rechteck entfernen * /
  XorPixmapRect(0);		/* Cache-Pixmaps Rechteck entfernen * /
  XorPixmapRect(1);
  moved=FALSE;
 }else*/ if (History_CanBack){
  CurIdx=History_BackIdx;
  SelectLoadPage(&CurIdx,EQUALPAGE,MenuFlags);
  UpdateBitmaps(TRUE);
 }
}

void WMRButtonUp(XEvent *event){
}

/*******************************/
/* Tastatur-Ereignisse (ASCII) */
/*******************************/

void WMChar(char ch){
#define iPage 1
#define iSubp 2
#define iFind 3
#define iExit 4
#define iMsg  5
#define iOpen 6
#define iFont 7
#define iText 8
#define iGif 9
 tIdx HilfIdx;
 char FileName[40], *sp;	/* Stringzeiger fr Hilfszwecke */
 static word CurFont;
 int Returncode;
 FILE *f;			/* Ausgabe-Datei */

/* Unterprogramm zur Dateinamenseingabe (nur Backspace zum Editieren) */
 bool HandleNameInput(char ch){
  switch (ch){
   case '\x1b':
    EndInput(TRUE);		/* Eingabe ergebnislos beenden */
    KindOfInput=0;
    break;
   case '\n':
   case '\r':
    KindOfInput=0;		/* EndInput mu vom Programm gerufen werden! */
    return TRUE;		/* (ist zugegebenermaen etwas unsauber) */
   default:
    InputChar(ch);
  }
  return FALSE;
 }

 if (HelpActive){
  if (SelectLoadPage(&CurIdx,EQUALPAGE,MenuFlags)==0xffff){
   UpdateBitmaps(FALSE);
  }else{
   UpdateBitmaps(TRUE);
  }
  HelpActive=FALSE;
 }


/* Zahl 1..8 eingegeben und kein Input aktiv und Index vorhanden? */
 if ((ch>='1') && (ch<='8') && !KindOfInput && Index){
  BeginInput(sGotoPage[country],NULL);
  KindOfInput=iPage;		/* flugs Eingabezeile erffnen */
 }

 switch (KindOfInput){
/*case iExit:
   break;*/
/****************** Speichern-Eingabezeile (Text) *****************/
  case iText:
   if (HandleNameInput(ch)){	/* wenn mit ENTER beendet */
    strcpy(FileName,EndInput(TRUE));	/* beschaffen */
    sp=(char *)malloc(41*24+1);		/* Kurzzeit-Speicher beschaffen */
    if (sp){
     Page2Asc(sp,MenuFlags,MenuFont,0,0,39,23);	/* Langen String draus machen */

     if (strlen(FileName)){
      f=fopen(FileName,"a");	/* anhngen an evtl. vorhandene Datei */
     }else{
      f=stdout;			/* Standardausgabe */
     }
     if (f){			/* Gltiger Zeiger? */
      fprintf(f,"%s",sp);	/* String schreiben */
      if (f!=stdout)
       fclose(f);		/* zumachen */
     }else{
      sprintf(Topline,sWriteError[country],FileName,(word)errno);
      BeginInput(NULL,NULL);
      KindOfInput=iMsg;
     }
     free(sp);			/* Angeforderten Speicher freigeben */
    }
   }
   break;

/****************** Speichern-Eingabezeile (Bild) *****************/
  case iGif:
   if (HandleNameInput(ch)){	/* wenn mit ENTER beendet */
    strcpy(FileName,EndInput(TRUE));	/* beschaffen */
    if (strlen(FileName)){
     f=fopen(FileName,"wb");
     if (f){
      sp=(char *)malloc(41*24+1);	/* Kurzzeit-Speicher beschaffen */
      if (sp){
       XDefineCursor(display,window,idc_wait);
/* "Sanduhr" anzeigen (Hnde bleiben bei den Subwindows) */
/* sonst mte hier noch ein UnmapSubwindows() hin */
       XFlush(display);
       Page2Asc(sp,MenuFlags,MenuFont,0,0,39,23);	/* Pascal-Strings draus machen */
       SchiessEinFoto(f,Pixmaps[0].hbm,41*FONTW,24*FONTH,sp);
       XDefineCursor(display,window,idc_arrow);
       free(sp);
      }
      fclose(f);		/* Sclieen */
     }else{
      sprintf(Topline,sWriteError[country],FileName,(word)errno);
      BeginInput(NULL,NULL);
      KindOfInput=iMsg;
     }
    }
   }
   break;

/****************** Such-Eingabezeile *****************/
  case iFind:
   if (HandleNameInput(ch)){	/* wenn mit ENTER beendet */
    strcpy(Suchkette,EndInput(FALSE));	/* "herbekommen" */
    if (strlen(Suchkette)){
     PrepareString(Suchkette,SuchArt);	/* zu Grobuchstaben usw. */
     if (SuchArt & USEREGEXP){
 /* hier Regexp-bersetzung einbauen (spter) */
     }
     if (Suche(SuchArt)){
      UpdateBitmaps(TRUE);
     }else{
      BeginInput(sNoMatch[country],NULL);
      KindOfInput=iMsg;
     }
    }
   }
   break;

/****************** ffnen-Eingabezeile *****************/
  case iOpen:
   if (HandleNameInput(ch)){	/* wenn mit ENTER beendet */
    strcpy(FileName,EndInput(FALSE));
    if ((strlen(FileName)==0) || (Returncode=OpenVTFile(FileName))){
     sprintf(Topline,sFileError[country],FileName,(word)Returncode);
     BeginInput(NULL,NULL);
     KindOfInput=iMsg;
    }else{			/* erfolgreich geladen */
     UpdateBitmaps(TRUE);
    }
   }
   break;

/****************** Fontwahl-Eingabezeile *****************/
  case iFont:
   switch (ch){
    case '\x1b':
    case 'q':
    case '\3':
     EndInput(TRUE);		/* Eingabe ergebnislos beenden */
     KindOfInput=0;
     break;
    case ' ':
    case 'j':
    case 'l':
    case '\t':
    case '+':
     CurFont=(CurFont+2)%16;	/* 2 vorwrts */
    case 'h':
    case 'k':
    case '\b':
    case '-':
     CurFont=(CurFont+15)%16;	/* und 1 zurck */
     EndInput(FALSE);		/* kein Redraw ntig! */
     BeginInput(sChooseFont[country],sFontName[country][CurFont]);
     break;
    case '\n':
    case '\r':
     MenuFont=CurFont;
     EndInput(FALSE);
     KindOfInput=0;
     UpdateBitmaps(Index!=NULL);/* wenn Index=NULL dann nicht "laden" */
     break;
    default:
     XBell(display,volume);
   }
   break;

/****************** Seiten-Eingabezeile *****************/
  case iPage:		/* Es mssen exakt 3 Ziffern eingegeben werden */
   if ((isxdigit(ch)) || (ch=='\b')){
    InputChar(ch);
    if (GetInputChars()==3){
     sscanf(EndInput(FALSE),"%hx",&HilfIdx.W.Page);
     KindOfInput=0;
     HilfIdx.W.Subp=0;
     if (SelectLoadPage(&HilfIdx,NEXTSUB,MenuFlags)!=0xffff){
      CurIdx=HilfIdx;
      UpdateBitmaps(TRUE);
     }else{
      sprintf(Topline,sNoPage[country],UsualPage(HilfIdx.W.Page));
      BeginInput(NULL,NULL);
      KindOfInput=iMsg;
     }
    }
   }else{
    EndInput(TRUE);
    KindOfInput=0;
   }
   break;

/****************** Unterseiten-Eingabezeile *****************/
  case iSubp:		/* es knnen max. 4 Ziffern eingegeben werden */
   if ((isxdigit(ch)) || (ch=='\b')){
    InputChar(ch);
   }
   if ((isxdigit(ch) && (GetInputChars()==4)) ||
    (((ch=='\n') || (ch=='\r')) && (GetInputChars()>0))){
    sscanf(EndInput(FALSE),"%hx",&HilfIdx.W.Subp);
    KindOfInput=0;
    HilfIdx.W.Page=CurIdx.W.Page;
    if (SelectLoadPage(&HilfIdx,EQUALPAGE,MenuFlags)!=0xffff){
     CurIdx=HilfIdx;
     UpdateBitmaps(TRUE);
    }else{
     sprintf(Topline,sNoSubp[country],HilfIdx.W.Subp);
     BeginInput(NULL,NULL);
     KindOfInput=iMsg;
    }
   }else if (!((isxdigit(ch)) || (ch=='\b'))){
    EndInput(TRUE);
    KindOfInput=0;
   }
   break;

/****************** Hinweis-Zeile *****************/
  case iMsg:
/*   printf("Hier iMsg!\n");*/
   EndInput(TRUE);		/* Meldungszeile verschwinden lassen */
   KindOfInput=0;
   break;

/****************** normale Tastenauswertung *****************/
  default:
   switch (ch){
    case '\x1b':
     break;			/* Nicht piepsen */
    case ' ':	/* Leertaste nextsubpage */
     if (Index){
      SelectLoadPage(&CurIdx,ADDNEXTSUBPAGE,MenuFlags);
      UpdateBitmaps(TRUE);
     }
     break;
    case '/':	/* Suchen */
     if (Index){
      Suchstart=CurIdx;		/* alte Suchkette vorgeben */
      BeginInput(sSuchString[country],Suchkette);
      KindOfInput=iFind;
     }
     break;
    case 'g':	/* Homepage */
     if (Index){
      CurIdx.W.Page=0x100; CurIdx.W.Subp=0;
      SelectLoadPage(&CurIdx,NEXTSUBPAGE,MenuFlags);
      UpdateBitmaps(TRUE);
      break;
     }
    case 'h':	/* prevsub */
     if (Index){
      if (SelectLoadPage(&CurIdx,SUBPREVSUB,MenuFlags)!=0xffff){
       UpdateBitmaps(TRUE);
      }else{
       BeginInput(sOnlyOneSubp[country],NULL);
       KindOfInput=iMsg;
      }
     }
     break;
    case 'i':	/* Infos ber aktuelle Seite */
     CurFont=LandMap[(Header.W.CBits >> 12) & 7];
     if (CurFont==0) CurFont=13;	/* "reserviert" statt "automatisch" */
     sprintf(Topline,sPageInfo[country],
      Header.W.CBits,&sFontName[country][CurFont][1]);
     BeginInput(NULL,NULL);
     KindOfInput=iMsg;
     break;
    case 'j':
    case 'd':	/* nextpage */
    case '+':
     if (Index){
      SelectLoadPage(&CurIdx,ADDNEXTPAGE,MenuFlags);
      UpdateBitmaps(TRUE);
      break;
     }
    case 'k':
    case 'u':	/* prevpage */
    case '-':
     if (Index){
      SelectLoadPage(&CurIdx,SUBPREVPAGE,MenuFlags);
      UpdateBitmaps(TRUE);
      break;
     }
    case 'l':	/* nextsub */
    case '\t':	/* nextsub */
     if (Index){
      if (SelectLoadPage(&CurIdx,ADDNEXTSUB,MenuFlags)!=0xffff){
       UpdateBitmaps(TRUE);
      }else{
       BeginInput(sOnlyOneSubp[country],NULL);
       KindOfInput=iMsg;
      }
     }
     break;
    case 'n':	/* Weitersuchen */
     if (strlen(Suchkette)){
      if (Suche(SuchArt)){
       UpdateBitmaps(TRUE);
      }else{
       BeginInput(sNoMatch[country],NULL);
       KindOfInput=iMsg;
      }
     }
     break;
    case 'N':	/* Weitersuchen */
     if (strlen(Suchkette)){
      if (Suche(SuchArt^BACKWARD)){
       UpdateBitmaps(TRUE);
      }else{
       BeginInput(sNoMatch[country],NULL);
       KindOfInput=iMsg;
      }
     }
     break;
    case 'o':
     strcpy(FileName,FName);		/* den alten Pfad schon mal bereiten */
     sp=(char *)strrchr(FileName,'/');	/* Pfad-Trenner enthalten? */
     if (sp){			/* Ja? */
      sp++;			/* Zeiger dahinter positionieren */
     }else{			/* Nein? */
      sp=FileName;		/* Zeiger auf Stringanfang */
     }
     *sp='\0';			/* Abschneiden: Dahinter oder am Anfang */
     BeginInput(sOpenFile[country],FileName);	/* aktuellen Pfad setzen */
     KindOfInput=iOpen;
     break;
    case 'p':	/* Eingabe Seitennummer */
     if (Index){
      BeginInput(sGotoPage[country],NULL);
      KindOfInput=iPage;		/* flugs Eingabezeile erffnen */
     }
     break;
    case 'q':
    case '\3':			/* ^C bricht auch ab */
     AppDone=TRUE;		/* Abbruch erzwingen */
     break;
    case 's':	/* subpageinput */
     if (Index){
      BeginInput(sGotoSubp[country],NULL);
      KindOfInput=iSubp;
     }
     break;
    case 't':			/* Textdatei schreiben */
     strcpy(FileName,FName);	/* den alten Dateinamen schon mal bereiten */
     sp=(char *)strrchr(FileName,'.');	/* Extension enthalten? */
     if (sp){			/* Ja? */
      *sp='\0';			/* Da abschneiden */
     }
     strcat(FileName,Idx2Str(CurIdx));	/* aktuellen Index dranhngen */
     *(char *)strrchr(FileName,'/')='S';	/* den (hier) lstigen Slash killen */
     strcat(FileName,".txt");	/* Ein bichen DOS mu sein... */
     BeginInput(sOpenFile[country],FileName);	/* aktuellen Pfad setzen */
     KindOfInput=iText;
     break;
    case 'y':	/* Hilfe */
     memcpy(&Page,sHelpPage[country],1024);
     SetupPage();
     UpdateBitmaps(FALSE);
     HelpActive=TRUE;		/* nchsten Tastendruck wegfangen */
     break;
    case 'z':			/* Bilddatei schreiben */
     strcpy(FileName,FName);	/* den alten Dateinamen schon mal bereiten */
     sp=(char *)strrchr(FileName,'.');	/* Extension enthalten? (Naja, etwas gewagt) */
     if (sp){			/* Ja? */
      *sp='\0';			/* Da abschneiden */
     }
     strcat(FileName,Idx2Str(CurIdx));	/* aktuellen Index dranhngen */
     *(char *)strrchr(FileName,'/')='s';/* den (hier) lstigen Slash killen */
     strcat(FileName,".gif");	/* Ein bichen DOS mu sein... */
     BeginInput(sOpenFile[country],FileName);	/* aktuellen Pfad setzen */
     KindOfInput=iGif;
     break;
    case 'b':
    case '\b':
     if (History_CanBack){
      CurIdx=History_BackIdx;
      SelectLoadPage(&CurIdx,EQUALPAGE,MenuFlags);
      UpdateBitmaps(TRUE);
     }else{
      BeginInput(sNoBack[country],NULL);
      KindOfInput=iMsg;		/* flugs Eingabezeile erffnen */
     }
     break;
    case 'D':
     MenuFlags^=fDblH;
     if (memchr(&Page,13,24*40))	/* DblH-Steuercode enthalten? */
      UpdateBitmaps(TRUE);		/* Dann sofort auffrischen */
     break;
    case 'B':
     MenuFlags^=fDebug;
     UpdateBitmaps(TRUE);
     break;
    case 'E':
     BeginInput("Henrik.Haftmann@E-Technik.TU-Chemnitz.de",NULL);
     KindOfInput=iMsg;
     break;
    case 'F':
     CurFont=MenuFont;
     BeginInput(sChooseFont[country],sFontName[country][CurFont]);
     KindOfInput=iFont;
     break;
    case 'I':
     MenuFlags^=fInvers;
     GetColors(MenuFlags&fInvers);	/* neue Farben besorgen */
     UpdateBitmaps(TRUE);
     break;
    case 'L':
     MenuFlags^=fBlink;		/* Blinken toggeln */
     break;
    case 'M':
     MenuFlags^=fMix;
     if ((Header.W.CBits & 0x60)==0)
      UpdateBitmaps(TRUE);
     break;
    case 'Q':
     MenuFlags^=fQuiz;		/* Quiz-Flag toggeln */
     if (memchr(&Page,24,24*40))
      UpdateBitmaps(TRUE);	/* Bei Vorhandensein von QUIZ aktualisieren */
     break;
    case 'R':
     MenuFlags^=fRoll;
     break;
    case 'V':
     BeginInput(" h#s VTX teletext for X version 0.90",NULL);
     KindOfInput=iMsg;
     break;
    case 'W':
     MenuFlags^=fBunt;
     UpdateBitmaps(TRUE);
     break;
    default:
     XBell(display,volume);	/* Ein "bellendes" Programm fr "liegengebliebene" Ereignisse */
   } /* switch(ch) */
 } /* switch */
}

/**************************************/
/* Tastatur-Ereignisse (Sondertasten) */
/**************************************/
void WMKey(KeySym key){		/* Behandlungsroutine fr Sondertasten */
 switch (key){
  case XK_Cancel:
  case XK_Break:
  case XK_F10:
   WMChar('q');
   break;
  case XK_Home:
   WMChar('g');
   break;
  case XK_End:
   WMChar('p');
   break;
  case XK_Prior:
   WMChar('-');
   break;
  case XK_Next:
   WMChar('+');
   break;
  case XK_F1:
  case XK_Help:
   WMChar('y');
   break;
  case XK_F2:
  case XK_Find:
   WMChar('/');
   break;
  case XK_F3:
   WMChar('n');
   break;
  case XK_F4:
  case XK_Execute:
   WMChar('o');
   break;
  case XK_Left:
   WMChar('h');
   break;
  case XK_Right:
   WMChar('l');
   break;
  case XK_Up:
   WMChar('k');
   break;
  case XK_Down:
   WMChar('j');
   break;
  case XK_Shift_L:
  case XK_Shift_R:
  case XK_Control_L:
  case XK_Control_R:
  case XK_Caps_Lock:
  case XK_Shift_Lock:
  case XK_Meta_L:
  case XK_Meta_R:
  case XK_Alt_L:
  case XK_Alt_R:
  case XK_Super_L:
  case XK_Super_R:
  case XK_Hyper_L:
  case XK_Hyper_R:
   break;			/* Nicht luten */
  default:
   XBell(display,volume);	/* Glocken luten */
 }
}

void DestroyOld(){
/* if (XDeleteContext(display,None,Linklist))	/* ich will ALLE Fenster lschen */
/*  printf("Kontext loeschen versagt\n");	/* aber das geht halt nicht! */
 XDestroySubwindows(display,window);	/* Alle "Eingabefenster" killen */
}
/* void SetTimer(word);		/* Forward */
word TimerCount;		/* zhlt die Sekunden */

/* Parameter gibt an, ob's vielleicht blo 'ne Hilfeseite ist */
void SetupNew(bool TruePage){
 Pixmaps[0].valid=Pixmaps[1].valid=FALSE;
 BMIdx=0;
 moved=FALSE;			/* Rechteck verschwindet */
 KindOfInput=0;			/* Eingabezeile verschwindet */
 TimerCount=0;			/* "StopBlink" */
 if (TruePage){
  History_Append(&CurIdx);
  MkLinkList(MenuFlags);	/* Neue Linkliste erzeugen (dauert nicht lange??) */
  MkLinkBF(MenuFlags);		/* Neue Linkliste erzeugen (dauert nicht lange??) */
 }
}
/******************/
/* Expose-Message */
/******************/
void UpdateBitmaps(bool TruePage){
 DestroyOld();
 SetupNew(TruePage);
 InvokeExpose();
}

void UpdateBitmap(short CurIdx){
 XDefineCursor(display,window,idc_wait);	/* Sanduhr (wre das unter MS-Windows) */
 DrawVT(Pixmaps[CurIdx].hbm,
  (CurIdx)? MenuFlags & ~fBlink : MenuFlags | fBlink, MenuFont);
 XDefineCursor(display,window,idc_arrow);
 Pixmaps[CurIdx].valid=TRUE;
}

void WMPaint(){
 if (BMIdx>=0){			/* Gltiger Wert (gegen verfrhte Exposes) */
  if (!Pixmaps[BMIdx].valid){	/* Pixmap noch nicht erstellt? */
   UpdateBitmap(BMIdx);		/* Na dann aber los! */
   if (moved) XorPixmapRect(BMIdx);
  }
  XCopyArea(display,Pixmaps[BMIdx].hbm,window,MainGC,0,0,41*FONTW,25*FONTH,0,0);
  if (KindOfInput)		/* Eingabezeile? */
   DrawInputLine();		/* Drberpinseln (Einzelzeichen) */
  XMapSubwindows(display,window);	/* Jetzt erst Eingabefenster erzeugen */
 }else{
/*  printf("BMIdx negativ!\n");*/
 }
}

/******************/
/* Timer-Messages */
/******************/
Atom WM_TIMER;
bool SafeToSendTimerEvent=FALSE,
     RequestToSendTimerEvent=FALSE;

void DefineWMTimer(){
 WM_TIMER=XInternAtom(display,"WM_TIMER",FALSE);
}

void XSendTimerMsg(int dummy){
 XEvent event;
 event.type=ClientMessage;
 event.xclient.display=display;
 event.xclient.window=window;
 event.xclient.message_type=WM_TIMER;
 event.xclient.format=32;
 event.xclient.data.l[0]=(long)dummy;
 if (SafeToSendTimerEvent){	/* Hauptprogramm ttigt gerade XNextEvent? */
  XSendEvent(display,window,True,0,&event);	/* XNextEvent() erlsen */
  XFlush(display);
 }else{
  RequestToSendTimerEvent=TRUE;	/* Nur vormerken */
 }
/* printf("SendTimerEvent\n"); */
}

void SetTimer(word seconds){
 signal(SIGALRM,XSendTimerMsg);
 alarm(seconds);
}


/* Reaktionsprogramm auf Timer-Message */
/* (Mglicherweise ginge alles auch ohne die Erfindung einer
 extra Timermessage, d.h. WMTimer wrde direkt vom Alarm-Handler aufgerufen.
 Aber so ist's mehr zu MS-Windows kompatibel, und auerdem lernte ich
 etwas ber den Nutzen der Atome) */
void WMTimer(XEvent *event){
 short BMMerk;		/* zum Entscheiden, ob Expose generiert werden soll */
 if (!autoredrawlock){		/* Timer nicht gesperrt? */
  autoredrawlock++;		/* Reentranz-Hahn zudrehen (sicherheitshalber) */
  TimerCount++;			/* Neuen "Sekundenwert" erzeugen */
  BMMerk=BMIdx;
  BMIdx=0; 			/* Grundstzlich Pixmap #0 nehmen */
  if ((MenuFlags & fBlink) && (TimerCount % 3==2) && /* Rest=2 */
   memchr(&Page,9,24*40)){	/* Blink-Zeichen enthalten? */
   BMIdx=1;			/* Nur bei Rest=2 Pixmap #1 nehmen */
  }
  if ((MenuFlags & fRoll) && (TimerCount % 3==0)){
				/* Seitenwechsel fllig? */
   if ((Header.W.CBits & (bit 11)) || (TimerCount % 24==0)){
				/* Schneller oder langsamer Wechsel? */
    if (SelectLoadPage(&CurIdx,ADDNEXTSUB,MenuFlags)!=0xFFFF){
     UpdateBitmaps(FALSE);	/* Hier: Nicht in History eintragen */
     MkLinkList(MenuFlags);	/* Neue Linkliste erzeugen (dauert nicht lange??) */
     MkLinkBF(MenuFlags);	/* Neue Linkliste erzeugen (dauert nicht lange??) */
     BMMerk=BMIdx;		/* Gleichsetzen, da InvokeExpose */
    }				/* von UpdateBitmaps() ausgefhrt wurde */
   }
  }
  if (BMMerk!=BMIdx)		/* Verschieden? */
   InvokeExpose();		/* Expose generieren */
  autoredrawlock--;
 }
 SetTimer(1);			/* Hier erst neu programmieren */
}


/*****************/
/* Hauptprogramm */
/*****************/
int main(int argc, char **argv){
 XEvent event;

 char CatBuf[16];
 XWMHints xwmh;
 char *DName=NULL;	/* Display-Name */
 char *iFName=NULL;	/* Kommandozeilen-Dateiname */
 char switchchar1, switchchar2;
 int i;
 KeySym key;
 XComposeStatus cs;

/* ':' und '=' im Kommando bergehen; wenn '\0' nchsten String nehmen */
 char *AdjustPP(char *sp){
  if (*sp=='\0'){
   i++;
   if (i==argc){
    fprintf(stderr,"Missing argument!\n");
    exit(1);
   }else{
   return argv[i];
   }
  }else if ((*sp==':') || (*sp=='=')){
   return ++sp;
  }else{
   return sp;
  }
 }

/* Dateiname der Variablen iFName zuweisen; aber NUR EINMAL */
 void AssignFName(char *Name){
  if (iFName){			/* Wenn bereits ein Name angegeben wurde */
   fprintf(stderr,"VTX accepts only one filename; ignore %s\n",Name);
  }else{
   iFName=Name;
  }
 }

 MenuFlags=fBunt|f41|f25|fDblH|fBlink|fBBar;
 MenuFont=0;
 CurIdx.W.Page=0x100;
 CurIdx.W.Subp=0;
/* printf("sizeof(tPage)=%hd, sizeof(tHeader)=%hd, \
sizeof(byte)=%hd, sizeof(word)=%hd, \
sizeof(long)=%hd, sizeof(tIdx)=%hd, sizeof(Ansitab)=%hx\n",
   sizeof(tPage),sizeof(tHeader),
/*   sizeof(tSAATrail),sizeof(tHSFTrail),
   sizeof(byte),sizeof(word),
   sizeof(long),sizeof(tIdx),sizeof(Ansitab));
/*  scanf("c",NULL);*/

/* Parameter parsen */
 for (i=1; i<argc; i++){
  if (argv[i][0]=='-'){
   switch (switchchar1=argv[i][1]){
    case 'D':
    case 'd':
     DName=AdjustPP(&argv[i][2]);
     break;
    case 'H':
    case 'h':
    case '?':
     puts(sHelp[country]);
     exit(0);
     break;
    case 'L':
    case 'l':
     switch (switchchar2=(AdjustPP(&argv[i][2])[0])){
      case 'D':
      case 'd':
       country=1;
       break;
/*      case 'F':
      case 'f':
       country=2;
       break;*/
      default:
       fprintf(stderr,"VTX: Unknown country %c!\n",switchchar2);
       exit(1);
     }
     break;
    case 'P':
    case 'p':
     sscanf(AdjustPP(&argv[i][2]),"%hx/%hx",&CurIdx.W.Page,&CurIdx.W.Subp);
     MenuFlags|=fNoX;
     break;
    case 'F':
    case 'f':
     sscanf(AdjustPP(&argv[i][2]),"%hd",&MenuFont);
     break;
    case 'M':
    case 'm':
     sscanf(AdjustPP(&argv[i][2]),"%hd",&MenuFlags);
     break;
    case 'N':
    case 'n':
     autoredrawlock++;		/* So das Blinken unterbinden */
     break;
    case 'S':
    case 's':
     sscanf(AdjustPP(&argv[i][2]),"%hd",&SuchArt);
     break;
    case 'V':
    case 'v':
     sscanf(AdjustPP(&argv[i][2]),"%d",&volume);
     break;
    case '-':
     AssignFName(&argv[i][1]);
     break;
    default:
     fprintf(stderr,"VTX: Unknown option -%c - for help type \"vtx -h\"!\n",
      switchchar1);
     exit(1);
   }
  }else{
   AssignFName(argv[i]);
  }
 } /* for */

 if (MenuFlags & fNoX){
  if (!iFName){
   fprintf(stderr,"You MUST specify a file here!\n");
   return -2;
  }
  if (i=LoadFile(iFName)){
   fprintf(stderr,"Error reading file %s, code %d\n",iFName,i);
   return i;
  }else{
   SelectLoadPage(&CurIdx,NEXTSUBPAGE,MenuFlags & ~fBBar);
   Page2Asc(FindBuff,MenuFlags,MenuFont,0,0,39,23);
   printf("%s",FindBuff);
   return 0;
  }
 }
 InitDisplay(DName);
 if (DefaultDepthOfScreen(screen)<3){
  MenuFlags&=~fBunt;		/* Bei armseligen Displays auf Schwarzwei schalten */
 }
/* printf("Display geoeffnet\n"); */
/* XSynchronize(display,TRUE);*/
 CreateMainWindow();
/* printf("Hauptfenster erstellt\n"); */
/* GetColors();*/
/* printf("Farben geholt\n");*/
 FontUpload();
/* printf("Font geladen\n");*/
 if (iFName){
  i=OpenVTFile(iFName);		/* Datei mit Trara ffnen, Returncode aufheben */
  if (i){
   SelectLoadPage(&CurIdx,NEXTSUBPAGE,MenuFlags);
				/* Startseite laden (lassen) */
   SetupNew(FALSE);
   sprintf(Topline,sFileError[country],iFName,i);
   BeginInput(NULL,NULL);
   KindOfInput=iMsg;
  }else{
   SetupNew(TRUE);
  }
 }else{
  SelectLoadPage(&CurIdx,NEXTSUBPAGE,MenuFlags);
				/* Startseite laden (lassen) */
  SetupNew(FALSE);
 }
 DefineWMTimer();		/* Timer-Atom vereinbaren */
 if (!autoredrawlock)
  SetTimer(1);			/* Timer starten wenn erlaubt */
/* Hauptereignisschleife */
 while (!AppDone){
  XFlush(display);		/* Warteschlange leeren */
  if (RequestToSendTimerEvent){	/* Anhngiges Timer-Event vorlassen */
   event.type=ClientMessage;
   event.xclient.message_type=WM_TIMER;
   RequestToSendTimerEvent=FALSE;
  }else{
   SafeToSendTimerEvent=TRUE;	/* Reentranz zulassen */
   XNextEvent(display,&event);
   SafeToSendTimerEvent=FALSE;	/* Reentranz sperren */
  }
/*  printf("Hier vorbei (XNextEvent)!\n");*/

  switch (event.type){
   case MappingNotify:
/*    printf("Mapping-Message\n");*/
    XRefreshKeyboardMapping((XMappingEvent *)&event);	/* sollte halt so sein */
    break;

   case Expose:
/*    printf("1 Expose\n"); */
/*    if (event.xany.window != window)
     printf("Da stimmt was nicht!"); */
    if (event.xexpose.count==0){
/*     printf("Start Expose\n"); */
     WMPaint();
/*     printf("Ende Expose\n"); */
    }
    break;

   case ButtonPress:
    switch (event.xbutton.button){
     case 1:				/* Linke Maustaste */
      WMLButtonDown(&event);
      break;
     default:				/* Alle anderen */
      WMRButtonDown(&event);
    }
    break;

   case MotionNotify:
    WMMouseMove(&event);
    break;

   case ButtonRelease:
    switch (event.xbutton.button){
     case 1:				/* Linke Maustaste */
      WMLButtonUp(&event);
      break;
     default:				/* Alle anderen */
      WMRButtonUp(&event);
    }
    break;

   case KeyPress:
    CatBuf[XLookupString((XKeyEvent *)&event,CatBuf,sizeof(CatBuf),&key,&cs)]='\0';

/*    printf("Tastatur-Ereignis! String=\"%s\" Code %hX, ",CatBuf,CatBuf[0]);
    printf("KeySym=0x%04X\n",key);*/
    if (strlen(CatBuf)==1){
     WMChar(CatBuf[0]);
    }else{
     WMKey(key);
    }
    break;

   case ClientMessage:
/*    printf("Timer-Event?\n"); */
    if (event.xclient.message_type==WM_TIMER){
/*     printf("Das Timer-Event! Hurra!\n"); */
     WMTimer(&event);		/* Windows-like aufrufen */
    }
    break;

   case NoExpose:
/*    printf("Huch! Ein NoExpose Event.\n");*/
    break;

   case SelectionRequest:
/*    printf("SelectionRequest!\n"); */
/*    if (event.xselectionrequest.target==XA_STRING)
     printf("Hervorragend: als String!\n");
    if (event.xselectionrequest.owner==window)
     printf("Hervorragend: Owner=Window!\n");
    if (event.xselectionrequest.selection==XA_PRIMARY)
     printf("Hervorragend: selection=XA_PRIMARY!\n");
    if (event.xselectionrequest.property==XA_CUT_BUFFER0){
     printf("Hervorragend: property=CUT_BUFFER0!\n");
    }else{
     printf("Nicht Hervorragend: property=%d!\n",
      event.xselectionrequest.property);
    }
    if (event.xselectionrequest.requestor==RootWindowOfScreen(screen)){
     printf("Hervorragend: requestor=CRootWindow!\n");
    }else{
     printf("Nicht Hervorragend: requestor=%d!%d\n",
      event.xselectionrequest.requestor,window);
    } */
/*    XChangeProperty(display,
     event.xselection.requestor,
     event.xselectionrequest.property,
     event.xselectionrequest.target,
     8,PropModeReplace,ClipBuff,strlen(ClipBuff));*/
  XChangeProperty(display, RootWindowOfScreen(screen),
   XA_CUT_BUFFER0,XA_STRING,8,PropModeReplace,ClipBuff,strlen(ClipBuff));
  XChangeProperty(display, event.xselection.requestor,
   XA_CUT_BUFFER0,XA_STRING,8,PropModeReplace,ClipBuff,strlen(ClipBuff));

    event.type=SelectionNotify;
    event.xselection.requestor=event.xselectionrequest.requestor;
    event.xselection.selection=XA_PRIMARY;
    event.xselection.target   =XA_STRING;
    event.xselection.property =XA_CUT_BUFFER0;
    event.xselection.time     =event.xselectionrequest.time;
    XSendEvent(display,event.xselection.requestor,
     TRUE,0xffffffL,&event);
/*    event.xselection.requestor=RootWindowOfScreen(screen);
    XSendEvent(display,RootWindowOfScreen(screen),
     TRUE,0xffffffL,&event);
    event.xselection.requestor=window;
    XSendEvent(display,RootWindowOfScreen(screen),
     TRUE,0xffffffL,&event);
    if (XSendEvent(display,event.xselection.requestor,
     TRUE,0xffffffL,&event))
     printf("Erfolgreich gesendet!\n");*/

    break;
   case SelectionClear:
    if (event.xselectionclear.selection==XA_PRIMARY){
     RemoveAnySelection();
    }
    break;
   default:
/*    printf("Unbekanntes Event %d\n",event.type); */
  } /* switch */
 } /* while */
 CloseFile();
 return 0;
} /* main */



