PROGRAM ACL_P;
{$R+}
{ Beispiel fr die Steuerung des ET4000/W32p (Accelerator)
  Sprache: Turbo Pascal 6.0     J.Petsch }

USES CRT, DOS, W32ACL_P;

CONST BpL	    : WORD    = 1024;	{ 640 ; 800 ; 1024 ; 1280 }
      Ymax          : WORD    = 767;    { 479 ; 599 ;  767 ; 1023 }
      GraphMode     : BYTE    = $38;    { $2E ; $30 ;  $38 ;  $3F }

TYPE
  BitBlTData = RECORD
       Xs:     INTEGER;      { 00 }
       Ys:     INTEGER;      { 02 }
       Xp:     INTEGER;      { 04 }
       Yp:     INTEGER;      { 06 }
       Xd:     INTEGER;      { 08 }
       Yd:     INTEGER;      { 10 }
       Breite: WORD;         { 12 }
       Hoehe:  WORD;         { 14 }
       FgROP:  WORD;         { 16 }
  END;

VAR reg                        : REGISTERS;
    Save, Dest                 : BitBlTData;
    X, Y, I, Dy, Dx, S, R, D2Y : INTEGER;

PROCEDURE Gitter;             { Zeichnet Gitter als Hintergrund }
VAR X, Y : WORD;
BEGIN
  FOR X:=0 TO 32 DO PutVliCopy (X * BpL DIV 32,0,Ymax,X+40);
  FOR Y:=0 TO 24 DO PutHliCopy (0,Y*(Ymax+1) DIV 24,BpL,Y+32);
END;

PROCEDURE PutDisk (X,Y,R,Farbe:WORD);   { Zeichnet Kreisscheibe }
VAR
H, Lhalbe :WORD;
BEGIN
  FOR H:=0 to R DO
  BEGIN
    Lhalbe:= ROUND (SQRT((R*R)-(H*H)));
    PutHliCopy (X-Lhalbe,Y+H, 2*Lhalbe, Farbe);
    PutHliCopy (X-Lhalbe,Y-H, 2*Lhalbe, Farbe);
  END;
END;

PROCEDURE LineDemo; { Zeichnet einen Fcher }
BEGIN
  FOR X:= 0 TO (BpL DIV 32) DO
    PutLine (32*X,0,BpL-32*X,Ymax,X+40);
  FOR Y:= 0 TO (Ymax DIV 32) DO
    PutLine (0,32*Y,BpL,Ymax-32*Y,Y+32);
  READLN;
END;				       { PROCEDURE LineDemo }

PROCEDURE FillDemo; { Fllt Quadrate entlang des Bildschirmrandes }
CONST  A = 9;       { Kantenlnge 1...24 }
VAR X,Y,K,D   : WORD;
    Farbe : BYTE;
BEGIN
  D:= BPL DIV 32;     { Schrittweite }
  K:= A * D;	      { Kantenlnge in Pixel }
  REPEAT
  FOR X:=0 TO 32-A DO
  BEGIN
    WaitForSync;
    FillSprite(X*D,0,K,K,FARBE);
    Farbe:=(Farbe+1) MOD 104;
  END;
  FOR Y:=0 TO 24-A DO
  BEGIN
    WaitForSync;
    FillSprite(X*D, Y*D, K, K, Farbe);
    Farbe:=(Farbe+1) MOD 104;
  END;
  FOR X:=32-A DOWNTO 0 DO
  BEGIN
    WaitForSync;
    FillSprite(X*D,Y*D,K,K,Farbe);
    Farbe:=(Farbe+1) MOD 104;
  END;
  FOR Y:=24-A DOWNTO 0 DO
  BEGIN
    WaitForSync;
    FillSprite(0, Y*D, K, K, Farbe);
    Farbe:=(Farbe+1) MOD 104;
  END;
  UNTIL KEYPRESSED;
  READLN
END;

PROCEDURE BitBlTDemo;
BEGIN
  reg.BX:=$FF;                          { Fr Farbe #255..         }
  reg.DH:=$3F; reg.CH:=$3F; reg.CL:=$3F;{ ..rot/grn/blau auf max..}
  reg.AL:=$10; reg.AH:=$10;             { .. ergibt hellwei       }
  INTR($10,reg);                        { Video BIOS  }
  R:=BpL DIV 16;                        { Radius der Kreisscheibe  }
  Gitter;                              { Zeichne Hintergrundmuster }
  FillSprite (2*R,0,2*R,2*R,0);        { Lsche Hintergrund und..  }
  PutDisk (3*R,R,R,255);               { ..zeichne Kreisscheibe.   }
  Save.Breite := 2*R;   Save.Hoehe := 2*R;
  Save.FgROP := $CC;
  Dest.Breite := 2*R;   Dest.Hoehe := 2*R;
  Dest.FgROP := $CA;
  S := 16;           { Skalierung  }
  X:= S*BPL DIV 2;   { Startposition X }
  Y:= S*R;           { Startposition Y }
  Dy:=0;             { Geschwindigkeit in Y-Richtung }
  D2Y:=4;            { Beschleunigung in Y-Richtung  }
  Dx:=20;            { Geschwindigkeit in X-Richtung }
  READLN;
  REPEAT
    Y:= Y+Dy;
    IF Y >= S*(Ymax-2*R) THEN
    BEGIN
      Dy:= -Dy;
      Y:= S*(Ymax-2*R);
    END;
    X:= X+Dx;
    IF (X > S*(BPL-2*R)) OR (X < 0) THEN Dx:=-Dx;
    Dest.Yd:= Y DIV S;
    Dest.Xd:= X DIV S;

    Save.Xs := Dest.Xd;   { Sichere die Dest-Flche unter.. }
    Save.Ys := Dest.Yd;   { ..Verwendung des Save.FgROP..   }
    Save.Xd := 0;         { ..im Save-Bereich.              }
    Save.Yd := 0;
    BitBlT (@Save);

    Dest.Xs := BpL DIV 2 -R;   { Verknpfe Source und Pattern..}
    Dest.Ys := Ymax DIV 2 -R;  { ..unter Verwendung des ..     }
    Dest.Xp := 2*R;            { ..Dest.FgROP und bertrage .. }
    Dest.Yp := 0;              { ..nach Dest.                  }
    BitBlT (@Dest);

    WaitForSync;          { Warte auf den Strahlrcklauf       }
                          { Das ist die Anzeigezeit in Dest    }

    Save.Xs := 0;         { Restauriere die Dest-Flche..      }
    Save.Ys := 0;         { ..unter Verwendung des Save.FgROP..}
    Save.Xd := Dest.Xd;   { ..aus dem Save-Bereich.            }
    Save.Yd := Dest.Yd;
    BitBlT (@Save);
    Dy:=Dy+D2Y;
  UNTIL KEYPRESSED;
READLN;
END;

BEGIN                   { Hauptprogramm }
  ACLInit(GraphMode);
  LineDemo;		{ Fcher }
  ACLInit(GraphMode);
  FillDemo;             { Serie von gefllten Quadraten }
  ACLInit(GraphMode);
  BitBlTDemo;           { Save und Restore von Flchen }
END.
