package pong.game 
{
  import mx.core.UIComponent;
  import flash.display.Shape;
  import flash.events.Event;

  /**
   * @author hos
   */
  [Event(name="gameOver", type="flash.events.Event")]
  [Event(name="scoreChanged", type="flash.events.Event")]
  public class PongField extends UIComponent 
  {
    private var paddle: Shape;
    private const paddleWidth : int = 50;
    private const paddleHeight : int = 8;
    private var ball : Shape;
    private const ballSize : int = 8;
    private var ballDX: Number;
    private var ballDY: Number;
    private var _score: int;

    // Implement score as a property accessor to automatically dispatch
    // scoreChanged event if value is set.
    public function get score(): int 
    {
      return _score;
    }

    public function set score(n: int): void 
    {
      _score = n;
      dispatchEvent(new Event("scoreChanged"));
    }

    public override function initialize(): void 
    {
      super.initialize();
      
      with(graphics) {
        lineStyle(0, 0);
        beginFill(0xc0e0ff);
        drawRect(0, 0, width, height);
        endFill();
      }

      paddle = new Shape();
      with(paddle.graphics) {
      	beginFill(0x000000);
      	drawRect(-paddleWidth / 2, 0, paddleWidth, paddleHeight);
      	endFill();
      }
      addChild(paddle);
      paddle.x = width / 2;
      paddle.y = height - paddleHeight - 5;

      ball = new Shape();
      with(ball.graphics) {
      	beginFill(0xff6060);
      	lineStyle(2, 0xa00000);
      	drawCircle(0, 0, ballSize);
      	endFill();
      }
      addChild(ball);
      ball.x = width / 2;
      ball.y = ballSize + 5;
    }

    public function startGame(): void 
    {
      ball.x = width / 2;
      ball.y = ballSize + 5;
      ballDX = 1.5;
      ballDY = 8;
      score = 0;
      addEventListener(Event.ENTER_FRAME, nextFrame);
    }

    public function nextFrame(evt: Event): void 
    {
      paddle.x = Math.max(paddleWidth / 2,
                 Math.min(width - paddleWidth / 2, mouseX));
      
      ball.x += ballDX;
      if(ball.x < ballSize || ball.x > width - ballSize) {
        // Bounce left/right
        ballDX *= -1;
        ball.x += 2 * ballDX;
      }

      ball.y += ballDY;
      if(ball.y < ballSize) {
        // Bounce top
        ballDY *= -1;
        ball.y += 2 * ballDY;
      }

      if(ball.y > paddle.y - ballSize
           && ball.x > paddle.x - paddleWidth / 2
           && ball.x < paddle.x + paddleWidth / 2)
      {
        // Bounce paddle
        ballDY *= -1;
        ball.y += 2 * ballDY;
        score += Math.abs(ballDX) + 1; 
        ballDX += (ball.x - paddle.x) / 5.0;
      }
			
      if(ball.y > paddle.y - ballSize) {
        // Game over
        removeEventListener(Event.ENTER_FRAME, nextFrame);
        dispatchEvent(new Event("gameOver"));
      }
    }
  }
}
