#! /bin/bash
#
# Installation des Updates auf Version 3.1+ (Patch 11)
# Erstellung, 17sep00
# header geaendert, efl, 23aug01

pwd=`pwd`

# Erstens: Nameserver fuer ip99 umstellen

cd /etc/named

fullname=`hostname -d`
sed "s/IN SOA[^(]*/IN SOA       Arktur.$fullname. postmaster.$fullname. /
             s/ NS.*/ NS Arktur.$fullname./
             s/\\(IN PTR[^.]*\\).*/\\1.$fullname./
                " named.ip99.neu > named.ip99
rm -f named.ip99.neu

# Zweitens: PPP-config korrigieren
cd /etc/Systemverwaltung
co PPP-config >/dev/null 2>&1

cp PPP-config PPP-config.old

awk -F: '{  if ( $8 == "*" ) {
	print $1":"$2":"$3":"$4":"$5":"$6":"$7"::"$9
	} else {
	print $1":"$2":"$3":"$4":"$5":"$6":"$7":"$8":"$9 };
	}' PPP-config.old > PPP-config
rm -f PPP-config.old

co PPP-chat > /dev/null 2>&1
/usr/lib/ods-server/bin/PPP-config -install

cd $pwd
