#!/bin/bash
#
# userlist.cgi
# Teil des c't/ODS-Komm'server;
#
# Copyright (C) 1998 Reiner Klaproth <klaproth@online.de>
# Geaendert, efl, 17okt02
#

# zusaetzl. Sicherheitspruefungen; efl, 17okt02
echo "$QUERY_STRING" | grep '[;/&|<>`]' && exit 1

for var in $(echo "$QUERY_STRING" | sed -e "s/\&/ /g"); do
  export ${var}
done

cgiutils -ct text/html -cl de -expires now
cat << xxxEOF1xxx

<HTML>
<HEAD>
   <TITLE>Nutzerliste</TITLE>
   <META NAME="Author" CONTENT="Reiner Klaproth">
</HEAD>
<BODY background="whttxtr2.jpg">
<A HREF="index.htm">
<IMG SRC="back.gif" BORDER=0 ALT="Pfeil">  Zur&uuml;ck</A>
<H1>Nutzer-&Uuml;bersicht</H1>
<HR>
<P>
xxxEOF1xxx

if [ -z "${user}" ]; then
        # Eine neue Liste aufbauen
	cat << xxxEOF2xxx
Bitte w&auml;hlen Sie die Gruppe aus der Liste aus! 
<P>
<UL>
  <LI><A HREF="userlist.cgi?user=ALLE">ALLE</A>
xxxEOF2xxx

	x=`cat /etc/passwd | awk -F: '{
	    klasse=$5
	    sub("[^,]*", "", klasse);
	    sub("^,[    ]*", "", klasse);
	    sub("[  ]*,.*", "", klasse);
	    print  klasse 
	    }' | egrep -v '^[ "]*$' | sort | uniq
	`
	for klasse in $x ; do
	   if [ ! -z "$klasse" ]; then
	   echo "<LI><A HREF=\"userlist.cgi?user=${klasse}\">${klasse}</A>"
	   fi
	done
	echo "</UL>"

else
	# Der Username ist angegeben
	echo "Benutzer auf Arktur in "
	if [ "${user}" = "ALLE" ]; then
		echo "alphabetischer Reihenfolge: <P>"
	else
		echo "Klasse ${user} : <P>"
	fi
	cat << xxxEOF4xxx

<TABLE BORDER WIDTH=80%>
<TR>
  <TH WIDTH=15%> Kennung </TH>
  <TH WIDTH=30%> Name </TH>
  <TH WIDTH=15%> Klasse </TH>
  <TH> Homepage </TH>
</TR>
xxxEOF4xxx

	awk -F: '{
		if ( $3 > 999 )
		print $1 "," $5 }' /etc/passwd | sort > /tmp/userlist.tmp
	grep -v "^nobody" /tmp/userlist.tmp > /tmp/userlist

	if [ ! "${user}" = "ALLE" ]; then
		grep ",${user}\$" /tmp/userlist >/tmp/userlist.tmp
		rm -f /tmp/userlist
	   else
	        mv /tmp/userlist /tmp/userlist.tmp
	fi

	# Formatieren der Liste
	DOMAIN=`hostname -d`
	awk -F, -v domain="$DOMAIN" '{
		print "<TR><TD><A HREF=\"mailto:" $1 "\@" domain "\"> " $1 \
	   "</A></TD><TD>" $2 "</TD><TD>" $3 \
	   "</TD><TD><A HREF=\"http://www/\~" $1 "\"> http://www/\~" $1 \
	   "</A></TD></TR>"
	}' /tmp/userlist.tmp

	rm -f /tmp/userlist.tmp

	echo "</TABLE>"
fi

cat << xxxEOFxxx
<P><HR>Letzte &Auml;nderung: 03.10.1999

<P>&copy; 
Reiner Klaproth

</BODY>
</HTML>
xxxEOFxxx

